<?php
/**
 * 报表明细用 返回html
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: lilong<lilong@suxuantech.cn> 2020-10-27 $
 */
namespace app\crm\lib;
use think\Controller;
use think\Exception;

class Detail extends Controller{
    /**
     * 实收现金-明细-除了VIP卡和代金券之外的所有收款 - 长沙芝麻宝贝  返回HTML
     *
     * @param  start      开始时间
     * @param  end        结束时间
     * @param  shop_code  
     *
     * @return str 
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getSsxj($param=[]){
        $ssxjArr = db('c_paymentcontent')
            ->where('paytype','<>','VIP卡')->where('paytype','<>','代金券')->where('shop_code',$param['shop_code'])
            ->where('paymentdate','between',[date('Ymd',strtotime($param['start'])),date('Ymd',strtotime($param['end']))])
            ->field('orderId,paymentdate,payment_money,paytype,fundname,collectmoneynumber,shop_name,suoshu')
            ->select();
        
        $str = '<thead>';
        $str.= '    <tr>';
        $str.= '        <th width="12.5%">单号</th>';
        $str.= '        <th width="12.5%">收款日期</th>';
        $str.= '        <th width="12.5%">收款金额</th>';
        $str.= '        <th width="12.5%">支付方式</th>';
        $str.= '        <th width="12.5%">收款款项</th>';
        $str.= '        <th width="12.5%">流水号</th>';
        $str.= '        <th width="12.5%">收款店面</th>';
        $str.= '        <th width="12.5%">款项所属</th>';
        $str.= '    </tr>';
        $str.= '</thead>';
        $str.= '<tbody>';
        foreach ($ssxjArr as $key => $value) {
            $str.= '    <tr>';
            $str.= '        <td>'.$value['orderId'].'</td>';
            $str.= '        <td>'.$value['paymentdate'].'</td>';
            $str.= '        <td>'.$value['payment_money'].'</td>';
            $str.= '        <td>'.$value['paytype'].'</td>';
            $str.= '        <td>'.$value['fundname'].'</td>';
            $str.= '        <td>'.$value['collectmoneynumber'].'</td>';
            $str.= '        <td>'.$value['shop_name'].'</td>';
            $str.= '        <td>'.$value['suoshu'].'</td>';
            $str.= '    </tr>';
        }
        $str.= '</tbody>';
        return $str;
    }
    /**
     * 根据付款类型-明细 - 长沙芝麻宝贝  返回HTML
     *
     * @param  start      开始时间
     * @param  end        结束时间
     * @param  shop_code  
     * @param  paytype    
     *
     * @return str 
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getSsxjByTpye($param=[]){
        if ($param['paytype']) {
            $where['paytype'] = $param['paytype'];
        }
        $where['shop_code']  = $param['shop_code'];
        $where['paymentdate']= ['between', [date('Ymd',strtotime($param['start'])),date('Ymd',strtotime($param['end']))] ];
        $ssxjArr = db('c_paymentcontent')
            ->where($where)
            ->field('orderId,paymentdate,payment_money,paytype,fundname,collectmoneynumber,shop_name,suoshu')
            ->select();
        
        $str = '<thead>';
        $str.= '    <tr>';
        $str.= '        <th width="12.5%">单号</th>';
        $str.= '        <th width="12.5%">收款日期</th>';
        $str.= '        <th width="12.5%">收款金额</th>';
        $str.= '        <th width="12.5%">支付方式</th>';
        $str.= '        <th width="12.5%">收款款项</th>';
        $str.= '        <th width="12.5%">流水号</th>';
        $str.= '        <th width="12.5%">收款店面</th>';
        $str.= '        <th width="12.5%">款项所属</th>';
        $str.= '    </tr>';
        $str.= '</thead>';
        $str.= '<tbody>';
        foreach ($ssxjArr as $key => $value) {
            $str.= '    <tr>';
            $str.= '        <td>'.$value['orderId'].'</td>';
            $str.= '        <td>'.$value['paymentdate'].'</td>';
            $str.= '        <td>'.$value['payment_money'].'</td>';
            $str.= '        <td>'.$value['paytype'].'</td>';
            $str.= '        <td>'.$value['fundname'].'</td>';
            $str.= '        <td>'.$value['collectmoneynumber'].'</td>';
            $str.= '        <td>'.$value['shop_name'].'</td>';
            $str.= '        <td>'.$value['suoshu'].'</td>';
            $str.= '    </tr>';
        }
        $str.= '</tbody>';
        return $str;
    }
    /**
     * 预约金-明细-一销套系金额 - 长沙芝麻宝贝  返回HTML
     *
     * @param  start      开始时间
     * @param  end        结束时间
     * @param  shop_code  
     *
     * @return str 
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getOrderYx($param=[]){
        $where['o.blankoutannal'] = ['<>',1];
        $where['o.shop_code']  = $param['shop_code'];
        $where['o.targetdate']= ['between', [date('Ymd',strtotime($param['start'])),date('Ymd',strtotime($param['end']))] ];

        $dataArr = db('c_customerorder')->alias('o')
                ->join('c_customerorder_servicefc fc','o.orderId=fc.orderId','left')
                ->where('fc.currentfc','1')->where($where)
                ->field('o.orderId,o.targetdate,o.consumption_type,o.package_name,fc.allfc,o.bargain_money,o.shop_name')
                ->select();
        $str = '<thead>';
        $str.= '    <tr>';
        $str.= '        <th width="12.5%">单号</th>';
        $str.= '        <th width="12.5%">开单日期</th>';
        $str.= '        <th width="12.5%">消费类型</th>';
        $str.= '        <th width="12.5%">包套名称</th>';
        $str.= '        <th width="12.5%">总服务次数</th>';
        $str.= '        <th width="12.5%">一销金额</th>';
        $str.= '        <th width="12.5%">订单店面</th>';
        $str.= '    </tr>';
        $str.= '</thead>';
        $str.= '<tbody>';
        foreach ($dataArr as $key => $value) {
            $str.= '    <tr>';
            $str.= '        <td>'.$value['orderId'].'</td>';
            $str.= '        <td>'.$value['targetdate'].'</td>';
            $str.= '        <td>'.$value['consumption_type'].'</td>';
            $str.= '        <td>'.$value['package_name'].'</td>';
            $str.= '        <td>'.$value['allfc'].'</td>';
            $str.= '        <td>'.$value['bargain_money'].'</td>';
            $str.= '        <td>'.$value['shop_name'].'</td>';
            $str.= '    </tr>';
        }
        $str.= '</tbody>';
        return $str;
    }
    /**
     * 订单金额 套系订单- 明细 - 长沙芝麻宝贝  返回HTML
     *
     * @param  start      开始时间
     * @param  end        结束时间
     * @param  shop_code  
     * @param  allfc      总服次数
     *
     * @return str 
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getAllTxMoney($param=[]){
        $where['o.blankoutannal'] = ['<>',1];
        $where['o.shop_code']  = $param['shop_code'];
        $where['o.targetdate']= ['between', [date('Ymd',strtotime($param['start'])),date('Ymd',strtotime($param['end']))] ];
        if ($param['allfc']) {
            if ($param['allfc']==1) {
                $where['fc.allfc'] = 1;
            }else if ($param['allfc']>1) {
                $where['fc.allfc'] = ['>',1];
            }
        }
        $where['fc.currentfc'] = 1;
        $dataArr = db('c_customerorder')->alias('o')
            ->join('c_customerorder_servicefc fc','o.orderId=fc.orderId','left')
            ->where($where)
            ->field('o.orderId,o.shop_name,o.targetdate,o.total_money,o.payment_money,o.nopayment_money,fc.allfc')
            ->select();
        $str = '<thead>';
        $str.= '    <tr>';
        $str.= '        <th width="12.5%">开单日期</th>';
        $str.= '        <th width="12.5%">订单单号</th>';
        $str.= '        <th width="12.5%">订单店面</th>';
        $str.= '        <th width="12.5%">订单金额</th>';
        $str.= '        <th width="12.5%">订单已付</th>';
        $str.= '        <th width="12.5%">订单欠款</th>';
        $str.= '        <th width="12.5%">总服次</th>';
        $str.= '    </tr>';
        $str.= '</thead>';
        $str.= '<tbody>';
        foreach ($dataArr as $key => $value) {
            $str.= '    <tr>';
            $str.= '        <td>'.$value['targetdate'].'</td>';
            $str.= '        <td>'.$value['orderId'].'</td>';
            $str.= '        <td>'.$value['shop_name'].'</td>';
            $str.= '        <td>'.$value['total_money'].'</td>';
            $str.= '        <td>'.$value['payment_money'].'</td>';
            $str.= '        <td>'.$value['nopayment_money'].'</td>';
            $str.= '        <td>'.$value['allfc'].'</td>';
            $str.= '    </tr>';
        }
        $str.= '</tbody>';
        return $str;
    }
    /**
     * 订单数量 套系订单- 明细 - 长沙芝麻宝贝  返回HTML
     *
     * @param  start      开始时间
     * @param  end        结束时间
     * @param  shop_code  
     * @param  allfc      总服次数
     *
     * @return str 
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getAllTxOrder($param=[]){
        $where['o.blankoutannal'] = ['<>',1];
        $where['o.shop_code']  = $param['shop_code'];
        $where['o.targetdate']= ['between', [date('Ymd',strtotime($param['start'])),date('Ymd',strtotime($param['end']))] ];
        if ($param['allfc']) {
            if ($param['allfc']==1) {
                $where['fc.allfc'] = 1;
            }else if ($param['allfc']>1) {
                $where['fc.allfc'] = ['>',1];
            }
        }
        $where['fc.currentfc'] = 1;
        $dataArr = db('c_customerorder')->alias('o')
            ->join('c_customerorder_servicefc fc','o.orderId=fc.orderId','left')
            ->where($where)
            ->field('o.orderId,o.shop_name,o.targetdate,o.total_money,o.payment_money,o.nopayment_money,fc.allfc')
            ->select();
        $str = '<thead>';
        $str.= '    <tr>';
        $str.= '        <th width="12.5%">开单日期</th>';
        $str.= '        <th width="12.5%">订单单号</th>';
        $str.= '        <th width="12.5%">订单店面</th>';
        $str.= '        <th width="12.5%">订单金额</th>';
        $str.= '        <th width="12.5%">订单已付</th>';
        $str.= '        <th width="12.5%">订单欠款</th>';
        $str.= '        <th width="12.5%">总服次</th>';
        $str.= '    </tr>';
        $str.= '</thead>';
        $str.= '<tbody>';
        foreach ($dataArr as $key => $value) {
            $str.= '    <tr>';
            $str.= '        <td>'.$value['targetdate'].'</td>';
            $str.= '        <td>'.$value['orderId'].'</td>';
            $str.= '        <td>'.$value['shop_name'].'</td>';
            $str.= '        <td>'.$value['total_money'].'</td>';
            $str.= '        <td>'.$value['payment_money'].'</td>';
            $str.= '        <td>'.$value['nopayment_money'].'</td>';
            $str.= '        <td>'.$value['allfc'].'</td>';
            $str.= '    </tr>';
        }
        $str.= '</tbody>';
        return $str;
    }
    /**
     * 第一次服务/三宝订单金额 - 长沙芝麻宝贝  返回HTML
     *
     * @param  start      开始时间
     * @param  end        结束时间
     * @param  shop_code  
     * @param  fundname   有效状态
     *
     * @return str 
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getTaoxiMoneyByFundname($param=[]){
        $where['o.blankoutannal'] = ['<>',1];
        $where['o.shop_code']  = $param['shop_code'];
        $where['o.targetdate']= ['between', [date('Ymd',strtotime($param['start'])),date('Ymd',strtotime($param['end']))] ];
        if ($param['fundname']) {
            $where['p.fundname']  = $param['fundname'];
        }
        $dataArr = db('c_customerorder')->alias('o')
            ->join('c_paymentcontent p','o.orderId=p.orderId','left')
            ->where($where)
            ->order('p.orderId')
            ->field('o.targetdate,o.orderId,p.shop_name,p.paymentdate,p.paytype,p.fundname,p.payment_money')
            ->select();
        $str = '<thead>';
        $str.= '    <tr>';
        $str.= '        <th width="12.5%">开单日期</th>';
        $str.= '        <th width="12.5%">订单单号</th>';
        $str.= '        <th width="12.5%">收款店面</th>';
        $str.= '        <th width="12.5%">收款日期</th>';
        $str.= '        <th width="12.5%">支付方式</th>';
        $str.= '        <th width="12.5%">收款款项</th>';
        $str.= '        <th width="12.5%">收款金额</th>';
        $str.= '    </tr>';
        $str.= '</thead>';
        $str.= '<tbody>';
        foreach ($dataArr as $key => $value) {
            $str.= '    <tr>';
            $str.= '        <td>'.$value['targetdate'].'</td>';
            $str.= '        <td>'.$value['orderId'].'</td>';
            $str.= '        <td>'.$value['shop_name'].'</td>';
            $str.= '        <td>'.$value['paymentdate'].'</td>';
            $str.= '        <td>'.$value['paytype'].'</td>';
            $str.= '        <td>'.$value['fundname'].'</td>';
            $str.= '        <td>'.$value['payment_money'].'</td>';
            $str.= '    </tr>';
        }
        $str.= '</tbody>';
        return $str;
    }
    /**
     * 第一次服务/三宝订单量 - 长沙芝麻宝贝  返回HTML
     *
     * @param  start      开始时间
     * @param  end        结束时间
     * @param  shop_code  
     * @param  fundname   有效状态
     *
     * @return str 
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getTaoxiOrderByFundname($param=[]){
        $where['o.blankoutannal'] = ['<>',1];
        $where['o.shop_code']  = $param['shop_code'];
        $where['o.targetdate']= ['between', [date('Ymd',strtotime($param['start'])),date('Ymd',strtotime($param['end']))] ];
        if ($param['fundname']) {
            $where['p.fundname']  = $param['fundname'];
        }
        $dataArr = db('c_customerorder')->alias('o')
            ->join('c_paymentcontent p','o.orderId=p.orderId','left')
            ->where($where)
            ->order('p.orderId')->group('p.orderId')
            ->field('o.targetdate,o.orderId,o.consumption_type,o.package_name,o.shop_name,p.fundname')
            ->select();
        $str = '<thead>';
        $str.= '    <tr>';
        $str.= '        <th width="12.5%">开单日期</th>';
        $str.= '        <th width="12.5%">订单单号</th>';
        $str.= '        <th width="12.5%">消费类型</th>';
        $str.= '        <th width="12.5%">包套名称</th>';
        $str.= '        <th width="12.5%">订单店面</th>';
        $str.= '    </tr>';
        $str.= '</thead>';
        $str.= '<tbody>';
        foreach ($dataArr as $key => $value) {
            $str.= '    <tr>';
            $str.= '        <td>'.$value['targetdate'].'</td>';
            $str.= '        <td>'.$value['orderId'].'</td>';
            $str.= '        <td>'.$value['consumption_type'].'</td>';
            $str.= '        <td>'.$value['package_name'].'</td>';
            $str.= '        <td>'.$value['shop_name'].'</td>';
            $str.= '    </tr>';
        }
        $str.= '</tbody>';
        return $str;
    }
    /**
     * 采集量/有效量-明细-即毛客资量/有效客资量 - 长沙芝麻宝贝  返回HTML
     *
     * @param  start      开始时间
     * @param  end        结束时间
     * @param  shop_code  
     * @param  is_valid   有效状态
     *
     * @return str 
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getCusinfo($param=[]){
        $whereCus['is_status'] = 1;
        $whereCus['c_from'] = 1;
        $whereCus['add_shop_code'] = $param['shop_code'];
        $whereCus['dj_day'] = ['between',[date('Y-m-d 00:00:00',strtotime($param['start'])),date('Y-m-d 23:59:59',strtotime($param['end']))]];
        if ($param['is_valid']) {
            $whereCus['is_valid'] = $param['is_valid'];
        }

        $dataArr = db('crm_c_customerinfo')->where($whereCus)->field('id,dj_day,is_valid,customer_name,customer_tel,customer_wechat,customer_channel,dj_staff,sales_staff,add_shop_name')->order('id asc')->select();

        $str = '<thead>';
        $str.= '    <tr>';
        $str.= '        <th width="10%">ID</th>';
        $str.= '        <th width="10%">登记时间</th>';
        $str.= '        <th width="10%">有效状态</th>';
        $str.= '        <th width="10%">妈妈姓名</th>';
        $str.= '        <th width="10%">妈妈手机</th>';
        $str.= '        <th width="10%">妈妈微信</th>';
        $str.= '        <th width="10%">渠道名称</th>';
        $str.= '        <th width="10%">录入人</th>';
        $str.= '        <th width="10%">追踪人</th>';
        $str.= '        <th width="10%">登记店面</th>';
        $str.= '    </tr>';
        $str.= '</thead>';
        $str.= '<tbody>';
        foreach ($dataArr as $key => $value) {
            $str.= '<tr>';
            $str.= '    <td>'.$value['id'].'</td>';
            $str.= '    <td>'.$value['dj_day'].'</td>';
            $str.= '    <td>'.getIsValidAttr($value['is_valid']).'</td>';
            $str.= '    <td>'.$value['customer_name'].'</td>';
            $str.= '    <td>'.$value['customer_tel'].'</td>';
            $str.= '    <td>'.$value['customer_wechat'].'</td>';
            $str.= '    <td>'.$value['customer_channel'].'</td>';
            $str.= '    <td>'.$value['dj_staff'].'</td>';
            $str.= '    <td>'.$value['sales_staff'].'</td>';
            $str.= '    <td>'.$value['add_shop_name'].'</td>';
            $str.= '</tr>';
        }
        $str.= '</tbody>';
        return $str;
    }
    /**
     * 预约上门-明细-预约/入户/拍摄- 长沙芝麻宝贝  返回HTML
     *
     * @param  start      开始时间
     * @param  end        结束时间
     * @param  shop_code  
     * @param  status   有效状态
     *
     * @return str 
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getCusYysm($param=[]){
        $whereYy['c.is_status'] = 1;
        $whereYy['c.c_from'] = 1;
        $whereYy['l.pc_shop_code'] = $param['shop_code'];
        $whereYy['l.pc_type'] = 2;
        $whereYy['l.is_delete'] = 2;
        $whereYy['l.is_gq'] = 1;
        $whereYy['l.pc_time'] = ['between',[$param['start'],$param['end']]];
        if ($param['status']) {
            $whereYy['l.status'] = ['in',$param['status']];
        }

        $dataArr = db('crm_c_customerinfo')->alias('c')
            ->join('crm_l_pc_log l','c.id=l.cid','left')
            ->join('c_customerorder o','o.crm_visit_id=l.id','left')
            ->where($whereYy)
            ->field('c.id,c.customer_name,c.customer_tel,c.customer_wechat,l.pc_time,l.smgroup,l.status,l.pc_shop_name,o.orderId')
            ->select();
        $str = '<thead>';
        $str.= '    <tr>';
        $str.= '        <th width="10%">ID</th>';
        $str.= '        <th width="10%">妈妈姓名</th>';
        $str.= '        <th width="10%">妈妈手机</th>';
        $str.= '        <th width="10%">妈妈微信</th>';
        $str.= '        <th width="10%">上门时间</th>';
        $str.= '        <th width="10%">上门小组</th>';
        $str.= '        <th width="10%">上门状态</th>';
        $str.= '        <th width="10%">上门店面</th>';
        $str.= '        <th width="10%">订单单号</th>';
        $str.= '    </tr>';
        $str.= '</thead>';
        $str.= '<tbody>';
        foreach ($dataArr as $key => $value) {
            $str.= '<tr>';
            $str.= '    <td>'.$value['id'].'</td>';
            $str.= '    <td>'.$value['customer_name'].'</td>';
            $str.= '    <td>'.$value['customer_tel'].'</td>';
            $str.= '    <td>'.$value['customer_wechat'].'</td>';
            $str.= '    <td>'.$value['pc_time'].'</td>';
            $str.= '    <td>'.$value['smgroup'].'</td>';

            if ($value['status']==1) {
                $str.= '    <td>'.未上门.'</td>';
            }else if ($value['status']==2) {
                $str.= '    <td>'.已订单.'</td>';
            }else if ($value['status']==3) {
                $str.= '    <td>'.未订单.'</td>';
            }else if ($value['status']==4) {
                $str.= '    <td>'.已取消.'</td>';
            }else{
                $str.= '    <td>'.未上门.'</td>';
            }
            $str.= '    <td>'.$value['pc_shop_name'].'</td>';
            $str.= '    <td>'.$value['orderId'].'</td>';
            $str.= '</tr>';
        }
        $str.= '</tbody>';
        return $str;
    }
    /**
     * 门店到件-明细-（产品整件完成）- 长沙芝麻宝贝  返回HTML
     *
     * @param  start      开始时间
     * @param  end        结束时间
     * @param  shop_code  
     *
     * @return str 
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getMddj($param=[]){
        $dataArr = db('c_customerorder_servicefc')->alias('fc')
            ->join('c_customersp s','fc.orderId = s.orderId AND fc.currentfc = s.currentfc','left')
            ->where('fc.whethercantakedate','between',[date('Y-m-d',strtotime($param['start'])),date('Y-m-d',strtotime($param['end']))])
            ->where('s.shop_code',$param['shop_code'])
            ->field('DISTINCT fc.orderId,fc.whethercantakedate,s.currentfc,take_takaddress')
            ->select();

        $str = '<thead>';
        $str.= '    <tr>';
        $str.= '        <th width="10%">订单单号</th>';
        $str.= '        <th width="10%">整件完成日期</th>';
        $str.= '        <th width="10%">服次</th>';
        $str.= '        <th width="10%">取件点</th>';
        $str.= '    </tr>';
        $str.= '</thead>';
        $str.= '<tbody>';
        foreach ($dataArr as $key => $value) {
            $str.= '<tr>';
            $str.= '    <td>'.$value['orderId'].'</td>';
            $str.= '    <td>'.$value['whethercantakedate'].'</td>';
            $str.= '    <td>'.$value['currentfc'].'</td>';
            $str.= '    <td>'.$value['take_takaddress'].'</td>';
            $str.= '</tr>';
        }
        $str.= '</tbody>';
        return $str;
    }
    /**
     * 取件-明细-（取件完成）- 长沙芝麻宝贝  返回HTML
     *
     * @param  start      开始时间
     * @param  end        结束时间
     * @param  shop_code  
     *
     * @return str 
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getQj($param=[]){
        $dataArr = db('c_customerorder_servicefc')->alias('fc')
            ->join('c_customersp s','fc.orderId = s.orderId AND fc.currentfc = s.currentfc','left')
            ->where('fc.alreadytakedate','between',[date('Y-m-d',strtotime($param['start'])),date('Y-m-d',strtotime($param['end']))])
            ->where('s.shop_code',$param['shop_code'])
            ->field('DISTINCT fc.orderId,fc.alreadytakedate,s.currentfc,fc.qj_renname')
            ->select();

        $str = '<thead>';
        $str.= '    <tr>';
        $str.= '        <th width="10%">订单单号</th>';
        $str.= '        <th width="10%">取件完成日期</th>';
        $str.= '        <th width="10%">服次</th>';
        $str.= '        <th width="10%">取件人</th>';
        $str.= '    </tr>';
        $str.= '</thead>';
        $str.= '<tbody>';
        foreach ($dataArr as $key => $value) {
            $str.= '<tr>';
            $str.= '    <td>'.$value['orderId'].'</td>';
            $str.= '    <td>'.$value['alreadytakedate'].'</td>';
            $str.= '    <td>'.$value['currentfc'].'</td>';
            $str.= '    <td>'.$value['qj_renname'].'</td>';
            $str.= '</tr>';
        }
        $str.= '</tbody>';
        return $str;
    }
    /**
     * 误件-明细- 长沙芝麻宝贝  返回HTML
     *
     * @param  start      开始时间
     * @param  end        结束时间
     * @param  shop_code  
     *
     * @return str 
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getWj($param=[]){
        $dataArr = db('c_customerorder_servicefc')->alias('fc')
            ->join('c_customersp s','fc.orderId = s.orderId AND fc.currentfc = s.currentfc','left')
            ->where('fc.whethercantakedate','')
            ->where('fc.qj_getDate','between',[$param['start'],$param['end']])
            ->where('s.shop_code',$param['shop_code'])
            ->field('DISTINCT fc.orderId,fc.qj_getDate,s.currentfc')
            ->select();

        $str = '<thead>';
        $str.= '    <tr>';
        $str.= '        <th width="10%">订单单号</th>';
        $str.= '        <th width="10%">日期</th>';
        $str.= '        <th width="10%">服次</th>';
        $str.= '    </tr>';
        $str.= '</thead>';
        $str.= '<tbody>';
        foreach ($dataArr as $key => $value) {
            $str.= '<tr>';
            $str.= '    <td>'.$value['orderId'].'</td>';
            $str.= '    <td>'.$value['alreadytakedate'].'</td>';
            $str.= '    <td>'.$value['currentfc'].'</td>';
            $str.= '</tr>';
        }
        $str.= '</tbody>';
        return $str;
    }
    /**
     * 返工-明细- 长沙芝麻宝贝  返回HTML
     *
     * @param  start      开始时间
     * @param  end        结束时间
     * @param  shop_code  
     *
     * @return str 
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getFg($param=[]){
        $dataArr = db('c_foundryprojecttable')->alias('tb')
            ->join('c_customersp s','tb.orderId = s.orderId AND tb.fc = s.currentfc','left')
            ->where('tb.Reject',1)
            ->where('tb.returndate','between',[$param['start'],$param['end']])
            ->where('s.shop_code',$param['shop_code'])
            ->field('DISTINCT s.orderId,tb.returndate,s.currentfc,tb.dutier')
            ->select();
        // echo db()->getLastSql();die;
        $str = '<thead>';
        $str.= '    <tr>';
        $str.= '        <th width="10%">订单单号</th>';
        $str.= '        <th width="10%">返工日期</th>';
        $str.= '        <th width="10%">服次</th>';
        $str.= '        <th width="10%">责任人</th>';
        $str.= '    </tr>';
        $str.= '</thead>';
        $str.= '<tbody>';
        foreach ($dataArr as $key => $value) {
            $str.= '<tr>';
            $str.= '    <td>'.$value['orderId'].'</td>';
            $str.= '    <td>'.$value['returndate'].'</td>';
            $str.= '    <td>'.$value['currentfc'].'</td>';
            $str.= '    <td>'.$value['dutier'].'</td>';
            $str.= '</tr>';
        }
        $str.= '</tbody>';
        return $str;
    }
    /**
     * 完相数据 摄影组数-明细 长沙芝麻宝贝  返回HTML
     *
     * @param  start      开始时间
     * @param  end        结束时间
     * @param  shop_code  
     *
     * @return str 
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getCusYyGroup($param=[]){
        $whereYy['c.is_status'] = 1;
        $whereYy['c.c_from'] = 1;
        $whereYy['l.pc_shop_code'] = $param['shop_code'];
        $whereYy['l.pc_type'] = 2;
        $whereYy['l.is_delete'] = 2;
        $whereYy['l.is_gq'] = 1;
        $whereYy['l.pc_time'] = ['between',[$param['start'],$param['end']]];

        $dataArr = db('crm_c_customerinfo')->alias('c')
            ->join('crm_l_pc_log l','c.id=l.cid','left')
            ->where($whereYy)
            ->field('l.pc_time,l.smgroup,l.cameraman_name,l.tutor_name,l.pc_shop_name')
            ->group('l.smgroup')
            ->select();
        $str = '<thead>';
        $str.= '    <tr>';
        $str.= '        <th width="10%">上门时间</th>';
        $str.= '        <th width="10%">上门小组</th>';
        $str.= '        <th width="10%">摄影师</th>';
        $str.= '        <th width="10%">导师</th>';
        $str.= '        <th width="10%">上门店面</th>';
        $str.= '    </tr>';
        $str.= '</thead>';
        $str.= '<tbody>';
        foreach ($dataArr as $key => $value) {
            $str.= '<tr>';
            $str.= '    <td>'.$value['pc_time'].'</td>';
            $str.= '    <td>'.$value['smgroup'].'</td>';
            $str.= '    <td>'.$value['cameraman_name'].'</td>';
            $str.= '    <td>'.$value['tutor_name'].'</td>';
            $str.= '    <td>'.$value['pc_shop_name'].'</td>';
            $str.= '</tr>';
        }
        $str.= '</tbody>';
        return $str;
    }

    /**
     * 马克叔叔 客服报表 订单金额明细  返回HTML
     * @return str 
     * @author lilong<lilong@suxuantech.cn>
     */
    public function mkssGetTotal($where=[]){
        $start = $where['start'];
        $end = $where['end'];
        unset($where['start'],$where['end'],$where['day_type']);
        $where['c.is_status'] = 1;
        $where['c.c_from'] = 1;
        
        $dataArr = db('crm_c_customerinfo')->alias('c')
            ->join('c_customerorder o','c.id=o.crm_customer_id','left')
            ->join('c_consumptioncontent cc','cc.orderId=o.orderId and cc.id is not null','left')
            ->where($where)->where('cc.sorting',0)->where('cc.servicenumber','1')
            // ->where('c.'.$day_type,'between',[$start,$end])
            ->where('o.targetdate','between',[date('Ymd',strtotime($start)),date('Ymd',strtotime($end))])
            ->where('o.crm_customer_id','not null')->where('o.blankoutannal',0)
            ->field('o.orderId,c.consultation_type,o.targetdate,o.storeconsuitant2,o.total_money,o.bargain_money')->select();

        $str = '<thead>';
        $str.= '    <tr>';
        $str.= '        <th width="10%">订单单号</th>';
        $str.= '        <th width="10%">消费类型</th>';
        $str.= '        <th width="10%">开单日期</th>';
        $str.= '        <th width="10%">网销门市</th>';
        $str.= '        <th width="10%">订单金额</th>';
        $str.= '    </tr>';
        $str.= '</thead>';
        $str.= '<tbody>';
        foreach ($dataArr as $key => $value) {
            $str.= '<tr>';
            $str.= '    <td>'.$value['orderId'].'</td>';
            $str.= '    <td>'.$value['consultation_type'].'</td>';
            $str.= '    <td>'.$value['targetdate'].'</td>';
            $str.= '    <td>'.$value['storeconsuitant2'].'</td>';
            $str.= '    <td>'.$value['bargain_money'].'</td>';
            $str.= '</tr>';
        }
        $str.= '</tbody>';
        return $str;
    }
    /**
     * 马克叔叔 客服报表 实收金额明细  返回HTML
     * @return str 
     * @author lilong<lilong@suxuantech.cn>
     */
    public function mkssGetFact($where=[]){
        $start = $where['start'];
        $end = $where['end'];
        unset($where['start'],$where['end'],$where['day_type']);
        $where['c.is_status'] = 1;
        $where['c.c_from'] = 1;
        
        $dataArr = db('crm_c_customerinfo')->alias('c')
            ->join('c_customerorder o','c.id=o.crm_customer_id','left')
            ->join('c_paymentcontent p','p.orderId=o.orderId','left')
            ->where($where)
            // ->where('c.'.$day_type,'between',[$start,$end])
            ->where('p.paymentdate','between',[date('Ymd',strtotime($start)),date('Ymd',strtotime($end))])
            ->where('o.crm_customer_id','not null')->where('o.blankoutannal',0)
            ->where('p.suoshu','in',['前期款','前期补款'])
            ->order('o.orderId')
            ->field('o.orderId,c.consultation_type,p.paymentdate,o.storeconsuitant2,p.payment_money')->select();

        $str = '<thead>';
        $str.= '    <tr>';
        $str.= '        <th width="10%">订单单号</th>';
        $str.= '        <th width="10%">消费类型</th>';
        $str.= '        <th width="10%">收款日期</th>';
        $str.= '        <th width="10%">网销门市</th>';
        $str.= '        <th width="10%">收款金额</th>';
        $str.= '    </tr>';
        $str.= '</thead>';
        $str.= '<tbody>';
        foreach ($dataArr as $key => $value) {
            $str.= '<tr>';
            $str.= '    <td>'.$value['orderId'].'</td>';
            $str.= '    <td>'.$value['consultation_type'].'</td>';
            $str.= '    <td>'.$value['paymentdate'].'</td>';
            $str.= '    <td>'.$value['storeconsuitant2'].'</td>';
            $str.= '    <td>'.$value['payment_money'].'</td>';
            $str.= '</tr>';
        }
        $str.= '</tbody>';
        return $str;
    }

    /**
     * 马克叔叔 电商员工业绩表  返回HTML
     * @return str 
     * @author lilong<lilong@suxuantech.cn>
     */
    public function mkssGetOrderInfos($where=[]){
        $start = $where['start'];
        $end = $where['end'];
        $type = $where['type'];
        unset($where['start'],$where['end'],$where['type']);
        $where['c.is_status'] = 1;
        $where['c.c_from'] = 1;
        
        $tempArr = db('crm_c_customerinfo')->alias('c')
            ->join('c_customerorder o','c.id=o.crm_customer_id','left')
            ->join('c_customerorder_servicefc fc', 'o.orderId=fc.orderId', 'left')
            ->where($where)->where('fc.currentfc',1)
            ->where('o.targetdate','between',[date('Ymd',strtotime($start)),date('Ymd',strtotime($end))])
            ->where('o.crm_customer_id','not null')
            ->where('o.blankoutannal',0)
            ->field('o.orderId,o.targetdate,c.consultation_type,o.bargain_money,fc.allfc')
            ->select();
        $dataArr = [];
        if ($type=='yeqq') {
            foreach ($tempArr as $key => $v) {
                if ($v['consultation_type']!='新生儿' && $v['consultation_type']!='满月照' && $v['package_name']!='网络团购套系') {
                    $dataArr[] = $v;
                }
            }
        }else if ($type=='xse') {
            foreach ($tempArr as $key => $v) {
                if ( ($v['consultation_type']=='新生儿' || $v['consultation_type']=='满月照') && $v['package_name']=='网络团购套系') {
                    $dataArr[] = $v;
                }
            }
        }
        $str = '<thead>';
        $str.= '    <tr>';
        $str.= '        <th width="10%">订单单号</th>';
        $str.= '        <th width="10%">消费类型</th>';
        $str.= '        <th width="10%">订单日期</th>';
        $str.= '        <th width="10%">订单金额</th>';
        $str.= '        <th width="10%">服次</th>';
        $str.= '    </tr>';
        $str.= '</thead>';
        $str.= '<tbody>';
        foreach ($dataArr as $key => $value) {
            $str.= '<tr>';
            $str.= '    <td>'.$value['orderId'].'</td>';
            $str.= '    <td>'.$value['consultation_type'].'</td>';
            $str.= '    <td>'.$value['paymentdate'].'</td>';
            $str.= '    <td>'.$value['storeconsuitant2'].'</td>';
            $str.= '    <td>'.$value['payment_money'].'</td>';
            $str.= '</tr>';
        }
        $str.= '</tbody>';
        return $str;
    }
    
}