<?php
/**
 * 催拍
 * CRM的基本功能实现，如客资录入，客资查询等。
 * 所有业务的真正实现全在lib目录下建controller并且访问modle等，供controller层调用
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: wangyining<wangyining@suxuantech.cn> 2020-12-26 $
 */
namespace app\crm\lib;
use think\Cache;
use think\Controller;
use PHPExcel_IOFactory;
use Excel5;
use PHPExcel;
use app\common\lib\redisQueue;
use think\Exception;

class Urgephoto extends Controller{

    protected $ym1 = 30;
    protected $ym2 = 124;
    protected $cs1 = 20;
    protected $cs2 = 20;
    protected $my1 = 20;
    protected $my2 = 10;
    protected $bt1 = 100;
    protected $bt2 = 90;
    protected $bs1 = 190;
    protected $bs2 = 180;
    protected $zs1 = 370;
    protected $zs2 = 360;
    protected $dulisb = '';
    protected $zuizongfenpeistaff = '';

    function _initialize() {
        $set = db('s_globalset')->find();
        if(!empty($set['ym1']) && $set['ym1'] > 0){
            $this->ym1 = $set['ym1'];
        }

        if(!empty($set['ym2']) && $set['ym2'] > 0){
            $this->ym2 = $set['ym2'];
        }

        if(!empty($set['cs1']) && $set['cs1'] > 0){
            $this->cs1 = $set['cs1'];
        }

        if(!empty($set['cs2']) && $set['cs2'] > 0){
            $this->cs2 = $set['cs2'];
        }

        if(!empty($set['my1']) && $set['my1'] > 0){
            $this->my1 = $set['my1'];
        }

        if(!empty($set['my2']) && $set['my2'] > 0){
            $this->my2 = $set['my2'];
        }

        if(!empty($set['bt1']) && $set['bt1'] > 0){
            $this->bt1 = $set['bt1'];
        }

        if(!empty($set['bt2']) && $set['bt2'] > 0){
            $this->bt2 = $set['bt2'];
        }

        if(!empty($set['bs1']) && $set['bs1'] > 0){
            $this->bs1 = $set['bs1'];
        }

        if(!empty($set['bs2']) && $set['bs2'] > 0){
            $this->bs2 = $set['bs2'];
        }

        if(!empty($set['zs1']) && $set['zs1'] > 0){
            $this->zs1 = $set['zs1'];
        }

        if(!empty($set['zs2']) && $set['zs2'] > 0){
            $this->zs2 = $set['zs2'];
        }

        $this->dulisb = $set['dulisb'];
        $this->zuizongfenpeistaff = $set['zuizongfenpeistaff'];

    }



    public function getCustomerData($params){

        $params['start_date'] = date('Ymd',strtotime($params['dateStar']));
        $params['end_date'] = date('Ymd',strtotime($params['dateEnd']));
        $where = '';

        if($params['shop_codes']){
            $str = '';
            $shop_arr = explode(',',$params['shop_codes']);
            foreach($shop_arr as $k => $v){
                $str .= ",'" . $v. "'";
            }
            $params['shop_codes'] = trim($str,',');
            //print_r($params['shop_codes']);die;
        }

        if($params['shop_type'] && !empty($params['shop_codes'])){
            switch ($params['shop_type'])
            {
                case "订单店面":
                    $where .= " and b.shop_code in (" .$params['shop_codes']. ")  ";
                    break;
                case "拍照店面":
                    $where .= " and p.shop_code in (" .$params['shop_codes']. ")  ";
                    break;
            }
        }


        //三宝
        $ordertype = "";
        $whereordertype = "";
        if ($this->dulisb == 1) {
            $sanbao_type = db('s_sanbaotype')->select();

            foreach($sanbao_type as $k => $v){
                    $ordertype .= ",'" . $v["sanbaotypename"]. "'";
            }
            $ordertype = trim($ordertype,',');

            if ($ordertype && !empty($ordertype)) {
                $whereordertype = " and b.consumption_type not in (" .$ordertype. ")";
            }
        }

        $whereordertype .= " and b.consumption_type not in ('游泳','理发')";

        //总完成日
        if($params['allfinishfate'] == 1){
            $where .= " and  b.allfinishfate <> ''";
        }else{
            $where .= " and  b.allfinishfate = ''";
        }

        //所有服务次，勾选了则查所有服次，否则，只查最后一次
        if ($params['allfc'] != 1)
        {
            $where .= " and fc.islastfc=1 ";
        }

        if($params['btn'] && $params['btn'] != ''){
            $res = $this->getSqlByType($params);
        }else{
            $res = $this->getSqlByInput($params);
        }

        $where .= $res;

        $sql = "select '' as ss, b.cp_zhousui,b.cp_yunfu,b.cp_chusheng,b.cp_manyue,b.cp_baitian,b.cp_bansui, a.customerid, a.mname,a.mphone,a.wname,a.wphone,a.viptype,a.vipnum, a.cplastday,a.cpstaffname,a.mbirthdate,a.wbirthdate,a.weddingdate,a.area,a.weddingdate,a.email,a.address ,a.vippercents,a.bbithdate,a.bbname,a.bbsex,a.bb_hospital,a.mwechat,a.wwechat,a.mqq,a.wqq,a.cssname,
     if(datediff(CURDATE(), bbithdate)>365,CONCAT_WS('',floor(datediff(CURDATE(), bbithdate)/365), '岁'),CONCAT_WS('',datediff(CURDATE(), bbithdate),
                if(IFNULL(datediff(CURDATE(), bbithdate),'')='','','天'))) bbage, b.tuiguangstaff,a.bbname2,a.bbithdate2,a.bbsex2,
                if(datediff(CURDATE(), bbithdate2)>365,CONCAT_WS('',floor(datediff(CURDATE(), bbithdate2)/365), '岁'),CONCAT_WS('',datediff(CURDATE(), bbithdate2),
                if(IFNULL(datediff(CURDATE(), bbithdate2),'')='','','天'))) bbage2,
b.orderId,b.consumption_type,b.package_name,b.storeconsuitant1 ,b.storeconsuitant2,b.acceptor_address,b.total_money,b.payment_money,b.nopayment_money,b.nextphotodate,b.packyouxiaodate,
a.yc_day,
a.bbithdate,
b.targetdate,
b.allfinishfate,
b.payoervedate,
b.allfinishfate,
p.photodate,p.todian,
s.selectday,
date_format(s.select_recordtime,'%Y%m%d') as select_recordtime ,
date_format(s.select_designtime,'%Y%m%d') as select_designtime ,

s.kanbanriqi,
date_format(fc.whethercantakedate,'%Y%m%d') as whethercantakedate ,
date_format(fc.alreadytakedate,'%Y%m%d') as alreadytakedate ,
date_format(fc.qj_getDate,'%Y%m%d') as qj_getDate ,

fc.senddate,
fc.shoulddate,
fc.backdate,
fc.fcoverday,

case p.photostate when 2 then '已拍完' else '' end as photostate,
case s.sptstate when  1 then  '已选完' else '' end  as sptstate,
case s.kanbanstate  when  1 then  '已看完' else '' end  as kanbanstate,

b.supplementary_money,b.bargain_money,b.shop_name,case  b.blankoutannal when 1 then '作废' else'' end AS blankoutannal1,
p.cameraman,p.currentfc,p.phototype,p.shop_name as photoshop_name,p.id as photoid,
s.selectman, s.shop_name as spshop_name,s.select_record,s.select_design,fc.take_takaddress,p.id as photoid,p.yxphotodaystart,p.yxphotodayend,p.callphotomark,p.communication_date,p.communication_state,p.communication_man,p.photonote,
vip.cardid,vip.cardmoney,vip.cardtype,b.fenpeiyaoyueday,b.fenpeiyaoyuestaff,b.yaoyuepaixiangstaff,a.address_sheng,a.address_shi,a.address_qu,a.address,b.yxpackage_name,a.customer_channel,
(select count(id) from c_customerteltracking ct where a.wphone=ct.telphone ) as dfcount,t.teyday,t.telstaffname,t.telway,p.paikongstaff from c_customerinfo a  join c_customerorder b on a.customerid = b.customerid
 join c_customerorder_servicefc fc on b.orderId=fc.orderId
 join c_customerphoto p on b.orderId=p.orderId and fc.currentfc=p.currentfc and p.islast=1
 join c_customersp s on b.orderId=s.orderId and fc.currentfc=s.currentfc
 left join c_vipcardinfo vip on a.vipnum=vip.cardid
 left join (select * from c_customerteltracking where id in ( select max(id) from c_customerteltracking  group by telphone)) t on a.wphone=t.telphone
 where  blankoutannal<>1 and  fc.fcstate=0  " .$where. $whereordertype;

        $list = db()->query($sql);
        return ['code'=>0,'data'=>$list,'count'=>count($list),'sql'=>$sql];

    }

    public function getSqlByInput($params){
        $where = '';

        if (!empty($params['date_type']) && !empty($params['start_date']) && !empty($params['end_date'])) {
            switch ($params['date_type']) {
                case "生日日期":
                    $where .= " and (( right(a.bbithdate,4)   between '" .$params['start_date']. "' and '" .$params['end_date']. "' ) or ( right(a.bbithdate2,4)   between '" .$params['start_date']. "' and '" .$params['end_date']. "' ))";
                    break;
                case "精准生日":
                    $where .= " and (( a.bbithdate between '" .$params['start_date']. "' and '" .$params['end_date']. "' ) or ( a.bbithdate2 between '" .$params['start_date']. "' and '" .$params['end_date']. "' ))";
                    break;

                case "预产日期":
                    $where .= " and ( a.yc_day between '" .$params['start_date']. "' and '" .$params['end_date']. "' )";
                    break;

                case "订单日期":
                    $where .= " and ( b.targetdate between '" .$params['start_date']. "' and '" .$params['end_date']. "' )";
                    break;

                case "有效日期":
                    $where .= " and ( b.packyouxiaodate between '" .$params['start_date']. "' and '" .$params['end_date']. "' )";
                    break;

                case "拍照日期":
                    $where .= " and ( p.photodate between '" .$params['start_date']. "' and '" .$params['end_date']. "' )";
                    break;
                case "选片日期":
                    $where .= " and ( s.selectday between '" .$params['start_date']. "' and '" .$params['end_date']. "' )";
                    break;
                case "锁定日期":
                    $where .= " and ( s.kanbanriqi between '" .$params['start_date']. "' and '" .$params['end_date']. "' )";
                    break;
                case "取件日期":
                    $where .= " and ( fc.qj_getDate between '" .$params['start_date']. "' and '" .$params['end_date']. "' )";
                    break;

                case "再约日期":
                    $where .= " and ( b.nextphotodate between '" .$params['start_date']. "' and '" .$params['end_date']. "' )";
                    break;

                case "分配日期":
                    $where .= " and ( b.fenpeiyaoyueday between '" .$params['start_date']. "' and '" .$params['end_date']. "' )";
                    break;
            }
        }

        //消费类型
        if($params['consumptiontype']){
            $where .= " and ( b.consumption_type ='" .$params['consumptiontype']. "')";
        }

        //渠道来源
        if($params['channel']){
            $where .= " and a.customer_channel='" .$params['channel']. "'";
        }

        //套系金额
        if($params['tx_money1'] > 0 && $params['tx_money2'] > 0){
            $where .= " and ( b.total_money between '" .$params['tx_money1']. "' and  '" .$params['tx_money2']. "') ";
        }

        //会员余额
        if($params['vip_money1'] > 0 && $params['vip_money2'] > 0){
            $where .= " and ( vip.cardmoney between '" .$params['vip_money1']. "' and  '" .$params['vip_money2']. "') ";
        }

        //妈妈手机号
        if($params['wphone']){
            $where .= " and a.wphone='" .$params['wphone']. "'";
        }

        //拍摄状态
        if($params['photostate']||$params['photostate'] === '0'){
            $where .= "and p.photostate='" .$params['photostate']. "'";
        }

        //推广人
        if ($params['tuiguangren']) {
            $where .= " and b.tuiguangstaff='" .$params['tuiguangren']. "' ";
        }

        //分配邀约人
        if ($params['fenpeiyaoyuestaff']) {
            $where .= " and b.fenpeiyaoyuestaff='" .$params['fenpeiyaoyuestaff']. "' ";
        }

        //排控人
        if ($params['paikongstaff']) {
            $where .= " and p.paikongstaff='" .$params['paikongstaff']. "' ";
        }

        //邀约人
        if ($this->zuizongfenpeistaff) {
            $oneself = db('c_functiontable')
                ->where(['gangwei_code'=>session('main_position_code')])
                ->where('FIND_IN_SET(62,popedom19)')
                ->find();
            if ($oneself) {
                $where .= " and b.yaoyuepaixiangstaff='" .session('staff_name'). "'";
            }else{
                if ($params['yaoyueren']) {
                    $where .= " and b.yaoyuepaixiangstaff='" .$params['yaoyueren']. "'";
                }
            }
        }else{
            if ($params['yaoyueren']) {
                $where .= " and b.yaoyuepaixiangstaff='" .$params['yaoyueren']. "'";
            }
        }

        //到店状态
        if($params['todian']){
            $where .= " and p.todian='" .$params['todian']. "'";
        }

        return $where;

    }


    public function getSqlByType($params){

        $getData = $this->getSearchDate($params['btn']);
        $cm_day1 = $getData['day1'];
        $cm_day2 = $getData['day2'];

        $ww = '';

        //未排拍照日
        if($params['btn'] == 'wp_photo'){

            //$ww = " a.shop_code in (" .$params['shop_codes']. ") and ";
            $where = " and  (fc.fcstate<>1) and  a.wphone <> ''and  b.targetdate between '" .$cm_day1. "' AND  '" .$cm_day2. "' and (p.photodate ='' or p.photodate  is null )" .
            " and a.wphone not in ( select  distinct a.wphone from  c_customerinfo a " .
            @" join c_customerorder_servicefc sf  on sf.customerid = a.customerid join c_customerphoto sp on sp.orderId = sf.orderId and sp.currentfc = sf.currentfc" .
            "  where  " .$ww. " (sp.photodate between  '" .$cm_day1. "' AND  '" .$cm_day2. "')) ";

        }elseif($params['btn'] == 'wp_xp'){
            //未排选片

            $where = " and  (fc.fcstate<>1) and  p.photodate between '" .$cm_day1. "' AND  '" .$cm_day2. "' " .
                " and (s.selectday='' or s.selectday is null)";

        }elseif($params['btn'] == 'wp_kb'){
            //未拍看版

            $where = " and  (fc.fcstate<>1) and  p.photodate between '" .$cm_day1. "' AND  '" .$cm_day2. "' " .
                " and (s.kanbanriqi='' or s.kanbanriqi is null)";
        }elseif($params['btn'] == 'yunma'){
            //孕妈催拍

            $where = " and (a.yc_day between '" .$cm_day1. "' and '" .$cm_day2. "') and (photodate='' or photodate is null)  ";
        }elseif($params['btn'] == 'birth'){
            //出生催拍

            $where = " and (a.yc_day between '" .$cm_day1. "' and '" .$cm_day2. "') and (photodate='' or photodate is null) ";
        }elseif($params['btn'] == 'month'){
            //满月催拍

            $where = " and (a.yc_day between '" .$cm_day1. "' and '" . $cm_day2
                . "' or a.bbithdate between '" .$cm_day1. "' and '" . $cm_day2
                . "' or a.bbithdate2 between '" .$cm_day1. "' and '" . $cm_day2
                . "') and (photodate='' or photodate is null) ";

        }elseif($params['btn'] == 'hundred'){
            //百天

            $where = " and (a.yc_day between '" .$cm_day1. "' and '" .$cm_day2. "' or a.bbithdate between  '" .$cm_day1. "' and '" .$cm_day2. "' or a.bbithdate2 between  '" .$cm_day1. "' and '" .$cm_day2. "'  ) and (photodate='' or photodate is null) ";
        }elseif($params['btn'] == 'half'){
            //半岁

            $where = " and (a.yc_day between '" .$cm_day1. "' and '" .$cm_day2. "' or a.bbithdate between  '" .$cm_day1. "' and '" .$cm_day2. "' or a.bbithdate2 between  '" .$cm_day1. "' and '" .$cm_day2. "'  ) and (photodate='' or photodate is null) ";

        }elseif($params['btn'] == 'one_full_year'){
            //周岁

            $where = " and (a.yc_day between '" .$cm_day1. "' and '" .$cm_day2. "' or a.bbithdate between  '" .$cm_day1. "' and '" .$cm_day2. "' or a.bbithdate2 between  '" .$cm_day1. "' and '" .$cm_day2. "'  ) and (photodate='' or photodate is null) ";

        }elseif($params['btn'] == 'week_valid'){

            //一周内有效

            //$ww = " b.shop_code in (" .$params['shop_codes']. ") and ";
            $where = " and  (fc.fcstate<>1)  and  a.wphone <> ''and  b.packyouxiaodate between '" .date('Y-m-d 00:00:00',strtotime($cm_day1)). "' AND  '" .date('Y-m-d 00:00:00',strtotime($cm_day2)). "' and (p.photodate ='' or p.photodate  is null )" .
                " and a.wphone not in ( select  distinct a.wphone from  c_customerinfo a " .
                @" join c_customerorder_servicefc sf  on sf.customerid = a.customerid
    join c_customerphoto sp on sp.orderId = sf.orderId and sp.currentfc = sf.currentfc" .
                "  where  " .$ww. " (sp.photodate between  '" .$cm_day1. "' AND  '" .$cm_day2. "')) ";

        }elseif($params['btn'] == 'three_months_valid'){
            //三个月内有效

            $yesa = 12 - date('m');
            $cm_day3 = date("Ymd",strtotime("-$yesa day"));
            $cm_day4 = date('Ymd');

            //$ww = " b.shop_code in (" .$params['shop_codes']. ") and ";

            $where = " and  (fc.fcstate<>1) and  a.wphone <> ''and  b.packyouxiaodate between '" .date("Y-m-d 00:00:00",strtotime($cm_day1)). "' AND  '" .date("Y-m-d 00:00:00",strtotime($cm_day2)). "' and (p.photodate ='' or p.photodate  is null )" .
                " and a.wphone not in ( select  distinct a.wphone from  c_customerinfo a " .
                @" join c_customerorder_servicefc sf  on sf.customerid = a.customerid
    join c_customerphoto sp on sp.orderId = sf.orderId and sp.currentfc = sf.currentfc" .
                "  where  " .$ww. " (sp.photodate between  '" .$cm_day3. "' AND  '" .$cm_day4. "')) ";
        }

        return $where;

    }

    /*
     * 获取各个按钮所查询的时间范围
     */
    public function getSearchDate($type){
        if($type == 'wp_photo' || $type == 'wp_xp' || $type == 'wp_kb'){
            $months = 12 - date('m');
            $cm_day1 = date('Ymd',strtotime(" -$months month"));
            $cm_day2 = date('Ymd');
        }elseif($type == 'yunma'){
            $cm_day1 = date("Ymd",strtotime("+$this->ym1 day"));
            $cm_day2 = date("Ymd",strtotime("+$this->ym2 day"));
        }elseif($type == 'birth'){
            //有问题 erp里第二个日期是当天
            $cm_day1 = date("Ymd",strtotime("-$this->cs1 day"));
            $cm_day2 = date("Ymd",strtotime("-$this->cs2 day"));
            //$cm_day2 = date("Ymd");
        }elseif($type == 'month'){
            $cm_day1 = date("Ymd",strtotime("-$this->my1 day"));
            $cm_day2 = date("Ymd",strtotime("-$this->my2 day"));
        }elseif($type == 'hundred'){
            $cm_day1 = date("Ymd",strtotime("-$this->bt1 day"));
            $cm_day2 = date("Ymd",strtotime("-$this->bt2 day"));
        }elseif($type == 'half'){
            $cm_day1 = date("Ymd",strtotime("-$this->bs1 day"));
            $cm_day2 = date("Ymd",strtotime("-$this->bs2 day"));
        }elseif($type == 'one_full_year'){
            $cm_day1 = date("Ymd",strtotime("- $this->zs1 day"));
            $cm_day2 = date("Ymd",strtotime("-$this->zs2 day"));
        }elseif($type == 'week_valid'){
            $cm_day1 = date("Ymd",strtotime("-7 day"));
            $cm_day2 = date('Ymd');
        }elseif($type == 'three_months_valid'){
            $cm_day1 = date("Ymd",strtotime("-93 day"));
            $cm_day2 = date('Ymd');
        }

        return ['day1'=>$cm_day1,'day2'=>$cm_day2];
    }

    /*
     * 催拍电访
     */
    public function dianfang($params){

        $today = date('Ymd');

        $tel = $params['telphone']?$params['telphone']:$params['wphone'];

        db()->startTrans();
        try{
            $log = [
                'starttime' => $params['dianfang_start']?strtotime($params['dianfang_start']):0,//通话开始时间
                'endtime' => $params['dianfang_end']?strtotime($params['dianfang_end']):0,//通话结束时间
                'telphone' => $tel,//通话电话
                'telguid' => $tel?trim(trim(getGuid(),'{'),'}'):0,
                'orderId' => $params['orderId'],
                'customerid' => $params['customerid'],
                'teyday' => $today,
                'nexttelcalltime' => $params['nexttelcalltime'],
                'yxphotoday1' => $params['yxphotoday1'],
                'yxphotoday2' => $params['yxphotoday2'],
                'telcallremark' => $params['telcallremark'],
                'telstaffname' => session('staff_name'),
            ];

            db('c_customerteltracking')->insert($log);


            $photo = [
                'photonote' => $params['photoremark'],
                'communication_state' => $params['communication_state'],
                'communication_man' => session('staff_name'),
                'communication_date' => $today,
                'yxphotodaystart' => $params['yxphotoday1'] ? date('Ymd',strtotime($params['yxphotoday1'])) : '',
                'yxphotodayend' => $params['yxphotoday2'] ? date('Ymd',strtotime($params['yxphotoday2'])) : '',
                'yxphotoweek' => $params['week'],
                'callphotomark' => $params['telcallremark'],
            ];
            db('c_customerphoto')->where('id',$params['photoid'])->update($photo);

            $order = [
                'order_type_name' => $params['mark_name'],//追踪标记
                'nextphotodate' => date('Ymd',strtotime($params['nexttelcalltime'])),//下次电访日期
            ];
            db('c_customerorder')->where(['orderId'=>$params['orderId']])->update($order);

            $c_info = [
                'cplastday' => $today,
                'cpstaffname' => session('staff_name'),
            ];
            db('c_customerinfo')->where('customerid',$params['customerid'])->update($c_info);

            db()->commit();
            return ['code'=>200,'msg'=>'操作成功'];

        }catch (\Exception $e){

            db()->rollback();
            return ['code'=>204,'msg'=>$e->getMessage()];
        }

    }

    /*
     * 分配催拍人
     */
   public function fpUrgeStaff($params){

       if(!$params['choose_staff']){
           return ['code'=>201,'msg'=>'请选择催拍人！'];
       }

        $data = [];
        $today = date('Ymd');

        db()->startTrans();
        try{
            foreach($params['choose_data'] as $k => $v){

                $data[] = [
                    'orderid' => $v['orderId'],
                    'fenpeiyaoyueday' => $today,
                    'fenpeiyaoyuestaff' => session('staff_name'),
                    'yaoyuepaixiangstaff' => $params['choose_staff'],
                    'createtime' => date('Y-m-d H:i:s'),
                ];

                $update = [
                    'fenpeiyaoyueday' => $today,
                    'yaoyuepaixiangstaff' => $params['choose_staff'],
                ];
                db('c_customerorder')->where('orderId',$v['orderId'])->update($update);
            }

            db('c_customerfenpeipaixianginfo')->insertAll($data);

            db()->commit();
            return ['code'=>200,'msg'=>'分配成功！'];
        }catch (\Exception $e){

            db()->rollback();
            return ['code'=>203,'msg'=>'分配失败！'.$e->getMessage()];
        }




   }

    /*
    * 查询可分配催拍的人
    */
   public function getUrgeStaff($params){

       $start_date = date('Ymd',strtotime($params['get_start_date']));
       $end_date = date('Ymd',strtotime($params['get_end_date']));

       //催拍人（催拍）
       $mc = new \app\common\lib\mcInterface();
       $shops = $mc->getWorkShop(['staff_id'=>session('staff_id')]);
       $shop_codes = implode(',',array_column($shops,'shop_code'));
       $staff = $mc->getStaffsByShopWorkType(['shop_code'=>$shop_codes,'work_type'=>40]);

       $arr = [];
       foreach($staff as $k => $v){
           $fp = db('c_customerorder')
               ->where('fenpeiyaoyueday',['between',[$start_date,$end_date]])
               ->where('yaoyuepaixiangstaff',$v['staffname'])
               ->value('count(orderId)');

           $yy = db('c_customerorder')
               ->alias('o')
               ->join('c_customerphoto p','o.orderId = p.orderId','left')
               ->where('o.fenpeiyaoyueday',['between',[$start_date,$end_date]])
               ->where('o.yaoyuepaixiangstaff',$v['staffname'])
               ->where('p.paikongstaff',$v['staffname'])
               ->value('count(o.orderId)');


           $arr[] = [
               'staff_name' => $v['staffname'],
               'fp_num' => $fp > 0 ? $fp : 0,
               'yy_num' => $yy > 0 ? $yy : 0,
           ];
       }

       return ['code'=>0,'data'=>$arr,'count'=>count($arr)];

   }


    /*
     * 分配邀约人
     */
    public function getFenpeiyaoyuestaff($params=''){

       $res = db('c_customerorder')->where('fenpeiyaoyuestaff is not null and fenpeiyaoyuestaff <> ""')->group('fenpeiyaoyuestaff')->column("fenpeiyaoyuestaff");
       return $res;
    }


    /*
     * 分配邀约人
     */
    public function getPaikongstaff($params=''){

       $res = db('c_customerphoto')->where('paikongstaff is not null and paikongstaff <> ""')->group('paikongstaff')->column("paikongstaff");
       return $res;
    }

}