<?php
/**
 * 报表实现类 网销追踪时段统计
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: wangzhenya 2019-11-26 $
 */
namespace app\crm\lib\report;
use app\crm\lib\Report;
use think\Controller;
use think\image\Exception;

class Customer_sales_hour_data extends Report {

    private $level=1;
    private $type=3;
    private $code='code1568182474';

    public function getLevel(){
        return $this->level;

    }
    public function getType(){
        return $this->type;
    }
    public function getCode(){
        return $this->code;
    }
    public function data()
    {
        set_time_limit(0);
        $data = input();
        $det = db('crm_s_report_form')->alias('f')->join('crm_s_report_detail d','d.form_id=f.id')->where('d.id',$data['did'])->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name,f.report_name')->find();
        //可操作店
        if($data['shop_code']){
            $shop_code = $data['shop_code'];
        }elseif($det['shop_code']){
            $shop_code = $det['shop_code'];
        }else{
            $shop_code = session('shop_code');
        }
        if(empty($shop_code)){
            return array('code'=>100,'msg'=>'报表配置有误');
        }
        $start = $data['start'] ? date('Y-m-d', strtotime($data['start'])) : date('Y-m-d 00:00:00');
        $end =  $data['end'] ? date('Y-m-d 23:59:59', strtotime($data['end'])) : date('Y-m-d 23:59:59');
        $start_erp = date('Ymd', strtotime($data['start']));
        $end_erp = date('Ymd', strtotime($data['end']));

        $where['c_from'] = 1;
        $where['is_status'] = 1;
        $where['l.shop_code'] = $shop_code;
        if($data['staff_id']){
            $where['c.sales_staff_id'] = intval($data['staff_id']);
            $staff = controller('crm/Customer','lib')->get_staff_list(['id'=>intval($data['staff_id'])]);
        }else{
            //店下人员
            $staff = getStaffsByWorkType(['shop_code'=>$shop_code,'work_type'=>21]);
            $staffIds = array_column($staff,'id');
            $where['c.sales_staff_id'] = ['in',$staffIds];
        }

        $tel= db('crm_c_customerinfo')->alias('c')->join('crm_c_salestrackinginfo s','c.id=customer_id','left')->join('crm_l_pc_log l','l.cid=c.id','INNER')->join('c_customerorder o','l.id=o.crm_visit_id','INNER')
            ->where($where)
            ->where('dj_day','between',[$start,$end])
            ->group('time')
            ->field('DATE_FORMAT(c.dj_day,"%H:00:00")as time,count(s.id)num')
            ->select();
        // echo db()->getLastSql();die;
        $duration = db('crm_c_customerinfo')->alias('c')->join('crm_c_salestrackinginfo s','c.id=customer_id','left')->join('crm_l_pc_log l','l.cid=c.id','left')->join('c_customerorder o','l.id=o.crm_visit_id','LEFT')
            ->where($where)
            ->where('s.sales_day','between',[$start,$end])
            ->group('time')
            ->field('DATE_FORMAT(s.sales_day,"%H:00:00")as time,sum(UNIX_TIMESTAMP(s.tel_endtime)-UNIX_TIMESTAMP(s.tel_starttime))num','')
            ->select();

        $sm= db('crm_c_customerinfo')->alias('c')->join('crm_l_pc_log l','l.cid=c.id','left')
            ->where($where)
            ->where('dj_day','between',[$start,$end])
            ->group('time')
            ->field('DATE_FORMAT(c.dj_day,"%H:00:00")as time,count(l.id)num')
            ->select();
        $order= db('crm_c_customerinfo')->alias('c')->join('crm_l_pc_log l','l.cid=c.id','left')->join('c_customerorder o','l.id=o.crm_visit_id','LEFT')
            ->where($where)
            ->where('l.status','in',['2,3'])
            ->where('o.create_time','between',[$start_erp,$end_erp])
            ->group('time')
            ->field('DATE_FORMAT(o.create_time,"%H:00:00")as time,count(l.id)num')
            ->select();
        $tel = array_column($tel,'num','time');
        $duration = array_column($duration,'num','time');
        $sm = array_column($sm,'num','time');
        $order = array_column($order,'num','time');
        $time = [
          '00:00:00', '01:00:00', '02:00:00', '03:00:00', '04:00:00', '05:00:00', '06:00:00', '07:00:00', '08:00:00', '09:00:00', '10:00:00', '11:00:00', '12:00:00', '13:00:00', '14:00:00', '15:00:00', '16:00:00', '17:00:00', '18:00:00', '19:00:00', '20:00:00', '21:00:00', '22:00:00', '23:00:00', '24:00:00',
        ];
        $return = [];
        $total['time'] = '总计';
        foreach($time as $k=>$v){
            $arr = [];
            $arr['time'] = $v;
            $arr['tel'] = $tel[$v] ? $tel[$v] : '';
            $arr['duration'] = $duration[$v] ? intval($duration[$v]/60).":".($duration[$v]-60*intval($duration[$v]/60)) : '';
            $arr['sm'] = $sm[$v] ? $sm[$v] : '';
            $arr['order'] = $order[$v] ? $order[$v] : '';
            array_push($return,$arr);

            $total['tel'] += $tel[$v];
            $total['duration'] += $duration[$v];
            $total['sm'] += $sm[$v];
            $total['order'] += $order[$v];
        }
        array_push($return,$total);

        $returnData['code'] = 0;
        $returnData['msg'] = '';
        $returnData['count'] = count($return);
        $returnData['data'] = $return;
        return json($returnData);
    }

    public function show(){
        $code = $this->getCode();
        /*
        $did = strtolower(input('param.did'));
        $info = db('crm_s_report_form')->alias('f')->join('crm_s_report_detail d','d.form_id=f.id')->where('d.id',$did)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();*/
        $menu_code = strtolower(input('param.menu_code'));
        $info = db('crm_s_report_form')->alias('f')->join('crm_s_report_detail d','d.form_id=f.id','left')->where('f.code',$menu_code)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();

        $display = APP_PATH.'crm'.DS.'view'.DS.'report'.DS.strtolower($info['report_class_name']).'.html';
        $title = db('crm_s_report_form')->where('code', $code)->value('report_name');
        $shop= controller('crm/Customer','lib')->get_shop(['shop_code'=>$info['shop_code']]);
        $staff = getStaffsByWorkType(['shop_code'=>$info['shop_code'],'work_type'=>21]);
        $this->assign('shop_code', $info['shop_code']);
        $this->assign('staff', $staff);
        $this->assign('title', $shop[0]['shop_name'].'-'.$title);
        $this->assign('did', $info['id']);
        return $this->fetch($display);
    }

}