<?php
/**
 * 报表实现类 上门信息统计
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: wangzhenya 2019-09-10 $
 */
namespace app\crm\lib\report;
use app\crm\lib\Report;
use think\Controller;
use think\image\Exception;

class Xaf_sm_data extends Report {

    private $level=1;
    private $type=1;
    private $code='code1578017344';

    public function getLevel(){
        return $this->level;

    }
    public function getType(){
        return $this->type;
    }
    public function getCode(){
        return $this->code;
    }
    public function data()
    {
        set_time_limit(0);
        $data = input();
        $det = db('crm_s_report_form')->alias('f')->join('crm_s_report_detail d','d.form_id=f.id')->where('d.id',$data['did'])->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name,f.report_name')->find();
        $shop_code = $det['shop_code'];
        if(empty($shop_code)){
            return array('code'=>100,'msg'=>'报表配置有误');
        }
        $where['c_from'] = 1;
        $where['is_status'] = 1;
        $where['l.pc_type'] = 2;
        if($data['pc_time']){
            $pc_time = explode(' - ',$data['pc_time']);
            $pc_time_start = $pc_time[0];
            $pc_time_end = $pc_time[1];
            $where['pc_time'] = ['between',[$pc_time_start,$pc_time_end]];
        }
        if($data['bb_birthday']){
            $bb_birthday = explode(' - ',$data['bb_birthday']);
            $bb_birthday_start = $bb_birthday[0];
            $bb_birthday_end = $bb_birthday[1];
            $where['baby_birthday'] = ['between',[$bb_birthday_start,$bb_birthday_end]];
        }
        if(!$data['pc_time'] && !$data['bb_birthday']){
            return array('code'=>99,'msg'=>'上门日期和宝宝生日必须选一项');
        }
        $info= db('crm_c_customerinfo')->alias('c')->join('crm_l_pc_log l','c.id=l.cid','left')
            ->where($where)
            ->field('l.pc_time,l.status,c.customer_name,c.customer_tel,c.customer_address,c.mate_tel,c.baby_birthday,c.baby_address,c.sales_staff,c.customer_channel,l.smgroup')
            ->order('l.pc_time desc')
            ->select();


        $return = [];
        foreach($info as $k=>$v){
            $arr = [];
            $arr['pc_time'] = $v['pc_time'];
            if($v['status'] == 2){
                $arr['status'] = '已成交';
            }elseif($v['status'] == 3){
                $arr['status'] = '未成交';
            }elseif($v['status'] == 3){
                $arr['status'] = '已取消';
            }else{
                $arr['status'] = '未上门';
            }
            $arr['customer_name'] = $v['customer_name'] ? $v['customer_name'] : '';
            $arr['customer_tel'] = $v['customer_tel'] ? $v['customer_tel'] : '';
            $arr['customer_address'] = $v['customer_address'] ? $v['customer_address'] : '';
            $arr['mate_tel'] = $v['mate_tel'] ? $v['mate_tel'] : '';
            $arr['baby_birthday'] = $v['baby_birthday'] ? date('Y-m-d',strtotime($v['baby_birthday'])) : '';
            $arr['baby_address'] = $v['baby_address'] ? $v['baby_address'] : '';
            $arr['sales_staff'] = $v['sales_staff'] ? $v['sales_staff'] : '';
            $arr['customer_channel'] = $v['customer_channel'] ? $v['customer_channel'] : '';
            $arr['smgroup'] = $v['smgroup'] ? $v['smgroup'] : '';
            array_push($return,$arr);
        }

        $returnData['code'] = 0;
        $returnData['msg'] = '';
        $returnData['count'] = count($return);
        $returnData['data'] = $return;
        return json($returnData);
    }

    public function show(){
        $code = $this->getCode();
        /*
        $did = strtolower(input('param.did'));
        $info = db('crm_s_report_form')->alias('f')->join('crm_s_report_detail d','d.form_id=f.id')->where('d.id',$did)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();*/
        $menu_code = strtolower(input('param.menu_code'));
        $info = db('crm_s_report_form')->alias('f')->join('crm_s_report_detail d','d.form_id=f.id','left')->where('f.code',$menu_code)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();

        $display = APP_PATH.'crm'.DS.'view'.DS.'report'.DS.strtolower($info['report_class_name']).'.html';
        $title = db('crm_s_report_form')->where('code', $code)->value('report_name');
        $shop= controller('crm/Customer','lib')->get_shop(['shop_code'=>$info['shop_code']]);
        $staff = controller('crm/Customer','lib')->get_staff_lists(['shop_code'=>$info['shop_code']]);
        $this->assign('shop_code', $info['shop_code']);
        $this->assign('staff', $staff);
        $this->assign('title', $shop[0]['shop_name'].'-'.$title);
        $this->assign('did', $info['id']);
        return $this->fetch($display);
    }

}