<?php
/**
 *  优尼可定制 呼叫中心统计
 * *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: yuanweibo 2021-07-30 $
 */
namespace app\crm\lib\report;
use app\crm\lib\Report;
use think\Controller;
use think\image\Exception;

class Ynk_call_center extends Report {

	private $level=1;
	private $type=1;
	private $code='code1627624068';

	public function getLevel(){
		return $this->level;
	}
	public function getType(){
		return $this->type;
	}
	public function getCode(){
		return $this->code;
	}
	public function data(){
		$param = input();

        $info = db('crm_s_report_form')->where('code', $param['code'])->field('code,report_name,report_class_name')->find();
        if (!$info || empty($param['code'])) {
            $this->error('没有此报表。');
        }
        $shop_code = $param['shop_code'] ? $param['shop_code'] : session('shop_code');

		$page = input("page")?input("page"):1;
		$limit = input("limit")?input("limit"):20;
		//-------查询条件---------//
		//时间 
		$start = $param['start'] ? $param['start'] : date('Y-m-d 00:00:00',strtotime());
		$end = $param['end'] ? $param['end'] : date('Y-m-d 23:59:59',strtotime());

		$starts= strtotime($start);
		$ends= strtotime($end);

		// 客服
		if ($param['sales_staff']) {
			$kefu = db('crm_s_call_man')->field("user,staff_name")->where('shop_code',$shop_code)->where('staff_id','in',$param['sales_staff'])->select();
		}else{
			$kefu = db('crm_s_call_man')->field("user,staff_name")->where('shop_code',$shop_code)->select();
		}
		
		$kf_user = [];
		$user = [];
		if (count($kefu) >0) {
			foreach ($kefu as $key => $value) {
				$kf_user[] = $value['user'];
				$user[$value['user']] = $value['staff_name'];
			}

			// $return['kf_user']  = $kf_user;
			$info = db('osip_table_calllog','db_call')
	            ->where("uufrom|uuto",'in',$kf_user)
	            ->where('uubegintime','between',[$starts,$ends])
	            ->order('uuid desc')
	            ->select();
	        $sql = db('osip_table_calllog','db_call')->getlastsql();

	        $infoData = '';
	        foreach ($info as $key => $value) {

				if (in_array($value['uufrom'], $kf_user)) {
                    $infoData[$value['uufrom']]['zx'] = $value['uufrom'];
                    $infoData[$value['uufrom']]['name'] = $user[$value['uufrom']];

                    //外呼量
                    $infoData[$value['uufrom']]['whl'] += 1;

                	//外呼总时长
                	$infoData[$value['uufrom']]['wh_zsc'] += $value['uufinishedtime'] > 0 ? $value['uufinishedtime'] - $value['uubegintime'] : 0;

                    if ($value['uuestablishedtime'] > 0) {
                    	//外呼接通量
                    	$infoData[$value['uufrom']]['whjtl'] += 1;
                    	//拨号等待总时长
                    	$infoData[$value['uufrom']]['dd_z'] += $value['uuestablishedtime'] - $value['uubegintime'];
                    }else{
                    	//拨号等待总时长
                    	$infoData[$value['uufrom']]['dd_z'] += $value['uufinishedtime'] > 0 ? $value['uufinishedtime'] - $value['uubegintime'] : 0;
                    }

                }
                if (in_array($value['uuto'], $kf_user)) {
                    $infoData[$value['uuto']]['zx'] = $value['uuto'];
                    $infoData[$value['uuto']]['name'] = $user[$value['uuto']];

                    //进线量
                    $infoData[$value['uuto']]['jxl'] += 1;

                	//进线总时长
                	$infoData[$value['uuto']]['jx_zsc'] += $value['uufinishedtime'] > 0 ? $value['uufinishedtime'] - $value['uubegintime'] : 0;

                    if ($value['uuestablishedtime'] > 0) {
                    	//进线接通量
                    	$infoData[$value['uuto']]['jxjtl'] += 1;
                    }

                }
	        }

            foreach ($infoData as $key => $value) {
                //外呼平均时长
                $infoData[$key]['wh_pjsc'] = SToHis(intval($value['wh_zsc']/$value['whl']));
                //拨号等待平均时长
                $infoData[$key]['dd_pjsc'] = SToHis(intval($value['dd_z']/$value['whl']));
                //进线平均时长
                $infoData[$key]['jx_pjsc'] = SToHis(intval($value['jx_zsc']/$value['jxjtl']));
                //总通话时长
                $infoData[$key]['zsc'] = SToHis($value['wh_zsc'] + $value['jx_zsc']);

            	$infoData[$key]['wh_zsc'] = SToHis($value['wh_zsc']);
            	$infoData[$key]['dd_z'] = SToHis($value['dd_z']);
            	$infoData[$key]['jx_zsc'] = SToHis($value['jx_zsc']);
            }

            $return['sql']  = $sql;
			$return['msg']  = '';
			$return['code'] = 0;
			$return['data'] = $infoData;
			$return['count']= count($infoCount);
			return json($return);
		}else{
			$return['msg']  = '没有坐席';
			$return['code'] = 0;
			$return['data'] = [];
			$return['count']= 0;
			return json($return);
        }

	}

	public function show(){
        $menu_code = strtolower(input('param.menu_code'));
        $info = db('crm_s_report_form')->where('code', $menu_code)->field('code,report_name,report_class_name')->find();
        if (!$info) {
            $this->error('没有此报表。');
        }

        $shop_code = session('shop_code');
        $shop= controller('crm/Customer','lib')->get_shop(['shop_code'=>$shop_code]);
		/*/ 事业部下所有可操作店
		$shopParam['staff_id'] = session('staff_id');
		$shopParam['brandclass_id'] = session('brandclass_id');
		$myShops = getShops($shopParam);
		$this->assign("myShops", $myShops);*/
		// $myShops = db('c_customerorder')->field("shop_code,shop_name")->GROUP('shop_code')->select();
		// $this->assign("myShops", $myShops);
		// var_dump($myShops);die;
	   	// 来源渠道
		$channel = getChannelJson($shop_code);
		$this->assign("channel", json_encode($channel));

		// $mc = new \app\common\lib\mcInterface();
		// // 部门
		// $departmentList = $mc->getDepartmentByShopcode($shop_code);
		// foreach ($departmentList as $key => $value) {
		// 	if ($value['department_name']==session('department_name')) {
		// 		$departmentList[$key]['selected']=1;
		// 		$departmentId = $value['id'];
		// 	}
		// }
		// $this->assign("departmentList",$departmentList);
		// $staffParam['department_id'] = $departmentId;
		// $staffParam['get_main'] = 1;
		// 客服
		$kefu = db('crm_s_call_man')->field("staff_id,staff_name")->where('shop_code',$shop_code)->select();
		$this->assign("kefu", $kefu);

		$display = APP_PATH.'crm'.DS.'view'.DS.'report'.DS.strtolower($info['report_class_name']).'.html';

        $this->assign('title', $shop[0]['shop_name'].'-'.$info['report_name']);
        $this->assign('code', $info['code']);
		$this->assign('start', date('Y-m-01 00:00:00'));
		$this->assign('end', date('Y-m-d 23:59:59'));
		return $this->fetch($display);
	}
}