<?php
return $sqlUpdate = [
    /*一个版本开始：*/
    '1.1.0' => [
        [ /*第一个改动*/
            'type' => 'table', /*操作类型：table表示添加一个表，column表示添加一个字段*/
            'name' => 's_test2', /*如果是添加一个表，此处为表名，如果是添加一个字段，此处是要哪个表添加字段*/
            'fields' => [ /*此值为系统要操作的字段列表，如果为多个表添加字段，外层写多个数组，如果是一个表添加多个字段，此字段写成数组形式即可*/
                ['name' => 'id', 'type' => 'int', 'default' => 'AUTO_INCREMENT', 'is_null' => false],
                /*name 字段名，type字段类型 default默认值，可以不设如果需要自增，设为：AUTO_INCREMENT is_null 是否可以为NULL primary 是否为主键，默认AUTO_INCREMENT为主键*/
                ['name' => 'field_1', 'type' => 'varchar', 'length' => 50, 'default' => '', 'is_null' => true],
                /*如果是字符串类型字段，需要指明长度*/
                ['type' => 'key', 'name' => 'key1', 'fields' => ['field_1', 'id']],
                /*如果要加索引，设定一个字段名为索引的字段名，type为key ,fields内为此索引的字段数组。*/
            ],
        ],
        [ /*第二个改动*/
            'type' => 'column',
            'name' => 'crm_app_version',
            'fields' => [
                ['name' => 'up_sql', 'type' => 'text', 'is_null' => true],
            ],
        ],
        [
            'type' => 'data',
            'name' => 'crm_api_list',
            'unique'=>'hash',
            'fields' => [
                'field' => ['apiName', 'apiUrl', 'app_id', 'hash', 'accessToken', 'needLogin', 'status', 'method', 'info'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['校验进客信息是否算网销订单，', 'Customer/preCheckCustomer', 5, '465abc8e0e679', 0, 0, 1, 1,'校验进客信息是否算网销订单，包括传CRM客资编号的也有可能不算网销订单'],
                ],
            ],
        ],
        [
            'type' => 'data',
            'name' => 'crm_api_fields',
            'fields' => [
                'field' => ['fieldName', 'hash','dataType', 'isMust', 'range', 'info', 'type', 'showName'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['brandclass_id', '465abc8e0e679', 1, 0, '事业部id', '事业部id', 0,'brandclass_id'],
                    ['customer_wechat', '465abc8e0e679', 2, 0, '微信号', '微信号', 0,'customer_wechat'],
                ],
            ],
        ],
        [
            //增加客资订单表唯一索引
            'type'=>'sql',
            'sql'=>'ALTER TABLE `crm_c_customer_order` ADD UNIQUE INDEX `order_number` (`customer_id`, `order_sn`);',
        ],
    ],
    '1.1.1' => [
        [ /*排程设定增加排程类型，用于区分到店拍还是体验拍*/
            'type' => 'column',
            'name' => 'crm_l_pc_setting_log',
            'fields' => [
                //1:到店拍；2：体验拍
                ['name' => 'pc_type', 'type' => 'tinyint','length'=>1,'default'=>1, 'is_null' => false],
            ],
        ],
        [
            'type' => 'data',
            'unique'=>'menu_code',//排重列，会按此列进行排重，如果重复，则跳过对应的数据行
            'name' => 'crm_s_menu',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['上门拍排程设定', 6, 'menu1557049289', '/crm/Setting/SmpcSet', 1, 100],
                ],
            ],
        ],
    ],
    '1.1.7' => [
        [
            'type'  => 'data',
            'name'  => 'crm_api_list',
            'unique'=> 'hash',
            'fields' => [
                'field' => ['apiName', 'apiUrl', 'app_id', 'hash', 'accessToken', 'needLogin', 'status', 'method', 'info'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['根据提报店，获取对应渠道', 'Customer/getChannelByAddshopcode', 4, '5d64ca8e6f540', 0, 0, 1, 1,'根据提报店，获取对应渠道'],
                ],
            ],
        ],
        [
            'type' => 'data',
            'name' => 'crm_api_fields',
            'fields' => [
                'field' => ['fieldName', 'hash','dataType', 'isMust', 'range', 'info', 'type', 'showName'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['add_shop_code', '5d64ca8e6f540', 2, 1, '提报店shop_code', '提报店shop_code', 0,'add_shop_code'],
                ],
            ],
        ],
    ],
    '1.1.8' => [
        [
            'type' => 'data',
            'name' => 'crm_s_menu',
            'unique'=>'id',
            'fields' => [
                'field' => ['id','menu_name', 'fid', 'menu_code', 'menu_url', 'menu_icon', 'status', 'sort'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['2053','查看统计报表', 5, 'menu1568895548', '', '', 0, 0],
                    ['2054','落地页设置', 0, 'menu1567476313', '', 'fa-reorder',1, 9],
                    ['2055','落地页列表', 2054, 'menu1567737010', '/advert/Advert/index', '',1, 1],
                    ['2056','落地页渠道', 2054, 'menu1567737059', '/advert/Advert/advertChannel', '',1, 2],
                ],
            ],
        ],
        // 广告落地页列表
        [ 
            'type'=>'sql',
            'sql' =>"CREATE TABLE IF NOT EXISTS `crm_s_advert_list` (
                  `id` int(11) NOT NULL AUTO_INCREMENT,
                  `advert_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '表单编号',
                  `name` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '表单名称',
                  `request_num` int(11) DEFAULT '0' COMMENT '提交客资数量',
                  `repeat_num` int(11) DEFAULT '0' COMMENT '与客资系统重复的数量',
                  `click_num` int(11) DEFAULT '0' COMMENT '点击数',
                  `add_shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
                  `add_shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
                  `template` text COLLATE utf8_unicode_ci COMMENT '组件',
                  `style` text COLLATE utf8_unicode_ci COMMENT '样式',
                  `openfeedbackpwd` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '是否为必选项',
                  `submitonce` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '只提交一次',
                  `onlywechat` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '仅微信提交',
                  `consumption_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '消费类型',
                  `js_customer_service` text COLLATE utf8_unicode_ci COMMENT '客服代码js',
                  `btn_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '按钮名称',
                  `create_time` datetime DEFAULT NULL,
                  `update_time` datetime DEFAULT NULL,
                  PRIMARY KEY (`id`),
                  UNIQUE KEY `advert_code` (`advert_code`) USING BTREE,
                  KEY `add_shop_code` (`add_shop_code`) USING BTREE
                ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='广告落地页列表';
            ",
        ],
        // 活动落地页提交客资表
        [ 
            'type' => 'sql', 
            'sql' => "CREATE TABLE IF NOT EXISTS `crm_s_advert_customer` (
                  `id` int(11) NOT NULL AUTO_INCREMENT,
                  `advert_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '表单编号',
                  `customer_channel` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
                  `customer_channel_id` int(11) DEFAULT NULL,
                  `consultation_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '消费类型',
                  `customer_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
                  `customer_tel` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
                  `customer_wechat` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
                  `add_shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
                  `add_shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
                  `brandclass_id` int(11) DEFAULT NULL,
                  `brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
                  `form_content` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '咨询内容',
                  `ip` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
                  `from_address` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '来源地址',
                  `create_time` datetime DEFAULT NULL,
                  `is_in` tinyint(4) DEFAULT NULL COMMENT '是否存在于客资',
                  `c_id` int(11) DEFAULT NULL COMMENT '客资id',
                  PRIMARY KEY (`id`),
                  KEY `advert_code` (`advert_code`) USING BTREE
                ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='活动落地页提交客资表';
            ", 
        ],
        // 落地页渠道设定
        [
            'type' => 'sql', 
            'sql' => "CREATE TABLE IF NOT EXISTS `crm_s_advert_channel` (
                  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
                  `channel_id` int(11) NOT NULL,
                  `channel_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
                  `sort` tinyint(4) NOT NULL DEFAULT '1' COMMENT '排序',
                  `shop_code` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
                  `shop_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
                  `staff_id` int(11) DEFAULT NULL,
                  `staff_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
                  `brandclass_id` int(11) DEFAULT NULL,
                  `brandclass` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
                  `create_time` datetime DEFAULT NULL,
                  PRIMARY KEY (`id`)
                ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
            ",
        ]
    ],
    '1.1.9'=>[
        [
            'type' => 'data',
            'name' => 'crm_s_menu',
            'unique'=>'menu_code',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['批量待定', '61','menu1571722592', '/crm/Customer/customerMoreDd', 1, 0],
                ],
            ],
        ],
    ],
    '1.1.11' => [
        [
            'type' => 'column',
            'name' => 'crm_l_pc_log',
            'fields' => [
                //上门类型:理发，拍摄，售后，其他
                ['name' => 'sm_type', 'type' => 'varchar','length'=>50,'default'=>null, 'is_null' => true],
            ],
        ],
        [
            'type' => 'column',
            'name' => 'crm_c_excel_import_data',
            'fields' => [
                //渠道绑定标记，存储标记信息
                ['name' => 'sign_id', 'type' => 'int','length'=>11,'default'=>null, 'is_null' => true],
                ['name' => 'sign_name', 'type' => 'varchar','length'=>50,'default'=>null, 'is_null' => true],
                ['name' => 'sign_time', 'type' => 'datetime','default'=>null, 'is_null' => true],
            ],
        ],
    ],
    '1.1.12'=>[
        [
            'type' => 'data',
            'name' => 'crm_s_menu',
            'unique'=>'menu_code',
            'fields' => [
                'field' => ['id','menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'],
                'value' => [ /*要插入的字段对应的数据*/
                    [1500,'人员追踪数据', '138','menu1573033477', '/crm/Customer/staffTrackLog', 1, 2],
                ],
            ],
        ],
        [
            'type' => 'data',
            'name' => 'crm_s_menu',
            'unique'=>'menu_code',
            'fields' => [
                'field' => ['id','menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'],
                'value' => [ /*要插入的字段对应的数据*/
                    [1501,'查询本店通话记录', '1500','menu1573096502', '', 0, 1],
                ],
            ],
        ],
        [
            'type' => 'data',
            'name' => 'crm_s_menu',
            'unique'=>'menu_code',
            'fields' => [
                'field' => ['id','menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'],
                'value' => [ /*要插入的字段对应的数据*/
                    [1502,'查询本人通话记录', '1500','menu1573096503', '', 0, 2],
                ],
            ],
        ],
    ],
    '1.1.13'=>[
        [
            'type' => 'sql',
            'sql' => "CREATE TABLE IF NOT EXISTS `crm_s_channel_keywords` (
                      `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
                      `channel_id` int(11) DEFAULT NULL,
                      `channel_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '渠道名称',
                      `keyword` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '关键字(不可重复)',
                      `staff_id` int(11) DEFAULT NULL,
                      `staff_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '创建人',
                      `create_time` datetime DEFAULT NULL COMMENT '创建时间',
                      `qrcode` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
                      `valid_date` datetime DEFAULT NULL COMMENT '有效时间',
                      `shop_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
                      `shop_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
                      `is_delete` tinyint(1) DEFAULT '2' COMMENT '是否删除：1：删除；2：未删除',
                      PRIMARY KEY (`id`)
                    ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='渠道关键字表';
                    "
        ],
    ],
    '1.1.14'=>[
        [
            'type' => 'sql',
            'sql' => "CREATE TABLE IF NOT EXISTS `crm_s_wx_menu` (
                      `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
                      `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '菜单名称',
                      `fid` int(11) DEFAULT NULL,
                      `menu_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '功能菜单唯一标识',
                      `url` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '菜单url',
                      `menu_icon` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '菜单图标',
                      `appid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '当菜单类型是小程序时要用到',
                      `status` tinyint(4) DEFAULT NULL COMMENT '状态:99:删除',
                      `sort` int(10) unsigned DEFAULT NULL COMMENT '排序',
                      `level` tinyint(1) unsigned DEFAULT NULL COMMENT '菜单等级',
                      `type` varchar(50) COLLATE utf8_unicode_ci DEFAULT 'view' COMMENT '菜单类型：view：网页；miniprogram：小程序；',
                      `keyword` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '消息回复关键字',
                      `pagepath` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '小程序用，页面路径',
                      PRIMARY KEY (`id`)
                    ) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='微信自定义菜单表';
                    "
        ],
    ],
    '1.1.15' => [
        [
            'type' => 'column',
            'name' => 'crm_c_excel_import_data',
            'fields' => [
                //渠道绑定标记，存储标记信息
                ['name' => 'baby_time', 'type' => 'varchar','length'=>50,'default'=>null, 'is_null' => true],
            ],
        ],
    ],
    '1.1.16'=>[
        [
            'type' => 'data',
            'name' => 'crm_s_menu',
            'unique'=>'menu_code',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['上门类型设定', '2060','menu1574042737', '/crm/Visit/smTypeSet', 1, 2],
                ],
            ],
        ],
        [
            'type' => 'column',
            'name' => 'crm_l_pc_setting_log',
            'fields' => [
                //上门类型
                ['name' => 'sm_type', 'type' => 'varchar','length'=>50,'default'=>null, 'is_null' => true],
            ],
        ],
    ],
    '1.1.17'=>[
        [
            'type' => 'column',
            'name' => 'crm_l_pc_log',
            'fields' => [
                //是否超距 1：是；2：否
                ['name' => 'is_chaoju', 'type' => 'tinyint','length'=>1,'default'=>2, 'is_null' => true],
            ],
        ],
    ],
    '1.1.18'=>[
        [
            'type' => 'column',
            'name' => 'crm_c_customerinfo',
            'fields' => [
                //医拍时间
                ['name' => 'hospital_photo_time', 'type' => 'datetime','default'=>null, 'is_null' => true],
                //医拍摄影师
                ['name' => 'hospital_photo_cameraman_id', 'type' => 'int','length'=>11,'default'=>null, 'is_null' => true],
                ['name' => 'hospital_photo_cameraman', 'type' => 'varchar','length'=>50,'default'=>null, 'is_null' => true],
                //医拍摄影助理
                ['name' => 'hospital_photo_assistant_id', 'type' => 'int','length'=>11,'default'=>null, 'is_null' => true],
                ['name' => 'hospital_photo_assistant', 'type' => 'varchar','length'=>50,'default'=>null, 'is_null' => true],
            ],
        ],
    ],
    '1.1.23'=>[
        [
            'type' => 'column',
            'name' => 'crm_s_channel',
            'fields' => [
                // 分享店面
                ['name' => 'share_shops', 'type' => 'varchar','length'=>1000,'default'=>null, 'is_null' => true],
                // 渠道二维码
                ['name' => 'channel_qrcode', 'type' => 'varchar','length'=>200,'default'=>null, 'is_null' => true],
                // 绑定的客资标记
                ['name' => 'sign_id', 'type' => 'int','length'=>11,'default'=>null, 'is_null' => true],
                ['name' => 'sign_name', 'type' => 'varchar','length'=>100,'default'=>null, 'is_null' => true],
                ['name' => 'bind_sign_ids', 'type' => 'varchar','length'=>1000,'default'=>null, 'is_null' => true],
            ]
        ]
    ],
    '1.1.24'=>[    // erp订单表增加以下字段，为防止数据库连接超时，
        [
            'type' => 'data',
            'name' => 'crm_s_menu',
            'unique'=>'menu_code',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['查询本店上门拍', '2033','menu1576489359', '/crm/Visit/toHome', 1, 2],
                    ['查询本人上门拍', '2033','menu1576489412', '/crm/Visit/toHome', 1, 2],
                    ['分配上门人员', '2033','menu1577329871', '/crm/Visit/cameramanFP', 1, 2],
                    ['上门分组', '2033','menu1577329895', '/crm/Visit/setSmGroup', 1, 2],
                    ['上门开单', '2033','menu1577329926', '/crm/Visit/order', 1, 2],
                    ['上门核销', '2033','menu1577329949', '/crm/Visit/markHX', 1, 2],
                    ['上门删除', '2033','menu1577329973', '', 1, 2],
                    ['上门改期', '2033','menu1577329992', '/crm/Visit/changeVisit', 1, 2],
                    ['上门反馈', '2033','menu1577330039', '', 1, 2],
                ],
            ],
        ],
    ],
    '1.1.32'=>[
        [
            'type' => 'column',
            'name' => 'crm_c_customer_main',
            'fields' => [
                ['name' => 'province', 'type' => 'varchar','length'=>50,'default'=>null, 'is_null' => true],
                ['name' => 'city', 'type' => 'varchar','length'=>50,'default'=>null, 'is_null' => true],
                ['name' => 'county', 'type' => 'varchar','length'=>50,'default'=>null, 'is_null' => true],
            ]
        ],
        [
            'type' => 'sql',
            'sql' => "CREATE TABLE IF NOT EXISTS `crm_c_client_introduct` (
                      `id` int(11) NOT NULL AUTO_INCREMENT,
                      `mid` int(11) DEFAULT NULL COMMENT 'main表主键id',
                      `type` tinyint(4) DEFAULT NULL COMMENT '转介绍类型：1亲属；2朋友',
                      `introduct_mid` int(11) DEFAULT NULL,
                      `create_time` datetime DEFAULT NULL,
                      PRIMARY KEY (`id`),
                      KEY `mid` (`mid`) USING BTREE,
                      KEY `introduct_mid` (`introduct_mid`) USING BTREE,
                      KEY `type` (`type`) USING BTREE
                    ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;"
        ],
    ],
    '1.1.33'=>[    // erp订单表增加以下字段，为防止数据库连接超时，
        [
            'type' => 'data',
            'name' => 'crm_s_menu',
            'unique'=>'menu_code',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['会所名称设定', '900','menu1591943564', '/crm/Setting/clubNameset', 1, 0]
                ],
            ],
        ],
        [
          'type' => 'sql',
            'sql' => "CREATE TABLE IF NOT EXISTS `crm_s_club` (
                      `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '会所表',
                      `club_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
                      `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
                      `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
                      `brandclass_id` int(11) DEFAULT '0',
                      `brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
                      PRIMARY KEY (`id`)
                    ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;"
        ],
        [
            'type' => 'column',
            'name' => 'crm_c_excel_import_data',
            'fields' => [
                // 医拍摄影师
                ['name' => 'hospital_photo_cameraman', 'type' => 'varchar','length'=>50,'default'=>null, 'is_null' => true],
                // 医拍助理
                ['name' => 'hospital_photo_assistant', 'type' => 'varchar','length'=>50,'default'=>null, 'is_null' => true],
                // 医拍时间
                ['name' => 'hospital_photo_time', 'type' => 'datetime','default'=>null, 'is_null' => true],
            ]
        ],
    ],
    '1.1.36'=>[
      [
            'type' => 'column',
            'name' => 'crm_c_customerinfo',
            'fields' => [
                // 推广人id
                ['name' => 'recommend_staff_id', 'type' => 'int','length'=>10,'default'=>null, 'is_null' => true],
                // 推广人
                ['name' => 'recommend_staff', 'type' => 'varchar','length'=>100,'default'=>null, 'is_null' => true],
            ]
        ],
    ],
    '1.1.37'=>[
        [
            'type' => 'column',
            'name' => 'crm_c_excel_import_data',
            'fields' => [
                // 推广人
                ['name' => 'recommend_staff', 'type' => 'varchar','length'=>100,'default'=>null, 'is_null' => true],
            ]
        ],
    ],
    '1.1.38'=>[
        [
            'type' => 'column',
            'name' => 'crm_c_customerinfo',
            'fields' => [
                // 推广人id
                ['name' => 'baby_time', 'type' => 'varchar','length'=>50,'default'=>null, 'is_null' => true],
                // 推广人
                ['name' => 'recommend_staff', 'type' => 'varchar','length'=>100,'default'=>null, 'is_null' => true],
            ]

        ],
        [
            'type' => 'column',
            'name' => 'crm_s_club',
            'fields' => [
                // 推广人id
                ['name' => 'brandclass_id', 'type' => 'int','length'=>10,'default'=>null, 'is_null' => true],
                // 推广人
                ['name' => 'brandclass', 'type' => 'varchar','length'=>100,'default'=>null, 'is_null' => true],
            ]
        ],
        [
            'type' => 'column',
            'name' => 'crm_c_customerinfo',
            'fields' => [
                // 推广人id
                ['name' => 'club_id', 'type' => 'int','length'=>10,'default'=>null, 'is_null' => true],
                // 推广人
                ['name' => 'club_name', 'type' => 'varchar','length'=>100,'default'=>null, 'is_null' => true],
            ]
        ],
    ],
    // '1.1.39'=>[
    //    [
    //         'type' => 'data',
    //         'name' => 'crm_s_menu',
    //         'unique'=>'menu_code',
    //         'fields' => [
    //             'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'],
    //             'value' => [ /*要插入的字段对应的数据*/
    //                 ['月度客资汇总', '300', 'menu1592795406', '/crm/report/Cd_month_customer','0', '0'],
    //                 ['年度客资统计报表', '300', 'menu1592894902', '/crm/report/Cd_year_customer','0', '0'],
    //                 ['月度客资统计导出', '300', 'menu1592895693', '/crm/report/cd_month_customer_daocu','0', '0'],
    //                 ['年度客资统计导出', '300', 'menu1592895869', '/crm/report/Cd_year_customer_daochu','0', '0'],
    //                 ['推广客资统计', '300', 'menu1592899519', '/crm/report/cd_group_staff_customer', '0', '0'],
    //                 ['推广客资统计导出', '300', 'menu1592899626', '/crm/report/cd_group_staff_customer_daochu', '0', '0'],
    //                 ['省域客资分析', '300', 'menu1592901523', '/crm/report/cd_province_customer','0', '0'],
    //                 ['客资广告信息汇总', '300', 'menu1592908385', '/crm/report/Cd_customer_advertising','0', '0'],
    //                 ['客资广告信息汇总导出', '300', 'menu1592988094', '/crm/report/Cd_customer_advertising_daochu','0', '0'],
    //                 ['客资获取方式信息汇总', '300', 'menu1592992337', '/crm/report/Cd_customer_access','0', '0'],
    //                 ['客资获取方式信息汇总导出', '300', 'menu1592993588', '/crm/report/Cd_customer_access_daochu','0', '0'],
    //                 ['关键词数据分析', '300', 'menu1593050731', '/crm/report/cd_keyword_data','0', '0'],
    //                 ['关键词数据分析导出', '300', 'menu1593050757', '/crm/report/cd_keyword_data_daochu','0', '0'],
    //                 ['无效客资原因', '300', 'menu1593054896', '/crm/report/Cd_unvalid_cause','0', '0'],
    //                 ['无效客资原因导出', '300', 'menu1593054927', '/crm/report/Cd_unvalid_cause_daochu','0', '0'],
    //                 ['推广客资统计', '300', 'menu1593159067', '/crm/report/Cd_group_staff_customer',  '0', '0'],
    //                 ['推广客资统计导出', '300', 'menu1592899519', '/crm/report/Cd_group_staff_customer_daochu',  '0', '0'],
    //                 ['状态客资统计', '300', 'menu1593159224', '/crm/report/Cd_status_customer',  '0', '0'],
    //                 ['状态客资统计导出', '300', 'menu1592981289', '/crm/report/Cd_status_customer_daochu',  '0', '0'],
    //                 ['省域客资分析导出', '300', 'menu1593057633', '/crm/report/Cd_province_customer_daochu',  '0', '0'],
    //                 ['市客资分析', '300', 'menu1593159450', '/crm/report/Cd_city_customer',  '0', '0'],
    //                 ['市客资分析导出', '300', 'menu1593058089', '/crm/report/Cd_city_customer_daochu',  '0', '0'],
    //             ],
    //         ],
    //     ],
    // ],
    // '1.1.40'=>[
    //     [
    //         'type' => 'data',
    //         'name' => 'crm_s_menu',
    //         'unique'=>'menu_code',
    //         'fields' => [
    //             'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'],
    //             'value' => [ /*要插入的字段对应的数据*/
    //                 ['网销成交明细表', '300', 'menu1593413738', '/crm/report/Cd_wx_order_info',  '0', '0'],
    //                 ['网销成交明细表导出', '300', 'menu1593322620', '/crm/report/Cd_wx_order_info_daochu',  '0', '0'],
    //                 ['网销销售个人数据业绩表', '300', 'menu1593413750', '/crm/report/Cd_wx_staff_yeji',  '0', '0'],
    //                 ['网销销售个人数据业绩表导出', '300', 'menu1593339260', '/crm/report/Cd_wx_staff_yeji_daochu',  '0', '0'],
    //             ],
    //         ],
    //     ],
    // ],
    // '1.1.41'=>[
    //     [
    //         'type' => 'data',
    //         'name' => 'crm_s_menu',
    //         'unique'=>'menu_code',
    //         'fields' => [
    //             'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'],
    //             'value' => [ /*要插入的字段对应的数据*/
    //                 ['导出客户', '1000', 'menu1593519025', '/crm/client/export',  '0', '0'],
    //             ],
    //         ],
    //     ]
    // ],
    // '1.1.42'=>[
    //     [
    //         'type' => 'data',
    //         'name' => 'crm_s_menu',
    //         'unique'=>'menu_code',
    //         'fields' => [

    //             'field' => ['id','menu_name', 'fid', 'menu_code', 'menu_url', 'menu_icon','status', 'sort'],
    //             'value' => [ /*要插入的字段对应的数据*/
    //                 ['1100','客户数据', '0', 'menu1594192741', '/crm/client/home', 'fa-bar-chart', '1', '1'],

    //             ],
    //         ],
    //     ]
    // ],
    '1.1.45' => [
        [
            'type' => 'column',
            'name' => 'crm_s_report_form',
            'fields' => [
                // 排序
                ['name' => 'sort', 'type' => 'int','length' => 3,'default' => 0, 'is_null' => true],         
            ],
        ],
        [
            'type' => 'column',
            'name' => 'crm_s_channel',
            'fields' => [
                // 操作人id
                ['name' => 'staff_id', 'type' => 'int','length' => 11,'default' => null, 'is_null' => true],   
                // 操作人name
                ['name' => 'staff_name', 'type' => 'varchar','length' => 50,'default' => null, 'is_null' => true],  
                // 操作时间
                ['name' => 'create_time', 'type' => 'datetime','default' => null, 'is_null' => true],        
            ],
        ],
    ],
    '1.1.46' => [
        [
            'type' => 'column',
            'name' => 'crm_l_pc_log',
            'fields' => [
                // 是否改期  默认 1 未改期 2：改期
                ['name' => 'is_gq', 'type' => 'int','length' => 4,'default' => 1, 'is_null' => true],         
            ],
        ]
    ],
    '1.1.47' => [
        [
            'type' => 'table',
            'name' => 'crm_s_goal_name',// 目标名称设定 具体的值由系统默认，不允许设定，跟mc的工作类型类似
            'fields' => [
                ['name' => 'id', 'type' => 'int', 'default' => 'AUTO_INCREMENT', 'is_null' => false],
                // 目标名称
                ['name' => 'goal_name', 'type' => 'varchar', 'length' => 50, 'default' => NULL, 'is_null' => true],
                ['name' => 'create_time', 'type' => 'datetime', 'default' => NULL, 'is_null' => true],
            ],
        ],
        [
            'type' => 'table',
            'name' => 'crm_s_goal',// 大屏目标设定表
            'fields' => [
                ['name' => 'id', 'type' => 'int', 'default' => 'AUTO_INCREMENT', 'is_null' => false],
                // 目标名称,实收，订单等
                ['name' => 'goal_name', 'type' => 'varchar', 'length' => 50, 'default' => NULL, 'is_null' => true],
                // 维度key，如brandclass_id，shop_code，staff_id  现在是店
                ['name' => 'key', 'type' => 'varchar', 'length' => 200, 'default' => NULL, 'is_null' => true],
                // 为谁设置的：某个店，事业部，人等
                ['name' => 'name', 'type' => 'varchar', 'length' => 100, 'default' => NULL, 'is_null' => true],
                // 
                ['name' => 'shop_code', 'type' => 'varchar', 'length' => 200, 'default' => NULL, 'is_null' => true],
                // 目标维度，事业部、店，人等
                ['name' => 'method', 'type' => 'varchar', 'length' => 50, 'default' => NULL, 'is_null' => true],
                // 目标值
                ['name' => 'goal_value', 'type' => 'varchar', 'length' => 50, 'default' => NULL, 'is_null' => true],
                // 年月日
                ['name' => 'year', 'type' => 'varchar', 'length' => 50, 'default' => NULL, 'is_null' => true],
                ['name' => 'month', 'type' => 'varchar', 'length' => 50, 'default' => NULL, 'is_null' => true],
                ['name' => 'day', 'type' => 'varchar', 'length' => 50, 'default' => NULL, 'is_null' => true],
                // 是否启用：1：启用；2：关闭
                ['name' => 'status', 'type' => 'tinyint', 'length' => 4, 'default' => 1, 'is_null' => false],
                ['name' => 'create_time', 'type' => 'datetime', 'default' => NULL, 'is_null' => true],
                ['name' => 'update_time', 'type' => 'datetime', 'default' => NULL, 'is_null' => true],
            ],
        ],
    ],
    /*  先升级到47  才能升级到 48  否则会因为表不存在二而报错
    '1.1.48' => [
        [
            'type' => 'data',
            'name' => 'crm_s_goal_name',
            'unique'=>'goal_name',
            'fields' => [
                'field' => ['goal_name'],
                'value' => [
                    ['毛客资量'],
                    ['有效客资量'],
                    ['有效客资率'],
                    ['预约上门量'],
                    ['成交量'],
                    ['成交率'],
                    ['一销营收'],
                    ['一销实收'],
                    ['二销营收'],
                    ['二销实收'],
                    ['总营收'],
                    ['总实收'],
                    ['拍摄量'],
                    ['拍摄率'],
                    ['选片量'],
                    ['选片率'],
                ],
            ],
        ],
    ],
    */
    '1.1.50' => [
        [
            'type' => 'column',
            'name' => 'crm_c_customerinfo',
            'fields' => [
                // 宝宝体重 单位kg
                ['name' => 'baby_weight', 'type' => 'varchar','length' => 50,'default' => NULL, 'is_null' => true],  
                // 宝宝身高 单位m
                ['name' => 'baby_stature', 'type' => 'varchar','length' => 50,'default' => NULL, 'is_null' => true],          
            ],
        ],
        [
            'type' => 'column',
            'name' => 'crm_c_excel_import_data',
            'fields' => [
                // 宝宝体重 单位kg
                ['name' => 'baby_weight', 'type' => 'varchar','length' => 50,'default' => NULL, 'is_null' => true],  
                // 宝宝身高 单位m
                ['name' => 'baby_stature', 'type' => 'varchar','length' => 50,'default' => NULL, 'is_null' => true],          
            ],
        ],
        [
            'type' => 'column',
            'name' => 'crm_s_report_form',
            'fields' => [
                // 报表分类名称
                ['name' => 'report_type_name', 'type' => 'varchar','length' => 50,'default' => NULL, 'is_null' => true],
            ],
        ],
    ],
    '1.1.57'=>[
        [
            'type' => 'table',
            'name' => 'crm_s_bggoalset',// 大屏目标设定表
            'fields' => [
                ['name' => 'id', 'type' => 'int', 'default' => 'AUTO_INCREMENT', 'is_null' => false],
                // 店名
                ['name' => 'shop_name', 'type' => 'varchar', 'length' => 100, 'default' => NULL, 'is_null' => true],
                // 标准值
                ['name' => 'target', 'type' => 'varchar', 'length' => 100, 'default' => NULL, 'is_null' => true],
                // 今日值
                ['name' => 'jinri', 'type' => 'varchar', 'length' => 100, 'default' => NULL, 'is_null' => true],
                // 标准值
                ['name' => 'biaozhun', 'type' => 'varchar', 'length' => 100, 'default' => NULL, 'is_null' => true],
                // 达成率
                ['name' => 'dachenglv', 'type' => 'varchar', 'length' => 100, 'default' => NULL, 'is_null' => true],
                // 月汇总
                ['name' => 'yuehui', 'type' => 'varchar', 'length' => 100, 'default' => NULL, 'is_null' => true],
                // 月达成率
                ['name' => 'yuedachenglv', 'type' => 'varchar', 'length' => 100, 'default' => NULL, 'is_null' => true],
                // 环比
                ['name' => 'huanbi', 'type' => 'varchar', 'length' => 100, 'default' => NULL, 'is_null' => true],
                // 满足率
                ['name' => 'manzulv', 'type' => 'varchar', 'length' => 100, 'default' => NULL, 'is_null' => true],
                // 日期
                ['name' => 'day', 'type' => 'datetime', 'length' => 0, 'default' => NULL, 'is_null' => true],
                // 创建时间
                ['name' => 'create_time', 'type' => 'datetime', 'length' => 0, 'default' => NULL, 'is_null' => true],
                // 修改时间
                ['name' => 'update_time', 'type' => 'datetime', 'length' => 0, 'default' => NULL, 'is_null' => true],
            ],
        ],
    ],
    '1.1.58'=>[
        [
            'type' => 'column',
            'name' => 'crm_c_customerinfo',
            'fields' => [
                ['name' => 'is_already_sk', 'type' => 'tinyint','length' => 1,'default' => NULL, 'is_null' => true],
            ],
        ],
        [
            'type' => 'column',
            'name' => 'crm_l_pc_setting_log',
            'fields' => [
                ['name' => 'week', 'type' => 'tinyint','length' => 1,'default' => NULL, 'is_null' => true],
            ],
        ]
    ],
    '1.1.61'=>[
        [
            'type' => 'table',
            'name' => 'crm_s_wx_relation',
            'fields' => [
                ['name' => 'id', 'type' => 'int', 'default' => 'AUTO_INCREMENT', 'is_null' => false],
                ['name' => 'subscribe', 'type'=>'tinyint','length'=>4,'is_null' => true,
                'comment'=>'用户是否订阅该公众号标识，值为0时，代表此用户没有关注该公众号，拉取不到其余信息。'],
                ['name' => 'openid', 'type' => 'varchar',  'length'=>50,'is_null' => true],
                ['name' => 'nickname', 'type' => 'varchar',  'length'=>50,'is_null' => true,'comment'=>'用户的昵称'],
                ['name' => 'sex', 'type' => 'varchar',  'length'=>50,'is_null' => true,'comment'=>'1时是男性，2时是女性，0时是未知'],
                ['name' => 'language', 'type' => 'varchar',  'length'=>50,'is_null' => true,'comment'=>'用户的语言，简体中文为zh_CN'],
                ['name' => 'headimgurl', 'type' => 'varchar',  'length'=>255,'is_null' => true,'comment'=>'用户头像，最后一个数值代表正方形头像大小（有0、46、64、96、132数值可选，0代表640*640正方形头像）'],
                ['name' => 'subscribe_time', 'type' => 'varchar',  'length'=>50,'is_null' => true,'comment'=>'用户关注时间，为时间戳。如果用户曾多次关注，则取最后关注时间'],
                ['name' => 'unionid', 'type' => 'varchar',  'length'=>100,'is_null' => true,'comment'=>'只有在用户将公众号绑定到微信开放平台帐号后，才会出现该字段。'],
                ['name' => 'remark', 'type' => 'varchar',  'length'=>255,'is_null' => true,'comment'=>'公众号运营者对粉丝的备注'],
                ['name' => 'kf_id', 'type' => 'int',  'length'=>11,'is_null' => true,'comment'=>'对应的客服id'],
                ['name' => 'cid', 'type' => 'int',  'length'=>11,'is_null' => true,'comment'=>'对应的客资id'],
                ['name' => 'wx_sys_id', 'type' => 'int',  'length'=>11,'is_null' => true,'comment'=>'对应的微信公众id'],
            ]
        ],
        [
            'type' => 'table',
            'name' => 'crm_s_wx_talk',
            'fields' => [
                ['name' => 'id', 'type' => 'bigint','length'=>20, 'default' => 'AUTO_INCREMENT', 'is_null' => false],
                ['name' => 'openid', 'type' => 'varchar',  'length'=>50,'is_null' => true],
                ['name' => 'opercode', 'type' => 'varchar',  'length'=>20,'is_null' => true,'comment'=>'文本（text）、图片（img）、语音（voice）、视频（video）、图文消息（news）'],
                ['name' => 'text', 'type' => 'text',  'is_null' => true],
                ['name' => 'time', 'type' => 'datetime',  'is_null' => true],
                ['name' => 'kf_id', 'type' => 'int',  'length'=>11,'is_null' => true,'comment'=>'发送消息的客服人员，如果为-1 则为系统自动回复'],
            ]
        ],
        [
            'type' => 'column',
            'name' => 'crm_s_wx_relation',
            'fields' => [
                ['name' => 'create_time', 'type' => 'datetime','default' => NULL, 'is_null' => true],
                ['name' => 'update_time', 'type' => 'datetime','default' => NULL, 'is_null' => true,'comment'=>'更新时间，即最后一次聊天时间，如果没有聊天，记录关注时间'],
                ['name' => 'last_word', 'type' => 'text','default' => NULL, 'is_null' => true],
                ['name' => 'new_msg_num', 'type' => 'int','length'=>11,'default' => 0, 'is_null' => true,'comment'=>'未读消息数量'],
                ['name' => 'openid', 'type' => 'key','keytype'=>'unique','fields'=>['openid']],
                ['name' => 'kf_id', 'type' => 'key','fields'=>['kf_id']],

            ],
        ],
        [
            'type' => 'column',
            'name' => 'crm_s_wx_talk',
            'fields' => [
                ['name' => 'status', 'type' => 'tinyint','length'=>1,'default' => 0, 'is_null' => true,'comment' =>'0:未读,1:已读'],
                ['name' => 'type_supply', 'type' => 'text','default' => NULL, 'is_null' => true,'comment'=>'类型的补充（如果是图片这里存放永久资源(ever)、临时资源(temp)；如果是音频这里存放语音翻译）'],
                ['name' => 'type', 'type' => 'varchar','length'=>50,'default' => NULL, 'is_null' => true,'comment'=>'文本（text）、图片（img）、语音（voice）、视频（video）、图文消息（news）'],
                ['name' => 'mc_id', 'type' => 'bigint','length'=>20,'default' => NULL, 'is_null' => true],
            ],
        ],
    ],
    '1.1.62'=>[
        [
            'type' => 'column',
            'name' => 'crm_c_customer_order',
            'fields' => [
                // 预约上门ID
                ['name' => 'visit_id', 'type' => 'int','length' => 11,'default' => NULL, 'is_null' => true],
                // 上门拍订单类型 1：网销开单，上门服务 2：上门服务并开单 3：上门服务，销售订单
                ['name' => 'visit_order_type', 'type' => 'tinyint','length' => 1,'default' => NULL, 'is_null' => true],
            ],
        ],
        [
            'type' => 'column',
            'name' => 'crm_l_pc_log',
            'fields' => [
                // 预约上门的服务订单(网销开的)
                ['name' => 'visit_order', 'type' => 'varchar','length' => 100,'default' => NULL, 'is_null' => true],
            ],
        ],
    ],
    '1.1.63'=>[
        [
            'type' => 'column',
            'name' => 'crm_s_channel',
            'fields' => [
                // 渠道简码
                ['name' => 'channel_code', 'type' => 'varchar','length' => 50,'default' => NULL, 'is_null' => true],
            ],
        ]
    ],
    '1.1.64'=>[
        [
            'type' => 'column',
            'name' => 'crm_c_customerinfo',
            'fields' => [
                // 套系名称
                ['name' => 'package_name', 'type' => 'varchar','length' => 100,'default' => NULL, 'is_null' => true],
            ],
        ]
    ],
    '1.1.65' => [
        [
            'type' => 'column',
            'name' => 'crm_c_customerinfo',
            'fields' => [
                // 加微信状态 1:已加未通过 2:通过
                ['name' => 'wechat_status', 'type' => 'tinyint','length' => 3, 'default' => 0, 'is_null' => true],                
            ],
        ],
    ],
    '1.1.66' => [
        [
            'type' => 'column',
            'name' => 'crm_c_customerinfo',
            'fields' => [
                // 介绍关系： 1:亲属 2:朋友
                ['name' => 'zjs_rel', 'type' => 'tinyint','length' => 3, 'default' => 0, 'is_null' => true],                
            ],
        ],
        [ /*添加索引*/
            'type' => 'column',
            'name' => 'crm_c_customerinfo',
            'fields' => [
                [ 'type' => 'key', 'keytype'=>'INDEX', 'name' => 'customer_channel', 'fields' => ['customer_channel'] ],
            ],
        ],
        [ /*添加索引*/
            'type' => 'column',
            'name' => 'crm_s_channel',
            'fields' => [
                [ 'type' => 'key', 'keytype'=>'INDEX', 'name' => 'channel_name', 'fields' => ['channel_name'] ],
            ],
        ],
    ],
    '1.1.68'=>[
      [
        'type' => 'column',
        'name' => 'crm_c_excel_import_data',
        'fields' => [
            // 意向套系
            ['name' => 'package_name', 'type' => 'varchar','length' => 100, 'default' => 0, 'is_null' => true],                
        ],
      ]
    ],
    '1.1.69' => [
        [
            'type' => 'column',
            'name' => 'crm_s_channel',
            'fields' => [
                // 利率
                ['name' => 'rebates', 'type' => 'int','length' => 11,'default' => null, 'is_null' => true],
                //利率开始时间
                ['name' => 'rebates_start_time', 'type' => 'datetime','default' => null, 'is_null' => true],   
                //利率结束时间
                ['name' => 'rebates_end_time', 'type' => 'datetime','default' => null, 'is_null' => true],   
            ],
        ],
    ],
    // 南宁定制 
    '1.1.73' => [
        [
            'type' => 'table',
            'name' => 'crm_s_brandset',
            'fields' => [
                ['name' => 'id', 'type' => 'int', 'default' => 'AUTO_INCREMENT', 'is_null' => false],
                // 品牌名称
                ['name' => 'name', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
                // 排序
                ['name' => 'sort', 'type' => 'int', 'length' => 11, 'default' => 0, 'is_null' => true],
                // 操作人
                ['name' => 'add_staff_id', 'type' => 'int', 'length' => 11, 'default' => null, 'is_null' => true],
                ['name' => 'add_staff_name', 'type' => 'varchar', 'length' => 50, 'default' => null, 'is_null' => true],
                ['name' => 'add_time', 'type' => 'datetime', 'default' => null, 'is_null' => true],
                // 修改人
                ['name' => 'update_staff_id', 'type' => 'int', 'length' => 11, 'default' => null, 'is_null' => true],
                ['name' => 'update_staff_name', 'type' => 'varchar', 'length' => 50, 'default' => null, 'is_null' => true],
                ['name' => 'update_time', 'type' => 'datetime', 'default' => null, 'is_null' => true],
            ],
        ],
        [
            'type' => 'table',
            'name' => 'crm_s_fans',// 南宁定制 粉丝信息
            'fields' => [
                ['name' => 'id', 'type' => 'int', 'default' => 'AUTO_INCREMENT', 'is_null' => false],
                // 城市
                ['name' => 'city_id', 'type' => 'int', 'length' => 11, 'default' => null, 'is_null' => true],
                ['name' => 'city_name', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
                // 渠道
                ['name' => 'channel_class_id', 'type' => 'int', 'length' => 11, 'default' => null, 'is_null' => true],
                ['name' => 'channel_class_name', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
                ['name' => 'channel_info_id', 'type' => 'int', 'length' => 11, 'default' => null, 'is_null' => true],
                ['name' => 'channel_info_name', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
                ['name' => 'channel_id', 'type' => 'int', 'length' => 11, 'default' => null, 'is_null' => true],
                ['name' => 'channel_name', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],

                ['name' => 'date', 'type' => 'date', 'default' => null, 'is_null' => true],
                ['name' => 'kf_staff_id', 'type' => 'int', 'length' => 11, 'default' => null, 'is_null' => true],
                ['name' => 'kf_staff_name', 'type' => 'varchar', 'length' => 50, 'default' => null, 'is_null' => true],
                ['name' => 'tg_staff_id', 'type' => 'int', 'length' => 11, 'default' => null, 'is_null' => true],
                ['name' => 'tg_staff_name', 'type' => 'varchar', 'length' => 50, 'default' => null, 'is_null' => true],

                ['name' => 'subscribe_num', 'type' => 'int', 'length' => 11, 'default' => null, 'is_null' => true],//关注量
                ['name' => 'unsubscribe_num', 'type' => 'int', 'length' => 11, 'default' => null, 'is_null' => true],//取关量
                ['name' => 'private_num', 'type' => 'int', 'length' => 11, 'default' => null, 'is_null' => true],//有效对话量
                ['name' => 'effective_form', 'type' => 'int', 'length' => 11, 'default' => null, 'is_null' => true],//有效表单
                ['name' => 'chat_num', 'type' => 'int', 'length' => 11, 'default' => null, 'is_null' => true],//有效对话量
                ['name' => 'kezi_num', 'type' => 'int', 'length' => 11, 'default' => 0, 'is_null' => true],
                
                ['name' => 'brandclass_id', 'type' => 'int', 'length' => 11, 'default' => null, 'is_null' => true],
                ['name' => 'shop_code', 'type' => 'varchar', 'length' => 50, 'default' => null, 'is_null' => true],
                ['name' => 'shop_name', 'type' => 'varchar', 'length' => 50, 'default' => null, 'is_null' => true],
                ['name' => 'add_staff_id', 'type' => 'int', 'length' => 11, 'default' => null, 'is_null' => true],
                ['name' => 'add_staff_name', 'type' => 'varchar', 'length' => 50, 'default' => null, 'is_null' => true],
                ['name' => 'add_time', 'type' => 'datetime', 'default' => null, 'is_null' => true],
                ['name' => 'update_staff_id', 'type' => 'int', 'length' => 11, 'default' => null, 'is_null' => true],
                ['name' => 'update_staff_name', 'type' => 'varchar', 'length' => 50, 'default' => null, 'is_null' => true],
                ['name' => 'update_time', 'type' => 'datetime', 'default' => null, 'is_null' => true],
            ],
        ],
        [
            'type' => 'column',
            'name' => 'crm_s_channel_cost', // 南宁定制 渠道花费表 品牌，城市，展现，点击
            'fields' => [
                ['name' => 'cost_staff', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],//
                ['name' => 'b_id', 'type' => 'int', 'length' => 11, 'default' => null, 'is_null' => true],//品牌id
                ['name' => 'b_name', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],//品牌name
                ['name' => 'show_num', 'type' => 'int', 'length' => 11, 'default' => null, 'is_null' => true],//展现量
                ['name' => 'click_num', 'type' => 'int', 'length' => 11, 'default' => null, 'is_null' => true],//点击量
            ],
        ],
        [
            'type' => 'column',
            'name' => 'crm_c_customerinfo', // 南宁定制 客资表 品牌
            'fields' => [
                ['name' => 'b_id', 'type' => 'int', 'length' => 11, 'default' => null, 'is_null' => true],//品牌id
                ['name' => 'b_name', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],//品牌name
                // 客资标记是否过保护期  1：过期；2：未过期;
                ['name' => 'sign_id_is_protected', 'type' => 'tinyint', 'length' => 3, 'default' => 2, 'is_null' => true],
                // 客资状态是否超期  1：超期；2：未超期;
                ['name' => 'valid_status_is_chaoqi', 'type' => 'tinyint', 'length' => 3, 'default' => 2, 'is_null' => true],
            ],
        ],
        [
            'type' => 'column',
            'name' => 'crm_s_tracksign',
            'fields' => [
                // 客资标记保护期
                ['name' => 'protect_day', 'type' => 'int', 'length' => 11, 'default' => null, 'is_null' => true],
            ],
        ],
        [
            'type' => 'data',
            'name' => 'crm_api_list',
            'unique'=>'hash',
            'fields' => [
                'field' => ['apiName', 'apiUrl', 'app_id', 'hash', 'accessToken', 'needLogin', 'status', 'method', 'info'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['转单 发送站内弹窗消息及微信推送', 'Intostore/getRemindSend', 8, '606d7db27053c', 0, 0, 1, 1, ''],
                ],
            ],
        ],
        [
            'type' => 'data',
            'name' => 'crm_api_fields',
            'unique'=>'hash',
            'fields' => [
                'field' => ['fieldName', 'hash', 'dataType', 'default', 'isMust', 'range', 'info', 'type', 'showName'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['cid','606d7db27053c','1','','1','','进店表 cid','0','cid'],
                    ['order_sn','606d7db27053c','2','单号','1','单号','单号','0','order_sn'],
                    ['staff_id','606d7db27053c','1','操作人id','1','操作人id','操作人id','0','staff_id'],
                    ['staff_name','606d7db27053c','2','staff_name','1','操作人','操作人','0','staff_name'],
                ],
            ],
        ],
    ],
    // 南宁定制 
    '1.1.74' => [
        [
            'type' => 'column',
            'name' => 'crm_s_channel_cost', // 南宁定制 渠道花费表 关注量/私信量/有效表单
            'fields' => [
                ['name' => 'subscribe_num', 'type' => 'int', 'length' => 11, 'default' => null, 'is_null' => true],//关注量
                ['name' => 'private_num', 'type' => 'int', 'length' => 11, 'default' => null, 'is_null' => true],//私信量
                ['name' => 'effective_form', 'type' => 'int', 'length' => 11, 'default' => null, 'is_null' => true],//有效表单
            ],
        ],
        [
            'type' => 'column',
            'name' => 'crm_c_customerinfo', // 南宁定制 客资流转
            'fields' => [
                ['name' => 'is_liuzhuan', 'type' => 'int', 'length' => 11, 'default' => 1, 'is_null' => true],//默认是1 代表这个客资未流转过 流转之后 修改为2 代表该客资流转过，可以查看，不允许追踪
            ],
        ],
    ],
    '1.1.78'  =>[
        [
            'type' => 'column',
            'name' => 'crm_l_pc_log',
            'fields' => [
                ['name' => 'cloth', 'type' => 'varchar', 'length' => 500, 'is_null' => true],//上门时选的服装编号
            ],
        ],
    ],
    '1.1.82'=>[
        [
            'type' => 'sql',
            'sql' => 'ALTER TABLE `crm_l_pc_log` CHANGE COLUMN `time` `time` VARCHAR(50) NULL DEFAULT NULL COMMENT \'具体时间\' AFTER `area_name`;', // 上门时间点，
        ]
    ],
    '1.1.83'  =>[
        [
            'type' => 'table',
            'name' => 'crm_s_channel_recharge',// 南宁定制 渠道充值
            'fields' => [
                ['name' => 'id', 'type' => 'int', 'default' => 'AUTO_INCREMENT', 'is_null' => false],
                // 城市
                ['name' => 'province_id', 'type' => 'int', 'length' => 11, 'default' => null, 'is_null' => true],
                ['name' => 'province_name', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
                ['name' => 'city_id', 'type' => 'int', 'length' => 11, 'default' => null, 'is_null' => true],
                ['name' => 'city_name', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
                // 渠道
                ['name' => 'channel_class_id', 'type' => 'int', 'length' => 11, 'default' => null, 'is_null' => true],
                ['name' => 'channel_class_name', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
                ['name' => 'channel_info_id', 'type' => 'int', 'length' => 11, 'default' => null, 'is_null' => true],
                ['name' => 'channel_info_name', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
                ['name' => 'channel_id', 'type' => 'int', 'length' => 11, 'default' => null, 'is_null' => true],
                ['name' => 'channel_name', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],

                ['name' => 'money', 'type' => 'decimal', 'length' => '10,2', 'is_null' => true],
                ['name' => 'time', 'type' => 'datetime',  'default' => null, 'is_null' => true],
                
                ['name' => 'brandclass_id', 'type' => 'int', 'length' => 11, 'default' => null, 'is_null' => true],
                ['name' => 'shop_code', 'type' => 'varchar', 'length' => 50, 'default' => null, 'is_null' => true],
                ['name' => 'shop_name', 'type' => 'varchar', 'length' => 50, 'default' => null, 'is_null' => true],
                ['name' => 'add_staff_id', 'type' => 'int', 'length' => 11, 'default' => null, 'is_null' => true],
                ['name' => 'add_staff_name', 'type' => 'varchar', 'length' => 50, 'default' => null, 'is_null' => true],
                ['name' => 'add_staff_time', 'type' => 'datetime', 'default' => null, 'is_null' => true],
                ['name' => 'update_staff_id', 'type' => 'int', 'length' => 11, 'default' => null, 'is_null' => true],
                ['name' => 'update_staff_name', 'type' => 'varchar', 'length' => 50, 'default' => null, 'is_null' => true],
                ['name' => 'update_staff_time', 'type' => 'datetime', 'default' => null, 'is_null' => true],
            ],
        ],
    ],
    '1.1.85'=>[
        [
            'type' => 'column',
            'name' => 'crm_s_channel_recharge',
            'fields' => [
                ['name' => 'money_fd', 'type' => 'decimal', 'length' => '10,2', 'is_null' => true],//返点金额
            ],
        ]
    ],
    '1.1.90'=>[
        [
            'type' => 'column',
            'name' => 'crm_c_customerinfo',
            'fields' => [
                // 套系名称
                ['name' => 'package_name', 'type' => 'varchar','length' => 100,'default' => NULL, 'is_null' => true],
                // 加微信状态 1:已加未通过 2:通过
                ['name' => 'wechat_status', 'type' => 'tinyint','length' => 3, 'default' => 0, 'is_null' => true],  
            ],
        ]
    ],
    '1.1.91'=>[
        [
            'type' => 'column',
            'name' => 'crm_s_call_center',
            'fields' => [
                // 云呼账号
                ['name' => 'accountid', 'type' => 'varchar','length' => 50,'default' => NULL, 'is_null' => true],
                // 云呼密码
                ['name' => 'secret', 'type' => 'varchar','length' => 50, 'default' => NULL, 'is_null' => true],  
            ],
        ],
        [
            'type' => 'column',
            'name' => 'crm_s_call_man',
            'fields' => [
                // 类型
                ['name' => 'exten_type', 'type' => 'varchar','length' => 50, 'default' => NULL, 'is_null' => true],  
            ],
        ],
        [
            'type' => 'table',
            'name' => 'crm_c_call_temporary',// 呼叫中心(七陌) 临时接收表
            'fields' => [
                ['name' => 'id', 'type' => 'int', 'default' => 'AUTO_INCREMENT', 'is_null' => false],
                ['name' => 'cid', 'type' => 'int', 'length' => 11, 'default' => null, 'is_null' => true],
                //1:通话结束Hangup;2:被呼振铃Ringing
                ['name' => 'type', 'type' => 'tinyint','length' => 1, 'default' => 1, 'is_null' => true],  
                ['name' => 'sales_staff_id', 'type' => 'int', 'length' => 11, 'default' => null, 'is_null' => true],
                ['name' => 'time', 'type' => 'varchar','length' => 50, 'default' => NULL, 'is_null' => true],  
                ['name' => 'times', 'type' => 'datetime', 'default' => NULL, 'is_null' => true], 
                ['name' => 'txt', 'type' => 'text','default' => NULL, 'is_null' => true],  
                // 1:数据已更新到追踪表
                ['name' => 'status', 'type' => 'tinyint','length' => 1, 'default' => NULL, 'is_null' => true],  
                ['name' => 'create_time', 'type' => 'datetime', 'default' => null, 'is_null' => true],
            ],
        ],
    ],
    '1.1.93'=>[
        [
            'type' => 'column',
            'name' => 'c_customerorder',// 呼叫中心(七陌) 临时接收表
            'fields' => [
                ['name' => 'crm_customer_id', 'type' => 'int', 'length' => 11, 'default' =>null], 
                //crm_c_customerinfo表字段，客资编号
                ['name' => 'crm_customer_number', 'type' => 'varchar','length' => 20, 'default' => NULL, 'is_null' => true],  
                //crm_c_customer_main表字段
                ['name' => 'crm_c_unique', 'type' => 'varchar','length' => 100, 'default' => NULL, 'is_null' => true],  
                //'crm，订单类型：''1：线上；2：线下'''
                ['name' => 'crm_order_type', 'type' => 'tinyint', 'length' => 4, 'default' => '2', 'is_null' => true],
                // 进客表（crm_c_customer_intostore）id
                ['name' => 'crm_into_id', 'type' => 'int','length' => 11, 'default' => NULL, 'is_null' => true],  
                //预约上门id（crm_l_pc_log）
                ['name' => 'crm_visit_id', 'type' => 'int','length' => 11, 'default' => NULL, 'is_null' => true],  
            ],
        ],
        [
            'type' => 'column',
            'name' => 'crm_l_pc_log',// 到店拍排程日志
            'fields' => [
                //上门客资分组
                ['name' => 'smgroup', 'type' => 'varchar','length' => 100, 'default' => NULL, 'is_null' => true],  
            ],
        ],
    ],
    '1.1.102'=>[
      [
          'type' => 'column',
          'name' => 'crm_l_pc_log',
          'fields' => [
              // 预约上门的服务订单(网销开的)
              ['name' => 'visit_order', 'type' => 'varchar','length' => 100,'default' => NULL, 'is_null' => true],
          ],
      ],
      [
          'type' => 'column',
          'name' => 'crm_c_customerinfo',
          'fields' => [
              // 介绍关系： 1:亲属 2:朋友
              ['name' => 'zjs_rel', 'type' => 'tinyint','length' => 3, 'default' => 0, 'is_null' => true],                
          ],
      ],
      [
          'type' => 'column',
          'name' => 'crm_c_customer_order',
          'fields' => [
              ['name' => 'visit_id', 'type' => 'int','length' => 11, 'is_null' => true],   
              ['name' => 'visit_order_type', 'type' => 'tinyint','length' => 1,'is_null' => true],                
          ],
      ],
    ],
];