<?php
/**
 * 报表详情 基本模块
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: wangzhenya<wangzhenya@suxuantech.cn> 2019-07-25 $
 */
namespace app\crm\controller;
use think\Cache;
use app\index\controller\Base;
use think\Exception;
use Excel5;
use think\Controller;
use app\common\lib\mcInterface;
class Detail extends Base{
    //private $aiying_shop_code = 'xaf002';
    private $aiying_shop_code = 'SC001';

    public function Xaf_hospital_fact_data_detail(){
        $data = input();
        if($data['day'] == 0){
            $time = date('Ym',strtotime($data['month']));
            $where['p.paymentdate'] = ['like','%'.$time.'%'];
        }else{
            $time = date('Ymd',strtotime($data['month'].'-'.$data['day']));
            $where['p.paymentdate'] = $time;
        }
        $hos = trim($data['hos']);
        $shop_code = trim($data['shop_code']);

        $where['c_from'] = 1;
        $where['is_status'] = 1;
        $where['c.shop_code'] = $shop_code;
        $sql = '1=1 ';
        if($data['hos'] == '医院实收合计'){
            $where['p.paytype'] = ['<>','VIP卡'];
            $hos = controller('crm/Customer','lib')->getHospital(['shop_code'=>$shop_code]);
            $where['c.baby_address'] = ['in',array_column($hos,'hospital')];

            //2021-05-08 加条件 只抓爱婴
            $sql .= ' and p.shop_name in ("爱婴总部","爱婴一部","爱婴二部","爱婴三部")';
        }elseif($data['hos'] == '其它实收统计'){
            $where['p.paytype'] = ['<>','VIP卡'];
            $hos = controller('crm/Customer','lib')->getHospital(['shop_code'=>$shop_code]);
            $baby_address = '';
            foreach($hos as $k=>$v){
                $baby_address .= '"'.$v['hospital'].'",';
            }
            $sql .= ' and c.baby_address is null or c.baby_address not in ('.trim($baby_address,',').')';

            //2021-05-08 加条件 只抓爱婴
            $sql .= ' and p.shop_name in ("爱婴总部","爱婴一部","爱婴二部","爱婴三部")';
        }elseif($data['hos'] == 'VIP卡'){
            $where['p.paytype'] = 'VIP卡';

            //2021-05-08 加条件 只抓爱婴
            $sql .= ' and p.shop_name in ("爱婴总部","爱婴一部","爱婴二部","爱婴三部")';
        }else{
            $where['p.paytype'] = ['<>','VIP卡'];
            $where['c.baby_address'] = $hos;
        }

        //2021-05-08 加条件 只抓爱婴
        if($data['hos'] == '实收总计'){
            $sql .= ' and p.shop_name in ("爱婴总部","爱婴一部","爱婴二部","爱婴三部")';
        }

        $return = db('crm_c_customerinfo')->alias('c')->join('c_customerorder o','c.customer_number=o.crm_customer_number','left')
            ->join('c_paymentcontent p','o.orderId=p.orderId','left')
            ->where($sql)
            ->where($where)
            ->field('c.baby_address,p.orderId,p.paymentdate,p.payment_money,p.cashierman,p.fundname,o.shop_name as order_shop_name,p.shop_name as pay_shop_name')
            ->select();
        $this->assign('return',$return);
        return $this->fetch();
    }
    public function Xaf_channel_fact_data_detail(){
        $data = input();
        if($data['day'] == 0){
            $time = date('Ym',strtotime($data['month']));
            $where['p.paymentdate'] = ['like','%'.$time.'%'];
        }else{
            $time = date('Ymd',strtotime($data['month'].'-'.$data['day']));
            $where['p.paymentdate'] = $time;
        }
        $channel_name = trim($data['channel_name']);
        $shop_code = trim($data['shop_code']);

        $where['c_from'] = 1;
        $where['is_status'] = 1;
        $where['c.shop_code'] = $shop_code;
        $sql = '1=1 ';
        if($data['channel_name'] == '会所类实收合计'){
            $where['p.paytype'] = ['<>','VIP卡'];
            $findSql = ' FIND_IN_SET("'.$shop_code.'",share_shops) ';
            $channel = db('crm_s_channel')->where($findSql)->where('sign_name','会所类')->order('order_sort')->select();
            $where['c.customer_channel'] = ['in',array_column($channel,'channel_name')];

            //2021-05-08 加条件 只抓爱婴
            $sql .= ' and p.shop_name in ("爱婴总部","爱婴一部","爱婴二部","爱婴三部")';
        }elseif($data['channel_name'] == '其它实收统计'){
            $where['p.paytype'] = ['<>','VIP卡'];
            $findSql = ' FIND_IN_SET("'.$shop_code.'",share_shops) ';
            $channel = db('crm_s_channel')->where($findSql)->where('sign_name','会所类')->order('order_sort')->select();
            $customer_channel = '';
            foreach($channel as $k=>$v){
                $customer_channel .= '"'.$v['channel_name'].'",';
            }
            $sql .= ' and c.customer_channel is null or c.customer_channel not in ('.trim($customer_channel,',').')';


            //2021-05-08 加条件 只抓爱婴
            $sql .= ' and p.shop_name in ("爱婴总部","爱婴一部","爱婴二部","爱婴三部")';
        }elseif($data['channel_name'] == 'VIP卡'){
            $where['p.paytype'] = 'VIP卡';
            
            //2021-05-08 加条件 只抓爱婴
            $sql .= ' and p.shop_name in ("爱婴总部","爱婴一部","爱婴二部","爱婴三部")';
        }else{
            $where['p.paytype'] = ['<>','VIP卡'];
            $where['c.customer_channel'] = $channel_name;
        }
        
        //2021-05-08 加条件 只抓爱婴
        if($data['hos'] == '实收总计'){
            $sql .= ' and p.shop_name in ("爱婴总部","爱婴一部","爱婴二部","爱婴三部")';
        }

        $return = db('crm_c_customerinfo')->alias('c')->join('c_customerorder o','c.customer_number=o.crm_customer_number','left')
            ->join('c_paymentcontent p','o.orderId=p.orderId','left')
            ->where($sql)
            ->where($where)
            ->field('c.customer_channel,p.orderId,p.paymentdate,p.payment_money,p.cashierman,p.fundname,o.shop_name as order_shop_name,p.shop_name as pay_shop_name')
            ->select();
        $this->assign('return',$return);
        return $this->fetch();
    }
    // Xaf_customer_data 报表  客资部分
    public function Xaf_customer_data_getKzNum(){
        $param = input();
        $start = date('Y-m-d 00:00:00', strtotime($param['start']));
        $end = date('Y-m-d 23:59:59', strtotime($param['end']));
        // if ((int)$param['staff_id']) {
        if ($param['staff_id']) {
            $where['c_from'] = 1;
            $where['is_status'] = 1;
            $where['is_loss'] = 2;
            $where['shop_code'] = $param['w_shop_code'] ? ['in',$param['w_shop_code']] : $param['shop_code'];
            $where['sales_staff_id'] = ['in',$param['staff_id']];//$param['staff_id'];

            switch ($param['sign']) {
                case 'kzyl':
                    $where['sign_name'] = YILEI;
                    $where['baby_birthday'] = ['between',[$start,$end]];
                    break;
                case 'kzel':
                    $where['sign_name'] = ERLEI;
                    $where['baby_birthday'] = ['between',[$start,$end]];
                    break;
                case 'kzsl':
                    $where['sign_name'] = SANLEI;
                    $where['baby_birthday'] = ['between',[$start,$end]];
                    break;
                case 'kzwx':
                    $where['is_valid'] = 3;
                    $where['baby_birthday'] = ['between',[$start,$end]];
                    break;
                case 'kzmd':
                    $where['sign_name'] = MINGDAN;
                    $where['baby_birthday'] = ['between',[$start,$end]];
                    break;
                case 'kzycq':
                    $where['sign_name'] = YUCHANAQI;
                    $where['ready_baby_day'] = ['between',[$start,$end]];
                    break;
            }

            $return = db('crm_c_customerinfo')
                ->where($where)
                ->field('id,customer_name,customer_tel,sign_name,customer_channel,DATE_FORMAT(baby_birthday, "%Y-%m-%d") as baby_birthday,DATE_FORMAT(ready_baby_day, "%Y-%m-%d") as ready_baby_day,shop_name')
                ->order('sign_name,customer_channel')->select();
            $this->assign('return',$return);
        }else{
            $this->assign('return',[]);
        }
        return $this->fetch();
    }
    // Xaf_customer_data 报表  标记部分
    public function Xaf_customer_data_getSignNum(){
        $param = input();
        $start = date('Y-m-d 00:00:00', strtotime($param['start']));
        $end = date('Y-m-d 23:59:59', strtotime($param['end']));
        // if ((int)$param['staff_id']) {
        if ($param['staff_id']) {
            $where['c.c_from'] = 1;
            $where['c.is_status'] = 1;
            $where['c.is_loss'] = 2;
            $where['l.pc_shop_code'] = $param['w_shop_code'] ? ['in',$param['w_shop_code']] : $param['shop_code'];
            $where['c.sales_staff_id'] = ['in',$param['staff_id']];//$param['staff_id'];
            switch ($param['sign']) {
                case 'ylps':
                    $type = 'sm';
                    $where['c.sign_name'] = YILEI;
                    $where['`l`.`status`'] = ['in',[2,3]];
                    $where['l.sm_type'] = '拍摄';
                    break;
                case 'ylcj':
                    $type = 'order';
                    $where['c.sign_name'] = YILEI;
                    $where['l.sm_type'] = '拍摄';
                    break;
                case 'ylyj':
                    $type = 'yeji';
                    $where['c.sign_name'] = YILEI;
                    $where['l.pc_time'] = ['between',[$start,$end]];
                    $where['l.sm_type'] = '拍摄';
                    break;
                case 'elps':
                    $type = 'sm';
                    $where['c.sign_name'] = ERLEI;
                    $where['`l`.`status`'] = ['in',[2,3]];
                    $where['l.sm_type'] = '拍摄';
                    break;
                case 'elcj':
                    $type = 'order';
                    $where['c.sign_name'] = ERLEI;
                    // $where['o.orderyouxiaodate'] = ['between',[$start,$end]];
                    $where['o.payment_money'] = ['>',899];
                    $where['l.pc_time'] = ['between',[$start,$end]];
                    // $where['o.orderyouxiao'] = 1;
                    $where['l.sm_type'] = '拍摄';
                    break;
                case 'elyj':
                    $type = 'yeji';
                    $where['c.sign_name'] = ERLEI;
                    $where['l.pc_time'] = ['between',[$start,$end]];
                    $where['l.sm_type'] = '拍摄';
                    break;
                case 'slps':
                    $type = 'sm';
                    $where['c.sign_name'] = SANLEI;
                    $where['`l`.`status`'] = ['in',[2,3]];
                    $where['l.sm_type'] = '拍摄';
                    break;
                case 'slcj':
                    $type = 'order';
                    $where['c.sign_name'] = SANLEI;
                    // $where['o.orderyouxiaodate'] = ['between',[$start,$end]];
                    $where['o.payment_money'] = ['>',899];
                    $where['l.pc_time'] = ['between',[$start,$end]];
                    // $where['o.orderyouxiao'] = 1;
                    $where['l.sm_type'] = '拍摄';
                    break;
                case 'slyj':
                    $type = 'yeji';
                    $where['c.sign_name'] = SANLEI;
                    $where['l.pc_time'] = ['between',[$start,$end]];
                    $where['l.sm_type'] = '拍摄';
                    break;
                case 'mdps':
                    $type = 'sm';
                    $where['c.sign_name'] = MINGDAN;
                    $where['`l`.`status`'] = ['in',[2,3]];
                    $where['l.sm_type'] = '拍摄';
                    break;
                case 'mdcj':
                    $type = 'order';
                    $where['c.sign_name'] = MINGDAN;
                    // $where['o.orderyouxiaodate'] = ['between',[$start,$end]];
                    $where['o.payment_money'] = ['>',899];
                    $where['l.pc_time'] = ['between',[$start,$end]];
                    // $where['o.orderyouxiao'] = 1;
                    $where['l.sm_type'] = '拍摄';
                    break;
                case 'mdyj':
                    $type = 'yeji';
                    $where['c.sign_name'] = MINGDAN;
                    $where['l.pc_time'] = ['between',[$start,$end]];
                    $where['l.sm_type'] = '拍摄';
                    break;
                case 'ycps':
                    $type = 'sm';
                    $where['c.sign_name'] = YUCHANAQI;
                    $where['`l`.`status`'] = ['in',[2,3]];
                    $where['l.sm_type'] = '拍摄';
                    break;
                case 'yccj':
                    $type = 'order';
                    $where['c.sign_name'] = YUCHANAQI;
                    // $where['o.orderyouxiaodate'] = ['between',[$start,$end]];
                    $where['o.payment_money'] = ['>',899];
                    $where['l.pc_time'] = ['between',[$start,$end]];
                    // $where['o.orderyouxiao'] = 1;
                    $where['l.sm_type'] = '拍摄';
                    break;
                case 'ycyj':
                    $type = 'yeji';
                    $where['c.sign_name'] = YUCHANAQI;
                    $where['l.pc_time'] = ['between',[$start,$end]];
                    $where['l.sm_type'] = '拍摄';
                    break;
                case 'lfps':
                    $type = 'sm';
                    $where['l.sm_type'] = '理发';
                    $where['`l`.`status`'] = ['in',[2,3]];
                    break;
                case 'lfcj':
                    $type = 'order';
                    $where['l.sm_type'] = '理发';
                    $where['l.pc_time'] = ['between',[$start,$end]];
                    // $where['o.orderyouxiao'] = 1;
                    // $where['o.orderyouxiaodate'] = ['between',[$start,$end]];
                    $where['o.payment_money'] = ['>',899];
                    break;
                case 'lfyj':
                    $type = 'yeji';
                    $where['l.sm_type'] = '理发';
                    $where['l.pc_time'] = ['between',[$start,$end]];
                    break;
            }
            // 上门
            if ($type=='sm') {
                $return = db('crm_c_customerinfo')->alias('c')
                    ->join('crm_l_pc_log l','c.id=l.cid', 'LEFT')
                    ->join('c_customerorder o','l.id=o.crm_visit_id','LEFT')
                    ->where($where)
                    ->where('l.pc_time','between',[$start,$end])
                    ->field('c.id,c.customer_name,c.customer_tel,c.sign_name,c.customer_channel,DATE_FORMAT(c.baby_birthday, "%Y-%m-%d") as baby_birthday,DATE_FORMAT(c.ready_baby_day, "%Y-%m-%d") as ready_baby_day,DATE_FORMAT(l.pc_time, "%Y-%m-%d") as pc_time,l.pc_shop_name,o.orderId,o.orderyouxiaodate,o.payment_money')
                    ->order('sign_name,customer_channel')->group('c.id')->select();
            }else if ($type=='order') {
                $return = db('crm_c_customerinfo')->alias('c')
                    ->join('crm_l_pc_log l','c.id=l.cid', 'left')
                    ->join('c_customerorder o','l.id=o.crm_visit_id','LEFT')
                    ->join('c_paymentcontent p','p.orderId=o.orderId','LEFT')
                    ->join('c_paymenttype t','p.paytype=t.typename','LEFT')
                    ->where('o.payment_money','>=','899')
                    ->where('p.suoshu','in','前期款,前期补款')
                    ->where('t.typecode','实收')
                    ->where($where)->where('l.pc_time','between',[$start,$end])
                    ->field('c.id,c.customer_name,c.customer_tel,c.sign_name,c.customer_channel,DATE_FORMAT(c.baby_birthday, "%Y-%m-%d") as baby_birthday,DATE_FORMAT(c.ready_baby_day, "%Y-%m-%d") as ready_baby_day,DATE_FORMAT(l.pc_time, "%Y-%m-%d") as pc_time,l.pc_shop_name,o.orderId,o.orderyouxiaodate,o.payment_money')
                    ->order('sign_name,customer_channel')->group('c.id')->select();
            }else if ($type=='yeji') {
                $return = db('crm_c_customerinfo')->alias('c')
                    ->join('crm_l_pc_log l','c.id=l.cid', 'left')
                    ->join('c_customerorder o','l.id=o.crm_visit_id','LEFT')
                    ->join('c_paymentcontent p','p.orderId=o.orderId','LEFT')
                    ->join('c_paymenttype t','p.paytype=t.typename','LEFT')
                    ->where('o.payment_money','>','0')
                    ->where('p.suoshu','in','前期款,前期补款')
                    ->where('t.typecode','实收')
                    ->where($where)->where('l.pc_time','between',[$start,$end])
                    ->field('c.id,c.customer_name,c.customer_tel,c.sign_name,c.customer_channel,DATE_FORMAT(c.baby_birthday, "%Y-%m-%d") as baby_birthday,DATE_FORMAT(c.ready_baby_day, "%Y-%m-%d") as ready_baby_day,DATE_FORMAT(l.pc_time, "%Y-%m-%d") as pc_time,l.pc_shop_name,o.orderId,o.orderyouxiaodate,p.payment_money')
                    ->order('sign_name,customer_channel')->select();
            }
            $this->assign('type',$type);
            $this->assign('return',$return);
        }else{
            $this->assign('return',[]);
        }
        return $this->fetch();
    }
    // Xaf_ds_tg 报表 推广绩效数据统计
    public function Xaf_ds_tg_getDetail(){
        $param = input();
        $month = $param['month'];
        $start = date('Y-m-01 00:00:00',strtotime($month));
        $end = date('Y-m-d 23:59:59',strtotime($end.'+1 month -1 day'));
        if ((int)$param['staff_id']) {
            $where['c.c_from'] = 1;
            $where['c.is_status'] = 1;
            $where['c.is_loss'] = 2;
            $where['c.add_shop_code'] = $param['shop_code'];
            $where['c.dj_staff_id'] = $param['staff_id'];
            $where['c.customer_channel'] = $param['customer_channel'];
            $where['c.dj_day'] = ['between',[$start,$end]];
            switch ($param['sign']) {
                case 'ayyx':
                    $where['c.pinlei'] = '爱婴上门';
                    $where['c.is_valid']=1;
                    break;
                case 'aycd':
                    $where['pinlei'] = '爱婴上门';
                    $where['o.payment_money'] = ['>','0'];
                    break;
                case 'ayje':
                    $where['pinlei'] = '爱婴上门';
                    $where['o.payment_money'] = ['>','0'];
                    break;
                case 'mdyx':
                    $where['pinlei'] = '小阿福';
                    $where['c.is_valid']=1;
                    break;
                case 'mdcd':
                    $where['pinlei'] = '小阿福';
                    $where['o.payment_money'] = ['>','0'];
                    break;
                case 'mdje':
                    $where['pinlei'] = '小阿福';
                    $where['o.payment_money'] = ['>','0'];
                    break;
                case 'danyx':
                    $where['pinlei'] = '狄安娜';
                    $where['c.is_valid']=1;
                    break;
                case 'dancd':
                    $where['pinlei'] = '狄安娜';
                    $where['o.payment_money'] = ['>','0'];
                    break;
                case 'danje':
                    $where['pinlei'] = '狄安娜';
                    $where['o.payment_money'] = ['>','0'];
                    break;
                case 'htyx':
                    $where['pinlei'] = '花童喜宴';
                    $where['c.is_valid']=1;
                    break;
                case 'htcd':
                    $where['pinlei'] = '花童喜宴';
                    $where['o.payment_money'] = ['>','0'];
                    break;
                case 'htje':
                    $where['pinlei'] = '花童喜宴';
                    $where['o.payment_money'] = ['>','0'];
                    break;
            }
            $return = db('crm_c_customerinfo')->alias('c')
                ->join('c_customerorder o','c.customer_number=o.crm_customer_number','left')
                ->where($where)
                ->field('c.id,c.customer_name,c.customer_tel,c.customer_channel,DATE_FORMAT(c.dj_day, "%Y-%m-%d") as dj_day,c.dj_staff,c.add_shop_name')
                ->order('sign_name,customer_channel')->select();
            $this->assign('return',$return);
        }else{
            $this->assign('return',[]);
        }
        return $this->fetch();
    }
    //小阿福 爱婴导师业绩
    public function Xaf_aiying_ds_yeji_detail(){

        $param = input();
        $start = $param['start'];
        $end = $param['end'];
        $event = $param['event'];//表头
        $staff_name = $param['staff_name'];

        if ($param['staff_name']) {
            $table = '';
            $where['pc.is_delete'] = 2;
            $where['pc.status'] = ['<>',99];
            $where['pc.pc_time'] = ['between time',[$start, $end]];
            $where['pc.tutor_name'] = $staff_name;


            $pcWhere['is_delete'] = 2;
            $pcWhere['status'] = ['<>',99];
            $pcWhere['pc_time'] = ['between time',[$start, $end]];
            $pcWhere['tutor_name'] = $staff_name;

            switch ($event) {
                case 'yy_num':
                    $table = 'pc_log';
                    break;
                case 'pz_num':

                    $pcWhere['status'] = 2;
                    $pcWhere['sm_type'] = ['<>','理发'];
                    $table = 'pc_log';
                    break;
                case 'lf_num'://理发

                    $pcWhere['status'] = 2;
                    $pcWhere['sm_type'] = '理发';
                    $table = 'pc_log';
                    break;
                case 'cj_num'://超距

                    $pcWhere['is_chaoju'] = 1;
                    $table = 'pc_log';
                    break;
                case 'sy_order_num':

                    $where['photo.shop_code'] = $this->aiying_shop_code;//爱婴
                    $where['erp_order.total_money'] = ['>=',899];
                    $where['erp_order.consumption_type'] = ['not like','%三宝%'];

                    $table = 'order';
                    break;
                case 'sb_order_num':
                    $where['photo.shop_code'] = $this->aiying_shop_code;//爱婴
                    $where['erp_order.total_money'] = ['>=',199];
                    $where['erp_order.consumption_type'] = ['like','%三宝%'];

                    $table = 'order';
                    break;
                case 'lf_sb_order_money_xj':

                    $where['photo.shop_code'] = $this->aiying_shop_code;
                    $where['erp_order.consumption_type'] = ['like','%三宝%'];
                    $where['pc.sm_type'] = '理发';
                    $where['pay.paytype'] = '现金';
                    $table = 'pay';
                    break;
                case 'lf_sb_order_money_sk':
                    $where['photo.shop_code'] = $this->aiying_shop_code;
                    $where['erp_order.consumption_type'] = ['like','%三宝%'];
                    $where['pc.sm_type'] = '理发';
                    $where['pay.paytype'] = '刷卡';
                    $table = 'pay';
                    break;
                case 'lf_sb_order_money_vip':
                    $where['photo.shop_code'] = $this->aiying_shop_code;
                    $where['erp_order.consumption_type'] = ['like','%三宝%'];
                    $where['pc.sm_type'] = '理发';
                    $where['pay.paytype'] = 'VIP卡';
                    $table = 'pay';
                    break;
                case 'sb_order_money_xj':
                    $where['photo.shop_code'] = $this->aiying_shop_code;
                    $where['erp_order.consumption_type'] = ['like','%三宝%'];
                    $where['pay.paytype'] = '现金';
                    $table = 'pay';
                    break;
                case 'sb_order_money_sk':
                    $where['photo.shop_code'] = $this->aiying_shop_code;
                    $where['erp_order.consumption_type'] = ['like','%三宝%'];
                    $where['pay.paytype'] = '刷卡';
                    $table = 'pay';
                    break;
                case 'sb_order_money_vip':
                    $where['photo.shop_code'] = $this->aiying_shop_code;
                    $where['erp_order.consumption_type'] = ['like','%三宝%'];
                    $where['pay.paytype'] = 'VIP卡';
                    $table = 'pay';
                    break;

                case 'sy_order_money_xj':
                    $where['photo.shop_code'] = $this->aiying_shop_code;
                    $where['erp_order.consumption_type'] = ['not like','%三宝%'];
                    $where['erp_order.total_money'] = ['<',899];
                    $where['pay.paytype'] = '现金';
                    $table = 'pay';
                    break;
                case 'sy_order_money_sk':
                    $where['photo.shop_code'] = $this->aiying_shop_code;
                    $where['erp_order.consumption_type'] = ['not like','%三宝%'];
                    $where['erp_order.total_money'] = ['<',899];
                    $where['pay.paytype'] = '刷卡';
                    $table = 'pay';
                    break;
                case 'sy_order_money_vip':
                    $where['photo.shop_code'] = $this->aiying_shop_code;
                    $where['erp_order.consumption_type'] = ['not like','%三宝%'];
                    $where['erp_order.total_money'] = ['<',899];
                    $where['pay.paytype'] = 'VIP卡';
                    $table = 'pay';
                    break;

                case 'sy_order_money_two_xj':
                    $where['photo.shop_code'] = $this->aiying_shop_code;
                    $where['erp_order.consumption_type'] = ['not like','%三宝%'];
                    $where['erp_order.total_money'] = ['>=',899];
                    $where['pay.paytype'] = '现金';
                    $table = 'pay';
                    break;
                case 'sy_order_money_two_sk':
                    $where['photo.shop_code'] = $this->aiying_shop_code;
                    $where['erp_order.consumption_type'] = ['not like','%三宝%'];
                    $where['erp_order.total_money'] = ['>=',899];
                    $where['pay.paytype'] = '刷卡';
                    $table = 'pay';
                    break;
                case 'sy_order_money_two_vip':
                    $where['photo.shop_code'] = $this->aiying_shop_code;
                    $where['erp_order.consumption_type'] = ['not like','%三宝%'];
                    $where['erp_order.total_money'] = ['>=',899];
                    $where['pay.paytype'] = 'VIP卡';
                    $table = 'pay';
                    break;

                case 'cz_order_num'://充值单数

                    $where['photo.shop_code'] = $this->aiying_shop_code;
                    $where['pay.payclass'] = 3;//VIP卡充值
                    $table = 'cz_order_num';
                    break;
                case 'cz_order_money'://充值总额
                    $where['photo.shop_code'] = $this->aiying_shop_code;
                    $where['pay.payclass'] = 3;//VIP卡充值
                    $table = 'cz_order_money';
                    break;
                case 'vip_money'://会员卡余额

                    $where['photo.shop_code'] = $this->aiying_shop_code;//爱婴
                    $table = 'vip_money';
                    break;

                case 'cj_order_money_xj'://成交合计

                    $where['photo.shop_code'] = $this->aiying_shop_code;
                    $where['pay.paytype'] = '现金';
                    $table = 'pay';
                    break;
                case 'cj_order_money_sk':
                    $where['photo.shop_code'] = $this->aiying_shop_code;
                    $where['pay.paytype'] = '刷卡';
                    $table = 'pay';
                    break;
                case 'cj_order_money_vip'://会员卡余额
                    $where['photo.shop_code'] = $this->aiying_shop_code;
                    $where['pay.paytype'] = '刷卡';
                    $table = 'pay';
                    break;
            }

            if($table == 'pc_log'){
                $return = db('crm_l_pc_log')
                    ->alias('pc')
                    ->join('crm_c_customerinfo c','pc.cid = c.id')
                    ->field('pc.*,c.customer_name,c.customer_tel')
                    ->where($pcWhere)
                    ->select();
            }elseif($table == 'order'){
                $return = db('crm_l_pc_log')
                    ->alias('pc')
                    ->join('c_customerorder erp_order','pc.id=erp_order.crm_visit_id')
                    ->join('c_customerphoto photo','photo.orderId = erp_order.orderId and photo.currentfc = 1')
                    ->join('c_customerinfo c','erp_order.customerid = c.customerid')
                    ->where($where)
                    ->field('pc.*,c.wname,c.wphone,erp_order.orderId,erp_order.package_name,erp_order.targetdate,erp_order.consumption_type,erp_order.total_money,erp_order.payment_money,erp_order.storeconsuitant2')
                    ->select();
            }elseif($table == 'pay'){
                $return = db('crm_l_pc_log')
                    ->alias('pc')
                    ->join('c_customerorder erp_order','pc.id=erp_order.crm_visit_id')
                    ->join('c_customerphoto photo','photo.orderId = erp_order.orderId and photo.currentfc = 1')
                    ->join('c_paymentcontent pay','pay.orderId = photo.orderId and pay.currentfc = 1')
                    ->join('c_customerinfo c','erp_order.customerid = c.customerid')
                    ->where($where)
                    ->field('pc.*,c.wname,c.wphone,erp_order.orderId,erp_order.package_name,erp_order.targetdate,erp_order.consumption_type,erp_order.total_money,erp_order.payment_money as order_payment_money,erp_order.storeconsuitant2,pay.paytype,pay.payment_money,pay.paymentdate')
                    ->select();
            }elseif($table == 'cz_order_num' || $table == 'cz_order_money'){
                $return = db('crm_l_pc_log')
                    ->alias('pc')
                    ->join('c_customerorder erp_order','pc.id=erp_order.crm_visit_id')
                    ->join('c_customerphoto photo','photo.orderId = erp_order.orderId and photo.currentfc = 1')
                    ->join('c_paymentcontent pay','pay.orderId = photo.orderId and pay.currentfc = 1')
                    ->join('c_customerinfo c','erp_order.customerid = c.customerid')
                    ->where($where)
                    ->field('pc.*,c.wname,c.wphone,erp_order.orderId,erp_order.package_name,erp_order.targetdate,erp_order.consumption_type,erp_order.total_money,erp_order.payment_money as order_payment_money,erp_order.storeconsuitant2,pay.paytype,pay.payment_money,pay.paymentdate')
                    ->select();

            }elseif($table == 'vip_money'){
                //卡余
                $return = db('crm_l_pc_log')
                    ->alias('pc')
                    ->join('c_customerorder erp_order','pc.id=erp_order.crm_visit_id')
                    ->join('c_customerphoto photo','photo.orderId = erp_order.orderId and photo.currentfc = 1')
                    ->join('c_customerinfo cus','erp_order.customerid = cus.customerid')
                    ->join('c_vipcardinfo vip','cus.vipnum = vip.cardid')
                    ->where($where)
                    ->field('pc.*,cus.wname,cus.wphone,erp_order.orderId,erp_order.package_name,erp_order.targetdate,erp_order.consumption_type,erp_order.total_money,erp_order.payment_money as order_payment_money,erp_order.storeconsuitant2,vip.cardmoney')
                    ->select();
            }

            $this->assign('table',$table);
            $this->assign('return',$return);
        }else{
            $this->assign('return',[]);
        }
        return $this->fetch();
    }
    //小阿福 爱婴摄影师业绩
    public function Xaf_aiying_cameraman_yeji_detail(){

        $param = input();
        $start = $param['start'];
        $end = $param['end'];
        $event = $param['event'];//表头
        $staff_name = $param['staff_name'];

        if ($param['staff_name']) {
            $table = '';
            $where['pc.is_delete'] = 2;
            $where['pc.status'] = ['<>',99];
            $where['pc.pc_time'] = ['between time',[$start, $end]];
            $where['pc.cameraman_name'] = $staff_name;


            $pcWhere['is_delete'] = 2;
            $pcWhere['status'] = ['<>',99];
            $pcWhere['pc_time'] = ['between time',[$start, $end]];
            $pcWhere['cameraman_name'] = $staff_name;

            switch ($event) {
                case 'yy_num':
                    $table = 'pc_log';
                    break;
                case 'pz_num':

                    $pcWhere['status'] = 2;
                    $pcWhere['sm_type'] = ['<>','理发'];
                    $table = 'pc_log';
                    break;
                case 'lf_num'://理发

                    $pcWhere['status'] = 2;
                    $pcWhere['sm_type'] = '理发';
                    $table = 'pc_log';
                    break;
                case 'cj_num'://超距

                    $pcWhere['is_chaoju'] = 1;
                    $table = 'pc_log';
                    break;
                case 'sy_order_num':

                    $where['photo.shop_code'] = $this->aiying_shop_code;//爱婴
                    $where['erp_order.total_money'] = ['>=',899];
                    $where['erp_order.consumption_type'] = ['not like','%三宝%'];

                    $table = 'order';
                    break;
                case 'sb_order_num':
                    $where['photo.shop_code'] = $this->aiying_shop_code;//爱婴
                    $where['erp_order.total_money'] = ['>=',199];
                    $where['erp_order.consumption_type'] = ['like','%三宝%'];

                    $table = 'order';
                    break;
                case 'lf_sb_order_money_xj':

                    $where['photo.shop_code'] = $this->aiying_shop_code;
                    $where['erp_order.consumption_type'] = ['like','%三宝%'];
                    $where['pc.sm_type'] = '理发';
                    $where['pay.paytype'] = '现金';
                    $table = 'pay';
                    break;
                case 'lf_sb_order_money_sk':
                    $where['photo.shop_code'] = $this->aiying_shop_code;
                    $where['erp_order.consumption_type'] = ['like','%三宝%'];
                    $where['pc.sm_type'] = '理发';
                    $where['pay.paytype'] = '刷卡';
                    $table = 'pay';
                    break;
                case 'lf_sb_order_money_vip':
                    $where['photo.shop_code'] = $this->aiying_shop_code;
                    $where['erp_order.consumption_type'] = ['like','%三宝%'];
                    $where['pc.sm_type'] = '理发';
                    $where['pay.paytype'] = 'VIP卡';
                    $table = 'pay';
                    break;
                case 'sb_order_money_xj':
                    $where['photo.shop_code'] = $this->aiying_shop_code;
                    $where['erp_order.consumption_type'] = ['like','%三宝%'];
                    $where['pay.paytype'] = '现金';
                    $table = 'pay';
                    break;
                case 'sb_order_money_sk':
                    $where['photo.shop_code'] = $this->aiying_shop_code;
                    $where['erp_order.consumption_type'] = ['like','%三宝%'];
                    $where['pay.paytype'] = '刷卡';
                    $table = 'pay';
                    break;
                case 'sb_order_money_vip':
                    $where['photo.shop_code'] = $this->aiying_shop_code;
                    $where['erp_order.consumption_type'] = ['like','%三宝%'];
                    $where['pay.paytype'] = 'VIP卡';
                    $table = 'pay';
                    break;

                case 'sy_order_money_xj':
                    $where['photo.shop_code'] = $this->aiying_shop_code;
                    $where['erp_order.consumption_type'] = ['not like','%三宝%'];
                    $where['erp_order.total_money'] = ['<',899];
                    $where['pay.paytype'] = '现金';
                    $table = 'pay';
                    break;
                case 'sy_order_money_sk':
                    $where['photo.shop_code'] = $this->aiying_shop_code;
                    $where['erp_order.consumption_type'] = ['not like','%三宝%'];
                    $where['erp_order.total_money'] = ['<',899];
                    $where['pay.paytype'] = '刷卡';
                    $table = 'pay';
                    break;
                case 'sy_order_money_vip':
                    $where['photo.shop_code'] = $this->aiying_shop_code;
                    $where['erp_order.consumption_type'] = ['not like','%三宝%'];
                    $where['erp_order.total_money'] = ['<',899];
                    $where['pay.paytype'] = 'VIP卡';
                    $table = 'pay';
                    break;

                case 'sy_order_money_two_xj':
                    $where['photo.shop_code'] = $this->aiying_shop_code;
                    $where['erp_order.consumption_type'] = ['not like','%三宝%'];
                    $where['erp_order.total_money'] = ['>=',899];
                    $where['pay.paytype'] = '现金';
                    $table = 'pay';
                    break;
                case 'sy_order_money_two_sk':
                    $where['photo.shop_code'] = $this->aiying_shop_code;
                    $where['erp_order.consumption_type'] = ['not like','%三宝%'];
                    $where['erp_order.total_money'] = ['>=',899];
                    $where['pay.paytype'] = '刷卡';
                    $table = 'pay';
                    break;
                case 'sy_order_money_two_vip':
                    $where['photo.shop_code'] = $this->aiying_shop_code;
                    $where['erp_order.consumption_type'] = ['not like','%三宝%'];
                    $where['erp_order.total_money'] = ['>=',899];
                    $where['pay.paytype'] = 'VIP卡';
                    $table = 'pay';
                    break;

                case 'cz_order_num'://充值单数

                    $where['photo.shop_code'] = $this->aiying_shop_code;
                    $where['pay.payclass'] = 3;//VIP卡充值
                    $table = 'cz_order_num';
                    break;
                case 'cz_order_money'://充值总额
                    $where['photo.shop_code'] = $this->aiying_shop_code;
                    $where['pay.payclass'] = 3;//VIP卡充值
                    $table = 'cz_order_money';
                    break;
                case 'vip_money'://会员卡余额

                    $where['photo.shop_code'] = $this->aiying_shop_code;//爱婴
                    $table = 'vip_money';
                    break;

                case 'cj_order_money_xj'://成交合计

                    $where['photo.shop_code'] = $this->aiying_shop_code;
                    $where['pay.paytype'] = '现金';
                    $table = 'pay';
                    break;
                case 'cj_order_money_sk':
                    $where['photo.shop_code'] = $this->aiying_shop_code;
                    $where['pay.paytype'] = '刷卡';
                    $table = 'pay';
                    break;
                case 'cj_order_money_vip'://会员卡余额
                    $where['photo.shop_code'] = $this->aiying_shop_code;
                    $where['pay.paytype'] = '刷卡';
                    $table = 'pay';
                    break;
            }

            if($table == 'pc_log'){
                $return = db('crm_l_pc_log')
                    ->alias('pc')
                    ->join('crm_c_customerinfo c','pc.cid = c.id')
                    ->field('pc.*,c.customer_name,c.customer_tel')
                    ->where($pcWhere)
                    ->select();
            }elseif($table == 'order'){
                $return = db('crm_l_pc_log')
                    ->alias('pc')
                    ->join('c_customerorder erp_order','pc.id=erp_order.crm_visit_id')
                    ->join('c_customerphoto photo','photo.orderId = erp_order.orderId and photo.currentfc = 1')
                    ->join('c_customerinfo c','erp_order.customerid = c.customerid')
                    ->where($where)
                    ->field('pc.*,c.wname,c.wphone,erp_order.orderId,erp_order.package_name,erp_order.targetdate,erp_order.consumption_type,erp_order.total_money,erp_order.payment_money,erp_order.storeconsuitant2')
                    ->select();
            }elseif($table == 'pay'){
                $return = db('crm_l_pc_log')
                    ->alias('pc')
                    ->join('c_customerorder erp_order','pc.id=erp_order.crm_visit_id')
                    ->join('c_customerphoto photo','photo.orderId = erp_order.orderId and photo.currentfc = 1')
                    ->join('c_paymentcontent pay','pay.orderId = photo.orderId and pay.currentfc = 1')
                    ->join('c_customerinfo c','erp_order.customerid = c.customerid')
                    ->where($where)
                    ->field('pc.*,c.wname,c.wphone,erp_order.orderId,erp_order.package_name,erp_order.targetdate,erp_order.consumption_type,erp_order.total_money,erp_order.payment_money as order_payment_money,erp_order.storeconsuitant2,pay.paytype,pay.payment_money,pay.paymentdate')
                    ->select();
            }elseif($table == 'cz_order_num' || $table == 'cz_order_money'){
                $return = db('crm_l_pc_log')
                    ->alias('pc')
                    ->join('c_customerorder erp_order','pc.id=erp_order.crm_visit_id')
                    ->join('c_customerphoto photo','photo.orderId = erp_order.orderId and photo.currentfc = 1')
                    ->join('c_paymentcontent pay','pay.orderId = photo.orderId and pay.currentfc = 1')
                    ->join('c_customerinfo c','erp_order.customerid = c.customerid')
                    ->where($where)
                    ->field('pc.*,c.wname,c.wphone,erp_order.orderId,erp_order.package_name,erp_order.targetdate,erp_order.consumption_type,erp_order.total_money,erp_order.payment_money as order_payment_money,erp_order.storeconsuitant2,pay.paytype,pay.payment_money,pay.paymentdate')
                    ->select();

            }elseif($table == 'vip_money'){
                //卡余
                $return = db('crm_l_pc_log')
                    ->alias('pc')
                    ->join('c_customerorder erp_order','pc.id=erp_order.crm_visit_id')
                    ->join('c_customerphoto photo','photo.orderId = erp_order.orderId and photo.currentfc = 1')
                    ->join('c_customerinfo cus','erp_order.customerid = cus.customerid')
                    ->join('c_vipcardinfo vip','cus.vipnum = vip.cardid')
                    ->where($where)
                    ->field('pc.*,cus.wname,cus.wphone,erp_order.orderId,erp_order.package_name,erp_order.targetdate,erp_order.consumption_type,erp_order.total_money,erp_order.payment_money as order_payment_money,erp_order.storeconsuitant2,vip.cardmoney')
                    ->select();
            }

            $this->assign('table',$table);
            $this->assign('return',$return);
        }else{
            $this->assign('return',[]);
        }
        return $this->fetch();
    }

    /*
     * 小阿福 爱婴话务业绩报表详情(写了一半，暂时没用到)
     */
    public function Xaf_aiying_hw_yeji_detail(){

        $param = input();
        $start = $param['start'];
        $end = $param['end'];
        $event = $param['event'];//表头
        $staff_name = $param['staff_name'];

        if ($param['staff_name']) {
            $table = '';

            $cus_where['is_status'] = 1;
            $cus_where['c_from'] = 1;
            $cus_where['sales_staff'] = $staff_name;

            $c_pc_where['pc.is_delete'] = 2;
            $c_pc_where['pc.status'] = ['<>',99];
            $c_pc_where['pc.pc_time'] = ['between time',[$start, $end]];
            $c_pc_where['c.sales_staff'] = $staff_name;

            $sql = ' 1 = 1 ';
            switch ($event) {
                case 'yl_valid':

                    $cus_where['sign_name'] = '一类';
                    $cus_where['is_valid'] = 1;
                    $cus_where['baby_birthday'] = ['between time', [$start, $end]];
                    $table = 'cus';
                    break;
                case 'el_valid':

                    $cus_where['sign_name'] = '二类';
                    $cus_where['is_valid'] = 1;
                    $cus_where['baby_birthday'] = ['between time', [$start, $end]];
                    $table = 'cus';
                    break;
                case 'sl_valid':

                    $cus_where['sign_name'] = '三类';
                    $cus_where['is_valid'] = 1;
                    $cus_where['baby_birthday'] = ['between time', [$start, $end]];
                    $table = 'cus';
                    break;
                case 'invalid'://无效

                    $cus_where['is_valid'] = 3;
                    $cus_where['baby_birthday'] = ['between time', [$start, $end]];
                    $table = 'cus';
                    break;
                case 'csmd_valid'://出生名单有效

                    $cus_where['is_valid'] = 1;
                    $cus_where['baby_birthday'] = ['between time', [$start, $end]];
                    $sql .= ' AND baby_birthday is not null';
                    $table = 'cus';
                    break;
                case 'csmd_invalid'://出生名单无效

                    $cus_where['is_valid'] = 3;
                    $cus_where['baby_birthday'] = ['between time', [$start, $end]];
                    $sql .= ' AND baby_birthday is not null';
                    $table = 'cus';
                    break;

                case 'ycq_valid'://预产期有效

                    $cus_where['is_valid'] = 1;
                    $cus_where['baby_birthday'] = ['between time', [$start, $end]];
                    $sql .= ' AND ready_baby_day is not null';
                    $table = 'cus';
                    break;
                case 'ycq_invalid'://预产期无效

                    $cus_where['is_valid'] = 3;
                    $cus_where['baby_birthday'] = ['between time', [$start, $end]];
                    $sql .= ' AND ready_baby_day is not null';
                    $table = 'cus';
                    break;

                case 'yl_yy_num'://一类预约量

                    $c_pc_where['c.sign_name'] = '一类';
                    $table = 'cus_pc';
                    break;

                case 'yl_pz_num'://一类拍照量

                    $c_pc_where['c.sign_name'] = '一类';
                    $c_pc_where['pc.status'] = 2;
                    $c_pc_where['pc.sm_type'] = ['<>','理发'];

                    $table = 'cus_pc';
                    break;


            }

            if($table == 'cus'){

                $return =  db('crm_c_customerinfo')
                    ->where($cus_where)
                    ->where($sql)
                    ->select();

            }elseif($table == 'cus_pc'){

                $return =  db('crm_c_customerinfo')
                    ->alias('c')
                    ->join('crm_l_pc_log pc','c.id = pc.cid')
                    ->where($c_pc_where)
                    ->field('c.customer_number,c.customer_name,c.customer_tel,c.consultation_type,c.sign_name,pc.pc_time,pc.pc_shop_code')
                    ->select();

            }elseif($table == 'pay'){

            }elseif($table == 'cz_order_num' || $table == 'cz_order_money'){


            }elseif($table == 'vip_money'){

            }

            $this->assign('table',$table);
            $this->assign('return',$return);
        }else{
            $this->assign('return',[]);
        }
        return $this->fetch();
    }

    /*
     * 成都小组人员客资推广统计
     */
    public function Cd_group_staff_customer_detail(){
        if(request()->instance()->isAjax()){
            $data = input();

            $start = date('Y-m-d 00:00:00', strtotime($data['start']));
            $end = date('Y-m-d 23:59:59', strtotime($data['end']));

            $shop_code = $data['shop_code'];
            $group_id = $data['group_id'];

            $where['is_status'] = 1;
            $where['c_from'] = 1;
            $where['add_shop_code'] = $shop_code;
            $where['sales_group_id'] = $group_id;
            $where['dj_day'] = ['between time',[$start, $end]];

            $sql = 'is_status = 1 and c_from = 1 and add_shop_code = "'.$shop_code.'" and sales_group_id = "'.$group_id.'" and (dj_day between "'.$start.'" and "'.$end.'") ';

            // 消费类型
            if((int)$data['consultation_type_id']){
                $where['consultation_type_id'] = (int)$data['consultation_type_id'];
                $sql .= ' and consultation_type_id = '.(int)$data['consultation_type_id'];
            }

            // 渠道
            if ((int)$data['channel_id']) {
                $channelNames = explode(',',$data['customer_channel']);

                $channels = db('crm_s_channel')->where('channel_name', 'in' ,$channelNames)->select();
                $channelIds = array_column($channels,'id');
                $where['customer_channel_id'] = ['in',$channelIds];

                $sql .= ' and customer_channel_id in ('.explode(',',$channelIds).')';
            }


            if ($data['staff_id']) {
                $staff = [['id'=>$data['staff_id'],'staffname'=>$data['staffname']]];
            } else {
                //组下所有人
                $mcInterface = new mcInterface();
                $staff = $mcInterface->getStaffInfoByGid(['group_id'=>$group_id]);

            }

            $group = 'sales_staff';
            $cKey = 'sales_staff';

            $allCus = 'select
            sales_staff,
            COUNT(1) AS all_num,
            SUM(is_valid in (\'1\',\'5\')) AS valid_num,
            SUM(is_valid = 2) AS dd_num,
            SUM(is_valid in (\'3\',\'4\')) AS invalid_num,
            SUM(sign_name = "已预约") AS rd_num
            from crm_c_customerinfo
            WHERE '.$sql.'
            GROUP BY '.$group.'
            ';

            $sql1 = $allCus;
            $allNum = db()->query($allCus);
            $num = [];
            foreach($allNum as $k => $v){
                $num[$v['sales_staff']] = $v;
            }


            // 成交量  (实收金额大于等于500)
            $orderNum = db('crm_c_customerinfo')->alias('c')
                ->join('c_customerorder erp_order', 'erp_order.crm_customer_number=c.customer_number')
                ->where($where)
                ->where('erp_order.orderId is not null')
                ->where('erp_order.blankoutannal','<>',1)
                // ->where('erp_order.yixiaoshishou','>',0)
                ->where('erp_order.payment_money','>',0)
                ->where('erp_order.crm_order_type',1)
                // ->where('c.dj_day', 'between time', [$start, $end])
                ->where('erp_order.targetdate', 'between', [date('Ymd',strtotime($start)), date('Ymd',strtotime($end))])
                ->group($group)
                ->column('count(c.id) as num', $cKey);


            // 营收额（订单总额）
            $totalMoney = db('crm_c_customerinfo')->alias('c')
                ->join('c_customerorder erp_order','erp_order.crm_customer_number = c.customer_number')
                ->where($where)
                ->where('erp_order.orderId is not null')
                ->where('erp_order.blankoutannal','<>',1)
                // ->where('erp_order.yixiaoshishou','>',0)
                ->where('erp_order.payment_money','>',0)
                ->where('erp_order.crm_order_type',1)
                ->where('erp_order.targetdate', 'between', [date('Ymd',strtotime($start)), date('Ymd',strtotime($end))])
                ->group($group)
                ->column('sum(erp_order.total_money) as total_money', $cKey);

            // 实际收入（实收金额总和）
            $paymentMoney = db('crm_c_customerinfo')->alias('c')
                ->join('c_customerorder erp_order','erp_order.crm_customer_number = c.customer_number')
                ->join('c_paymentcontent pay','erp_order.orderId = pay.orderId')
                ->where($where)
                ->where('erp_order.crm_order_type',1)
                ->where('pay.shop_code',$shop_code)
                ->where('pay.paymentdate', 'between', [date('Ymd',strtotime($start)), date('Ymd',strtotime($end))])
                ->where('pay.suoshu', 'in', ['前期款','前期补款'])
                ->group($group)
                ->column('sum(pay.payment_money) as payment_money', $cKey);


            $returnData = [];

            $all = [];
            $all['staffname'] = '总计';

            foreach ($staff as $k => $v) {

                $returnData[$k]['staffname'] = $v['staffname'];

                $returnData[$k]['lrCustomer'] = $num[$v['staffname']]['all_num'] ? $num[$v['staffname']]['all_num'] : 0;
                $returnData[$k]['validCustomer'] = $num[$v['staffname']]['valid_num'] ? $num[$v['staffname']]['valid_num'] : 0;
                $returnData[$k]['invalidCustomer'] = $num[$v['staffname']]['invalid'] ? $num[$v['staffname']]['invalid'] : 0;
                $returnData[$k]['dd'] = $num[$v['staffname']]['dd_num'] ? $num[$v['staffname']]['dd_num'] : 0;
                $returnData[$k]['rdNum'] = $num[$v['staffname']]['rd_num'] ? $num[$v['staffname']]['rd_num'] : 0;

                $returnData[$k]['orderNum'] = $orderNum[$v['staffname']] ? $orderNum[$v['staffname']] : 0;
                $returnData[$k]['totalMoney'] = $totalMoney[$v['staffname']] ? $totalMoney[$v['staffname']] : '0.00';//营业总额
                $returnData[$k]['paymentMoney'] = $paymentMoney[$v['staffname']] ? $paymentMoney[$v['staffname']] : '0.00';//实收

                // 有效率（ 有效获取 / 毛客资 ）
                $returnData[$k]['validRate'] = (sprintf('%.2f', $returnData[$k]['validCustomer'] / $returnData[$k]['lrCustomer'] * 100)) . '%';
                //无效率 （ 无效客资 / 毛客资）
                $returnData[$k]['invalidRate'] = (sprintf('%.2f', $returnData[$k]['invalidCustomer'] / $returnData[$k]['lrCustomer'] * 100)) . '%';
                //待定率 （ 待定客资 / 毛客资）
                $returnData[$k]['ddRate'] = (sprintf('%.2f', $returnData[$k]['dd'] / $returnData[$k]['lrCustomer'] * 100)) . '%';
                //毛客资入店率
                $returnData[$k]['rdRate'] = (sprintf('%.2f', $returnData[$k]['rdNum'] / $returnData[$k]['lrCustomer'] * 100)) . '%';
                //有效客资入店率
                $returnData[$k]['validRdRate'] = (sprintf('%.2f', $returnData[$k]['rdNum'] / $returnData[$k]['validCustomer'] * 100)) . '%';
                //入店成交率(成交/入店)
                $returnData[$k]['rdOrderRate'] = (sprintf('%.2f', $returnData[$k]['orderNum'] / $returnData[$k]['rdNum'] * 100)) . '%';
                //毛客资成交率(成交/总客)
                $returnData[$k]['orderRate'] = (sprintf('%.2f', $returnData[$k]['orderNum'] / $returnData[$k]['lrCustomer'] * 100)) . '%';
                // 有效客资成交率（ 新单 / 有效客资 ）
                $returnData[$k]['validorderRate'] = (sprintf('%.2f', $returnData[$k]['orderNum'] / $returnData[$k]['validCustomer'] * 100)) . '%';
                //营业额
                $returnData[$k]['totalMoney'] = $totalMoney[$v['id']] ? sprintf('%.2f',$totalMoney[$v['id']]) : '0.00';
                //已收金额
                $returnData[$k]['paymentMoney'] = $paymentMoney[$v['id']] ? sprintf('%.2f',$paymentMoney[$v['id']]) : '0.00';


                $all['lrCustomer']  += $returnData[$k]['lrCustomer'];    //录入总计
                $all['validCustomer'] += $returnData[$k]['validCustomer'];     //有效总计
                $all['invalidCustomer'] += $returnData[$k]['invalidCustomer']; //无效总计
                $all['dd'] += $returnData[$k]['dd'];   //待定总计
                $all['rdNum']    += $returnData[$k]['rdNum'];    //入店量
                $all['orderNum'] += $returnData[$k]['orderNum']; //订单数总计
                $all['totalMoney']   += $returnData[$k]['totalMoney']; //营业额总计
                $all['paymentMoney']  += $returnData[$k]['paymentMoney']; //实收金额总计

            }

            // 有效率（ 有效获取 / 毛客资 ）
            $all['validRate'] = (sprintf('%.2f', $all['validCustomer'] / $all['lrCustomer'] * 100)) . '%';
            //无效率 （ 无效客资 / 毛客资）
            $all['invalidRate'] = (sprintf('%.2f', $all['invalidCustomer'] / $all['lrCustomer'] * 100)) . '%';
            //待定率 （ 待定客资 / 毛客资）
            $all['ddRate'] = (sprintf('%.2f', $all['dd'] / $all['lrCustomer'] * 100)) . '%';
            //毛客资入店率
            $all['rdRate'] = (sprintf('%.2f', $all['rdNum'] / $all['lrCustomer'] * 100)) . '%';
            //有效客资入店率
            $all['validRdRate'] = (sprintf('%.2f', $all['rdNum'] / $all['validCustomer'] * 100)) . '%';
            //入店成交率(成交/入店)
            $all['rdOrderRate'] = (sprintf('%.2f', $all['orderNum'] / $all['rdNum'] * 100)) . '%';
            //毛客资成交率(成交/总客)
            $all['orderRate'] = (sprintf('%.2f', $all['orderNum'] / $all['lrCustomer'] * 100)) . '%';
            // 有效客资成交率（ 新单 / 有效客资 ）
            $all['validorderRate'] = (sprintf('%.2f', $all['orderNum'] / $all['validCustomer'] * 100)) . '%';

            $all['totalMoney']   = $all['totalMoney'] ? $all['totalMoney'] : '0.00'; //营业额总计
            $all['paymentMoney'] = $all['paymentMoney'] ? $all['paymentMoney'] : '0.00'; //已收金额总计
            array_push($returnData,$all);

            $return['code'] = 0;
            $return['msg'] = '';
            $return['count'] = count($returnData);
            $return['data'] = $returnData;
            $return['sql1'] = $sql1;

            return json($return);
        }else{

            /* 暂时没用页面
             * $start
             * $end
             * $group_id
             * $consultation_type_id
             * $channel_id
             *
             */
            $data = input();
            $group_id = $data['group_id'];

            $start = date('Y-m-d', strtotime($data['start']));
            $end = date('Y-m-d', strtotime($data['end']));
            $consultation_type_id = (int)$data['consultation_type_id'];
            $channel_id = (int)$data['channel_id'];

            $mcInterface = new mcInterface();
            $data['staff'] = $mcInterface->getStaffInfoByGid(['group_id'=>$group_id]);

            $this->assign('data',$data);

            return $this->fetch();
        }
    }

    public function Cd_wx_staff_yeji_detail(){

        $data = input();

        $start = date('Y-m-d 00:00:00', strtotime($data['start']));
        $end = date('Y-m-d 23:59:59', strtotime($data['end']));
        $det = db('crm_s_report_form')->alias('f')->join('crm_s_report_detail d','d.form_id=f.id')->where('d.id',$data['did'])->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();

        //可操作店
        if($data['shop_code']){
            $shop_code = $data['shop_code'];
        }elseif($det['shop_code']){
            $shop_code = $det['shop_code'];
        }else{
            $shop_code = session('shop_code');
        }
        
        if(empty($shop_code)){
            return array('code'=>100,'msg'=>'请选择店面');
        }
        
        if ($data['customer_channel']) {
            $channels = explode(',',$data['customer_channel']);
            
        }elseif($data['erji_channel_id']){
            // 来源渠道
            $channels = explode(',',$data['erji_channel_id']);
        }else{
            $channels = controller('crm/Customer', 'lib')->getChannel($shop_code);
            $channels = array_column($channels,'channel_name');
        }

        $where['is_status'] = 1;
        $where['c_from'] = 1;
        $where['c.add_shop_code'] = $shop_code;
        //$where['fp_day'] = ['between time',[$start, $end]];
        if(!$data['sales_staff']){
            $this->assign('error','未获取到人员姓名');
            return $this->fetch();
        }
        $where['sales_staff'] = $data['sales_staff'];

        $group = 'sales_staff';
        $cKey = 'sales_staff';

        if($data['event'] == 'cus'){
            //总客资：当月总客资量（当月分配给网销的客资量）
            $arr = db('crm_c_customerinfo c')
                ->where($where)
                ->where('dj_day','between time',[$start, $end])
                ->where('customer_channel','in',$channels)
                ->select();
            $return['mkz'] = db()->getLastSql();
        }elseif($data['event'] == 'validNum'){
            //有效客资：当月有效客资+当月预约客资+当月已订单客资
            $arr = db('crm_c_customerinfo')
                ->alias('c')
                ->where($where)
                ->where("is_valid","in",['1','5'])
                ->where('dj_day','between time',[$start, $end])
                ->where('c.customer_channel','in',$channels)
                ->select();
            $return['yxkz'] = db()->getLastSql();
        }elseif($data['event'] == 'orderNum'){
             // 成交量  (实收金额大于等于500)
            $arr = db('crm_c_customerinfo')->alias('c')
                ->join('c_customerorder erp_order', 'erp_order.crm_customer_number=c.customer_number')
                ->where($where)
                ->where('erp_order.targetdate','between',[date('Y-m-d',strtotime($start)), date('Y-m-d',strtotime($end))])
                ->where('erp_order.orderId is not null')
                ->where('erp_order.blankoutannal','<>',1)
                // ->where('erp_order.yixiaoshishou','>',0)
                ->where('erp_order.payment_money','>',0)
                ->where('erp_order.crm_order_type',1)
                ->field('c.*,erp_order.bargain_money,erp_order.orderId,erp_order.targetdate')
                // ->group($group)
                ->select();
            $return['cjkz'] = db()->getLastSql();
        }elseif($data['event'] == 'totalMoney'){
             // 应收业绩（订单总额）
            $arr = db('crm_c_customerinfo')->alias('c')
                ->join('c_customerorder erp_order','erp_order.crm_customer_number = c.customer_number')
                ->where($where)
                ->where('c.customer_channel','in',$channels)
                ->where('erp_order.orderId is not null')
                ->where('erp_order.blankoutannal','<>',1)
                // ->where('erp_order.yixiaoshishou','>',0)
                ->where('erp_order.payment_money','>',0)
                ->where('erp_order.crm_order_type',1)
                ->where('erp_order.targetdate', 'between', [date('Ymd',strtotime($start)), date('Ymd',strtotime($end))])
                // ->group($group)
                ->field('c.*,erp_order.bargain_money,erp_order.orderId,erp_order.targetdate')
                ->select();
            $return['yinghsoue'] = db()->getLastSql();
        }elseif($data['event'] == 'paymentMoney'){
            // 总业绩（实收金额总和）
            $arr = db('crm_c_customerinfo')->alias('c')
                ->join('c_customerorder erp_order','erp_order.crm_customer_number = c.customer_number')
                ->join('c_paymentcontent pay','erp_order.orderId = pay.orderId')
                ->where($where)
                ->where('c.customer_channel','in',$channels)
                ->where('erp_order.crm_order_type',1)
                ->where('pay.shop_code',$shop_code)
                ->field('c.*,erp_order.yixiaoshishou,erp_order.orderId,erp_order.targetdate')
                ->where('pay.suoshu', 'in', ['前期款','前期补款'])
                ->where('pay.paymentdate','between',[date('Y-m-d',strtotime($start)), date('Y-m-d',strtotime($end))])
                // ->group($group)
                ->select();
            $return['shijishoukuan'] = db()->getLastSql();
        }elseif($data['event'] == 'cost'){
            //花费
            // 渠道花费
            $whereCost['shop_code'] = $shop_code;
            // $channels = controller('crm/Customer', 'lib')->getChannel($shop_code);
            // $channels = array_column($channels,'channel_name');
            $arr = db('crm_s_channel_cost')
                ->where('cost_date', 'between time', [$start, $end])
                ->where($whereCost)
                ->where('channel_name','in',$channels)
                // ->group('channel_name')
                ->select();
            $return['cost'] = db()->getLastSql();
        }
        $this->assign('sales_staff',$data['sales_staff']);
        $this->assign('method',$data['event']);
        $this->assign('data',$arr);

        return $this->fetch();
    }

    /**
     * 长沙芝麻宝贝 爱婴 爱婴部月报表 明细
     *
     * @param  start       开始时间
     * @param  end         结束时间
     * @param  event       明细数据 名 
     * @param  shop_code   
     *
     * @author lilong<lilong@suxuantech.cn>
     */
    public function Cszm_ay_month_data_detail(){
        $data = input();
        $start = date('Y-m-d 00:00:00', strtotime($data['start']));
        $end = date('Y-m-d 23:59:59', strtotime($data['end']));
        $shop_code = trim($data['shop_code']) ? trim($data['shop_code']) : session('shop_code');

        $event = $data['event'];
        switch ($event) {
            // 实收现金
            case 'ssxj':
                $returnHtml = controller('crm/Detail','lib')->getSsxj(['start'=>$start,'end'=>$end,'shop_code'=>$shop_code]);
                $this->assign('title',date('Y-m-d', strtotime($data['start'])).' 实收现金明细数据');
                $this->assign('sql',db()->getLastSql());
                break;
            // 卡销金额
            case 'kxje':
                $returnHtml = controller('crm/Detail','lib')->getSsxjByTpye(['start'=>$start,'end'=>$end,'shop_code'=>$shop_code,'paytype'=>'VIP卡']);
                $this->assign('title',date('Y-m-d', strtotime($data['start'])).' 卡销金额明细数据');
                $this->assign('sql',db()->getLastSql());
                break;
            // 代金券
            case 'djq':
                $returnHtml = controller('crm/Detail','lib')->getSsxjByTpye(['start'=>$start,'end'=>$end,'shop_code'=>$shop_code,'paytype'=>'代金券']);
                $this->assign('title',date('Y-m-d', strtotime($data['start'])).' 代金券明细数据');
                $this->assign('sql',db()->getLastSql());
                break;
            // 营收业绩
            case 'ysyj':
                $returnHtml = controller('crm/Detail','lib')->getSsxjByTpye(['start'=>$start,'end'=>$end,'shop_code'=>$shop_code,'paytype'=>'']);
                $this->assign('title',date('Y-m-d', strtotime($data['start'])).' 营收业绩明细数据');
                $this->assign('sql',db()->getLastSql());
                break;
            // 预约金
            case 'yyj':
                // $returnHtml = controller('crm/Detail','lib')->getOrderYx(['start'=>$start,'end'=>$end,'shop_code'=>$shop_code]);
                $returnHtml = controller('crm/Detail','lib')->getTaoxiMoneyByFundname(['start'=>$start,'end'=>$end,'shop_code'=>$shop_code,'fundname'=>'前期订金']);
                $this->assign('title',date('Y-m-d', strtotime($data['start'])).' 预约金明细数据');
                $this->assign('sql',db()->getLastSql());
                break;
            // 套系补款
            case 'txbk':
                $returnHtml = controller('crm/Detail','lib')->getTaoxiMoneyByFundname(['start'=>$start,'end'=>$end,'shop_code'=>$shop_code,'fundname'=>'前期补款']);
                $this->assign('title',date('Y-m-d', strtotime($data['start'])).' 套系补款明细数据');
                $this->assign('sql',db()->getLastSql());
                break;
            // 套系 订单金额 套系订单（包含成长+单次）
            case 'tx_ddje':
                $returnHtml = controller('crm/Detail','lib')->getAllTxMoney(['start'=>$start,'end'=>$end,'shop_code'=>$shop_code]);
                $this->assign('title',date('Y-m-d', strtotime($data['start'])).' 套系订单（包含成长+单次）订单金额明细数据');
                $this->assign('sql',db()->getLastSql());
                break;
            // 套系 订单量 套系订单（包含成长+单次）
            case 'tx_ddl':
                $returnHtml = controller('crm/Detail','lib')->getAllTxOrder(['start'=>$start,'end'=>$end,'shop_code'=>$shop_code]);
                $this->assign('title',date('Y-m-d', strtotime($data['start'])).' 套系订单（包含成长+单次）订单量明细数据');
                $this->assign('sql',db()->getLastSql());
                break;
            // 成长 订单金额
            case 'cz_ddje':
                $returnHtml = controller('crm/Detail','lib')->getAllTxMoney(['start'=>$start,'end'=>$end,'shop_code'=>$shop_code,'allfc'=>2]);
                $this->assign('title',date('Y-m-d', strtotime($data['start'])).' 成长套系订单 订单金额明细数据');
                $this->assign('sql',db()->getLastSql());
                break;
            // 成长 订单量
            case 'cz_ddl':
                $returnHtml = controller('crm/Detail','lib')->getAllTxOrder(['start'=>$start,'end'=>$end,'shop_code'=>$shop_code,'allfc'=>2]);
                $this->assign('title',date('Y-m-d', strtotime($data['start'])).' 成长套系订单 订单量明细数据');
                $this->assign('sql',db()->getLastSql());
                break;
            // 单次 订单金额
            case 'dc_ddje':
                $returnHtml = controller('crm/Detail','lib')->getAllTxMoney(['start'=>$start,'end'=>$end,'shop_code'=>$shop_code,'allfc'=>1]);
                $this->assign('title',date('Y-m-d', strtotime($data['start'])).' 单次订单 订单金额明细数据');
                $this->assign('sql',db()->getLastSql());
                break;
            // 单次 订单量
            case 'dc_ddl':
                $returnHtml = controller('crm/Detail','lib')->getAllTxOrder(['start'=>$start,'end'=>$end,'shop_code'=>$shop_code,'allfc'=>1]);
                $this->assign('title',date('Y-m-d', strtotime($data['start'])).' 单次订单 订单量明细数据');
                $this->assign('sql',db()->getLastSql());
                break;
            // 第一次服务 订单金额
            case 'dy_ddje':
                $returnHtml = controller('crm/Detail','lib')->getTaoxiMoneyByFundname(['start'=>$start,'end'=>$end,'shop_code'=>$shop_code,'fundname'=>'前期全款']);
                $this->assign('title',date('Y-m-d', strtotime($data['start'])).' 第一次服务 订单金额明细数据');
                $this->assign('sql',db()->getLastSql());
                break;
            // 第一次服务 订单量
            case 'dy_ddl':
                $returnHtml = controller('crm/Detail','lib')->getTaoxiOrderByFundname(['start'=>$start,'end'=>$end,'shop_code'=>$shop_code,'fundname'=>'前期全款']);
                $this->assign('title',date('Y-m-d', strtotime($data['start'])).' 第一次服务 订单量明细数据');
                $this->assign('sql',db()->getLastSql());
                break;
            // 三宝 订单金额
            case 'sb_ddje':
                $returnHtml = controller('crm/Detail','lib')->getTaoxiMoneyByFundname(['start'=>$start,'end'=>$end,'shop_code'=>$shop_code,'fundname'=>'三宝全款']);
                $this->assign('title',date('Y-m-d', strtotime($data['start'])).' 三宝业绩 订单金额明细数据');
                $this->assign('sql',db()->getLastSql());
                break;
            // 三宝 订单量
            case 'sb_ddl':
                $returnHtml = controller('crm/Detail','lib')->getTaoxiOrderByFundname(['start'=>$start,'end'=>$end,'shop_code'=>$shop_code,'fundname'=>'三宝全款']);
                $this->assign('title',date('Y-m-d', strtotime($data['start'])).' 三宝业绩 订单量明细数据');
                $this->assign('sql',db()->getLastSql());
                break;
            // 客资 采集量
            case 'cjl':
                $returnHtml = controller('crm/Detail','lib')->getCusinfo(['start'=>$start,'end'=>$end,'shop_code'=>$shop_code]);
                $this->assign('title',date('Y-m-d', strtotime($data['start'])).' 客资 采集量明细数据');
                $this->assign('sql',db()->getLastSql());
                break;
            // 客资 有效量
            case 'yxl':
                $returnHtml = controller('crm/Detail','lib')->getCusinfo(['start'=>$start,'end'=>$end,'shop_code'=>$shop_code,'is_valid'=>1]);
                $this->assign('title',date('Y-m-d', strtotime($data['start'])).' 客资 有效量明细数据');
                $this->assign('sql',db()->getLastSql());
                break;
            // 客资 预约量
            case 'yyl':
                $returnHtml = controller('crm/Detail','lib')->getCusYysm(['start'=>$start,'end'=>$end,'shop_code'=>$shop_code]);
                $this->assign('title',date('Y-m-d', strtotime($data['start'])).' 客资 预约量明细数据');
                $this->assign('sql',db()->getLastSql());
                break;
            // 客资 入户量
            case 'rhl':
                $returnHtml = controller('crm/Detail','lib')->getCusYysm(['start'=>$start,'end'=>$end,'shop_code'=>$shop_code,'status'=>'2,3']);
                $this->assign('title',date('Y-m-d', strtotime($data['start'])).' 客资 入户量明细数据');
                $this->assign('sql',db()->getLastSql());
                break;
            // 客资 拍摄量
            case 'psl':
                $returnHtml = controller('crm/Detail','lib')->getCusYysm(['start'=>$start,'end'=>$end,'shop_code'=>$shop_code,'status'=>2]);
                $this->assign('title',date('Y-m-d', strtotime($data['start'])).' 客资 拍摄量明细数据');
                $this->assign('sql',db()->getLastSql());
                break;
            // 客资 订单量
            case 'ddl':
                // $returnHtml = controller('crm/Detail','lib')->getCusYysm(['start'=>$start,'end'=>$end,'shop_code'=>$shop_code,'status'=>2]);
                $returnHtml = controller('crm/Detail','lib')->getTaoxiOrderByFundname(['start'=>$start,'end'=>$end,'shop_code'=>$shop_code,'fundname'=>'后期续订']);
                $this->assign('title',date('Y-m-d', strtotime($data['start'])).' 客资 订单量明细数据');
                $this->assign('sql',db()->getLastSql());
                break;
            // 门店到件
            case 'mddj':
                $returnHtml = controller('crm/Detail','lib')->getMddj(['start'=>$start,'end'=>$end,'shop_code'=>$shop_code]);
                $this->assign('title',date('Y-m-d', strtotime($data['start'])).' 取件数据 门店到件明细数据');
                $this->assign('sql',db()->getLastSql());
                break;
            // 取件
            case 'qj':
                $returnHtml = controller('crm/Detail','lib')->getQj(['start'=>$start,'end'=>$end,'shop_code'=>$shop_code]);
                $this->assign('title',date('Y-m-d', strtotime($data['start'])).' 取件数据 取件明细数据');
                $this->assign('sql',db()->getLastSql());
                break;
            // 误稿件
            case 'wgj':
                # code...
                $this->assign('title',date('Y-m-d', strtotime($data['start'])).' 取件数据 误稿件明细数据');
                $this->assign('sql',db()->getLastSql());
                break;
            // 误件
            case 'wj':
                $returnHtml = controller('crm/Detail','lib')->getWj(['start'=>$start,'end'=>$end,'shop_code'=>$shop_code]);
                $this->assign('title',date('Y-m-d', strtotime($data['start'])).' 取件数据 误件明细数据');
                $this->assign('sql',db()->getLastSql());
                break;
            // 返工
            case 'fg':
                $returnHtml = controller('crm/Detail','lib')->getFg(['start'=>$start,'end'=>$end,'shop_code'=>$shop_code]);
                $this->assign('title',date('Y-m-d', strtotime($data['start'])).' 取件数据 返工件明细数据');
                $this->assign('sql',db()->getLastSql());
                break;
            // 摄影组数
            case 'syzs':
                $returnHtml = controller('crm/Detail','lib')->getCusYyGroup(['start'=>$start,'end'=>$end,'shop_code'=>$shop_code]);
                $this->assign('title',date('Y-m-d', strtotime($data['start'])).' 完相数据 摄影组数明细数据');
                $this->assign('sql',db()->getLastSql());
                break;
        }
        // var_dump($returnHtml);die;
        $this->assign('returnHtml',$returnHtml);
        return $this->fetch();
    }

    /**
     * 成都马克叔叔 客服报表  明细
     *
     * @param  event       明细数据 名 
     * @param  day_type    时间类型 登记时间 dj_day 最后一次追踪时间 last_trackday
     * @param  start       开始时间
     * @param  end         结束时间
     * @param  shop_code   
     * @param  staff_type  员工类型 登记人 dj_staff 追踪人 sales_staff
     * @param  staff       员工
     * @param  consultation_type   消费类型
     * @param  channel     渠道名称（暂无）
     *
     * @author lilong<lilong@suxuantech.cn>
     */
    public function Mkss_staff_data_detail(){
        $data = input();
        $where['start']= date('Y-m-d 00:00:00', strtotime($data['start']));
        $where['end']  = date('Y-m-d 23:59:59', strtotime($data['end']));
        $shop_code = trim($data['shop_code']) ? trim($data['shop_code']) : session('shop_code');
        // 时间类型
        if ($data['day_type']=='dj_day') {
            $where['day_type'] = 'dj_day';
        }else if ($data['day_type']=='last_trackday') {
            $where['day_type'] = 'last_trackday';
        }else{
            $where['day_type'] = 'last_trackday';
        }
        // 消费类型
        if ($data['consultation_type']) {
            $where['c.consultation_type'] = ['in',$data['consultation_type']];
        }
        // 员工类型
        if ($data['staff_type']=='dj_staff') {
            $where['c.dj_staff'] = $data['staff'];
            $where['c.add_shop_code'] = $shop_code;
        }else{
            $where['c.sales_staff'] = $data['staff'];
            $where['c.shop_code'] = $shop_code;
        }

        $event = $data['event'];
        switch ($event) {
            // 订单金额
            case 'total':
                $returnHtml = controller('crm/Detail','lib')->mkssGetTotal($where);
                $this->assign('title',$data['staff'].' 订单金额明细数据');
                $this->assign('sql',db()->getLastSql());
                break;
            // 已收金额
            case 'fact':
                $returnHtml = controller('crm/Detail','lib')->mkssGetFact($where);
                $this->assign('title',$data['staff'].' 已收金额明细数据');
                $this->assign('sql',db()->getLastSql());
                break;
        }
        // var_dump($returnHtml);die;
        $this->assign('returnHtml',$returnHtml);
        return $this->fetch();
    }
    /**
     * 成都马克叔叔 电商员工业绩表  明细
     *
     * @param  event       明细数据 名 
     * @param  start       开始时间
     * @param  end         结束时间
     * @param  shop_code   
     * @param  staff       员工
     * @param  channel     渠道名称
     *
     * @author lilong<lilong@suxuantech.cn>
     */
    public function Mkss_wx_yj_data_detail(){
        $data = input();
        $where['start']= date('Y-m-d 00:00:00', strtotime($data['start']));
        $where['end']  = date('Y-m-d 23:59:59', strtotime($data['end']));
        $shop_code = trim($data['shop_code']) ? trim($data['shop_code']) : session('shop_code');
        $where['c.sales_staff'] = $data['staff'];
        $where['c.shop_code'] = $shop_code;
        // 消费类型
        if ($data['channel']) {
            $where['c.customer_channel'] = ['in',$data['channel']];
        }
        
        $event = $data['event'];
        switch ($event) {
            // 孕儿亲全订单量（不含99）
            case 'yeqqddl':
            // 孕儿亲全总服次数
            case 'yeqqzfc':
            // 孕儿亲全前期套系金额（不含99）
            case 'yeqqztxje':
                $where['type'] = 'yeqq';
                $returnHtml = controller('crm/Detail','lib')->mkssGetOrderInfos($where);
                $this->assign('title',$data['staff'].' 孕儿亲全明细数据');
                $this->assign('sql',db()->getLastSql());
                break;
            // 新生儿订单量（99元套系订单量）
            case 'xseddl':
                $where['type'] = 'xse';
                $returnHtml = controller('crm/Detail','lib')->mkssGetOrderInfos($where);
                $this->assign('title',$data['staff'].'  新生儿订单明细数据');
                $this->assign('sql',db()->getLastSql());
                break;
        }
        // var_dump($returnHtml);die;
        $this->assign('returnHtml',$returnHtml);
        return $this->fetch();
    }
    
}