<?php
/**
 * 报表实现类 网销追踪统计
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: wangzhenya 2019-11-26 $
 */
namespace app\crm\lib\report;
use app\crm\lib\Report;
use think\Controller;
use think\image\Exception;

class Customer_sales_data extends Report {

    private $level=1;
    private $type=1;
    private $code='code1568182674';

    public function getLevel(){
        return $this->level;

    }
    public function getType(){
        return $this->type;
    }
    public function getCode(){
        return $this->code;
    }
    public function data()
    {
        set_time_limit(0);
        $data = input();
        $det = db('crm_s_report_form')->alias('f')->join('crm_s_report_detail d','d.form_id=f.id')->where('d.id',$data['did'])->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name,f.report_name')->find();
        //可操作店
        if($data['shop_code']){
            $shop_code = $data['shop_code'];
        }elseif($det['shop_code']){
            $shop_code = $det['shop_code'];
        }else{
            $shop_code = session('shop_code');
        }
        if(empty($shop_code)){
            return array('code'=>100,'msg'=>'报表配置有误');
        }
        $start = $data['start'] ? date('Y-m-d', strtotime($data['start'])) : date('Y-m-d 00:00:00');
        $end =  $data['end'] ? date('Y-m-d 23:59:59', strtotime($data['end'])) : date('Y-m-d 23:59:59');

        $where['c_from'] = 1;
        $where['is_status'] = 1;
        $where['s.shop_code'] = $shop_code;
        if($data['staff_id']){
            $where['s.sales_staff_id'] = intval($data['staff_id']);
            $staff = controller('crm/Customer','lib')->get_staff_list(['id'=>intval($data['staff_id'])]);
        }else{
            //店下人员
            $staff = getStaffsByWorkType(['shop_code'=>$shop_code,'work_type'=>21]);
            $staffIds = array_column($staff,'id');
            $where['s.sales_staff_id'] = ['in',$staffIds];
        }
        $group = 's.sales_staff_id';

        $sql = "sum(dj_day between '".$start."' and '".$end."') as mkz,";//总录入
        $sql .= "sum(tel_alltime<>'' and tel_alltime is not null and s.sales_day between '".$start."' and '".$end."') as tel,";//拨打电话数
        $sql .= "sum((status=2 or status=3) and dj_day between '".$start."' and '".$end."') as sm,";//
        $sql .= "sum(targetdate between '".date('Ymd',strtotime($start))."' and '".date('Ymd',strtotime($end))."') as `order`";//成交

        $info= db('crm_c_customerinfo')->alias('c')->join('crm_c_salestrackinginfo s','c.id=customer_id','left')->join('crm_l_pc_log l','l.cid=c.id','left')->join('c_customerorder o','o.crm_order_type = 1 and o.crm_customer_number = c.customer_number and l.id=o.crm_visit_id','LEFT')
            ->where($where)
            ->group($group)
            ->column($sql,$group);
        $sql = db()->getLastSql();
        $return = [];
        $total['staff_name'] = '总计';
        foreach($staff as $k=>$v){
            $arr = [];
            $arr['staff_name'] = $v['staffname'];
            $arr['mkz'] = $info[$v['id']]['mkz'] ? $info[$v['id']]['mkz'] : 0;
            $arr['tel'] = $info[$v['id']]['tel'] ? $info[$v['id']]['tel'] : 0;
            $arr['sm'] = $info[$v['id']]['sm'] ? $info[$v['id']]['sm'] : 0;
            $arr['smRate'] = $info[$v['id']]['sm']/$info[$v['id']]['mkz']>0 ? sprintf('%.2f',$info[$v['id']]['sm']/$info[$v['id']]['mkz']*100).'%' : '';
            $arr['order'] = $info[$v['id']]['order'] ? $info[$v['id']]['order'] : 0;
            $arr['orderRate'] = $info[$v['id']]['order']/$info[$v['id']]['mkz']>0 ? sprintf('%.2f',$info[$v['id']]['order']/$info[$v['id']]['mkz']*100).'%' : '';
            array_push($return,$arr);

            $total['mkz'] += $info[$v['id']]['mkz'];
            $total['tel'] += $info[$v['id']]['tel'];
            $total['sm'] += $info[$v['id']]['sm'];
            $total['order'] += $info[$v['id']]['order'];
        }
        $total['smRate'] = $total['sm']/$total['mkz']>0 ? sprintf('%.2f',$total['sm']/$total['mkz']*100).'%' : '';
        $total['orderRate'] = $total['order']/$total['mkz']>0 ? sprintf('%.2f',$total['order']/$total['mkz']*100).'%' : '';
        array_push($return,$total);

        $returnData['code'] = 0;
        $returnData['msg'] = '';
        $returnData['count'] = count($return);
        $returnData['data'] = $return;
        $returnData['sql'] = $sql;
        return json($returnData);
    }

    public function show(){
        $code = $this->getCode();
        /*
        $did = strtolower(input('param.did'));
        $info = db('crm_s_report_form')->alias('f')->join('crm_s_report_detail d','d.form_id=f.id')->where('d.id',$did)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();*/
        $menu_code = strtolower(input('param.menu_code'));
        $info = db('crm_s_report_form')->alias('f')->join('crm_s_report_detail d','d.form_id=f.id','left')->where('f.code',$menu_code)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();

        $display = APP_PATH.'crm'.DS.'view'.DS.'report'.DS.strtolower($info['report_class_name']).'.html';
        $title = db('crm_s_report_form')->where('code', $code)->value('report_name');
        $shop= controller('crm/Customer','lib')->get_shop(['shop_code'=>$info['shop_code']]);
        $staff = getStaffsByWorkType(['shop_code'=>$info['shop_code'],'work_type'=>21]);
        $this->assign('shop_code', $info['shop_code']);
        $this->assign('staff', $staff);
        $this->assign('title', $shop[0]['shop_name'].'-'.$title);
        $this->assign('did', $info['id']);
        return $this->fetch($display);
    }

}