<?php
/**
 * 报表实现类 小阿福 客资标记汇总表
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: wangyining 2020-06-08 $
 */
namespace app\crm\lib\report;
use app\crm\lib\Report;
use think\Controller;
use think\image\Exception;

class Xaf_customer_bj_data extends Report {

    private $level=1;
    private $type=1;
    private $code='code1591608398';

    public function getLevel(){
        return $this->level;

    }
    public function getType(){
        return $this->type;
    }
    public function getCode(){
        return $this->code;
    }
    public function data()
    {
        set_time_limit(0);
        $data = input();

        $start = date('Y-m-d 00:00:00', strtotime($data['start']));
        $end = date('Y-m-d 23:59:59', strtotime($data['end']));
        $det = db('crm_s_report_form')->alias('f')->join('crm_s_report_detail d','d.form_id=f.id')->where('d.id',$data['did'])->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();

        $shop_code = $det['shop_code'];
        if(empty($shop_code)){
            return array('code'=>100,'msg'=>'报表配置有误');
        }


        $whereSql = 'is_status = 1 AND c_from = 1 AND add_shop_code = "'.$shop_code.'" AND dj_day between "'.$start.'" and "'.$end.'"';

        if($data['consultation_type_id']){
            $whereSql .= ' and consultation_type_id = "'.$data['consultation_type_id'].'"';
        }

        if($data['channel_id']){
            $whereSql .= ' and customer_channel_id = "'.$data['channel_id'].'"';
        }

        // 地域id，拼接where条件
        if ($data['province']) {
            $whereSql .= ' and province_id = "'.$data['province'].'"';
        }

        if ($data['city']) {
            $whereSql .= ' and city_id = "'.$data['city'].'"';
        }


        $sql = 'SELECT
                dj_staff,
                customer_channel,
                sum(IF(baby_birthday IS NULL , 1, 0))AS ycq_num,
                sum(IF(baby_birthday IS NOT NULL,1,0))AS csmd_num
            FROM
                crm_c_customerinfo
            WHERE ' .$whereSql . '
            group by dj_staff,customer_channel
            order by dj_staff,customer_channel
            ';

        $list = db()->query($sql);

        $ycq = 0;
        $csmd = 0;
        foreach($list as $k => $v){
            $ycq += $v['ycq_num'];
            $csmd += $v['csmd_num'];
        }
        $list[] = [
            'dj_staff' => '合计:',
            'customer_channel'=>'',
            'ycq_num'=>$ycq,
            'csmd_num'=>$csmd,
        ];

        $return['code'] = 0;
        $return['msg'] = '';
        $return['count'] = count($list);
        $return['data'] = $list;


        return json($return);

    }

    public function show(){
        /*
        $did = strtolower(input('param.did'));
        $info = db('crm_s_report_form')->alias('f')->join('crm_s_report_detail d','d.form_id=f.id')->where('d.id',$did)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();*/
        $menu_code = strtolower(input('param.menu_code'));
        $info = db('crm_s_report_form')->alias('f')->join('crm_s_report_detail d','d.form_id=f.id','left')->where('f.code',$menu_code)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();
        $city = db('crm_s_shop_address')->where('shop_code',$info['shop_code'])->where('type',2)->select();

        //消费类型
        $consumptionType = controller("Customer", "lib")->consumptionType(['brandclass_id'=>$info['brandclass_id']]);
        $this->assign("consumptionType", $consumptionType);

        // crm省    列表
        $data['type'] = 1;
        $data['shop_code'] = $info['shop_code'];
        $province = controller("Customer", "lib")->address($data);
        $this->assign('province', $province);

        //来源渠道
        $channel = controller("Customer", "lib")->getChannel($info['shop_code']);
        $this->assign("channel", $channel);

        $code = $this->getCode();
        $display = APP_PATH.'crm'.DS.'view'.DS.'report'.DS.strtolower($info['report_class_name']).'.html';
        $title = db('crm_s_report_form')->where('code', $code)->value('report_name');
        $shopInfo = controller('crm/Customer','lib')->get_shop(['shop_code'=>$info['shop_code']]);
        $this->assign('title', $shopInfo[0]['shop_name'].'-'.$title);
        $this->assign('did', $info['id']);
        return $this->fetch($display);
    }

}