<?php
/**
 * MC 接口模型，
 * 所有请求MC接口的，写到此类里，未来可以方便管理。
 * 
 * 接口返回false表示调用失败，非false的表示返回具体数据，注：有可能为空
 * 如果接口返回false 时，可以获取类的_code获性获得这个错误的代码，_msg获得错误描述
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: songdemei<songdemei@suxuantech.cn> 2018-01-30 $
 */
namespace app\common\lib;
use think\Controller;
use think\Exception;

class mcInterface extends Controller{
    var $_code = 0;
    var $_msg = '';
    var $_shopCode = '';
    function _initialize($shopCode = ''){
        $this->_shopCode = $shopCode;
    }
    public function retResult($res){
        if(!$res){
            $this->_code = -2;
            $this->_msg = '接口请求失败，请重试';
            return false;
        }
        if($res['error']){
            $this->_code = -1;
            $this->_msg = $res['error'];
            return false;
        }
        if($res['code'] != 200){
            $this->_code = $res['code'];
            $this->_msg = $res['msg'];
            return false;
        }
        return $res['data'];
    }
    /**
     * 获取集团信息  mc:Staff/groupCompany
     *
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getGName($params){
    	$cacheKey = 'mc_interface_5a6978bb82027_'.md5(json_encode($params));
        //如果需要缓存，即是那些查询类的，需要定义好缓存KEY，
        //并且在本类的cleanCache里加上清除的方法，
        //这样在公共的清除缓方法里，会调用此方法清除缓存
        if(cache('?'.$cacheKey)){
            return cache($cacheKey);
        }else{
            $res = sx_call('5a6978bb82027', $params);
            $return = $this->retResult($res);
            if($return !== false){
                cache($cacheKey,$return);
            }
        }
        return $return;
    }
    /**
     * 调mc获取登录二维码  mc:staff/getLoginQrCode
     *
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getLoginQrCode($params=[]){
        return sx_call('5a1027da4e9c1',$params);
    }
    /**
     * 发送短信  mc:system/sendSms
     *
     * @param  mobile       手机号
     * @param  content      短信内容
     * @param  send_time    发送时间，发果是立即发送不需要，格式：2017-01-01 15:22:56
     * @param  shop_code    调用短信的门店CODE，如果不传，取配置内默认第一个配置进行发送。传的话，取门店，品牌，集团，任意一个有配置的 
     * @param  brand_id     事业部ID，用作会员发短信。
     * @param  send_config  配置号，使用指定配置发短信 
     *
     * @author lilong<lilong@suxuantech.cn>
     */
    public function sendSms($params){
        return sx_call('5a17b86088f1a',$params);
    }
    /**
     * 修改密码密码  mc:Staff/resetPassword
     *
     * @param  telephone       员工手机号
     * @param  password        新密码
     *
     * @author lilong<lilong@suxuantech.cn>
     */
    public function resetPassword($params){
        return sx_call('5a1cb7e65cb5f',$params);
    }
    /**
     * 检测用户密码是否正确  mc:Staff/checkPassword
     *
     * @param  staffname       员工名
     * @param  password        新密码
     *
     * @author lilong<lilong@suxuantech.cn>
     */
    public function checkPassword($params){
        return sx_call('5a221c9548d47',$params);
    }
    /**
     * 根据某几个条件获取员工信息  Staff/staffInfo
     * 
     * @param  id              员工id
     * @param  staffname       员工姓名（非真实姓名）
     * @param  telephone       员工手机号
     * @param  shop_name       店
     * @param  shop_code       店
     * @param  department_name 部门 (含id)
     * @param  position_name   岗位 (含id)
     * @param  brandclass      事业部 (含id)
     * @param  get_leave       是否离职
     *
     * @return array
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getStaffInfo($params){
        $cacheKey = 'mc_interface_5a01766b4a3dd_'.md5(json_encode($params));
        //如果需要缓存，即是那些查询类的，需要定义好缓存KEY，
        //并且在本类的cleanCache里加上清除的方法，
        //这样在公共的清除缓方法里，会调用此方法清除缓存
        if(cache('?'.$cacheKey)){
            return cache($cacheKey);
        }else{
            $res = sx_call('5a01766b4a3dd', $params);
            $return = $this->retResult($res);
            if($return !== false){
                cache($cacheKey,$return);
            }
        }
        return $return;
    }

    /**
     * 某店面下人员信息（包括工作类型的集合） Staff/getShopStaffData
     * 
     * @param  id              员工id
     * @param  staffname       员工姓名（非真实姓名）
     * @param  telephone       员工手机号
     * @param  shop_name       店
     * @param  shop_code       店
     * @param  department_name 部门 (含id)
     * @param  position_name   岗位 (含id)
     * @param  brandclass      事业部 (含id)
     *
     * @return array
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getShopStaff($params){
        $cacheKey = 'mc_interface_5aafa4ac48058_'.md5(json_encode($params));
        if(cache('?'.$cacheKey)){
            return cache($cacheKey);
        }else{
            $res = sx_call('5aafa4ac48058', $params);
            $return = $this->retResult($res);
            if($return !== false){
                cache($cacheKey,$return);
            }
        }
        return $return;
    }
    /**
     * 店面下所有人员工作类型集合    Staff/getShopStaffWorkType
     * 
     * @param  shop_code      shop_code
     * 
     * @return array
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getStaffs($params){
        $cacheKey = 'mc_interface_5a574b13103b7_'.md5(json_encode($params));
        //如果需要缓存，即是那些查询类的，需要定义好缓存KEY，
        //并且在本类的cleanCache里加上清除的方法，
        //这样在公共的清除缓方法里，会调用此方法清除缓存
        if(cache('?'.$cacheKey)){
            return cache($cacheKey);
        }else{
            $res = sx_call('5a574b13103b7', $params);
            $return = $this->retResult($res);
            if($return !== false){
                cache($cacheKey,$return);
            }
        }
        return $return;
    }
    /**
     * 获取单个员工的信息   Staff/get_staff_info 
     * 
     * @param  id              员工id
     *
     * @return array
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getOneStaff($params){
        $cacheKey = 'mc_interface_59f933a395abe_'.md5(json_encode($params));
        if(cache('?'.$cacheKey)){
            return cache($cacheKey);
        }else{
            $res = sx_call('59f933a395abe', $params);
            $return = $this->retResult($res);
            if($return !== false){
                cache($cacheKey,$return);
            }
        }
        return $return;
    }
    /**
     * 查看员工在某个事业部下的可操作店  Staff/getWorkShop
     * 
     * @param  staff_id        员工id
     * @param  brandclass_id   事业部id
     * @param  shop_type       店面类型 
     * 
     * @return array
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getWorkShop($params){
        $cacheKey = 'mc_interface_5b9cac8aa21c0_'.md5(json_encode($params));
        if(cache('?'.$cacheKey)){
            return cache($cacheKey);
        }else{
            $res = sx_call('5b9cac8aa21c0', $params);
            $return = $this->retResult($res);
            if($return !== false){
                cache($cacheKey,$return);
            }
        }
        return $return;
    }
    /**
     * 给自动分配用的人员查询  Staff/getFpStaff 
     * 
     * @param  shop_code       员工id
     * @param  department_id   事业部id
     * @param  position_id     店面类型 
     * 
     * @return array
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getStaffInfoForFp($params){
        $cacheKey = 'mc_interface_5a0a624728618_'.md5(json_encode($params));
        if(cache('?'.$cacheKey)){
            return cache($cacheKey);
        }else{
            $res = sx_call('5a0a624728618', $params);
            $return = $this->retResult($res);
            if($return !== false){
                cache($cacheKey,$return);
            }
        }
        return $return;
    }
    /**
     * 获取渠道类型(一级)  channel/channelClass
     * 
     * @return array
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getChannelClass($params){
        $cacheKey = 'mc_interface_5a2757c0a9810_'.md5(json_encode($params));
        if(cache('?'.$cacheKey)){
            return cache($cacheKey);
        }else{
            $res = sx_call('5a2757c0a9810', $params);
            $return = $this->retResult($res);
            if($return !== false){
                cache($cacheKey,$return);
            }
        }
        return $return;
    }
    // 短信模板
    public function getSMSModel($param){
        $cacheKey = 'mc_interface_5d78e5b101c5c_'.md5(json_encode($param));
        //如果需要缓存，即是那些查询类的，需要定义好缓存KEY，
        //并且在本类的cleanCache里加上清除的方法，
        //这样在公共的清除缓方法里，会调用此方法清除缓存
        if(cache('?'.$cacheKey)){
            return cache($cacheKey);
        }else{
            $res = sx_call('5d78e5b101c5c', $param);

            $return = $this->retResult($res);
            if($return !== false){
                cache($cacheKey,$return);
            }
        }
        return $return;
    }
    /**
     * 获取来源渠道(二级)  Channel/channelInfo
     * 
     * @param  ChannelClass     渠道类型
     * 
     * @return array
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getChannelInfo($params){
        $cacheKey = 'mc_interface_59fd5e729e5a8_'.md5(json_encode($params));
        if(cache('?'.$cacheKey)){
            return cache($cacheKey);
        }else{
            $res = sx_call('59fd5e729e5a8', $params);
            $return = $this->retResult($res);
            if($return !== false){
                cache($cacheKey,$return);
            }
        }
        return $return;
    }
    /**
     * 根据门店编码，获取店下所有员工，包含兼职  
     * 
     * @param  shop_code    shop_code
     * @param  work_type    工作类型
     * @param  get_leave    是否离职 
     * @param  all          是否查看全部 
     * 
     * @return array
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getAllStaffListByShopcode($params){
        $cacheKey = 'mc_interface_5b75341456d18_'.md5(json_encode($params));
        if(cache('?'.$cacheKey)){
            return cache($cacheKey);
        }else{
            $res = sx_call('5b75341456d18', $params);
            $return = $this->retResult($res);
            if($return !== false){
                cache($cacheKey,$return);
            }
        }
        return $return;
    }
    /**
     * 岗位查询    Staff/position
     * 
     * @param  id             岗位id
     * @param  brandclass     事业部名称
     * @param  shop_code      shop_code
     * @param  department_id  部门id
     * @param  position_code  岗位code
     * 
     * @return array
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getPosition($params){
        $cacheKey = 'mc_interface_5a0b96b65c111_'.md5(json_encode($params));
        if(cache('?'.$cacheKey)){
            return cache($cacheKey);
        }else{
            $res = sx_call('5a0b96b65c111', $params);
            $return = $this->retResult($res);
            if($return !== false){
                cache($cacheKey,$return);
            }
        }
        return $return;
    }
    /**
     * 部门下员工查询    Staff/getDepartmentStaffs
     * 
     * @param  department_id  事业部名称
     * @param  get_leave      是否查看离职
     * @param  get_main       1:不查看兼职； 2:查看兼职； 
     * 
     * @return array
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getStaffByDepartment($params=[]){
        $cacheKey = 'mc_interface_5a0e6f272bb38_'.md5(json_encode($params));
        if(cache('?'.$cacheKey)){
            return cache($cacheKey);
        }else{
            $res = sx_call('5a0e6f272bb38', $params);
            $return = $this->retResult($res);
            if($return !== false){
                cache($cacheKey,$return);
            }
        }
        return $return;
    }
    /**
     * 部门查询    Staff/getDepartment
     *
     * @return array
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getDepartments($params=[]){
        $cacheKey = 'mc_interface_5a62dcd5c7e40_'.md5(json_encode($params));
        if(cache('?'.$cacheKey)){
            return cache($cacheKey);
        }else{
            $res = sx_call('5a62dcd5c7e40', $params);
            $return = $this->retResult($res);
            if($return !== false){
                cache($cacheKey,$return);
            }
        }
        return $return;
    }
    /**
     * 搜索员工     Staff/searchStaff 
     * 
     * @param  key_words      关键词，姓名或者手机号 
     * @param  shop_code      是否查看离职
     * @param  get_leave      是否查看离职
     * 
     * @return array
     * @author lilong<lilong@suxuantech.cn>
     */
    public function searchStaff($params=[]){
        $cacheKey = 'mc_interface_5aec138a7bae9_'.md5(json_encode($params));
        if(cache('?'.$cacheKey)){
            return cache($cacheKey);
        }else{
            $res = sx_call('5aec138a7bae9', $params);
            $return = $this->retResult($res);
            if($return !== false){
                cache($cacheKey,$return);
            }
        }
        return $return;
    }
    /**
     * 部门查询     Staff/department
     * 
     * @param  id          部门id
     * @param  shop_code   shop_code
     * 
     * @return array
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getDepartment($params=[]){
        $cacheKey = 'mc_interface_5a0aef152b750_'.md5(json_encode($params));
        if(cache('?'.$cacheKey)){
            return cache($cacheKey);
        }else{
            $res = sx_call('5a0aef152b750', $params);
            $return = $this->retResult($res);
            if($return !== false){
                cache($cacheKey,$return);
            }
        }
        return $return;
    }
    /**
     * MC地址字典     System/clientAddress
     * 
     * @param  id          
     * 
     * @return array
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getMcAddress($params){
        $cacheKey = 'mc_interface_59fd885ed3628_'.md5(json_encode($params));
        if(cache('?'.$cacheKey)){
            return cache($cacheKey);
        }else{
            $table = isTableExist('crm_s_address');

            if ($table) {
                if($params['type']){
                    $type='type = :type';
                    $typeArray=['type'=>$params['type']];
                }
                if($params['id']){
                    $sql = ' id in ('.$params['id'].')';
                }
                if($params['pid']){
                    $pid='pid = :pid';
                    $pidArray=['pid'=>$params['pid']];
                }
                if($params['name']){
                    $name='name like :name';
                    $nameArray=['name'=>'%'.$params['name'].'%'];
                }
                $detail=db('crm_s_address')->where($sql)->where($pid,$pidArray)->where($type,$typeArray)->where($name,$nameArray)->order('order_sort asc')->select();

                if($detail){
                    $res = array('code'=>200, 'data'=>$detail);
                }else{
                    $res = array('error'=>1,'code'=>202,'msg'=>'客户地址查询失败！');
                }
            }else{
                $res = sx_call('59fd885ed3628', $params);
            }
            
            $return = $this->retResult($res);
            
            if($return !== false){
                cache($cacheKey,$return);
            }
        }
        return $return;
    }
    public function getAddcustomerShopList($shopCode){
        $shopCode = $shopCode?$shopCode:$this->_shopCode;
        $res = sx_call('5a7076a6ccfaa',['shop_code'=>$shopCode]);
        return $this->retResult($res);
    }
    public function getCustomerResource($shopCode = ''){
        $res = sx_call('59fd5ec462c88',[]);
        return $this->retResult($res);
    }
    public function getCustomerArea(){
        $res = sx_call('5a004e9c3e030');
        return $this->retResult($res);
    }
    public function getCustomerRegin(){
        $res = sx_call('59fd5fa926b98');
        return $this->retResult($res);
    }
    public function getBrandShopList($brandId){
        $cacheKey = 'mc_interface_5a005e0038270_'.md5(json_encode($params));
        if(cache('?'.$cacheKey)){
            return cache($cacheKey);
        }else{
            $res = sx_call('5a005e0038270', $params);
            $return = $this->retResult($res);
            if($return !== false){
                cache($cacheKey,$return);
            }
        }
        return $return;

        // $res = sx_call('5a005e0038270');
        // return $this->retResult($res);
    }
    public function getStaffById($staffId){
        $res = sx_call('5a01766b4a3dd',['id'=>$staffId]);
        if($res['code'] == 200 && $res['data'][0]){
            return $this->retResult(['code'=>200,'data'=>$res['data'][0]]);
        }else{
            return $this->retResult($res);
        }
    }
    //通过staffids查询员工信息,逗号隔开
    public function getStaffByIds($staffId){
        $res = sx_call('5a18e3fa516a1',['staff_id'=>$staffId]);
        if($res['code'] == 200 && $res['data']){
            return $this->retResult(['code'=>200,'data'=>$res['data']]);
        }else{
            return $this->retResult($res);
        }
    }
    /**
     * 小组信息查询  Staff/getGroupInfo   
     * 
     * @param  brandclass_id  事业部id
     * @param  shop_code      shop_code
     * @param  department_id  部门id
     * @param  staff_id       员工id
     * 
     * @return array
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getGroupInfo($param){
        $cacheKey = 'mc_interface_5cc6ed5f19c60_'.md5(json_encode($param));
        //如果需要缓存，即是那些查询类的，需要定义好缓存KEY，
        //并且在本类的cleanCache里加上清除的方法，
        //这样在公共的清除缓方法里，会调用此方法清除缓存
        if(cache('?'.$cacheKey)){
            return cache($cacheKey);
        }else{
            $res = sx_call('5cc6ed5f19c60', $param);
            $return = $this->retResult($res);
            if($return !== false){
                cache($cacheKey,$return);
            }
        }
        return $return;
    }
    /**
     * 根据部门ID，获取部门下所有员工
     * 
     */
    public function getStaffListByDepartmentId($departmentId){
        $res = sx_call('5a01766b4a3dd',['department_id'=>$departmentId]);
        return $this->retResult($res);
    }
    /**
     * 根据门店编码，获取店下直属员工
     * 
     */
    public function getStaffListByShopcode($shopCode){
        $res = sx_call('5a01766b4a3dd',['shop_code'=>$shopCode,'grade_type'=>3]);
        return $this->retResult($res);
    }
    public function getAllStaffList($conditions){
        $cacheKey = 'mc_interface_5a7424f13aa54_'.md5(json_encode($conditions));
        $result = cache($cacheKey);
        if($result){
            return $result;
        }else{
            $url="5a7424f13aa54";
            $res = sx_call($url,$conditions);
            $result = $this->retResult($res);
            cache($cacheKey,$result);
            return $result;
        }
    }
    /**
     * 根据店号获取店下的所有部门
     * @param  [type] $shopCode [description]
     * @return [type]           [description]
     */
    public function getDepartmentByShopcode($shopCode){
        $res = sx_call('5a0aef152b750',['shop_code'=>$shopCode]);
        return $this->retResult($res);

    }
    /**
     * 获取部门信息
     * 
     * @param  [type] $departmentId [description]
     * @return [type]               [description]
     */
    public function getDepartmentById($departmentId){
        $res = sx_call('5a0aef152b750',['id'=>$departmentId]);
        if($res['data'][0]){
            return $this->retResult(['code'=>200,'data'=>$res['data'][0]]);
        }else{
            return $this->retResult($res);
        }

    }
    // 根据branclass 查事业部下所有的店
    public function getBrandShops($param){
        $data['brandclass'] = $param;
        $cacheKey = 'mc_interface_5a005e0038270_'.md5(json_encode($param));
        //如果需要缓存，即是那些查询类的，需要定义好缓存KEY，
        //并且在本类的cleanCache里加上清除的方法，
        //这样在公共的清除缓方法里，会调用此方法清除缓存
        if(cache('?'.$cacheKey)){
            return cache($cacheKey);
        }else{
            $res = sx_call('5a005e0038270', $data);
            $return = $this->retResult($res);
            if($return !== false){
                cache($cacheKey,$return);
            }
        }
        
        return $return;
    }

    public function getStaffsByShopCode($shopCode){
        $res = sx_call('5a01766b4a3dd',['shop_code'=>$shopCode,'grade_type'=>4]);
        return $this->retResult($res);
    }

    /**
     * 获取品牌信息，如果不传参数，则获取所有品牌数据，如果传了id或是brandclass则按ID或品牌名称获取某个品牌信息
     * 
     * @param  [Array] $params [按ID查时，传[id=>?],按名称查时，传[brandclass=>?]]
     * @return [Array]         [获取所有品牌时，返回的是二维数组，获取某个品牌信息时，返回的是一维数组]
     */
    public function getBrand($params){
        $cacheKey = 'mc_interface_5a3bbb5d0988d';
        //如果需要缓存，即是那些查询类的，需要定义好缓存KEY，
        //并且在本类的cleanCache里加上清除的方法，
        //这样在公共的清除缓方法里，会调用此方法清除缓存
        if(cache('?'.$cacheKey)){
            $return = cache($cacheKey);
        }else{
            $res = sx_call('5a3bbb5d0988d');
            $return = $this->retResult($res);
            if($return !== false){
                cache($cacheKey,$return);
            }
        }
        if($return){
            if($params['brandclass']){
                foreach ($return as $value) {
                    if($value['brandclass'] == $params['brandclass']){
                        $info = $value;
                    }
                }
                //指定条件时，如果没找到，返回空
                if(!$info){
                    $return = [];
                }else{
                    $return = $info;
                }
            }
            if($params['id']){
                foreach ($return as $value) {
                    if($value['id'] == $params['id']){
                        $info = $value;
                    }
                }
                //指定条件时，如果没找到，返回空
                if(!$info){
                    $return = [];
                }else{
                    $return = $info;
                }
            }
        }
        return $return;
    }

    // 根据shop_code 店面信息
    public function getShopInfo($param){
        // $data['shop_code'] = $param['shop_code'];
        $cacheKey = 'mc_interface_5a005e0038270_'.md5(json_encode($param));
        //如果需要缓存，即是那些查询类的，需要定义好缓存KEY，
        //并且在本类的cleanCache里加上清除的方法，
        //这样在公共的清除缓方法里，会调用此方法清除缓存
        if(cache('?'.$cacheKey)){
            return cache($cacheKey);
        }else{
            // $res = sx_call('5a005e0038270', $data);
            $res = sx_call('5a005e0038270', $param);
            $return = $this->retResult($res);
            if($return !== false){
                cache($cacheKey,$return);
            }
        }
        
        return $return;
    }
    public function getStaffList($condition){
        $cacheKey = 'mc_interface_all_staffs_data';

        if(cache('?'.$cacheKey)){
            $allStaff = cache($cacheKey);
        }else{
            $res = sx_call('5a01766b4a3dd', []);
            $allStaff = $this->retResult($res);
            // dump($allStaff);die;
            if($allStaff !== false){
                cache($cacheKey,$allStaff);
            }
        }
        $result = [];
        foreach ($allStaff as $key => $value) {
            
        }

    }
    /*
    public function getStaffById(){

    }*/

    /**
     * 清除缓存方法，清除除所有本类设置的缓存
     * 
     * @param  string $cacheName [description]
     * @return [type]            [description]
     */
    static function cleanCache($cacheName=''){
        if($cacheName){
            cache($cacheName.'*',null);
        }
        cache('mc_interface_*',null);
    }
    public function cacheData($hash,$data=[]){
        $cacheKey = "mc_interface_".md5($hash.serialize($data));
        if(cache('?'.$cacheKey)){
            return cache($cacheKey);
        }else{
            $res = sx_call($hash, $data);
            $return = $this->retResult($res);
            if($return !== false){
                cache($cacheKey,$return);
            }
        }
        return $return;
    }

    /*
       * 根据token
      */
    public function checkToken($staff_id,$token){
//        $cacheKey = 'mc_interface_5b3ae7a95f370_'.md5($token);
        //如果需要缓存，即是那些查询类的，需要定义好缓存KEY，
        //并且在本类的cleanCache里加上清除的方法，
        //这样在公共的清除缓方法里，会调用此方法清除缓存
//        if(cache('?'.$cacheKey)){
//            return cache($cacheKey);
//        }else{
        $res = sx_call('5b3ae7a95f370', ['staff_id'=>$staff_id,'token'=>$token]);
        $return = $this->retResult($res);
//            if($return !== false){
//                cache($cacheKey,$return);
//            }
//        }
        return $return;
    }

    /**
     * 根据部门id取部门下的组
     * 
     * @param  department_id 
     * @return 
     */
    public function getGroupInfoByDid($param) {
        $data['department_id'] = $param['department_id'];
        $cacheKey = 'mc_interface_5cc6ed5f19c60_'.md5(json_encode($param));
        //如果需要缓存，即是那些查询类的，需要定义好缓存KEY，
        //并且在本类的cleanCache里加上清除的方法，
        //这样在公共的清除缓方法里，会调用此方法清除缓存
        if(cache('?'.$cacheKey)){
            return cache($cacheKey);
        }else{
            $res = sx_call('5cc6ed5f19c60', $data);
            $return = $this->retResult($res);
            if($return !== false){
                cache($cacheKey,$return);
            }
        }
        
        return $return;
    }
    /**
     * 根据组id取组下的人 5cf8d76edd1ca
     * 
     * @param  group_id   
     * @return 
     */
    public function getStaffInfoByGid($param){
        $data['group_id'] = $param['group_id'];
        $cacheKey = 'mc_interface_5cf8d76edd1ca_'.md5(json_encode($param));
        //如果需要缓存，即是那些查询类的，需要定义好缓存KEY，
        //并且在本类的cleanCache里加上清除的方法，
        //这样在公共的清除缓方法里，会调用此方法清除缓存
        if(cache('?'.$cacheKey)){
            return cache($cacheKey);
        }else{
            $res = sx_call('5cf8d76edd1ca', $data);
            $return = $this->retResult($res);
            if($return !== false){
                cache($cacheKey,$return);
            }
        }
        return $return;
    }

    /**
     * 获取微信access_token 调mc接口
     * @param  wx_appid       微信app_id
     * @param  wx_secret      微信secret
     * @param  shop_code      shop_code
     * @param  brandclass_id  brandclass_id
     * @param  force          是否强制获取(1：强制获取，默认0)
     * @return array      
     */
    public function getAccessToken($param){
        $data['wx_appid'] = $param['wx_appid'];
        $data['wx_secret']= $param['wx_secret'];
        $data['shop_code']= $param['shop_code'];
        $data['brandclass_id']= $param['brandclass_id'];
        $data['force']    = $force ? $force : 0;
        $res = sx_call('5a603e4ea5c0c', $data);
        if ($res['code']==200) {
            $accessToken = $res['data']['access_token'];
        }
        return $accessToken;
    }

    /**
     * 获取客服人员 调mc接口
     * @param  param  条件         
     * @return array      
     */
    public function getWxKfStaff($param=[]){
        $res = sx_call('5f32641f028f0', $param);
        if ($res['code']==200) {
            $accessToken = $res['data'];
        }else{
            $accessToken = '';
        }
        return $accessToken;
    }

    /**
     * 获取微信会话列表1 调mc接口
     * @param  param  条件         
     * @return array      
     */
    public function wxTalkListJSON1($param){
        $res = sx_call('5f33978d6e6af', $param);
        if ($res['code']==200) {
            $accessToken = $res['data'];
        }else{
            $accessToken = '';
        }
        return $accessToken;
    }

    /**
     * 获取微信会话列表2 调mc接口
     * @param  param  条件         
     * @return array      
     */
    public function wxTalkListJSON2($param){
        if (!$param['staff_id']) {
            return array('code'=>100,'msg'=>'没有staff_id参数！');
        }
        $res = sx_call('5f3397a8a512a', $param);
        if ($res['code']==200) {
            $accessToken = $res['data'];
        }else{
            $accessToken = '';
        }
        return $accessToken;
    }

    /**
     * 获取微信会话页面 调mc接口
     * @param  param  条件         
     * @return array      
     */
    public function getKfTalk($param){
        if (!$param['id']) {
            return array('code'=>100,'msg'=>'没有id参数！');
        }
        $res = sx_call('5f339d2535459', $param);
        if ($res['code']==200) {
            $accessToken = $res['data'];
        }else{
            $accessToken = '';
        }
        return $accessToken;
    }

    /**
     * 发送消息 调mc接口
     * @param  param  条件         
     * @return array      
     */
    public function getWxKfTalk($param){
        // if (!$param['rid']) {
        //     return array('code'=>100,'msg'=>'没有id参数！');
        // }
        if (!$param['brandclass_id']) {
            return array('code'=>100,'msg'=>'没有brandclass_id参数！');
        }
        if (!$param['msg']) {
            return array('code'=>100,'msg'=>'没有发送信息！');
        }

        $res = sx_call('5f33ac035d292', $param);
        if ($res['code']==200) {
            $accessToken = $res['data'];
        }else{
            $accessToken = '';
        }
        return $accessToken;
    }

    /**
     * 获取最新消息 调mc接口
     * @param  param  条件         
     * @return array      
     */
    public function getWxNewMsg($param){
        if (!$param['rid']) {
            return array('code'=>100,'msg'=>'没有rid参数！');
        }
        if (!$param['tid']) {
            return array('code'=>100,'msg'=>'没有tid参数！');
        }
        if (!$param['kf_id']) {
            return array('code'=>100,'msg'=>'没有kf_id参数！');
        }
        $res = sx_call('5f34afb5582c2', $param);
        if ($res['code']==200) {
            $accessToken = $res['data'];
        }else{
            $accessToken = '';
        }
        return $accessToken;
    }

    /**
     * 更新已读消息 调mc接口
     * @param  param  条件         
     * @return array      
     */
    public function getUpdateMsg($param){
        if (!$param['rid']) {
            return array('code'=>100,'msg'=>'没有rid参数！');
        }
        if (!$param['tid']) {
            return array('code'=>100,'msg'=>'没有tid参数！');
        }
        $res = sx_call('5f3629f1f295b', $param);
        if ($res['code']==200) {
            $accessToken = $res['data'];
        }else{
            $accessToken = '';
        }
        return $accessToken;
    }
    
    /**
     * 根据客户openid 获取该客户的 聊天记录 调mc接口
     * @param  param  条件         
     * @return array      
     */
    public function getTalkByOpenid($param){
        $res = sx_call('5f34caa21cf48', $param);
        if ($res['code']==200) {
            $accessToken = $res['data'];
        }else{
            $accessToken = '';
        }
        return $accessToken;
    }

    /**
     * 获取微信表情 调mc接口
     * @param  param  条件         
     * @return array      
     */
    public function getWxTupian($param=[]){
        $cacheKey = 'mc_interface_5f34b6e6247f5_'.md5(json_encode($param));
        //如果需要缓存，即是那些查询类的，需要定义好缓存KEY，
        //并且在本类的cleanCache里加上清除的方法，
        //这样在公共的清除缓方法里，会调用此方法清除缓存
        if(cache('?'.$cacheKey)){
            return cache($cacheKey);
        }else{
            $res = sx_call('5f34b6e6247f5', $data);
            $return = $this->retResult($res);
            if($return !== false){
                cache($cacheKey,$return);
            }
        }
        return $return;
    }

    /**
     * 分配客服 调mc接口
     * @param  param  条件         
     * @return array      
     */
    public function getWxAllotKf($param){
        if (!$param['id']) {
            return array('code'=>100,'msg'=>'没有id参数！');
        }
        if (!$param['kf_id']) {
            return array('code'=>100,'msg'=>'没有kf_id参数！');
        }
        $res = sx_call('5f34fff504b5b', $param);
        if ($res['code']==200) {
            $accessToken = $res['data'];
        }else{
            $accessToken = '';
        }
        return $accessToken;
    }

    /**
     * 获取素材列表 调mc接口
     * @param  param  条件         
     * @return array      
     */
    public function getWxSource($param){
        if (!$param['brandclass_id']) {
            return array('code'=>100,'msg'=>'没有brandclass_id参数！');
        }
        
        $res = sx_call('5f3a3b4a2811d', $param);
        if ($res['code']==200) {
            $accessToken = $res['data'];
        }else{
            $accessToken = '';
        }
        return $accessToken;
    }

    /**
     * 获取客服人员管理 调mc接口
     * @param  param  条件         
     * @return array      
     */
    public function getWxKfStaffToJSON($param=[]){
        $res = sx_call('5f3b6a32962df', $param);
        if ($res['code']==200) {
            $accessToken = $res['data'];
        }else{
            $accessToken = '';
        }
        return $accessToken;
    }

    /**
     * 添加客服人员 调mc接口
     * @param  param  条件         
     * @return array      
     */
    public function getWxAddkf($param){
        if (!$param['brandclass_id'] && !$param['shop_code']) {
            return array('code'=>100,'msg'=>'没有brandclass_id参数 或 shop_code参数！');
        }
        if (!$param['staff_id']) {
            return array('code'=>100,'msg'=>'没有staff_id参数！');
        }
        if (!$param['kf_account']) {
            return array('code'=>100,'msg'=>'没有kf_account参数！');
        }
        if (!$param['kf_nick']) {
            return array('code'=>100,'msg'=>'没有kf_nick参数！');
        }
        if (!$param['kf_wx']) {
            return array('code'=>100,'msg'=>'没有kf_wx参数！');
        }
        $res = sx_call('5f3b7022ee5df', $param);
        
        if ($res['code']==200) {
            $accessToken = $res['data'];
        }else{
            $accessToken = '';
        }
        return $accessToken;
    }
    /**
     * 修改客服人员 调mc接口
     * @param  param  条件         
     * @return array      
     */
    public function getWxEditkf($param){
        if (!$param['brandclass_id']) {
            return array('code'=>100,'msg'=>'没有brandclass_id参数！');
        }
        if (!$param['staff_id']) {
            return array('code'=>100,'msg'=>'没有staff_id参数！');
        }
        if (!$param['kf_account']) {
            return array('code'=>100,'msg'=>'没有kf_account参数！');
        }
        if (!$param['kf_nick']) {
            return array('code'=>100,'msg'=>'没有kf_nick参数！');
        }
        if (!$param['id']) {
            return array('code'=>100,'msg'=>'没有id参数！');
        }
        $res = sx_call('5f3b88b12e7d0', $param);
        if ($res['code']==200) {
            $accessToken = $res['data'];
        }else{
            $accessToken = '';
        }
        return $accessToken;
    }
    /**
     * 删除客服人员 调mc接口
     * @param  param  条件         
     * @return array      
     */
    public function getWxDelkf($param){
        if (!$param['brandclass_id']) {
            return array('code'=>100,'msg'=>'没有brandclass_id参数！');
        }
        if (!$param['id']) {
            return array('code'=>100,'msg'=>'没有id参数！');
        }
        $res = sx_call('5f3b8add08911', $param);
        if ($res['code']==200) {
            $accessToken = $res['data'];
        }else{
            $accessToken = '';
        }
        return $accessToken;
    }
    /**
     * 生成二维码 调mc接口
     * @param  param  条件         
     * @return array      
     */
    public function getWxQRorder($param){
        if (!$param['brandclass_id']) {
            return array('code'=>100,'msg'=>'没有brandclass_id参数！');
        }
        $res = sx_call('5f3ba72e9d8a8', $param);
        if ($res['code']==200) {
            $accessToken = $res['data'];
        }else{
            $accessToken = '';
        }
        return $accessToken;
    }

    /**
     * 获取微信自定义菜单 调mc接口
     * @param  param  条件         
     * @return array      
     */
    public function getWxMenu($param){
        if (!$param['brandclass_id']) {
            return array('code'=>100,'msg'=>'没有brandclass_id参数！');
        }
        $res = sx_call('5f3c8fa2561a0', $param);
        if ($res['code']==200) {
            $accessToken = $res['data'];
        }else{
            $accessToken = '';
        }
        return $accessToken;
    }
    /**
     * 设定微信menu菜单 调mc接口
     * @param  menu           菜单（数组）
     * @param  shop_code      客资传shop_code
     * @param  brandclass_id  会员或者其他系统可能需要用到事业部ID
     * @return array      
     */
    public function setWxMenu($param){

        if (!$param['brandclass_id'] && !$param['shop_code']) {
            return array('code'=>100,'msg'=>'没有brandclass_id或shop_code参数！');
        }
        $res = sx_call('5f9bcfecbd05d', $param);
        // var_dump($res);die;
        // if ($res['code']==200) {
        //     $accessToken = $res['data'];
        // }else{
        //     $accessToken = '';
        // }
        // return $accessToken;
        return $res;
    }
    /**
     * 微信新增菜单 调mc接口
     * @param  param  条件         
     * @return array      
     */
    public function getWxAddMenuSet($param){
        if (!$param['brandclass_id']) {
            return array('code'=>100,'msg'=>'没有brandclass_id参数！');
        }
        $res = sx_call('5f3c9c4b07bc4', $param);
        if ($res['code']==200) {
            $accessToken = $res['data'];
        }else{
            $accessToken = '';
        }
        return $accessToken;
    }

    /**
     * 微信新增菜单写入 调mc接口
     * @param  param  条件         
     * @return array      
     */
    public function getWxAddMenu($param){

        $res = sx_call('5f3cb81ecc895', $param);
        if ($res['code']==200) {
            $accessToken = $res['data'];
        }else{
            $accessToken = '';
        }
        return $accessToken;
    }

    /**
     * 微信删除菜单 调mc接口
     * @param  param  条件         
     * @return array      
     */
    public function getWxDelMenu($param){
        if (!$param['id']) {
            return array('code'=>100,'msg'=>'没有id参数！');
        }

        $res = sx_call('5f3cc835b031c', $param);
        if ($res['code']==200) {
            $accessToken = $res['data'];
        }else{
            $accessToken = '';
        }
        return $accessToken;
    }

    /**
     * 初始化微信菜单 调mc接口
     * @param  param  条件         
     * @return array      
     */
    public function getWxSetWxmenu($param){
        if (!$param['brandclass_id']) {
            return array('code'=>100,'msg'=>'没有brandclass_id参数！');
        }

        $res = sx_call('5f3cca0071020', $param);
        if ($res['code']==200) {
            $accessToken = $res['data'];
        }else{
            $accessToken = '';
        }
        return $accessToken;
    }

    /**
     * 获取自动回复列表列表 调mc接口
     * @param  param  条件         
     * @return array      
     */
    public function getWxAutoAnswerList($param){

        $res = sx_call('5f3cd67174c71', $param);
        if ($res['code']==200) {
            $accessToken = $res['data'];
        }else{
            $accessToken = '';
        }
        return $accessToken;
    }

    /**
     * 获取回复详情 调mc接口
     * @param  param  条件         
     * @return array      
     */
    public function getAnswerDetail($param){
        if (!$param['id']) {
            return array('code'=>100,'msg'=>'没有id参数！');
        }
        
        $res = sx_call('5f3cd9fa71bf7', $param);
        if ($res['code']==200) {
            $accessToken = $res['data'];
        }else{
            $accessToken = '';
        }
        return $accessToken;
    }

    /**
     * 获取微信公众号自动回复 调mc接口
     * @param  param  条件         
     * @return array      
     */
    public function geWxtAutoAnswer($param){
        if (!$param['brandclass_id']) {
            return array('code'=>100,'msg'=>'没有brandclass_id参数！');
        }
        if (!$param['staff_id']) {
            return array('code'=>100,'msg'=>'没有staff_id参数！');
        }
        if (!$param['staff_name']) {
            return array('code'=>100,'msg'=>'没有staff_name参数！');
        }
        
        $res = sx_call('5f3ce8b53f53b', $param);
        if ($res['code']==200) {
            $accessToken = $res['data'];
        }else{
            $accessToken = '';
        }
        return $accessToken;
    }
    /**
     * 获取微信 最新消息 给设定的管理员发送消息 （弹窗，带上会话列表的链接）
     * @param  param  条件         
     * @return array      
     */
    public function getWxsendSystemMessage($param=[]){
        
        $res = sx_call('5f434d2fcdd52', $param);
        if ($res['code']==200) {
            $accessToken = $res['data'];
        }else{
            $accessToken = '';
        }
        return $accessToken;
    }

    /**
     * 发送消息(直接调取微信接口) 调mc接口
     * @param  sendPost                       
     *               $sendPost['touser'] = $info['openid'];
     *               $sendPost['msgtype'] = 'text';
     *               $sendPost['text']['content'] = $msg;
     *               $sendPost['customservice']['kf_account'] = $info['kf_account'];
     * @return array      
     */
    public function getWxSendMessage($param){
        if (!$param['touser']) {
            return array('code'=>100,'msg'=>'没有touser参数！');
        }
        if (!$param['msgtype']) {
            return array('code'=>100,'msg'=>'没有msgtype参数！');
        }
        if (!$param['customservice']['kf_account']) {
            return array('code'=>100,'msg'=>'没有customservice-kf_account参数！');
        }

        $res = sx_call('5f32711801d34', $param);
        if ($res['code']==200) {
            $accessToken = $res['data'];
        }else{
            $accessToken = '';
        }
        return $accessToken;
    }
    /**
     * 上传临时素材 调mc接口
     * @param  sendPost                       
     *               $sendPost['touser'] = $info['openid'];
     *               $sendPost['msgtype'] = 'text';
     *               $sendPost['text']['content'] = $msg;
     *               $sendPost['customservice']['kf_account'] = $info['kf_account'];
     * @return array      
     */
    public function getWxSendTemporaryMaterial($param){
        if (!$param['url']) {
            return array('code'=>100,'msg'=>'没有url参数！');
        }

        $res = sx_call('5f32714d7088a', $param);
        if ($res['code']==200) {
            $accessToken = $res['data'];
        }else{
            $accessToken = '';
        }
        return $accessToken;
    }

    /*
     * 可操作店包括某店面的，某个工作类型（人员设定中勾选）的所有在职员工
     * 5bc58874c5828
     * $shop_code   多个用英文逗号隔开
     * $work_type
     */
    public function getStaffsByShopWorkType($params){
        $res = sx_call('5bc58874c5828', $params);
        if ($res['code']==200) {
            $data = $res['data'];
        }else{
            $data = '';
        }
        return $data;
    }
}