<?php

/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
namespace app\crm\command;
use think\console\Command;
use think\console\Input;
use think\console\Output;

class Oui extends Command{

    protected function configure()
    {
        $this->setName('oui')->setDescription('Suxuan oui service: data statistics');
    }
    
    protected function execute(Input $input, Output $output)
    {
       
		$file = '/data/suxuan/oui.txt';
		$data = file($file,FILE_IGNORE_NEW_LINES);
		$count = 0;
		foreach ($data as $key => $value) {
			if(strpos($value, '(hex)')){
				$count++;
			}
		}

		$a = new progressTools(1,2,[$count]);
		$insert = null;
		$do = 0;
		foreach ($data as $key => $value) {
			if(strpos($value, '(base 16)')){
				$do++;
				$a->updateProgressValue(0,$do);
				$line = explode("(base 16)", $value);
				if($dbdata){
					//处理一下上一条
					$find = db('oui')->where('mac',trim($dbdata['mac']))->count();
					if(!$find){
						$insert[] = $dbdata;
					}
					if(count($insert) > 1000){
						db('oui')->insertAll($insert);
						// var_dump($insert);
						$insert = null;
					}
				}
				//本条信息
				$dbdata = [
					'mac'=>trim($line[0]),
					'comany_name'=>trim($line[1],"\t"),
					'company_address'=>'',
					'create_time'=>date('Y-m-d H:i:s'),
				];
			}else{
				if($dbdata && strpos($value, '(hex)') === false){
					$dbdata['company_address'] .= ' '.trim($value);
				}
			}
		}
		$find = db('oui')->where('mac',trim($dbdata['mac']))->count();
		if(!$find){
			$insert[] = $dbdata;
		}
		// var_dump($insert);
		if(count($insert) > 0){
			echo "Insert into db".count($insert).".\r\n";
			db('oui')->insertAll($insert);
		}
		echo "All check over!\r\n";
	}
}