<?php
/**
 * 服务相关类，显示系统服务相关的功能
 *
 * ============================================================================
 * 版权所有 2017-2018北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: songdemei<songdemei@suxuantech.cn> 2018-04-16 $
 */
namespace app\crm\controller;
use app\index\controller\Base;
/**
* 
*/
class Server extends Base
{

    public function index(){
        if(!check_right('menu1523865883')){
            echo '无权操作，请联系管理进行授权。';
            exit();
        }
        $service = service_status();
        //$service = json_decode('{"last_active":"2018-01-20 10:14:26","service_list":{"test1":{"restart_count":102,"last_restart":"2018-01-20 10:14:26"},"test2":{"restart_count":11,"last_restart":"2018-01-20 10:14:26"}}}',true);
        $this->assign('service',$service);
        $this->assign('restart',json_decode($this->getRestartStatus(),true));
        return $this->fetch();

    }
    public function restart(){
        $ret = ['code'=>200,'msg'=>'','data'=>[]];
        if(request()->isPost()){
            if(!check_right('menu1523865883')){
                $ret['code'] = 104;
                $ret['msg']='无权操作，请联系管理进行授权。';
                return json($ret);
            }
            $serverName = trim(input('server_name'),',');
            if($serverName){
                $res = service_status($serverName,'restart');
                if($res === false){
                    $ret['code'] = 101;
                    $ret['msg']='发送重启信息失败，请检查是否已启动监听程序。';
                    return json($ret);
                }else{
                    return json($ret);
                }
            }else{
                $ret['code'] = 102;
                $ret['msg']='无效的服务名,请开启监听服务。';
                return json($ret);
            }
        }
    }
    public function getRestartStatus(){
        $sign = cache('service_control_sign');
        if(is_string($sign)){
            $sign = json_decode($sign,true);
        }
        $status = 1;
        if($sign){
            foreach ($sign as $key => $value) {
                if($value['status'] != 1){
                    $status  = 0;
                }
            }
        }
        if(request()->isAjax()){
            return json(['status'=>$status]);

        }else{
            return json_encode(['status'=>$status]);
        }
        
    }
    
}