<?php
/**
 * CRM   预约上门模块实现模块
 * 所有业务的真正实现全在lib目录下建controller并且访问modle等，供controller层调用
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: Lilong<Lilong@suxuantech.cn> 2019-10-28 $
 */
namespace app\crm\lib;
use think\Cache;
use think\Controller;
use PHPExcel_IOFactory;
use Excel5;
use PHPExcel;
use app\common\lib\redisQueue;
use think\Exception;

class Visit extends Controller{
    protected $errid = 0;
    protected $errmsg = '';

    /**
     * 根据shop_code及日期，获取分组
     *
     * @param  shop_code   shop_code
     * @param  date        开始日期(2019-10-30格式)
     * @param  end         结束日期(2019-10-30格式)
     *
     * @return  array      日期内的分组名称
     *
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getSmGroup($param){
        $shop_code = trim($param['shop_code']);
        $date = date('Y-m-d', strtotime(trim($param['date'])));
        $end  = date('Y-m-d', strtotime(trim($param['end'])));
        $where['pc_shop_code'] = $shop_code;
        $where['is_delete'] = 2;
        $where['pc_type']   = 2;
        $where['pc_time']   = ['between', [$date, $end]];
        $groupInfo = db('crm_l_pc_log')->where($where)->where('smgroup', 'not null')->group('smgroup')->field('smgroup')->select();
		return $groupInfo;
    }

}

