<?php
/**
 * 报表实现类 上门信息统计
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: wangzhenya 2019-09-10 $
 */
namespace app\crm\lib\report;
use app\crm\lib\Report;
use think\Controller;
use think\image\Exception;

class Customer_pc extends Report {

    private $level=1;
    private $type=1;
    private $code='code1568197500';

    public function getLevel(){
        return $this->level;

    }
    public function getType(){
        return $this->type;
    }
    public function getCode(){
        return $this->code;
    }
    public function data()
    {
        set_time_limit(0);
        $data = input();
        $det = db('crm_s_report_form')->alias('f')->join('crm_s_report_detail d','d.form_id=f.id')->where('d.id',$data['did'])->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name,f.report_name')->find();
        //可操作店
        if($data['shop_code']){
            $shop_code = $data['shop_code'];
        }elseif($det['shop_code']){
            $shop_code = $det['shop_code'];
        }else{
            $shop_code = session('shop_code');
        }
        
        if(empty($shop_code)){
            return array('code'=>100,'msg'=>'请选择店面');
        }
        $start = $data['start'] ? date('Y-m-d', strtotime($data['start'])) : date('Y-m-d 00:00:00');
        $end =  $data['end'] ? date('Y-m-d 23:59:59', strtotime($data['end'])) : date('Y-m-d 23:59:59');

        $time = getDates($start,$end);
        $where['is_delete'] = 2;
        $where['pc_shop_code'] = $shop_code;
        $where['l.pc_type'] = 2;
        if($data['smgroup']) $where['l.smgroup'] = $data['smgroup'];
        if($data['cameraman_id']) $where['cameraman_id'] = intval($data['cameraman_id']);
        if($data['tutor_id']) $where['tutor_id'] = intval($data['tutor_id']);
        $all = db('crm_c_customerinfo')->alias('c')->join('crm_l_pc_log l','c.id=l.cid','left')
            ->where('l.pc_time','between',[$start,$end])
            ->where($where)
            ->group('l.pc_time')
            ->column('count(l.id)','l.pc_time');
        $allSql = db()->getLastSql();
        $status1 = db('crm_c_customerinfo')->alias('c')->join('crm_l_pc_log l','c.id=l.cid','left')
            ->where('l.pc_time','between',[$start,$end])
            ->where($where)
            ->where('l.status',1)
            ->group('l.pc_time')
            ->column('count(l.id)','l.pc_time');
        $status2 = db('crm_c_customerinfo')->alias('c')->join('crm_l_pc_log l','c.id=l.cid','left')
            ->where('l.pc_time','between',[$start,$end])
            ->where($where)
            ->where('l.status',2)
            ->group('l.pc_time')
            ->column('count(l.id)','l.pc_time');
        $status3 = db('crm_c_customerinfo')->alias('c')->join('crm_l_pc_log l','c.id=l.cid','left')
            ->where('l.pc_time','between',[$start,$end])
            ->where($where)
            ->where('l.status',3)
            ->group('l.pc_time')
            ->column('count(l.id)','l.pc_time');
        $status4 = db('crm_c_customerinfo')->alias('c')->join('crm_l_pc_log l','c.id=l.cid','left')
            ->where('l.pc_time','between',[$start,$end])
            ->where($where)
            ->where('l.status',4)
            ->group('l.pc_time')
            ->column('count(l.id)','l.pc_time');
        $order = db('crm_c_customerinfo')->alias('c')
            ->join('crm_l_pc_log l','c.id=l.cid','left')
            ->join('c_customerorder o','o.crm_visit_id=l.id','left')
            ->join('c_paymentcontent p','p.orderId=o.orderId','left')
            ->where('p.paymentdate','between',[date('Ymd',strtotime($start)),date('Ymd',strtotime($end))])
            ->where('p.isshishou','实收')->where('p.shop_code',$shop_code)
            ->where($where)
            ->group('paymentdate')
            ->column('sum(o.bargain_money) as amount,sum(p.payment_money) as fact','p.paymentdate');
        $sql['order'] = db()->getLastSql();
        $return = [];
        $total['time'] = '总计';
        foreach($time as $k=>$v){
            $arr = [];
            $arr['time'] = $v;
            $arr['all'] = $all[$v] ? $all[$v] : 0;
            $arr['no'] = $status1[$v] ? $status1[$v] : 0;
            $arr['order'] = $status2[$v] ? $status2[$v] : 0;
            $arr['noorder'] = $status3[$v] ? $status3[$v] : 0;
            $arr['cancel'] = $status4[$v] ? $status4[$v] : 0;
            $arr['smRate'] = $status2[$v]+$status3[$v]>0  ? sprintf('%.2f',($status2[$v]+$status3[$v])/$all[$v]*100).'%' : '';
            $arr['cancelRate'] = $status4[$v]  ? sprintf('%.2f',$status4[$v]/$all[$v]*100).'%' : '';
            $arr['amount'] = $order[date('Ymd',strtotime($v))]['amount'] ? $order[date('Ymd',strtotime($v))]['amount'] : 0;
            $arr['fact'] = $order[date('Ymd',strtotime($v))]['fact'] ? $order[date('Ymd',strtotime($v))]['fact'] : 0;

            array_push($return,$arr);

            $total['all'] +=  $all[$v];
            $total['no'] += $status1[$v];
            $total['order'] += $status2[$v];
            $total['noorder'] += $status3[$v];
            $total['cancel'] += $status4[$v];
            $total['amount'] += $order[date('Ymd',strtotime($v))]['amount'];
            $total['fact'] += $order[date('Ymd',strtotime($v))]['fact'];
        }
        $total['smRate'] = $total['order']+$total['noorder']>0  ? sprintf('%.2f',($total['order']+$total['noorder'])/$total['all']*100).'%' : '';
        $total['cancelRate'] = $total['cancel']  ? sprintf('%.2f',$total['cancel']/$total['all']*100).'%' : '';
        array_push($return,$total);

        $returnData['allSql'] = $allSql;
        $returnData['sql'] = $sql;
        $returnData['code'] = 0;
        $returnData['msg'] = '';
        $returnData['count'] = count($return);
        $returnData['data'] = $return;
        return json($returnData);
    }

    public function show(){
        $code = $this->getCode();
        /*
        $did = strtolower(input('param.did'));
        $info = db('crm_s_report_form')->alias('f')->join('crm_s_report_detail d','d.form_id=f.id')->where('d.id',$did)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();*/
        $menu_code = strtolower(input('param.menu_code'));
        $info = db('crm_s_report_form')->alias('f')->join('crm_s_report_detail d','d.form_id=f.id','left')->where('f.code',$menu_code)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();
        
        $display = APP_PATH.'crm'.DS.'view'.DS.'report'.DS.strtolower($info['report_class_name']).'.html';
        $title = db('crm_s_report_form')->where('code', $code)->value('report_name');
        $shop= controller('crm/Customer','lib')->get_shop(['shop_code'=>$info['shop_code']]);
        // 导师
        $tParam['work_type'] = 25;
        $tParam['shop_code'] = $info['shop_code'];
        $tutors = getShopStaffs($tParam);
        $this->assign('tutors',$tutors);
        // 摄影师
        $cParam['work_type'] = 3;
        $cParam['shop_code'] = $info['shop_code'];
        $cameraman = getShopStaffs($cParam);
        $this->assign('cameraman',$cameraman);

        //可操作店
        $mc = new \app\common\lib\mcInterface;
        $shopList = $mc->getWorkShop(['staff_id'=>session('staff_id'),'brandclass_id'=>session('brandclass_id')]);
        $this->assign('shopList',$shopList);
        $this->assign("shop_code", $info['shop_code']?$info['shop_code']:$shop_code);

        //小组
        $where['is_delete'] = 2;
        $where['pc_shop_code'] = $info['shop_code'];
        $where['l.pc_type'] = 2;
        $group = db('crm_c_customerinfo')->alias('c')->join('crm_l_pc_log l','c.id=l.cid','left')
            // ->where('l.pc_time','between',[date('Y-m-01'),date('Y-m-d')])
            ->where($where)
            ->group('l.smgroup')
            ->field('l.smgroup')
            ->select();
        $this->assign('group',$group);
        $this->assign('shop_code',$info['shop_code']);
        $this->assign('title', $shop[0]['shop_name'].'-'.$title);
        $this->assign('did', $info['id']);
        return $this->fetch($display);
    }

}