<?php
/**
 * 报表实现类 渠道客资集团统计
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: yuanweibo 2022-02-24 $
 */
namespace app\crm\lib\report;
use app\crm\lib\Report;
use think\Controller;
use think\image\Exception;

class Xaf_channel_brandclass extends Report {

    private $level=1;
    private $type=1;
    private $code='code1645680075';

    public function getLevel(){
        return $this->level;

    }
    public function getType(){
        return $this->type;
    }
    public function getCode(){
        return $this->code;
    }
    public function data()
    {
        set_time_limit(0);
        $data = input();
        $det = db('crm_s_report_form')->alias('f')->join('crm_s_report_detail d','d.form_id=f.id')->where('d.id',$data['did'])->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name,f.report_name')->find();
        //可操作店
        // if($data['shop_code']){
        //     $shop_code = $data['shop_code'];
        // }elseif($det['shop_code']){
        //     $shop_code = $det['shop_code'];
        // }else{
        //     $shop_code = session('shop_code');
        // }
        // if(empty($shop_code)){
        //     return array('code'=>100,'msg'=>'请选择店面');
        // }
        $start = $data['start'] ? date('Y-m-d', strtotime($data['start'])) : date('Y-m-d 00:00:00');
        $end =  $data['end'] ? date('Y-m-d 23:59:59', strtotime($data['end'])) : date('Y-m-d 23:59:59');
        $start_erp = date('Ymd', strtotime($data['start']));
        $end_erp = date('Ymd', strtotime($data['end']));

        if($data['customer_channel']){
            // $findSql = ' FIND_IN_SET("'.$shop_code.'",share_shops) ';->where($findSql)
            $channel = db('crm_s_channel')->where('channel_name','in',$data['customer_channel'])->group('channel_name')->select();
            $where['c.customer_channel'] = ['in',$data['customer_channel']];
        }else{
            // $findSql = ' FIND_IN_SET("'.$shop_code.'",share_shops) ';->where($findSql)
            $channel = db('crm_s_channel')->order('order_sort')->group('channel_name')->select();
            $where['c.customer_channel'] = ['in',array_column($channel,'channel_name')];
        }

        $where['c.c_from'] = 1;
        $where['c.is_status'] = 1;

        $sql = "sum(dj_day between '".$start."' and '".$end."') as mkz,";//总录入
        $sql .= "sum(is_valid=1 and dj_day between '".$start."' and '".$end."') as valid,";//有效
        $sql .= "sum(is_valid=3 and dj_day between '".$start."' and '".$end."') as wx";//无效
        // $sql .= "sum(is_valid in ('2,','4','5') and dj_day between '".$start."' and '".$end."') as dd";//待定
        // $sql .= "sum(is_success=1 and order_day between '$start' and '$end') as `order`";//成交量
        $info= db('crm_c_customerinfo')->alias('c')->join('c_customerorder o','c.customer_number=o.crm_customer_number','LEFT')
            ->where($where)
            ->group('customer_channel')
            ->column($sql,'customer_channel');
        $returnData['info_sql'] = db()->getlastsql();

        $ord = db('crm_c_customerinfo')->alias('c')->join('c_customerorder o','c.customer_number=o.crm_customer_number','LEFT')->join('c_paymentcontent p','o.orderId=p.orderId','LEFT')
            ->where('p.paymentdate','between',[$start_erp,$end_erp])
            ->where('o.shop_order_name','in',["爱婴总部","爱婴一部","爱婴二部","爱婴三部"])//爱婴
            ->where($where)
            ->group('o.orderId')
            ->field('o.orderId,c.customer_channel')
            ->select();
        $returnData['ord_sql'] = db()->getlastsql();

        $yixiao = db('crm_c_customerinfo')->alias('c')->join('c_customerorder o','c.customer_number=o.crm_customer_number','LEFT')->join('c_paymentcontent p','o.orderId=p.orderId','LEFT')
            ->where('p.paymentdate','between',[$start_erp,$end_erp])
            ->where('p.shop_name','in',["爱婴总部","爱婴一部","爱婴二部","爱婴三部"])//爱婴
            ->where($where)
            ->where('p.suoshu','in',['前期款','前期补款'])
            ->where('p.paytype','<>','VIP卡')
            ->group('c.customer_channel')
            ->column('sum(p.payment_money)','c.customer_channel');
        $returnData['yixiao_sql'] = db()->getlastsql();

        $erxiao = db('crm_c_customerinfo')->alias('c')->join('c_customerorder o','c.customer_number=o.crm_customer_number','LEFT')->join('c_paymentcontent p','o.orderId=p.orderId','LEFT')
            ->where('p.paymentdate','between',[$start_erp,$end_erp])
            ->where('p.shop_name','in',["爱婴总部","爱婴一部","爱婴二部","爱婴三部"])//爱婴
            ->where($where)
            ->where('p.suoshu','in',['后期款','后期补款'])
            ->where('p.paytype','<>','VIP卡')
            ->group('c.customer_channel')
            ->column('sum(p.payment_money)','c.customer_channel');

        $order = db('crm_c_customerinfo')->alias('c')->join('c_customerorder o','c.customer_number=o.crm_customer_number','LEFT')->join('c_paymentcontent p','o.orderId=p.orderId','LEFT')
            ->where('p.paymentdate','between',[$start_erp,$end_erp])
            ->where('p.shop_name','in',["爱婴总部","爱婴一部","爱婴二部","爱婴三部"])//爱婴
            ->where($where)
            ->where('p.paytype','<>','VIP卡')
            ->group('c.customer_channel')
            ->column('sum(p.payment_money) AS num','c.customer_channel');

        $ordm = db('crm_c_customerinfo')->alias('c')->join('c_customerorder o','c.customer_number=o.crm_customer_number','LEFT')->join('c_paymentcontent p','o.orderId=p.orderId','LEFT')
            ->where('p.paymentdate','between',[$start_erp,$end_erp])
            ->where('o.shop_order_name','not in',["爱婴总部","爱婴一部","爱婴二部","爱婴三部"])
            ->where($where)
            ->group('o.orderId')
            ->field('o.orderId,c.customer_channel')
            ->select();
        $returnData['ordm_sql'] = db()->getlastsql();

        $yixiaom = db('crm_c_customerinfo')->alias('c')->join('c_customerorder o','c.customer_number=o.crm_customer_number','LEFT')->join('c_paymentcontent p','o.orderId=p.orderId','LEFT')
            ->where('p.paymentdate','between',[$start_erp,$end_erp])
            ->where('p.shop_name','not in',["爱婴总部","爱婴一部","爱婴二部","爱婴三部"])
            ->where($where)
            ->where('p.suoshu','in',['前期款','前期补款'])
            ->where('p.paytype','<>','VIP卡')
            ->group('c.customer_channel')
            ->column('sum(p.payment_money)','c.customer_channel');
        $returnData['yixiaom_sql'] = db()->getlastsql();

        $erxiaom = db('crm_c_customerinfo')->alias('c')->join('c_customerorder o','c.customer_number=o.crm_customer_number','LEFT')->join('c_paymentcontent p','o.orderId=p.orderId','LEFT')
            ->where('p.paymentdate','between',[$start_erp,$end_erp])
            ->where('p.shop_name','not in',["爱婴总部","爱婴一部","爱婴二部","爱婴三部"])
            ->where($where)
            ->where('p.suoshu','in',['后期款','后期补款'])
            ->where('p.paytype','<>','VIP卡')
            ->group('c.customer_channel')
            ->column('sum(p.payment_money)','c.customer_channel');

        $orderm = db('crm_c_customerinfo')->alias('c')->join('c_customerorder o','c.customer_number=o.crm_customer_number','LEFT')->join('c_paymentcontent p','o.orderId=p.orderId','LEFT')
            ->where('p.paymentdate','between',[$start_erp,$end_erp])
            ->where('p.shop_name','not in',["爱婴总部","爱婴一部","爱婴二部","爱婴三部"])
            ->where('p.paytype','<>','VIP卡')
            ->where($where)
            ->group('c.customer_channel')
            ->column('sum(p.payment_money) AS num','c.customer_channel');
        $return = [];
        $total['channel_name'] = '总计';
        foreach($channel as $k=>$v){
            $arr = [];
            $arr['channel_name'] = $v['channel_name'];
            $arr['mkz'] = $info[$v['channel_name']]['mkz'] ? $info[$v['channel_name']]['mkz'] : 0;
            $arr['valid'] = $info[$v['channel_name']]['valid'] ? $info[$v['channel_name']]['valid'] : 0;
            $arr['wx'] = $info[$v['channel_name']]['wx'] ? $info[$v['channel_name']]['wx'] : 0;

            $arr['order'] = 0;
            foreach ($ord as $key => $value) {
                if($value['customer_channel'] == $v['channel_name']){
                    $arr['order'] += 1;
                }
            }
            // $arr['order'] = $arr['mkz'] != 0 && $ord[$v['channel_name']] ? $ord[$v['channel_name']] : 0;
            $arr['yixiao'] = $arr['mkz'] != 0 && $yixiao[$v['channel_name']] ? $yixiao[$v['channel_name']] : 0;
            $arr['erxiao'] = $arr['mkz'] != 0 && $erxiao[$v['channel_name']] ? $erxiao[$v['channel_name']] : 0;
            $arr['yeji'] = $arr['mkz'] != 0 && $order[$v['channel_name']] ? $order[$v['channel_name']] : 0;

            $arr['orderm'] = 0;
            foreach ($ordm as $key => $value) {
                if($value['customer_channel'] == $v['channel_name']){
                    $arr['orderm'] += 1;
                }
            }
            // $arr['orderm'] = $arr['mkz'] != 0 && $ordm[$v['channel_name']] ? $ordm[$v['channel_name']] : 0;
            $arr['yixiaom'] = $arr['mkz'] != 0 && $yixiaom[$v['channel_name']] ? $yixiaom[$v['channel_name']] : 0;
            $arr['erxiaom'] = $arr['mkz'] != 0 && $erxiaom[$v['channel_name']] ? $erxiaom[$v['channel_name']] : 0;
            $arr['yejim'] = $arr['mkz'] != 0 && $orderm[$v['channel_name']] ? $orderm[$v['channel_name']] : 0;

            array_push($return,$arr);

            $total['mkz'] +=  $info[$v['channel_name']]['mkz'];
            $total['valid'] +=  $info[$v['channel_name']]['valid'];
            $total['wx'] +=  $info[$v['channel_name']]['wx'];

            $total['order'] +=  $arr['order'];
            $total['yixiao'] += $yixiao[$v['channel_name']];
            $total['erxiao'] += $erxiao[$v['channel_name']];
            $total['yeji'] += $order[$v['channel_name']];

            $total['orderm'] +=  $arr['orderm'];
            $total['yixiaom'] += $yixiaom[$v['channel_name']];
            $total['erxiaom'] += $erxiaom[$v['channel_name']];
            $total['yejim'] += $orderm[$v['channel_name']];
        }
        // $total['cancelRate'] = $total['cancel']  ? sprintf('%.2f',$total['cancel']/$total['all']*100).'%' : '';
        array_push($return,$total);

        $returnData['code'] = 0;
        $returnData['msg'] = '';
        $returnData['count'] = count($return);
        $returnData['data'] = $return;
        return json($returnData);
    }

    public function show(){
        $code = $this->getCode();
        /*
        $did = strtolower(input('param.did'));
        $info = db('crm_s_report_form')->alias('f')->join('crm_s_report_detail d','d.form_id=f.id')->where('d.id',$did)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();*/
        $menu_code = strtolower(input('param.menu_code'));
        $info = db('crm_s_report_form')->alias('f')->join('crm_s_report_detail d','d.form_id=f.id','left')->where('f.code',$menu_code)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();
        
        $display = APP_PATH.'crm'.DS.'view'.DS.'report'.DS.strtolower($info['report_class_name']).'.html';
        $title = db('crm_s_report_form')->where('code', $code)->value('report_name');
        // $shop= controller('crm/Customer','lib')->get_shop(['shop_code'=>$info['shop_code']]);
        // $channel = controller('crm/Customer')->gtChannel($info['shop_code'],0);
        $channel = controller("Customer","lib")->getChannel($info['shop_code']);

        
        $this->assign('channel',$channel);
        $this->assign('title', $title);
        $this->assign('did', $info['id']);
        return $this->fetch($display);
    }

}