<?php
/**
 * 报表实现类 小阿福 拓展中心客资 爱婴上门成交明细表
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: wangyining 2020-06-08 $
 */
namespace app\crm\lib\report;
use app\crm\lib\Report;
use think\Controller;
use think\image\Exception;

class Xaf_sm_order_info extends Report {

    private $level=1;
    private $type=1;
    private $code='code1591687774';

    public function getLevel(){
        return $this->level;

    }
    public function getType(){
        return $this->type;
    }
    public function getCode(){
        return $this->code;
    }
    public function data()
    {
        set_time_limit(0);
        $data = input();

        $start = date('Y-m-d 00:00:00', strtotime($data['start']));
        $end = date('Y-m-d 23:59:59', strtotime($data['end']));
        $det = db('crm_s_report_form')->alias('f')->join('crm_s_report_detail d','d.form_id=f.id')->where('d.id',$data['did'])->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();

        //可操作店
        if($data['shop_code']){
            $shop_code = $data['shop_code'];
        }elseif($det['shop_code']){
            $shop_code = $det['shop_code'];
        }else{
            $shop_code = session('shop_code');
        }
        
        if(empty($shop_code)){
            return array('code'=>100,'msg'=>'请选择店面');
        }

        $where['is_status'] = 1;
        $where['c_from'] = 1;
        // $where['customer_type'] = 1;
        $where['add_shop_code'] = $shop_code;

        if($data['consultation_type_id']){
            $where['consultation_type_id'] = $data['consultation_type_id'];
        }

        if($data['channel_id']){
            $where['customer_channel_id'] = $data['channel_id'];
        }

        // 地域id，拼接where条件
        if ($data['province']) {
            $where['province_id'] = $data['province'];
        }

        if ($data['city']) {
            $where['city_id'] = (int)$data['city'];
        }

        //$page = $data['page'] ? $data['page'] : 1;
        //$limit = $data['limit'] ? $data['limit'] : 10;

        $list = db('crm_c_customerinfo')
            ->alias('c')
            ->join('crm_l_pc_log pc','c.id=pc.cid')
            ->join('c_customerorder erp_order','pc.id=erp_order.crm_visit_id')
            ->join('c_customerphoto photo','photo.orderId = erp_order.orderId and photo.currentfc = 1')
            ->join('c_paymentcontent pay','pay.orderId = photo.orderId and pay.currentfc = 1')
            ->where($where)
            ->where('pc.is_delete',2)//未删除
            ->where('photo.shop_code','in',['xaf002','xaf021','xaf022','xaf023'])//爱婴
            ->where('pay.payclass',0)//门市收款
            ->where('erp_order.targetdate', 'between', [date('Ymd',strtotime($start)), date('Ymd',strtotime($end))])//订单时间
            ->field('c.dj_staff,c.customer_channel,c.customer_name,c.customer_tel,erp_order.orderId,pc.sm_type,c.consultation_type,erp_order.targetdate,erp_order.storeconsuitant1,erp_order.storeconsuitant2,erp_order.package_name,erp_order.total_money,erp_order.nopayment_money,erp_order.shop_order_name,photo.shop_code as photo_shop_code,photo.shop_name as photo_shop_name,pay.paymentdate,pay.payment_money,pay.paytype,pay.shop_name as soukuan_shop_name,pay.suoshu,pay.currentfc')
            ->order('dj_staff,sm_type')
            ->select();
        $sql = db()->getLastSql();
        $sum = [];
        $existOrderId = [];
        foreach($list as $k => $v){
            if(!in_array($v['orderId'], $existOrderId)){
                $sum['total_money'] += $v['total_money'];
                $existOrderId[] = $v['orderId'];
            }else{
                $list[$k]['total_money'] = '-';
            }
            
            $sum['nopayment_money'] += $v['nopayment_money'];
            $sum['payment_money'] += $v['payment_money'];
        }

        $sum['dj_staff'] = '合计：';
        $sum['customer_channel'] = '';
        $sum['total_money'] = $sum['total_money'] ? $sum['total_money'] : '0.00';
        $sum['nopayment_money'] = $sum['nopayment_money'] ? $sum['nopayment_money'] : '0.00';
        $sum['payment_money'] = $sum['payment_money'] ? $sum['payment_money'] : '0.00';

        array_push($list,$sum);

        $return['code'] = 0;
        $return['msg'] = '';
        $return['count'] = count($list);
        $return['data'] = $list;
        $return['sql']  = $sql;

        return json($return);

    }

    public function show(){
        /*
        $did = strtolower(input('param.did'));
        $info = db('crm_s_report_form')->alias('f')->join('crm_s_report_detail d','d.form_id=f.id')->where('d.id',$did)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();*/
        $menu_code = strtolower(input('param.menu_code'));
        $info = db('crm_s_report_form')->alias('f')->join('crm_s_report_detail d','d.form_id=f.id','left')->where('f.code',$menu_code)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();
        $city = db('crm_s_shop_address')->where('shop_code',$info['shop_code'])->where('type',2)->select();

        //消费类型
        $consumptionType = controller("Customer", "lib")->consumptionType(['brandclass_id'=>$info['brandclass_id']]);
        $this->assign("consumptionType", $consumptionType);

        // crm省    列表
        $data['type'] = 1;
        $data['shop_code'] = $info['shop_code'];
        $province = controller("Customer", "lib")->address($data);
        $this->assign('province', $province);
        //店
        $mcInterface = new \app\common\lib\mcInterface();
        $shop = $mcInterface->getWorkShop(['staff_id'=>session('staff_id'),'brandclass_id'=>session('brandclass_id')]);
        $this->assign("shop", $shop);
        $this->assign("shop_code", $info['shop_code']?$info['shop_code']:session('shop_code'));

        //来源渠道
        $channel = controller("Customer", "lib")->getChannel($info['shop_code']);
        $this->assign("channel", $channel);

        $code = $this->getCode();
        $display = APP_PATH.'crm'.DS.'view'.DS.'report'.DS.strtolower($info['report_class_name']).'.html';
        $title = db('crm_s_report_form')->where('code', $code)->value('report_name');
        $shopInfo = controller('crm/Customer','lib')->get_shop(['shop_code'=>$info['shop_code']]);
        $this->assign('title', $shopInfo[0]['shop_name'].'-'.$title);
        $this->assign('did', $info['id']);
        return $this->fetch($display);
    }

}