<?php
/**
 * 报表实现类 小阿福 上门网付订单成交明细表
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: wangyining 2020-06-08 $
 */
namespace app\crm\lib\report;
use app\crm\lib\Report;
use think\Controller;
use think\image\Exception;

class Xaf_yp_cameraman_data extends Report {

    private $level=1;
    private $type=1;
    private $code='code﻿1591842392';

    public function getLevel(){
        return $this->level;
    }
    public function getType(){
        return $this->type;
    }
    public function getCode(){
        return $this->code;
    }
    public function data()
    {

        set_time_limit(0);
        $param = input();

      	//医拍摄影师
      	if($param['photo_cameraman']){
      		$where['hospital_photo_cameraman'] = $param['photo_cameraman'];
      	}

      	$start = date('Y-m-d 00:00:00', $param['start']?strtotime($param['start']):time());
        $end = date('Y-m-d 23:59:59', $param['end']?strtotime($param['end']):time());

        $sql = "";
    	$sql.= " sum(is_valid <> 3 and sign_name = '一类') as yilei ";
    	$sql.= ",sum(is_valid <> 3 and sign_name = '二类') as erlei ";
    	$sql.= ",sum(is_valid <> 3 and sign_name = '三类') as sanlei ";
    	$sql.= ",sum(is_valid <> 3 and sign_name = '出生名单') as csmd ";
    	$sql.= ",sum(is_valid = 3 and unvalid_reason = '空号') as kh ";
    	$sql.= ",sum(is_valid = 3 and unvalid_reason = '错号') as ch ";
    	$sql.= ",sum(is_valid = 3 and unvalid_reason = '超区') as cq ";
    	$sql.= ",sum(is_valid = 3 and unvalid_reason = '外地') as wd ";
    	$sql.= ",sum(is_valid = 3 and unvalid_reason = '重复') as cf ";

        $Data = db('crm_c_customerinfo')
                ->where("dj_day between '$start' and '$end'")
		        // ->where("add_shop_code",$param['shop_code'])
		        ->group('hospital_photo_cameraman')
		        ->where("is_status=1 and c_from = 1")
		        ->where($where)
		        ->column($sql,'hospital_photo_cameraman');
        $querysql = db()->getLastSql();
        $photo_cameraman = getShopStaffs(['shop_code'=>$param['shop_code'],'work_type'=>3]);
        if($param['photo_cameraman']){
            foreach($photo_cameraman as $key=>$value){
                if($value['staffname'] != $param['photo_cameraman']){
                    unset($photo_cameraman[$key]);
                }
            }    
        }
        

        $list = [];
        foreach ($photo_cameraman as $key => $value) {
            $list[$key] = $Data[$value['staffname']];
            $list[$key]['hospital_photo_cameraman'] = $value['staffname'];
            $list[$key]['yilei'] = $Data[$value['staffname']]['yilei']?$Data[$value['staffname']]['yilei']:0;
            $list[$key]['erlei'] = $Data[$value['staffname']]['erlei']?$Data[$value['staffname']]['erlei']:0;
            $list[$key]['sanlei'] = $Data[$value['staffname']]['sanlei']?$Data[$value['staffname']]['sanlei']:0;
            $list[$key]['csmd'] = $Data[$value['staffname']]['csmd']?$Data[$value['staffname']]['csmd']:0;
            $list[$key]['kh'] = $Data[$value['staffname']]['kh']?$Data[$value['staffname']]['kh']:0;
            $list[$key]['ch'] = $Data[$value['staffname']]['ch']?$Data[$value['staffname']]['ch']:0;
            $list[$key]['cq'] = $Data[$value['staffname']]['cq']?$Data[$value['staffname']]['cq']:0;
            $list[$key]['wd'] = $Data[$value['staffname']]['wd']?$Data[$value['staffname']]['wd']:0;
            $list[$key]['cf'] = $Data[$value['staffname']]['cf']?$Data[$value['staffname']]['cf']:0;
            
        }

        $arr = [];

        $arr['hospital_photo_cameraman'] = '总计';

        foreach($list as $key=>$value){
            $arr['yilei'] += $value['yilei'];
            $arr['erlei'] += $value['erlei'];
            $arr['sanlei']+=$value['sanlei'];
            $arr['csmd']+=$value['csmd'];
            $arr['kh']+=$value['kh'];
            $arr['ch']+=$value['ch'];
            $arr['cq']+=$value['cq'];
            $arr['wd']+=$value['wd'];
            $arr['cf']+=$value['cf'];
        }

        array_push($list,$arr);


        $return['code'] = 0;
        $return['msg'] = '';
        $return['count'] = count($list);
        $return['data'] = $list;
        $return['start'] = $param['start'];
        $return['end'] = $param['end'];
        $return['photo_cameraman'] = $param['photo_cameraman'];
        $return['sql'] = $querysql;

        return json($return);

    }

    public function show(){
        /*
        $did = strtolower(input('param.did'));
        $info = db('crm_s_report_form')->alias('f')->join('crm_s_report_detail d','d.form_id=f.id')->where('d.id',$did)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();*/
        $menu_code = strtolower(input('param.menu_code'));
        $info = db('crm_s_report_form')->alias('f')->join('crm_s_report_detail d','d.form_id=f.id','left')->where('f.code',$menu_code)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();
        $city = db('crm_s_shop_address')->where('shop_code',$info['shop_code'])->where('type',2)->select();

        $photo_cameraman = getShopStaffs(['shop_code'=>$info['shop_code'],'work_type'=>3]);
        $this->assign('photo_cameraman',$photo_cameraman);//医拍摄影师

        $this->assign('yestoday',date("Y-m-d",time()));

        $code = $this->getCode();
        $display = APP_PATH.'crm'.DS.'view'.DS.'report'.DS.strtolower($info['report_class_name']).'.html';
        $title = db('crm_s_report_form')->where('code', $code)->value('report_name');
        $shopInfo = controller('crm/Customer','lib')->get_shop(['shop_code'=>$info['shop_code']]);
        $this->assign('title', $shopInfo[0]['shop_name'].'-'.$title);
        $this->assign('did', $info['id']);
        $this->assign('shop_code',$info['shop_code']);
        return $this->fetch($display);
    }

}