<?php
/**
 * 报表实现类 贵阳莱色定制 定制  恒向定单占比数据
 * *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: lilong 2020-05 $
 */
namespace app\crm\lib\report;
use app\crm\lib\Report;
use think\Controller;
use think\image\Exception;

class Gyls_hxddzb_data extends Report {

    private $level= 1;
    private $type = 1;
    private $code = 'code1611035579';

    public function getLevel(){
        return $this->level;
    }
    public function getType(){
        return $this->type;
    }
    public function getCode(){
        return $this->code;
    }
    public function data(){
        set_time_limit(0);
        $data = input();
        $start= date('Y-m-d', strtotime($data['start']));
        $end  = date('Y-m-d 23:59:59', strtotime($data['end']));
        // $det = db('s_report_form')->alias('f')->join('s_report_detail d','d.form_id=f.id')->where('d.id',$data['did'])->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();
        // $shop_code = $det['shop_code'];
        $add_shop_code = $data['add_shop_code']?$data['add_shop_code']:session('shop_code');
        $shop_code = $data['shop_code']?$data['shop_code']:session('shop_code');
        if(empty($shop_code)){
            return array('code'=>100,'msg'=>'请选择门店');
        }
        // 基础条件
        $where['c.is_status'] = 1;
        $where['c.c_from'] = 1;
        $where['c.add_shop_code'] = $add_shop_code;
        $where['c.shop_code'] = $shop_code;
        // 消费类型
        if((int)$data['consultation_type_id']){
            $where['c.consultation_type_id'] = (int)$data['consultation_type_id'];
        }
        // 渠道
        if($data['channel_id']){
            $channels = explode(',',$data['channel_id']);
            $where['customer_channel'] = ['in',$channels];
        }

        $orders = db('c_customerinfo')->alias('c')
            ->join('c_customer_order o','c.id=o.customer_id','left')
            ->where($where)
            ->field('c.id,c.customer_name,c.customer_tel,c.customer_wechat,c.customer_channel,c.dj_staff,c.add_shop_name,c.dj_day,c.sales_staff,c.jr_day,c.shop_name,c.is_success,o.target_time,o.valid_time,o.order_fact,o.order_amount')
            ->order('o.target_time')
            ->select();
        $sql = db()->getLastSql();
        foreach($orders as $k=>$v){
            $orders[$k]['is_success'] = getIsSuccess($v['is_success']);
            $orders[$k]['target_time']= $v['target_time'] ? date('Y-m-d',strtotime($v['target_time'])) : '';
            $orders[$k]['valid_time'] = $v['valid_time'] ? date('Y-m-d',strtotime($v['valid_time'])) : '';
        }
        
        $return['sql']  = $sql;
        $return['code'] = 0;
        $return['msg']  = '';
        $return['count']= count($orders);
        $return['data'] = $orders;
        
        return json($return);
    }
    public function show(){
        $code = $this->getCode();
        $did = strtolower(input('param.did'));
        // $info = db('s_report_form')->alias('f')->join('s_report_detail d','d.form_id=f.id')->where('d.id',$did)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();
        //来源渠道
       /* $channel = getChannelJson(session('shop_code'));
        $this->assign("channel", json_encode($channel));*/
        //消费类型
        $consumptionType = controller("Customer", "lib")->consumptionType(['brandclass_id'=>session('brandclass_id')]);
        $this->assign("consumptionType", $consumptionType);

        if (isMobile()) {
            //来源渠道
            $c = controller('crm/Customer', 'lib')->getChannel($info['shop_code']);
            $channel_infos = array_column($c,'channel_info_name');
            //二级渠道
            $url = '59fd5e729e5a8';
            $res = sx_call($url, []);
            $channels = $res['data'];
            //过滤掉本店不存在的二级渠道
            foreach($channels as $k => $v){
                if(!in_array($v['channel_name'],$channel_infos)){
                    unset($channels[$k]);
                }
            }
            $channel_name = array_column($channels, 'channel_name');
            $channel_data = db('s_channel')->where("channel_info_name","in",$channel_name)->order("order_sort")->select();
            // $channel_datas = array_column($channel_data, 'channel_info_name');
            $this->assign('channel',$channel_data);
            $report = "report_wap";
        }else{
            //来源渠道
            $channel = getChannelJson(session('shop_code'));
            $this->assign("channel", json_encode($channel));

            $report = "report";
        }
        $mc = new \app\common\lib\mcInterface();
        $shopList = $mc->cacheData('5a8fd8296f3d3',['staff_id'=>session('staff_id')]);
        $this->assign('shop_list',$shopList);

        $info = db('s_report_form')->where('code', $code)->field('report_class_name,report_name')->find();
        $display = APP_PATH.'crm'.DS.'view'.DS.$report.DS.strtolower($info['report_class_name']).'.html';
        $shop= controller('crm/Customer','lib')->get_shop(['shop_code'=>$info['shop_code']]);
        $this->assign('title', session('shop_name').'-'.$info['report_name']);

        $this->assign('did', $info['id']);
        $this->assign('today',date('Y-m-d'));
        $this->assign('yestoday',date('Y-m-d',time()));

        return $this->fetch($display);
    }
}