<?php
/**
 * ERP 对应模块
 * CRM的基本功能实现，如客资录入，客资查询等。
 * 所有业务的真正实现全在lib目录下建controller并且访问modle等，供controller层调用
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: songdemei<songdemei@suxuantech.cn> 2018-11-14 $
 */
namespace app\erp\lib;
use think\Cache;
use think\Controller;
use app\common\lib\redisQueue;
use think\Exception;

class Erp extends Controller{


// ------------- 儿童排控 (选片、摄影) 开始 --------------

    //获取某个列表上方下方 排控统计数量
    public function reloadTableNum($photodate,$shop_code){

        //获取总排控数 已排控 可排控
        $res = $this->getPcNum($photodate,$shop_code);

        //已排程 摄影师 摄影助理 化妆师数量
        //摄影师
        $syer = db('c_customerphoto','sx_erp')
            ->where('shop_code',$shop_code)
            ->where('photodate',$photodate)
            ->field('cameraman AS staffname,COUNT(1) AS num')
            ->group('cameraman')
            ->select();

        foreach($syer as $syKey => $syVal){
            if(empty($syVal['staffname']))  unset($syer[$syKey]);
        }

        $res['syer'] = $syer;

        // 摄影助理
        $syzler = db('c_customerphoto','sx_erp')
            ->where('shop_code',$shop_code)
            ->where('photodate',$photodate)
            ->field('photoassistant AS staffname,COUNT(1) AS num')
            ->group('photoassistant')
            ->select();

        foreach($syzler as $zlKey => $zlVal){
            if(empty($zlVal['staffname']))  unset($syzler[$zlKey]);
        }
        $res['syzler'] = $syzler;

        //化妆师
        $hzer = db('c_customerphoto','sx_erp')
            ->where('shop_code',$shop_code)
            ->where('photodate',$photodate)
            ->field('dresser AS staffname,COUNT(1) AS num')
            ->group('dresser')
            ->select();

        foreach($hzer as $hzKey => $hzVal){
            if(empty($hzVal['staffname']))  unset($hzer[$hzKey]);
        }
        $res['hzer'] = $hzer;

        unset($syer,$syzler,$hzer);

        return $res;

    }

    /*
     * 获取可排控数量
     * $shop_code   店面识别码
     * $photodate   时间
     */
    public function getPcNum($photodate,$shop_code){
        // 查设定 (可排程)
        $pc_set = db('s_pcdefault_monthset','sx_erp')
            ->where('pctype', 0) // 0:拍照排程;1:选片排程
            ->where('shop_code', $shop_code)
            ->where('pcday',$photodate)
            ->field('pcday,sum(timecount) num')
            ->find();

        $res['day'] = $photodate;
        $res['allPc'] = $pc_set['num'];
        unset($pc_set);

        // 查排程 已排程
        $pc_list = db('c_customerphoto','sx_erp')
            ->where('shop_code', $shop_code)
            ->where('photodate',$photodate)
            ->field('photodate,count(orderId) as num')
            ->find();

        $res['yPc'] = $pc_list['num'];
        $res['nPc'] = $res['allPc'] - $res['yPc'];
        unset($pc_list);
        return $res;
    }


    /*
     *  获取每一天的排程
     *  $shop_code    店面识别码
     *  $photodate          日期（例:20181114）
     */
    public function getPcListDay($photodate,$shop_code){


        $pc_set = db('s_pcdefault_monthset','sx_erp')
            ->where('pctype', 0) // 0:拍照排程;1:选片排程
            ->where('shop_code', $shop_code)
            ->where('pcday',$photodate)
            ->column('pcday,pctime,timecount,area','id');

        //根据排程设定 得到的空数据
        $setData = [];
        $num = 1;
        foreach($pc_set as $key => $value){

            for($i = 0; $i < $value['timecount']; $i++){
                $setData[] = [
                    'setId'   => $num,
                    'setTime' => $value['pctime'],
                    'setArea' => $value['area'],
                    'is_use'  => 2
                ];

                $num ++;
            }
        }

        unset($pc_set);

        //已排程数据
        $pc_list = db('c_customerphoto','sx_erp')->alias('p')
            ->join('c_customerinfo c','c.customerid = p.customerid', 'left')
            ->join('c_customerorder o','o.customerid = c.customerid', 'left')
            ->where('p.shop_code', $shop_code)
            ->where('p.photodate',$photodate)
            ->field('p.id,c.customerid,c.mname,c.wname,c.bbname,c.wphone,c.mphone,c.cssname,c.area,o.orderId,o.targetdate,o.consumption_type,o.acceptor_address,o.total_money,o.payment_money,o.nopayment_money,o.ordertopic,o.dresstheme,o.ordernote,p.currentfc,p.phototype,p.photodate,p.phototime,p.photostate,p.cameraman,p.photoassistant,p.lighting_engineer,p.designer,p.mentor_a,p.mentor_b,p.dresser,p.photonote,p.photobase,p.id,p.id as photoid,p.shop_code,p.jiaji,p.huazhuangzhuli,p.communication_date,p.communicationtime,p.communication_state,p.communication_man,p.secretaireman,p.shop_name,p.shop_code')
            ->order('p.photodate')
            ->select();

        $set_list = $setData;
        foreach($pc_list as $key => $val){

            $status = 5;
            $keyNum = 'no';
            foreach($set_list as $k => $v){


                if(!empty($v['setTime']) && $v['setArea']!='全部' && $val['phototime']==$v['setTime'] && $val['area']==$v['setArea']){

                    if($status > 1 && $v['is_use'] == 2){
                        $status = 1;
                        $pc_list[$key]['setId'] = $v['setId'];
                        $set_list[$k]['is_use'] = 1;

                        //将之前匹配数据修改回未使用状态
                        if($keyNum !='no'){
                            $set_list[$keyNum]['is_use'] = 2;
                        }

                        //更改当前规则key
                        $keyNum = $k;

                    }

                }elseif(!empty($v['setTime']) && $v['setArea'] == '全部'){

                    $setPcTime = $v['setTime'];
                    $setArea = $val['area'];

                    if($val['phototime'] == $setPcTime && $val['area'] == $setArea){
                        if($status > 2 && $v['is_use'] == 2){
                            $status = 2;
                            $pc_list[$key]['setId'] = $v['setId'];
                            $set_list[$k]['is_use'] = 1;

                            //将之前匹配数据修改回未使用状态 更改当前规则key
                            if($keyNum !='no'){
                                $set_list[$keyNum]['is_use'] = 2;
                            }
                            //更改当前规则key
                            $keyNum = $k;
                        }
                    }

                }elseif(empty($v['setTime']) && $v['setArea'] != '全部'){

                    $setPcTime = $val['phototime'];
                    $setArea = $v['setArea'];

                    if($val['phototime'] == $setPcTime && $val['area'] == $setArea){

                        if($status > 2 && $v['is_use'] == 2){
                            $status = 2;
                            $pc_list[$key]['setId'] = $v['setId'];
                            $set_list[$k]['is_use'] = 1;

                            //将之前匹配数据修改回未使用状态 更改当前规则key
                            if($keyNum !='no'){
                                $set_list[$keyNum]['is_use'] = 2;
                            }
                            //更改当前规则key
                            $keyNum = $k;
                        }
                    }
                }elseif(empty($v['setTime']) && $v['setArea'] == '全部'){

                    if($status > 3 && $v['is_use'] == 2){

                        $status = 3;
                        $pc_list[$key]['setId'] = $v['setId'];
                        $set_list[$k]['is_use'] = 1;

                        //将之前匹配数据修改回未使用状态 更改当前规则key
                        if($keyNum !='no'){
                            $set_list[$keyNum]['is_use'] = 2;
                        }
                        //更改当前规则key
                        $keyNum = $k;
                    }
                }

                unset($setPcTime,$setArea);
            }

        }

        foreach($setData as $k1 => $v1){

            foreach($pc_list as $k2 => $v2){
                if($v2['setId'] == $v1['setId']){
                    $setData[$k1] = $v2;
                    $setData[$k1]['setTime'] = $v1['setTime'];
                    $setData[$k1]['setArea'] = $v1['setArea'];
                    unset($pc_list[$k2]);
                }
            }
        }

        $all_list = array_merge($setData,$pc_list);
        return $all_list;

    }


// -------------------------------------------- 儿童排控 (选片、摄影) 结束 -------------------------------------------- //


}
