<?php
namespace app\common\lib;
class erpInterface {
    protected $options = [
        'address'     => '',//ERP请求地址
        'token' => '^******^',//ERP请求密钥
        'shop_type'=>1,//类型，按MC的门店类型：婚纱1，儿童2，注意，ERP内标识是婚纱0儿童1
    ];
    protected $erpConfig = [];
    protected  $handler = null ;
    var $error = '';
    var $errno = '';
    function __construct($options=array()) {
        if (!empty($options)) {
            $this->options = array_merge($this->options, $options);
        }
        $this->erpConfig = config('ext.app_config');
        if($this->options['shop_type'] == 2){
            $this->options['address'] = $this->erpConfig['sx_erp']['addr_child'];
        }else{
            $this->options['shop_type'] = 1;
            $this->options['address'] = $this->erpConfig['sx_erp']['addr'];
        }
    }

    /**
     * 获取ERP的支付类型
     * 
     * @return [array] [收款类型字典]
     */
    public function getPayTypeDict(){
        $pathArray = [
            2=>'/SX_ChildCrmApi/Sel_ZhiFuTypeSet',
            1=>'/SX_CrmApi/Sel_ZhiFuTypeSet'
        ];
        $cacheKey = 'erp_paytype_dict_'.$this->options['shop_type'];
        $result = [];
        if(!cache('?'.$cacheKey)){
            $path = $pathArray[$this->options['shop_type']];
            $url = trim($this->options['address'],'/').$path.'?Token='.$this->options['token'].'&Code=';
            $res = requestERP($url,[]);
            if($res['Code'] == 200){
                $result = $res['Data'];
                cache($cacheKey,$result);
                return $result;
            }else{
                $this->error = $res['Message']?$res['Message']:json_encode($res);
                $this->errno = $res['Code'];
                return false;
            }
        }else{
            return cache($cacheKey);
        }
    }

    /**
     * 获取ERP系统的收款款项
     * @return [array] [款项列表]
     */
    public function getFeeCategoryDict(){
        $pathArray = [
            2=>'/SX_ChildCrmApi/Sel_KuanXiangSet',
            1=>'/SX_CrmApi/Sel_KuanXiangSet'
        ];
        //转输给ERP的款项类型。儿童1婚纱0
        $KXType=$this->getErpShopType();
        $cacheKey = 'erp_feecategory_dict_'.$this->options['shop_type'];;
        $result = [];
        if(!cache('?'.$cacheKey)){
            $path = $pathArray[$this->options['shop_type']];
            $url = trim($this->options['address'],'/').$path.'?Token='.$this->options['token'].'&KXType='.$KXType.'&Code=';
            $res = requestERP($url,[]);
            if($res['Code'] == 200){
                $result = $res['Data'];
                cache($cacheKey,$result);
                return $result;
            }else{
                $this->error = $res['Message']?$res['Message']:json_encode($res);
                $this->errno = $res['Code'];
                return false;
            }
        }else{
            return cache($cacheKey);
        }
    }

    /**
     * 创建订单，即转订单接口
     * 
     * [addNewOrder description]
     */
    public function addNewOrder($data){
        $pathArray = [
            2=>'/SX_ChildCrmApi/Add_CustomerOrderinfo',
            1=>'/SX_CrmApi/Add_CustomerOrderinfo'
        ];
        //转输给ERP的款项类型。儿童1婚纱0
        $path = $pathArray[$this->options['shop_type']];
        $erpShopType=$this->getErpShopType();
        $url = trim($this->options['address'],'/').$path.'?Token='.$this->options['token'].'&CustomerType='.$erpShopType;
        $response = requestERP($url, $data);
        // var_dump($response);die;
        if ($response['Code'] != '200') {
            $this->error = $response['Message']?$response['Message']:json_encode($response);
            $this->errno = $response['Code'];
            return false;
        }
        return $response['Data'];
    }

    /**
     * 创建订单，即转订单接口 2021-12-09 appwxerp
     */
    public function addNewOrderAppWx($data){
        $path = '/APP_ERPWedApi/APP_Open_WeddingOrder';

        $data = json_decode($data,true);
        $data['Token'] = $this->options['token'];
        $data = json_encode($data);

        $url = trim($this->options['address'],'/').$path;
        $response = requestERP($url, $data);
        // var_dump($response);die;
        if ($response['Code'] != '200') {
            $this->error = $response['Message']?$response['Message']:json_encode($response);
            $this->errno = $response['Code'];
            return false;
        }
        return $response['Data'];
    }
    /**
     * 根据CRM店类型，返回ERP对应店类型。
     * 
     * @return [type] [description]
     */
    public function getErpShopType(){
        return $this->options['shop_type']==1?0:1;
    }
    /**
     * 变更类的门店类型，
     * 
     * @param integer $shopType [description]
     */
    public function setShopType($shopType = 0){
        if($shopType == 2){
            $this->options['shop_type'] = 2;
            $this->options['address'] = $this->erpConfig['sx_erp']['addr_child'];
        }else{
            $this->options['shop_type'] = 1;
            $this->options['address'] = $this->erpConfig['sx_erp']['addr'];
        }
    }
    /**
     * 变更类型的访问地址
     * 
     * @param string $address [description]
     */
    public function setAddress($address = ''){
        if($address){
            $this->options['address'] = $address;
        }
    }
    /**
     * 清除缓存方法，清除除所有本类设置的缓存
     * 
     * @param  string $cacheName [description]
     * @return [type]            [description]
     */
    static function cleanCache($cacheName=''){
        if($cacheName){
            cache($cacheName.'*',null);
        }
        cache('erp_paytype_dict_*',null);
        cache('erp_feecategory_dict_*',null);
    }

}