<?php
/**
 * MC 接口模型，
 * 所有请求MC接口的，写到此类里，未来可以方便管理。
 * 
 * 接口返回false表示调用失败，非false的表示返回具体数据，注：有可能为空
 * 如果接口返回false 时，可以获取类的_code获性获得这个错误的代码，_msg获得错误描述
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: songdemei<songdemei@suxuantech.cn> 2018-01-30 $
 */
namespace app\common\lib;
use think\Controller;
use think\Exception;

class mcInterface extends Controller{
    var $_code = 0;
    var $_msg = '';
    var $_shopCode = '';
    function _initialize($shopCode = ''){
        $this->_shopCode = $shopCode;
    }
    public function retResult($res){
        if(!$res){
            $this->_code = -2;
            $this->_msg = '接口请求失败，请重试';
            return false;
        }
        if($res['error']){
            $this->_code = -1;
            $this->_msg = $res['error'];
            return false;
        }
        if($res['code'] != 200 && $res['code'] != 202){
            $this->_code = $res['code'];
            $this->_msg = $res['msg'];
            return false;
        }
        return $res['data'];
    }
    /**
     * 获取渠道类型(一级)  channel/channelClass
     * 
     * @return array
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getChannelClass($params){
        $cacheKey = 'mc_interface_5a2757c0a9810_'.md5(json_encode($params));
        if(cache('?'.$cacheKey)){
            return cache($cacheKey);
        }else{
            $res = sx_call('5a2757c0a9810', $params);
            $return = $this->retResult($res);
            if($return !== false){
                cache($cacheKey,$return);
            }
        }
        return $return;
    }
    /**
     * 获取来源渠道(二级)  Channel/channelInfo
     * 
     * @param  ChannelClass     渠道类型
     * 
     * @return array
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getChannelInfo($params){
        $cacheKey = 'mc_interface_59fd5e729e5a8_'.md5(json_encode($params));
        if(cache('?'.$cacheKey)){
            return cache($cacheKey);
        }else{
            $res = sx_call('59fd5e729e5a8', $params);
            $return = $this->retResult($res);
            if($return !== false){
                cache($cacheKey,$return);
            }
        }
        return $return;
    }
    /**
     * 岗位查询    Staff/position
     * 
     * @param  id             岗位id
     * @param  brandclass     事业部名称
     * @param  shop_code      shop_code
     * @param  department_id  部门id
     * @param  position_code  岗位code
     * 
     * @return array
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getPosition($params){
        $cacheKey = 'mc_interface_5a0b96b65c111_'.md5(json_encode($params));
        if(cache('?'.$cacheKey)){
            return cache($cacheKey);
        }else{
            $res = sx_call('5a0b96b65c111', $params);
            $return = $this->retResult($res);
            if($return !== false){
                cache($cacheKey,$return);
            }
        }
        return $return;
    }
    /**
     * 部门下员工查询    Staff/getDepartmentStaffs
     *
     * @param  department_id  事业部名称
     * @param  get_leave      是否查看离职
     * @param  get_main       1:不查看兼职； 2:查看兼职；
     *
     * @return array
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getStaffByDepartment($params=[]){
        $cacheKey = 'mc_interface_5a0e6f272bb38_'.md5(json_encode($params));
        if(cache('?'.$cacheKey)){
            return cache($cacheKey);
        }else{
            $res = sx_call('5a0e6f272bb38', $params);
            $return = $this->retResult($res);
            if($return !== false){
                cache($cacheKey,$return);
            }
        }
        return $return;
    }
    /**
     * 消费类型
     * @return array
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getSumptionType($params){
        $cacheKey = 'mc_interface_59fd58574204a_'.md5(json_encode($params));
        if(cache('?'.$cacheKey)){
            return cache($cacheKey);
        }else{
            $res = sx_call('59fd58574204a', $params);
            $return = $this->retResult($res);
            if($return !== false){
                cache($cacheKey,$return);
            }
        }
        return $return;
    }
    /**
     * 消费能力
     * @return array
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getCapacity($params){
        $cacheKey = 'mc_interface_5a0c43da3e99a_'.md5(json_encode($params));
        if(cache('?'.$cacheKey)){
            $cacheData = cache($cacheKey);
            return $cacheData['data'];
        }else{
            $res = sx_call('5a0c43da3e99a', $params);
            $return = $this->retResult($res);
            if($return !== false){
                cache($cacheKey,['data'=>$return]);
            }
        }
        return $return;
    }
    /**
     * 部门查询     Staff/department
     * 
     * @param  id          部门id
     * @param  shop_code   shop_code
     * 
     * @return array
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getDepartment($params=[]){
        $cacheKey = 'mc_interface_5a0aef152b750_'.md5(json_encode($params));
        if(cache('?'.$cacheKey)){
            return cache($cacheKey);
        }else{
            $res = sx_call('5a0aef152b750', $params);
            $return = $this->retResult($res);
            if($return !== false){
                cache($cacheKey,$return);
            }
        }
        return $return;
    }
    /**
     * 小组信息查询  Staff/getGroupInfo   
     * 
     * @param  brandclass_id  事业部id
     * @param  shop_code      shop_code
     * @param  department_id  部门id
     * @param  staff_id       员工id
     * 
     * @return array
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getGroupInfo($param){
        $cacheKey = 'mc_interface_5cc6ed5f19c60_'.md5(json_encode($param));
        //如果需要缓存，即是那些查询类的，需要定义好缓存KEY，
        //并且在本类的cleanCache里加上清除的方法，
        //这样在公共的清除缓方法里，会调用此方法清除缓存
        if(cache('?'.$cacheKey)){
            return cache($cacheKey);
        }else{
            $res = sx_call('5cc6ed5f19c60', $param);
            $return = $this->retResult($res);
            if($return !== false){
                cache($cacheKey,$return);
            }
        }
        return $return;
    }
    /**
     * 查询部门下人员    Staff/getDepartmentStaffs
     * 
     * @param  department_id  部门id
     * 
     * @return array
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getStaffByDepartp($params){
        $cacheKey = 'mc_interface_5a0e6f272bb38_'.md5(json_encode($params));
        //如果需要缓存，即是那些查询类的，需要定义好缓存KEY，
        //并且在本类的cleanCache里加上清除的方法，
        //这样在公共的清除缓方法里，会调用此方法清除缓存
        if(cache('?'.$cacheKey)){
            return cache($cacheKey);
        }else{
            $res = sx_call('5a0e6f272bb38', $params);
            $return = $this->retResult($res);
            if($return !== false){
                cache($cacheKey,$return);
            }
        }
        return $return;
    }
    /**
     * 通过ids获取员工信息数组    Staff/getStaffInfos
     * 
     * @param  staff_id  staff_id数组或字符串
     * 
     * @return array
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getStaffByIds($params){
        $cacheKey = 'mc_interface_5a18e3fa516a1_'.md5(json_encode($params));
        //如果需要缓存，即是那些查询类的，需要定义好缓存KEY，
        //并且在本类的cleanCache里加上清除的方法，
        //这样在公共的清除缓方法里，会调用此方法清除缓存
        if(cache('?'.$cacheKey)){
            return cache($cacheKey);
        }else{
            $res = sx_call('5a18e3fa516a1', $params);
            $return = $this->retResult($res);
            if($return !== false){
                cache($cacheKey,$return);
            }
        }
        return $return;
    }
    /**
     * 员工信息查询    Staff/staffInfo 
     * 
     * @param  id             员工id
     * @param  brandclass     事业部名称
     * @param  shop_code      shop_code
     * @param  department_id  部门id
     * @param  position_code  岗位code
     * 
     * @return array
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getStaffInfo($params){
        $cacheKey = 'mc_interface_5a01766b4a3dd_'.md5(json_encode($params));
        //如果需要缓存，即是那些查询类的，需要定义好缓存KEY，
        //并且在本类的cleanCache里加上清除的方法，
        //这样在公共的清除缓方法里，会调用此方法清除缓存
        if(cache('?'.$cacheKey)){
            return cache($cacheKey);
        }else{
            $res = sx_call('5a01766b4a3dd', $params);
            $return = $this->retResult($res);
            if($return !== false){
                cache($cacheKey,$return);
            }
        }
        return $return;
    }
    
    /**
     * 获取单个员工的信息   Staff/get_staff_info 
     * 
     * @param  id              员工id
     *
     * @return array
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getOneStaff($params){
        $cacheKey = 'mc_interface_59f933a395abe_'.md5(json_encode($params));
        if(cache('?'.$cacheKey)){
            return cache($cacheKey);
        }else{
            $res = sx_call('59f933a395abe', $params);
            $return = $this->retResult($res);
            if($return !== false){
                cache($cacheKey,$return);
            }
        }
        return $return;
    }
    /**
     * 获取员工可操作店    Staff/getWorkShop
     * 
     * @param  id             员工id
     * @param  brandclass     事业部名称
     * @param  shop_code      shop_code
     * @param  department_id  部门id
     * @param  position_code  岗位code
     * 
     * @return array
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getWorkShop($params){
        $cacheKey = 'mc_interface_5b9cac8aa21c0_'.md5(json_encode($params));
        //如果需要缓存，即是那些查询类的，需要定义好缓存KEY，
        //并且在本类的cleanCache里加上清除的方法，
        //这样在公共的清除缓方法里，会调用此方法清除缓存
        if(cache('?'.$cacheKey)){
            return cache($cacheKey);
        }else{
            $res = sx_call('5b9cac8aa21c0', $params);
            $return = $this->retResult($res);
            if($return !== false){
                cache($cacheKey,$return);
            }
        }
        return $return;
    }
    /**
     * 店面信息查询    Staff/staffInfo 
     * 
     * @param  id             岗位id
     * @param  brandclass     事业部名称
     * @param  shop_code      shop_code
     * @param  department_id  部门id
     * @param  position_code  岗位code
     * 
     * @return array
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getShops($params){
        $cacheKey = 'mc_interface_5a005e0038270_'.md5(json_encode($params));
        //如果需要缓存，即是那些查询类的，需要定义好缓存KEY，
        //并且在本类的cleanCache里加上清除的方法，
        //这样在公共的清除缓方法里，会调用此方法清除缓存
        if(cache('?'.$cacheKey)){
            return cache($cacheKey);
        }else{
            $res = sx_call('5a005e0038270', $params);
            $return = $this->retResult($res);
            if($return !== false){
                cache($cacheKey,$return);
            }
        }
        return $return;
    }
    /**
     * 店内员工查询    Staff/getStaffsByWorkType 
     * 
     * @param  shop_code      shop_code，多个用,连接
     * @param  work_type      工作类型
     * 
     * @return array
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getStaffsByWorkType($params){
        $cacheKey = 'mc_interface_5b75341456d18_'.md5(json_encode($params));
        if(cache('?'.$cacheKey)){
            return cache($cacheKey);
        }else{
            $res = sx_call('5b75341456d18', $params);
            $return = $this->retResult($res);
            if($return !== false){
                cache($cacheKey,$return);
            }
        }
        return $return;
    }
    /**
     * MC地址字典     System/clientAddress
     * 
     * @param  id          
     * 
     * @return array
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getMcAddress($params){
        $cacheKey = 'mc_interface_59fd885ed3628_'.md5(json_encode($params));
        if(cache('?'.$cacheKey)){
            return cache($cacheKey);
        }else{
            $table = isTableExist('s_address');

            if ($table) {
                if($params['type']){
                    $type='type = :type';
                    $typeArray=['type'=>$params['type']];
                }
                if($params['id']){
                    $sql = ' id in ('.$params['id'].')';
                }
                if($params['pid']){
                    $pid='pid = :pid';
                    $pidArray=['pid'=>$params['pid']];
                }
                if($params['name']){
                    $name='name like :name';
                    $nameArray=['name'=>'%'.$params['name'].'%'];
                }
                $detail=db('s_address')->where($sql)->where($pid,$pidArray)->where($type,$typeArray)->where($name,$nameArray)->order('order_sort asc')->select();

                if($detail){
                    $res = array('code'=>200, 'data'=>$detail);
                }else{
                    $res = array('error'=>1,'code'=>202,'msg'=>'客户地址查询失败！');
                }
            }else{
                $res = sx_call('59fd885ed3628', $params);
            }
            
            $return = $this->retResult($res);
            
            if($return !== false){
                cache($cacheKey,$return);
            }
        }
        return $return;
    }
    public function getAddcustomerShopList($shopCode){
        $shopCode = $shopCode?$shopCode:$this->_shopCode;
        $res = sx_call('5a7076a6ccfaa',['shop_code'=>$shopCode]);
        return $this->retResult($res);

    }
    public function getCustomerResource($shopCode = ''){
        $res = sx_call('59fd5ec462c88',[]);
        return $this->retResult($res);
    }
    public function getCustomerArea(){
        $res = sx_call('5a004e9c3e030');
        return $this->retResult($res);
    }
    public function getCustomerRegin(){
        $res = sx_call('59fd5fa926b98');
        return $this->retResult($res);
    }
    public function getBrandShopList($brandId){
        $res = sx_call('5a005e0038270');
        return $this->retResult($res);
    }
    public function getStaffById($staffId){
        $res = sx_call('5a01766b4a3dd',['id'=>$staffId]);
        if($res['code'] == 200 && $res['data'][0]){
            return $this->retResult(['code'=>200,'data'=>$res['data'][0]]);
        }else{
            return $this->retResult($res);
        }
    }
    /**
     * 根据部门ID，获取部门下所有员工
     * 
     */
    public function getStaffListByDepartmentId($departmentId){
        $res = sx_call('5a01766b4a3dd',['department_id'=>$departmentId]);
        return $this->retResult($res);
    }
    /**
     * 根据门店编码，获取店下直属员工
     * 
     */
    public function getStaffListByShopcode($shopCode){
        $res = sx_call('5a01766b4a3dd',['shop_code'=>$shopCode,'grade_type'=>3]);
        return $this->retResult($res);
    }
    /**
     * 根据店号获取店下的所有部门
     * @param  [type] $shopCode [description]
     * @return [type]           [description]
     */
    public function getDepartmentByShopcode($shopCode){
        // $res = sx_call('5a0aef152b750',['shop_code'=>$shopCode]);
        // return $this->retResult($res);
        $params['shop_code'] = $shopCode;
        $cacheKey = 'mc_interface_5a0aef152b750_'.md5(json_encode($params));
        if(cache('?'.$cacheKey)){
            return cache($cacheKey);
        }else{
            $res = sx_call('5a0aef152b750', $params);
            $return = $this->retResult($res);
            if($return !== false){
                cache($cacheKey,$return);
            }
        }
        return $return;
    }
    /**
     * 获取部门信息
     * 
     * @param  [type] $departmentId [description]
     * @return [type]               [description]
     */
    public function getDepartmentById($departmentId){
        $res = sx_call('5a0aef152b750',['id'=>$departmentId]);
        if($res['data'][0]){
            return $this->retResult(['code'=>200,'data'=>$res['data'][0]]);
        }else{
            return $this->retResult($res);
        }

    }
    
    // 根据branclass 查事业部下所有的店
    public function getBrandShops($brandclass){
        $data['brandclass'] = $brandclass;
        $cacheKey = 'mc_interface_5a005e0038270_'.md5(json_encode($data));
        //如果需要缓存，即是那些查询类的，需要定义好缓存KEY，
        //并且在本类的cleanCache里加上清除的方法，
        //这样在公共的清除缓方法里，会调用此方法清除缓存
        if(cache('?'.$cacheKey)){
            $cacheData = cache($cacheKey);
            return $cacheData['data'];
        }else{
            $res = sx_call('5a005e0038270', $data);
            $return = $this->retResult($res);
            if($return !== false){
                cache($cacheKey,['data'=>$return]);
            }
        }
        
        return $return;
    }
    // 短信模板
    public function getSMSModel($param){
        $cacheKey = 'mc_interface_5d78e5b101c5c_'.md5(json_encode($param));
        //如果需要缓存，即是那些查询类的，需要定义好缓存KEY，
        //并且在本类的cleanCache里加上清除的方法，
        //这样在公共的清除缓方法里，会调用此方法清除缓存
        if(cache('?'.$cacheKey)){
            return cache($cacheKey);
        }else{
            $res = sx_call('5d78e5b101c5c', $param);

            $return = $this->retResult($res);
            if($return !== false){
                cache($cacheKey,$return);
            }
        }
        return $return;
    }

    public function getStaffsByShopCode($shopCode){
        $res = sx_call('5a01766b4a3dd',['shop_code'=>$shopCode,'grade_type'=>4]);
        return $this->retResult($res);
    }

    /**
     * 获取品牌信息，如果不传参数，则获取所有品牌数据，如果传了id或是brandclass则按ID或品牌名称获取某个品牌信息
     * 
     * @param  [Array] $params [按ID查时，传[id=>?],按名称查时，传[brandclass=>?]]
     * @return [Array]         [获取所有品牌时，返回的是二维数组，获取某个品牌信息时，返回的是一维数组]
     */
    public function getBrand($params){
        $cacheKey = 'mc_interface_5a3bbb5d0988d';
        //如果需要缓存，即是那些查询类的，需要定义好缓存KEY，
        //并且在本类的cleanCache里加上清除的方法，
        //这样在公共的清除缓方法里，会调用此方法清除缓存
        if(cache('?'.$cacheKey)){
            $return = cache($cacheKey);
        }else{
            $res = sx_call('5a3bbb5d0988d');
            $return = $this->retResult($res);
            if($return !== false){
                cache($cacheKey,$return);
            }
        }
        if($return){
            if($params['brandclass']){
                foreach ($return as $value) {
                    if($value['brandclass'] == $params['brandclass']){
                        $info = $value;
                    }
                }
                //指定条件时，如果没找到，返回空
                if(!$info){
                    $return = [];
                }else{
                    $return = $info;
                }
            }
            if($params['id']){
                foreach ($return as $value) {
                    if($value['id'] == $params['id']){
                        $info = $value;
                    }
                }
                //指定条件时，如果没找到，返回空
                if(!$info){
                    $return = [];
                }else{
                    $return = $info;
                }
            }
        }
        return $return;
    }

    // 根据shop_code 店面信息
    public function getShopInfo($param){
        // $data['shop_code'] = $param['shop_code'];
        $cacheKey = 'mc_interface_5a005e0038270_'.md5(json_encode($param));
        //如果需要缓存，即是那些查询类的，需要定义好缓存KEY，
        //并且在本类的cleanCache里加上清除的方法，
        //这样在公共的清除缓方法里，会调用此方法清除缓存
        if(cache('?'.$cacheKey)){
            return cache($cacheKey);
        }else{
            $res = sx_call('5a005e0038270', $param);
            $return = $this->retResult($res);
            if($return !== false){
                cache($cacheKey,$return);
            }
        }
        
        return $return;
    }
    public function cacheData($hash,$data){
        if (!$hash) {
            return [];
        }
        $cacheKey = 'mc_interface_cache_'.$hash.'_'.md5(json_encode($data));
        if(cache('?'.$cacheKey)){
            $cacheData = cache($cacheKey);
            return $cacheData['data'];
        }else{
            $res = sx_call($hash, $data);
            $return = $this->retResult($res);
            if($return !== false){
                cache($cacheKey,['data'=>$return]);
            }
        }
        return $return;
    }
    /**
     * 清除缓存方法，清除除所有本类设置的缓存
     * 
     * @param  string $cacheName [description]
     * @return [type]            [description]
     */
    static function cleanCache($cacheName=''){
        if($cacheName){
            cache($cacheName.'*',null);
        }
        cache('mc_interface_*',null);
    }
    /*
       * 根据token Staff/checkToken
      */
    public function checkToken($staff_id,$token){
//        $cacheKey = 'mc_interface_5b3ae7a95f370_'.md5($token);
        //如果需要缓存，即是那些查询类的，需要定义好缓存KEY，
        //并且在本类的cleanCache里加上清除的方法，
        //这样在公共的清除缓方法里，会调用此方法清除缓存
//        if(cache('?'.$cacheKey)){
//            return cache($cacheKey);
//        }else{
        $res = sx_call('5b3ae7a95f370', ['staff_id'=>$staff_id,'token'=>$token]);
        $return = $this->retResult($res);
//            if($return !== false){
//                cache($cacheKey,$return);
//            }
//        }
        return $return;
    }
     /**
     * 根据组id取组下的人 5cf8d76edd1ca
     * 
     * @param  group_id   
     * @return 
     */
    public function getStaffInfoByGid($param){
        $data['group_id'] = $param['group_id'];
        $cacheKey = 'mc_interface_5cf8d76edd1ca_'.md5(json_encode($data));
        //如果需要缓存，即是那些查询类的，需要定义好缓存KEY，
        //并且在本类的cleanCache里加上清除的方法，
        //这样在公共的清除缓方法里，会调用此方法清除缓存
        if(cache('?'.$cacheKey)){
            return cache($cacheKey);
        }else{
            $res = sx_call('5cf8d76edd1ca', $data);
            $return = $this->retResult($res);
            if($return !== false){
                cache($cacheKey,$return);
            }
        }
        return $return;
    }
}