<?php
/**
 * CRM 报表控制器
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: lilong/wangzhenya  2018-05-24 $
 */
namespace app\crm\controller;
use think\Cache;
use app\index\controller\Base;
use think\Exception;
use think\Log;
use think\Request;
use think\Session;
use think\Controller;

class Report extends Base{
    /*
	 *控制器基本入口
     */
    public function index(){
        // 报表ID即报表类名（lib/report/$id）
        // var $id = input('get.id');
        $id = strtolower(input('param.id'));

        $get = input('get.');
        if ($get['sign']=='app') {
            // $sid = $get['staff_id'];
            // session('staff_id', $sid);
            // $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
            
            /*if ($auth === false) {
                echo '您无查看此页面权限！';die;
                // $this->redirect('/crm/Customer/index');
            }*/

        }

        // 通过反射类，判断该类是否存在
        if(!class_exists('app\\crm\\lib\\report\\'.ucwords($id) ) ) {
            echo '没有发现这个类：'.$id."\r\n";
            exit();
        }
        $instance = new \ReflectionClass('app\\crm\\lib\\report\\'.ucwords($id));
        $method = 'show';
        if (!$instance->hasMethod($method)) {
            echo '没有发现这个方法：'.$method."\r\n";
            exit();
        }

        $objMethod = $instance->getMethod($method);

        $handle = $instance->newInstance();
        
        $display = $objMethod->invokeArgs($handle,array());
        return $display;
    }

    //查询请求方法
    public function data(){
        $data = input();
        $id = strtolower($data['id']);
        // 通过反射类，判断该类是否存在
        if(!class_exists('app\\crm\\lib\\report\\'.ucwords($id))){
            echo '没有发现这个类：'.ucwords($data['id'])."\r\n";
            exit();
        }
        $instance = new \ReflectionClass('app\\crm\\lib\\report\\'.ucwords($id));
        $method = 'data';
        if (!$instance->hasMethod($method)) {
            echo '没有发现这个方法：'.$method."\r\n";
            exit();
        }

        $objMethod = $instance->getMethod($method);

        $handle = $instance->newInstance();

        $display = $objMethod->invokeArgs($handle,$data);
        return $display;
    }

    /*
     * 设置表头
     */
    public function setTitle(){
        $data = input();
        $id = strtolower($data['id']);
        // 通过反射类，判断该类是否存在
        if(!class_exists('app\\crm\\lib\\report\\'.ucwords($id))){
            echo '没有发现这个类：'.ucwords($data['id'])."\r\n";
            exit();
        }
        $instance = new \ReflectionClass('app\\crm\\lib\\report\\'.ucwords($id));
        $method = 'setTitle';
        if (!$instance->hasMethod($method)) {
            echo '没有发现这个方法：'.$method."\r\n";
            exit();
        }

        $objMethod = $instance->getMethod($method);

        $handle = $instance->newInstance();

        $display = $objMethod->invokeArgs($handle,$data);
        return $display;
    }

    //添加报表
    public function add(){
        $data = input();
        $report_class_name = ucwords(strtolower($data['report_class_name']));
        // 通过反射类，判断该类是否存在
        if(!class_exists('app\\crm\\lib\\report\\'.$report_class_name)){
            return array('code'=>101,'msg'=>'没有发现这个报表','data'=>'');
        }
        $instance = new \ReflectionClass('app\\crm\\lib\\report\\'.$report_class_name);
        $obj = $instance->getMethod('getLevel');
        $type = $instance->getMethod('getType');
        $code = $instance->getMethod('getCode');
        $handle = $instance->newInstance();
        $level = $obj->invokeArgs($handle,array());
        $type = $type->invokeArgs($handle,array());
        $code = $code->invokeArgs($handle,array());
        //查询有无数据
        $info = db('s_report_form')->where('report_class_name',$report_class_name)->find();
        db()->startTrans();
        try {
            if(!$info['id']) {//插入报表设定
                    $form = [
                        'report_class_name' => $report_class_name,
                        'report_name' => $data['report_name'],
                        'report_url' => url('Report/index',['id'=>$report_class_name]),
                        'level' => $level,
                        'report_type' => $type,
                        'code' => $code,
                        'status' => 1,
                        'add_time' => date('Y-m-d H:i:s'),
                    ];
                    db('s_report_form')->insert($form);

            }else{//修改报表设定
                $form = [
                    'report_class_name' => $report_class_name,
                    'report_name' => $data['report_name'],
                    'report_url' => url('Report/index',['id'=>$report_class_name]),
                    'level' => $level,
                    'report_type' => $type,
                    'code' => $code,
                    'status' => 1,
                ];
                db('s_report_form')->where('id',$info['id'])->update($form);
            }
                db()->commit();
                action_log($info,$form,0,session('staff_id'),session('staff_name'));
                return array('code'=>200,'msg'=>'报表接口添加成功','data'=>'');
            } catch (Exception $e) {
                db()->rollback();
                return array('code'=>100,'msg'=>'报表接口添加失败','data'=>$e->getMessage());
            }
    }
    /**
     * 获取时间范围
     */
    public function DataScope(){
        $param = input("");

        $data = getdateArea($param['data']);
        foreach($data as $key=>$value){
            $data[$key] = date("Y-m-d",strtotime($value));
        }
        return array('code'=>200,'data'=>$data);
    }

}