<?php
/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
namespace app\crm\lib;

use think\controller;
class Systemlist extends controller{

	protected $errid = 0;
	protected $errmsg = '';
	// log日志
	function log($str){
        if(config('app_debug')){
            echo date('Y-m-d H:i:s').$str."\r\n";
        }
    }

	// dj_customer 数据统计用==>提报客资数  录入
	public function dj_customer($data, $cid, $hid, $eid){
		db()->startTrans();
		try {
			foreach ($data as $k => $v) {
				$result = getTable($v);
				// $this->log('getTable:'.json_encode($result));
				$where = ['addtime'=>$result['useDay'],'staff_id'=>$k];
				$count = db($result['table'])->where($where)->count();
				// $this->log('count:'.$count);
				if ($count) {
					$res = db($result['table'])->where($where)->setInc('dj_customer');
					// $this->log('inc:'.$res);
				}else{
					$staffInfo = getStaffInfoById($k);
					$inData = array(
						'dj_customer' => 1,
						'addtime'	  => $result['useDay'],
						'staff_id'	  => $k,
						'staff_name'  => $staffInfo['staffname'],
						'staff_number'=> $staffInfo['staffnumber'],
						'shop_code'   => $staffInfo['shop_code'],
					);
					$res = db($result['table'])->insert($inData);
					// $this->log('inc:'.$res);
				}
			}
			// 如果存在导入id
			if ($eid && $eid != 0) {
				$res = db('c_history_data')->where('id', $hid)->find();
				$sid = $res['success_id'];
				$dataIn['success_id'] = $sid.$cid.',';
				$res = db('c_history_data')->where('id', $hid)->update($dataIn);
				// $this->log('update_eid:'.$res);
			}else{
				$dataIn['success_id'] = $cid;
				$res = db('c_history_data')->where('id', $hid)->update($dataIn);
				// $this->log('update_dj_customer:'.$res);;
			}
			db()->commit();
			return true;
		} catch (Exception $e) {
			$error = db()->getLastSql();
			$this->log('dj_customer_warning--rollback:'.$error);
			db()->rollback();
			return false;
		}
	}

	// dj_mobile 数据统计用==>提报手机号数  录入
	public function dj_mobile($data, $cid, $hid, $eid){
		db()->startTrans();
		try {
			foreach ($data as $k => $v) {
				$result = getTable($v);
				// $this->log('getTable:'.json_encode($result));
				$where = ['addtime'=>$result['useDay'],'staff_id'=>$k];
				$count = db($result['table'])->where($where)->count();
				// $this->log('count:'.$count);
				if ($count) {
					$res = db($result['table'])->where($where)->setInc('dj_mobile');
					// $this->log('inc:'.$res);
				}else{
					$staffInfo = getStaffInfoById($k);
					// 如果没有，需要insert的原始数据
					$inData = array(
						'dj_mobile'   => 1,
						'addtime'	  => $result['useDay'],
						'staff_id'	  => $k,
						'staff_name'  => $staffInfo['staffname'],
						'staff_number'=> $staffInfo['staffnumber'],
						'shop_code'   => $staffInfo['shop_code'],
					);
					$res = db($result['table'])->insert($inData);
					// $this->log('ins:'.$res);
				}
			}
			
			// 如果存在导入id
			if ($eid && $eid != 0) {
				// $this->log('hid:'.$hid);
				$res = db('c_history_data')->where('id', $hid)->find();
				$sid = $res['success_id'];
				$dataIn['success_id'] = $sid.$cid.',';
				$res = db('c_history_data')->where('id', $hid)->update($dataIn);
				// $this->log('update_eid:'.$res);
			}else{
				$dataIn['success_id'] = $cid;
				// $this->log('[hid==>'.$hid.'],[data==>'.json_encode($dataIn).']');
				$res = db('c_history_data')->where('id', $hid)->update($dataIn);
				$sql = db()->getLastSql();
				// $this->log('sql'.$sql);
				// $this->log('update_dj_mobile:'.$res);
			}
			db()->commit();
			return true;
		} catch (Exception $e) {
			$error = db()->getLastSql();
			$this->log('dj_mobile_warning--rollback:'.$error);
			db()->rollback();
			return false;
		}
	}

	// sel_customer 数据统计用==>筛客 客资数量  筛客
	public function sel_customer($data, $staff_id){
		db()->startTrans();
		try {
			foreach ($data as $k => $v) {
				if ($k != $staff_id) {
					continue;
				}
				$result = getTable($v);
				// $this->log('result_sel_customer:'.json_encode($result));
				$where = ['addtime'=>$result['useDay'],'staff_id'=>$k];
				$count = db($result['table'])->where($where)->count();
				// $this->log('result_count:'.$count);
				if ($count) {
					$res = db($result['table'])->where($where)->setInc('sel_customer');
					// $this->log('inc_sel_customer:'.$res);
				}else{
					$staffInfo = getStaffInfoById($k);
					// 如果没有，需要insert的原始数据
					$inData = array(
						'sel_customer'=> 1,
						'addtime'	  => $result['useDay'],
						'staff_id'	  => $k,
						'staff_name'  => $staffInfo['staffname'],
						'staff_number'=> $staffInfo['staffnumber'],
						'shop_code'   => $staffInfo['shop_code'],
					);
					$res = db($result['table'])->insert($inData);
					// $this->log('ins_sel_customer:'.$res);
				}
			}
			db()->commit();
			return true;
		} catch (Exception $e) {
			$error = db()->getLastSql();
			$this->log('sel_customer_warning--rollback:'.$res);
			db()->rollback();
			return false;
		}
	}

	// fp_customer 数据统计用==>分配客资数  销售  筛客
	public function fp_customer($data){
		// 如果三个，去掉第一个
		if (count($data) == 3) {
			$first_key = key($data);
			unset($data[$first_key]);
		}
		db()->startTrans();
		try {
			foreach ($data as $k => $v) {
				$result = getTable($v);
				$where = ['addtime'=>$result['useDay'],'staff_id'=>$k];
				$count = db($result['table'])->where($where)->count();
				if ($count) {
					db($result['table'])->where($where)->setInc('fp_customer');
				}else{
					$staffInfo = getStaffInfoById($k);
					// 如果没有，需要insert的原始数据
					$inData = array(
						'fp_customer' => 1,
						'addtime'	  => $result['useDay'],
						'staff_id'	  => $k,
						'staff_name'  => $staffInfo['staffname'],
						'staff_number'=> $staffInfo['staffnumber'],
						'shop_code'   => $staffInfo['shop_code'],
					);
					$res = db($result['table'])->insert($inData);
				}
			}
			db()->commit();
			return true;
		} catch (Exception $e) {
			$error = db()->getLastSql();
			$this->log('fp_customer_warning--rollback:'.$error);
			db()->rollback();
			return false;
		}
	}

	// fp_customer 数据统计用==>重新分配用  即 从分配到分配
	public function fp_customer_new($ndata){
		db()->startTrans();
		try {
			foreach ($ndata as $k => $v) {
				$result = getTable($v);
				$where = ['addtime'=>$result['useDay'],'staff_id'=>$k];
				db($result['table'])->where($where)->setDec('fp_customer');
			}
			db()->commit();
			return true;
		} catch (Exception $e) {
			$error = db()->getLastSql();
			$this->log('fp_customer_new_warning--rollback:'.$error);
			db()->rollback();
			return false;
		}
	}


	// fp_no_mobile 数据统计用==>分配无手机号数  销售  筛客
	public function fp_no_mobile($data){
		// 如果三个，去掉第一个
		if (count($data) == 3) {
			$first_key = key($data);
			unset($data[$first_key]);
		}
		db()->startTrans();
		try {
			foreach ($data as $k => $v) {
				$result = getTable($v);
				$where = ['addtime'=>$result['useDay'],'staff_id'=>$k];
				$count = db($result['table'])->where($where)->count();
				if ($count) {
					db($result['table'])->where($where)->setInc('fp_no_mobile');
				}else{
					$staffInfo = getStaffInfoById($k);
					// 如果没有，需要insert的原始数据
					$inData = array(
						'fp_no_mobile'=> 1,
						'addtime'	  => $result['useDay'],
						'staff_id'	  => $k,
						'staff_name'  => $staffInfo['staffname'],
						'staff_number'=> $staffInfo['staffnumber'],
						'shop_code'   => $staffInfo['shop_code'],
					);
					$res = db($result['table'])->insert($inData);
				}
			}
			db()->commit();
			return true;
		} catch (Exception $e) {
			$error = db()->getLastSql();
			$this->log('fp_no_mobile_warning--rollback:'.$error);
			db()->rollback();
			return false;
		}
	}

	// add_mobile 数据统计用==>新增手机号数  销售  筛客
	public function add_mobile($data, $sta){
		if (count($data) == 3) {
			$first_key = key($data);
			unset($data[$first_key]);
		}
		db()->startTrans();
		try {
			foreach ($data as $k => $v) {
				$result = getTable($v);
				$where = ['addtime'=>$result['useDay'],'staff_id'=>$k];
				$count = db($result['table'])->where($where)->count();
				if ($count) {
					if ($sta == 'inc') {
						db($result['table'])->where($where)->setInc('add_mobile');
					}else if ($sta = 'dec') {
						db($result['table'])->where($where)->setDec('add_mobile');
					}
				}else{
					$staffInfo = getStaffInfoById($k);
					// 如果没有，需要insert的原始数据
					$inData = array(
						'add_mobile'  => 1,
						'addtime'	  => $result['useDay'],
						'staff_id'	  => $k,
						'staff_name'  => $staffInfo['staffname'],
						'staff_number'=> $staffInfo['staffnumber'],
						'shop_code'   => $staffInfo['shop_code'],
					);
					$res = db($result['table'])->insert($inData);
				}
			}
			db()->commit();
			return true;
		} catch (Exception $e) {
			$error = db()->getLastSql();
			$this->log('add_mobile_warning--rollback:'.$error);
			db()->rollback();
			return false;
		}
	}

	// valid_customer 数据统计用==>有效客资数  销售  筛客  录入
	public function valid_customer($data, $sta){
		db()->startTrans();
		try {
			foreach ($data as $k => $v) {
				$result = getTable($v);
				$where = ['addtime'=>$result['useDay'],'staff_id'=>$k];
				$count = db($result['table'])->where($where)->count();

				if ($count) {
					if ($sta == 'inc') {
						db($result['table'])->where($where)->setInc('valid_customer');
					}else if ($sta == 'dec') {
						db($result['table'])->where($where)->setInc('valid_customer');
						db($result['table'])->where($where)->setDec('no_valid_customer');
					}
				}else{
					$staffInfo = getStaffInfoById($k);
					// 如果没有，需要insert的原始数据
					$inData = array(
						'valid_customer'=> 1,
						'addtime'	    => $result['useDay'],
						'staff_id'	    => $k,
						'staff_name'    => $staffInfo['staffname'],
						'staff_number'  => $staffInfo['staffnumber'],
						'shop_code'     => $staffInfo['shop_code'],
					);
					$res = db($result['table'])->insert($inData);
				}
			}
			db()->commit();
			return true;
		} catch (Exception $e) {
			$error = db()->getLastSql();
			$this->log('valid_customer_warning--rollback:'.$error);
			db()->rollback();
			return false;
		}
	}
	
	// no_valid_customer 数据统计用==>无效客资数  销售  筛客  录入
	public function no_valid_customer($data, $sta){
		db()->startTrans();
		try {
			foreach ($data as $k => $v) {
				$result = getTable($v);
				$where = ['addtime'=>$result['useDay'],'staff_id'=>$k];
				$count = db($result['table'])->where($where)->count();
				if ($count) {
					if ($sta == 'inc') {
						db($result['table'])->where($where)->setInc('no_valid_customer');
					}else if ($sta == 'dec') {
						db($result['table'])->where($where)->setInc('no_valid_customer');
						db($result['table'])->where($where)->setDec('valid_customer');
					}
				}else{
					$staffInfo = getStaffInfoById($k);
					// 如果没有，需要insert的原始数据
					$inData = array(
						'no_valid_customer'=> 1,
						'addtime'	    => $result['useDay'],
						'staff_id'	    => $k,
						'staff_name'    => $staffInfo['staffname'],
						'staff_number'  => $staffInfo['staffnumber'],
						'shop_code'     => $staffInfo['shop_code'],
					);
					$res = db($result['table'])->insert($inData);
				}
			}
			db()->commit();
			return true;
		} catch (Exception $e) {
			$error = db()->getLastSql();
			$this->log('no_valid_customer_warning--rollback:'.$error);
			db()->rollback();
			return false;
		}
	}
	
	// yjd 数据统计用==>预约进店数  销售  筛客  录入
	public function yjd($data, $sta){
		db()->startTrans();
		try {
			foreach ($data as $k => $v) {
				$result = getTable($v);
				$where = ['addtime'=>$result['useDay'],'staff_id'=>$k];
				$count = db($result['table'])->where($where)->count();
				if ($count) {
					if ($sta == 'inc') {
						db($result['table'])->where($where)->setInc('yjd');
					}else if ($sta == 'dec') {
						db($result['table'])->where($where)->setDec('yjd');
					}
				}else{
					$staffInfo = getStaffInfoById($k);
					// 如果没有，需要insert的原始数据
					$inData = array(
						'yjd'         => 1,
						'addtime'	  => $result['useDay'],
						'staff_id'	  => $k,
						'staff_name'  => $staffInfo['staffname'],
						'staff_number'=> $staffInfo['staffnumber'],
						'shop_code'   => $staffInfo['shop_code'],
					);
					$res = db($result['table'])->insert($inData);
				}
			}
			db()->commit();
			return true;
		} catch (Exception $e) {
			$error = db()->getLastSql();
			$this->log('yjd_warning--rollback:'.$error);
			db()->rollback();
			return false;
		}
	}
	
	// syjd_jk 数据统计用==>实际进店数，进客  销售  筛客  录入
	public function syjd_jk($data, $sta){
		db()->startTrans();
		try {
			foreach ($data as $k => $v) {
				$result = getTable($v);
				$where = ['addtime'=>$result['useDay'],'staff_id'=>$k];
				$count = db($result['table'])->where($where)->count();
				if ($count) {
					if ($sta == 'inc') {
						db($result['table'])->where($where)->setInc('syjd_jk');
					}else if ($sta == 'dec') {
						db($result['table'])->where($where)->setDec('syjd_jk');
					}else if ($sta == 'no') {
						db($result['table'])->where($where)->setInc('syjd_jk');
						db($result['table'])->where($where)->setDec('syjd_no_jk');
					}
				}else{
					$staffInfo = getStaffInfoById($k);
					// 如果没有，需要insert的原始数据
					$inData = array(
						'syjd_jk'         => 1,
						'addtime'	  => $result['useDay'],
						'staff_id'	  => $k,
						'staff_name'  => $staffInfo['staffname'],
						'staff_number'=> $staffInfo['staffnumber'],
						'shop_code'   => $staffInfo['shop_code'],
					);
					$res = db($result['table'])->insert($inData);
				}
			}
			db()->commit();
			return true;
		} catch (Exception $e) {
			$error = db()->getLastSql();
			$this->log('syjd_jk_warning--rollback:'.$error);
			db()->rollback();
			return false;
		}
	}
	
	// syjd_no_jk 数据统计用==>实际进店数，非进客  销售  筛客  录入
	public function syjd_no_jk($data, $sta){
		db()->startTrans();
		try {
			foreach ($data as $k => $v) {
				$result = getTable($v);
				$where = ['addtime'=>$result['useDay'],'staff_id'=>$k];
				$count = db($result['table'])->where($where)->count();
				if ($count) {
					if ($sta == 'inc') {
						db($result['table'])->where($where)->setInc('syjd_no_jk');
					}else if ($sta == 'dec') {
						db($result['table'])->where($where)->setDec('syjd_no_jk');
					}else if ($sta == 'no') {
						db($result['table'])->where($where)->setInc('syjd_no_jk');
						db($result['table'])->where($where)->setDec('syjd_jk');
					}
				}else{
					$staffInfo = getStaffInfoById($k);
					// 如果没有，需要insert的原始数据
					$inData = array(
						'syjd_no_jk'  => 1,
						'addtime'	  => $result['useDay'],
						'staff_id'	  => $k,
						'staff_name'  => $staffInfo['staffname'],
						'staff_number'=> $staffInfo['staffnumber'],
						'shop_code'   => $staffInfo['shop_code'],
					);
					$res = db($result['table'])->insert($inData);
				}
			}
			db()->commit();
			return true;
		} catch (Exception $e) {
			$error = db()->getLastSql();
			$this->log('syjd_no_jk_warning--rollback:'.$error);
			db()->rollback();
			return false;
		}
	}

	// orders 数据统计用==>成单数  销售  筛客  录入
	public function orders($data, $sta){
		db()->startTrans();
		try {
			foreach ($data as $k => $v) {
				$result = getTable($v);
				$where = ['addtime'=>$result['useDay'],'staff_id'=>$k];
				$count = db($result['table'])->where($where)->count();
				if ($count) {
					if ($sta == 'inc') {
						db($result['table'])->where($where)->setInc('orders');
					}else if ($sta == 'dec') {
						db($result['table'])->where($where)->setDec('orders');
					}
				}else{
					$staffInfo = getStaffInfoById($k);
					// 如果没有，需要insert的原始数据
					$inData = array(
						'orders'       => 1,
						'addtime'	  => $result['useDay'],
						'staff_id'	  => $k,
						'staff_name'  => $staffInfo['staffname'],
						'staff_number'=> $staffInfo['staffnumber'],
						'shop_code'   => $staffInfo['shop_code'],
					);
					$res = db($result['table'])->insert($inData);
				}
			}
			db()->commit();
			return true;
		} catch (Exception $e) {
			$error = db()->getLastSql();
			$this->log('orders_warning--rollback:'.$error);
			db()->rollback();
			return false;
		}
	}

	// valid_order 数据统计用==>有效成单数  销售  筛客  录入
	public function valid_order($data, $sta){
		db()->startTrans();
		try {
			foreach ($data as $k => $v) {
				$result = getTable($v);
				$where = ['addtime'=>$result['useDay'],'staff_id'=>$k];
				$count = db($result['table'])->where($where)->count();
				if ($count) {
					if ($sta == 'inc') {
						db($result['table'])->where($where)->setInc('valid_order');
					}else if ($sta == 'dec') {
						db($result['table'])->where($where)->setDec('valid_order');
					}
				}else{
					$staffInfo = getStaffInfoById($k);
					// 如果没有，需要insert的原始数据
					$inData = array(
						'valid_order' => 1,
						'addtime'	  => $result['useDay'],
						'staff_id'	  => $k,
						'staff_name'  => $staffInfo['staffname'],
						'staff_number'=> $staffInfo['staffnumber'],
						'shop_code'   => $staffInfo['shop_code'],
					);
					$res = db($result['table'])->insert($inData);
				}
			}
			db()->commit();
			return true;
		} catch (Exception $e) {
			$error = db()->getLastSql();
			$this->log('valid_order_warning--rollback:'.$error);
			db()->rollback();
			return false;
		}
	}

	// a_customer 数据统计用==>A客数  销售  筛客  录入
	public function a_customer($data, $sta){
		if (count($data) == 3) {
			$first_key = key($data);
			unset($data[$first_key]);
		}
		db()->startTrans();
		try {
			foreach ($data as $k => $v) {
				$result = getTable($v);
				$where = ['addtime'=>$result['useDay'],'staff_id'=>$k];
				$count = db($result['table'])->where($where)->count();
				if ($count) {
					if ($sta == 'inc') {
						db($result['table'])->where($where)->setInc('a_customer');
					}else if ($sta == 'dec') {
						db($result['table'])->where($where)->setDec('a_customer');
					}
				}else{
					$staffInfo = getStaffInfoById($k);
					// 如果没有，需要insert的原始数据
					$inData = array(
						'a_customer'  => 1,
						'addtime'	  => $result['useDay'],
						'staff_id'	  => $k,
						'staff_name'  => $staffInfo['staffname'],
						'staff_number'=> $staffInfo['staffnumber'],
						'shop_code'   => $staffInfo['shop_code'],
					);
					$res = db($result['table'])->insert($inData);
				}
			}
			db()->commit();
			return true;
		} catch (Exception $e) {
			$error = db()->getLastSql();
			$this->log('a_customer_warning--rollback:'.$error);
			db()->rollback();
			return false;
		}
	}

	// tel_num 数据统计用==>电访量  销售  筛客  录入
	public function tel_num($data){
		try {
			foreach ($data as $k => $v) {
				$result = getTable($v);
				$where = ['addtime'=>$result['useDay'],'staff_id'=>$k];
				$count = db($result['table'])->where($where)->count();
				if ($count) {
					db($result['table'])->where($where)->setInc('tel_visit');
				}else{
					$staffInfo = getStaffInfoById($k);
					// 如果没有，需要insert的原始数据
					$inData = array(
						'tel_visit'   => 1,
						'addtime'	  => $result['useDay'],
						'staff_id'	  => $k,
						'staff_name'  => $staffInfo['staffname'],
						'staff_number'=> $staffInfo['staffnumber'],
						'shop_code'   => $staffInfo['shop_code'],
					);
					$res = db($result['table'])->insert($inData);
				}
			}
			db()->commit();
			return true;
		} catch (Exception $e) {
			$error = db()->getLastSql();
			$this->log('tel_num_warning--rollback:'.$error);
			db()->rollback();
			return false;
		}
	}

	// 待续。。。	
}