<?php
/**
 * 报表实现类 花费数据分析
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: lilong/wangzhenya 2018-05-24 $
 */
namespace app\crm\lib\report;
use app\crm\lib\Report;
use think\Controller;
use think\image\Exception;

class Costdata extends Report {

    private $level=1;
    private $type=1;
    private $code='code1527312667';

    public function getLevel(){
        return $this->level;

    }
    public function getType(){
        return $this->type;
    }
    public function getCode(){
        return $this->code;
    }
    public function data()
    {
        $param = input();
        $start = $param['start'] ? date('Y-m-d', strtotime($param['start'])) : date('Y-m-d');
        $end =  $param['end'] ? date('Y-m-d', strtotime($param['end'])) : date('Y-m-d');
        $det = db('s_report_form')->alias('f')->join('s_report_detail d','d.form_id=f.id')->where('d.id',$param['did'])->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();
        // $shopCode = $det['shop_code'];
        $shopCode = $det['shop_code'] ? $det['shop_code'] : session('shop_code');
        if(empty($shopCode)){
            return array('code'=>100,'msg'=>'报表配置有误');
        }
//        $shopCode = session('shop_code');->where('FIND_IN_SET("'.$shopCode.'",share_shops)')
        $info = db('s_channel_cost')->where('shop_code',$shopCode)->where('cost_date','between',[$start,$end])->order('channel_id')->field('channel_id,channel_name,city_id,city_name,cost,province_id,province_name')->select();
        $count = [];
        $channel = db('s_channel')->where('shop_code',$shopCode)->order('order_sort')->column('channel_name','id');
        foreach($channel as $k=>$v){
            $channelOut[] = ['channel_name'=>$v,'id'=>$k];
        }

        if($param['city']){
            $city = db('s_shop_address')->where('shop_code',$shopCode)->where('type',2)->column('name','id');
        }else{
            $city = db('s_shop_address')->where('shop_code',$shopCode)->where('type',1)->column('name','id');
        }
        $return = [];
        $countCity = [];
        foreach ($info as $key => $value) {
            $return[$value['channel_id']]['channel_name'] =$value['channel_name'];
            $count[$value['channel_id']] +=  $value['cost'];
            if($param['city']){
                $return[$value['channel_id']][$value['city_id']]['cost'] += $value['cost'];
                $countCity[$value['city_id']]['id'] = $value['city_id'];
                $countCity[$value['city_id']]['name'] = $value['city_name'];
                $countCity[$value['city_id']]['cost'] += $value['cost'];
            }else{
                $return[$value['channel_id']][$value['province_id']]['cost'] += $value['cost'];
                $countCity[$value['province_id']]['id'] = $value['province_id'];
                $countCity[$value['province_id']]['name'] = $value['province_name'];
                $countCity[$value['province_id']]['cost'] += $value['cost'];
            }
        }

        // 导出
        if ($param['need'] == 1) {
            $title = $city;
            array_unshift($title,'渠道');
            array_push($title,'总计');
            $import = [];
            $i = 0;
            $j = 0;

            foreach($channel as $k=>$v){

                $import[$i][$j] = $v;
               // $import[$j][$i] = $v;
                foreach($city as $kk=>$vv){
                    $j++;
                    if($return[$k][$kk]['cost']){
                        $import[$i][$j] += (float)$return[$k][$kk]['cost'];
                    }else if(!isset( $import[$i][$j])){
                        $import[$i][$j] = '';
                    }
                }
                $import[$i][$j+1] = $count[$k];
                $j = 0;
                $i++;
            }
            $import[$i+1][0] = '总计';
            foreach($city as $kk=>$vv){
                $j++;
                $import[$i+1][$j] = sprintf('%.2f',$countCity[$kk]['cost']);
            }
            $import[$i+1][$j+1] = sprintf('%.2f',array_sum($count));
            $code = $this->getCode();
            $ff = db('s_report_form')->where('code', $code)->value('report_name');
            $shop = controller('crm/Customer','lib')->get_shop(['shop_code'=>$shopCode]);
            $file = $shop[0]['shop_name'].'-'.$ff.'.xlsx';
            controller("crm/Customer", "lib")->export($title, $import, $file);
        } else {
            return json(['code'=>200,'data'=>$return,'count'=>$count,'countCity'=>$countCity,'channel'=>$channelOut,'city'=>$city]);
        }
    }

    public function show(){
        $did = strtolower(input('param.did'));
        $info = db('s_report_form')->alias('f')->join('s_report_detail d','d.form_id=f.id')->where('d.id',$did)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();
        $display = APP_PATH.'crm'.DS.'view'.DS.'report'.DS.strtolower($info['report_class_name']).'.html';
        $city = db('s_shop_address')->where('shop_code',$info['shop_code'])->where('type',2)->select();
        $this->assign('city',$city);
        $shopInfo = controller('crm/Customer','lib')->get_shop(['shop_code'=>$info['shop_code']]);
        $code = $this->getCode();
        $title = db('s_report_form')->where('code', $code)->value('report_name');
        $this->assign('title',$shopInfo[0]['shop_name']. '-'.$title);
        $this->assign('did', $info['id']);
        return $this->fetch($display);
    }

}