<?php
/**
 * 报表实现类 深挖数据统计
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: lilong/wangzhenya 2018-05-29 $
 */
namespace app\crm\lib\report;
use app\crm\lib\Report;
use think\Controller;
use think\image\Exception;

class Dsj_zjs_dep_data extends Report {

    private $level=1;
    private $type=3;
    private $code='code1550026165';

    public function getLevel(){
        return $this->level;

    }
    public function getType(){
        return $this->type;
    }
    public function getCode(){
        return $this->code;
    }
    public function data()
    {
        set_time_limit(0);
        $data = input();
        // 时间区域
        if (!$data['start'] || !$data['end']) {
            $return = ['code' => 200, 'msg' => '请选择时间区间', 'count' => 0, 'data' => '',];
            return json($return);
        }
        $det = db('s_report_form')->alias('f')->join('s_report_detail d','d.form_id=f.id')->where('d.id',$data['did'])->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();
        $shop_code = $det['shop_code'];

        if(empty($shop_code)){
            return array('code'=>100,'msg'=>'报表配置有误');
        }

        $start = date('Y-m-d', strtotime($data['start']));
        $end = date('Y-m-d 23:59:59', strtotime($data['end']));
        $where['is_status'] = 1;
        $where['customer_type'] = 2;
        $where['shop_code'] = $data['shop_code'] ? $data['shop_code'] : $shop_code;

        if($data['consultation_type_id']){
            $where['consultation_type_id'] = intval($data['consultation_type_id']);
        }
        if($data['department_id']){
            $dep = controller("crm/Customer",'controller')->getDepartments(array('id' =>$data['department_id'],'shop_code' =>$shop_code));
        }else{
            $dep = controller("crm/Customer",'controller')->getDepartments(array('shop_code' =>$shop_code));
        }

        $where['customer_channel'] = array('in',array_column($dep,'department_name'));
        $sql = '';
        $sql .= "sum(dj_day between '$start' and '$end') as mkz,";//毛客资
        $sql .= "sum(sign_name='A' and sign_time between '$start' and '$end') as a,";//a客
        $sql .= "sum(sign_name='B' and sign_time between '$start' and '$end') as b,";//b客
        $sql .= "sum(sign_name='B转A' and sign_time between '$start' and '$end') as bza";//b转a
        // 录入客资量
        $info= db('c_customerinfo')
            ->where($where)
            ->group('customer_channel')
            ->column($sql,'customer_channel');

        $returnData = [];
        $arr = [];
        $i = 1;
        foreach ($dep as $key => $value) {
            $returnData[$key]['id'] = $i;
            $returnData[$key]['department'] = $value['department_name'];
            $returnData[$key]['mkz'] = $info[$value['department_name']]['mkz'];
            $returnData[$key]['a'] = $info[$value['department_name']]['a'];
            $returnData[$key]['b'] = $info[$value['department_name']]['b'];
            $returnData[$key]['bza'] = $info[$value['department_name']]['bza'];

            $arr['department'] = '总计';
            $arr['mkz'] += $info[$value['department_name']]['mkz'];
            $arr['a'] += $info[$value['department_name']]['a'];
            $arr['b'] += $info[$value['department_name']]['b'];
            $arr['bza'] += $info[$value['department_name']]['bza'];

            $i++;
        }
        array_push($returnData,$arr);

        $return['code'] = 0;
        $return['msg'] = '';
        $return['count'] = count($returnData);
        $return['data'] = $returnData;
        $return['time'] =  date('Y-m-d H:i:s');
        return json($return);

    }

    public function show(){
        $code = $this->getCode();
        $did = strtolower(input('param.did'));
        $info = db('s_report_form')->alias('f')->join('s_report_detail d','d.form_id=f.id')->where('d.id',$did)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();
        $shop= controller('crm/Customer','lib')->get_shop(['shop_code'=>$info['shop_code']]);
        $this->assign('shop', $shop);
        $dep = controller("crm/Customer")->getDepartmentList(array('shop_code' =>$info['shop_code']));
        $this->assign("dep", $dep);

        //消费类型
        $consumptionType = controller("Customer", "lib")->consumptionType(['brandclass_id'=>$info['brandclass_id']]);
        $this->assign("consumptionType", $consumptionType);
        $display = APP_PATH.'crm'.DS.'view'.DS.'report'.DS.strtolower($info['report_class_name']).'.html';
        $title = db('s_report_form')->where('code', $code)->value('report_name');
        $this->assign('title', $shop[0]['shop_name'].'-'.$title);


        $this->assign('did', $info['id']);
        return $this->fetch($display);
    }

}
