<?php
/**
 * 报表实现类 部门数据统计
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: lilong/wangzhenya 2018-05-29 $
 */
namespace app\crm\lib\report;
use app\crm\lib\Report;
use think\Controller;
use think\image\Exception;

class Jsj_department_data extends Report {

    private $level=1;
    private $type=3;
    private $code='code1547460692';

    public function getLevel(){
        return $this->level;

    }
    public function getType(){
        return $this->type;
    }
    public function getCode(){
        return $this->code;
    }
    public function data()
    {
        set_time_limit(0);
        $data = input();
        // 时间区域
        if (!$data['start'] || !$data['end']) {
            $return = ['code' => 200, 'msg' => '请选择时间区间', 'count' => 0, 'data' => '',];
            return json($return);
        }
        $det = db('s_report_form')->alias('f')->join('s_report_detail d','d.form_id=f.id')->where('d.id',$data['did'])->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();
        $shop_code = $det['shop_code'];
        if(empty($shop_code)){
            return array('code'=>100,'msg'=>'报表配置有误');
        }
        $start = date('Y-m-d', strtotime($data['start']));
        $end = date('Y-m-d 23:59:59', strtotime($data['end']));
        $where['is_status'] = 1;
        $where['c_from'] = 1;

        if($data['consultation_type_id']){
            $consultation_type_id = intval($data['consultation_type_id']);
        }
        // 地域id，拼接where条件
        if ($data['province_id']) {
            $where['province_id'] = (int)$data['province_id'];
            $whereC['province_id'] = (int)$data['province_id'];
            $whereD['c.province_id'] = (int)$data['province_id'];
        }
        if ($data['city_id']) {
            $where['city_id'] = (int)$data['city_id'];
            $whereC['city_id'] = (int)$data['city_id'];
            $whereD['c.city_id'] = (int)$data['city_id'];
        }

        if ($data['accessModel_id']) {//获取方式
            $where['access_model_id'] = (int)$data['accessModel_id'];
            $whereD['c.access_model_id'] = (int)$data['accessModel_id'];
        }
        if(!$data['department_id']){
            $department = controller('crm/Setting','lib')->getdepartment(array('shop_code'=>$shop_code));
            if($department['code'] == 200){
                $department = $department['data'];
            }
        }else{
            $department = [];
            $info = controller('crm/Customer','lib')->getDepartment();
            $ids = explode(',',$data['department_id']);
            foreach($ids as $k=>$v){
                $arr['id'] = $v;
                $arr['department_name'] = $info[$v]['department_name'];
                $department[] = $arr;
            }
        }

        $dids = array_column($department,'id');


        $sql = '';
        if($data['method'] == 'dj'){
            $code = 'add_shop_code';
            $department_id = 'dj_department_id';
            $sql .= "sum(dj_day between '$start' and '$end') as mkz,";
            $cus = db('c_customerinfo')
                ->where('add_shop_code',$shop_code)
                ->where('dj_department_id', 'in',$dids)
                ->where($where)
                ->where('dj_day','between',[$start,$end])
                ->column('dj_department_id','id');
        }else{
            $code = 'shop_code';
            $department_id = 'sales_department_id';
            $sql .= "sum(yx_day between '$start' and '$end') as mkz,";
            $cus = db('c_customerinfo')
                ->where('add_shop_code',$shop_code)
                ->where('sales_department_id', 'in',$dids)
                ->where($where)
                ->where('yx_day','between',[$start,$end])
                ->column('sales_department_id','id');
        }


        $temp = [];
        $temp1 = [];
        foreach($cus as $k=>$v){
            $temp[] = $k;
            $temp1[$v][] = $k;
        }
        $channelCost = db('c_customer_from')
                        ->where('cid','in',$temp)
                        ->column('c_channel_cost','cid');
        $cost = [];
        foreach($temp1 as $k=>$v){
            foreach($v as $kk=>$vv){
                $cost[$k] += floatval($channelCost[$vv]);
            }
        }
        if($data['consultation_type_id']){
            $sql .= "sum(consultation_type_id = ".$consultation_type_id." and is_valid in('1','4','5') and yx_day between '$start' and '$end') as valid,";//有效
            $sql .= "sum(consultation_type_id = ".$consultation_type_id." and is_intostore in ('2','3','5') and syjd_day between '$start' and '$end') as jd,";
            $sql .= "sum(consultation_type_id = ".$consultation_type_id." and is_success=1 and order_day between '$start' and '$end') as newOrder,";
        }else{
            $sql .= "sum(is_valid in('1','4','5') and yx_day between '$start' and '$end') as valid,";//有效
            $sql .= "sum(is_intostore in ('2','3','5') and syjd_day between '$start' and '$end') as jd,";
            $sql .= "sum(is_success=1 and order_day between '$start' and '$end') as newOrder,";
        }
        $sql .= "sum(customer_channel='网销转介绍' and dj_day between '$start' and '$end') as zjs,";
        $sql .= "sum(is_valid=2 and yx_day between '$start' and '$end') as dd,";
        $sql .= "sum(is_valid=3 and yx_day between '$start' and '$end') as wx";
        // 录入客资量
        $info= db('c_customerinfo')
            ->where($where)
            ->where($code, $shop_code)
            ->where('dj_department_id', 'in',$dids)
            ->group($department_id)
            ->column($sql,$department_id);
//        echo db()->getLastSql();die;
        //营收
        $detail = db('c_customerinfo')->alias('c')->join('c_order_detail d','d.order_sn=c.order_number')
            ->where($where)
            ->where('c.'.$code,  $shop_code)
            ->where($department_id, 'in',$dids)
            ->where('d.pay_type',1)
            ->where('d.pay_time', 'between time', [$start, $end])
            ->group('c.'.$department_id)
            ->column('sum(d.order_fact) as fact','c.'.$department_id);
        //套系
        $whereTx['c.c_from'] = 1;
        $whereTx['c.is_status'] = 1;
        $whereTx['c.is_status'] = 1;

        $total = db('c_customerinfo')->alias('c')->join('c_customer_order o','c.order_number=o.order_sn')
            ->where($whereTx)
            ->where('c.'.$code,  $shop_code)
            ->where('c.'.$department_id, 'in',$dids)
            ->where('o.order_valid', 2)
            ->where('c.order_day', 'between time', [$start, $end])
            ->group('c.'.$department_id)
            ->column('sum(o.order_amount) as total','c.'.$department_id);
        $returnData = [];
        $arr = [];
        $i = 1;
        $arr['id'] = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
        foreach ($department as $key => $value) {
            $returnData[$key]['id'] = $i;
            $returnData[$key]['department_name'] = $value['department_name'];
            $returnData[$key]['lrCustomer'] = $info[$value['id']]['mkz'];
            $returnData[$key]['invCustomer'] = $info[$value['id']]['valid'];
            // 有效率（ 有效获取 / 毛客资 ）
            $returnData[$key]['invRate'] = (number_format($returnData[$key]['invCustomer'] / $returnData[$key]['lrCustomer']*100, 2)) . '%';
            $returnData[$key]['dd'] = $info[$value['id']]['dd'];
            $returnData[$key]['wx'] = $info[$value['id']]['wx'];
            $returnData[$key]['zjs'] = $info[$value['id']]['zjs'];
            $returnData[$key]['intoNum'] = $info[$value['id']]['jd'];
            $returnData[$key]['intoRate'] = (number_format($returnData[$key]['intoNum'] / $returnData[$key]['invCustomer']*100, 2)) . '%';
            $returnData[$key]['orderNum'] = $info[$value['id']]['newOrder'];
            // 成交率（ 有效新单 / 实际进店 ）
            $returnData[$key]['orderRate'] = (number_format($returnData[$key]['orderNum'] / $returnData[$key]['intoNum']*100, 2)) . '%';
            // 有效客资成交率（ 有效新单 / 有效 ）
            $returnData[$key]['validOrderRate'] = (number_format($returnData[$key]['orderNum'] / $returnData[$key]['invCustomer']*100, 2)) . '%';
            // 毛客资成交率（ 有效新单 / 毛客资 ）
            $returnData[$key]['mkzOrderRate'] = (number_format($returnData[$key]['orderNum'] / $returnData[$key]['lrCustomer']*100, 2)) . '%';
            $returnData[$key]['cost'] = sprintf('%.2f',$cost[$value['id']]);
            // 毛客资成本
            $returnData[$key]['mkzCost'] = (number_format($cost[$value['id']] / $returnData[$key]['lrCustomer'], 2));
            // 有效客资成本
            $returnData[$key]['validCost'] = (number_format($cost[$value['id']] / $returnData[$key]['invCustomer'], 2));
            // 进店成本
            $returnData[$key]['jdCost'] = (number_format($cost[$value['id']] / $returnData[$key]['intoCustomer'], 2));
            // 成交成本
            $returnData[$key]['orderCost'] = (number_format($cost[$value['id']] / $returnData[$key]['orderNum'], 2));

            $returnData[$key]['orderAmount'] = sprintf('%.2f',$total[$value['id']]);
            $returnData[$key]['factMoney'] = sprintf('%.2f',$detail[$value['id']]);
            $returnData[$key]['orderAmountAvg'] = sprintf('%.2f',$detail[$value['id']]/$info[$value['id']]['newOrder']);
            $returnData[$key]['roi'] = number_format($cost[$value['id']] / $detail[$value['id']], 2).':1';

            $arr['department_name'] = '总计';
            $arr['lrCustomer'] += $info[$value['id']]['mkz'];
            $arr['invCustomer'] += $info[$value['id']]['valid'];
            $arr['invRate'] = '';
            $arr['dd'] += $info[$value['id']]['dd'];
            $arr['wx'] += $info[$value['id']]['wx'];
            $arr['zjs'] += $info[$value['id']]['zjs'];
            $arr['intoNum'] += $info[$value['id']]['jd'];
            $arr['intoRate'] = '';
            $arr['orderNum'] += $info[$value['id']]['newOrder'];
            $arr['orderRate'] = '';
            $arr['validOrderRate'] = '';
            $arr['mkzOrderRate'] = '';
            $arr['cost'] += floatval($cost[$value['id']]);
            $arr['mkzCost'] = '';
            $arr['validCost'] = '';
            $arr['jdCost'] = '';
            $arr['orderCost'] = '';
            $arr['orderAmount'] += $total[$value['id']];
            $arr['factMoney'] += $detail[$value['id']];
            $arr['orderAmountAvg'] = '';
            $arr['roi'] = '';
            $i++;
        }
        $arr['invRate'] = sprintf('%.2f',$arr['invCustomer']/$arr['lrCustomer']*100).'%';
        $arr['intoRate'] = sprintf('%.2f',$arr['intoNum']/$arr['invCustomer']*100).'%';
        $arr['orderRate'] = sprintf('%.2f',$arr['orderNum']/$arr['intoNum']*100).'%';
        $arr['validOrderRate'] = sprintf('%.2f',$arr['orderNum']/$arr['invCustomer']*100).'%';
        $arr['mkzOrderRate'] = sprintf('%.2f',$arr['orderNum']/$arr['lrCustomer']*100).'%';
        $arr['mkzCost'] = sprintf('%.2f',$arr['cost']/$arr['lrCustomer']);
        $arr['validCost'] = sprintf('%.2f',$arr['cost']/$arr['invCustomer']);
        $arr['jdCost'] = sprintf('%.2f',$arr['cost']/$arr['intoNum']);
        $arr['orderCost'] = sprintf('%.2f',$arr['cost']/$arr['orderNum']);
        $arr['orderAmountAvg'] = sprintf('%.2f',$arr['factMoney']/$arr['orderNum']);
        $arr['roi'] = sprintf('%.2f',$arr['factMoney']/$arr['cost']).':1';
        array_push($returnData,$arr);

        $return['code'] = 0;
        $return['msg'] = '';
        $return['count'] = count($returnData);
        $return['data'] = $returnData;
        return json($return);

    }

    public function show(){
        $code = $this->getCode();
        $did = strtolower(input('param.did'));
        $info = db('s_report_form')->alias('f')->join('s_report_detail d','d.form_id=f.id')->where('d.id',$did)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();
        $shop= controller('crm/Customer','lib')->get_shop(['shop_code' =>$info['shop_code']]);
        $this->assign('shop', $shop);
        //部门
        $dep = controller("crm/Customer")->getDepartmentList(array('shop_code' =>$info['shop_code']));
        $this->assign('department', $dep);
        //获取方式
        $accessModel = controller("crm/Customer", "lib")->accessModel(array('shop_code' =>$info['shop_code']));
        $this->assign("accessModel", $accessModel);

        //客资地域
        // crm省    列表
        $data['type'] = 1;
        $data['shop_code'] = $info['shop_code'];
        $province = controller("crm/Customer", "lib")->address($data);
        $this->assign('province', $province);
        //消费类型
        $consumptionType = controller("crm/Customer", "lib")->consumptionType(['brandclass_id'=>$info['brandclass_id']]);
        $this->assign("consumptionType", $consumptionType);
        $display = APP_PATH.'crm'.DS.'view'.DS.'report'.DS.strtolower($info['report_class_name']).'.html';
        $title = db('s_report_form')->where('code', $code)->value('report_name');
        $this->assign('title', $shop[0]['shop_name'].'-'.$title);

        $channels = getChannelJson($info['shop_code']);
        $this->assign('channel', json_encode($channels));
        $this->assign('did', $info['id']);
        return $this->fetch($display);
    }

}
