<?php
/**
 * 报表实现类 网销业绩统计
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: wangzhenya 2018-06-12 $
 */
namespace app\crm\lib\report;
use app\crm\lib\Report;
use think\Controller;
use think\image\Exception;

class Qqbaby_wx_day_data extends Report {

    private $level=1;
    private $type=3;
    private $code='code1544758169';

    public function getLevel(){
        return $this->level;

    }
    public function getType(){
        return $this->type;
    }
    public function getCode(){
        return $this->code;
    }
    public function data()
    {
        set_time_limit(0);
        $data = input();
        $det = db('s_report_form')->alias('f')->join('s_report_detail d','d.form_id=f.id')->where('d.id',$data['did'])->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name,f.report_name')->find();
        $shop_code = $det['shop_code'];
        if(empty($shop_code)){
            return array('code'=>100,'msg'=>'报表配置有误');
        }

        $flag = $data['flag'];

        $where['c_from'] = 1;
        $where['is_status'] = 1;
        $where['shop_code'] = $shop_code;
        $whereCost['shop_code'] = $shop_code;
        $shopinfo = controller('crm/Customer','lib')->get_shop(['shop_code'=>$shop_code]);
        // 地域id，拼接where条件
        if ($data['province_id']) {
            $where['province_id'] = (int)$data['province_id'];
            $whereCost['province_id'] = (int)$data['province_id'];
        }
        if ($data['city_id']) {
            $where['city_id'] = (int)$data['city_id'];
            $whereCost['city_id'] = (int)$data['city_id'];
        }
        if ($data['customer_channel_id']) {
            $where['customer_channel_id'] = (int)$data['customer_channel_id'];
            $whereCost['channel_id'] = (int)$data['customer_channel_id'];
        }
        $staff_id = $data['staff_id'];
        if(!$staff_id){
            $staff = controller('crm/Customer','lib')->get_staff_lists(['shop_code'=>$shop_code]);
            foreach($staff as $k=>$v){
                $staff[$k]['staff_id'] = $v['id'];
                $staff[$k]['staff_name'] = $v['staffname'];
            }
        }else{
            $info = sx_call('5a18e3fa516a1',['staff_id'=>$staff_id]);
            if($info['code'] == 200){
                $staff = $info['data'];
                foreach($staff as $k=>$v){
                    $staff[$k]['staff_id'] = $v['id'];
                    $staff[$k]['staff_name'] = $v['staffname'];
                }
            }
        }
        $sales_staff_id = array_column($staff,'staff_id');
        $staff_name = array_column($staff,'staffname');
        $start = $data['start'] ? date('Y-m-d', strtotime($data['start'])) : date('Y-m-d 00:00:00');
        $end =  $data['end'] ? date('Y-m-d 23:59:59', strtotime($data['end'])) : date('Y-m-d 23:59:59');
        $info = [];
       if($flag == 'mkz'){//毛客资
            $info = db('c_customerinfo')
                ->where($where)
                ->where('dj_day', 'between time', [$start, $end])
                ->where('sales_staff_id','in',$sales_staff_id)
                ->group('sales_staff_id')
                ->column('count(*) num','sales_staff_id');
        }elseif($flag == 'valid'){//有效客资
            $info = db('c_customerinfo')
                ->where($where)
                ->where('is_valid',1)
                ->where('dj_day', 'between time', [$start, $end])
                ->where('sales_staff_id','in',$sales_staff_id)
                ->group('sales_staff_id')
                ->column('count(*) num','sales_staff_id');
        }elseif($flag == 'validRate'){//有效率
            $mkz = db('c_customerinfo')
                ->where($where)
                ->where('dj_day', 'between time', [$start, $end])
                ->where('sales_staff_id','in',$sales_staff_id)
                ->group('sales_staff_id')
                ->column('count(*) num','sales_staff_id');
            $valid = db('c_customerinfo')
                ->where($where)
                ->where('is_valid',1)
                ->where('dj_day', 'between time', [$start, $end])
                ->where('sales_staff_id','in',$sales_staff_id)
                ->group('sales_staff_id')
                ->column('count(*) num','sales_staff_id');
            $info = [];
            foreach($valid as $k=>$v){
                $info[$k] = $v ? sprintf('%.2f',$v/$mkz[$k]*100) : '0';
            }
        }elseif($flag == 'jd'){//进店
            $info = db('c_customerinfo')
                ->where($where)
                ->where('is_intostore','in',[2,3])
                ->where('syjd_day', 'between time', [$start, $end])
                ->where('sales_staff_id','in',$sales_staff_id)
                ->group('sales_staff_id')
                ->column('count(*) num','sales_staff_id');
        }elseif($flag == 'order'){//成交
            $info = db('c_customerinfo')
                ->where($where)
                ->where('is_success', 1)
                ->where('order_day', 'between time', [$start, $end])
                ->where('sales_staff_id','in',$sales_staff_id)
                ->group('sales_staff_id')
                ->column('count(*) num','sales_staff_id');
        }elseif($flag == 'fact'){//业绩
            $info = db('c_customerinfo')->alias('c')->join('c_order_detail d','c.order_number=d.order_sn','LEFT')
                ->where($where)
                ->where('d.create_time', 'between time', [$start, $end])
                ->where('sales_staff_id','in',$sales_staff_id)
                ->group('sales_staff_id')
                ->column('sum(d.order_fact) num','sales_staff_id');

            foreach($info as $k=>$v){
                $info[$k] = sprintf('%.2f',$v);
            }

        }elseif($flag == 'avg'){//均价
            $fact = db('c_customerinfo')->alias('c')->join('c_order_detail d','c.order_number=d.order_sn','LEFT')
                ->where($where)
                ->where('d.create_time', 'between time', [$start, $end])
                ->where('sales_staff_id','in',$sales_staff_id)
                ->group('sales_staff_id')
                ->column('sum(d.order_fact) num','sales_staff_id');
           $order = db('c_customerinfo')
               ->where($where)
               ->where('is_success', 1)
               ->where('order_day', 'between time', [$start, $end])
               ->where('sales_staff_id','in',$sales_staff_id)
               ->group('sales_staff_id')
               ->column('count(*) num','sales_staff_id');
           $info = [];
           foreach($fact as $k=>$v){
               $info[$k] = $v ? sprintf('%.2f',$v/$order[$k]) : '0';
           }
        }elseif($flag == 'tel'){
           $info = db('c_customerinfo')
               ->where($where)
               ->where('customer_tel','<>','')
               ->where('dj_day', 'between time', [$start, $end])
               ->where('sales_staff_id','in',$sales_staff_id)
               ->group('sales_staff_id')
               ->column('count(*) num','sales_staff_id');
       }elseif($flag == 'telRate'){
           $tel = db('c_customerinfo')
               ->where($where)
               ->where('customer_tel','<>','')
               ->where('dj_day', 'between time', [$start, $end])
               ->where('sales_staff_id','in',$sales_staff_id)
               ->group('sales_staff_id')
               ->column('count(*) num','sales_staff_id');

           $mkz = db('c_customerinfo')
               ->where($where)
               ->where('dj_day', 'between time', [$start, $end])
               ->where('sales_staff_id','in',$sales_staff_id)
               ->group('sales_staff_id')
               ->column('count(*) num','sales_staff_id');
           $info = [];
           foreach($tel as $k=>$v){
               $info[$k] = $v ? sprintf('%.2f',$v/$mkz[$k]*100) : '0';
           }
       }elseif($flag == 'jdRate'){
           $jd = db('c_customerinfo')
               ->where($where)
               ->where('is_intostore','in',[2,3])
               ->where('syjd_day', 'between time', [$start, $end])
               ->where('sales_staff_id','in',$sales_staff_id)
               ->group('sales_staff_id')
               ->column('count(*) num','sales_staff_id');

           $valid = db('c_customerinfo')
               ->where($where)
               ->where('is_valid',1)
               ->where('dj_day', 'between time', [$start, $end])
               ->where('sales_staff_id','in',$sales_staff_id)
               ->group('sales_staff_id')
               ->column('count(*) num','sales_staff_id');
           $info = [];
           foreach($jd as $k=>$v){
               $info[$k] = $v ? sprintf('%.2f',$v/$valid[$k]*100) : '0';
           }
       }elseif($flag == 'orderRate'){
           $jd = db('c_customerinfo')
               ->where($where)
               ->where('is_intostore','in',[2,3])
               ->where('syjd_day', 'between time', [$start, $end])
               ->where('sales_staff_id','in',$sales_staff_id)
               ->group('sales_staff_id')
               ->column('count(*) num','sales_staff_id');

           $order = db('c_customerinfo')
               ->where($where)
               ->where('is_success', 1)
               ->where('order_day', 'between time', [$start, $end])
               ->where('sales_staff_id','in',$sales_staff_id)
               ->group('sales_staff_id')
               ->column('count(*) num','sales_staff_id');
           $info = [];
           foreach($order as $k=>$v){
               $info[$k] = $v ? sprintf('%.2f',$v/$jd[$k]*100) : '0';
           }
       }elseif($flag == 'zhRate'){
           $valid = db('c_customerinfo')
               ->where($where)
               ->where('is_valid',1)
               ->where('dj_day', 'between time', [$start, $end])
               ->where('sales_staff_id','in',$sales_staff_id)
               ->group('sales_staff_id')
               ->column('count(*) num','sales_staff_id');

           $order = db('c_customerinfo')
               ->where($where)
               ->where('is_success', 1)
               ->where('order_day', 'between time', [$start, $end])
               ->where('sales_staff_id','in',$sales_staff_id)
               ->group('sales_staff_id')
               ->column('count(*) num','sales_staff_id');
           $info = [];
           foreach($order as $k=>$v){
               $info[$k] = $v ? sprintf('%.2f',$v/$valid[$k]*100) : '0';
           }
       }elseif($flag == 'jieshao'){//转介绍业绩
           $info = db('c_customerinfo')->alias('c')->join('c_order_detail d','c.order_number=d.order_sn','LEFT')
               ->where($where)
               ->where('customer_type',2)
               ->where('d.create_time', 'between time', [$start, $end])
               ->where('sales_staff_id','in',$sales_staff_id)
               ->group('sales_staff_id')
               ->column('count(*) num','sales_staff_id');

           foreach($info as $k=>$v){
               $info[$k]['num'] = sprintf('%.2f',$v['num']);
           }
       }
        $value = [];
        foreach($staff as $k=>$v){
            $value[] = $info[$v['id']] ? $info[$v['id']] : 0;
        }
        return json(array('code' =>200,'shop'=>$shopinfo[0]['shop_name'],'value' => $value,'xname'=>$staff_name));

    }

    public function show(){
        $code = $this->getCode();
        $did = strtolower(input('param.did'));
        $info = db('s_report_form')->alias('f')->join('s_report_detail d','d.form_id=f.id')->where('d.id',$did)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();

        $display = APP_PATH.'crm'.DS.'view'.DS.'report'.DS.strtolower($info['report_class_name']).'.html';
        $title = db('s_report_form')->where('code', $code)->value('report_name');
        $shop= controller('crm/Customer','lib')->get_shop(['shop_code'=>$info['shop_code']]);

        $this->assign('shop', $shop);
        // crm省    列表
        $data['type'] = 1;
        $data['shop_code'] = $info['shop_code'];
        $province = controller("Customer", "lib")->address($data);
        $this->assign('province', $province);
        //渠道
        $channel = controller('crm/Customer','lib')->getChannel();
        $this->assign('channel',$channel);
        //人员
        $staff = controller('crm/Customer','lib')->get_staff_lists(['shop_code'=>$info['shop_code']]);
        $this->assign('staff',$staff);
        $this->assign('title', $shop[0]['shop_name'].'-'.$title);
        $this->assign('did', $info['id']);
        return $this->fetch($display);
    }

}