<?php
/**
 * 莱色定制接口
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: lilong<lilong@suxuantech.cn>  $
 */
namespace app\index\api;

use think\Exception;

class Laise{
    /**
     * 根据客资ID 查询客资基本信息
     * 
     * @param  cid             客资id
     * 
     * @return array['id']               客资ID
     * @return array['customer_name']    客资姓名
     * @return array['customer_tel']     客资手机号
     * @return array['customer_wechat']  客资微信
     * @return array['mate_name']        配偶姓名
     * @return array['mate_tel']         配偶手机
     * @return array['mate_wechat']      配偶微信
     * @return array['province']         省
     * @return array['city']             市
     * @return array['county']           区
     * @return array['customer_address'] 详细地址
     * @return array['consultation_type']消费类型
     * @return array['customer_channel'] 渠道名称
     * @return array['is_valid']         是否有效（1有效 2待定 3无效 4驳回 5反驳回）
     * @return array['yx_day']           有效时间
     * @return array['is_intostore']     是否进店（1未进店 2进店进客 3进店非进客 4邀约未进店（爽约） 5 进店未成交（流失））
     * @return array['syjd_day']         进店时间
     * @return array['dj_staff']         登记人姓名
     * @return array['add_shop_name']    登记人所属店面
     * @return array['sales_staff']      追踪人姓名
     * @return array['shop_name']        追踪人所属店面
     * @return array['branclass']        归属事业部
     *
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getCusInfoById($param){
        $cid = (int)$paramp['cid'];

        if(!$cid){
            return array('error'=>1,'code'=>100,'msg'=>'未获取到客资ID');
        }
        $column = 'id,customer_name,customer_tel,customer_wechat,mate_name,mate_tel,mate_wechat,province,city,county,customer_address,consultation_type,customer_channel,is_valid,yx_day,is_intostore,syjd_day,dj_staff,add_shop_name,sales_staff,shop_name,branclass';
        $cusInfo = db('c_customerinfo')->where('id',$id)->field($column)->find();

        if (!$cusInfo) {
            return array('error'=>1,'code'=>101,'msg'=>'未查询到客资信息，请确认。');
        }else{
            if ($cusInfo['is_status']!=1) {
                return array('error'=>1,'code'=>101,'msg'=>'未查询到客资信息，请确认。');
            }else{
                return array('code'=>200,'msg'=>'查询成功','data'=>$cusInfo);
            }
        }
    }

    
}

