<?php
/**
 * 电商基础数据  ( 毛客资 有效客资(区分消费类型:婚纱) 邀约 进店 新单（区分消费类型:婚纱） )
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: lilong/wangzhenya 2018-05-24 $
 */
namespace app\crm\lib\report;
use app\crm\lib\Report;
use think\Controller;
use think\Session;

class Ds_basedata extends Report {

    private $level= 1;
    private $type = 1;
    private $code = 'ds_basedata';

    public function getLevel(){
        return $this->level;
    }
    public function getType(){
        return $this->type;
    }
    public function getCode(){
        return $this->code;
    }
    public function data(){
        $param = input();
        $shop_code = session('shop_code');
        
        // 开始结束时间，如果没有，则为当天
        if (!$param['start']) {
            $start = date('Y-m-d 00:00:00', time());
        }else{
            $start = date('Y-m-d 00:00:00', strtotime($param['start']));
        }
        if (!$param['end']) {
            $end = date('Y-m-d 23:59:59', time());
        }else{
            $end   = date('Y-m-d 23:59:59', strtotime($param['end']));
        }
        // 基础查询条件
        $where['c_from']        = 1;
        $where['is_status']     = 1;
        $where['customer_type'] = 1;
        $where['add_shop_code'] = $shop_code;

        if ($param['channel_id']) {
            $where['add_shop_code'] = (int)$param['channel_id'];
        }

        if ($param['province']) {
            $where['add_shop_code'] = (int)$param['channel_id'];
        }

        if ($param['city']) {
            $where['add_shop_code'] = (int)$param['channel_id'];
        }

        // 查询店下客资提报的人员
        $url = '5a1510583e3a5';
        $data['shop_code'] = $shop_code;
        $data['work_type'] = CUSTOMER_TB;

        $res = sx_call($url, $data);
        if ($res['code'] == 200) {
            $staffList = $res['data'];
        }else{
            $staffList = [];
        }
        $baseStaffList = [];
        // 店下有客资提报人员  根据人员查
        if (count($staffList)>=1) {
            $ids = '';
            foreach ($staffList as $key => $value) {
                $ids .= $value['id'].',';
                $baseStaffList[$value['id']]['dj_staff_id']= $value['id'];
                $baseStaffList[$value['id']]['dj_staff']   = $value['staffname'];
                $baseStaffList[$value['id']]['mkzNum']     = 0;
                $baseStaffList[$value['id']]['yskzNum']    = 0;
                $baseStaffList[$value['id']]['yyNum']      = 0;
                $baseStaffList[$value['id']]['jdNum']      = 0;
                $baseStaffList[$value['id']]['xdNum']      = 0;
            }

            $ids = trim($ids, ',');
            // 毛客资
            $mkz = db('c_customerinfo')
                ->where($where)
                ->where('dj_staff_id', 'in', $ids)
                ->where('dj_day', 'between', [$start, $end])
                ->group('dj_staff_id')
                ->column('dj_staff,count(*) as mkzNum, 0 as yskzNum, 0 as yyNum, 0 as jdNum, 0 as xdNum', 'dj_staff_id');
            // 有效客资
            $yxkz = db('c_customerinfo')
                ->where($where)
                ->where('dj_staff_id', 'in', $ids)
                ->where('is_valid', 1)
                ->where('yx_day', 'between', [$start, $end])
                ->group('dj_staff_id')
                ->column('dj_staff, 0 as mkzNum, count(*) as yskzNum, 0 as yyNum, 0 as jdNum, 0 as xdNum', 'dj_staff_id');
            // 邀约数
            $yy = db('c_customerinfo')
                ->where($where)
                ->where('dj_staff_id', 'in', $ids)
                ->where('yjd_action_day', 'between', [$start, $end])
                ->group('dj_staff_id')
                ->column('dj_staff,0 as mkzNum, 0 as yskzNum, count(*) as yyNum, 0 as jdNum, 0 as xdNum', 'dj_staff_id');
            // 进店数
            $jd = db('c_customerinfo')
                ->where($where)
                ->where('is_intostore', 'in', '2,3')
                ->where('dj_staff_id', 'in', $ids)
                ->where('syjd_day', 'between', [$start, $end])
                ->group('dj_staff_id')
                ->column('dj_staff, 0 as mkzNum, 0 as yskzNum, 0 as yyNum, count(*) as jdNum, 0 as xdNum', 'dj_staff_id');
            // 新单数
            $xd = db('c_customerinfo')
                ->where($where)
                ->where('dj_staff_id', 'in', $ids)
                ->where('is_success', 1)
                ->where('order_day', 'between', [$start, $end])
                ->group('dj_staff_id')
                ->column('dj_staff, 0 as mkzNum, 0 as yskzNum, 0 as yyNum, 0 as jdNum, count(*) as xdNum', 'dj_staff_id');
            $allData = array_merge($baseStaffList, $mkz, $yxkz, $yy, $jd, $xd);
            // var_dump($allData);
            // exit;
            $returnData = [];
            foreach ($allData as $key => $value) {
                $returnData[$value['dj_staff_id']]['dj_staff_id'] = $value['dj_staff_id'];
                $returnData[$value['dj_staff_id']]['staff']    = $value['dj_staff'];
                $returnData[$value['dj_staff_id']]['mkzNum']  += $value['mkzNum'];
                $returnData[$value['dj_staff_id']]['yskzNum'] += $value['yskzNum'];
                $returnData[$value['dj_staff_id']]['yyNum']   += $value['yyNum'];
                $returnData[$value['dj_staff_id']]['jdNum']   += $value['jdNum'];
                $returnData[$value['dj_staff_id']]['xdNum']   += $value['xdNum'];
            }
        }
        // 店下没有客资提报人员
        else{
            // 毛客资
            $mkz = db('c_customerinfo')
                ->where($where)
                ->where('dj_day', 'between', [$start, $end])
                ->group('dj_staff_id')
                ->column('dj_staff,count(*) as mkzNum, 0 as yskzNum, 0 as yyNum, 0 as jdNum, 0 as xdNum', 'dj_staff_id');
            // 有效客资
            $yxkz = db('c_customerinfo')
                ->where($where)
                ->where('is_valid', 1)
                ->where('yx_day', 'between', [$start, $end])
                ->group('dj_staff_id')
                ->column('dj_staff, 0 as mkzNum, count(*) as yskzNum, 0 as yyNum, 0 as jdNum, 0 as xdNum', 'dj_staff_id');
            // 邀约数
            $yy = db('c_customerinfo')
                ->where($where)
                ->where('yjd_action_day', 'between', [$start, $end])
                ->group('dj_staff_id')
                ->column('dj_staff,0 as mkzNum, 0 as yskzNum, count(*) as yyNum, 0 as jdNum, 0 as xdNum', 'dj_staff_id');
            // 进店数
            $jd = db('c_customerinfo')
                ->where($where)
                ->where('is_intostore', 'in', '2,3')
                ->where('syjd_day', 'between', [$start, $end])
                ->group('dj_staff_id')
                ->column('dj_staff, 0 as mkzNum, 0 as yskzNum, 0 as yyNum, count(*) as jdNum, 0 as xdNum', 'dj_staff_id');
            // 新单数
            $xd = db('c_customerinfo')
                ->where($where)
                ->where('is_success', 1)
                ->where('order_day', 'between', [$start, $end])
                ->group('dj_staff_id')
                ->column('dj_staff, 0 as mkzNum, 0 as yskzNum, 0 as yyNum, 0 as jdNum, count(*) as xdNum', 'dj_staff_id');
            $allData = array_merge($mkz, $yxkz, $yy, $jd, $xd);
            // var_dump($allData);
            // exit;
            $returnData = [];
            foreach ($allData as $key => $value) {
                $returnData[$value['dj_staff_id']]['dj_staff_id'] = $value['dj_staff_id'];
                $returnData[$value['dj_staff_id']]['dj_staff'] = $value['dj_staff'];
                $returnData[$value['dj_staff_id']]['mkzNum']  += $value['mkzNum'];
                $returnData[$value['dj_staff_id']]['yskzNum'] += $value['yskzNum'];
                $returnData[$value['dj_staff_id']]['yyNum']   += $value['yyNum'];
                $returnData[$value['dj_staff_id']]['jdNum']   += $value['jdNum'];
                $returnData[$value['dj_staff_id']]['xdNum']   += $value['xdNum'];
            }
        }
        return json(array('code' => 0, 'msg' => '', 'count' => count($returnData), 'data' => $returnData));
    }
    public function show(){
        /**
         * coding.....
         * var data = {};
         * data.start = $().val();
         * data.end = $().val();
         * $.ajax(function(){
         *    url:'url('crm/Report',['id'=>'Shewayuangongyeji_sy'])',
         *    'method':'POST',
         *    data:data
         *    success:function(){
         *
         *    sdfsfd
         *    }
         *
         * })
         * 
         */

        $html = strtolower(input('param.id'));
        $display = APP_PATH.'crm'.DS.'view'.DS.'report'.DS.$html.'.html';

        $code = $this->getCode();
        
        // crm省    列表
        $data['type'] = 1;
        $province = controller("Customer", "lib")->address($data);
        $this->assign('province', $province);
        //来源渠道
        $channel = controller("Customer", "lib")->getChannel();
        $this->assign("channel", $channel);

        $title = db('s_report_form')->where('code', $code)->value('report_name');
        $this->assign('title', session('department_name').'-'.$title);

        $this->assign('shop_code', session('shop_code'));

        return $this->fetch($display);
    }

}