<?php
/**
 * 电商渠道花费表  
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: lilong/wangzhenya 2018-05-24 $
 */
namespace app\crm\lib\report;
use app\crm\lib\Report;
use think\Controller;
use think\Session;

class Ds_channelcost extends Report {

    private $level= 1;
    private $type = 1;
    private $code = 'code1527410247';

    public function getLevel(){
        return $this->level;
    }
    public function getType(){
        return $this->type;
    }
    public function getCode(){
        return $this->code;
    }
    public function data(){
        $param = input();
//        $shopCode = session('shop_code');
        $det = db('s_report_form')->alias('f')->join('s_report_detail d','d.form_id=f.id')->where('d.id',$param['did'])->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();        
        $shopCode = $det['shop_code'] ? $det['shop_code'] : session('shop_code');
        if(empty($shopCode)){
            return array('code'=>100,'msg'=>'报表配置有误');
        }
        // 开始结束时间，如果没有，则为当天
        if (!$param['start']) {
            $start = date('Y-m-d', time());
        }else{
            $start = date('Y-m-d', strtotime($param['start']));
        }
        if (!$param['end']) {
            $end = date('Y-m-d', time());
        }else{
            $end   = date('Y-m-d', strtotime($param['end']));
        }
        if($param['city']){
            $city = db('s_shop_address')->where('shop_code',$shopCode)->where('type',2)->column('name','id');
        }else{
            $city = db('s_shop_address')->where('shop_code',$shopCode)->where('type',1)->column('name','id');
        }
        $info = db('s_channel_cost')->where('shop_code',$shopCode)->where('cost_date','between',[$start,$end])->where('channel_id',$param['channel_id'])->order('cost_date')->field('id,channel_id,channel_name,city_id,city_name,cost,cost_date,province_id,province_name,create_time,staff_id')->select();
        $total = [];
        $return = [];
        $all = [];
        foreach($info as $k=>$v){
            $total[$v['cost_date']] += $v['cost'];
            if($param['city']){
                $return[$v['cost_date']][$v['city_id']] += $v['cost'];
                $all[$v['city_id']] += $v['cost'];
            }else{
                $return[$v['cost_date']][$v['province_id']] += $v['cost'];
                $all[$v['province_id']] += $v['cost'];
            }
        }
        $date = getDates($start,$end);
        if($param['need'] == 1){
            $title = $city;
            array_unshift($title,'花费日期');
            array_push($title,'总计');
            $import = [];
            foreach($date as $k=>$v){
                $arr = [];
                $arr[] = $v;
                foreach($city as $kk=>$vv){
                    if($return[$v] && $return[$v][$kk]) {
                        $arr[] = $return[$v][$kk];
                    }else{
                        $arr[] = '';
                    }
                }
                if($total[$v]){
                    $arr[] = $total[$v];
                }else{
                    $arr[] = '';
                }
                array_push($import,$arr);
            }

            $array = [$param['channel'].'-总计'];
            foreach($city as $key=>$val){
                if($all[$key]){
                    array_push($array,$all[$key]);
                }else{
                    $array[] = '';
                }
            }
            $num = array_sum($array);
            $array[] = sprintf('%.2f',$num);
            $import[] = $array;
            $code = $this->getCode();
            $ff = db('s_report_form')->where('code', $code)->value('report_name');
            $shop = controller('crm/Customer','lib')->get_shop(['shop_code'=>$shopCode]);
            $file = $shop[0]['shop_name'].'-'.$ff.'.xlsx';
            controller("crm/Customer", "lib")->export($title, $import, $file);
        }else{
            if(count($date) >=15){
                $a = 4;
            }else{
                $a = 3;
            }
            return json(array('code' => 0, 'msg' => '', 'date' => $date,'city'=>$city,'all'=>$all, 'data' => $return,'cityCount'=>$total,'width'=>(count($city)+$a)*115));
        }
    }
    public function show(){
        $code = $this->getCode();

        $did = strtolower(input('param.did'));
        $info = db('s_report_form')->alias('f')->join('s_report_detail d','d.form_id=f.id')->where('d.id',$did)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();

        //来源渠道
        $channel = controller("Customer", "lib")->getChannel($info['shop_code']);
        $this->assign("channel", $channel);

        // crm省    列表  旅拍取省列表  其他取市列表
//        if (session('shop_type') == 3) {
//            $data['type'] = 1;
//            $province = controller("Customer", "lib")->address($data);
//            $this->assign('areaList', $province);
//        }else{
            $data['type'] = 2;
            $data['shop_code'] = $info['shop_code'];
            $city = controller("Customer", "lib")->address($data);
            $this->assign('city', $city);
            $this->assign('width', (count($city)+3)*115);//根据城市数量定义宽度
//        }

        $shopInfo = controller('crm/Customer','lib')->get_shop(['shop_code'=>$info['shop_code']]);
        $title = db('s_report_form')->where('code', $code)->value('report_name');
        $this->assign('title', $shopInfo[0]['shop_name'].'-'.$title);

        $this->assign('shop_code', $info['shop_code']);
        $display = APP_PATH.'crm'.DS.'view'.DS.'report'.DS.strtolower($info['report_class_name']).'.html';
        $this->assign('did', $info['id']);
        return $this->fetch($display);
    }

}