<?php
/**
 * 报表实现类 电商部店内员工客资统计
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: lilong/wangzhenya 2018-05-29 $
 */
namespace app\crm\lib\report;
use app\crm\lib\Report;
use think\Controller;
use think\image\Exception;

class Ds_customer_data extends Report {

    private $level=1;
    private $type=1;
    private $code='code1528233361';

    public function getLevel(){
        return $this->level;

    }
    public function getType(){
        return $this->type;
    }
    public function getCode(){
        return $this->code;
    }
    public function data()
    {
        $param = input();
        $start = $param['start'] ? trim($param['start']).' 00:00:00' : date('Y-m-d 00:00:00');
        $end = $param['end'] ? trim($param['end']).' 23:59:59' : date('Y-m-d 23:59:59');

        $det = db('s_report_form')->alias('f')->join('s_report_detail d','d.form_id=f.id')->where('d.id',$param['did'])->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();
        $shopCode = $det['shop_code'] ? $det['shop_code'] : session('shop_code');
        if(empty($shopCode)){
            return array('code'=>100,'msg'=>'报表配置有误');
        }
        $where['add_shop_code'] = $shopCode;
        $where['is_status'] = 1;
        $where['c_from'] = 1;

        $consultation_type_id = $param['consultation_type_id'] ? $param['consultation_type_id'] : HS_TYPE;
        //获取店内所有员工
        if($param['department_id']){
            $whereStaff['department_id'] = intval($param['department_id']);
        }
        $whereStaff['shop_code'] = $shopCode;
        $whereStaff['work_type'] = 23;
//        $staffs = controller('crm/Statistics', 'lib')->getStaffInfoByShop($shopCode);
        $staffs = getShopStaffs($whereStaff);
        $staffIds = array_column($staffs,'id');
        $sql = '';
        $sql .= "sum(is_first_qq=1 and yx_day between '".$start."' and '".$end."') as qq,";//qq
        $sql .= "sum(is_first_wechat=1 and yx_day between '".$start."' and '".$end."') as wx,";//微信
        $sql .= "sum(is_first_tel=1 and yx_day between '".$start."' and '".$end."') as tel,";//tel
        if($param['consultation_type_id']){
            $sql .= "sum(consultation_type_id = ".$consultation_type_id." and is_valid=1 and yx_day between '".$start."' and '".$end."') as valid,";//总获取
        }else{
            $sql .= "sum(is_valid=1 and yx_day between '".$start."' and '".$end."') as valid,";//总获取
        }

        $sql .= "sum(dj_day between '".$start."' and '".$end."') as mkz,";//总录入
        $sql .= "sum(is_valid=2 and yx_day between '".$start."' and '".$end."') as dd,";//待定
        $sql .= "sum(is_valid=3 and yx_day between '".$start."' and '".$end."') as unvalid,";//无效
        $sql .= "sum(is_valid=4 and yx_day between '".$start."' and '".$end."') as bh,";//驳回
        $sql .= "sum(is_valid=5 and yx_day between '".$start."' and '".$end."') as fbh";//反驳回
        $info= db('c_customerinfo')
            ->where($where)
            ->where('dj_staff_id', 'in',$staffIds)
            ->group('dj_staff_id')
            ->column($sql,'dj_staff_id');
//        echo db()->getLastSql();die;
        $returnData = [];
        $total = [];
        $total['staff'] = '总计';
        foreach($staffs as $k=>$v){
            $arr = [];
            $arr['staff'] = $v['staffname'];
            $arr['mkz'] = $info[$v['id']]['mkz'] ? $info[$v['id']]['mkz'] : '';
            $arr['valid'] = $info[$v['id']]['valid'] ? $info[$v['id']]['valid'] : '';
            $arr['tel'] = $info[$v['id']]['tel'] ? $info[$v['id']]['tel'] : '';
            $arr['qq'] = $info[$v['id']]['qq'] ? $info[$v['id']]['qq'] : '';
            $arr['wx'] = $info[$v['id']]['wx'] ? $info[$v['id']]['wx'] : '';
            $arr['dd'] = $info[$v['id']]['dd'] ? $info[$v['id']]['dd'] : '';
            $arr['unvalid'] = $info[$v['id']]['unvalid'] ? $info[$v['id']]['unvalid'] : '';
            $arr['bh'] = $info[$v['id']]['bh'] ? $info[$v['id']]['bh'] : '';
            $arr['fbh'] = $info[$v['id']]['fbh'] ? $info[$v['id']]['fbh'] : '';
            array_push($returnData,$arr);
            $total['mkz'] += (int)$arr['mkz'];
            $total['valid'] += (int)$arr['valid'];
            $total['tel'] += (int)$arr['tel'];
            $total['wx'] += (int)$arr['wx'];
            $total['qq'] += (int)$arr['qq'];
            $total['dd'] += (int)$arr['dd'];
            $total['unvalid'] += (int)$arr['unvalid'];
            $total['bh'] += (int)$arr['bh'];
            $total['fbh'] += (int)$arr['fbh'];
        }
        array_push($returnData,$total);
        // 导出
        if ($param['need'] == 1) {
            $title = ['员工','总录入','有效获取','首次有效获取手机','首次有效获取QQ','首次有效获取微信','待定','无效','驳回','反驳回'];
            $code = $this->getCode();
            $ff = db('s_report_form')->where('code', $code)->value('report_name');
            $shop = controller('crm/Customer','lib')->get_shop(['shop_code'=>$shopCode]);
            $file = $shop[0]['shop_name'].'-'.$ff.'.xlsx';
            controller("crm/Customer", "lib")->export($title, $returnData, $file);
        } else {
            $return['code'] = 0;
            $return['msg'] = '';
            $return['count'] = count($returnData);
            $return['data'] = $returnData;
            return json($return);
        }
    }

    public function show(){
        $code = $this->getCode();
        $did = strtolower(input('param.did'));
        $info = db('s_report_form')->alias('f')->join('s_report_detail d','d.form_id=f.id')->where('d.id',$did)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();
        //消费类型
        $consumptionType = controller("Customer", "lib")->consumptionType(['brandclass_id'=>$info['brandclass_id']]);
        $this->assign("consumptionType", $consumptionType);
        $display = APP_PATH.'crm'.DS.'view'.DS.'report'.DS.strtolower($info['report_class_name']).'.html';
        $dep = controller("crm/Customer")->getDepartmentList(array('shop_code' =>$info['shop_code']));
        $this->assign("department", $dep);
        $shopInfo = controller('crm/Customer','lib')->get_shop(['shop_code'=>$info['shop_code']]);
        $title = db('s_report_form')->where('code', $code)->value('report_name');
        $this->assign('title', $shopInfo[0]['shop_name'].'-'.$title);
        $this->assign('did', $info['id']);
        return $this->fetch($display);
    }

}