<?php
/**
 * 报表实现类 渠道毛客资透视
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: wangzhenya 2018-06-12 $
 */
namespace app\crm\lib\report;
use app\crm\lib\Report;
use think\Controller;
use think\image\Exception;

class Ds_qd_mkz extends Report {

    private $level=1;
    private $type=1;
    private $code='code1528867761';

    public function getLevel(){
        return $this->level;

    }
    public function getType(){
        return $this->type;
    }
    public function getCode(){
        return $this->code;
    }
    public function data()
    {
        set_time_limit(0);
        $data = input();

        if (!$data['city_id']) {
            $return = ['code' => 200, 'msg' => '请选择城市', 'count' => 0, 'data' => '',];
            return json($return);
        }
        $start = date('Y-m-d', strtotime($data['start']));
        $end = date('Y-m-d 23:59:59', strtotime($data['end']));
        $date = getDates($start, $end);
        // 来源渠道
        $channels = db('s_channel')->where('shop_code', $data['shop_code'])->order('order_sort')->select();
        $channelIds = array_column($channels,'id');
        $channelName = array_column($channels,'channel_name');

        $where['is_status'] = 1;
        $where['customer_type'] = 1;
        $where['c_from'] = 1;
        $where['add_shop_code'] = $data['shop_code'];
        // 地域id，拼接where条件
        if ($data['province_id']) {
            $where['province_id'] = (int)$data['province_id'];
        }
        if ($data['city_id']) {
            $where['city_id'] = (int)$data['city_id'];
        }
        //毛客资
        $info = db('c_customerinfo')
            ->where($where)
            ->where('customer_channel_id', 'in',$channelIds)
            ->where('dj_day', 'between time', [$start, $end])
            ->group('customer_channel_id,days')
            ->order('days,customer_channel_id')
            ->field('customer_channel_id,count(*) num,customer_channel_id,DATE_FORMAT(dj_day,"%Y-%m-%d") days')
            ->select();
        $all = [];
        foreach($info as $k=>$v){
            $all[$v['days'].'_'.$v['customer_channel_id']] = $v;
        }
//        echo db()->getLastSql();die;
        $returnData = [];
        $arr = [];
        $arr[0] = $data['city'];
        foreach($channelName as $key=>$val){
            $arr[$key+1] = $val;
        }
        array_push($arr,'总计');
        array_push($returnData,$arr);
        $title = $arr;
        $last = ['总计'];
        $aa = [];
        $num = 0;
        foreach($date as $k=>$v){
            $mkz = [];
            array_push($mkz,$v);
            $total = 0;
            foreach($channels as $kk=>$vv){
                if($all[$v.'_'.$vv['id']]['num']){
                    array_push($mkz,$all[$v.'_'.$vv['id']]['num']);
                }else{
                    array_push($mkz,'');
                }
                $total += intval($all[$v.'_'.$vv['id']]['num']);//当天总计
                $aa[$vv['id']] += intval($all[$v.'_'.$vv['id']]['num']);
            }
            $num += $total;
            array_push($mkz,$total);//当天总计
            array_push($returnData,$mkz);
        }
        $tt = array_values($aa);//取最后总计的值
        array_push($tt,$num);
        array_push($returnData,array_merge($last,$tt));
        // 导出
        if ($data['need'] == 1) {
            $code = $this->getCode();
            $ff = db('s_report_form')->where('code', $code)->value('report_name');
            $shop = controller('crm/Customer','lib')->get_shop(['shop_code'=>$data['shop_code']]);
            $file = $shop[0]['shop_name'].'-'.$ff.'.xlsx';
            unset($returnData[0]);
            controller("crm/Customer", "lib")->export($title, $returnData, $file);
        } else {
            return json(array('code' => 1, 'data' => $returnData, 'count' => count($title)));
        }
    }

    public function show(){
        $code = $this->getCode();
        $did = strtolower(input('param.did'));
        $info = db('s_report_form')->alias('f')->join('s_report_detail d','d.form_id=f.id')->where('d.id',$did)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();

        $display = APP_PATH.'crm'.DS.'view'.DS.'report'.DS.strtolower($info['report_class_name']).'.html';
        $title = db('s_report_form')->where('code', $code)->value('report_name');
        $shop= controller('crm/Customer','lib')->get_shop(['shop_code'=>$info['shop_code']]);

        $this->assign('shop', $shop);
        $this->assign('title', $shop[0]['shop_name'].'-'.$title);
        $this->assign('did', $info['id']);
        return $this->fetch($display);
    }

}