<?php
/**
 * 报表实现类 电商年度数据统计
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: wangzhenya 2018-06-12 $
 */
namespace app\crm\lib\report;
use app\crm\lib\Report;
use think\Controller;
use think\image\Exception;

class Qqbaby_ds_year_data extends Report {

    private $level=1;
    private $type=1;
    private $code='code1544517968';

    public function getLevel(){
        return $this->level;

    }
    public function getType(){
        return $this->type;
    }
    public function getCode(){
        return $this->code;
    }
    public function data()
    {
        set_time_limit(0);
        $data = input();
        $det = db('s_report_form')->alias('f')->join('s_report_detail d','d.form_id=f.id')->where('d.id',$data['did'])->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name,f.report_name')->find();
        $shop_code = $det['shop_code'];
        if(empty($shop_code)){
            return array('code'=>100,'msg'=>'报表配置有误');
        }
        $start = $data['year'] ? date('Y-01-01', strtotime($data['year'])) : date('Y-01-01 00:00:00');
        $end =  $data['year'] ? date('Y-12-31 23:59:59', strtotime($data['year'])) : date('Y-12-31 23:59:59');
        $flag = $data['flag'];

        $where['c_from'] = 1;
        $where['is_status'] = 1;
        $where['add_shop_code'] = $shop_code;
        $whereCost['shop_code'] = $shop_code;
        $shopinfo = controller('crm/Customer','lib')->get_shop(['shop_code'=>$shop_code]);
        // 地域id，拼接where条件
        if ($data['province_id']) {
            $where['province_id'] = (int)$data['province_id'];
            $whereCost['province_id'] = (int)$data['province_id'];
        }
        if ($data['city_id']) {
            $where['city_id'] = (int)$data['city_id'];
            $whereCost['city_id'] = (int)$data['city_id'];
        }
        if ($data['customer_channel_id']) {
            $where['customer_channel_id'] = (int)$data['customer_channel_id'];
            $whereCost['channel_id'] = (int)$data['customer_channel_id'];
            $whereA['channel_id'] = (int)$data['customer_channel_id'];
        }
        if ($data['dj_staff_id']) {
            $where['dj_staff_id'] = (int)$data['dj_staff_id'];
            $whereA['staff_id'] = (int)$data['dj_staff_id'];
        }
        $return = [];
        $info = [];
        if($flag == 'cost'){//花费
            $info = db('c_customer_cost')
                ->where($whereCost)
                ->group('month')
                ->field('DATE_FORMAT(cost_time,"%m") month,sum(cost_avg) as num')
                ->select();
            foreach($info as $k=>$v){
                $info[$k]['num'] = sprintf('%.2f',$v['num']);
            }
        }elseif($flag == 'exposure'){//曝光量
            $info = db('s_another_setting')
                ->where($whereA)
                ->group('month')
                ->field('DATE_FORMAT(time,"%m") month,sum(exposure) as num')
                ->select();
            foreach($info as $k=>$v){
                $info[$k]['num'] = $v['num'];
            }
        }elseif($flag == 'click'){//点击量
            $info = db('s_another_setting')
                ->where($whereA)
                ->group('month')
                ->field('DATE_FORMAT(time,"%m") month,sum(click) as num')
                ->select();
            foreach($info as $k=>$v){
                $info[$k]['num'] = $v['num'];
            }
        }elseif($flag == 'clickRate'){//点击率
            $exposure = db('s_another_setting')
                ->where($whereA)
                ->group('month')
                ->field('DATE_FORMAT(time,"%m") month,sum(exposure) as num')
                ->select();
            $click = db('s_another_setting')
                ->where($whereA)
                ->group('month')
                ->field('DATE_FORMAT(time,"%m") month,sum(click) as num')
                ->select();
            $arr = [];
            foreach($exposure as $kk=>$vv){
                $arr[$vv['month']] = $vv['num'];
            }
            $info = [];
            foreach($click as $k=>$v){
                $array = [];
                $array['month'] = $v['month'];
                $array['num'] = $v['num'] ? sprintf('%.2f',$v['num']/$arr[$v['month']]*100) : '0';
                $info[] = $array;
            }
        }elseif($flag == 'clickAVG'){//点击率
            $cost =  db('c_customer_cost')
                ->where($whereCost)
                ->group('month')
                ->field('DATE_FORMAT(cost_time,"%m") month,sum(cost_avg) as num')
                ->select();
            $click = db('s_another_setting')
                ->where($whereA)
                ->group('month')
                ->field('DATE_FORMAT(time,"%m") month,sum(click) as num')
                ->select();
            $arr = [];
            foreach($click as $kk=>$vv){
                $arr[$vv['month']] = $vv['num'];
            }
            $info = [];
            foreach($cost as $k=>$v){
                $array = [];
                $array['month'] = $v['month'];
                $array['num'] = $v['num'] ? sprintf('%.2f',$v['num']/$arr[$v['month']]) : '0';
                $info[] = $array;
            }
        }elseif($flag == 'show'){//查看量
            $info = db('s_another_setting')
                ->where($whereA)
                ->group('month')
                ->field('DATE_FORMAT(time,"%m") month,sum(`show`) as num')
                ->select();
            foreach($info as $k=>$v){
                $info[$k]['num'] = $v['num'];
            }
        }elseif($flag == 'showRate'){//查看率
            $show = db('s_another_setting')
                ->where($whereA)
                ->group('month')
                ->field('DATE_FORMAT(time,"%m") month,sum(`show`) as num')
                ->select();
            $click = db('s_another_setting')
                ->where($whereA)
                ->group('month')
                ->field('DATE_FORMAT(time,"%m") month,sum(click) as num')
                ->select();
            $arr = [];
            foreach($click as $kk=>$vv){
                $arr[$vv['month']] = $vv['num'];
            }
            $info = [];
            foreach($show as $k=>$v){
                $array = [];
                $array['month'] = $v['month'];
                $array['num'] = $v['num'] ? sprintf('%.2f',$v['num']/$arr[$v['month']]*100) : '0';
                $info[] = $array;
            }
        }elseif($flag == 'mkz'){//毛客资
            $info = db('c_customerinfo')
                ->where($where)
                ->where('dj_day', 'between time', [$start, $end])
                ->group('month')
                ->field('count(*) num,DATE_FORMAT(dj_day,"%m") month')
                ->select();
        }elseif($flag == 'valid'){//有效客资
            $info = db('c_customerinfo')
                ->where($where)
                ->where('is_valid',1)
                ->where('dj_day', 'between time', [$start, $end])
                ->group('month')
                ->field('count(*) num,DATE_FORMAT(dj_day,"%m") month')
                ->select();
        }elseif($flag == 'validRate'){//有效率
            $mkz = db('c_customerinfo')
                ->where($where)
                ->where('dj_day', 'between time', [$start, $end])
                ->group('month')
                ->field('count(*) num,DATE_FORMAT(dj_day,"%m") month')
                ->select();
            $valid = db('c_customerinfo')
                ->where($where)
                ->where('is_valid',1)
                ->where('dj_day', 'between time', [$start, $end])
                ->group('month')
                ->field('count(*) num,DATE_FORMAT(dj_day,"%m") month')
                ->select();
            $arr = [];
            foreach($mkz as $kk=>$vv){
                $arr[$vv['month']] = $vv['num'];
            }
            $info = [];
            foreach($valid as $k=>$v){
                $array = [];
                $array['month'] = $v['month'];
                $array['num'] = $v['num'] ? sprintf('%.2f',$v['num']/$arr[$v['month']]*100) : '0';
                $info[] = $array;
            }
        }elseif($flag == 'jd'){//进店
            $info = db('c_customerinfo')
                ->where($where)
                ->where('is_intostore','in',[2,3])
                ->where('syjd_day', 'between time', [$start, $end])
                ->group('month')
                ->field('count(*) num,DATE_FORMAT(syjd_day,"%m") month')
                ->select();
        }elseif($flag == 'order'){//成交
            $info = db('c_customerinfo')
                ->where($where)
                ->where('is_success', 1)
                ->where('order_day', 'between time', [$start, $end])
                ->group('month')
                ->field('count(*) num,DATE_FORMAT(order_day,"%m") month')
                ->select();
        }elseif($flag == 'fact'){//业绩
            $info = db('c_customerinfo')->alias('c')->join('c_order_detail d','c.order_number=d.order_sn','LEFT')
                ->where($where)
                ->where('d.create_time', 'between time', [$start, $end])
                ->group('month')
                ->field('sum(d.order_fact) num,DATE_FORMAT(d.create_time,"%m") month')
                ->select();
            foreach($info as $k=>$v){
                $info[$k]['num'] = sprintf('%.2f',$v['num']);
            }
        }elseif($flag == 'fact_cost'){//投入产出比
            $cost = db('c_customer_cost')
                ->where($whereCost)
                ->group('month')
                ->field('DATE_FORMAT(cost_time,"%m") month,sum(cost_avg) as num')
                ->select();
            $fact =  db('c_customerinfo')->alias('c')->join('c_order_detail d','c.order_number=d.order_sn','LEFT')
                ->where($where)
                ->where('d.create_time', 'between time', [$start, $end])
                ->group('month')
                ->field('sum(d.order_fact) num,DATE_FORMAT(d.create_time,"%m") month')
                ->select();
            $arr = [];
            foreach($fact as $kk=>$vv){
                $arr[$vv['month']] = $vv['num'];
            }
            $info = [];
            foreach($cost as $k=>$v){
                $array = [];
                $array['month'] = $v['month'];
                $array['num'] = $v['num'] ? sprintf('%.2f',$v['num']/$arr[$v['month']]*100) : '0';
                $info[] = $array;
            }
        }elseif($flag == 'mkzCost'){//客资成本
            $cost = db('c_customer_cost')
                ->where($whereCost)
                ->group('month')
                ->field('DATE_FORMAT(cost_time,"%m") month,sum(cost_avg) as num')
                ->select();
            $mkz = db('c_customerinfo')
                ->where($where)
                ->where('dj_day', 'between time', [$start, $end])
                ->group('month')
                ->field('count(*) num,DATE_FORMAT(dj_day,"%m") month')
                ->select();
            $arr = [];
            foreach($mkz as $kk=>$vv){
                $arr[$vv['month']] = $vv['num'];
            }
            $info = [];
            foreach($cost as $k=>$v){
                $array = [];
                $array['month'] = $v['month'];
                $array['num'] = $v['num'] ? sprintf('%.2f',$v['num']/$arr[$v['month']]) : '0';
                $info[] = $array;
            }
        }elseif($flag == 'orderCost'){//订单成本
            $cost = db('c_customer_cost')
                ->where($whereCost)
                ->group('month')
                ->field('DATE_FORMAT(cost_time,"%m") month,sum(cost_avg) as num')
                ->select();
            $order = db('c_customerinfo')
                ->where($where)
                ->where('order_day', 'between time', [$start, $end])
                ->group('month')
                ->field('count(*) num,DATE_FORMAT(dj_day,"%m") month')
                ->select();
            $arr = [];
            foreach($order as $kk=>$vv){
                $arr[$vv['month']] = $vv['num'];
            }
            $info = [];
            foreach($cost as $k=>$v){
                $array = [];
                $array['month'] = $v['month'];
                $array['num'] = $v['num'] ? sprintf('%.2f',$v['num']/$arr[$v['month']]) : '0';
                $info[] = $array;
            }
        }
        $m = ['1','2','3','4','5','6','7','8','9','10','11','12'];
        $arr = [];
        if(empty($info)){
            return json(array('code'=>100,'msg'=>'暂无数据'));
        }else{
            $temp = [];
            foreach($info as $kk=>$vv){
                $temp[intval($vv['month'])] = $vv['num'];
            }
            foreach($m as $k=>$v){
                $arr[] = $temp[intval($v)] ? $temp[intval($v)] : 0;
            }
        }
        return json(array('code' =>200,'shop'=>$shopinfo[0]['shop_name'],'value' => $arr));

    }

    public function show(){
        $code = $this->getCode();
        $did = strtolower(input('param.did'));
        $info = db('s_report_form')->alias('f')->join('s_report_detail d','d.form_id=f.id')->where('d.id',$did)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();

        $display = APP_PATH.'crm'.DS.'view'.DS.'report'.DS.strtolower($info['report_class_name']).'.html';
        $title = db('s_report_form')->where('code', $code)->value('report_name');
        $shop= controller('crm/Customer','lib')->get_shop(['shop_code'=>$info['shop_code']]);

        $this->assign('shop', $shop);
        // crm省    列表
        $data['type'] = 1;
        $data['shop_code'] = $info['shop_code'];
        $province = controller("Customer", "lib")->address($data);
        $this->assign('province', $province);
        //渠道
        $channel = controller('crm/Customer','lib')->getChannel();
        $this->assign('channel',$channel);
        //人员
        $staff = controller('crm/Customer','lib')->get_staff_lists(['shop_code'=>$info['shop_code']]);
        $this->assign('staff',$staff);
        $this->assign('title', $shop[0]['shop_name'].'-'.$title);
        $this->assign('did', $info['id']);
        return $this->fetch($display);
    }

}