<?php
/**
 * 报表实现类 网销小组综合数据分析1
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: lilong/wangzhenya 2018-05-29 $
 */
namespace app\crm\lib\report;
use app\crm\lib\Report;
use think\Controller;
use think\image\Exception;

class Wx_group2 extends Report {

    private $level=1;
    private $type=3;
    private $code='code1533562771';

    public function getLevel(){
        return $this->level;

    }
    public function getType(){
        return $this->type;
    }
    public function getCode(){
        return $this->code;
    }
    public function data()
    {
        set_time_limit(0);
        $title = ['序号','组名', '姓名', '毛客资','接入客资', '有效客资', '进店数',  '进店率', '有效订单数','成交率', '流失(进店未成交)', '流失率', '套系金额', '实收金额', '余款金额','预付定金', '总客资成单率',  '有效成单率'];
        $data = input();

//        $shopCode = session('shop_code');
        $det = db('s_report_form')->alias('f')->join('s_report_detail d','d.form_id=f.id')->where('d.id',$data['did'])->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();
        $shop_code = $det['shop_code'] ? $det['shop_code'] :session('shop_code');
        if(empty($shop_code)){
            return array('code'=>100,'msg'=>'报表配置有误');
        }
        //获取店下的小组
        $groupList = db('c_staff_group')->where('shop_code', $shop_code)->select();
        if (empty($groupList)) {
            $return = ['code' => 100, 'msg' => '暂无小组，请先去设置小组', 'count' => 0, 'data' => ''];
            return json($return);
        }
        $returnData = [];
        for ($i = 0; $i < count($title); $i++) {
            $returnData[0][$i] = $title[$i];
        }
        // 时间区域
        $start = date('Y-m-d', strtotime($data['start']));
        $end = date('Y-m-d 23:59:59',strtotime($data['end']));

        $where['c.is_status'] = 1;
        $where['c.c_from'] = 1;
        // 如果不是旅拍事业部，那么网销报表中查新客资，如果是旅拍事业部，不限制类型
        // $where['c.customer_type'] = 1;
        if ($det['brandclass_id'] != 2) {
            $where['c.customer_type'] = HS_TYPE;
        }
        if($data['consultation_type_id'] && $det['brandclass_id'] != 8){
            $consultation_type_id = intval($data['consultation_type_id']);
            $whereT['c.consultation_type_id'] = $consultation_type_id;
        }

        if ($data['sign_id']) {
            $where['c.sign_id'] = $data['sign_id'];
        }
        if ($data['customer_channel_id']) {
            $where['c.customer_channel_id'] = $data['customer_channel_id'];
        }


        if ($data['province_id']) {
            $where['c.province_id'] = $data['province_id'];
        }
        if ($data['city_id']) {
            $where['c.city_id'] = $data['city_id'];
        }
        //组内所有人
        $staff = db('c_staff_group')->alias('g')->join('c_staff_group_relation r','g.id=r.group_id')
            ->where('g.shop_code','in',session('shop_code'))
            ->field('g.id,g.group_name,r.staff_id,r.staff_name')
            ->select();
        if(!$staff[0]['staff_name']){
            $staffIds = implode(',',array_column($staff,'staff_id'));
            $url = "5a18e3fa516a1";
            $res = sx_call($url,array('staff_id'=>$staffIds));
            $staffNames = [];

            if($res['code'] == 200){
                $info = $res['data'];
                foreach($info as $key=>$val){
                    $staffNames[$val['id']] = $val['staffname'];
                }
            }else{
                $return = ['code' => 100, 'msg' => '批量查询小组人员信息失败', 'count' => 0, 'data' => ''];
                return json($return);
            }
        }
        //毛客资
        $djCustomer = db('c_customerinfo')->alias('c')->join('c_staff_group_relation r','c.sales_staff_id=r.staff_id')->join
        ('c_staff_group g','g.id=r.group_id')
            ->where($where)
            ->where('c.shop_code','in',$shop_code)
            ->where('dj_day', 'between time', [$start, $end])
            ->group('r.staff_id')
            ->order('g.id desc')
            ->column('count(c.id) as num,c.sales_staff,g.group_name','r.staff_id');
        //接入毛客资
        $allCustomer = db('c_customerinfo')->alias('c')->join('c_staff_group_relation r','c.sales_staff_id=r.staff_id')->join
        ('c_staff_group g','g.id=r.group_id')
            ->where($where)
            ->where('c.shop_code','in',$shop_code)
            ->where('c.jr_day', 'between time', [$start, $end])
            ->group('r.staff_id')
            ->order('g.id desc')
            ->column('count(c.id) as num,c.sales_staff,g.group_name','r.staff_id');
        //有效
        $validCustomer = db('c_customerinfo')->alias('c')->join('c_staff_group_relation r','c.sales_staff_id=r.staff_id')->join
        ('c_staff_group g','g.id=r.group_id')
            ->where($where)
            ->where($whereT)
             ->where('c.shop_code','in',$shop_code)
            ->where('c.is_valid', 1)
            ->where('c.yx_day', 'between time', [$start, $end])
            ->group('r.staff_id')
            ->order('g.id desc')
            ->column('count(c.id) as num,c.sales_staff,g.group_name','r.staff_id');
        //进店
        $yy =db('c_customerinfo')->alias('c')->join('c_staff_group_relation r','c.sales_staff_id=r.staff_id')->join
        ('c_staff_group g','g.id=r.group_id')
            ->where($where)
            ->where($whereT)
            ->where('c.shop_code','in',$shop_code)
            ->where('c.is_intostore', 'in',[2,3])
            ->where('c.syjd_day', 'between time', [$start, $end])
            ->group('r.staff_id')
            ->order('g.id desc')
            ->column('count(c.id) as num,c.sales_staff,g.group_name','r.staff_id');

        //新单（实际婚纱有效定单数）
        $newOrder = db('c_customerinfo')->alias('c')->join('c_staff_group_relation r','c.sales_staff_id=r.staff_id')->join
        ('c_staff_group g','g.id=r.group_id')
            ->where($where)
            ->where($whereT)
            ->where('c.shop_code','in',$shop_code)
            ->where('c.is_success', 1)
            ->where('c.order_day', 'between time', [$start, $end])
            ->group('r.staff_id')
            ->order('g.id desc')
            ->column('count(c.id) as num,c.sales_staff,g.group_name','r.staff_id');
        // 流失(进店成交)
        $loss = db('c_customerinfo')->alias('c')->join('c_staff_group_relation r','c.sales_staff_id=r.staff_id')->join
        ('c_staff_group g','g.id=r.group_id')
            ->where($where)
            ->where($whereT)
             ->where('c.shop_code','in',$shop_code)
            ->where('c.erp_loss', '2')
            // ->where('c.fact_money', 0)
            ->where('c.syjd_day', 'between time', [$start, $end])
            ->group('r.staff_id')
            ->order('g.id desc')
            ->column('count(c.id) as num,c.sales_staff,g.group_name','r.staff_id');
        //套系金额 套系金额累计（按订单时间计算）设定类型
        $totalMoney = db('c_customerinfo')->alias('c')->join('c_staff_group_relation r','c.sales_staff_id=r.staff_id')->join
        ('c_staff_group g','g.id=r.group_id')->join('c_customer_order o','c.order_number=o.order_sn')
            ->where($where)
             ->where('c.shop_code','in',$shop_code)
            ->where('c.is_success', 1)
            ->where('o.order_valid', 2)
            ->where('c.order_start_time', 'between time', [$start, $end])
            ->group('r.staff_id')
            ->order('g.id desc')
            ->column('sum(o.order_amount) as sum,c.sales_staff,g.group_name','r.staff_id');
        //实收金额累计(按订单时间计算)
        $factMoney = db('c_customerinfo')->alias('c')->join('c_staff_group_relation r','c.sales_staff_id=r.staff_id')->join
        ('c_staff_group g','g.id=r.group_id')->join('c_order_detail d','d.order_sn=c.order_number')
            ->where($where)
            ->where('c.shop_code','in',$shop_code)
            ->where('d.pay_type',1)
            ->where('d.pay_time', 'between time', [$start, $end])
            ->group('r.staff_id')
            ->order('g.id desc')
            ->column('sum(d.order_fact) as sum,c.sales_staff,g.group_name','r.staff_id');
        //预付定金 实收金额大于0，低于有效订单标准，的实收累计（订单时间计算）
        $dj = db('c_customerinfo')->alias('c')->join('c_staff_group_relation r','c.sales_staff_id=r.staff_id')->join
        ('c_staff_group g','g.id=r.group_id')->join('c_customer_order o','o.order_sn=c.order_number')
            ->where($where)
            ->where('c.shop_code','in',$shop_code)
            ->where('c.is_success', 3)
            ->where('o.target_time', 'between time', [$start, $end])
            ->group('r.staff_id')
            ->order('g.id desc')
            ->column('sum(o.earnest_money) as sum,c.sales_staff,g.group_name','r.staff_id');

        $returnData = [];
        $arr = [];
        $px = [];
        $arr['id'] = count($staff)+1;
        $arr['name'] = '';
        $arr['staff_name'] = '总计';
        $i = 1;
        //第一个小组
        $gid = $staff[0]['id'];
        //最后一个小组
        $last = end($staff);
        $lastSid = $last['staff_id'];
        $group = [];
        foreach($staff as $k=>$v){
            //小组总计
            $group[$v['id']]['id'] = '';
            $group[$v['id']]['name'] = '';
            $group[$v['id']]['staff_name'] = '总计';
            $group[$v['id']]['djCus'] += $djCustomer[$v['staff_id']]['num'] ? $djCustomer[$v['staff_id']]['num'] : 0;
            $group[$v['id']]['jrCus'] += $allCustomer[$v['staff_id']]['num'] ? $allCustomer[$v['staff_id']]['num'] : 0;//轮位客资
            $group[$v['id']]['valid'] += $validCustomer[$v['staff_id']]['num'] ? $validCustomer[$v['staff_id']]['num'] : 0;//有效客资
            $group[$v['id']]['yy'] += $yy[$v['staff_id']]['num'] ? $yy[$v['staff_id']]['num'] : 0;//进店数
            $group[$v['id']]['intoRate'] = sprintf('%.2f',$group[$v['id']]['yy']/$group[$v['id']]['valid'] * 100).'%';//进店率  进店/接入客资
            $group[$v['id']]['newOrder'] += $newOrder[$v['staff_id']]['num'] ? $newOrder[$v['staff_id']]['num'] : 0;//录入订单数
            $group[$v['id']]['cjRate'] = sprintf('%.2f',$group[$v['id']]['newOrder']/$group[$v['id']]['yy'] * 100).'%';//成交率 订单数/进店数
            $group[$v['id']]['loss'] += $loss[$v['staff_id']]['num'] ? $loss[$v['staff_id']]['num'] : 0;//流失
            $group[$v['id']]['lossRate'] = sprintf('%.2f',$group[$v['id']]['loss']/$group[$v['id']]['yy'] * 100).'%';//流失率 流失/进店
            $group[$v['id']]['totalMoney'] += $totalMoney[$v['staff_id']]['sum'] ? sprintf('%.2f',$totalMoney[$v['staff_id']]['sum']) : 0;//套系金额
            $group[$v['id']]['factMoney'] += $factMoney[$v['staff_id']]['sum'] ? sprintf('%.2f',$factMoney[$v['staff_id']]['sum']) : 0;//实收金额
            $group[$v['id']]['YK'] += $group[$v['id']]['totalMoney']-$group[$v['id']]['factMoney'] > 0 ? sprintf('%.2f',$group[$v['id']]['totalMoney']-$group[$v['id']]['factMoney']) : 0;//余款金额
            $group[$v['id']]['dj'] += $dj[$v['staff_id']]['sum'] ? sprintf('%.2f',$dj[$v['staff_id']]['sum']) : 0;//预付定金
            $group[$v['id']]['allCusOrderRate'] = sprintf('%.2f',$newOrder[$v['staff_id']]['num']/$group[$v['id']]['jrCus'] * 100).'%';//总客资成单率
            $group[$v['id']]['validOrderRate'] = sprintf('%.2f',$newOrder[$v['staff_id']]['num']/$group[$v['id']]['valid'] * 100).'%';//有效成单率

            $px['id'] = $i;
            $px['name'] = $v['group_name'];
            $px['staff_name'] = $v['staff_name'] ? $v['staff_name'] : $staffNames[$v['staff_id']];
            $px['djCus'] = $djCustomer[$v['staff_id']]['num'] ? $djCustomer[$v['staff_id']]['num'] : 0;
            $px['jrCus'] = $allCustomer[$v['staff_id']]['num'] ? $allCustomer[$v['staff_id']]['num'] : 0;//轮位客资
            $px['valid'] = $validCustomer[$v['staff_id']]['num'] ? $validCustomer[$v['staff_id']]['num'] : 0;//有效客资
            $px['yy'] = $yy[$v['staff_id']]['num'] ? $yy[$v['staff_id']]['num'] : 0;//进店数
            $px['intoRate'] = sprintf('%.2f',$px['yy']/$px['valid'] * 100).'%';//进店率  进店/接入客资
            $px['newOrder'] = $newOrder[$v['staff_id']]['num'] ? $newOrder[$v['staff_id']]['num'] : 0;//录入订单数
            $px['cjRate'] = sprintf('%.2f',$px['newOrder']/$px['yy'] * 100).'%';//成交率 订单数/进店数
            $px['loss'] = $loss[$v['staff_id']]['num'] ? $loss[$v['staff_id']]['num'] : 0;//流失(进店未成交)进店并且实收金额=0的（按进店时间计算）
            $px['lossRate'] = sprintf('%.2f',$px['loss']/$px['yy'] * 100).'%';//流失率 流失/进店
            $px['totalMoney'] = $totalMoney[$v['staff_id']]['sum'] ? sprintf('%.2f',$totalMoney[$v['staff_id']]['sum']) : 0;//套系金额
            $px['factMoney'] = $factMoney[$v['staff_id']]['sum'] ? sprintf('%.2f',$factMoney[$v['staff_id']]['sum']) : 0;//实收金额
            $px['YK'] = $px['totalMoney']-$px['factMoney'] > 0 ? sprintf('%.2f',$px['totalMoney']-$px['factMoney']) : 0;//余款金额

            $px['dj'] = $dj[$v['staff_id']]['sum'] ? sprintf('%.2f',$dj[$v['staff_id']]['sum']) : 0;//预付定金

            $px['allCusOrderRate'] = sprintf('%.2f',$px['newOrder']/$px['jrCus'] * 100).'%';//总客资成单率
            $px['validOrderRate'] = sprintf('%.2f',$px['newOrder']/$px['valid'] * 100).'%';//有效成单率

            if((!empty($gid) && ($gid != $v['id']))){
                $returnData[]= $group[$gid];
                $gid = $v['id'];
            }
            $returnData[] = $px;
            if($v['staff_id'] == $lastSid){
                $returnData[]= $group[$gid];
            }
            $arr['djCus'] += $px['djCus'];
            $arr['jrCus'] += $px['jrCus'];
            $arr['valid'] += $px['valid'];
            $arr['yy'] += $px['yy'];
            $arr['intoRate'] = '';
            $arr['newOrder'] += $px['newOrder'];
            $arr['cjRate'] = '';
            $arr['loss'] += $px['loss'];
            $arr['lossRate'] = '';
            $arr['totalMoney'] += floatval($px['totalMoney']);
            $arr['factMoney'] += floatval($px['factMoney']);
            $arr['YK'] += floatval($px['YK']);
            $arr['dj'] += $px['dj'];
            $arr['allCusOrderRate'] = '';
            $arr['validOrderRate'] = '';
                $i++;
        }
        $arr['totalMoney'] = sprintf('%.2f',$arr['totalMoney']);
        $arr['factMoney'] = sprintf('%.2f',$arr['factMoney']);
        $arr['YK'] = sprintf('%.2f',$arr['YK']);
        $arr['dj'] = sprintf('%.2f',$arr['dj']);
        $arr['intoRate'] = sprintf('%.2f',$arr['yy']/$arr['valid'] * 100).'%';//进店率  进店/接入客资
        $arr['cjRate'] = sprintf('%.2f',$arr['newOrder']/$arr['yy'] * 100).'%';//成交率 订单数/进店数
        $arr['lossRate'] = sprintf('%.2f',$arr['loss']/$arr['yy'] * 100).'%';//流失率 流失/进店
        $arr['allCusOrderRate'] = sprintf('%.2f',$arr['newOrder']/$arr['jrCus'] * 100).'%';//总客资成单率
        $arr['validOrderRate'] = sprintf('%.2f',$arr['newOrder']/$arr['valid'] * 100).'%';//有效成单率
        array_push($returnData,$arr);

        //无小组人员
        $allStaff = getStaffsByWorkType(['shop_code'=>$shop_code,'work_type'=>RECEIVE_WORK_TYPE]);
        $staffs = array_column($staff,'staff_id');
        $noGroupStaff = array_column($allStaff,'id');
        $staff_diff_id = array_diff($noGroupStaff,$staffs);
        $staff_diff_id = implode(',',$staff_diff_id);
        $url = '5a18e3fa516a1';
        $res = sx_call($url,['staff_id'=>$staff_diff_id]);
        if($res['code'] == 200){
            $another = $res['data'];
        }
        $sql = '';
       $sql .= "sum(dj_day between '$start' and '$end') as mkz,";
        $sql .= "sum(jr_day between '$start' and '$end') as jr,";
        if($consultation_type_id && session('brandclass_id') != 8){
            $sql .= "sum(consultation_type_id = ".$consultation_type_id." and is_valid=1 and yx_day between '$start' and '$end') as valid,";//有效
            $sql .= "sum(consultation_type_id = ".$consultation_type_id." and is_intostore in (2,3) and syjd_day between '$start' and '$end') as jd,";//婚纱进店
            $sql .= "sum(consultation_type_id = ".$consultation_type_id." and is_success=1 and order_day between '$start' and '$end') as `order`,";//婚纱订单
        }else{
            $sql .= "sum(is_valid=1 and yx_day between '$start' and '$end') as valid,";//有效
            $sql .= "sum(is_intostore in (2,3) and syjd_day between '$start' and '$end') as jd,";//婚纱进店
            $sql .= "sum(is_success=1 and order_day between '$start' and '$end') as `order`,";//婚纱订单
        }
        $sql .= "sum(is_intostore in ('2','3') and is_success=2 and syjd_day between '$start' and '$end') as loss";//流失

        $whereNo['is_status'] = 1;
        $whereNo['c_from'] = 1;
        // $whereNo['customer_type'] = 1;
        // 如果不是旅拍事业部，那么网销报表中查新客资，如果是旅拍事业部，不限制类型
        if (session('brandclass_id') != 2) {
            $whereNo['customer_type'] = 1;
        }
        // 录入客资量（分配）
        $info= db('c_customerinfo')
            ->where($whereNo)
            ->where('shop_code','in',$shop_code)
            ->where('sales_staff_id', 'in', $staff_diff_id)
            ->group('sales_staff_id')
            ->column($sql,'sales_staff_id');
        $whereN['c.is_status'] = 1;
        $whereN['c.c_from'] = 1;
        // $whereN['c.customer_type'] = 1;
        // 如果不是旅拍事业部，那么网销报表中查新客资，如果是旅拍事业部，不限制类型
        if (session('brandclass_id') != 2) {
            $whereN['c.customer_type'] = 1;
        }
        //套系
        $amount =  db('c_customerinfo')->alias('c')->join('c_customer_order o','c.order_number=o.order_sn')
            ->where($whereN)
            ->where('c.shop_code','in',$shop_code)
            ->where('c.is_success',1)
            ->where('o.order_valid', 2)
            ->where('c.sales_staff_id','in', $staff_diff_id)
            ->where('c.order_day', 'between time', [$start, $end])
            ->group('c.sales_staff_id')
            ->column('sum(o.order_amount) as amount','c.sales_staff_id');
        //实收
        $fact =  db('c_customerinfo')->alias('c')->join('c_order_detail d','d.order_sn=c.order_number')
            ->where($whereN)
            ->where('c.shop_code','in',$shop_code)
            ->where('d.pay_type',1)
            ->where('d.pay_time', 'between time', [$start, $end])
            ->where('c.sales_staff_id','in', $staff_diff_id)
            ->group('c.sales_staff_id')
            ->column('sum(d.order_fact) as fact','c.sales_staff_id');
        //定金
        $dingjin =  db('c_customerinfo')->alias('c')->join('c_customer_order o','c.order_number=o.order_sn')
            ->where($whereN)
            ->where('c.shop_code','in',$shop_code)
            ->where('o.order_valid',1)
            ->where('c.sales_staff_id','in', $staff_diff_id)
            ->where('c.order_start_time','between',[$start,$end])
            ->group('c.sales_staff_id')
            ->column('sum(o.earnest_money) as fact','c.sales_staff_id');
        $no = [];
        $noG = [];
        $noG['id'] = $i;
        $noG['name'] = '';
        $noG['staff_name'] = '总计';
        foreach($another as $k=>$v){
            $no['id'] = $i;
            $no['name'] = '无小组';
            $no['staff_name'] = $v['staffname'] ? $v['staffname'] : '';
            $no['djCus'] = $info[$v['id']]['mkz'] ? $info[$v['id']]['mkz'] : 0;
            $no['jrCus'] = $info[$v['id']]['jr'] ? $info[$v['id']]['jr'] : 0;

            $no['valid'] = $info[$v['id']]['valid'] ? $info[$v['id']]['valid'] : 0;

            $no['yy'] = $info[$v['id']]['jd'] ? $info[$v['id']]['jd'] : 0;//进店
            $no['intoRate'] = $info[$v['id']]['jd'] ? sprintf($info[$v['id']]['jd']/$info[$v['id']]['valid']*100).'%' : '';//进店率
            $no['newOrder'] = $info[$v['id']]['order'] ? $info[$v['id']]['order'] : 0;//订单
            $no['cjRate'] = sprintf('%.2f',$no['newOrder']/$no['yy'] * 100).'%';//成交率
            $no['loss'] =  $info[$v['id']]['loss'] ? $info[$v['id']]['loss'] : 0;//loss
            $no['lossRate'] = sprintf('%.2f',$no['loss']/$no['yy'] * 100).'%';//流失率
            $no['totalMoney'] = $amount[$v['id']] ? sprintf('%.2f',$amount[$v['id']]) : 0;//套系
            $no['factMoney'] = $fact[$v['id']] ? sprintf('%.2f',$fact[$v['id']]) : 0;//实收
            $no['YK'] =$no['totalMoney']-$no['factMoney'] > 0 ? sprintf('%.2f',$no['totalMoney']-$no['factMoney']) : 0;//余款金额
            $no['dj'] = $dingjin[$v['staff_id']]['fact'] ? sprintf('%.2f',$dingjin[$v['staff_id']]['fact']) : 0;//预付定金
            $no['allCusOrderRate'] = sprintf('%.2f',$info[$v['id']]['order']/$no['jrCus'] * 100).'%';//总客资成单率
            $no['validOrderRate'] = sprintf('%.2f',$info[$v['id']]['order']/$no['valid'] * 100).'%';//有效成单率
            $returnData[] = $no;
            //无小组人员相加
            $noG['djCus'] += $no['djCus'];
            $noG['jrCus'] += $no['jrCus'];
            $noG['valid'] += $no['valid'];
            $noG['yy'] += $no['yy'];
            $noG['intoRate'] = '';
            $noG['newOrder'] += $no['newOrder'];
            $noG['cjRate'] = '';
            $noG['loss'] += $no['loss'];
            $noG['lossRate'] = '';
            $noG['totalMoney'] += floatval($no['totalMoney']);
            $noG['factMoney'] += floatval($no['factMoney']);
            $noG['YK'] += floatval($no['YK']);
            $noG['dj'] += $no['dj'];
            $noG['allCusOrderRate'] = '';
            $noG['validOrderRate'] = '';
                $i++;
        }

        $noG['djCus'] += $arr['djCus'];
        $noG['jrCus'] += $arr['jrCus'];
        $noG['valid'] += $arr['valid'];
        $noG['yy'] += $arr['yy'];
        $noG['intoRate'] = sprintf('%.2f',$noG['yy']/$noG['valid'] * 100).'%';//进店率  进店/接入客资
        $noG['newOrder'] += $arr['newOrder'];
        $noG['cjRate'] = sprintf('%.2f',$noG['newOrder']/$noG['yy'] * 100).'%';//成交率 订单数/进店数
        $noG['loss'] += $arr['loss'];
        $noG['lossRate'] = sprintf('%.2f',$noG['loss']/$noG['yy'] * 100).'%';//流失率 流失/进店
        $noG['totalMoney'] += floatval($arr['totalMoney']);
        $noG['factMoney'] += floatval($arr['factMoney']);
        $noG['YK'] += floatval($arr['YK']);
        $noG['dj'] += floatval($arr['dj']);
        $noG['totalMoney'] = sprintf('%.2f',$noG['totalMoney']);
        $noG['factMoney'] = sprintf('%.2f',$noG['factMoney']);
        $noG['YK'] = sprintf('%.2f',$noG['YK']);
        $noG['dj'] = sprintf('%.2f',$noG['dj']);
        $noG['allCusOrderRate'] = sprintf('%.2f',$noG['newOrder']/$noG['jrCus'] * 100).'%';//总客资成单率
        $noG['validOrderRate'] = sprintf('%.2f',$noG['newOrder']/$noG['valid'] * 100).'%';//有效成单率
        $returnData[] = $noG;
        // 导出
        if ($data['need'] == 1) {
            $code = $this->getCode();
            $ff = db('s_report_form')->where('code', $code)->value('report_name');
            $shop = controller('crm/Customer','lib')->get_shop(['shop_code'=>$shop_code]);
            $file = $shop[0]['shop_name'].'-'.$ff.'.xlsx';
            controller("crm/Customer", "lib")->export($title, $returnData, $file);
        } else {
            $return['code'] = 0;
            $return['msg'] = '';
            $return['count'] = count($returnData);
            $return['data'] = $returnData;
            return json($return);
        }
    }

    public function show(){
        $code = $this->getCode();
        $did = strtolower(input('param.did'));
        $info = db('s_report_form')->alias('f')->join('s_report_detail d','d.form_id=f.id')->where('d.id',$did)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();
        $shop= controller('crm/Customer','lib')->get_shop(['shop_code'=>$info['shop_code']]);
        $this->assign('shopList', $shop);
        //消费类型
        $consumptionType = controller("Customer", "lib")->consumptionType(['brandclass_id'=>$info['brandclass_id']]);
        $this->assign("consumptionType", $consumptionType);
        // 来源渠道
        // $channels = controller('crm/Customer', 'lib')->getChannel();
        // $this->assign('channel', $channels);
        
//        //查询事业部下的电商店
//        $shop = controller('crm/Customer','lib')->shop(['belong_shop_code'=>session('shop_code'),'is_marketing'=>1]);
//        array_push($shop,['shop_code'=>session('shop_code'),'shop_name'=>session('shop_name')]);
        //来源渠道
        $shopCode = array_column($shop,'shop_code');
        $channel = db('s_channel')->where('shop_code','in',$shopCode)->order('order_sort')->select();
        $this->assign("channel", $channel);

        // 客资标记
        $signs = db('STracksign')->where('shop_code',$info['shop_code'])->where('is_delete',1)->select();
        $this->assign('signs', $signs);
        // crm省    列表
        $data['type'] = 1;
        $data['shop_code'] = $info['shop_code'];
        $province = controller("Customer", "lib")->address($data);
        $this->assign('province', $province);
        //获取方式
        $accessModel = controller("Customer", "lib")->accessModel(array('shop_code' => $info['shop_code']));
        $this->assign("accessModel", $accessModel);

        $display = APP_PATH.'crm'.DS.'view'.DS.'report'.DS.strtolower($info['report_class_name']).'.html';
        $title = db('s_report_form')->where('code', $code)->value('report_name');
        $this->assign('title', $shop[0]['shop_name'].'-'.$title);
        $this->assign('did', $info['id']);
        return $this->fetch($display);
    }

}