<?php
return $sqlUpdate = [
    /*一个版本开始：*/
    '1.0.1' => [
        [ /*第一个改动*/
            'type' => 'table', /*操作类型：table表示添加一个表，column表示添加一个字段*/
            'name' => 's_test2', /*如果是添加一个表，此处为表名，如果是添加一个字段，此处是要哪个表添加字段*/
            'fields' => [ /*此值为系统要操作的字段列表，如果为多个表添加字段，外层写多个数组，如果是一个表添加多个字段，此字段写成数组形式即可*/
                ['name' => 'id', 'type' => 'int', 'default' => 'AUTO_INCREMENT', 'is_null' => false],
                /*name 字段名，type字段类型 default默认值，可以不设如果需要自增，设为：AUTO_INCREMENT is_null 是否可以为NULL primary 是否为主键，默认AUTO_INCREMENT为主键*/
                ['name' => 'field_1', 'type' => 'varchar', 'length' => 50, 'default' => '', 'is_null' => true],
                /*如果是字符串类型字段，需要指明长度*/
                ['type' => 'key', 'name' => 'key1', 'fields' => ['field_1', 'id']],
                /*如果要加索引，设定一个字段名为索引的字段名，type为key ,fields内为此索引的字段数组。*/
            ],
        ],
        [ /*第二个改动*/
            'type' => 'column',
            'name' => 'app_version',
            'fields' => [
                ['name' => 'up_sql', 'type' => 'text', 'is_null' => true],
            ],
        ],
        [ /*第三个改动*/
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['name', 'sex', 'age'], /*要插入的字段*/
                'value' => [ /*要插入的字段对应的数据*/
                    ['小红', '1', '14'],
                    ['王明', '2', '14'],
                    ['赵强', '1', '64'],
                ],
            ],
        ],
    ],
    /*一个版配所有升级语句结束*/
    '1.1.1' => [
        [ /*第一个改动*/
            'type' => 'table',
            'name' => 'c_customer_contact',
            'fields' => [
                ['name' => 'id', 'type' => 'int', 'default' => 'AUTO_INCREMENT', 'is_null' => false],
                ['name' => 'c_id', 'type' => 'int', 'length' => 11, 'is_null' => true],
                ['name' => 'contact', 'type' => 'varchar', 'length' => 50, 'default' => '', 'is_null' => true],
            ],
        ],
    ],

    '1.1.3' => [
        [ /*第二个改动*/
            'type' => 'column',
            'name' => 'c_customer_contact',
            'fields' => [
                ['name' => 'brandclass', 'type' => 'varchar', 'length' => 50, 'default' => '', 'is_null' => true],
            ],
        ],
        [ /*第二个改动*/
            'type' => 'column',
            'name' => 'c_excel_import',
            'fields' => [
                ['name' => 'import_fail', 'type' => 'int', 'default' => 0, 'is_null' => true],
            ],
        ],
    ],
    '1.1.4' => [
        [
            'type' => 'table',
            'name' => 's_channel',
            'fields' => [
                ['name' => 'id', 'type' => 'int', 'default' => 'AUTO_INCREMENT', 'is_null' => false],
                // 客资 来源渠道设定第一层 由 mc 设定
                ['name' => 'channel_class_id', 'type' => 'int', 'length' => 11, 'default' => 0, 'is_null' => false],
                ['name' => 'channel_class_name', 'type' => 'varchar', 'length' => 50, 'default' => '', 'is_null' => false],
                // 客资 来源渠道设定第二层 由 mc 设定
                ['name' => 'channel_info_id', 'type' => 'int', 'length' => 11, 'default' => 0, 'is_null' => false],
                ['name' => 'channel_info_name', 'type' => 'varchar', 'length' => 50, 'default' => '', 'is_null' => false],
                // 子账号名称
                ['name' => 'channel_name', 'type' => 'varchar', 'length' => 50, 'default' => '', 'is_null' => true],
                ['name' => 'brandclass_id', 'type' => 'int', 'length' => 11, 'default' => 0, 'is_null' => true],
                ['name' => 'brandclass_name', 'type' => 'varchar', 'length' => 50, 'default' => '', 'is_null' => true],
                ['name' => 'shop_code', 'type' => 'varchar', 'length' => 50, 'default' => '', 'is_null' => true],
                ['name' => 'shop_name', 'type' => 'varchar', 'length' => 50, 'default' => '', 'is_null' => true],
                ['name' => 'setkey', 'type' => 'varchar', 'length' => 50, 'default' => '', 'is_null' => true],
                ['type' => 'key', 'name' => 'key1', 'fields' => ['id']]
            ],
        ],
    ],
    '1.1.5' => [
        [ /*第三个改动*/
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'], /*要插入的字段*/
                'value' => [ /*要插入的字段对应的数据*/
                    ['渠道子账户', 6, 'menu1516949559', '/crm/Setting/channel', 1, 50],
                ],
            ],
            [ /*第一个改动*/
                'type' => 'column',
                'name' => 's_channel_cost',
                'fields' => [
                    // 客资 来源渠道设定第一层 由 mc 设定
                    ['name' => 'channel_class_id', 'type' => 'int', 'length' => 11, 'default' => 0, 'is_null' => false],
                    ['name' => 'channel_class_name', 'type' => 'varchar', 'length' => 50, 'default' => '', 'is_null' => false],
                    // 客资 来源渠道设定第二层 由 mc 设定
                    ['name' => 'channel_info_id', 'type' => 'int', 'length' => 11, 'default' => 0, 'is_null' => false],
                    ['name' => 'channel_info_name', 'type' => 'varchar', 'length' => 50, 'default' => '', 'is_null' => false],
                ],
            ],
            [ /*第二个改动*/
                'type' => 'column',
                'name' => 's_channel_cost_return',
                'fields' => [
                    // 客资 来源渠道设定第一层 由 mc 设定
                    ['name' => 'channel_class_id', 'type' => 'int', 'length' => 11, 'default' => 0, 'is_null' => false],
                    ['name' => 'channel_class_name', 'type' => 'varchar', 'length' => 50, 'default' => '', 'is_null' => false],
                    // 客资 来源渠道设定第二层 由 mc 设定
                    ['name' => 'channel_info_id', 'type' => 'int', 'length' => 11, 'default' => 0, 'is_null' => false],
                    ['name' => 'channel_info_name', 'type' => 'varchar', 'length' => 50, 'default' => '', 'is_null' => false],
                ],
            ],
            [ /*第三个改动*/
                'type' => 'column',
                'name' => 'c_customer_cost',
                'fields' => [
                    // 客资 来源渠道设定第一层 由 mc 设定
                    ['name' => 'channel_class_id', 'type' => 'int', 'length' => 11, 'default' => 0, 'is_null' => false],
                    ['name' => 'channel_class_name', 'type' => 'varchar', 'length' => 50, 'default' => '', 'is_null' => false],
                    // 客资 来源渠道设定第二层 由 mc 设定
                    ['name' => 'channel_info_id', 'type' => 'int', 'length' => 11, 'default' => 0, 'is_null' => false],
                    ['name' => 'channel_info_name', 'type' => 'varchar', 'length' => 50, 'default' => '', 'is_null' => false],
                ],
            ],
        ],
    ],
    '1.1.6' => [
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'], /*要插入的字段*/
                'value' => [ /*要插入的字段对应的数据*/
                    ['失败再分配', 61, 'menu1517042801', '/crm/Customer/customerReAllot', 1, 0],
                ],
            ],
        ],
    ],
    '1.1.7' => [
        [
            'type' => 'column',
            'name' => 'c_customerinfo',
            'fields' => [
                // 追踪标记id （ 关联追踪标记设定 ）
                ['name' => 'op_signinfo_id', 'type' => 'int', 'length' => 11, 'default' => 0, 'is_null' => true],
            ],
        ],
    ],
    '1.1.8' => [
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'], /*要插入的字段*/
                'value' => [ /*要插入的字段对应的数据*/
                    ['客资标记', 2, 'menu1517129233', '', 0, 30],
                    ['标记有效', 105, 'menu1517129299', '/crm/signValid', 1, 30],
                    ['标记无效', 105, 'menu1517129331', '/crm/signUnvalid', 1, 30],
                ],
            ],
        ],
    ],
    '1.1.9' => [
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'], /*要插入的字段*/
                'value' => [ /*要插入的字段对应的数据*/
                    ['当日接收', 34, 'menu1517217988', '', 1, 1],
                    ['三日内追踪', 34, 'menu1517218007', '', 1, 1],
                    ['当日预进店', 34, 'menu1517218044', '', 1, 1],
                ],
            ],
        ],
    ],
    '1.1.10' => [
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'], /*要插入的字段*/
                'value' => [ /*要插入的字段对应的数据*/
                    ['客资驳回', 2, 'menu1517278817', '/crm/customerValidUpdate', 0, 20],
                    ['客资反驳回', 2, 'menu1517278844', '/crm/customerUnValidUpdate', 0, 20],
                ],
            ],
        ],
    ],
    '1.1.11' => [
        [
            'type' => 'column',
            'name' => 'c_customer_cost',
            'fields' => [
                ['name' => 'province_id', 'type' => 'int', 'length' => 11, 'default' => 0, 'is_null' => true],
                ['name' => 'province_name', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
                ['name' => 'city_id', 'type' => 'int', 'length' => 11, 'default' => 0, 'is_null' => true],
                ['name' => 'city_name', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
            ],
        ],
        [
            'type' => 'column',
            'name' => 's_channel_cost',
            'fields' => [
                ['name' => 'province_id', 'type' => 'int', 'length' => 11, 'default' => 0, 'is_null' => true],
                ['name' => 'province_name', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
                ['name' => 'city_id', 'type' => 'int', 'length' => 11, 'default' => 0, 'is_null' => true],
                ['name' => 'city_name', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
            ],
        ],
        [
            'type' => 'column',
            'name' => 's_channel_cost_return',
            'fields' => [
                ['name' => 'province_id', 'type' => 'int', 'length' => 11, 'default' => 0, 'is_null' => true],
                ['name' => 'province_name', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
                ['name' => 'city_id', 'type' => 'int', 'length' => 11, 'default' => 0, 'is_null' => true],
                ['name' => 'city_name', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
            ],
        ],
    ],
    '1.1.12' => [
        [
            'type' => 'table',
            'name' => 's_shop_address',
            'fields' => [
                ['name' => 'id', 'type' => 'int', 'default' => '0', 'is_null' => false],
                ['name' => 'pid', 'type' => 'int', 'length' => 11, 'default' => 0, 'is_null' => false],
                ['name' => 'name', 'type' => 'varchar', 'length' => 50, 'default' => null, 'is_null' => false],
                ['name' => 'type', 'type' => 'tinyint', 'length' => 1, 'default' => 0, 'is_null' => false],
                ['name' => 'shop_code', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => false],
            ],
        ],
    ],
    '1.1.13' => [
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'], /*要插入的字段*/
                'value' => [ /*要插入的字段对应的数据*/
                    ['省市区设定', 6, 'menu1517560908', '/crm/Setting/province', 1, 90],
                ],
            ],
        ],
    ],
    '1.1.14' => [
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'], /*要插入的字段*/
                'value' => [ /*要插入的字段对应的数据*/
                    ['渠道-各店转化率表', 5, 'menu1517727451', '/crm/Statistics/swCustomerChange', 1, 9],
                ],
            ],
        ],
    ],
    '1.1.16' => [
        [
            'type' => 'column',
            'name' => 's_kpi_staffgoal',
            'fields' => [
                ['name' => 'order_sort', 'type' => 'int', 'length' => 5, 'default' => 0, 'is_null' => true],
            ],
        ],
    ],
    '1.1.17' => [
        [
            // 自定义列表
            'type' => 'table',
            'name' => 's_custom_column',
            'fields' => [
                ['name' => 'id', 'type' => 'int', 'default' => 'AUTO_INCREMENT', 'is_null' => false],
                // jqgrid 每一列的配置信息
                ['name' => 'custom_model', 'type' => 'text', 'default' =>null, 'is_null' => true],
                // 列名
                ['name' => 'custom_name', 'type' => 'text', 'default' => null, 'is_null' => true],
                // 列字段名
                ['name' => 'custom_column', 'type' => 'text', 'default' => null, 'is_null' => true],
                ['name' => 'staff_id', 'type' => 'int', 'length' => 11, 'default' => 0, 'is_null' => false],
                ['type' => 'key', 'name' => 'key1', 'fields' => ['id']]
            ],
        ],
    ],
    '1.1.18' => [
        [
            'type' => 'column',
            'name' => 's_kpi_staffgoal',
            'fields' => [
                ['name' => 'flag', 'type' => 'varchar', 'length' =>11, 'default' => null, 'is_null' => true],
                ['name' => 'department_id', 'type' => 'int', 'length' => 11, 'default' => 0, 'is_null' => true],
                ['name' => 'department_name', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
                ['name' => 'staff_id', 'type' => 'int', 'length' => 11, 'default' => 0, 'is_null' => true],
                ['name' => 'staff_name', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
            ],
        ],
    ],
    '1.1.19' => [
        [
            'type' => 'column',
            'name' => 's_kpi_staffgoal',
            'fields' => [
                ['name' => 'channel_id', 'type' => 'int', 'length' => 11, 'default' => 0, 'is_null' => true],
                ['name' => 'channel_name', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
                ['name' => 'region_id', 'type' => 'int', 'length' => 11, 'default' => 0, 'is_null' => true],
                ['name' => 'region_name', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
                ['name' => 'province_id', 'type' => 'int', 'length' => 11, 'default' => 0, 'is_null' => true],
                ['name' => 'province_name', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
                ['name' => 'city_id', 'type' => 'int', 'length' => 11, 'default' => 0, 'is_null' => true],
                ['name' => 'city_name', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
            ],
        ],
    ],
    '1.1.20' => [
        [
            // 自定义选项卡表
            'type' => 'table',
            'name' => 's_customer_tab',
            'fields' => [
                ['name' => 'id', 'type' => 'int', 'length' => 11, 'default' => 0, 'is_null' => false],
                // 选项卡名
                ['name' => 'name', 'type' => 'varchar', 'length' => 11, 'default' =>null, 'is_null' => true],
                // 选项对应的sql条件
                ['name' => 'sql', 'type' => 'text', 'default' => null, 'is_null' => true],
                // 排序
                ['name' => 'order_sort', 'type' => 'int', 'length' => 4, 'default' => 0, 'is_null' => true],
                // 是否使用 1：使用；2：禁用
                ['name' => 'is_use', 'type' => 'tinyint', 'length' => 3, 'default' => 1, 'is_null' => false],
            ],
        ],
    ],
    '1.1.21' => [
        [
            'type' => 'column',
            'name' => 's_customer_tab',
            'fields' => [
                // li标签id
                ['name' => 'li_id', 'type' => 'varchar', 'length' => 100, 'default' => '', 'is_null' => true],
                // 显示数据条数span 标签 id
                ['name' => 'count_id', 'type' => 'varchar', 'length' => 100, 'default' => '', 'is_null' => true],
            ],
        ],
    ],
    '1.1.22' => [
        [
            'type' => 'column',
            'name' => 's_customer_tab',
            'fields' => [
                // 权限code
                ['name' => 'auth_code', 'type' => 'varchar', 'length' => 100, 'default' => '', 'is_null' => true],
            ],
        ],
    ],
    '1.1.23' => [
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'], /*要插入的字段*/
                'value' => [ /*要插入的字段对应的数据*/
                    ['选项卡-有效客资', 34, 'menu1519611713', '', 1, 13],
                    ['选项卡-无效客资', 34, 'menu1519611738', '', 1, 14],
                    ['选项卡-待定客资', 34, 'menu1519611762', '', 1, 15],
                    ['选项卡-驳回客资', 34, 'menu1519611781', '', 1, 16],
                    ['右键-客资标记', 2, 'menu1519631971', '/crm/Customer/customerSign', 0, 20],
                    ['右键-追踪标记', 2, 'menu1519632099', '/crm/Customer/customerSign', 0, 21],
                    ['右键-不再追踪', 2, 'menu1519633436', '/crm/Customer/notTraking', 0, 30],
                    ['右键-预约进店', 2, 'menu1519633870', '/crm/Customer/customerYJD', 0, 25],
                    ['右键-转订单', 2, 'menu1519633923', '/crm/Customer/zhuanOrder', 0, 26],
                    ['右键-编辑订单', 2, 'menu1519633959', '/crm/Customer/editOrder', 0, 27],
                    ['右键-筛客', 2, 'menu1519635403', '/crm/Customer/skCustomer', 0, 20],
                ],
            ],
        ],
    ],
    '1.1.24' => [
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'], /*要插入的字段*/
                'value' => [ /*要插入的字段对应的数据*/
                    ['渠道漏斗统计', 5, 'menu1519826594', '/crm/Statistics/ds_channelLd', 0, 2],
                    ['地域漏斗统计', 5, 'menu1519826642', '/crm/Statistics/ds_regionLd', 0, 2],
                ],
            ],
        ],
    ],
    '1.1.25' => [
        [
            'type' => 'column',
            'name' => 'c_customer_order',
            'fields' => [
                //订单获取时间
                ['name' => 'target_time', 'type' => 'datetime', 'default' => null, 'is_null' => true],
            ],
        ],
    ],
    '1.1.26' => [
        [
            'type' => 'column',
            'name' => 'c_order_detail',
            'fields' => [
                //订单支付类型:1:一销；2：二销；3：三销；4：四销
                ['name' => 'pay_type', 'type' => 'int','length'=>2, 'default' => null, 'is_null' => false],
            ],
        ],
    ],
    '1.1.27' => [
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'], /*要插入的字段*/
                'value' => [ /*要插入的字段对应的数据*/
                    ['右键-撤销', 2, 'menu1520675106', '/crm/Customer/customerRevoke', 0, 28],
                ],
            ],
        ],
    ],
    '1.1.28' => [
        [
            'type' => 'column',
            'name' => 'c_customerinfo',
            'fields' => [
                // 是否参加活动，默认1，不参加；2：参加
                ['name' => 'is_act', 'type' => 'int', 'length' => 2, 'default' =>1, 'is_null' => true],
            ],
        ],
        // 客资爆破活动设定表
        [
            'type' => 'table',
            'name' => 's_swapset',
            'fields' => [
                ['name' => 'id', 'type' => 'int','length' => 11, 'default' => 'AUTO_INCREMENT', 'is_null' => false],
                // 爆破活动编号 
                ['name' => 'swap_number', 'type' => 'char', 'length' => 14, 'default' =>'', 'is_null' => false],
                // 爆破活动名称 
                ['name' => 'swap_name', 'type' => 'varchar', 'length' => 100, 'default' =>'', 'is_null' => false],
                // 参与爆破活动的员工id集合，用逗号（,）分隔 
                ['name' => 'swap_staff_ids', 'type' => 'varchar', 'length' => 200, 'default' =>'', 'is_null' => false],
                // 参与爆破活动的员工账号集合，逗号（,）分隔 
                ['name' => 'swap_staff_names', 'type' => 'text', 'is_null' => false],
                // 选择客资开始时间 
                ['name' => 'customer_start', 'type' => 'date', 'default' =>null, 'is_null' => true],
                // 选择客资结束时间  
                ['name' => 'customer_end', 'type' => 'date', 'default' =>null, 'is_null' => true],
                // 客资爆破活动开始时间  
                ['name' => 'start_date', 'type' => 'date', 'default' =>null, 'is_null' => true],
                // 客资爆破活动结束时间 
                ['name' => 'end_date', 'type' => 'date', 'default' =>null, 'is_null' => true],
                ['name' => 'brandclass_id', 'type' => 'int', 'length' => 11, 'default' => 0, 'is_null' => true],
                ['name' => 'brandclass', 'type' => 'varchar', 'length' => 50, 'default' => '', 'is_null' => true],
                ['name' => 'shop_code', 'type' => 'varchar', 'length' => 100, 'default' => '', 'is_null' => true],
                ['name' => 'shop_name', 'type' => 'varchar', 'length' => 100, 'default' => '', 'is_null' => true],
                // 活动状态（1：未开始；2：已开始；3：已结束）
                ['name' => 'status', 'type' => 'tinyint', 'length' => 2, 'default' =>1, 'is_null' => true],
                // 是否删除（1：未删除；2：已删除）
                ['name' => 'is_del', 'type' => 'tinyint', 'length' => 2, 'default' =>1, 'is_null' => true],
                // 创建时间
                ['name' => 'create_time', 'type' => 'datetime', 'default' =>null, 'is_null' => true],
                // 编辑更新时间
                ['name' => 'update_time', 'type' => 'datetime', 'default' =>null, 'is_null' => true],
            ],
        ],
        // 客资爆破活动表
        [
            'type' => 'table',
            'name' => 'c_swap_customer',
            'fields' => [
                ['name' => 'id', 'type' => 'int', 'length' => 11, 'default' => 'AUTO_INCREMENT', 'is_null' => false],
                // 爆破活动编号 
                ['name' => 'swap_number', 'type' => 'char', 'length' => 14, 'default' =>'', 'is_null' => false],
                // 客资number
                ['name' => 'customer_number', 'type' => 'varchar', 'length' => 50, 'default' => 0, 'is_null' => true],
                // 客资有效状态（c:原状态）
                ['name' => 'c_is_valid', 'type' => 'tinyint', 'length' => 2, 'default' => 0, 'is_null' => true],
                ['name' => 'is_valid', 'type' => 'tinyint', 'length' => 2, 'default' => 0, 'is_null' => true],
                // 客资进店状态
                ['name' => 'c_is_intostore', 'type' => 'tinyint', 'length' => 2, 'default' => 0, 'is_null' => true],
                ['name' => 'is_intostore', 'type' => 'tinyint', 'length' => 2, 'default' => 0, 'is_null' => true],
                // 客资订单状态
                ['name' => 'c_is_success', 'type' => 'tinyint', 'length' => 2, 'default' => 0, 'is_null' => true],
                ['name' => 'is_success', 'type' => 'tinyint', 'length' => 2, 'default' => 0, 'is_null' => true],
                // 追踪人相关信息 staff_id  staff_number staff_id
                ['name' => 'sales_staff_id', 'type' => 'int', 'length' => 11, 'default' => 0, 'is_null' => true],
                ['name' => 'sales_staff_name', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
                ['name' => 'sales_staff_number', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
                ['name' => 'brandclass_id', 'type' => 'int', 'length' => 11, 'default' => 0, 'is_null' => true],
                ['name' => 'brandclass', 'type' => 'varchar', 'length' => 50, 'default' => '', 'is_null' => true],
                ['name' => 'shop_code', 'type' => 'varchar', 'length' => 100, 'default' => '', 'is_null' => true],
                ['name' => 'shop_name', 'type' => 'varchar', 'length' => 100, 'default' => '', 'is_null' => true],
                // 创建时间
                ['name' => 'create_time', 'type' => 'datetime', 'default' =>null, 'is_null' => true],
            ],
        ],
    ],
    '1.1.29' => [
        [
            'type' => 'column',
            'name' => 'c_customer_order',
            'fields' => [
                ['name' => 'brandclass_id', 'type' => 'int','length'=>11, 'default' => null, 'is_null' => true],
                ['name' => 'brandclass', 'type' => 'varchar','length'=>50, 'default' => null, 'is_null' => true],
            ],
        ],
    ],
    '1.1.35' => [
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'], /*要插入的字段*/
                'value' => [ /*要插入的字段对应的数据*/
                    ['返点规则设定', 6, 'menu1521280345', '/crm/Setting/shop_return_setting', 1, 100],
                ],
            ],
        ],
    ],
    //店面返点规则设定表
    '1.1.36' => [
        [
            'type' => 'table',
            'name' => 's_shop_return_rule',
            'fields' => [
                ['name' => 'id', 'type' => 'int', 'default' => 'AUTO_INCREMENT', 'is_null' => false],
                // 返点设定标准 1：占比；2：定额
                ['name' => 'return_rule', 'type' => 'tinyint', 'length'=>1,'default' =>1, 'is_null' => true],
                // 规则设定的 值 百分比 （1000/10）
                ['name' => 'return_value', 'type' => 'int', 'length'=>10, 'default' => 0, 'is_null' => true],
                ['name' => 'channel_id', 'type' => 'int', 'length'=>11, 'default' => 0, 'is_null' => true],
                ['name' => 'channel_name', 'type' => 'varchar', 'length'=>100, 'default' => null, 'is_null' => true],
                ['name' => 'shop_code', 'type' => 'varchar','length'=>100, 'default' => null, 'is_null' => true],
                ['name' => 'shop_name', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
                ['name' => 'brandclass_id', 'type' => 'int', 'length' => 11, 'default' => 0, 'is_null' => true],
                ['name' => 'brandclass', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
                ['type' => 'key', 'name' => 'key1', 'fields' => ['id']]
            ],
        ],
    ],
    '1.1.37' => [
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url','menu_icon', 'status', 'sort'], /*要插入的字段*/
                'value' => [ /*要插入的字段对应的数据*/
                    ['查询服务', 0, 'menu1521267312', '/crm/Customer/moreSearch','fa-search', 1, 3],
                ],
            ],
        ],
    ],
    '1.1.38' => [
        [
            'type' => 'column',
            'name' => 'c_swap_customer',
            'fields' => [
                // 预计时间 （c-原）
                ['name' => 'c_yjd_day', 'type' => 'datetime', 'default' => null, 'is_null' => true],
                ['name' => 'yjd_day', 'type' => 'datetime', 'default' => null, 'is_null' => true],
            ],
        ],
    ],
    '1.1.39' => [
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'], /*要插入的字段*/
                'value' => [ /*要插入的字段对应的数据*/
                    ['电商统计日报--常态报表1', 5, 'menu1521352296', '/crm/Statistics/ds_sta_day', 0, 10],
                    ['电商统周报--常态报表2', 5, 'menu1521352325', '/crm/Statistics/ds_sta_month', 0, 11],
                    ['电商统计日报--常态报表3', 5, 'menu1521352381', '/crm/Statistics/ds_to_wx_report', 0, 12],
                    ['电商日报明细', 5, 'menu1521352428', '/crm/Statistics/daily_detail', 0, 13],
                    ['网销漏斗', 5, 'menu1521352461', '/crm/Statistics/wx_ld', 0, 14],
                    ['渠道透视', 5, 'menu1521352487', '/crm/Statistics/qd_ts', 0, 15],
                    ['地域渠道有效客资透视', 5, 'menu1521352560', '/crm/Statistics/dy_ts', 6, 16],
                    ['网销无效分析', 5, 'menu1521352579', '/crm/Statistics/wx_unvalid', 0, 17],
                    ['渠道漏斗月走势统计', 5, 'menu1521352601', '/crm/Statistics/channel_ld_month', 0, 18],
                    ['关键词分析', 5, 'menu1521352632', '/crm/Statistics/keywords', 0, 19],
                    ['网销小组数据统计', 5, 'menu1521352658', '/crm/Statistics/wx_group', 0, 20],
                    ['网销小组邀约(进店)统计', 5, 'menu1521352682', '/crm/Statistics/wx_group_jd', 0, 21],
                    ['网销小组新单统计', 5, 'menu1521352703', '/crm/Statistics/wx_group_new_order', 0, 22],
                    ['网销地域统计', 5, 'menu1521352729', '/crm/Statistics/wx_region', 0, 23],
                    ['电商目标达成统计', 5, 'menu1521352748', '/crm/Statistics/ds_goal', 0, 24],
                    ['电商渠道达成进店跟踪', 5, 'menu1521352772', '/crm/Statistics/ds_shop_goal', 0, 25],
                ],
            ],
        ],
    ],
    '1.1.40'=>[
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['批量客资查询', 134, 'menu1521439092', '/crm/Customer/moreSearch', 1, 0],
                    ['门市订单查询', 134, 'menu1521352773', '/crm/Customer/searchorders', 1, 2],
                ],
            ],
        ],
    ],
    '1.1.44'=>[
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'],
                'value' => [ 
                    ['客资爆破', 6, 'menu1521091523', '/crm/Setting/customerSwap', 1, 101],
                    ['爆破设定', 171, 'menu1521093152', '/crm/Setting/customerSwapSet', 1, 102],
                    ['添加客资', 171, 'menu1521093203', '/crm/Setting/addCustomerSwap', 1, 103],
                ]
            ],
        ],
        [
            'type' => 'column',
            'name' => 'c_customerinfo',
            'fields' => [ /* 预计进店操作时间 */
                ['name' => 'yjd_action_day', 'type' => 'datetime', 'default' => null, 'is_null' => true],
            ],
        ],
        [
            'type' => 'column',
            'name' => 'c_swap_customer',
            'fields' => [ /* 预计进店操作时间 */
                // 预计时间 （c-原）
                ['name' => 'c_yjd_action_day', 'type' => 'datetime', 'default' => null, 'is_null' => true],
                ['name' => 'yjd_action_day', 'type' => 'datetime', 'default' => null, 'is_null' => true],
            ],
        ],
        [   // 驳回原因设定表
            'type' => 'table',
            'name' => 's_reject_reason',
            'fields' => [
                ['name' => 'id', 'type' => 'int', 'default' => 'AUTO_INCREMENT', 'is_null' => false],
                ['name' => 'reason', 'type' => 'varchar', 'length'=>255 ,'default' =>null, 'is_null' => true],
                ['name' => 'shop_code', 'type' => 'varchar','length'=>100, 'default' => null, 'is_null' => true],
                ['name' => 'shop_name', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
                ['name' => 'brandclass_id', 'type' => 'int', 'length' => 11, 'default' => 0, 'is_null' => true],
                ['name' => 'brandclass', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
            ],
        ],
    ],
    '1.1.45'=>[
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['驳回原因设定', 6, 'menu1521784361', '/crm/Setting/RejectReason', 1, 21],
                ],
            ],
        ],
    ],
    '1.1.46' => [
        [
            'type' => 'column',
            'name' => 'c_customerinfo',
            'fields' => [
                // 驳回原因
                ['name' => 'reject_reason', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
                //驳回备注
                ['name' => 'reject_remark', 'type' => 'text','default' => null, 'is_null' => true],
                //不在追踪备注
                ['name' => 'loss_remark', 'type' => 'text','default' => null, 'is_null' => true],
            ],
        ],
    ],
    '1.1.48' => [
        [
            'type' => 'column',
            'name' => 's_tracksign',
            'fields' => [
                // 是否删除：2：是，1：否
                ['name' => 'is_delete', 'type' => 'tinyint', 'length' => 1, 'default' => 1, 'is_null' => true],
            ],
        ],
    ],
    '1.1.50'=>[
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['ERP设置', 6, 'menu1522207375', '/crm/Setting/erpSet', 1, 101],
                ],
            ],
        ],
    ],
    '1.1.51' => [
        [
            // 订单来源表
            'type' => 'table',
            'name' => 's_order_source',
            'fields' => [
                ['name' => 'id', 'type' => 'int', 'length' => 11, 'default' => 'AUTO_INCREMENT', 'is_null' => false],
                // 订单来源名
                ['name' => 'source', 'type' => 'varchar', 'length' => 100, 'default' =>null, 'is_null' => true],
                ['name' => 'shop_code', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
                ['name' => 'shop_name', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
                ['name' => 'brandclass_id', 'type' => 'int', 'length' => 11, 'default' => 0, 'is_null' => false],
                ['name' => 'brandclass', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
                // 是否删除：2：是，1：否
                ['name' => 'is_delete', 'type' => 'tinyint', 'length' => 1, 'default' => 1, 'is_null' => false],
                ['type' => 'key', 'name' => 'key1', 'fields' => ['id']]
            ],
        ],
    ],
    '1.1.52'=>[
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['订单来源设定', 6, 'menu1522225258', '/crm/Setting/orderSource', 1, 102],
                ],
            ],
        ],
    ],
    '1.1.53'=>[
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['各店24小时PK表', 5, 'menu1522237395', '/crm/Statistics/ds_pk', 0, 26],
                ],
            ],
        ],
    ],
    '1.1.55'=>[
        [
            'type' => 'data',
            'name' => 'api_list',
            'fields' => [
                'field' => ['apiName', 'apiUrl', 'app_id', 'hash', 'accessToken', 'needLogin', 'status', 'method', 'info'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['删除订单', 'Customer/delOrder', 5, '5abf60677c448', 0, 0, 1, 1,'删除订单接口'],
                ],
            ],
        ],
        [
            'type' => 'data',
            'name' => 'api_fields',
            'fields' => [
                'field' => ['fieldName', 'hash','dataType', 'isMust', 'range', 'info', 'type', 'showName'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['order_sn', '5abf60677c448', 2, 1, 'erp订单单号', 'erp订单单号', 0,'order_sn'],
                    ['staff_id', '5abf60677c448', 1, 1, '当前操作人id ', '当前操作人id', 0,'staff_id'],
                    ['staff_name', '5abf60677c448', 2, 1, '当前操作人姓名', '当前操作人姓名', 0,'staff_name'],
                ],
            ],
        ],
    ],
    '1.1.57'=>[
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['右键-介绍人修改', 2, 'menu1522653972', '/crm/Customer/editIntroducer', 0, 29],
                ],
            ],
        ],
    ],
    '1.1.58'=>[
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['电商--本店各渠道数据明细', 5, 'menu1522752932', '/crm/Statistics/dayStatistics', 0, 28],
                    ['各事业部数据统计', 5, 'menu1522752970', '/crm/Statistics/week_and_month_statistics', 0, 29],
                ],
            ],
        ],
    ],
    '1.1.59'=>[
        [
            'type' => 'data',
            'name' => 'api_list',
            'fields' => [
                'field' => ['apiName', 'apiUrl', 'app_id', 'hash', 'accessToken', 'needLogin', 'status', 'method', 'info'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['获取员工的A客和毛客资数', 'Customer/getStaffAllCustomer', 5, '5acd6abcb09be', 0, 0, 1, 1,'获取员工的A客和毛客资数'],
                ],
            ],
        ],
        [
            'type' => 'data',
            'name' => 'api_fields',
            'fields' => [
                'field' => ['fieldName', 'hash','dataType', 'isMust', 'range', 'info', 'type', 'showName'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['brandclass_id', '5acd6abcb09be', 1, 0, '事业部id', '事业部id', 0,'brandclass_id'],
                    ['shop_code', '5acd6abcb09be', 2, 0, '', '', 0,'shop_code'],
                    ['department_id', '5acd6abcb09be', 1, 0, '部门id ', '部门id', 0,'department_id'],
                    ['staff_id', '5acd6abcb09be', 1, 0, '登记人id', '登记人id', 0,'staff_id'],
                    ['start', '5acd6abcb09be', 2, 0, '客资登记开始时间', '客资登记开始时间，格式是：2018-04-01 15:30:15,下面参数亦如此', 0,'start'],
                    ['end', '5acd6abcb09be', 2, 0, '客资登记结束时间', '客资登记结束时间', 0,'end'],
                ],
            ],
        ],
    ],
    '1.1.61' => [
        [
            // 客资录入接口配置表
            'type' => 'table',
            'name' => 's_customer_interface',
            'fields' => [
                ['name' => 'id', 'type' => 'int', 'length' => 11, 'default' => 'AUTO_INCREMENT', 'is_null' => false],
                // token
                ['name' => 'token', 'type' => 'varchar', 'length' => 100, 'is_null' => false],
                ['name' => 'url', 'type' => 'varchar', 'length' => 255, 'is_null' => false],
                //字段配置
                ['name' => 'field_config', 'type' => 'text', 'default' => null, 'is_null' => false],
                ['name' => 'create_time', 'type' => 'datetime', 'default' => null, 'is_null' => true],
                ['name' => 'update_time', 'type' => 'datetime', 'default' => null, 'is_null' => true],
                //创建人id
                ['name' => 'create_staff_id', 'type' => 'int', 'length' => 11, 'default' => 0, 'is_null' => true],
                ['name' => 'create_staff_name', 'type' => 'varchar', 'length' => 100, 'default' => 0, 'is_null' => true],
                //1：可用；2：禁用
                ['name' => 'status', 'type' => 'tinyint', 'length' => 1, 'default' => 1, 'is_null' => false],
                //1：删除；2：未删除
                ['name' => 'is_delete', 'type' => 'tinyint', 'length' => 1, 'default' => 2, 'is_null' => false],
                ['name' => 'shop_code', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
                ['name' => 'shop_name', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
                ['type' => 'key', 'name' => 'key1', 'fields' => ['id']]
            ],
        ],
        [
            // 客资录入详情表
            'type' => 'table',
            'name' => 's_customer_interface_detail',
            'fields' => [
                ['name' => 'id', 'type' => 'int', 'length' => 11, 'default' => 'AUTO_INCREMENT', 'is_null' => false],
                // 客资录入接口配置表id
                ['name' => 'pid', 'type' => 'int', 'length' => 11, 'default' =>0, 'is_null' => true],
                //提报参数json串
                ['name' => 'data', 'type' => 'text', 'default' => null, 'is_null' => true],
                //结果状态码，200：成功;100:字段重复；300：参数有误；400：插入出错
                ['name' => 'result_code', 'type' => 'int', 'length' => 3, 'default' => 0, 'is_null' => true],
                //失败原因
                ['name' => 'error_reason', 'type' => 'text', 'default' => null, 'is_null' => true],
                //提交人ip
                ['name' => 'ip', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
                // 提报人id
                ['name' => 'staff_id', 'type' => 'int', 'length' => 11, 'default' => 0, 'is_null' => true],
                ['name' => 'create_time', 'type' => 'datetime', 'default' => null, 'is_null' => true],
                // 修改人id
                ['name' => 'update_staff_id', 'type' => 'int', 'length' => 11, 'default' => 0, 'is_null' => true],
                //修改时间
                ['name' => 'update_time', 'type' => 'datetime', 'default' => null, 'is_null' => true],
                ['type' => 'key', 'name' => 'key1', 'fields' => ['id']],
                ],
            ],
        ],
    '1.1.63'=>[
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['第三方录入接口配置', 6, 'menu1523588039', '/crm/Setting/customerInterface', 1, 103],
                ],
            ],
        ],
    ],
    '1.1.64' => [
        [
            'type' => 'column',
            'name' => 's_channel',
            'fields' => [
                // 排序
                ['name' => 'order_sort', 'type' => 'int', 'length' => 3, 'default' => 0, 'is_null' => true],
            ],
        ],
    ],
    '1.1.65'=>[
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['本店报表设置', 5, 'menu1523775076', '', 1, 1],
                ],
            ],
        ],
    ],
    '1.1.66'=>[
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'], /*要插入的字段*/
                'value' => [ /*要插入的字段对应的数据*/
                    ['服务监控', 70, 'menu1523865883', '/server/index', 1, 1],
                ],
            ],
        ],
    ],
    '1.1.70'=>[
        [
            // crm消费类型配置表
            'type' => 'table',
            'name' => 's_consumptiontype',
            'fields' => [
                //mc消费类型id
                ['name' => 'pid', 'type' => 'int', 'length' => 11, 'is_null' => false],
                //mc消费类型
                ['name' => 'pname', 'type' => 'varchar', 'length' => 100, 'is_null' => false],
                ['name' => 'brandclass_id', 'type' => 'int', 'length' => 11, 'default' => 0, 'is_null' => true],
                ['name' => 'brandclass', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
                ['name' => 'create_time', 'type' => 'datetime', 'default' => null, 'is_null' => true],
                //添加人id
                ['name' => 'create_staff_id', 'type' => 'int', 'default' => 0, 'is_null' => true],
                //添加人
                ['name' => 'create_staff', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
                ['name' => 'update_time', 'type' => 'datetime', 'default' => null, 'is_null' => true],
                //修改人id
                ['name' => 'update_staff_id', 'type' => 'int', 'default' => 0, 'is_null' => true],
                //修改人
                ['name' => 'update_staff', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
                //1：删除；2：未删除
                ['name' => 'is_delete', 'type' => 'tinyint', 'length' => 1,'default'=>2, 'is_null' => false],
                ['name' => 'delete_time', 'type' => 'datetime', 'default' => null, 'is_null' => true],
                //删除人id
                ['name' => 'delete_staff_id', 'type' => 'int', 'default' => 0, 'is_null' => true],
                //删除人
                ['name' => 'delete_staff', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
            ],
        ],
//        [
//            'type' => 'data',
//            'name' => 's_menu',
//            'fields' => [
//                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'], /*要插入的字段*/
//                'value' => [ /*要插入的字段对应的数据*/
//                    ['消费类型设置', 6, 'menu1524130864', '/crm/Setting/consultationType', 1, 104],
//                ],
//            ],
//        ],
    ],
    '1.1.71'=>[
        [
            // 其他花费表
            'type' => 'table',
            'name' => 's_another_cost',
            'fields' => [
                ['name' => 'id', 'type' => 'int', 'length' => 11, 'default' => 'AUTO_INCREMENT', 'is_null' => false],
                //其他花费名
                ['name' => 'name', 'type' => 'varchar', 'length' => 100, 'default' =>null, 'is_null' => true],
                //花费
                ['name' => 'cost', 'type' => 'decimal', 'length' => '14,4','default' => 0, 'is_null' => true],
                //花费设定日期 区间
                ['name' => 'cost_date', 'type' => 'varchar',  'length' => 100,'default' =>null, 'is_null' => true],
                ['name' => 'create_time', 'type' => 'datetime', 'default' => null, 'is_null' => true],
                ['name' => 'update_time', 'type' => 'datetime', 'default' => null, 'is_null' => true],
                ['name' => 'shop_code', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
                ['name' => 'shop_name', 'type' => 'varchar', 'length' => 100,'default' => null, 'is_null' => true],
                ['name' => 'brandclass_id', 'type' => 'int', 'length' => 100, 'default' => 0, 'is_null' => true],
                ['name' => 'brandclass', 'type' => 'varchar','length'=>100, 'default' => null, 'is_null' => true],
                ['type' => 'key', 'name' => 'key1', 'fields' => ['id']],
            ],
            ],
        [
            // 其他花费表
            'type' => 'table',
            'name' => 's_another_cost_detail',
            'fields' => [
                ['name' => 'id', 'type' => 'int', 'length' => 11, 'default' => 'AUTO_INCREMENT', 'is_null' => false],
                ['name' => 'pid', 'type' => 'int', 'length' => 11, 'is_null' => false],
                //其他花费名
                ['name' => 'name', 'type' => 'varchar', 'length' => 100, 'default' =>null, 'is_null' => true],
                //花费平均值
                ['name' => 'cost_avg', 'type' => 'decimal', 'length' => '14,4','default' => 0, 'is_null' => true],
                //花费时间(天)
                ['name' => 'cost_date', 'type' => 'date', 'default' =>null, 'is_null' => true],
                ['name' => 'create_time', 'type' => 'datetime', 'default' => null, 'is_null' => true],
                ['name' => 'shop_code', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
                ['name' => 'shop_name', 'type' => 'varchar', 'length' => 100,'default' => null, 'is_null' => true],
                ['name' => 'brandclass_id', 'type' => 'int', 'length' => 10, 'default' => 0, 'is_null' => true],
                ['name' => 'brandclass', 'type' => 'varchar','length'=>100, 'default' => null, 'is_null' => true],
                ['type' => 'key', 'name' => 'key1', 'fields' => ['id']],
            ],
        ],
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'], /*要插入的字段*/
                'value' => [ /*要插入的字段对应的数据*/
                    ['其它花费设定', 6, 'menu1524225422', '/crm/Setting/anotherCost', 1, 105],
                ],
            ],
        ],
    ],
    '1.1.72'=>[
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'], /*要插入的字段*/
                'value' => [ /*要插入的字段对应的数据*/
                    ['今日需追踪', 34, 'menu1524450329', '', 1, 1],
                ],
            ],
        ],
    ],
    '1.1.73'=>[
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'], /*要插入的字段*/
                'value' => [ /*要插入的字段对应的数据*/
                    ['客资池', 61, 'menu1524551642', '', 1, 0],
                ],
            ],
        ],
    ],
    '1.1.74'=>[
        [
            'type' => 'table',
            'name' => 's_sta_setting',
            'fields' => [
                ['name' => 'id', 'type' => 'int', 'length' => 11, 'default' => 'AUTO_INCREMENT', 'is_null' => false],
                //店面编码
                ['name' => 'shop_code', 'type' => 'varchar', 'length' => 100, 'default' =>null, 'is_null' => true],
                //毛客资消费类型
                ['name' => 'all_customer_consumptiontype', 'type' => 'text','default' => null, 'is_null' => true],
                //有效客资消费类型
                ['name' => 'valid_customer_consumptiontype', 'type' => 'text','default' => null, 'is_null' => true],
                //进店消费类型
                ['name' => 'into_customer_consumptiontype', 'type' => 'text','default' => null, 'is_null' => true],
                //新单消费类型
                ['name' => 'order_customer_consumptiontype', 'type' => 'text','default' => null, 'is_null' => true],
                //店面类型：1：电商店；3：网销店；4：渠道店
                ['name' => 'is_marketing', 'type' => 'tinyint','length'=>3, 'default' =>3, 'is_null' => true],
                ['name' => 'create_time', 'type' => 'datetime', 'default' => null, 'is_null' => true],
                ['name' => 'update_time', 'type' => 'datetime', 'default' => null, 'is_null' => true],
                ['name' => 'brandclass_id', 'type' => 'int', 'length' => 10, 'default' => 0, 'is_null' => true],
                ['type' => 'key', 'name' => 'key1', 'fields' => ['id']],
            ],
        ],
    ],
    '1.1.75'=>[// 大屏数据沉淀表
        [
            'type' => 'table',
            'name' => 's_data_dp',
            'fields' => [
                ['name' => 'id', 'type' => 'int', 'length' => 11, 'default' => 'AUTO_INCREMENT', 'is_null' => false],
                // 日期
                ['name' => 'date', 'type' => 'varchar', 'length' => 100, 'default' =>null, 'is_null' => true],
                // 毛客资数
                ['name' => 'customer', 'type' => 'varchar', 'length' => 50, 'default' =>null, 'is_null' => true],
                // 有效客资数
                ['name' => 'valid', 'type' => 'varchar', 'length' => 50, 'default' =>null, 'is_null' => true],
                // 网销接收的客资数量
                ['name' => 'receive', 'type' => 'varchar', 'length' => 50, 'default' =>null, 'is_null' => true],
                // 进店（邀约）客资数
                ['name' => 'into', 'type' => 'varchar', 'length' => 50, 'default' =>null, 'is_null' => true],
                // 订单数量
                ['name' => 'order', 'type' => 'varchar', 'length' => 50, 'default' =>null, 'is_null' => true],
                // 营收
                ['name' => 'money', 'type' => 'varchar', 'length' => 50, 'default' =>null, 'is_null' => true],
                // shop_code
                ['name' => 'shop_code', 'type' => 'varchar', 'length' => 100, 'default' =>null, 'is_null' => true],
                // 事业部id
                ['name' => 'brandclass_id', 'type' => 'int', 'length' => 11, 'default' =>null, 'is_null' => true],
            ],
        ],
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'], /*要插入的字段*/
                'value' => [ /*要插入的字段对应的数据*/
                    ['网销综合数据分析2', 5, 'menu1521352658', '/crm/Statistics/wx_group1', 0, 20],
                ],
            ],
        ],
    ],
    '1.1.77' => [
        [
            'type' => 'column',
            'name' => 's_home_show',
            'fields' => [
                // 排序
                ['name' => 'position_code', 'type' => 'varchar', 'length' => 50, 'default' => '', 'is_null' => true],
            ],
        ],
        [
            'type' => 'column',
            'name' => 'c_staff_group_relation',
            'fields' => [
                // 排序
                ['name' => 'staff_name', 'type' => 'varchar', 'length' => 200, 'default' => '', 'is_null' => true],
            ],
        ],
    ],
    '1.1.78' => [
        [
            'type' => 'column',
            'name' => 's_kpi_staffgoal',
            'fields' => [
                // 排序
                ['name' => 'position_code', 'type' => 'varchar', 'length' => 50, 'default' => '', 'is_null' => true],
            ],
        ],
    ],
    '1.1.82'=>[
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'], /*要插入的字段*/
                'value' => [ /*要插入的字段对应的数据 (西昌报表) */
                    ['渠道日报表', 5, 'menu1525935313', '/crm/statistics/ds_channel_day_xc', 0, 30],
                    ['渠道月报表', 5, 'menu1525935348', '/crm/statistics/ds_channel_month_xc', 0, 31],
                ],
            ],
        ],
    ],
    '1.1.85'=>[// 分配日志表
        [
            'type' => 'table',
            'name' => 'l_fp_logs',
            'fields' => [
                ['name' => 'id', 'type' => 'int', 'length' => 11, 'default' => 'AUTO_INCREMENT', 'is_null' => false],
                // 客资id
                ['name' => 'cid', 'type' => 'int', 'length' => 11, 'default' =>null, 'is_null' => true],
                // 导入id
                ['name' => 'eid', 'type' => 'int', 'length' => 11, 'default' =>null, 'is_null' => true],
                // 分配方式(1：自动分配；2：手动分配；3：录入指定；4：话务录入）
                ['name' => 'fp_model', 'type' => 'tinyint', 'length' => 4, 'default' =>null, 'is_null' => true],
                // 分配状态（1：已分配；2：未分配；3：待接收；4：分配失败；5：放弃）
                ['name' => 'fp_status', 'type' => 'varchar', 'length' => 50, 'default' =>null, 'is_null' => true],
                // 分配时间
                ['name' => 'fp_time', 'type' => 'datetime', 'default' =>null, 'is_null' => true],
                // 分配人id
                ['name' => 'fp_staff_id', 'type' => 'int', 'length' => 11, 'default' =>null, 'is_null' => true],
                // 分配人姓名
                ['name' => 'fp_staff_name', 'type' => 'varchar', 'length' => 100, 'default' =>null, 'is_null' => true],
                // 分配shop_code
                ['name' => 'fp_shop_code', 'type' => 'varchar', 'length' => 100, 'default' =>null, 'is_null' => true],
                // 分配shop_name
                ['name' => 'fp_shop_name', 'type' => 'varchar', 'length' => 100, 'default' =>null, 'is_null' => true],
                // 接入时间 / 放弃时间
                ['name' => 'jr_time', 'type' => 'datetime', 'default' =>null, 'is_null' => true],
                // 接入人id
                ['name' => 'jr_staff_id', 'type' => 'int', 'length' => 11, 'default' =>null, 'is_null' => true],
                // 接入人姓名
                ['name' => 'jr_staff_name', 'type' => 'varchar', 'length' => 100, 'default' =>null, 'is_null' => true],
                // 接入shop_code
                ['name' => 'jr_shop_code', 'type' => 'varchar', 'length' => 100, 'default' =>null, 'is_null' => true],
                // 接入shop_name
                ['name' => 'jr_shop_name', 'type' => 'varchar', 'length' => 100, 'default' =>null, 'is_null' => true],
                // 事业部id
                ['name' => 'brandclass_id', 'type' => 'int', 'length' => 11, 'default' =>null, 'is_null' => true],
            ],
        ],
    ],
    '1.1.86'=>[// 分配日志表 字段错了
        [
            'type' => 'column',
            'name' => 'l_fp_logs',
            'fields' => [
                // 分配人所在事业部id
                ['name' => 'fp_brandclass_id', 'type' => 'int', 'length' => 11, 'default' => 0, 'is_null' => true],
            ],
        ],
    ],
    '1.1.87'=>[// 花费导入表
        [
            'type' => 'table',
            'name' => 'c_excel_cost_import',
            'fields' => [
                ['name' => 'id', 'type' => 'int', 'length' => 11, 'default' => 'AUTO_INCREMENT', 'is_null' => false],
                // 文件名
                ['name' => 'file_name', 'type' => 'varchar', 'length' => 255, 'default' =>null, 'is_null' => true],
                // 文件地址
                ['name' => 'file_url', 'type' => 'varchar', 'length' => 255, 'default' =>null, 'is_null' => true],
                // 错误文件地址
                ['name' => 'fail_file_url', 'type' => 'varchar', 'length' => 255, 'default' =>null, 'is_null' => true],
                //操作人id
                ['name' => 'staff_id', 'type' => 'int', 'length' => 11, 'default' =>null, 'is_null' => true],
                ['name' => 'staff_name', 'type' => 'varchar', 'length' => 100, 'default' =>null, 'is_null' => true],
                ['name' => 'add_time', 'type' => 'datetime', 'default' =>null, 'is_null' => true],
                // 导入状态，0未导入，1已导入，2正在导入，默认为0
                ['name' => 'status', 'type' => 'varchar', 'length' => 50, 'default' =>0, 'is_null' => true],
                // 数据总条数
                ['name' => 'all_number', 'type' => 'int', 'length' => 11, 'default' =>0, 'is_null' => true],
                // 导入成功条数
                ['name' => 'import_number', 'type' => 'int', 'length' => 11, 'default' =>0, 'is_null' => true],
                // 导入失败数据条数
                ['name' => 'fail_number', 'type' => 'int', 'length' => 11, 'default' =>0, 'is_null' => true],
                ['name' => 'shop_code', 'type' => 'varchar', 'length' => 100, 'default' =>null, 'is_null' => true],
                ['name' => 'shop_name', 'type' => 'varchar', 'length' => 100, 'default' =>null, 'is_null' => true],
                // 事业部id
                ['name' => 'brandclass_id', 'type' => 'int', 'length' => 11, 'default' =>null, 'is_null' => true],
                ['name' => 'brandclass', 'type' => 'varchar', 'length' => 255, 'default' =>null, 'is_null' => true],
                ['name' => 'import_fail', 'type' => 'varchar', 'length' => 255, 'default' =>null, 'is_null' => true],
            ],
        ],
        [
            //渠道花费表增加eid
            'type' => 'column',
            'name' => 's_channel_cost',
            'fields' => [
                // 分配人所在事业部id
                ['name' => 'eid', 'type' => 'int', 'length' => 11, 'default' => 0, 'is_null' => true],
            ],
        ],
    ],
    '1.1.88'=>[// 报表设置表
        [
            'type' => 'table',
            'name' => 's_report_form',
            'fields' => [
                ['name' => 'id', 'type' => 'int', 'length' => 11, 'default' => 'AUTO_INCREMENT', 'is_null' => false],
                // 报表名(类名)
                ['name' => 'report_class_name', 'type' => 'varchar', 'length' => 255, 'default' =>null, 'is_null' => true],
                // 报表显示名(中文)
                ['name' => 'report_name', 'type' => 'varchar', 'length' => 255, 'default' =>null, 'is_null' => true],
                // 报表地址
                ['name' => 'report_url', 'type' => 'varchar', 'length' => 255, 'default' =>null, 'is_null' => true],
                //报表级别 1:集团;2:事业部;3,4:员工
                ['name' => 'level', 'type' => 'int', 'length' => 11, 'default' =>0, 'is_null' => true],
                //报表类别 1:电商店;3:网销店;4:渠道/深挖店
                ['name' => 'report_type', 'type' => 'tinyint', 'length' => 1, 'default' =>1, 'is_null' => true],
                ['name' => 'code', 'type' => 'varchar', 'length' => 100, 'default' =>null, 'is_null' => true],
                //是否使用 1:使用;2:禁用
                ['name' => 'status', 'type' => 'tinyint', 'length' => 1, 'default' =>1, 'is_null' => true],
                ['name' => 'add_time', 'type' => 'datetime', 'default' =>null, 'is_null' => true],
            ],
        ],
    ],
    '1.1.90' => [
        [
            'type' => 'column',
            'name' => 'c_customerinfo',
            'fields' => [
                // 客资更新时间及删除时间
                ['name' => 'update_time', 'type' => 'datetime', 'default' => null, 'is_null' => true],
                ['name' => 'del_time', 'type' => 'datetime', 'default' => null, 'is_null' => true],
            ],
        ],
        [
            'type' => 'column',
            'name' => 's_sta_setting',
            'fields' => [
                // A客id
                ['name' => 'aid', 'type' => 'int', 'length' => 4, 'default' => 0, 'is_null' => true],
            ],
        ],
    ],
    '1.1.91' => [
        [
            'type' => 'column',
            'name' => 'c_customerinfo',
            'fields' => [
                // 标记无效原因id
                ['name' => 'unvalid_id', 'type' => 'int', 'length' => 11, 'default' => 0, 'is_null' => true],
                // 标记无效原因
                ['name' => 'unvalid_reason', 'type' => 'varchar', 'length' => 200, 'default' =>null, 'is_null' => true],
            ],
        ],
    ],
    '1.1.92' => [
        [
            'type' => 'column',
            'name' => 's_allocation_rule',
            'fields' => [
                // 人员id
                ['name' => 'staff_id', 'type' => 'varchar', 'length' => 255, 'default' => null, 'is_null' => true],
                // 人员名
                ['name' => 'staff_name', 'type' => 'varchar', 'length' => 255, 'default' =>null, 'is_null' => true],
            ],
        ],
    ],
    '1.1.93' => [
        [
            'type' => 'column',
            'name' => 's_allocation_rule',
            'fields' => [
                // 人员标识
                ['name' => 'staff_type', 'type' => 'varchar', 'length' => 50, 'default' => null, 'is_null' => true],
                // 人员值
                ['name' => 'staff_value', 'type' => 'text', 'default' =>null, 'is_null' => true],
            ],
        ],
    ],
    '1.1.94' => [
        [
            'type' => 'data',
            'name' => 'api_list',
            'fields' => [
                'field' => ['apiName', 'apiUrl', 'app_id', 'hash', 'accessToken', 'needLogin', 'status', 'method', 'info'],
                'value' => [ /*要插入的字段对应的数据*/
                    [' 客资列表', 'Customer/getCustomerList', 5, '5b1a178493b48', 0, 0, 1, 1,'获取客资列表'],
                    [' 获取客资详情', 'Customer/getCustomerInfo', 5, '5b1a18f6249f0', 0, 0, 1, 1,''],
                    [' 获取客资追踪记录', 'Customer/getSalesLog', 5, '5b1a1f8ebd740', 0, 0, 1, 1,''],
                ],
            ],
        ],
        [
            'type' => 'data',
            'name' => 'api_fields',
            'fields' => [
                'field' => ['fieldName', 'hash','dataType', 'isMust', 'range', 'info', 'type', 'showName'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['search', '5b1a178493b48', 2, 0, '', '模糊查询,可查询到匹配的联系方式,姓名,编号,单号', 0,'search'],
                    ['start', '5b1a178493b48', 2, 0, '', '录入开始时间,不传默认当天', 0,'start'],
                    ['end', '5b1a178493b48', 2, 0, '', '录入结束时间,不传默认当天', 0,'end'],
                    ['customer_number', '5b1a18f6249f0', 2, 1, ' ', '客资编号', 0,'customer_number'],
                    ['customer_number', '5b1a1f8ebd740', 2, 2, '', '客资编号', 0,'customer_number'],
                ],
            ],
        ],
    ],
    '1.1.98' => [
        [
            'type'=> 'sql',
            'sql' => "alter table c_customerinfo modify column fact_money DECIMAL (11,4)",
        ],
        [
            'type'=> 'sql',
            'sql' => "alter table c_customerinfo modify column totalpay_money DECIMAL (11,4)",
        ],
        [
            'type'=> 'sql',
            'sql' => "alter table s_position_menu modify column menu_code text",
        ],
        [
        'type' => 'column',
            'name' => 'c_customerinfo',
            'fields' => [
                // erp标记流失状态（1：未流失；2：已流失）默认1
                ['name' => 'erp_loss', 'type' => 'tinyint', 'length' => 2, 'default' => 1],
                // erp标记流失原因
                ['name' => 'erp_loss_reason', 'type' => 'text', 'default' => null, 'is_null' => true],
                // erp标记流失时间
                ['name' => 'erp_loss_time', 'type' => 'datetime', 'default' => null, 'is_null' => true],
            ],
        ],
    ],
    '1.1.99' => [
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['id','menu_name', 'fid', 'menu_code', 'menu_url','menu_icon', 'status', 'sort'], /*要插入的字段*/
                'value' => [ /*要插入的字段对应的数据*/
                    [8,'花费录入', 0, 'menu1529995000', '#','fa-money', 1, 6],
                ],
            ],
        ],
        [
            'type' => 'column',
            'name' => 's_home_show',
            'fields' => [
                // 设置的时间段  值为:本周,上周,本月,上月,今日,昨日
                ['name' => 'time', 'type' => 'varchar','length'=>200, 'default' =>null],
            ],
        ],
        [
            'type'=> 'sql',
            'sql' => "UPDATE s_menu set fid=8,menu_name='渠道花费' where menu_code='menu1512650793'",
        ],
        [
            'type'=> 'sql',
            'sql' => "UPDATE s_menu set fid=8,menu_name='花费返点' where menu_code='menu1513343947'",
        ],
        [
            'type'=> 'sql',
            'sql' => "UPDATE s_menu set fid=8,status=0,menu_name='返点规则' where menu_code='menu1521280345'",
        ],
        [
            'type'=> 'sql',
            'sql' => "UPDATE s_menu set fid=8,menu_name='其它花费' where menu_code='menu1524225422'",
        ],
        [
            'type'=> 'sql',
            'sql' => "UPDATE s_menu set fid=8,menu_name='获取成本' where menu_code='menu1513855331'",
        ],
    ],
    '1.1.100' => [
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'], /*要插入的字段*/
                'value' => [ /*要插入的字段对应的数据*/
                    ['查看小组客资', 61, 'menu1529653231', '', 0, 10],
                ],
            ],
        ],
    ],
    '1.1.101' => [
        [
            'type' => 'column',
            'name' => 'c_customerinfo',
            'fields' => [
                // 登记部门id
                ['name' => 'dj_department_id', 'type' => 'int', 'length' => 11, 'default' => null, 'is_null' => true],
                // 追踪部门id
                ['name' => 'sales_department_id', 'type' => 'int','length' => 11, 'default' =>null, 'is_null' => true],
            ],
        ],
    ],
    '1.1.102' => [
        [
            'type' => 'sql',
            'sql' => "UPDATE s_menu set status=0 where menu_code='menu1513855331'",
        ],
    ],
    '1.1.103' => [
        [
            'type' => 'column',
            'name' => 'c_customerinfo',
            'fields' => [
                // 审核状态:1:已通过;2:待审核;3:审核未通过
                ['name' => 'is_examine', 'type' => 'tinyint', 'length' => 4, 'default' => 1, 'is_null' => true],
                // 审核不通过原因
                ['name' => 'examine_reason', 'type' => 'text', 'default' =>null, 'is_null' => true],
            ],
        ],
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'], /*要插入的字段*/
                'value' => [ /*要插入的字段对应的数据*/
                    ['回收站', 61, 'menu1529995330', '/crm/Customer/customerBack', 0, 9],
                ],
            ],
        ],
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'], /*要插入的字段*/
                'value' => [ /*要插入的字段对应的数据*/
                    ['客资审核', 61, 'menu1531379209', '/crm/Customer/customerExamine', 0, 10],
                ],
            ],
        ],
    ],
    '1.1.104' => [
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'], /*要插入的字段*/
                'value' => [ /*要插入的字段对应的数据*/
                    ['查看部门客资', 61, 'menu1531471639', '', 0, 11],
                ],
            ],
        ],
    ],
    '1.1.105' => [
        [ /*第二个改动*/
            'type' => 'column',
            'name' => 's_kpi_staffgoal',
            'fields' => [
                //设定天数
                ['name' => 'day_number', 'type' => 'int', 'length' => 11, 'default' => null, 'is_null' => true],
                //每天平均值
                ['name' => 'avg_value', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
            ],
        ],
    ],
    '1.1.106' => [
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'], /*要插入的字段*/
                'value' => [ /*要插入的字段对应的数据*/
                    ['客资转移', 61, 'menu1532333135', '', 0, 11],
                ],
            ],
        ],
    ],
    '1.1.107' => [
        [
            'type' => 'column',
            'name' => 'c_customerinfo',
            'fields' => [
                // 儿童版字段 宝宝姓名 
                ['name' => 'baby_name', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
                // 儿童版字段 宝宝性别 
                ['name' => 'baby_sex', 'type' => 'varchar', 'length' => 10, 'default' => null, 'is_null' => true],
                // 座机
                ['name' => 'home_phone', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
                // email
                ['name' => 'email', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
            ],
        ],
    ],
    // 儿童erp接口
    '1.1.108' => [
        [
            'type' => 'data',
            'name' => 'api_app',
            'fields' => [
                'field' => ['id','app_id', 'app_secret', 'app_name', 'app_status', 'app_type', 'app_info'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['6','05194764', 'oUWKYeqCEojOvbmsynvWTctJSAVeoMZv', '儿童erp接口', 1, 1,'儿童erp调用crm接口'],
                ],
            ],
        ],
        [
            'type' => 'data',
            'name' => 'api_list',
            'fields' => [
                'field' => ['apiName', 'apiUrl', 'app_id', 'hash', 'accessToken', 'needLogin', 'status', 'method', 'info'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['查询客资信息', 'Child/getCustomerInfomation', 6, '5b3b60b24ada9', 0, 0, 1, 1,'根据手机号获取客资信息，用于erp自动填充信息'],
                    ['进客登记', 'Child/createCustomer', 6, '5b3b61169ed69', 0, 0, 1, 1,'erp进客登记用'],
                    ['修改客资状态', 'Child/changeCustomerStatus', 6, '5b3b63334a9c1', 0, 0, 1, 1,'标记客资进店，流失'],
                    ['编辑客资信息', 'Child/erpEditCustomer', 6, '5b3b63ad39081', 0, 0, 1, 1,'根据客资编号，编辑客资信息'],
                    ['创建订单', 'Child/createOrder', 6, '5b3b640593da1', 0, 0, 1, 1,'右键转订单（客资编号），直接开单'],
                    ['添加消费项目', 'Child/addOrderTotal', 6, '5b3b645687669', 0, 0, 1, 1,'根据订单编号，添加消费项目，套系总额'],
                    ['收款接口', 'Child/cashMoney', 6, '5b3b64b260d39', 0, 0, 1, 1,'根据订单编号，收款'],
                    ['删除订单', 'Child/delOrder', 6, '5b3b64f2b9f01', 0, 0, 1, 1,'根据订单编号，删除订单（物理删除）'],
                    ['开单/加套系/收款', 'Child/receivables', 6, '5b3b6722b9f01', 0, 0, 1, 1,'开单/加套系/收款'],
                ],
            ],
        ],
        [
            'type' => 'data',
            'name' => 'api_fields',
            'fields' => [
                'field' => ['fieldName', 'hash','dataType', 'isMust', 'range', 'info', 'showName'],
                'value' => [
                    // 查询客资信息  Child/getCustomerInfomation
                    ['customer_number', '5b3b60b24ada9', 2, 0, '客资编号', '客资编号', 'customer_number'],
                    ['brandclass_id', '5b3b60b24ada9', 1, 0, '事业部ID', '事业部ID', 'brandclass_id'],
                    ['brandclass', '5b3b60b24ada9', 2, 0, '事业部', '事业部', 'brandclass'],
                    ['contact_type', '5b3b60b24ada9', 1, 0, '联系方式类型(1：手机；2：微信；3：qq)', '联系方式类型(1：手机；2：微信；3：qq)', 'contact_type'],
                    ['contact_w', '5b3b60b24ada9', 2, 0, '联系方式_母亲', '联系方式_母亲', 'contact_w'],
                    ['contact_m', '5b3b60b24ada9', 2, 0, '联系方式_父亲', '联系方式_父亲', 'contact_m'],
                    
                    // 进客登记  Child/createCustomer
                    ['customer_number', '5b3b61169ed69', 2, 0, '客资编号', '客资编号', 'customer_number'],
                    ['brandclass_id', '5b3b61169ed69', 1, 1, '事业部ID', '事业部ID', 'brandclass_id'],
                    ['brandclass', '5b3b61169ed69', 2, 1, '事业部', '事业部', 'brandclass'],
                    ['shop_code', '5b3b61169ed69', 2, 1, '操作店code','操作店code','shop_code'],
                    ['shop_name', '5b3b61169ed69', 2, 1, '操作店名','操作店名','shop_name'],
                    ['staff_id', '5b3b61169ed69', 1, 1, '操作人id', '操作人id', 'staff_id'],
                    ['staff_name', '5b3b61169ed69', 2, 1, '操作人', '操作人', 'staff_name'],
                    ['baby_name', '5b3b61169ed69', 2, 0, '宝宝姓名', '宝宝姓名', 'baby_name'],
                    ['baby_sex', '5b3b61169ed69', 2, 0, '宝宝性别', '宝宝性别', 'baby_sex'],
                    ['baby_birthday', '5b3b61169ed69', 2, 0, '宝宝生日', '宝宝生日', 'baby_birthday'],
                    ['baby_address', '5b3b61169ed69', 2, 0, '宝宝出生地(医院)', '宝宝出生地(医院)', 'baby_address'],
                    ['customer_name', '5b3b61169ed69', 2, 0, '母亲姓名', '母亲姓名', 'customer_name'],
                    ['customer_tel', '5b3b61169ed69', 2, 0, '母亲手机', '母亲手机', 'customer_tel'],
                    ['customer_wechat', '5b3b61169ed69', 2, 0, '母亲微信', '母亲微信', 'customer_wechat'],
                    ['customer_qq', '5b3b61169ed69', 2, 0, '母亲QQ', '母亲QQ', 'customer_qq'],
                    ['customer_birthday', '5b3b61169ed69', 2, 0, '母亲生日', '母亲生日', 'customer_birthday'],
                    ['mate_name', '5b3b61169ed69', 2, 0, '父亲姓名', '父亲姓名', 'mate_name'],
                    ['mate_tel', '5b3b61169ed69', 2, 0, '父亲手机', '父亲手机', 'mate_tel'],
                    ['mate_wechat', '5b3b61169ed69', 2, 0, '父亲微信', '父亲微信', 'mate_wechat'],
                    ['mate_qq', '5b3b61169ed69', 2, 0, '父亲QQ', '父亲QQ', 'mate_qq'],
                    ['mate_birthday', '5b3b61169ed69', 2, 0, '父亲生日', '父亲生日', 'mate_birthday'],
                    ['ready_baby_day', '5b3b61169ed69', 2, 0, '预产期', '预产期', 'ready_baby_day'],
                    ['marry_day', '5b3b61169ed69', 2, 0, '结婚日期', '结婚日期', 'marry_day'],
                    ['yp_day', '5b3b61169ed69', 2, 0, '预拍日期', '预拍日期', 'yp_day'],
                    ['consultation_type_id', '5b3b61169ed69', 1, 0, '消费类型id', '消费类型id', 'consultation_type_id'],
                    ['consultation_type', '5b3b61169ed69', 2, 0, '消费类型', '消费类型', 'consultation_type'],
                    ['customer_area_id', '5b3b61169ed69', 1, 0, '客户分区id', '客户分区id', 'customer_area_id'],
                    ['customer_area', '5b3b61169ed69', 2, 0, '客户分区', '客户分区', 'customer_area'],
                    ['customer_cource_id', '5b3b61169ed69', 1, 0, '客户来源id', '客户来源id', 'customer_cource_id'],
                    ['customer_cource', '5b3b61169ed69', 2, 0, '客户来源', '客户来源', 'customer_cource'],
                    ['customer_intention_id', '5b3b61169ed69', 1, 0, '客户意向id', '客户意向id', 'customer_intention_id'],
                    ['customer_intention', '5b3b61169ed69', 2, 0, '客户意向', '客户意向', 'customer_intention'],
                    ['customer_orderaddress', '5b3b61169ed69', 1, 0, '接单点_id', '接单点_id', 'customer_orderaddress_id'],
                    ['customer_orderaddress_id', '5b3b61169ed69', 2, 0, '接单点', '接单点', 'customer_orderaddress'],
                    ['province', '5b3b61169ed69', 2, 0, '省', '省', 'province'],
                    ['city', '5b3b61169ed69', 2, 0, '市', '市', 'city'],
                    ['county', '5b3b61169ed69', 2, 0, '区/县', '区/县', 'county'],
                    ['home_phone', '5b3b61169ed69', 2, 0, '座机', '座机', 'home_phone'],
                    ['email', '5b3b61169ed69', 2, 0, '邮箱', '邮箱', 'email'],
                    ['customer_address', '5b3b61169ed69', 2, 0, '客户地址', '客户地址', 'customer_address'],
                    ['customer_remark', '5b3b61169ed69', 2, 0, '客户备注', '客户备注', 'customer_remark'],
                    
                    // 修改客资状态  Child/changeCustomerStatus
                    ['customer_number', '5b3b63334a9c1', 2, 1, '客资编号', '客资编号', 'customer_number'],
                    ['staff_id', '5b3b63334a9c1', 1, 1, '操作人id', '操作人id', 'staff_id'],
                    ['staff_name', '5b3b63334a9c1', 2, 1, '操作人', '操作人', 'staff_name'],
                    ['code', '5b3b63334a9c1', 1, 1, '1:进店进客；2：进店非进客；3：未进店；4：流失', '1:进店进客；2：进店非进客；3：未进店；4：流失', 'code'],
                    ['lose_reason', '5b3b63334a9c1', 2, 0, '流失原因', '流失原因', 'lose_reason'],
                    ['create_time', '5b3b63334a9c1', 2, 1, '流失/进店时间', '流失/进店时间', 'create_time'],
                    
                    // 编辑客资信息  Child/erpEditCustomer
                    ['customer_number', '5b3b63ad39081', 2, 0, '客资编号', '客资编号', 'customer_number'],
                    ['staff_id', '5b3b63ad39081', 1, 1, '操作人id', '操作人id', 'staff_id'],
                    ['staff_name', '5b3b63ad39081', 2, 1, '操作人', '操作人', 'staff_name'],
                    ['baby_name', '5b3b63ad39081', 2, 0, '宝宝姓名', '宝宝姓名', 'baby_name'],
                    ['baby_sex', '5b3b63ad39081', 2, 0, '宝宝性别', '宝宝性别', 'baby_sex'],
                    ['baby_birthday', '5b3b63ad39081', 2, 0, '宝宝生日', '宝宝生日', 'baby_birthday'],
                    ['baby_address', '5b3b63ad39081', 2, 0, '宝宝出生地(医院)', '宝宝出生地(医院)', 'baby_address'],
                    ['customer_name', '5b3b63ad39081', 2, 0, '母亲姓名', '母亲姓名', 'customer_name'],
                    ['customer_tel', '5b3b63ad39081', 2, 0, '母亲手机', '母亲手机', 'customer_tel'],
                    ['customer_wechat', '5b3b63ad39081', 2, 0, '母亲微信', '母亲微信', 'customer_wechat'],
                    ['customer_qq', '5b3b63ad39081', 2, 0, '母亲QQ', '母亲QQ', 'customer_qq'],
                    ['customer_birthday', '5b3b63ad39081', 2, 0, '母亲生日', '母亲生日', 'customer_birthday'],
                    ['mate_name', '5b3b63ad39081', 2, 0, '父亲姓名', '父亲姓名', 'mate_name'],
                    ['mate_tel', '5b3b63ad39081', 2, 0, '父亲手机', '父亲手机', 'mate_tel'],
                    ['mate_wechat', '5b3b63ad39081', 2, 0, '父亲微信', '父亲微信', 'mate_wechat'],
                    ['mate_qq', '5b3b63ad39081', 2, 0, '父亲QQ', '父亲QQ', 'mate_qq'],
                    ['mate_birthday', '5b3b63ad39081', 2, 0, '父亲生日', '父亲生日', 'mate_birthday'],
                    ['ready_baby_day', '5b3b63ad39081', 2, 0, '预产期', '预产期', 'ready_baby_day'],
                    ['marry_day', '5b3b63ad39081', 2, 0, '结婚日期', '结婚日期', 'marry_day'],
                    ['yp_day', '5b3b63ad39081', 2, 0, '预拍日期', '预拍日期', 'yp_day'],
                    ['consultation_type_id', '5b3b63ad39081', 1, 0, '消费类型id', '消费类型id', 'consultation_type_id'],
                    ['consultation_type', '5b3b63ad39081', 2, 0, '消费类型', '消费类型', 'consultation_type'],
                    ['customer_area_id', '5b3b63ad39081', 1, 0, '客户分区id', '客户分区id', 'customer_area_id'],
                    ['customer_area', '5b3b63ad39081', 2, 0, '客户分区', '客户分区', 'customer_area'],
                    ['customer_cource_id', '5b3b63ad39081', 1, 0, '客户来源id', '客户来源id', 'customer_cource_id'],
                    ['customer_cource', '5b3b63ad39081', 2, 0, '客户来源', '客户来源', 'customer_cource'],
                    ['customer_intention_id', '5b3b63ad39081', 1, 0, '客户意向id', '客户意向id', 'customer_intention_id'],
                    ['customer_intention', '5b3b63ad39081', 2, 0, '客户意向', '客户意向', 'customer_intention'],
                    ['customer_orderaddress', '5b3b63ad39081', 1, 0, '接单点_id', '接单点_id', 'customer_orderaddress_id'],
                    ['customer_orderaddress_id', '5b3b63ad39081', 2, 0, '接单点', '接单点', 'customer_orderaddress'],
                    ['province', '5b3b63ad39081', 2, 0, '省', '省', 'province'],
                    ['city', '5b3b63ad39081', 2, 0, '市', '市', 'city'],
                    ['county', '5b3b63ad39081', 2, 0, '区/县', '区/县', 'county'],
                    ['home_phone', '5b3b63ad39081', 2, 0, '座机', '座机', 'home_phone'],
                    ['email', '5b3b63ad39081', 2, 0, '邮箱', '邮箱', 'email'],
                    ['customer_address', '5b3b63ad39081', 2, 0, '客户地址', '客户地址', 'customer_address'],
                    ['customer_remark', '5b3b63ad39081', 2, 0, '客户备注', '客户备注', 'customer_remark'],

                    // 创建订单  Child/createOrder
                    ['order_sn', '5b3b640593da1', 2, 1, '订单编号', '订单编号', 'order_sn'],
                    ['brandclass_id', '5b3b640593da1', 1, 1, '事业部ID', '事业部ID', 'brandclass_id'],
                    ['brandclass', '5b3b640593da1', 2, 1, '事业部', '事业部', 'brandclass'],
                    ['shop_code', '5b3b640593da1', 2, 1, '操作店code','操作店code','shop_code'],
                    ['shop_name', '5b3b640593da1', 2, 1, '操作店名','操作店名','shop_name'],
                    ['staff_id', '5b3b640593da1', 1, 1, '操作人id', '操作人id', 'staff_id'],
                    ['staff_name', '5b3b640593da1', 2, 1, '操作人', '操作人', 'staff_name'],
                    ['baby_name', '5b3b640593da1', 2, 0, '宝宝姓名', '宝宝姓名', 'baby_name'],
                    ['baby_sex', '5b3b640593da1', 2, 0, '宝宝性别', '宝宝性别', 'baby_sex'],
                    ['baby_birthday', '5b3b640593da1', 2, 0, '宝宝生日', '宝宝生日', 'baby_birthday'],
                    ['baby_address', '5b3b640593da1', 2, 0, '宝宝出生地(医院)', '宝宝出生地(医院)', 'baby_address'],
                    ['customer_name', '5b3b640593da1', 2, 0, '母亲姓名', '母亲姓名', 'customer_name'],
                    ['customer_tel', '5b3b640593da1', 2, 0, '母亲手机', '母亲手机', 'customer_tel'],
                    ['customer_wechat', '5b3b640593da1', 2, 0, '母亲微信', '母亲微信', 'customer_wechat'],
                    ['customer_qq', '5b3b640593da1', 2, 0, '母亲QQ', '母亲QQ', 'customer_qq'],
                    ['customer_birthday', '5b3b640593da1', 2, 0, '母亲生日', '母亲生日', 'customer_birthday'],
                    ['mate_name', '5b3b640593da1', 2, 0, '父亲姓名', '父亲姓名', 'mate_name'],
                    ['mate_tel', '5b3b640593da1', 2, 0, '父亲手机', '父亲手机', 'mate_tel'],
                    ['mate_wechat', '5b3b640593da1', 2, 0, '父亲微信', '父亲微信', 'mate_wechat'],
                    ['mate_qq', '5b3b640593da1', 2, 0, '父亲QQ', '父亲QQ', 'mate_qq'],
                    ['mate_birthday', '5b3b640593da1', 2, 0, '父亲生日', '父亲生日', 'mate_birthday'],
                    ['ready_baby_day', '5b3b640593da1', 2, 0, '预产期', '预产期', 'ready_baby_day'],
                    ['marry_day', '5b3b640593da1', 2, 0, '结婚日期', '结婚日期', 'marry_day'],
                    ['yp_day', '5b3b640593da1', 2, 0, '预拍日期', '预拍日期', 'yp_day'],
                    ['consultation_type_id', '5b3b640593da1', 1, 0, '消费类型id', '消费类型id', 'consultation_type_id'],
                    ['consultation_type', '5b3b640593da1', 2, 0, '消费类型', '消费类型', 'consultation_type'],
                    ['customer_area_id', '5b3b640593da1', 1, 0, '客户分区id', '客户分区id', 'customer_area_id'],
                    ['customer_area', '5b3b640593da1', 2, 0, '客户分区', '客户分区', 'customer_area'],
                    ['customer_cource_id', '5b3b640593da1', 1, 0, '客户来源id', '客户来源id', 'customer_cource_id'],
                    ['customer_cource', '5b3b640593da1', 2, 0, '客户来源', '客户来源', 'customer_cource'],
                    ['customer_intention_id', '5b3b640593da1', 1, 0, '客户意向id', '客户意向id', 'customer_intention_id'],
                    ['customer_intention', '5b3b640593da1', 2, 0, '客户意向', '客户意向', 'customer_intention'],
                    ['customer_orderaddress', '5b3b640593da1', 1, 0, '接单点_id', '接单点_id', 'customer_orderaddress_id'],
                    ['customer_orderaddress_id', '5b3b640593da1', 2, 0, '接单点', '接单点', 'customer_orderaddress'],
                    ['province', '5b3b640593da1', 2, 0, '省', '省', 'province'],
                    ['city', '5b3b640593da1', 2, 0, '市', '市', 'city'],
                    ['county', '5b3b640593da1', 2, 0, '区/县', '区/县', 'county'],
                    ['home_phone', '5b3b640593da1', 2, 0, '座机', '座机', 'home_phone'],
                    ['email', '5b3b640593da1', 2, 0, '邮箱', '邮箱', 'email'],
                    ['customer_address', '5b3b640593da1', 2, 0, '客户地址', '客户地址', 'customer_address'],
                    ['customer_remark', '5b3b640593da1', 2, 0, '客户备注', '客户备注', 'customer_remark'],

                    // 添加消费项目  Child/addOrderTotal
                    ['order_sn', '5b3b645687669', 2, 1, '订单编号', '订单编号', 'order_sn'],
                    ['brandclass_id', '5b3b645687669', 1, 1, '事业部ID', '事业部ID', 'brandclass_id'],
                    ['brandclass', '5b3b645687669', 2, 1, '事业部', '事业部', 'brandclass'],
                    ['shop_code', '5b3b645687669', 2, 1, '操作店code','操作店code','shop_code'],
                    ['shop_name', '5b3b645687669', 2, 1, '操作店名','操作店名','shop_name'],
                    ['staff_id', '5b3b645687669', 1, 1, '操作人id', '操作人id', 'staff_id'],
                    ['staff_name', '5b3b645687669', 2, 1, '操作人', '操作人', 'staff_name'],
                    ['order_amount', '5b3b645687669', 2, 1, '一销套系总额', '一销套系总额', 'order_amount'],
                    ['two_pin_amount', '5b3b645687669', 2, 1, '二销套系总额', '二销套系总额', 'two_pin_amount'],
                    
                    // 收款接口  Child/cashMoney
                    ['order_sn', '5b3b64b260d39', 2, 1, '订单编号', '订单编号', 'order_sn'],
                    ['brandclass_id', '5b3b64b260d39', 1, 1, '事业部ID', '事业部ID', 'brandclass_id'],
                    ['brandclass', '5b3b64b260d39', 2, 1, '事业部', '事业部', 'brandclass'],
                    ['shop_code', '5b3b64b260d39', 2, 1, '操作店code','操作店code','shop_code'],
                    ['shop_name', '5b3b64b260d39', 2, 1, '操作店名','操作店名','shop_name'],
                    ['staff_id', '5b3b64b260d39', 1, 1, '操作人id', '操作人id', 'staff_id'],
                    ['staff_name', '5b3b64b260d39', 2, 1, '操作人', '操作人', 'staff_name'],
                    ['order_fact', '5b3b64b260d39', 1, 1, '一销收款金额', '一销收款金额', 'order_fact'],
                    ['two_pin_fact', '5b3b64b260d39', 2, 1, '二销收款金额', '二销收款金额', 'two_pin_fact'],
                    
                    // 删除订单  Child/delOrder 
                    ['order_sn', '5b3b64f2b9f01', 2, 1, '订单编号', '订单编号', 'order_sn'],
                    ['staff_id', '5b3b64f2b9f01', 1, 1, '操作人id', '操作人id', 'staff_id'],
                    ['staff_name', '5b3b64f2b9f01', 2, 1, '操作人', '操作人', 'staff_name'],

                    // 开单/加套系/收款  Child/receivables
                    ['diff', '5b3b6722b9f01', 1, 1, '用于区分是转订单（1）添加消费产品(2)还是收款(3)', '用于区分是转订单（1）添加消费产品(2)还是收款(3)', 'diff'],
                    ['create_time', '5b3b6722b9f01', 2, 0, '订单创建时间', '订单创建时间', 'create_time'],
                    ['customer_number', '5b3b6722b9f01', 2, 1, '客资编号', '客资编号', 'customer_number'],
                    ['order_sn', '5b3b6722b9f01', 2, 0, '订单号', '订单号', 'order_sn'],
                    ['order_valid', '5b3b6722b9f01', 1, 0, '订单有效状态（1：无效；2：有效）', '订单有效状态（1：无效；2：有效）', 'order_valid'],
                    ['m_tel', '5b3b6722b9f01', 2, 0, '母亲手机', '母亲手机', 'm_tel'],
                    ['w_tel', '5b3b6722b9f01', 2, 0, '父亲手机', '父亲手机', 'w_tel'],
                    ['order_valid', '5b3b6722b9f01', 2, 0, '', '', 'order_valid'],
                    ['order_fact', '5b3b6722b9f01', 2, 0, '一销实收', '一销实收', 'order_fact'],
                    ['order_amount', '5b3b6722b9f01', 2, 0, '一销总额', '一销总额', 'order_amount'],
                    ['two_pin_fact', '5b3b6722b9f01', 2, 0, '二销实收', '二销实收', 'two_pin_fact'],
                    ['two_pin_amount', '5b3b6722b9f01', 2, 0, '二销总额', '二销总额', 'two_pin_amount'],
                    ['brandclass_id', '5b3b6722b9f01', 2, 0, '事业部ID', '事业部ID', 'brandclass_id'],
                    ['brandclass', '5b3b6722b9f01', 2, 0, '事业部', '事业部', 'brandclass'],
                    ['shop_code', '5b3b6722b9f01', 2, 0, 'shop_code', 'shop_code', 'shop_code'],
                    ['shop_name', '5b3b6722b9f01', 2, 0, 'shop_name', 'shop_name', 'shop_name'],
                ],
            ],
        ],
    ],
    '1.1.109' => [
        [ /*第二个改动*/
            'type' => 'column',
            'name' => 's_kpi_staffgoal',
            'fields' => [
                ['name' => 'start', 'type' => 'date','default' => null, 'is_null' => true],
                ['name' => 'end', 'type' => 'date', 'default' => null, 'is_null' => true],
            ],
        ],
    ],
    '1.1.110' => [
        [ /*第二个改动*/
            'type' => 'sql',
            'sql' => 'ALTER TABLE s_kpi_staffgoal MODIFY `month` VARCHAR(20) DEFAULT NULL;',
        ],
    ],
    '1.1.111' => [
        [ /*第二个改动*/
            'type' => 'sql',
            'sql' => "UPDATE s_menu set menu_name='首页客资简析' where menu_code='menu1514430518'",
        ],
        [ /*菜单隐藏*/
            'type' => 'sql',
            'sql' => "UPDATE s_menu set status=0 where menu_code='menu1512029909'",
        ],
        [ /*电访备注隐藏*/
            'type' => 'sql',
            'sql' => "UPDATE s_menu set status=0 where menu_code='menu1512029635'",
        ],
    ],
    '1.1.112' => [
        [ /*第二个改动*/
            'type' => 'sql',
            'sql' => "UPDATE s_menu set menu_name='渠道名称设定' where menu_code='menu1516949559'",
        ],
    ],
    '1.1.113' => [
        [ /*第二个改动*/
            'type' => 'column',
            'name' => 's_channel_cost',
            'fields' => [
                ['name' => 'department_id', 'type' => 'int','length'=>11,'default' => null, 'is_null' => true],
                ['name' => 'department_name', 'type' => 'varchar','length'=>50, 'default' => null, 'is_null' => true],
            ],
        ],
    ],
    '1.1.115' => [
        [ /*第二个改动*/
            'type' => 'column',
            'name' => 's_kpi_staffgoal',
            'fields' => [
                ['name' => 'group_id', 'type' => 'int','length'=>11,'default' => 0, 'is_null' => true],
                ['name' => 'group_name', 'type' => 'varchar', 'length'=>50, 'default' => null, 'is_null' => true],
            ],
        ],
        [
            'type' => 'column',
            'name' => 's_custom_column',
            'fields' => [
                // 自定义列增加员工姓名
                ['name' => 'staff_name', 'type' => 'varchar','length'=>50, 'default' => null, 'is_null' => true],
            ],
        ],
    ],
    '1.1.116' => [
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'], /*要插入的字段*/
                'value' => [ /*要插入的字段对应的数据*/
                    ['客资姓名修改', 61, 'menu1533803338', '', 0, 11],
                ],
            ],
        ],
    ],
    '1.1.117' => [
        [ /*第一个改动*/
            'type' => 'table',
            'name' => 'c_customer_jdm',
            'fields' => [
                ['name' => 'c_id', 'type' => 'int', 'length' => 11, 'is_null' => true],
                ['name' => 'shop_code', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
                ['name' => 'shop_name', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
                ['name' => 'brandclass_id', 'type' => 'int', 'length' => 11, 'is_null' => true],
                ['name' => 'brandclass', 'type' => 'varchar', 'length' => 50,'default' =>null, 'is_null' => true],
                ['name' => 'jd_code', 'type' => 'varchar', 'length' => 100,'default' => null, 'is_null' => true],
                ['name' => 'jd_time', 'type' => 'datetime','default'=>null, 'is_null' => true],
                //是否进店:1:进店;2:未进店
                ['name' => 'is_jd', 'type' => 'tinyint', 'length' => 1,'default'=>2, 'is_null' => true],
            ],
        ],
    ],
    '1.1.118' => [
        [ /*第二个改动*/
            'type' => 'column',
            'name' => 'c_customer_order',
            'fields' => [
                // 订单有效时间
                ['name' => 'valid_time', 'type' => 'datetime', 'default' => null, 'is_null' => true],
                // 退单时间
                ['name' => 'unvalid_time', 'type' => 'datetime', 'default' => null, 'is_null' => true],
                //是否删除:1:删除;2:未删除;用于客资删除时删除订单,软删除；erp接口删除订单为物理删除
                ['name' => 'is_delete', 'type' => 'tinyint', 'default' => 2, 'is_null' => true],
            ],
        ],
    ],
    '1.1.119' => [
        [ /*第二个改动*/
            'type' => 'column',
            'name' => 'c_customerinfo',
            'fields' => [
                // 转介绍人
                ['name' => 'introduce_staff_name', 'type' => 'varchar','length'=>50, 'default' => null, 'is_null' => true],
            ],
        ],
        [ /*第二个改动*/
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'], /*要插入的字段*/
                'value' => [ /*要插入的字段对应的数据*/
                    ['客资录入设置', 6, 'menu1534495340', '/crm/Setting/cusLrset', 1, 25],
                ],
            ],
        ],
    ],
    '1.1.120' => [
        [
            'type' => 'data',
            'name' => 'api_list',
            'fields' => [
                'field' => ['apiName', 'apiUrl', 'app_id', 'hash', 'accessToken', 'needLogin', 'status', 'method', 'info'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['退单', 'Customer/refund', 5, '5b1a174a2cd3', 0, 0, 1, 1,'退单'],
                ],
            ],
        ],
        [
            'type' => 'data',
            'name' => 'api_fields',
            'fields' => [
                'field' => ['fieldName', 'hash','dataType', 'isMust', 'range', 'info', 'type', 'showName'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['customer_number', '5b1a174a2cd3', 2, 1, '', '客资编号', 0,'customer_number'],
                ],
            ],
        ],
    ],
    '1.1.121' => [
        [
            'type' => 'column',
            'name' => 's_kpi_staffgoal',
            'fields' => [
                ['name' => 'brandclass_id', 'type' => 'int', 'length' => 5, 'default' => 0, 'is_null' => true],
                ['name' => 'brandclass', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
            ],
        ],
    ],
    '1.1.124' => [
        [
            'type' => 'column',
            'name' => 's_report_form',
            'fields' => [
                // 报表描述
                ['name' => 'described', 'type' => 'varchar', 'length' => 255, 'default' => null, 'is_null' => true],
                //缩略图
                ['name' => 'thumb', 'type' => 'varchar', 'length' => 255, 'default' => null, 'is_null' => true],
            ],
        ],
        [
            'type' => 'table',
            'name' => 's_report_detail',
            'fields' => [
                ['name' => 'id', 'type' => 'int', 'default' => 'AUTO_INCREMENT', 'is_null' => false],
                //报表id
                ['name' => 'form_id', 'type' => 'int', 'default' => '0', 'is_null' => false],
                //统计对象 事业部 店 部门 小组
                ['name' => 'brandclass_id', 'type' => 'int', 'length' => 11, 'default' => null, 'is_null' => true],
                ['name' => 'shop_code', 'type' => 'varchar', 'length' => 50, 'default' => null, 'is_null' => true],
                ['name' => 'department_id', 'type' => 'int', 'length' => 11, 'default' => null, 'is_null' => true],
                ['name' => 'group_id', 'type' => 'int', 'length' => 11, 'default' => null, 'is_null' => true],
                //查看权限 事业部 店  部门 岗位
                ['name' => 'report_auth', 'type' => 'varchar', 'length' => 255, 'default' => null, 'is_null' => true],
                //查看权限 事业部 店  部门 岗位
                ['name' => 'report_auth_detail', 'type' => 'text', 'default' => null, 'is_null' => true],
                ['name' => 'create_time', 'type' => 'datetime', 'default' => null, 'is_null' => true],
            ],
        ],
    ],
    '1.1.125' => [
        [ /*第二个改动*/
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'], /*要插入的字段*/
                'value' => [ /*要插入的字段对应的数据*/
                    ['花费设定', 8, 'menu1535512964', '/crm/Setting/costSet', 1, 130],
                ],
            ],
        ],
    ],
    '1.1.126' => [
        [ /*第二个改动*/
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'], /*要插入的字段*/
                'value' => [ /*要插入的字段对应的数据*/
                    ['删除小组', 74, 'menu1535542292', '', 0, 15],
                ],
            ],
        ],
    ],
    '1.1.127' => [
        [ /*第二个改动*/
            'type' => 'column',
            'name' => 'c_customerinfo',
            'fields' => [
                // 新单类型，即消费子类型
                ['name' => 'order_newclass', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
            ],
        ],
        [ /*第二个改动*/
            'type' => 'column',
            'name' => 'd_customerinfo',
            'fields' => [
                // 新单类型，即消费子类型
                ['name' => 'order_newclass', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
            ],
        ],
        [ /*第二个改动*/
            'type' => 'column',
            'name' => 's_session',
            'fields' => [
                // 登陆时间
                ['name' => 'login_time', 'type' => 'datetime','default' => null, 'is_null' => true],
            ],
        ],
    ],
    '1.1.128' => [
        [
            'type' => 'column',
            'name' => 'c_customerinfo',
            'fields' => [
                // //转介绍类型 :   1:老顾客转介绍;2:员工亲友转介绍 默认0
                ['name' => 'zjs_from', 'type' => 'tinyint','length'=>2,'is_null' => true, 'default' =>0],
            ],
        ],
        [ /*第二个改动*/
            'type' => 'column',
            'name' => 'd_customerinfo',
            'fields' => [
                // //转介绍类型 :   1:老顾客转介绍;2:员工亲友转介绍 默认0
                ['name' => 'zjs_from', 'type' => 'tinyint','length'=>2,'is_null' => true, 'default' =>0],
            ],
        ],
    ],
    '1.1.129' => [
        [ /*第二个改动*/
            'type' => 'sql',
            'sql' => "DELETE FROM s_menu where menu_code='menu1535512964'",
        ],
        [ /*第二个改动*/
            'type' => 'sql',
            'sql' => "DELETE FROM s_menu where menu_code='menu1534495340'",
        ],
    ],
    '1.1.130' => [
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'], /*要插入的字段*/
                'value' => [ /*要插入的字段对应的数据*/
                    ['批量有效', 61, 'menu1529401205', '/crm/Customer/customerMoreValid', 0, 7],
                    ['批量无效', 61, 'menu1529401206', '/crm/Customer/customerMoreUnValid', 0, 8],
                ],
            ],
        ],
    ],
    '1.1.131' => [
        [
            'type' => 'column',
            'name' => 's_home_show',
            'fields' => [
                //部门id
                ['name' => 'department_id', 'type' => 'int','length'=>11,'is_null' => true, 'default' =>null],
                ['name' => 'department_name', 'type' => 'varchar','length'=>100,'is_null' => true, 'default' =>null],
            ],
        ],
    ],
    '1.1.132' => [
        [
            'type' => 'column',
            'name' => 's_custom_column',
            'fields' => [
                //店面类型  1:婚纱;2:儿童
                ['name' => 'shop_type', 'type' => 'tinyint','length'=>2,'is_null' => true, 'default' =>1],
            ],
        ],
    ],
    '1.1.133' => [
        [ /*第一个改动*/
            'type' => 'table',
            'name' => 'c_customer_from',
            'fields' => [
                ['name' => 'cid', 'type' => 'int', 'length' => 11, 'is_null' => false],
                ['name' => 'dj_group_id', 'type' => 'int', 'length' => 11, 'default' => null, 'is_null' => true],
                ['name' => 'dj_group_name', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
                ['name' => 'sales_group_id', 'type' => 'int', 'length' => 11, 'default' => null, 'is_null' => true],
                ['name' => 'sales_group_name', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
            ],
        ],
        [ /*第二个改动*/
            'type' => 'sql',
            'sql' => "ALTER TABLE c_customer_from ADD UNIQUE cid(cid)",
        ],
        [
            'type' => 'data',
            'name' => 'api_list',
            'fields' => [
                'field' => ['apiName', 'apiUrl', 'app_id', 'hash', 'accessToken', 'needLogin', 'status', 'method', 'info'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['新增erp追踪记录', 'Customer/erpAddTrackinfo', 5, '5b935efda2990', 0, 0, 1, 1,'erp进客登记中的标记功能，crm记录一次客资追踪记录'],
                ],
            ],
        ],
        [
            'type' => 'data',
            'name' => 'api_fields',
            'fields' => [
                'field' => ['fieldName', 'hash','dataType', 'isMust', 'range', 'info', 'type', 'showName'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['customer_number', '5b935efda2990', 2, 1, '客资编号','客资编号', 0,'customer_number'],
                    ['staff_name', '5b935efda2990', 2, 1, '当前操作人姓名', '当前操作人姓名', 0,'staff_name'],
                    ['shop_code', '5b935efda2990', 2, 1, '操作店shop_code','操作店shop_code', 0,'shop_code'],
                    ['shop_name', '5b935efda2990', 1, 1, '操作店shop_name','操作店shop_name', 0,'shop_name'],
                    ['sign_name', '5b935efda2990', 2, 1, '标记名称','标记名称', 0,'sign_name'],
                    ['sign_time', '5b935efda2990', 2, 1, '标记时间','标记时间', 0,'sign_time'],
                ],
            ],
        ],
    ],
    '1.1.134' => [
        [ /*第一个改动*/
            'type'=> 'sql',
            'sql' => "CREATE TABLE `".config('db_logs')['database']."`.`request_logs` (`id` int(11) NOT NULL AUTO_INCREMENT,`request_url` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,`request_data` text COLLATE utf8_unicode_ci,`response_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,`response_data` text COLLATE utf8_unicode_ci,`request_start_time` decimal(16,5) DEFAULT NULL,`request_end_time` decimal(16,5) DEFAULT NULL,`create_time` datetime DEFAULT NULL,`create_ip` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,PRIMARY KEY (`id`),KEY `request_url` (`request_url`) USING BTREE,KEY `response_code` (`response_code`) USING BTREE) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;",
        ],
    ],
    '1.1.135' => [
        [ /*修改字段类型*/
            'type'=> 'sql',
            'sql' => "ALTER TABLE `".config('db_logs')['database']."`.request_logs modify column request_data longtext;",
        ],
        [ /*修改字段类型*/
            'type'=> 'sql',
            'sql' => "ALTER TABLE `".config('db_logs')['database']."`.request_logs modify column response_data longtext;",
        ],
        [ /*删除索引*/
            'type'=> 'sql',
            'sql' => "drop index request_url on `".config('db_logs')['database']."`.request_logs;",
        ],
        [ /*修改字段类型*/
            'type'=> 'sql',
            'sql' => "ALTER TABLE `".config('db_logs')['database']."`.request_logs modify column request_url text;",
        ],
        [ /*添加索引(全文索引) text 不能用使用普通索引*/
            'type'=> 'sql',
            'sql' => "ALTER TABLE `".config('db_logs')['database']."`.`request_logs` ADD FULLTEXT  request_url (`request_url`);",
        ],
        [ /*添加索引(全文索引)*/
            'type'=> 'sql',
            'sql' => "ALTER TABLE `".config('db_logs')['database']."`.`request_logs` ADD FULLTEXT request_data (`request_data`);",
        ],
        [ /*添加索引(全文索引)*/
            'type'=> 'sql',
            'sql' => "ALTER TABLE `".config('db_logs')['database']."`.`request_logs` ADD FULLTEXT response_data (`response_data`);",
        ],
        [ /* c_customer_from 同步客资表中的cid */
            'type'=> 'sql',
            'sql' => "INSERT INTO `c_customer_from`(cid) SELECT id FROM c_customerinfo;",
        ],
    ],
    '1.1.136' => [
        [
            'type'=> 'sql',
            'sql' => "UPDATE s_menu set sort=7 where menu_code='menu1512650831'",
        ],
        [
            'type'=> 'sql',
            'sql' => "UPDATE s_menu set sort=5 where menu_code='menu1529995000'",
        ]
    ],
    '1.1.137' => [
        [ /*呼叫中心配置表*/
            'type' => 'table',
            'name' => 's_call_center',
            'fields' => [
                ['name' => 'id', 'type' => 'int', 'length' => 11,'default' => 'AUTO_INCREMENT', 'is_null' => false],
                // 呼叫中心的名字
                ['name' => 'call_name', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
                // 域名
                ['name' => 'ip', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
                // 端口号
                ['name' => 'port', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
            ],
        ],
        [ /*呼叫中心坐席信息表*/
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'], /*要插入的字段*/
                'value' => [ /*要插入的字段对应的数据*/
                    ['呼叫中心设置', 6, 'menu1537348792', '/crm/Setting/callCenterSet', 1, 103],
                ],
            ],
        ],
    ],
    '1.1.138' => [
        [ /*呼叫中心坐席信息表*/
            'type' => 'table',
            'name' => 's_call_man',
            'fields' => [
                // 坐席号
                ['name' => 'user', 'type' => 'varchar', 'length' => 100, 'is_null' => false],
                // 坐席密码
                ['name' => 'pwd', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
                // 坐席对应的员工信息
                ['name' => 'staff_id', 'type' => 'int', 'length' => 11, 'is_null' => false],
                ['name' => 'staff_name', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
                ['name' => 'shop_code', 'type' => 'varchar', 'length' => 100, 'is_null' => true],
                ['name' => 'shop_name', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
                ['name' => 'group_id', 'type' => 'int', 'length' => 11, 'is_null' => false],
                ['name' => 'group_name', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
                ['name' => 'department_id', 'type' => 'int', 'length' => 11, 'is_null' => false],
                ['name' => 'department_name', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
            ],
        ],
    ],
    '1.1.139' => [
        [ /*呼叫中心坐席信息表*/
            'type' => 'column',
            'name' => 's_call_man',
            'fields' => [
                // 是否在线 默认:0,不在线
                ['name' => 'status', 'type' => 'tinyint', 'length' => 1,'default'=>0, 'is_null' => true],
                // 是否忙碌 默认:0 闲,   1:忙
                ['name' => 'is_busy', 'type' => 'tinyint', 'length' => 1, 'default' => 0, 'is_null' => true],
            ],
        ],
    ],
    '1.1.140' => [
        [ /*呼叫中心坐席信息表*/
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'], /*要插入的字段*/
                'value' => [ /*要插入的字段对应的数据*/
                    ['坐席监控', 70, 'menu1537587731', '', 0, 3],
                ],
            ],
        ],
    ],
    '1.1.141' => [
        [ /*第二个改动*/
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['id', 'menu_name', 'fid', 'menu_code', 'menu_url', 'menu_icon','status', 'sort'], /*要插入的字段*/
                'value' => [ /*要插入的字段对应的数据*/
                    ['9','系统日志', 0, 'menu1537322224', '#', 'fa-file-text', 1, 5],
                ],
            ],
        ],
        [ /*第二个改动*/
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'], /*要插入的字段*/
                'value' => [ /*要插入的字段对应的数据*/
                    ['客资分配日志', 9, 'menu1537322380', '/crm/Logs/fplogs', 1, 1],
                    ['网销签到信息', 9, 'menu1538119117', '', 0, 1],
                    ['手机修改日志', 9, 'menu1538103712', '/crm/Logs/telLogs', 1, 1],
                    ['客资操作日志', 9, 'menu1538103743', '/crm/Logs/customerLogs', 1, 1],
                    ['设定日志', 9, 'menu1538103771', '/crm/Logs/settingLogs', 1, 1],
                ],
            ],
        ],
    ],
    '1.1.142' => [
        [ /*排程日志表*/
            'type' => 'table',
            'name' => 'l_pc_log',
            'fields' => [
                ['name' => 'id', 'type' => 'int', 'length' => 11, 'default' => 'AUTO_INCREMENT', 'is_null' => false],
                ['name' => 'cid', 'type' => 'int', 'length' => 11, 'is_null' => true],
                //摄影师所在店面
                ['name' => 'shop_code', 'type' => 'varchar', 'length' => 100,'default'=>null, 'is_null' => true],
                ['name' => 'shop_name', 'type' => 'varchar', 'length' => 100,'default'=>null, 'is_null' => true],
                //摄影师所在店面
                ['name' => 'pc_shop_code', 'type' => 'varchar', 'length' => 100,'default'=>null, 'is_null' => true],
                ['name' => 'pc_shop_name', 'type' => 'varchar', 'length' => 100,'default'=>null, 'is_null' => true],
                //摄影师
                ['name' => 'cameraman_id', 'type' => 'int', 'length' => 11,'default'=>null, 'is_null' => true],
                ['name' => 'cameraman_name', 'type' => 'varchar', 'length' => 100,'default'=>null, 'is_null' => true],
                //销售(门市)
                ['name' => 'sale_id', 'type' => 'int', 'length' => 11,'default'=>null, 'is_null' => true],
                ['name' => 'sale_name', 'type' => 'varchar', 'length' => 100,'default'=>null, 'is_null' => true],
                //导师
                ['name' => 'tutor_id', 'type' => 'int', 'length' => 11,'default'=>null, 'is_null' => true],
                ['name' => 'tutor_name', 'type' => 'varchar', 'length' => 100,'default'=>null, 'is_null' => true],
                //备注
                ['name' => 'remark', 'type' => 'text', 'default'=>null, 'is_null' => true],
                //排程时间
                ['name' => 'pc_time', 'type' => 'date', 'default'=>null, 'is_null' => true],
                ['name' => 'create_time', 'type' => 'datetime', 'default'=>null, 'is_null' => true],
            ],
        ],
        [ /*排程次数变更表*/
            'type' => 'table',
            'name' => 'l_pc_setting_log',
            'fields' => [
                ['name' => 'id', 'type' => 'int', 'length' => 11, 'default' => 'AUTO_INCREMENT', 'is_null' => false],
                ['name' => 'num', 'type' => 'int', 'length' => 11, 'is_null' => true],
                ['name' => 'setting_date', 'type' => 'date', 'default'=>null, 'is_null' => true],
                //操作人
                ['name' => 'staff_id', 'type' => 'varchar', 'length' => 100,'default'=>null, 'is_null' => true],
                ['name' => 'staff_name', 'type' => 'varchar', 'length' => 100,'default'=>null, 'is_null' => true],
                ['name' => 'ip', 'type' => 'varchar', 'length' => 100,'default'=>null, 'is_null' => true],
                ['name' => 'shop_code', 'type' => 'varchar', 'length' => 100,'default'=>null, 'is_null' => true],
                ['name' => 'shop_name', 'type' => 'varchar', 'length' => 100,'default'=>null, 'is_null' => true],
                ['name' => 'create_time', 'type' => 'datetime', 'default'=>null, 'is_null' => true],
            ],
        ],
    ],
    '1.1.143' => [
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'], /*要插入的字段*/
                'value' => [ /*要插入的字段对应的数据*/
                    ['客资提醒查询', 9, 'menu1538103331', '/crm/Logs/remindLogs', 1, 1],
                ],
            ],
        ],
    ],
    '1.1.144' => [
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'], /*要插入的字段*/
                'value' => [ /*要插入的字段对应的数据*/
                    ['关键字修改', 61, 'menu1539573890', '', 0, 20],
                ],
            ],
        ],
    ],
    '1.1.147' => [
        [
            'type' => 'column',
            'name' => 'c_customerinfo',
            'fields' => [
                //广告落地页
                ['name' => 'ad_page', 'type' => 'text','default'=>null, 'is_null' => true],
            ],
        ],
    ],
    '1.1.149' => [
        [ /*第三方提报配置*/
            'type' => 'table',
            'name' => 's_third',
            'fields' => [
                ['name' => 'id', 'type' => 'int', 'length' => 11, 'default' => 'AUTO_INCREMENT', 'is_null' => false],
                ['name' => 'columns', 'type' => 'text','default'=>null, 'is_null' => true],
                //录入店面
                ['name' => 'add_shop_code', 'type' => 'varchar', 'length' => 100,'default'=>null, 'is_null' => true],
                ['name' => 'add_shop_name', 'type' => 'varchar', 'length' => 100,'default'=>null, 'is_null' => true],
                //录入人
                ['name' => 'dj_staff_id', 'type' => 'int', 'length' => 11,'default'=>null, 'is_null' => true],
                ['name' => 'dj_staff', 'type' => 'varchar', 'length' => 100,'default'=>null, 'is_null' => true],
                //归属店
                ['name' => 'belong_shop_code', 'type' => 'varchar', 'length' => 100,'default'=>null, 'is_null' => true],
                ['name' => 'belong_shop_name', 'type' => 'varchar', 'length' => 100,'default'=>null, 'is_null' => true],
                //客资来源
                ['name' => 'customer_cource_id', 'type' => 'int', 'length' => 11,'default'=>null, 'is_null' => true],
                ['name' => 'customer_cource', 'type' => 'varchar', 'length' => 100,'default'=>null, 'is_null' => true],
                //提交地址
                ['name' => 'url', 'type' => 'text','default'=>null, 'is_null' => true],
                ['name' => 'token', 'type' => 'varchar','length' => 100,'default'=>null, 'is_null' => true],
                //创建人
                ['name' => 'create_staff_id',  'type' => 'int', 'length' => 11,'default'=>null, 'is_null' => true],
                ['name' => 'create_staff', 'type' => 'varchar','length' => 100, 'default'=>null, 'is_null' => true],
                //事业部
                ['name' => 'brandclass_id',  'type' => 'int', 'length' => 11,'default'=>null, 'is_null' => true],
                ['name' => 'brandclass', 'type' => 'varchar','length' => 200, 'default'=>null, 'is_null' => true],
                //时间
                ['name' => 'create_time', 'type' => 'datetime', 'default'=>null, 'is_null' => true],
            ],
        ],
        [ /*第三方提报详情表*/
            'type' => 'table',
            'name' => 's_third_detail',
            'fields' => [
                ['name' => 'id', 'type' => 'int', 'length' => 11, 'default' => 'AUTO_INCREMENT', 'is_null' => false],
                // 客资录入接口配置表id
                ['name' => 'pid', 'type' => 'int', 'length' => 11, 'default' =>0, 'is_null' => true],
                //提报参数json串
                ['name' => 'data', 'type' => 'text', 'default' => null, 'is_null' => true],
                //结果状态码，200：成功;100:字段重复；300：参数有误；400：插入出错
                ['name' => 'result_code', 'type' => 'int', 'length' => 3, 'default' => 0, 'is_null' => true],
                //失败原因
                ['name' => 'error_reason', 'type' => 'text', 'default' => null, 'is_null' => true],
                //提交人ip
                ['name' => 'ip', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
                // 提报人id
                ['name' => 'staff_id', 'type' => 'int', 'length' => 11, 'default' => 0, 'is_null' => true],
                ['name' => 'create_time', 'type' => 'datetime', 'default' => null, 'is_null' => true],
                // 修改人id
                ['name' => 'update_staff_id', 'type' => 'int', 'length' => 11, 'default' => 0, 'is_null' => true],
                //修改时间
                ['name' => 'update_time', 'type' => 'datetime', 'default' => null, 'is_null' => true],
                ['type' => 'key', 'name' => 'key1', 'fields' => ['id']],
            ],
        ],
    ],
    '1.1.150' => [
        [
            'type' => 'data',
            'name' => 's_menu',
            'unique'=>'menu_code',//排重列，会按此列进行排重，如果重复，则跳过对应的数据行
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'], /*要插入的字段*/
                'value' => [ /*要插入的字段对应的数据*/
                    ['客资表单设定', 6, 'menu1540363547', '/crm/Setting/customerForms', 1, 30],
                ],
            ],
        ],
    ],
    '1.1.151' => [
        [
            'type' => 'column',
            'name' => 'c_customerinfo',
            'fields' => [
                //添加好友时间
                ['name' => 'add_friend_time', 'type' => 'datetime','default'=>null, 'is_null' => true],
            ],
        ],
    ],
    '1.1.152' => [
        [
            'type' => 'data',
            'name' => 's_menu',
            'unique'=>'menu_code',//排重列，会按此列进行排重，如果重复，则跳过对应的数据行
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'], /*要插入的字段*/
                'value' => [ /*要插入的字段对应的数据*/
                    ['选项卡-过期客资', 34, 'menu1540550148', '', 1, 17],
                ],
            ],
        ],
    ],
    '1.1.154' => [
        [
            'type' => 'data',
            'name' => 'api_list',
            'fields' => [
                'field' => ['apiName', 'apiUrl', 'app_id', 'hash', 'accessToken', 'needLogin', 'status', 'method', 'info'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['erp通知crm成单', 'Customer/erpCallCrmCreateOrder', 5, '5bd42d703b150', 0, 0, 1, 1,'用于转单后ERP通知CRM订单'],
                ],
            ],
        ],
        [
            'type' => 'data',
            'name' => 'api_fields',
            'fields' => [
                'field' => ['fieldName', 'hash','dataType', 'isMust', 'range', 'info', 'type', 'showName'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['order_day', '5bd42d703b150', 2, 1, '','订单时间', 0,'order_day'],
                    ['customer_number', '5bd42d703b150', 1, 1, '', '客资编号', 0,'customer_number'],
                    ['order_sn', '5bd42d703b150', 1, 1, '','单号', 0,'order_sn'],
                    ['total_money', '5bd42d703b150', 1, 1, '','套系', 0,'total_money'],
                    ['fact_money', '5bd42d703b150', 1, 1, '','实收', 0,'fact_money'],
                    ['reception_name', '5bd42d703b150', 1, 0, '','门市', 0,'reception_name'],
                    ['pay_type', '5bd42d703b150', 2, 0, '','付款方式', 0,'pay_type'],
                ],
            ],
        ],
    ],
    '1.1.167' =>[
        [
            'type' => 'column',
            'name' => 'c_customer_cost',
            'fields' => [
                ['name' => 'belong_shop_code', 'type' => 'varchar','length'=>100,'default'=>null, 'is_null' => true],
                ['name' => 'belong_shop_name', 'type' => 'varchar','length'=>100,'default'=>null, 'is_null' => true],
            ],
        ],
        [
            'type' => 'column',
            'name' => 's_channel_cost',
            'fields' => [
                ['name' => 'belong_shop_code', 'type' => 'varchar','length'=>100,'default'=>null, 'is_null' => true],
                ['name' => 'belong_shop_name', 'type' => 'varchar','length'=>100,'default'=>null, 'is_null' => true],
            ],
        ],
    ],
    '1.1.169' => [
        [
            'type' => 'column',
            'name' => 'c_customer_from',
            'fields' => [
                ['name' => 'code', 'type' => 'varchar','length'=>100,'default'=>null, 'is_null' => true],
                ['name' => 'hd_name', 'type' => 'varchar','length'=>100,'default'=>null, 'is_null' => true],
            ],
        ],
        [
            'type' => 'data',
            'name' => 'api_list',
            'fields' => [
                'field' => ['apiName', 'apiUrl', 'app_id', 'hash', 'accessToken', 'needLogin', 'status', 'method', 'info'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['活动提报客资接口', 'Vip/addCustomer', 7, '5be54b43c8bb8', 0, 0, 1, 1,'用于活动中的客资提报'],
                ],
            ],
        ],
        [
            'type' => 'data',
            'name' => 'api_fields',
            'fields' => [
                'field' => ['fieldName', 'hash','dataType', 'isMust', 'range', 'info', 'type', 'showName'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['staff_id', '5be54b43c8bb8', 1, 1, '','登记人id', 0,'staff_id'],
                    ['hd_name', '5be54b43c8bb8', 1, 1, '', '活动名称', 0,'hd_name'],
                    ['customer_name', '5be54b43c8bb8', 1, 1, '','客户姓名', 0,'customer_name'],
                    ['customer_tel', '5be54b43c8bb8', 1, 1, '','客户手机', 0,'customer_tel'],
                    ['consulation_shop_code', '5be54b43c8bb8', 0, 1, '','意向店面编码', 0,'consulation_shop_code'],
                    ['consulation_shop', '5be54b43c8bb8', 1, 0, '','意向店面', 0,'consulation_shop'],
                    ['customer_cource_id', '5be54b43c8bb8', 1, 0, '','客户来源id', 0,'customer_cource_id'],
                    ['customer_cource', '5be54b43c8bb8', 2, 0, '','客户来源', 0,'customer_cource'],
                ],
            ],
        ],
    ],
    '1.1.170' => [
        [
            'type' => 'column',
            'name' => 'l_pc_log',
            'fields' => [
                //分区id
                ['name' => 'area_id', 'type' => 'int','length' => 11,'default'=>null, 'is_null' => true],
                //分区名称
                ['name' => 'area_name', 'type' => 'varchar','length'=>50,'default'=>null, 'is_null' => true],
                //时间点
                ['name' => 'time', 'type' => 'int','length'=>5,'default'=>null, 'is_null' => true],
                //排程结果 1:未完成；2：已完成
                ['name' => 'result', 'type' => 'tinyint','default'=>1, 'is_null' => true],
            ],
        ],
        [
            'type' => 'column',
            'name' => 'l_pc_setting_log',
            'fields' => [
                //分区id
                ['name' => 'area_id', 'type' => 'int','length' => 11,'default'=>null, 'is_null' => true],
                //分区名称
                ['name' => 'area_name', 'type' => 'varchar','length'=>50,'default'=>null, 'is_null' => true],
                //时间点
                ['name' => 'time', 'type' => 'varchar','length'=>50,'default'=>null, 'is_null' => true],
            ],
        ],
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'], /*要插入的字段*/
                'value' => [ /*要插入的字段对应的数据*/
                    ['排程设定', 6, 'menu1542112060', '/crm/Setting/pcSet', 1, 35],
                ],
            ],
        ],
    ],
    '1.1.171' => [
        [
            'type' => 'column',
            'name' => 's_tracksign',
            'fields' => [
                //客资标记颜色
                ['name' => 'sign_color', 'type' => 'varchar','length'=>50,'default'=>null, 'is_null' => true],
            ],
        ],
    ],
    '1.1.172'=>[
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['id','menu_name', 'fid', 'menu_code', 'menu_url', 'menu_icon','status', 'sort'], /*要插入的字段*/
                'value' => [
                    /*erp*/
                    ['2000','电务系统', 0, 'menu1542196943', '','fa-home', 0, 7],
                    ['2001','排控', 2000, 'menu1542196979', '/erp/Erp/childArrange', '',0, 1],
                    ['2002','体验拍', 2000, 'menu1542197015', '/erp/Erp/mark', '',0, 2],
                ],
            ],
        ],
    ],
    '1.1.173'=>[
        [ /*第一个改动*/
            'type' => 'table',
            'name' => 's_shop_goal',
            'fields' => [
                ['name' => 'id', 'type' => 'int', 'length' => 11,'default' => 'AUTO_INCREMENT', 'is_null' => false],
                //实收
                ['name' => 'fact', 'type' => 'int', 'length'=>11,'default' => null, 'is_null' => true],
                //进店
                ['name' => 'jd', 'type' => 'int', 'length'=>11,'default' => null, 'is_null' => true],
                //订单
                ['name' => 'order', 'type' => 'int', 'length'=>11,'default' => null, 'is_null' => true],
                //客资量
                ['name' => 'cus', 'type' => 'int', 'length'=>11,'default' => null, 'is_null' => true],
                //预算
                ['name' => 'cost', 'type' => 'int', 'length'=>11,'default' => null, 'is_null' => true],
                //月份 yyyy-mm
                ['name' => 'month', 'type' => 'varchar', 'length'=>50, 'default' => null, 'is_null' => true],
                //操作人
                ['name' => 'staff_id', 'type' => 'int', 'length'=>11,'default' => null, 'is_null' => true],
                ['name' => 'staff_name', 'type' => 'varchar', 'length'=>50,'default' => null, 'is_null' => true],
                ['name' => 'ip', 'type' => 'varchar', 'length'=>50,'default' => null, 'is_null' => true],
                //操作时间
                ['name' => 'action_time', 'type' => 'datetime', 'default' => null, 'is_null' => false],
                //设置的店面
                ['name' => 'shop_code', 'type' => 'varchar', 'length' => 50,'default'=>null, 'is_null' => true],
                ['name' => 'shop_name', 'type' => 'varchar', 'length' => 100,'default'=>null, 'is_null' => true],
                ['name' => 'brandclass_id', 'type' => 'int', 'length' => 11,'default'=>null, 'is_null' => true],
                ['name' => 'brandclass', 'type' => 'varchar', 'length' => 100,'default'=>null, 'is_null' => true],
            ],
        ],
    ],
    '1.1.174' => [
        [
            'type' => 'column',
            'name' => 'c_customer_from',
            'fields' => [
                // 渠道客资成本
                ['name' => 'c_channel_cost', 'type' => 'varchar','length'=>50,'default'=>null, 'is_null' => true],
            ],
        ],
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['id','menu_name', 'fid', 'menu_code', 'menu_url', 'menu_icon','status', 'sort'],
                'value' => [
                    ['2003','客资再分配', 61, 'menu1541663886', '', '',1, 8],
                ],
            ],
        ],
    ],
    '1.1.175' => [
        [
            'type' => 'column',
            'name' => 'c_customer_from',
            'fields' => [
                // 操作人
                ['name' => 'staff_id', 'type' => 'int','length'=>11,'default'=>null, 'is_null' => true],
                ['name' => 'staff_name', 'type' => 'varchar','length'=>100,'default'=>null, 'is_null' => true],
                //是否核销：1：未核销；2：已核销
                ['name' => 'is_hx', 'type' => 'tinyint','length'=>2,'default'=>1, 'is_null' => true],
                //核销时间
                ['name' => 'hx_time', 'type' => 'datetime','default'=>NULL, 'is_null' => true],
            ],
        ],
    ],
    '1.1.176' =>[
        [
            'type' => 'sql',
            'sql' => 'show tables;',
        ],
        [
            'type' => 'sql',
            'sql' => 'show databases;',
        ],
    ],
    '1.1.179' => [
        [
            'type' => 'column',
            'name' => 's_allocation_rule',
            'fields' => [
                ['name' => 'belong_shop_code', 'type' => 'varchar','length'=>100,'default'=>null, 'is_null' => true],
                ['name' => 'belong_shop_name', 'type' => 'varchar','length'=>100,'default'=>null, 'is_null' => true],
                ['name' => 'brandclass_id', 'type' => 'int','length'=>11,'default'=>null, 'is_null' => true],
            ],
        ],
    ],
    '1.1.180'=>[
        [
            'type' => 'data',
            'name' => 'api_list',
            'unique'=>'hash',
            'fields' => [
                'field' => ['apiName', 'apiUrl', 'app_id', 'hash', 'accessToken', 'needLogin', 'status', 'method', 'info'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['校验进客信息是否算网销订单，', 'Customer/preCheckCustomer', 5, '465abc8e0e679', 0, 0, 1, 1,'校验进客信息是否算网销订单，包括传CRM客资编号的也有可能不算网销订单'],
                ],
            ],
        ],
        [
            'type' => 'data',
            'name' => 'api_fields',
            'fields' => [
                'field' => ['fieldName', 'hash','dataType', 'isMust', 'range', 'info', 'type', 'showName'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['brandclass_id', '465abc8e0e679', 1, 0, '事业部id', '事业部id', 0,'brandclass_id'],
                    ['customer_wechat', '465abc8e0e679', 2, 0, '微信号', '微信号', 0,'customer_wechat'],
                    ['from_index', '465abc8e0e679', 1, 0, '客资编号 ', '客资编号', 0,'from_index'],
                    ['customer_tel', '465abc8e0e679', 1, 0, '联系电话', '联系电话', 0,'customer_tel'],
                    ['mate_tel', '465abc8e0e679', 2, 0, '配偶电话', '配偶电话', 0,'mate_tel'],
                    ['customer_qq', '465abc8e0e679', 2, 0, '客户QQ', '客户QQ', 0,'customer_qq'],
                ],
            ],
        ],
    ],
    '1.1.185'=>[
        [
            'type' => 'data',
            'name' => 'api_list',
            'unique'=>'hash',
            'fields' => [
                'field' => ['apiName', 'apiUrl', 'app_id', 'hash', 'accessToken', 'needLogin', 'status', 'method', 'info'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['本单作废', 'Customer/refund', 5, '5b1a174a2cd3', 0, 0, 1, 1,'本单作废'],
                ],
            ],
        ],
        [
            'type' => 'data',
            'name' => 'api_fields',
            'fields' => [
                'field' => ['fieldName', 'hash','dataType', 'isMust', 'range', 'info', 'type', 'showName'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['customer_number', '5b1a174a2cd3', 2, 1, '', '客资编号', 0,'customer_number'],
                    ['order_sn', '5b1a174a2cd3', 2, 1, '', '订单编号', 0,'order_sn'],
                ],
            ],
        ],
        [
            'type' => 'column',
            'name' => 'c_customer_order',
            'fields' => [
                // 作废原因
                ['name' => 'unvalid_reason', 'type' => 'varchar', 'length' => 200, 'default' => null, 'is_null' => true],
                // 是否为 作废 单  1：正常；2：作废
                ['name' => 'refund', 'type' => 'tinyint', 'length' => 2, 'default' => 1, 'is_null' => true],
                // 是否为 退款 单  1：正常；2：退款
                ['name' => 'reback', 'type' => 'tinyint', 'length' => 2, 'default' => 1, 'is_null' => true],
            ],
        ],
        [
            //增加客资订单表唯一索引
            'type'=>'sql',
            'sql'=>'ALTER TABLE `c_customer_order` ADD UNIQUE INDEX `order_number` (`customer_id`, `order_sn`);',
        ],
    ],
    '1.1.188'=>[
        [
            'type' => 'data',
            'name' => 'api_list',
            'unique'=>'hash',
            'fields' => [
                'field' => ['apiName', 'apiUrl', 'app_id', 'hash', 'accessToken', 'needLogin', 'status', 'method', 'info'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['根据联系方式，查询客资信息', 'Customer/getCustomerInfomation', 5, '5b285b5c829d8', 0, 0, 1, 1,'根据联系方式，查询客资信息'],
                ],
            ],
        ],
        [
            'type' => 'data',
            'name' => 'api_fields',
            'fields' => [
                'field' => ['fieldName', 'hash','dataType', 'isMust', 'range', 'info', 'type', 'showName'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['customer_number', '5b285b5c829d8', 2, 0, '客资编号', '客资编号', 0,'customer_number'],
                    ['contace_type', '5b285b5c829d8', 1, 0, '联系方式类型(1：手机；2：微信；3：qq)', '联系方式类型(1：手机；2：微信；3：qq)', 0,'contace_type'],
                    ['contace_m', '5b285b5c829d8', 2, 0, '联系方式_男士', '联系方式_男士', 0,'contace'],
                    ['contace_w', '5b285b5c829d8', 2, 0, '联系方式_女士', '联系方式_女士', 0,'contace'],
                ],
            ],
        ],
    ],
    '1.1.189' => [
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['id','menu_name', 'fid', 'menu_code', 'menu_url', 'menu_icon','status', 'sort'],
                'value' => [
                    ['2004','订单转移', 61, 'menu1512977628', '', '',0, 11],
                ],
            ],
        ],
    ],
    '1.1.192' => [
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['id','menu_name', 'fid', 'menu_code', 'menu_url', 'menu_icon','status', 'sort'],
                'value' => [
                    ['2005','离职交接', 61, 'menu1532333136', '', '',0, 12],
                ],
            ],
        ],
    ],
    '1.1.194' => [
        [
            'type' => 'table',
            /*其它设定，如曝光量，点击量等*/
            'name' => 's_another_setting',
            'fields' => [
                ['name' => 'id', 'type' => 'int', 'default' => 'AUTO_INCREMENT', 'is_null' => false],
                ['name' => 'channel_id', 'type' => 'int', 'length' => 11, 'default' => 0, 'is_null' => true],
                ['name' => 'channel_name', 'type' => 'varchar', 'length' => 50, 'default' => '', 'is_null' => true],
                /*曝光量*/
                ['name' => 'exposure', 'type' => 'int', 'length' => 11, 'default' => 0, 'is_null' => true],
                /*点击量*/
                ['name' => 'click', 'type' => 'int', 'length' => 11, 'default' => 0, 'is_null' => true],
                /*查看量*/
                ['name' => 'show', 'type' => 'int', 'length' => 11, 'default' => 0, 'is_null' => true],
                /*粉丝量*/
                ['name' => 'fans', 'type' => 'int', 'length' => 11, 'default' => 0, 'is_null' => true],
                /*设置时间*/
                ['name' => 'time', 'type' => 'date',  'default' => NULL, 'is_null' => true],
                ['name' => 'staff_id', 'type' => 'int', 'length' => 11, 'default' => NULL, 'is_null' => true],
                ['name' => 'staff_name', 'type' => 'varchar', 'length' => 50, 'default' =>NULL, 'is_null' => true],
                ['name' => 'group_id', 'type' => 'int', 'length' => 11, 'default' => NULL, 'is_null' => true],
                ['name' => 'group_name', 'type' => 'varchar', 'length' => 50, 'default' =>NULL, 'is_null' => true],
                ['name' => 'department_id', 'type' => 'int', 'length' => 11, 'default' => NULL, 'is_null' => true],
                ['name' => 'department_name', 'type' => 'varchar', 'length' => 50, 'default' =>NULL, 'is_null' => true],
                ['name' => 'brandclass_id', 'type' => 'int', 'length' => 11, 'default' => NULL, 'is_null' => true],
                ['name' => 'brandclass', 'type' => 'varchar', 'length' => 50, 'default' =>NULL, 'is_null' => true],
                ['name' => 'shop_code', 'type' => 'varchar', 'length' => 50, 'default' => NULL, 'is_null' => true],
                ['name' => 'shop_name', 'type' => 'varchar', 'length' => 50, 'default' =>NULL, 'is_null' => true],
                ['name' => 'create_time', 'type' => 'datetime', 'default' => NULL, 'is_null' => true],
                ['name' => 'update_time', 'type' => 'datetime', 'default' => NULL, 'is_null' => true],
                ['type' => 'key', 'name' => 'key1', 'fields' => ['id']]
            ],
        ],
        [
            'type' => 'data',
            'unique'=>'menu_code',//排重列，会按此列进行排重，如果重复，则跳过对应的数据行
            'name' => 's_menu',
            'fields' => [
                'field' => ['id','menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['2006','广告信息录入', 8, 'menu1544608169', '/crm/Setting/anotherSetting', 1, 110],
                ],
            ],
        ],
    ],
    '1.1.196'=>[
        [
            'type' => 'data',
            'name' => 'api_list',
            'unique'=>'hash',
            'fields' => [
                'field' => ['apiName', 'apiUrl', 'app_id', 'hash', 'accessToken', 'needLogin', 'status', 'method', 'info'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['获取排程余量', 'Child/paichengNum', 4, '5c207f0794700', 0, 0, 1, 1,'获取上门拍排程余量'],
                    ['排程', 'Child/paicheng', 4, '5c207f8394318', 0, 0, 1, 1,'上门拍排程'],
                    ['获取短信模板', 'Child/getModel', 4, '5c2095b23efd0', 0, 0, 1, 1,'获取短信模板'],
                ],
            ],
        ],
        [
            'type' => 'data',
            'name' => 'api_fields',
            'fields' => [
                'field' => ['fieldName', 'hash','dataType', 'isMust', 'range', 'info', 'type', 'showName'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['month', '5c207f0794700', 2, 1, '年月', '月份', 0,'month'],
                    ['shop_code', '5c207f0794700', 2, 1, '', '', 0,'shop_code'],
                    ['area_id', '5c207f0794700', 2, 0, '', '分区id', 0,'area_id'],
                    ['time', '5c207f0794700', 2, 0, '', '时间点', 0,'time'],
                    ['id', '5c207f8394318', 1, 1, '', '客资id', 0,'id'],
                    ['staff_id', '5c207f8394318', 1, 1, '', '操作人id', 0,'staff_id'],
                    ['pc_time', '5c207f8394318', 2, 1, '2018-12-29', '排程日期', 0,'pc_time'],
                    ['pc_shop_code', '5c207f8394318', 2, 1, '', '排程店面code', 0,'pc_shop_code'],
                    ['pc_shop_name', '5c207f8394318', 2, 1, '', '排程店面', 0,'pc_shop_name'],
                    ['area_id', '5c207f8394318', 1, 0, '', '分区id', 0,'area_id'],
                    ['area_name', '5c207f8394318', 2, 0, '', '分区', 0,'area_name'],
                    ['time', '5c207f8394318', 2, 0, '', '时间点', 0,'time'],
                    ['cameraman_id', '5c207f8394318', 1, 0, '', '摄影师id', 0,'cameraman_id'],
                    ['cameraman_name', '5c207f8394318', 2, 0, '', '摄影师', 0,'cameraman_name'],
                    ['sale_id', '5c207f8394318', 1, 0, '', '销售id', 0,'sale_id'],
                    ['sale_name', '5c207f8394318', 2, 0, '', '销售', 0,'sale_name'],
                    ['tutor_id', '5c207f8394318', 1, 0, '', '导师id', 0,'tutor_id'],
                    ['tutor_name', '5c207f8394318', 2, 0, '', '导师', 0,'tutor_name'],
                    ['remark', '5c207f8394318', 2, 0, '', '排程备注', 0,'remark'],
                    ['model_id', '5c207f8394318', 1, 0, '', '短信模板id', 0,'短信模板id'],
                    ['shop_code', '5c2095b23efd0', 2, 1, '', '店code', 0,'店code'],
                ],
            ],
        ],
    ],
    '1.1.197' => [
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['id','menu_name', 'fid', 'menu_code', 'menu_url', 'menu_icon','status', 'sort'],
                'value' => [
                    ['2007','右键-标记有效', 2, 'menu1546854995', '/crm/signValid', '',0, 30],
                    ['2008','转介绍渠道花费', 8, 'menu1547192861', '/crm/Setting/channelFee_zjs',NULL,0, 20],
                    ['2009','预约进店查询', 134, 'menu1549940502', '/crm/Customer/yjdSearch',NULL,1, 1],
                ],
            ],
        ],
    ],
    '1.1.198' => [
        [
            'type' => 'column',
            'name' => 'c_customer_order',
            'fields' => [
                // 拍照店面
                ['name' => 'photo_shop_code', 'type' => 'varchar', 'length' => 200, 'default' => null, 'is_null' => true],
                ['name' => 'photo_shop_name', 'type' => 'varchar', 'length' => 200, 'default' => null, 'is_null' => true],
            ],
        ],
    ],
    '1.1.199' => [
        [
            'type' => 'data',
            'name' => 'api_list',
            'unique'=>'hash',
            'fields' => [
                'field' => ['apiName', 'apiUrl', 'app_id', 'hash', 'accessToken', 'needLogin', 'status', 'method', 'info'],
                'value' => [ /*要插入的字段对应的数据*/
                    [' 获取渠道名称列表', 'Customer/getAllChannel', 5, '5c3ff3eb4ef48', 0, 0, 1, 1,'返回所有渠道名称（包含一二三级）'],
                ],
            ],
        ],
    ],
    '1.1.200' => [
        [
            'type' => 'column',
            'name' => 'c_customer_order',
            'fields' => [
                // 进店表id
                ['name' => 'into_id', 'type' => 'int', 'length' => 11, 'default' => null, 'is_null' => true],
            ],
        ],
    ],
    // 1025
    '1.1.201' => [
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['id','menu_name', 'fid', 'menu_code', 'menu_url', 'menu_icon','status', 'sort'],
                'value' => [
                    ['2010','查看一年内客资', 34, 'menu1546854888', '', '',0, 3],
                ],
            ],
        ],
    ],
    '1.1.202' => [
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['id','menu_name', 'fid', 'menu_code', 'menu_url', 'menu_icon','status', 'sort'],
                'value' => [
                    ['2011','奖金标记', 61, 'menu1546854777', '', '',0, 22],
                ],
            ],
        ],
    ],
    '1.1.203' => [
        [
            'type' => 'column',
            'name' => 'c_customer_from',
            'fields' => [
                // 奖金标记状态 1：已发；2：未发
                ['name' => 'bonus', 'type' => 'tinyint', 'length' => 2, 'default' => 2, 'is_null' => true],
            ],
        ],
    ],
    '1.1.204' => [
        [
            'type' => 'data',
            'name' => 'api_app',
            'unique'=>'app_id',
            'fields' => [
                'field' => ['id','app_id', 'app_secret', 'app_name', 'app_status', 'app_type', 'app_info'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['7','76014592', 'oUWKYeqCEojOvbmsynvWTctJSAVeoMZv', 'VIP接口', 1, 1,'VIP接口'],
                ],
            ],
        ],
        [
            'type' => 'data',
            'name' => 'api_list',
            'unique'=>'hash',//排重列，会按此列进行排重，如果重复，则跳过对应的数据行
            'fields' => [
                'field' => ['apiName', 'apiUrl', 'app_id', 'hash', 'accessToken', 'needLogin', 'status', 'method', 'info'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['客资列表', 'Vip/getCustomerList', 6, '5c6a8c262b8e0', 0, 0, 1, 1,'查询客资列表'],
                ],
            ],
        ],
        [
            'type' => 'data',
            'name' => 'api_fields',
            'fields' => [
                'field' => ['fieldName', 'hash','dataType', 'isMust', 'range', 'info', 'showName'],
                'value' => [
                    // 查询客资列表  Vip/getCustomerList
                    ['brandclass_id', '5c6a8c262b8e0', 1, 0, '事业部ID', '事业部ID', 'brandclass_id'],
                    ['search_time', '5c6a8c262b8e0', 2, 0, '查询的时间类型（dj_day）等', '查询的时间类型（dj_day）等', 'search_time'],
                    ['start', '5c6a8c262b8e0', 1, 0, '开始时间', '开始时间', 'start'],
                    ['end', '5c6a8c262b8e0', 1, 0, '结束时间', '结束时间', 'end'],
                ],
            ],
        ],
        [
        	'type' => 'column',
            'name' => 'c_excel_import',
            'fields' => [
                // 导入时选择的归属店，也可能是默认的归属店
                ['name' => 'belong_shop_code', 'type' => 'varchar', 'length' => 150, 'default' => NULL, 'is_null' => true],
                ['name' => 'belong_shop_name', 'type' => 'varchar', 'length' => 150, 'default' => NULL, 'is_null' => true],
            ],
        ]
    ],
    '1.1.205' => [
        [
            'type' => 'column',
            'name' => 'c_staff_group',
            'fields' => [
                // 小组管理员
                ['name' => 'admin', 'type' => 'longtext', 'default' => NULL, 'is_null' => true],
            ],
        ],
    ],
    '1.1.206' => [
        [ /*第一个改动*/
            'type' => 'table',
            'name' => 'l_login_log',
            'fields' => [
                ['name' => 'id', 'type' => 'int', 'default' => 'AUTO_INCREMENT', 'is_null' => false],
                //是否5天自动登录  1：是；2：否
                ['name' => 'is_five', 'type' => 'tinyint', 'length' => 1,'default'=>2, 'is_null' => true],
                ['name' => 'staff_id', 'type' => 'int', 'length' => 11, 'is_null' => true],
                ['name' => 'staff_name', 'type' => 'varchar', 'length' => 50, 'default' =>NULL, 'is_null' => true],
                ['name' => 'last_login_ip', 'type' => 'varchar', 'length' => 50, 'default' =>NULL, 'is_null' => true],
                ['name' => 'last_login_time', 'type' => 'datetime', 'default' =>NULL, 'is_null' => true],
                ['name' => 'login_out_time', 'type' => 'datetime', 'default' =>NULL, 'is_null' => true],
                ['name' => 'session_id', 'type' => 'varchar','length'=>100, 'default' => NULL, 'is_null' => true],
            ],
        ],
    ],
    '1.1.207' => [
        [ /*第一个改动*/
            'type' => 'table',
            'name' => 'd_ds_channel_ld',
            'fields' => [
                ['name' => 'id', 'type' => 'int', 'default' => 'AUTO_INCREMENT', 'is_null' => false],
                ['name' => 'shop_code', 'type' => 'varchar', 'length' => 100, 'default' =>NULL, 'is_null' => true],
                ['name' => 'shop_name', 'type' => 'varchar', 'length' => 100, 'default' =>NULL, 'is_null' => true],
                ['name' => 'brandclass_id', 'type' => 'int', 'length' => 11, 'default' =>NULL, 'is_null' => true],
                ['name' => 'brandclass', 'type' => 'varchar', 'length' => 100, 'default' =>NULL, 'is_null' => true],
                ['name' => 'time', 'type' => 'date', 'default' =>NULL, 'is_null' => true],
                ['name' => 'cost', 'type' => 'varchar', 'length' => 200, 'default' =>NULL, 'is_null' => true],
                ['name' => 'mkz', 'type' => 'varchar', 'length' => 100, 'default' =>NULL, 'is_null' => true],
                ['name' => 'channel_id', 'type' => 'int', 'length' => 11,'default'=>null, 'is_null' => true],
                ['name' => 'channel_name', 'type' => 'varchar', 'length' => 10, 'default' =>NULL, 'is_null' => true],
                ['name' => 'channel_info_id', 'type' => 'int', 'length' => 11,'default'=>null, 'is_null' => true],
                ['name' => 'channel_info_name', 'type' => 'varchar', 'length' => 10, 'default' =>NULL, 'is_null' => true],
                ['name' => 'valid', 'type' => 'varchar', 'length' => 100, 'default' =>NULL, 'is_null' => true],
                ['name' => 'dd', 'type' => 'varchar', 'length' => 100, 'default' =>NULL, 'is_null' => true],
                ['name' => 'tel', 'type' => 'varchar', 'length' => 100, 'default' =>NULL, 'is_null' => true],
                ['name' => 'jd', 'type' => 'varchar', 'length' => 100, 'default' =>NULL, 'is_null' => true],
                ['name' => 'order', 'type' => 'varchar', 'length' => 100, 'default' =>NULL, 'is_null' => true],
                ['name' => 'fact', 'type' => 'varchar', 'length' => 100, 'default' =>NULL, 'is_null' => true],
                ['name' => 'amount', 'type' => 'varchar', 'length' => 100, 'default' =>NULL, 'is_null' => true],
                ['name' => 'amountAVG', 'type' => 'varchar', 'length' => 100, 'default' =>NULL, 'is_null' => true],
                ['name' => 'validRate', 'type' => 'varchar', 'length' => 100, 'default' =>NULL, 'is_null' => true],
                ['name' => 'jdRate', 'type' => 'varchar', 'length' => 100, 'default' =>NULL, 'is_null' => true],
                ['name' => 'orderRate', 'type' => 'varchar', 'length' => 100, 'default' =>NULL, 'is_null' => true],
                ['name' => 'orderValidRate', 'type' => 'varchar', 'length' => 100, 'default' =>NULL, 'is_null' => true],
                ['name' => 'mkzCost', 'type' => 'varchar', 'length' => 100, 'default' =>NULL, 'is_null' => true],
                ['name' => 'validCost', 'type' => 'varchar', 'length' => 100, 'default' =>NULL, 'is_null' => true],
                ['name' => 'orderCost', 'type' => 'varchar', 'length' => 100, 'default' =>NULL, 'is_null' => true],
                ['name' => 'roi', 'type' => 'varchar', 'length' => 100, 'default' =>NULL, 'is_null' => true],
            ],
        ],
        [ /*错误日志表，执行的错误原因写入此表*/
            'type' => 'table',
            'name' => 'l_error_log',
            'fields' => [
                ['name' => 'id', 'type' => 'int', 'default' => 'AUTO_INCREMENT', 'is_null' => false],
                //操作
                ['name' => 'action', 'type' => 'varchar','length'=>100, 'default' =>NULL, 'is_null' => true],
                //错误原因
                ['name' => 'error_reason', 'type' => 'text', 'default' =>NULL, 'is_null' => true],
                ['name' => 'create_time', 'type' => 'datetime', 'default' =>NULL, 'is_null' => true],
            ],
        ],
    ],
    '1.1.208' => [
        [ /*第一个改动*/
            'type' => 'table',
            'name' => 'd_wx_group',
            'fields' => [
                ['name' => 'id', 'type' => 'int', 'default' => 'AUTO_INCREMENT', 'is_null' => false],
                ['name' => 'staff_name', 'type' => 'varchar', 'length' => 100, 'default' =>NULL, 'is_null' => true],
                ['name' => 'group_name', 'type' => 'varchar', 'length' => 100, 'default' =>NULL, 'is_null' => true],
                ['name' => 'shop_code', 'type' => 'varchar', 'length' => 100, 'default' =>NULL, 'is_null' => true],
                ['name' => 'shop_name', 'type' => 'varchar', 'length' => 100, 'default' =>NULL, 'is_null' => true],
                ['name' => 'brandclass_id', 'type' => 'int', 'length' => 11, 'default' =>NULL, 'is_null' => true],
                ['name' => 'brandclass', 'type' => 'varchar', 'length' => 100, 'default' =>NULL, 'is_null' => true],
                ['name' => 'time', 'type' => 'date', 'default' =>NULL, 'is_null' => true],
                ['name' => 'mkz', 'type' => 'int', 'length' => 11, 'default' =>NULL, 'is_null' => true],
                ['name' => 'jr', 'type' => 'int', 'length' => 11,'default'=>null, 'is_null' => true],
                ['name' => 'valid', 'type' => 'int', 'length' => 11, 'default' =>NULL, 'is_null' => true],
                ['name' => 'dd', 'type' => 'int', 'length' => 11, 'default' =>NULL, 'is_null' => true],
                ['name' => 'wx', 'type' => 'int', 'length' => 11, 'default' =>NULL, 'is_null' => true],
                ['name' => 'validRate', 'type' => 'varchar', 'length' => 100, 'default' =>NULL, 'is_null' => true],
                ['name' => 'wxRate', 'type' => 'varchar', 'length' => 100, 'default' =>NULL, 'is_null' => true],
                ['name' => 'ddRate', 'type' => 'varchar', 'length' => 100, 'default' =>NULL, 'is_null' => true],
                ['name' => 'notel', 'type' => 'int', 'length' => 11, 'default' =>NULL, 'is_null' => true],
                ['name' => 'zhaunTel', 'type' => 'int', 'length' => 11, 'default' =>NULL, 'is_null' => true],
                ['name' => 'zhaunRate', 'type' => 'varchar', 'length' => 100, 'default' =>NULL, 'is_null' => true],
                ['name' => 'tel', 'type' => 'int', 'length' => 11, 'default' =>NULL, 'is_null' => true],
                ['name' => 'jd', 'type' => 'int', 'length' => 11, 'default' =>NULL, 'is_null' => true],
                ['name' => 'jdRate', 'type' => 'varchar', 'length' => 100, 'default' =>NULL, 'is_null' => true],
                ['name' => 'order', 'type' => 'int', 'length' => 11, 'default' =>NULL, 'is_null' => true],
                ['name' => 'orderRate', 'type' => 'varchar', 'length' => 100, 'default' =>NULL, 'is_null' => true],
                ['name' => 'loss', 'type' => 'int', 'length' => 11, 'default' =>NULL, 'is_null' => true],
                ['name' => 'lossRate', 'type' => 'varchar', 'length' => 100, 'default' =>NULL, 'is_null' => true],
                ['name' => 'fact', 'type' => 'varchar', 'length' => 100, 'default' =>NULL, 'is_null' => true],
                ['name' => 'amount', 'type' => 'varchar', 'length' => 100, 'default' =>NULL, 'is_null' => true],
                //余款
                ['name' => 'yk', 'type' => 'varchar', 'length' => 100, 'default' =>NULL, 'is_null' => true],
                //定金
                ['name' => 'dj', 'type' => 'varchar', 'length' => 100, 'default' =>NULL, 'is_null' => true],
                //总客资成单率
                ['name' => 'orderMkzRate', 'type' => 'varchar', 'length' => 100, 'default' =>NULL, 'is_null' => true],
                //有效客资成单率
                ['name' => 'orderValidRate', 'type' => 'varchar', 'length' => 100, 'default' =>NULL, 'is_null' => true],
            ],
        ],
    ],
    '1.1.209' => [
        [
            'type' => 'column',
            'name' => 'l_login_log',
            'fields' => [
                ['name' => 'session_id', 'type' => 'varchar','length'=>100, 'default' => NULL, 'is_null' => true],
            ],
        ],
        [
            //增加进店码唯一索引
            'type'=>'sql',
            'sql'=>'ALTER TABLE `c_customer_from` ADD UNIQUE INDEX `code` (`code`);',
        ],
    ],
    '1.1.211' => [
        [ /*进店表*/
            'type' => 'table',
            'name' => 'c_customer_intostore_1',
            'fields' => [
                ['name' => 'id', 'type' => 'int', 'default' => 'AUTO_INCREMENT', 'is_null' => false],
                ['name' => 'cid', 'type' => 'int', 'length' => 11, 'default' =>NULL, 'is_null' => true],
                ['name' => 'yjd_day', 'type' => 'datetime', 'default' =>NULL, 'is_null' => true],
                ['name' => 'syjd_day', 'type' => 'datetime', 'default' =>NULL, 'is_null' => true],
                //进店备注
                ['name' => 'intostore_remark', 'type' => 'text', 'default' => NULL, 'is_null' => true],
                //意向店面
                ['name' => 'consulation_shop_code', 'type' => 'varchar', 'length' => 100, 'default' =>NULL, 'is_null' => true],
                ['name' => 'consulation_shop_name', 'type' => 'varchar', 'length' => 100, 'default' =>NULL, 'is_null' => true],
                //接待人
                ['name' => 'reception_id', 'type' => 'int', 'length' => 11, 'default' =>NULL, 'is_null' => true],
                ['name' => 'reception_name', 'type' => 'varchar', 'length' => 100, 'default' =>NULL, 'is_null' => true],
                //分配时间
                ['name' => 'fp_rec_time', 'type' => 'datetime', 'default' =>NULL, 'is_null' => true],
                //操作人
                ['name' => 'operate_id', 'type' => 'int', 'length' => 11, 'default' =>NULL, 'is_null' => true],
                ['name' => 'operate_name', 'type' => 'varchar', 'length' => 100, 'default' =>NULL, 'is_null' => true],
                //标记
                ['name' => 'op_signinfo', 'type' => 'text', 'default' =>NULL, 'is_null' => true],
                //标记时间
                ['name' => 'op_signday', 'type' => 'datetime', 'default' =>NULL, 'is_null' => true],
                //系统自动标记（进店未成交）1：未流失；2：已流失；默认：1
                ['name' => 'sys_loss', 'type' => 'tinyint', 'length' => 2, 'default' =>1, 'is_null' => true],
                ['name' => 'loss_reason', 'type' => 'text', 'default'=>null, 'is_null' => true],
                ['name' => 'loss_time', 'type' => 'datetime', 'default' =>NULL, 'is_null' => true],
                //进店状态：1未进店；2进店进客；3进店非进客；4：邀约未进店（爽约）5：进店未成交（流失）
                ['name' => 'is_intostore', 'type' => 'tinyint', 'length' => 2, 'default' =>1, 'is_null' => true],
                //订单状态：1 已成交；2 未成交；3 已定金；4 本单作废
                ['name' => 'is_success', 'type' => 'tinyint', 'length' => 2, 'default' =>2, 'is_null' => true],
                //礼品
                ['name' => 'giftinfo', 'type' => 'varchar', 'length' => 200, 'default' =>null, 'is_null' => true],
                //礼品成本
                ['name' => 'costs', 'type' => 'varchar', 'length' => 200, 'default' =>null, 'is_null' => true],
                //状态（1：正常；2：取消预约，默认：1）,99:删除
                ['name' => 'status', 'type' => 'tinyint', 'length' => 2, 'default' =>1, 'is_null' => true],
                //是否回门（1：正常邀约；2：回门客资；默认：1）
                ['name' => 'reback', 'type' => 'tinyint', 'length' => 2, 'default' =>1, 'is_null' => true],
                ['name' => 'create_time', 'type' => 'datetime', 'default' =>NULL, 'is_null' => true],
                ['name' => 'update_time', 'type' => 'datetime', 'default' =>NULL, 'is_null' => true],
                ['name' => 'intostore_note', 'type' => 'text', 'default' =>NULL, 'is_null' => true],
            ],
        ],
        [
            'type' => 'table',
            'name' => 'l_yjd_ctrl',
            'fields' => [
                ['name' => 'id', 'type' => 'int', 'default' => 'AUTO_INCREMENT', 'is_null' => false],
                ['name' => 'shop_code', 'type' => 'varchar','length'=>150, 'default' => NULL, 'is_null' => true],
                ['name' => 'shop_name', 'type' => 'varchar','length'=>150, 'default' => NULL, 'is_null' => true],
                //使用日期
                ['name' => 'use_day', 'type' => 'date', 'default' =>NULL, 'is_null' => true],
                ['name' => 'week', 'type' => 'varchar','length'=>150, 'default' => NULL, 'is_null' => true],
                ['name' => 'num', 'type' => 'int','length'=>11, 'default' => NULL, 'is_null' => true],
                //时间区间
                ['name' => 'time_area', 'type' => 'varchar','length'=>150, 'default' => NULL, 'is_null' => true],
                ['name' => 'start', 'type' => 'varchar','length'=>150, 'default' => NULL, 'is_null' => true],
                ['name' => 'end', 'type' => 'varchar','length'=>150, 'default' => NULL, 'is_null' => true],
                ['name' => 'sort', 'type' => 'int','length'=>11, 'default' => NULL, 'is_null' => true],
                ['name' => 'create_time', 'type' => 'datetime', 'default' =>NULL, 'is_null' => true],
                ['name' => 'update_time', 'type' => 'datetime', 'default' =>NULL, 'is_null' => true],
                //1：未删除；2：已删除
                ['name' => 'is_del', 'type' => 'tinyint', 'default' =>1, 'is_null' => true],
            ],
        ],
    ],
    '1.1.212' => [
        [
            'type' => 'column',
            'name' => 's_reminditemset',
            'fields' => [
                ['name' => 'send_method', 'type' => 'varchar','length'=>100, 'default' => NULL, 'is_null' => true],
                ['name' => 'send_receive', 'type' => 'text','default' => NULL, 'is_null' => true],
                ['name' => 'brandclass_id', 'type' => 'int','length'=>11, 'default' => NULL, 'is_null' => true],
                ['name' => 'brandclass', 'type' => 'varchar','length'=>100,'default' => NULL, 'is_null' => true],
            ],
        ],
    ],
    '1.1.218' => [
        [
            'type' => 'column',
            'name' => 'c_salestrackinginfo',
            'fields' => [
                //功能选择（追踪类型）
                ['name' => 'no_track', 'type' => 'varchar','length'=>20, 'default' => NULL, 'is_null' => true],
            ],
        ],
    ],
    '1.1.219' => [
        [ /*人员渠道匹配*/
            'type' => 'table',
            'name' => 'c_staff_trench_mate',
            'fields' => [
                ['name' => 'staff_id', 'type' => 'int', 'length' => 11, 'default' => NULL, 'is_null' => true],
                ['name' => 'staff_name', 'type' => 'varchar', 'length' => 50, 'default' => NULL, 'is_null' => true],
                //渠道 以逗号隔开
                ['name' => 'trench', 'type' => 'varchar', 'length' => 500, 'default' => NULL, 'is_null' => true],
                ['name' => 'shop_code', 'type' => 'varchar', 'length' => 100, 'default' =>NULL, 'is_null' => true],
                //操作时间
                ['name' => 'time', 'type' => 'datetime', 'default' =>NULL, 'is_null' => true],
            ],
        ],
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['id','menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'], /*要插入的字段*/
                'value' => [ /*要插入的字段对应的数据*/
                    ['2012','人员绑定渠道', 6, 'menu1554174733', '/crm/Setting/staffTrenchMate_List', 1, 0],
                ],
            ],
        ],
    ],
    '1.1.225' => [
        [ /*加 手机地址 默认配置 0：中国；1：香港*/
            'type' => 'data',
            'name' => 'c_sysconfig',
            'fields' => [
                'field' => ['ckey', 'cvalue'], /*要插入的字段*/
                'value' => [ /*要插入的字段对应的数据*/
                    ['tel_address_grant', 0],
                ],
            ],
        ],
    ],
    '1.1.226' => [
        [
            'type' => 'column',
            'name' => 'c_customer_from',
            'fields' => [
                // 成交奖金 状态 1：已发；2：未发
                ['name' => 'bonus_deal', 'type' => 'tinyint', 'length' => 2, 'default' => 2, 'is_null' => true],
            ],
        ],
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['id','menu_name', 'fid', 'menu_code', 'menu_url', 'menu_icon','status', 'sort'],
                'value' => [
                    ['2013','成交奖金', 61, 'menu1546854778', '', '',0, 22],
                ],
            ],
        ],
    ],
    '1.1.230' => [
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['id','menu_name', 'fid', 'menu_code', 'menu_url', 'menu_icon','status', 'sort'],
                'value' => [
                    ['2014','修改加好友时间', 61, 'menu1513409630', '', '',1, 9],
                ],
            ],
        ],
    ],
    '1.1.231'=>[
        [
            'type' => 'data',
            'name' => 'api_list',
            'unique'=>'hash',
            'fields' => [
                'field' => ['apiName', 'apiUrl', 'app_id', 'hash', 'accessToken', 'needLogin', 'status', 'method', 'info'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['获取当日登记客资数，预约数量', 'Intostore/getCustomerNumber', 8, '5cb2d1cd2ba28', 1, 0, 1, 1,''],
                ],
            ],
        ],
        [
            'type' => 'data',
            'name' => 'api_list',
            'unique'=>'hash',
            'fields' => [
                'field' => ['apiName', 'apiUrl', 'app_id', 'hash', 'accessToken', 'needLogin', 'status', 'method', 'info'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['获取店面进客数量', 'Intostore/getIntoNumber', 8, '5cb2d6a633ac7', 1, 0, 1, 1,''],
                ],
            ],
        ],
        [
            'type' => 'data',
            'name' => 'api_fields',
            'fields' => [
                'field' => ['fieldName', 'hash','dataType', 'isMust', 'range', 'info', 'type', 'showName'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['shop_code', '5cb2d1cd2ba28', 2, 1, '', '店code', 0,'店code'],
                ],
            ],
        ],
        [
            'type' => 'data',
            'name' => 'api_fields',
            'fields' => [
                'field' => ['fieldName', 'hash','dataType', 'isMust', 'range', 'info', 'type', 'showName'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['shop_code', '5cb2d6a633ac7', 2, 1, '', '店code', 0,'店code'],
                    ['start', '5cb2d6a633ac7', 2, 0, '', '开始时间', 0,'开始时间'],
                    ['end', '5cb2d6a633ac7', 2, 0, '', '接收时间', 0,'接收时间'],
                ],
            ],
        ],
    ],
    '1.1.232' => [
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['id','menu_name', 'fid', 'menu_code', 'menu_url', 'menu_icon','status', 'sort'],
                'value' => [
                    ['2015','修改手机号', 61, 'menu1555556591', '', '',1, 90],
                ],
            ],
        ],
    ],
    '1.1.233' => [
        [ /*第一个改动*/
            'type' => 'table',
            'name' => 's_label_cat',
            'fields' => [
                ['name' => 'id', 'type' => 'int', 'default' => 'AUTO_INCREMENT', 'is_null' => false],
                //状态：1：删除；2:未删除
                ['name' => 'status', 'type' => 'tinyint', 'length' => 1,'default'=>2, 'is_null' => true],
                //分类名称
                ['name' => 'cat_name', 'type' => 'varchar', 'length' => 50, 'default' =>NULL, 'is_null' => true],
                ['name' => 'brandclass_id', 'type' => 'int', 'length' => 11, 'default' =>NULL, 'is_null' => true],
                ['name' => 'brandclass', 'type' => 'varchar','length' => 150, 'default' =>NULL, 'is_null' => true],
            ],
        ],
        [ /*第二个改动*/
            'type' => 'table',
            'name' => 's_label',
            'fields' => [
                ['name' => 'id', 'type' => 'int', 'default' => 'AUTO_INCREMENT', 'is_null' => false],
                //状态：1：删除；2:未删除
                ['name' => 'is_delete', 'type' => 'tinyint', 'length' => 1,'default'=>2, 'is_null' => true],
                //分类名称
                ['name' => 'label_cat_id', 'type' => 'int', 'length' => 11, 'default' =>NULL, 'is_null' => true],
                ['name' => 'label_cat_name', 'type' => 'varchar', 'length' => 150, 'default' =>NULL, 'is_null' => true],
                ['name' => 'label_name', 'type' => 'varchar', 'length' => 255, 'default' =>NULL, 'is_null' => true],
                ['name' => 'brandclass_id', 'type' => 'int', 'length' => 11, 'default' =>NULL, 'is_null' => true],
                ['name' => 'brandclass', 'type' => 'varchar','length' => 255, 'default' =>NULL, 'is_null' => true],
                ['name' => 'create_time', 'type' => 'datetime', 'default' =>NULL, 'is_null' => true],
                ['name' => 'update_time', 'type' => 'datetime', 'default' =>NULL, 'is_null' => true],
            ],
        ],
        [
            'type' => 'data',
            'name' => 's_menu',
            'fields' => [
                'field' => ['id','menu_name', 'fid', 'menu_code', 'menu_url', 'menu_icon','status', 'sort'],
                'value' => [
                    ['2016','标签设定', 61, 'menu1555746079', '/crm/Setting/labelSetting', '',1, 50],
                ],
            ],
        ],
    ],
    '1.1.234' => [
        [
            'type' => 'column',
            'name' => 'c_customerinfo',
            'fields' => [
                // 客资标签
                ['name' => 'customer_label', 'type' => 'text',  'default' => null, 'is_null' => true],
            ],
        ],
    ],
    '1.1.235' => [
        [
            'type' => 'data',
            'name' => 's_menu',
            'unique'=>'menu_code',//排重列，会按此列进行排重，如果重复，则跳过对应的数据行
            'fields' => [
                'field' => ['id','menu_name', 'fid', 'menu_code', 'menu_url', 'menu_icon','status', 'sort'],
                'value' => [
                    ['2017','查看大屏', 5, 'menu1556162726', '', '',0, 95],
                ],
            ],
        ],
    ],
    '1.1.236'=>[
        [
            'type' => 'data',
            'name' => 'api_list',
            'unique'=>'hash',
            'fields' => [
                'field' => ['apiName', 'apiUrl', 'app_id', 'hash', 'accessToken', 'needLogin', 'status', 'method', 'info'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['修改实际进店时间', 'Intostore/editSyjd', 8, '5ce3624dca72a', 1, 0, 1, 1,''],
                ],
            ],
        ],
        [
            'type' => 'data',
            'name' => 'api_fields',
            'fields' => [
                'field' => ['fieldName', 'hash','dataType', 'isMust', 'range', 'info', 'type', 'showName'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['id', '5ce3624dca72a', 1, 1, '', '进客id', 0,'time'],
                    ['time', '5ce3624dca72a', 1, 1, '', '实际进店时间的时分秒，格式：143035', 0,'id'],
                    ['staff_id', '5ce3624dca72a', 1, 1, '', '操作人id', 0,'staff_id'],
                    ['staff_name', '5ce3624dca72a', 2, 1, '', '操作人', 0,'staff_name'],
                ],
            ],
        ],
        [
            'type' => 'column',
            'name' => 'c_customer_order',
            'fields' => [
                // 客户分区
                ['name' => 'customer_area', 'type' => 'varchar', 'length' => 50,'default' => null,'is_null' => true],
            ],
        ],
    ],
    '1.1.238' => [
        [ /* 追踪人 渠道 花费表*/
            'type' => 'table',
            'name' => 'c_staff_channel_cost',
            'fields' => [
                ['name' => 'staff_id', 'type'=> 'int', 'length' => 11,'is_null' => true],
				['name' => 'staff_name', 'type'=> 'varchar', 'length' => 100,'is_null' => true],
				['name' => 'group_id', 'type'=> 'int', 'length' => 11,'is_null' => true],
				['name' => 'group_name', 'type'=> 'varchar', 'length' => 100,'is_null' => true],
				['name' => 'department_id', 'type'=> 'int', 'length' => 11,'is_null' => true],
				['name' => 'department_name', 'type'=> 'varchar', 'length' => 100,'is_null' => true],
				['name' => 'shop_code', 'type'=> 'varchar', 'length' => 100,'is_null' => true],
				['name' => 'shop_name', 'type'=> 'varchar', 'length' => 100,'is_null' => true],
				['name' => 'day', 'type' => 'date', 'default' =>null, 'is_null' => true],
				['name' => 'channel_id', 'type'=> 'int', 'length' => 11,'is_null' => true],
				['name' => 'channel_name', 'type'=> 'varchar', 'length' => 100,'is_null' => true],
				['name' => 'c_num', 'type'=> 'int', 'length' => 11,'is_null' => true],
				['name' => 'c_all_num', 'type'=> 'int', 'length' => 11,'is_null' => true],
				['name' => 'cost', 'type' => 'decimal', 'length' => '12,4','default' => null, 'is_null' => true],
				['name' => 'all_cost', 'type' => 'decimal', 'length' => '12,4','default' => null, 'is_null' => true],
            ],
        ],
    ],
    '1.1.239' => [
        [
            'type' => 'data',
            'name' => 's_menu',
            'unique'=>'menu_code',//排重列，会按此列进行排重，如果重复，则跳过对应的数据行
            'fields' => [
                'field' => ['id','menu_name', 'fid', 'menu_code', 'menu_url', 'menu_icon','status', 'sort'],
                'value' => [
                    ['2018','坐席配置',0, 'menu1561718791', '', '',0, 1],
                ],
            ],
        ],
    ],
    '1.1.240'=>[
        [
            'type' => 'data',
            'name' => 'api_list',
            'unique'=>'hash',
            'fields' => [
                'field' => ['apiName', 'apiUrl', 'app_id', 'hash', 'accessToken', 'needLogin', 'status', 'method', 'info'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['新增追踪记录', 'Intostore/addCustomerTrackInfo', 8, '5d80a10dd8bf8', 1, 0, 1, 1,'新增追踪记录'],
                ],
            ],
        ],
        [
            'type' => 'data',
            'name' => 'api_fields',
            'fields' => [
                'field' => ['fieldName', 'hash','dataType', 'isMust', 'range', 'info', 'type', 'showName'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['cid', '5d80a10dd8bf8', 1, 1, '客资id', '客资id', 0,'cid'],
                    ['staffname', '5d80a10dd8bf8', 2, 1, '操作人', '操作人', 0,'staffname'],
                    ['trackinfo', '5d80a10dd8bf8', 2, 1, '要添加的追踪信息（json数组，必须与追踪记录表，字段名一致）', '要添加的追踪信息（json数组，必须与追踪记录表，字段名一致）', 0,'trackinfo'],
                ],
            ],
        ],
    ],
    '1.1.241'=>[
        [
            'type' => 'data',
            'name' => 'api_list',
            'unique'=>'hash',
            'fields' => [
                'field' => ['apiName', 'apiUrl', 'app_id', 'hash', 'accessToken', 'needLogin', 'status', 'method', 'info'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['标记邀约未进店', 'Intostore/notIntostore', 8, '5d9c671562ed0', 1, 0, 1, 1,'标记邀约未进店'],
                ],
            ],
        ],
        [
            'type' => 'data',
            'name' => 'api_fields',
            'fields' => [
                'field' => ['fieldName', 'hash','dataType', 'isMust', 'range', 'info', 'type', 'showName'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['id', '5d9c671562ed0', 1, 1, '进客id', '进客id', 0,'id'],
                    ['remark', '5d9c671562ed0', 2, 0, '未进店备注', '未进店备注', 0,'remark'],
                    ['staff_id', '5d9c671562ed0', 1, 1, '操作人id', '操作人id', 0,'staff_id'],
                    ['staff_name', '5d9c671562ed0', 2, 1, '操作人', '操作人', 0,'staff_name'],
                ],
            ],
        ],
    ],
    '1.1.242'=>[
        [
            'type' => 'data',
            'name' => 'api_list',
            'unique'=>'hash',
            'fields' => [
                'field' => ['apiName', 'apiUrl', 'app_id', 'hash', 'accessToken', 'needLogin', 'status', 'method', 'info'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['新增追踪', 'Intostore/addIntoTrackInfo', 8, '5d9f0c0f3c5a0', 0, 0, 1, 1,'新增追踪'],
                ],
            ],
        ],
        [
            'type' => 'data',
            'name' => 'api_fields',
            'fields' => [
                'field' => ['fieldName', 'hash','dataType', 'isMust', 'range', 'info', 'type', 'showName'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['id', '5d9f0c0f3c5a0', 1, 1, '进客id', '进客id', 0,'id'],
                    ['remark', '5d9f0c0f3c5a0', 2, 0, '未进店备注', '未进店备注', 0,'remark'],
                    ['staff_id', '5d9f0c0f3c5a0', 1, 1, '操作人id', '操作人id', 0,'staff_id'],
                    ['staff_name', '5d9f0c0f3c5a0', 2, 1, '操作人', '操作人', 0,'staff_name'],
                ],
            ],
        ],
    ],
    '1.1.243'=>[
        [
            'type' => 'data',
            'name' => 's_menu',
            'unique'=>'menu_code',
            'fields' => [
                'field' => ['id','menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['2019','签到详情', '9','menu1571127958', '/crm/Logs/getRuleStaff', 1, 0],
                ],
            ],
        ],
    ],
    '1.1.245'=>[
        [
            'type' => 'data',
            'name' => 's_menu',
            'unique'=>'menu_code',
            'fields' => [
                'field' => ['id','menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['2020','批量待定', '61','menu1571722592', '/crm/Customer/customerMoreDd', 1, 0],
                ],
            ],
        ],
    ],
    '1.1.246'=>[
        [
            'type' => 'data',
            'name' => 's_menu',
            'unique'=>'menu_code',
            'fields' => [
                'field' => ['id','menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['2021','右键退单', '2','menu1572077805', '/crm/Customer/delOrder', 0, 3],
                ],
            ],
        ],
    ],
    '1.1.247'=>[
        [
            'type' => 'data',
            'name' => 'api_list',
            'unique'=>'hash',
            'fields' => [
                'field' => ['apiName', 'apiUrl', 'app_id', 'hash', 'accessToken', 'needLogin', 'status', 'method', 'info'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['ERP预约进店', 'Intostore/erpYjd', 8, '5db8046be13ae', 1, 0, 1, 1,'ERP预约进店'],
                ],
            ],
        ],
        [
            'type' => 'data',
            'name' => 'api_fields',
            'fields' => [
                'field' => ['fieldName', 'hash','dataType', 'isMust', 'range', 'info', 'type', 'showName'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['into_id', '5db8046be13ae', 1, 1, '进客id', '进客id', 0,'into_id'],
                    ['yjd_day', '5db8046be13ae', 1, 1, '格式：YY-mm-dd HH:ii:ss', '预约时间', 0,'yjd_day'],
                    ['consulation_shop_code', '5db8046be13ae', 2, 1, '预约店面code', '预约店面code', 0,'consulation_shop_code'],
                    ['consulation_shop', '5db8046be13ae', 2, 1, '预约店面', '预约店面', 0,'consulation_shop'],
                    ['reception_id', '5db8046be13ae', 1, 1, '门市id', '门市d', 0,'reception_id'],
                    ['reception_name', '5db8046be13ae', 2, 1, '门市', '门市', 0,'reception_name'],
                    ['staff_id', '5db8046be13ae', 1, 1, '操作人id', '操作人id', 0,'staff_id'],
                    ['staff_name', '5db8046be13ae', 2, 1, '操作人', '操作人', 0,'staff_name'],
                    ['intostore_note', '5db8046be13ae', 2, 0, '进店备注', '进店备注', 0,'intostore_note'],
                ],
            ],
        ],
    ],
    '1.1.248' => [
        [
            'type' => 'column',
            'name' => 'c_customerinfo',
            'fields' => [
                // 分配人员部门ID
                ['name' => 'fp_department_id', 'type' => 'int', 'length' => 11, 'default' => null, 'is_null' => true],
                // 分配人员部门
                ['name' => 'fp_department_name', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
                // 登记人员部门
                ['name' => 'dj_department_name', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
                // 追踪人员部门
                ['name' => 'sales_department_name', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
            ],
        ],
    ],
    '1.1.249'=>[
        [
            'type' => 'data',
            'name' => 'api_list',
            'unique'=>'hash',
            'fields' => [
                'field' => ['apiName', 'apiUrl', 'app_id', 'hash', 'accessToken', 'needLogin', 'status', 'method', 'info'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['ERP绑定订单', 'Intostore/bindOrder', 8, '5dbff21eef745', 1, 0, 1, 1,'ERP绑定订单'],
                ],
            ],
        ],
        [
            'type' => 'data',
            'name' => 'api_fields',
            'fields' => [
                'field' => ['fieldName', 'hash','dataType', 'isMust', 'range', 'info', 'type', 'showName'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['into_id', '5dbff21eef745', 1, 1, '', '进客id', 0,'into_id'],
                    ['order_sn', '5dbff21eef745', 2, 1, '', '订单号', 0,'order_sn'],
                    ['staff_id', '5dbff21eef745', 1, 1, '', '操作人id', 0,'staff_id'],
                    ['staff_name', '5dbff21eef745', 2, 1, '', '操作人', 0,'staff_name'],
                ],
            ],
        ],
    ],
    '1.1.250' => [
        [
            'type' => 'column',
            'name' => 'l_login_log',
            'fields' => [
                // 登录日志记录生存时间
                ['name' => 'active', 'type' => 'varchar', 'length' => 200, 'default' => null, 'is_null' => true],
            ],
        ],
    ],
    '1.1.251'=>[
        [
            'type' => 'data',
            'name' => 's_menu',
            'unique'=>'menu_code',
            'fields' => [
                'field' => ['id','menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'],
                'value' => [ /*要插入的字段对应的数据*/
                    [2034,'员工在线状态查询',134,'menu1575105212', '/crm/Setting/staffStatus', 1, 4],
                ],
            ],
        ],
    ],
    '1.1.252'=>[
        // 该字段需要操作 客资表，如果客资表数据量过大，建议手动创建
        // [
        //     'type' => 'column',
        //     'name' => 'c_customerinfo',
        //     'fields' => [
        //         // 预计婚期  3个月、6个月、1年内、其它
        //         ['name' => 'ready_marry_day', 'type' => 'varchar', 'length' => 100, 'default' => null, 'is_null' => true],
        //     ]
        // ],
        [
            'type' => 'data',
            'name' => 's_menu',
            'unique'=>'menu_code',//排重列，会按此列进行排重，如果重复，则跳过对应的数据行
            'fields' => [
                'field' => ['id','menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'], /*要插入的字段*/
                'value' => [ /*要插入的字段对应的数据*/
                    ['2035','预计婚期设定', 6, 'menu1582510236', '/crm/Setting/readyMarrydaySet', 1, 10],
                ],
            ],
        ],
        [ /*预计婚期设定*/
            'type' => 'table',
            'name' => 's_merry_day_set',
            'fields' => [
                ['name' => 'id', 'type' => 'int', 'default' => 'AUTO_INCREMENT', 'is_null' => false],
                // 状态：1：删除；2:未删除
                ['name' => 'is_delete', 'type' => 'tinyint', 'length' => 1,'default'=>2, 'is_null' => true],
                // 婚期
                ['name' => 'ready_marry_day', 'type' => 'varchar', 'length' => 100, 'default' =>NULL, 'is_null' => true],
                ['name' => 'brandclass_id', 'type' => 'int', 'length' => 11, 'default' =>NULL, 'is_null' => true],
                ['name' => 'brandclass', 'type' => 'varchar','length' => 255, 'default' =>NULL, 'is_null' => true],
                ['name' => 'create_time', 'type' => 'datetime', 'default' =>NULL, 'is_null' => true],
                ['name' => 'update_time', 'type' => 'datetime', 'default' =>NULL, 'is_null' => true],
            ],
        ],
        [
            'type' => 'data',
            'name' => 's_menu',
            'unique'=>'menu_code',//排重列，会按此列进行排重，如果重复，则跳过对应的数据行
            'fields' => [
                'field' => ['id','menu_name', 'fid', 'menu_code', 'menu_url', 'status', 'sort'], /*要插入的字段*/
                'value' => [ /*要插入的字段对应的数据*/
                    ['2036','右键-发送站内信', 2, 'menu1584353494', '/crm/Customer/sendMsgToStaff', 0, 10],
                ],
            ],
        ],
    ],
    '1.1.253' => [
        [
            'type' => 'column',
            'name' => 's_allocation_rule',
            'fields' => [
                // 分配规则表增加字段，用于保存员工分配客资上限及排序 另外 l_login_log 表给 staff_id last_login_time 加索引
                ['name' => 'fp_staffs', 'type' => 'text', 'default' => null, 'is_null' => true],
            ],
        ],
    ],
    '1.1.254' => [
        [
            'type' => 'column',
            'name' => 'c_customer_order',
            'fields' => [
                // 拍照排程时间
                ['name' => 'pc_time', 'type' => 'datetime', 'default' => null, 'is_null' => true],
                // 拍照排程状态（1：新增排程；2：改期）
                ['name' => 'pc_status', 'type' => 'tinyint', 'length' => 4, 'default' => null, 'is_null' => true],
                // 拍照排程改期原因 （当改期时必填）
                ['name' => 'pc_change', 'type' => 'varchar','length' => 200, 'default' => null, 'is_null' => true],
                // 摄影师
                ['name' => 'photoman', 'type' => 'varchar','length' => 50, 'default' => null, 'is_null' => true],
                // 拍摄完成时间
                ['name' => 'photo_time', 'type' => 'datetime', 'default' => null, 'is_null' => true],
            ],
        ],
        /*  客资表字段 手动添加
        [
            'type' => 'column',
            'name' => 'c_customerinfo',
            'fields' => [
                // 拍照排程时间
                ['name' => 'pc_time', 'type' => 'datetime', 'default' => null, 'is_null' => true],
                // 拍照排程状态（1：新增排程；2：改期）
                ['name' => 'pc_status', 'type' => 'tinyint', 'length' => 4, 'default' => null, 'is_null' => true],
                // 拍照排程改期原因 （当改期时必填）
                ['name' => 'pc_change', 'type' => 'varchar','length' => 200, 'default' => null, 'is_null' => true],
                // 摄影师
                ['name' => 'photoman', 'type' => 'varchar','length' => 50, 'default' => null, 'is_null' => true],
                // 拍摄完成时间
                ['name' => 'photo_time', 'type' => 'datetime', 'default' => null, 'is_null' => true],
            ],
        ],
        */
        [
            'type' => 'data',
            'name' => 'api_list',
            'unique'=>'hash',
            'fields' => [
                'field' => ['apiName', 'apiUrl', 'app_id', 'hash', 'accessToken', 'needLogin', 'status', 'method', 'info'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['ERP排程时（排程改期时）调用该接口', 'Child/getPcStatus', 6, '5e941617210e8', 0, 0, 1, 1,'ERP排程时（排程改期时）调用该接口'],
                    ['ERP拍照完成之后调用该接口', 'Child/getPhotoStatus', 6, '5e9416564d7d8', 0, 0, 1, 1,'ERP拍照完成之后调用该接口'],
                ],
            ],
        ],
        [
            'type' => 'data',
            'name' => 'api_fields',
            'fields' => [
                'field' => ['fieldName', 'hash','dataType', 'default', 'isMust', 'range', 'info', 'type', 'showName'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['order_sn', '5e941617210e8', 2, null,1, '', '订单编号', 0,'order_sn'],
                    ['area', '5e941617210e8', 2, null,1, '', '排程分区', 0,'area'],
                    ['pc_time', '5e941617210e8', 2, null,1, '', '排程时间', 0,'pc_time'],
                    ['pc_status', '5e941617210e8', 1, null,1, '', '排程状态（1：新增排程；2：改期）', 0,'pc_status'],
                    ['pc_change', '5e941617210e8', 2, null,1, '', '改期原因 （当改期时必填）', 0,'pc_change'],
                    ['photo_shop_code', '5e941617210e8', 2, null,1, '', '拍照店面', 0,'photo_shop_code'],
                    ['photo_shop_name', '5e941617210e8', 2, null,1, '', '拍照店面', 0,'photo_shop_name'],
                    ['staff_id', '5e941617210e8', 1, null,1, '', '操作人', 0,'staff_id'],
                    ['staff_name', '5e941617210e8', 2, null,1, '', '操作人', 0,'staff_name'],

                    ['order_sn', '5e9416564d7d8', 2, null,1, '', '订单编号', 0,'order_sn'],
                    ['area', '5e9416564d7d8', 2, null,1, '', '排程分区', 0,'area'],
                    ['photoman', '5e9416564d7d8', 2, null,1, '', '摄影师', 0,'photoman'],
                    ['photo_time', '5e9416564d7d8', 2, null,1, '', '拍摄完成时间', 0,'photo_time'],
                    ['photo_shop_code', '5e9416564d7d8', 2, null,1, '', '拍照店面', 0,'photo_shop_code'],
                    ['photo_shop_name', '5e9416564d7d8', 2, null,1, '', '拍照店面', 0,'photo_shop_name'],
                    ['staff_id', '5e9416564d7d8', 1, null,1, '', '操作人', 0,'staff_id'],
                    ['staff_name', '5e9416564d7d8', 2, null,1, '', '操作人', 0,'staff_name'],
                ],
            ],
        ],
    ],

    '1.1.255' => [
        /*  客资表字段 手动添加
        [
            'type' => 'column',
            'name' => 'c_customerinfo',
            'fields' => [
                // 加微信状态(0：未添加；1：已添加未通过；2：已通过；3：未通过)
                ['name' => 'wechat_status', 'type' => 'tinyint','length' => 4, 'default' => 0, 'is_null' => true],
                // 年龄区间
                ['name' => 'age_area', 'type' => 'varchar','length' => 50, 'default' => null, 'is_null' => true],
            ],
        ],
        */
    ],
    '1.1.256' => [
        /*  客资表字段 手动添加*/
        [
            'type' => 'column',
            'name' => 'c_customer_from',
            'fields' => [
                // 拦截次数
                ['name' => 'lanjie_num', 'type' => 'int','length' => 11, 'default' => 0, 'is_null' => true],
            ],
        ],
    ],
    '1.1.257' => [
        /*  客资表字段 手动添加*/
        [
            'type' => 'column',
            'name' => 's_report_form',
            'fields' => [
                // 报表类型  1电商 2网销 3转介绍 4汇总类
                ['name' => 'type', 'type' => 'tinyint','length' => 4, 'default' => 0, 'is_null' => true],
                // 排序
                ['name'=>'order', 'type'=>'int','length'=>11, 'default'=>0, 'is_null'=>true],
            ],
        ],
        [
            'type' => 'column',
            'name' => 'c_salestrackinginfo',
            'fields' => [
                // 追踪类型，区分 是否为 拦截提醒
                ['name' => 'track_type', 'type' => 'varchar','length' =>50, 'default' => 0, 'is_null' => true],
            ],
        ],
    ],
    '1.1.258' => [
          [
            'type' => 'column',
            'name' => 'c_customerinfo',
            'fields' => [
                // 预计婚期
                ['name' => 'ready_marry_day', 'type' => 'varchar','length' => 100, 'default' => 0, 'is_null' => true],
                // 年龄区间
                ['name' => 'age_area', 'type' => 'varchar','length' => 50, 'default' => 0, 'is_null' => true],
                // 加微信状态 1:已加未通过 2:通过
                ['name' => 'wechat_status', 'type' => 'tinyint','length' => 3, 'default' => 0, 'is_null' => true],                
            ],
        ],
    ],
    '1.1.262' => [
          [
            'type' => 'column',
            'name' => 'c_customer_order',
            'fields' => [
                // 一销全款时间
                ['name' => 'bargainoverdate', 'type' => 'datetime','default' => null, 'is_null' => true],
                // 套系名称
                ['name' => 'package_name', 'type' => 'varchar','length' => 100, 'default' => null, 'is_null' => true],
            ],
        ],
    ],
    '1.1.263' => [
        [
            'type' => 'column',
            'name' => 's_channel',
            'fields' => [
                // 操作人id
                ['name' => 'staff_id', 'type' => 'int','length' => 11,'default' => null, 'is_null' => true],   
                // 操作人name
                ['name' => 'staff_name', 'type' => 'varchar','length' => 50,'default' => null, 'is_null' => true],  
                // 操作时间
                ['name' => 'create_time', 'type' => 'datetime','default' => null, 'is_null' => true],        
            ],
        ],
    ],
    '1.1.264' => [
        [
            'type' => 'column',
            'name' => 's_channel',
            'fields' => [
                // 利率
                ['name' => 'rebates', 'type' => 'int','length' => 11,'default' => null, 'is_null' => true],
                //利率开始时间
                ['name' => 'rebates_start_time', 'type' => 'datetime','default' => null, 'is_null' => true],   
                //利率结束时间
                ['name' => 'rebates_end_time', 'type' => 'datetime','default' => null, 'is_null' => true],   
            ],
        ],
        [
            'type' => 'column',
            'name' => 's_channel_cost',
            'fields' => [
                // 花费返点金额  这个字段不用了
                ['name' => 'input_cost', 'type' => 'decimal', 'length' => '10,2','default' => 0, 'is_null' => true],
            ],
        ],
    ],
    '1.1.266' => [
        [
            'type'=> 'sql',
            'sql' => "ALTER TABLE `c_message` MODIFY COLUMN `customer_id` VARCHAR(200);",
        ],
        [
            'type'=> 'sql',
            'sql' => "ALTER TABLE `c_message` DEFAULT CHARACTER SET utf8;",
        ],
        [
            'type'=> 'sql',
            'sql' => "ALTER TABLE `c_message` MODIFY COLUMN `send_msg` text;",
        ],
    ],
    '1.1.267' => [
        [
            'type' => 'column',
            'name' => 's_tracksign',
            'fields' => [
                // 客资标记绑定客资状态  1有效，3无效，4驳回，5反驳回
                ['name' => 'customer_valid', 'type' => 'tinyint', 'length' => '4','default' => 0, 'is_null' => true],
            ],
        ],
    ],
    '1.1.268'=>[
        [
            'type' => 'column',
            'name' => 's_channel',
            'fields' => [
                // 分享店面
                ['name' => 'share_shops', 'type' => 'varchar','length'=>1000,'default'=>null, 'is_null' => true],
                // 渠道二维码
                ['name' => 'channel_qrcode', 'type' => 'varchar','length'=>200,'default'=>null, 'is_null' => true],
            ]
        ],
        [
            'type'=> 'sql',
            'sql' => "UPDATE `s_channel` SET share_shops=CONCAT(shop_code,',') WHERE share_shops IS NULL;",
        ],
        [
            'type'=> 'sql',
            'sql' => "UPDATE `s_address` SET `name`='播州区' WHERE id=2950;",
        ],
        [
            'type'=> 'sql',
            'sql' => "INSERT INTO `s_address` (`pid`, `name`, `type`, `order_sort`) VALUES ('294', '其它区', '3', '');",
        ],
    ],
    '1.1.269'=>[
        [
            'type' => 'data',
            'name' => 'api_list',
            'unique'=>'hash',
            'fields' => [
                'field' => ['apiName', 'apiUrl', 'app_id', 'hash', 'accessToken', 'needLogin', 'status', 'method', 'info'],
                'value' => [ /*要插入的字段对应的数据*/
                    ['回门', 'Intostore/returnDoor', 8, '5c459396a8750', 0, 0, 1, 1, ''],
                    ['删除进店', 'Intostore/deleteInto', 8, '5c4595ab2b750', 0, 0, 1, 1, ''],
                    ['流失', 'Intostore/loss', 8, '5c4596536c660', 0, 0, 1, 1, ''],
                    ['领取礼品', 'Intostore/gift', 8, '5c459af2ccd58', 0, 0, 1, 1, '领取礼品'],
                    ['门市标记', 'Intostore/customerSign', 8, '5c459b56b6210', 0, 0, 1, 1, ''],
                    ['分配接待人', 'Intostore/allotReception', 8, '5c459ba5c96a8', 0, 0, 1, 1, ''],
                    ['客资编辑', 'Intostore/customerEdit', 8, '5c459c06aae60', 0, 0, 1, 1, ''],
                    ['创建新客资前检查客资是否重复', 'Intostore/checkCustomerRepeat', 8, '5c47046db54c8', 0, 0, 1, 1, ''],
                    ['进客列表', 'Intostore/customerList', 8, '5c4704a203138', 0, 0, 1, 1, ''],
                    ['创建新客资', 'Intostore/createCustomer', 8, '5c4704b515630', 0, 0, 1, 1, ''],
                    ['erp转单', 'Intostore/createNewOrder', 8, '5c4704d990ad8', 0, 0, 1, 1, ''],
                    ['进客/非进客', 'Intostore/intostore', 8, '5c4a7b30027d8', 0, 0, 1, 1, ''],
                ],
            ],
        ],
    ],
    // '1.1.270'=>[
    //     [
    //         'type'=> 'sql',
    //         'sql' => "INSERT INTO `api_app`(`app_id`, `app_secret`, `app_name`, `app_status`, `app_type`, `app_info`) VALUES ('96354215', 'fsyEouttWzMjbxKKgeWvalXwfqqEeSAZ', '南宁QQbaby定制接口', 1, 2, '南宁QQbaby定制接口');",
    //     ],
    //     [
    //         'type'=> 'sql',
    //         'sql' => "INSERT INTO `api_list`(`apiName`, `apiUrl`, `app_id`, `hash`, `accessToken`, `needLogin`, `status`, `method`, `info`, `isTest`, `returnStr`) VALUES ('客资列表', 'NanNing/getCustomerList', (SELECT id FROM api_app where app_id = '96354215'), '5f6d8tv6wgfs6', 1, 0, 1, 1, '查询客资列表', 0, NULL);",
    //     ],
    //     [
    //         'type'=> 'sql',
    //         'sql' => "INSERT INTO `api_list`(`apiName`, `apiUrl`, `app_id`, `hash`, `accessToken`, `needLogin`, `status`, `method`, `info`, `isTest`, `returnStr`) VALUES ('订单列表', 'NanNing/getOrderList', (SELECT id FROM api_app where app_id = '96354215'), '5f6dafhkxu6xq', 1, 0, 1, 1, '查询订单列表', 0, NULL);",
    //     ],
    // ],
    '1.1.278'=>[
        [
            'type'=> 'sql',
            'sql' => "update api_list set apiUrl='FeiSi/getCustomerList' where hash='5f6d8tv6wgfs6' and apiUrl='NanNing/getCustomerList';",
        ],
        [
            'type'=> 'sql',
            'sql' => "update api_list set apiUrl='FeiSi/getOrderList' where hash='5f6dafhkxu6xq' and apiUrl='NanNing/getOrderList';",
        ],
        [
            'type'=> 'sql',
            'sql' => "update api_app set app_name='费司第三方',app_info='费司第三方' where app_id='96354215';",
        ],
        [
            'type'=> 'sql',
            'sql' => "update api_list set app_id=4 where app_id=8;",
        ],
    ],
];





