$(function(){
    /* ---------------------------------------------  页面开始的时候加载的数据 start  --------------------------------------------- */
    // 页面基础数据
    baseData();
    // 转化漏斗 （日） 图
    dayChangeRate();
    // 转化漏斗 （月） 图
    monthChangeRate();
    // // 订单来源排名
    orderCource();

    // 本月有效客资量走势
    monthCustomerNumber();
    // 本月网络新单量走势
    monthNewOrderNumber();
    // 有效完成进度
    getTargetValid();
    // 订单完成进度
    getTargetOrder();

    // 两个个排行榜
    rankData();
    // 客资渠道分布
    channelCustomer();
    /* ---------------------------------------------  页面开始的时候加载的数据 end  --------------------------------------------- */   
    // 页面基础数据
    function baseData () {
        $.ajax({
            type: 'POST',
            url : '/crm/citygarden/baseData',
            success: function(res){
                if (res) {
                    // console.log(res);
                    $("#validCustomer").html(res.validCustomer);
                    $("#readyInto").html(res.readyInto);
                    $("#notInto").html(res.notInto);
                    $("#intoOrder").html(res.intoOrder);
                    $("#onlineOrder").html(res.onlineOrder);
                    $("#intoLoss").html(res.intoLoss);
                    $("#orderRate").html(res.orderRate);

                    $("#dayChangeRateData").html('日有效率：'+res.dayChangeRate);
                    $("#monthChangeRateData").html('月有效率：'+res.monthChangeRate);
                };
            },
        })
    }
    // 转化漏斗 （日） 图
    function dayChangeRate (brandclass_id) {
        // 基于准备好的dom，初始化echarts实例
        var dayChangeRate = echarts.init(document.getElementById('dayChangeRate'));
        dayChangeRate.clear();

        dayChangeRate.setOption({
            title: {
                // text: '转化漏斗（日）',
            },
            tooltip: {
                trigger: 'axis',
                axisPointer: {
                    type: 'shadow'
                }
            },
            color:['#ffaf74','#65fbe3','#85e6ff','#fcdd7f'],  //手动设置每个图例的颜色
            legend: {
                data: ['毛客资量','有效客资','进店','订单'],
                // data: ['有效客资','进店','订单'],
                itemWidth: 15,
                itemHeight: 10,
                itemGap: 5,
                textStyle: {
                    fontSize: 12,
                    color: '#fff'
                }
            },
            grid: {
                x:'10%',
                y:'20%',
                x2:'10%',
                y2:"15%",
                borderWidth:1
            },
            xAxis: {
                type: 'value',
                axisLabel: {
                    formatter: '{value}'
                },
                axisLine:{
                    lineStyle:{
                        color:'#fff',
                        width:1
                    }
                }
            },
            yAxis: {
                show:false,
                type: 'category'
            },
            series: [],
        });
        var arr=[];
        var labelOption = {
            normal: {
                show: true,
                position: 'right',
                // distance: '15',
                // align: 'left',
                // verticalAlign: 'middle',
                // rotate: 90,
                // formatter: '{c} {a}',
                formatter: '{c}',
                fontSize: 12,
                textStyle: {
                    color: '#FFF',
                }
                // formatter: '{c}  {name|{a}}',
                // rich: {
                //     name: {
                //         textBorderColor: '#fff'
                //     }
                // }
            }
        };
        $.ajax({
            type: 'POST',
            data: {brandclass_id:brandclass_id},
            url : '/crm/Citygarden/dayChangeRate',
            success: function(res){
                for(var i=0;i<res.length;i++){
                    arr.push({
                        name: res[i].name,
                        data: [res[i].data],
                        type: 'bar',
                        label: labelOption,
                    })
                }
                dayChangeRate.setOption({
                    series: arr
                });
            }
        })
    }

    // 转化漏斗 （月） 图
    function monthChangeRate (brandclass_id) {
        // 基于准备好的dom，初始化echarts实例
        var monthChangeRate = echarts.init(document.getElementById('monthChangeRate'));
        monthChangeRate.clear();

        monthChangeRate.setOption({
            tooltip: {
                trigger: 'axis',
                axisPointer: {
                    type: 'shadow'
                }
            },
            color:['#ffaf74','#65fbe3','#85e6ff','#fcdd7f'],  //手动设置每个图例的颜色
            legend: {
                data: ['毛客资量','有效客资','进店','订单'],
                // data: ['有效客资','进店','订单'],
                itemWidth: 15,
                itemHeight: 10,
                itemGap: 5,
                textStyle: {
                    fontSize: 12,
                    color: '#fff'
                }
            },
            grid: {
                x:'10%',
                y:'20%',
                x2:'10%',
                y2:"15%",
                borderWidth:1
            },
            xAxis: {
                type: 'value',
                axisLabel: {
                    formatter: '{value}'
                },
                axisLine:{
                    lineStyle:{
                        color:'#fff',
                        width:1
                    }
                }
            },
            yAxis: {
                show:false,
                type: 'category'
            },
            series: [],
        });
        var arr=[];
        var labelOption = {
            normal: {
                show: true,
                position: 'right',
                // distance: '15',
                // align: 'left',
                // verticalAlign: 'middle',
                // rotate: 90,
                formatter: '{c}',
                fontSize: 12,
                textStyle: {
                    color: '#FFF',
                }
                // formatter: '{c}  {name|{a}}',
                // rich: {
                //     name: {
                //         textBorderColor: '#fff'
                //     }
                // }
            }
        };
        $.ajax({
            type: 'POST',
            data: {brandclass_id:brandclass_id},
            url : '/crm/Citygarden/monthChangeRate',
            success: function(res){
                for(var i=0;i<res.length;i++){
                    arr.push({
                        name: res[i].name,
                        data: [res[i].data],
                        type: 'bar',
                        label: labelOption,
                    })
                }
                monthChangeRate.setOption({
                    series: arr
                });
            }
        })
    }
    // 订单来源排名
    function orderCource(){
        // 基于准备好的dom，初始化echarts实例
        var orderCource = echarts.init(document.getElementById('orderCource'));
        orderCource.clear();
        orderCource.setOption({
            tooltip: {
                trigger: 'axis',
                axisPointer: {
                    type: 'shadow'
                }
            },
            // color:['#ffaf74','#65fbe3','#85e6ff','#fcdd7f'],  //手动设置每个图例的颜色
            legend: {
                // data: ['毛客资量','有效客资','进店','订单'],
                // data: ['有效客资','进店','订单'],
                itemWidth: 15,
                itemHeight: 10,
                itemGap: 5,
                textStyle: {
                    fontSize: 12,
                    color: '#fff'
                }
            },
            grid: {
                x:'5%',
                y:'20%',
                x2:'10%',
                y2:"15%",
                borderWidth:1
            },
            xAxis: {
                type: 'value',
                axisLabel: {
                    formatter: '{value}'
                },
                axisLine:{
                    lineStyle:{
                        color:'#fff',
                        width:1
                    }
                }
            },
            yAxis: {
                show:false,
                type: 'category'
            },
            series: [],
        });
        var arr=[];
        var labelOption = {
            normal: {
                show: true,
                position: 'right',
                // distance: '15',
                // align: 'left',
                // verticalAlign: 'middle',
                // rotate: 90,
                formatter: '{c}',
                fontSize: 12,
                textStyle: {
                    color: '#FFF',
                }
                // formatter: '{c}  {name|{a}}',
                // rich: {
                //     name: {
                //         textBorderColor: '#fff'
                //     }
                // }
            }
        };
        $.ajax({
            type: 'POST',
            // data: {brandclass_id:brandclass_id},
            url : '/crm/Citygarden/orderCource',
            success: function(res){
                for(var i=0;i<res.data.length;i++){
                    arr.push({
                        name: res.data[i].name,
                        data: [res.data[i].num],
                        type: 'bar',
                        label: labelOption,
                    })
                }
                orderCource.setOption({
                    legend:{
                        data: res.cource
                    },
                    series: arr
                });
            }
        })
    }

    // 本月有效客资量走势 图
    function monthCustomerNumber () {
        // 基于准备好的dom，初始化echarts实例
        var monthCustomerNumber = echarts.init(document.getElementById('chart1'));
        monthCustomerNumber.clear();

        monthCustomerNumber.setOption({
            color: ['#66e0ff'],
            tooltip: {
                trigger: 'axis'
            },
            grid: {
                x:'14%',
                y:'4%',
                x2:'5%',
                y2:"30%",
                borderWidth:1
            },
            xAxis:  {
                type: 'category',
                boundaryGap: false,
                data: [],
                axisLine:{
                    lineStyle:{
                        color:'#fff',
                        width:1
                    }
                }
            },
            yAxis: {
                    type: 'value',
                    min:0,
                    axisLine:{
                        lineStyle:{
                            color:'#fff',
                            width:1
                        }
                    }
            },
            series: [
                {
                    name:'有效客资量',
                    type:'bar',
                    data:[]
                }
            ]
        });
        var arr=[];
        var labelOption = {
            normal: {
                show: true,
                position: 'top',
            }
        };
        $.ajax({
            type: 'POST',
            url : '/crm/Citygarden/monthCustomerNumber',
            success: function(res){
                arr.push({
                    name:res.data[0].name,
                    data:res.data[0].data,
                    type: 'bar',
                    // label: labelOption,
                })
                monthCustomerNumber.setOption({
                    xAxis: {
                        data: res.timezone
                    },
                    series: arr
                });
            }
        })
    }
    // 本月网络新单量走势 图
    function monthNewOrderNumber () {
        // 基于准备好的dom，初始化echarts实例
        var monthNewOrderNumber = echarts.init(document.getElementById('chart3'));
        monthNewOrderNumber.clear();

        monthNewOrderNumber.setOption({
            color: ['#00ffd6'],
            tooltip: {
                trigger: 'axis'
            },
            grid: {
                x:'14%',
                y:'4%',
                x2:'5%',
                y2:"30%",
                borderWidth:1
            },
            xAxis:  {
                type: 'category',
                boundaryGap: false,
                data: [],
                axisLine:{
                    lineStyle:{
                        color:'#fff',
                        width:1
                    }
                }
            },
            yAxis: {
                type: 'value',
                axisLine:{
                    lineStyle:{
                        color:'#fff',
                        width:1
                    }
                }
            },
            series: [],
        });
        var arr=[];
        var labelOption = {
            normal: {
                show: true,
                position: 'top',
            }
        };
        $.ajax({
            type: 'POST',
            url : '/crm/Citygarden/monthNewOrderNumber',
            success: function(res){
                arr.push({
                    name:res.data[0].name,
                    data:res.data[0].data,
                    type: 'bar',
                    // label: labelOption,
                })
                monthNewOrderNumber.setOption({
                    xAxis: {
                        data: res.timezone
                    },
                    series: arr
                });
            }
        })
    }
    // 目标及进度
    function getTargetValid () {
        $.ajax({
            type: 'POST',
            url : '/crm/Citygarden/getTargetValid',
            success: function(res){
                if (res) {
                    // 有效
                    $("#valid_alread").html(res.valid_alread);
                    $("#valid_target").html(res.valid_target);
                    // 顶部进度条
                    var pecent=0;
                    var isChange=false;
                    var progressFn=function(){
                        for(var i=0;i<$(".li-wrap").length;i++){
                            pecent=($(".li-wrap").eq(i).find(".mounth-num").html()/$(".li-wrap").eq(i).find(".count-num").html()*100).toFixed(0);
                            $(".li-wrap").eq(i).find(".progress-value").html(pecent+'%');
                            $(".li-wrap").eq(i).find(".progress-bar").css('width',pecent>100?100+'%':pecent+'%');
                            if(isChange){
                                $("#customerValid .progress-bar").addClass("change-bg");
                            }else{
                                $("#customerValid .progress-bar").removeClass("change-bg");
                            }
                        }
                    };
                    progressFn();
                };
            },
            // error:function(){
            //     baseData(brandclass_id);
            // }
        })
    }
    function getTargetOrder () {
        $.ajax({
            type: 'POST',
            url : '/crm/Citygarden/getTargetOrder',
            success: function(res){
                if (res) {
                    // 订单
                    $("#order_alread").html(res.order_alread);
                    $("#order_target").html(res.order_target);
                    // 顶部进度条
                    var pecent=0;
                    var isChange=false;
                    var progressFn1=function(){
                        for(var i=0;i<$(".li-wrap").length;i++){
                            pecent=($(".li-wrap").eq(i).find(".mounth-num").html()/$(".li-wrap").eq(i).find(".count-num").html()*100).toFixed(0);
                            $(".li-wrap").eq(i).find(".progress-value").html(pecent+'%');
                            $(".li-wrap").eq(i).find(".progress-bar").css('width',pecent>100?100+'%':pecent+'%');
                            if(isChange){
                                $("#customerOrder .progress-bar").addClass("change-bg");
                            }else{
                                $("#customerOrder .progress-bar").removeClass("change-bg");
                            }
                        }
                    };
                    progressFn1();
                };
            },
            // error:function(){
            //     baseData(brandclass_id);
            // }
        })
    }

    // 两个排行榜
    function rankData () {
        $.ajax({
            type: 'POST',
            url : '/crm/Citygarden/rankData',
            success: function(res){
                if (res) {
                    // 来源新单 日排行
                    var wxRankTop = res.wxRankTop;
                    // var ret1 = '<table cellpadding="0" cellspacing="0">';
                    var ret1 = '';
                    var j1 = 0;
                    for(var i = 0; i < wxRankTop.length; i++){
                    // for(var i = 0; i < 10; i++){
                        j1 = i+1;
                        ret1 += '<tr><td style="width:10%;text-align: left;">'+(j1)+'</td><td style="width:50%;text-align: left;">'+wxRankTop[i]['sales_staff']+'</td><td style="width:20%;text-align: right;">'+wxRankTop[i]['orderNum']+'/'+wxRankTop[i]['valiNum']+'</td><td style="width:20%;text-align: left;">'+wxRankTop[i]['orderRate']+'</td></tr>';
                    }
                    // ret1 +='</table>';
                    $('#wxRankTop').html(ret1);

                    // 来源新单 月排行
                    var wxRankDown = res.wxRankDown;
                    // var ret2 = '<table cellpadding="0" cellspacing="0">';
                    var ret2 = '';
                    var j2 = 0;
                    for(var i = 0; i < wxRankDown.length; i++){
                    // for(var i = 0; i < 10; i++){
                        j2 = i+1;
                        ret2 += '<tr><td style="width:10%;text-align: left;">'+(j2)+'</td><td style="width:50%;text-align: left;">'+wxRankDown[i]['sales_staff']+'</td><td style="width:20%;text-align: right;">'+wxRankDown[i]['orderNum']+'/'+wxRankDown[i]['valiNum']+'</td><td style="width:20%;text-align: left;">'+wxRankDown[i]['orderRate']+'</td></tr>';
                    }
                    // ret2 +='</table>';
                    $('#wxRankDown').html(ret2);
                };
            }
        })
    }
    // 客资渠道分布
    function channelCustomer () {
        //中间右侧图表
        var kzChart = echarts.init(document.getElementById('kzChart'));
        kzChart.clear();

        kzChart.setOption({
            color: ['#ffaf74','#65fbe3'],
            tooltip: {
                trigger: 'axis',
            },
            legend: {
                data: ['毛客资','有效客资'],
                textStyle: {
                    fontSize: 12,
                    color: '#fff'
                }
            },
            grid: {
                x:'8%',
                y:'5%',
                x2:'3%',
                y2:"45%",
                borderWidth:1
            },
            xAxis: {
                type: 'category',
                boundaryGap: true,
                data:[],
                axisPointer: {
                    type: 'shadow'
                },
                axisLine:{
                    lineStyle:{
                        color:'#fff',
                        width: 1
                    }
                },
                textStyle: {
                    fontSize: 6,
                    color: '#fff'
                },
                axisLabel : {
                    show:true,
                    interval: 'auto',
                    inside: false,
                    rotate: 60,
                    margin: 10
                }
            },
            yAxis: {
                type: 'value',
                axisLine:{
                    lineStyle:{
                        color:'#fff',
                        width:1
                    }
                }
            },
            series: []
        })
        $.ajax({
            type: 'POST',
            url : '/crm/Citygarden/channelCustomer',
            success: function(res){
                // console.log(res);
                var arr=[];
                for(var i=0;i<res.data.length;i++){
                    arr.push({
                        name:res.data[i].name,
                        data:res.data[i].num,
                        type:"bar"
                    });
                }

                kzChart.setOption({
                    xAxis:{
                        data:res.name
                    },
                    series: arr
                });
            }
        })
    }
    /* ---------------------------------------- end ---------------------------------------- */    
})