<?php
/**
 * 导库转用
 * 
 */
namespace app\crm\command;
use think\console\Command;
use think\console\Input;
use think\console\Output;
class Runtransdata extends Command{

    protected function configure()
    {
        
        $this->setName('runtransdata')->setDescription('Suxuan transdata command');
        $this->addArgument('method');
        $this->addArgument('step');
    }
    protected function execute(Input $input, Output $output)
    {

        $configFile = APP_PATH.'transdata.php';

        /**
         *要操作的类，此类必须在LIB下面
         * 
         */
        $controller = 'Runtransdata';
        /**
         * 类里的方法
         */
        $method = 'Tcdj';

        if($input->getArgument('method')){
            //指定执行某个方法，未来要增加方法，不需要再指定method，直接运行时，输入函数名即可
            $method = $input->getArgument('method');
        }
        $options = [];
        if($input->getArgument('step')){
            //指定操作哪一步，可以分为init start等，
            //其中init是出相关的需要准备的基础对应数据
            //start或不传，表示开始导入
            $options[] = $input->getArgument('step');
        }
        if(!class_exists('app\\crm\\lib\\'.ucwords($controller))){
            echo '没有发现这个类：'.$controller."\r\n";
            exit();
        }
        $instance = new \ReflectionClass('app\\crm\\lib\\'.ucwords($controller));
        if (!$instance->hasMethod($method)) {
            echo '没有发现这个方法：'.$method."\r\n";
            exit();
        }

        $objMethod = $instance->getMethod($methoxd);
        $handle = $instance->newInstance();
        try{
            $objMethod->invokeArgs($handle, $options);

        }  catch (\Exception $e){
            echo '程序报错：'."\r\n";
            echo $e->getMessage()."\r\n";
            print_r($e->getTraceAsString());
        }
        
        
    }

}
