<?php
/**
 *  西安费司（face） 大屏控制器
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: lilong<lilong@suxuantech.cn> $
 */
namespace app\crm\controller;
use think\Controller;
// use app\index\controller\Base;
use think\Queue;
use think\Request;

class Xafs extends Controller{
    // 推广店
    protected  $shop_code = ['JDRQ05'];
    // 转介绍
    protected  $shop_code_zjs = ['JDRQ06'];
    // 网销组所在部门
    protected  $wxGroupDep = [
        'id'=>11,
        'department_name'=>'网销部',
    ];
    // 转介绍
    protected  $zjsGroupDep = [
        'id'=>16,
        'department_name'=>'转介绍部',
    ];
    // 门市部
    protected  $msGroupDep = [
        'id'=>9,
        'department_name'=>'门市部',
    ];
    // 今天
    protected  $today = [
        'start'=>'', 'end'  =>'',
    ];
    // 本周
    protected  $thisWeek = [
        'start'=>'', 'end'  =>'',
    ];
    // 本月一号和当天
    protected  $thisMonth = [
        'start'=>'', 'end'  =>'',
    ];
    // 本月每一天
    protected  $thisMonthAllDay = [];
    public function _initialize(){
        // 今天
        $this->today['start']=  date('Y-m-d 00:00:00');
        $this->today['end']  =  date('Y-m-d 23:59:59');
        // 昨天
        $this->yestoday['start']= date('Y-m-d 00:00:00',strtotime('-1 day'));
        $this->yestoday['end']  = date('Y-m-d 23:59:59',strtotime('-1 day'));
        // 本周
        $week = getdateArea('this_week');
        $this->thisWeek['start']=  $week['0'];
        $this->thisWeek['end']  =  $week['1'];
        // 本月
        $this->thisMonth['start']= date('Y-m-01 00:00:00');
        $this->thisMonth['end']  = date('Y-m-d 23:59:59');
        // 本月每一天
        $date = getdateArea('this_month');
        $this->thisMonthAllDay = getDateFromRange($date[0], $date[1]);
    }
    // 员工大屏页面  2018-07-26
    public function staff(){
        // $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        // if ($auth === false) {
        //     controller('crm/Index','controller')->index();
        //     exit;
        // }
        
        $this->assign('title','费司摄影 【网销实时大数据】');
        return $this->fetch();
    }
    // 转介绍员工大屏页面  2018-07-26
    public function staffzjs(){
        // $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        // if ($auth === false) {
        //     controller('crm/Index','controller')->index();
        //     exit;
        // }
        
        $this->assign('title','费司摄影 【转介绍实时大数据】');
        return $this->fetch();
    }
    // 转介绍员工大屏页面  2018-07-26
    public function staffms(){
        // $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        // if ($auth === false) {
        //     controller('crm/Index','controller')->index();
        //     exit;
        // }
        
        $this->assign('title','费司摄影 【门市实时大数据】');
        return $this->fetch();
    }
    // 第一部分 
    public function staffBaseData(){
        $param = input();
        //本月
        $mdate = getdateArea('this_month');
        $mData['start'] = $this->thisMonth['start'];
        $mData['end']   = $this->thisMonth['end'];
        //今天
        $tData['start']    = $this->today['start'];
        $tData['end']      = $this->today['end'];
        // 门店
        if ($param['type']=='zjs') {
            $mData['shop_code']= $this->shop_code_zjs;
            $tData['shop_code']= $this->shop_code_zjs;
        }else{
            $mData['shop_code']= $this->shop_code;
            $tData['shop_code']= $this->shop_code;
        }
        // 今日电商总线索  即  推广今日录入的客资总数
        $tmkz = controller('crm/Xafs', 'lib')->getCustomerNum($tData);
        $mmkz = controller('crm/Xafs', 'lib')->getCustomerNum($mData);
        // 今日待联系新线索 即  今日录入的 一次都没有追踪过的客资 (待追踪)
        $dzz = controller('crm/Xafs', 'lib')->getDzzNum($tData);
        // 电商客服在线数
        $onlinestaff = controller('crm/Xafs', 'lib')->getOnlineStaffs($tData);
        // 本月成交冠军
        $allOrderStaff = controller('crm/Xafs', 'lib')->getAllStaffOrders($mData);
        $maxOrderStaff = $allOrderStaff ? array_shift($allOrderStaff) : [];
        // 返回数据
        $returnData['tmkz'] = $tmkz;
        $returnData['mmkz'] = $mmkz;
        $returnData['dzz']  = $dzz;
        $returnData['onlinestaff']  = $onlinestaff;
        $returnData['maxOrderStaff']= $maxOrderStaff;
        return json($returnData);
    }
    // 第二部分  1今日网销各组订单量
    public function todayWxGroupOrder(){
        $param = input();
        //今天
        $tData['start']    = $this->today['start'];
        $tData['end']      = $this->today['end'];
        // 门店
        if ($param['type']=='zjs') {
            $tData['shop_code']= $this->shop_code_zjs;
            $groupDep = $this->zjsGroupDep;
        }else{
            $tData['shop_code']= $this->shop_code;
            $groupDep = $this->wxGroupDep;
        }
        // 所有的组
        $allGroups = controller('crm/Xafs', 'lib')->getAllGroups($groupDep);
        $gids = '';
        foreach ($allGroups as $key => $value) {
            $gids .= $value['id'].',';
        }
        $gids = trim($gids,',');
        $tData['gids']= $gids;
        // 所有组的订单
        $allGroupOrder = controller('crm/Xafs', 'lib')->getAllGroupOrders($tData);
        $allData = [];
        foreach ($allGroups as $key => $value) {
            $temp['sales_group_name'] = $value['group_name'];
            $temp['orderNum'] = $allGroupOrder[$value['id']]['orderNum'] ? $allGroupOrder[$value['id']]['orderNum'] : 0;
            $allData[] = $temp;
        }
        $return['names'] = array_column($allData,'sales_group_name');
        $return['datas'] = array_column($allData,'orderNum');
        return json($return);
    }
    // 第二部分  2本周网销各组订单量
    public function weekWxGroupOrder(){
        $param = input();
        //今天
        $wData['start']    = $this->thisWeek['start'];
        $wData['end']      = $this->thisWeek['end'];
        $wData['shop_code']= $this->shop_code;
        // 门店
        if ($param['type']=='zjs') {
            $wData['shop_code']= $this->shop_code_zjs;
            $wxGroupDep = $this->zjsGroupDep;
        }else{
            $wData['shop_code']= $this->shop_code;
            $wxGroupDep = $this->wxGroupDep;
        }
        // 所有的组
        $allGroups = controller('crm/Xafs', 'lib')->getAllGroups($wxGroupDep);
        $gids = '';
        foreach ($allGroups as $key => $value) {
            $gids .= $value['id'].',';
        }
        $gids = trim($gids,',');
        $wData['gids']= $gids;
        // 所有组的订单
        $allGroupOrder = controller('crm/Xafs', 'lib')->getAllGroupOrders($wData);
        $allData = [];
        foreach ($allGroups as $key => $value) {
            $temp['sales_group_name'] = $value['group_name'];
            $temp['orderNum'] = $allGroupOrder[$value['id']]['orderNum'] ? $allGroupOrder[$value['id']]['orderNum'] : 0;
            $allData[] = $temp;
        }
        $return['names'] = array_column($allData,'sales_group_name');
        $return['datas'] = array_column($allData,'orderNum');
        return json($return);
    }
    // 第二部分  3本月网销各组订单量
    public function monthWxGroupOrder(){
        $param = input();
        //本月
        $mdate = getdateArea('this_month');
        $mData['start'] = $this->thisMonth['start'];
        $mData['end']   = $this->thisMonth['end'];
        // 门店
        if ($param['type']=='zjs') {
            $mData['shop_code']= $this->shop_code_zjs;
            $wxGroupDep = $this->zjsGroupDep;
        }else{
            $mData['shop_code']= $this->shop_code;
            $wxGroupDep = $this->wxGroupDep;
        }
        // 所有的组
        $allGroups = controller('crm/Xafs', 'lib')->getAllGroups($wxGroupDep);
        $gids = '';
        foreach ($allGroups as $key => $value) {
            $gids .= $value['id'].',';
        }
        $gids = trim($gids,',');
        $mData['gids']= $gids;
        // 所有组的订单
        $allGroupOrder = controller('crm/Xafs', 'lib')->getAllGroupOrders($mData);
        $allData = [];
        foreach ($allGroups as $key => $value) {
            $temp['sales_group_name'] = $value['group_name'];
            $temp['orderNum'] = $allGroupOrder[$value['id']]['orderNum'] ? $allGroupOrder[$value['id']]['orderNum'] : 0;
            $allData[] = $temp;
        }
        $return['names'] = array_column($allData,'sales_group_name');
        $return['datas'] = array_column($allData,'orderNum');
        return json($return);
    }
    // 第三部分  1网销月订单量排行榜
    public function monthWxStaffOrder(){
        $param = input();
        // 本月
        $mdate = getdateArea('this_month');
        $mData['start'] = $this->thisMonth['start'];
        $mData['end']   = $this->thisMonth['end'];
        $mData['shop_code']= $this->shop_code;
        // 门店
        if ($param['type']=='zjs') {
            $mData['shop_code']= $this->shop_code_zjs;
        }else{
            $mData['shop_code']= $this->shop_code;
        }
        $allStaffOrders = controller('crm/Xafs', 'lib')->getAllStaffOrders($mData);
        $allStaffOrders = my_sort($allStaffOrders, 'orderNum');
        $return['names'] = array_column($allStaffOrders,'sales_staff');
        $return['datas'] = array_column($allStaffOrders,'orderNum');
        return json($return);
    }
    // 第三部分  2网销月线索订单率
    public function monthWxStaffCusRate(){
        $param = input();
        // 本月
        $mdate = getdateArea('this_month');
        $mData['start'] = $this->thisMonth['start'];
        $mData['end']   = $this->thisMonth['end'];
        // 门店
        if ($param['type']=='zjs') {
            $mData['shop_code']= $this->shop_code_zjs;
        }else{
            $mData['shop_code']= $this->shop_code;
        }
        $allStaffOrders = controller('crm/Xafs', 'lib')->getAllStaffOrders($mData);
        $allStaffCus = controller('crm/Xafs', 'lib')->getAllStaffCus($mData);

        $allData = [];
        foreach ($allStaffCus as $key => $value) {
            $temp['sales_staff'] = $value['sales_staff'];
            $temp['cusNum'] = $value['cusNum'];
            $temp['orderNum'] = $allStaffOrders[$value['sales_staff']]['orderNum'];
            $temp['cusRate'] = $temp['orderNum'] ? sprintf('%.2f',$temp['orderNum']/$temp['cusNum']*100) : '0%';
            $allData[]=$temp;
        }
        $allData = my_sort($allData, 'cusRate');
        $return['names'] = array_column($allData,'sales_staff');
        $return['datas'] = array_column($allData,'cusRate');
        $return['cusNum'] = array_column($allData,'cusNum');
        $return['orderNum'] = array_column($allData,'orderNum');
        return json($return);
    }
    // 门市订单base
    public function msBaseData(){
        // 当日进店 及 订单
        $returnData['dayinto'] = $this->intoNum(['day_type'=>'day']);
        $returnData['dayorder']= $this->orderNum(['day_type'=>'day']);
        // 本月进店 及 订单
        $returnData['monthinto'] = $this->intoNum(['day_type'=>'month']);
        $returnData['monthorder']= $this->orderNum(['day_type'=>'month']);
        // 本月成交冠军
        $msOrderParam['start']= $this->thisMonth['start'];
        $msOrderParam['end']  = $this->thisMonth['end'];
        $msOrderParam['shop_code'] = $this->shop_code_zjs;
        $msOrderParam['department']= $this->msGroupDep;
        $allMsOrder = controller('crm/Xafs', 'lib')->getAllMsOrderDetail($msOrderParam);
        $maxOrderStaff = $allMsOrder ? array_shift($allMsOrder) : [];

        $maxOrderStaff['orderRate'] = $maxOrderStaff['oNum'] ? sprintf('%.2f',$maxOrderStaff['oNum']/$maxOrderStaff['intonum']*100).'%' : '0%';
        $returnData['maxOrderStaff']= $maxOrderStaff;

        return json($returnData);
    }
    // 门市 进店量
    public function intoNum($param){
        // $param = input();
        // 时间类型 当日 本周 本月
        if ($param['day_type']=='day') {
            $date['start']    = $this->today['start'];
            $date['end']      = $this->today['end'];
        }else if ($param['day_type']=='week') {
            $date['start'] = $this->thisWeek['start'];
            $date['end']   = $this->thisWeek['end'];
        }else{
            $date['start'] = $this->thisMonth['start'];
            $date['end']   = $this->thisMonth['end'];
        }
        $date['shop_code']= $this->shop_code_zjs;
        // 
        $getAllMsInto = controller('crm/Xafs', 'lib')->getAllMsInto($date);
        return $getAllMsInto;
    }
    // 成交量
    public function orderNum($param){
        // $param = input();
        // 时间类型 当日 本周 本月
        if ($param['day_type']=='day') {
            $date['start']    = $this->today['start'];
            $date['end']      = $this->today['end'];
        }else if ($param['day_type']=='week') {
            $date['start'] = $this->thisWeek['start'];
            $date['end']   = $this->thisWeek['end'];
        }else{
            $date['start'] = $this->thisMonth['start'];
            $date['end']   = $this->thisMonth['end'];
        }
        $date['shop_code']= $this->shop_code_zjs;
        $getAllMsOrder = controller('crm/Xafs', 'lib')->getAllMsOrder($date);
        return $getAllMsOrder;
    }
    // 本月门市成交量  金排量 成交率 进店均价
    public function getMsOrder(){
        $param = input();
        $msOrderParam['start']= $this->thisMonth['start'];
        $msOrderParam['end']  = $this->thisMonth['end'];
        $msOrderParam['shop_code'] = $this->shop_code_zjs;
        if ($param['gid']) {
            $msOrderParam['group']= $param['gid'];
        }else{
            $msOrderParam['department']= $this->msGroupDep;
        }
        
        $groupOrder = controller('crm/Xafs', 'lib')->getAllMsOrderDetail($msOrderParam);
        $returnData = [];
        $i = 1;
        foreach ($groupOrder as $k => $v) {
            $temp['key']  = $i;
            $temp['staff']= $v['staff'] ? $v['staff'] : '';
            $temp['cssname']= $v['cssname'] ? $v['cssname'] : 0;
            $temp['oNum']= $v['oNum'];
            $temp['oMoney']= $v['oMoney'];
            $temp['intonum']= $v['intonum'];

            $temp['orderRate']= $v['oNum'] ? sprintf('%.2f',$v['oNum']/$v['intonum']*100).'%' : '0%';
            $temp['moneyRate']= $v['oMoney'] ? sprintf('%.2f',$v['oMoney']/$v['oNum']) : '0';

            array_push($returnData, $temp);
            unset($temp);
            $i++;
        }
        return json($returnData);
    }

}