<?php
/**
 * 城市花园 大屏专用lib
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: lilong<lilong@suxuantech.cn> $
 */
namespace app\crm\lib;
use think\Controller;

class Citygarden extends Controller{
    protected $noinConsultation = ['礼服租售','产品加做','业务单','美容跟妆','网打预付'];
    // 大屏专用  判断  该员工是否有权限查看大屏数据
    public function checkBigScreenAuth(){
        // 获取配置文件中的信息，根据,分割成数组，如果staff_id不存在，则跳转到登录或首页
        $staff_id = session('staff_id');
        $str_id = config('bigScreen_id');
        $bigScreen_id = explode(',', $str_id);
        $is_in = in_array($staff_id, $bigScreen_id);
        if ($is_in === false) {
            // 查看有无查看大屏权限
            if(check_right('menu1556162726')){
                return true;
            }
            return false;
        }else{
            return true;
        }
    }

    // 获取网销店下的所有部门
    public function getWxDepartment(){
        $deparment_info = cache('wx_deparment');
        if (!$deparment_info) {
            $shop_info = $this->getShopByType('wx');
            $shop_code = $shop_info['shop_code'];
            $deparment_info = $this->getdeparments($shop_code);
            cache('wx_deparment',$deparment_info);
        }
        
        return $deparment_info;
    }
    // 获取不同类型的店面信息（电商，网销，实体）
    public function getShopByType($param){
        $url = '5a005e0038270';
        switch ($param) {
            case 'ds':
                $data['is_marketing'] = 1;
                break;
            case 'st':
                $data['is_marketing'] = 2;
                break;
            case 'wx':
                $data['is_marketing'] = 3;
                break;
            case 'qd':
                $data['is_marketing'] = 4;
                break;
        }
        $data['brandclass_id']=1;
        $res = sx_call($url, $data);
        if ($res['code'] == 200) {
            $return = $res['data'][0];
        }
        return $return;
    }

    // 根据事业部获取  店 （电商，网销，渠道）
    public function getShops($brandclass_id){
        $url = '5a37a1503264d';
        $data['brandclass_id']= $brandclass_id;
        $res = sx_call($url, $data);
        if ($res['code'] == 200) {
            $shopList = $res['data'];
        }else{
            $shopList = '';
        }
        return $shopList;
    }

    // 获取所有部门信息
    public function getdeparments($shop_code = ''){
        $url = '5a0aef152b750';
        $data['shop_code'] = $shop_code;
        $res = sx_call($url, $data);
        $return = $res['data'];
        return $return;
    }

    // 根据部门id获取所有  小组  信息
    public function getGroups($deparment_id){
        $where = [
            'department_id' => $deparment_id,
        ];
        $groups = db('c_staff_group')->where($where)->select();
        return $groups;
    }

    // 根据shop_code 获取该店加权系数
    public function getShopWeight($shop_code){
        $weight = cache('shopWeight_'.$shop_code);
        if (!$weight) {
            $url = '5a005e0038270';
            $data['shop_code'] = $shop_code;
            $info = sx_call($url, $data);
            if ($info['code'] == 200) {
                $weight = $info['data'][0]['weight'];
                if ($weight == 0) {
                    $weight = 1;
                }
                cache('shopWeight_'.$shop_code, $weight);
            }else{
                $weight = '1';
            }
        }
        return $weight;
    }

    // 获取所有客户来源
    public function getCource(){
        $courceList = cache('courceList_all');
        if (!$courceList) {
            $url = '59fd5ec462c88';
            $data= [];
            $res = sx_call($url, $data);
            if ($res['code'] == 200) {
                $courceList = $res['data'];
                cache('courceList_all', $courceList, 3600);
            }else{
                $courceList = '';
            }
        }
        
        return $courceList;
    }

    // 获取所有渠道 （二级渠道）
    public function getChannel(){
        $channelList = cache('channelList_all');
        if (!$channelList) {
            $url = '59fd5e729e5a8';
            $data= [];
            $res = sx_call($url, $data);
            if ($res['code'] == 200) {
                $channelList = $res['data'];
                cache('channelList_all', $channelList_all, 3600);
            }else{
                $channelList = '';
            }
        }
        
        return $channelList;
    }

    // 获取毛客资  量
    public function getCustomerNum($data){
        // 毛客资定义：电商录入的新客资，不包括网销，渠道录入的客资
        $where['c_from']        = 1;
        $where['is_status']     = 1;
        $where['customer_type'] = 1;

        if ($data['customer_cource']) {
            $where['customer_cource'] = $data['customer_cource'];
        }
        $num = db('c_customerinfo')
            ->where($where)
            ->where('add_shop_code', 'in', $data['shop_code'])
            ->where('dj_day', 'between time', [$data['start'], $data['end']])
            ->count();
        // echo db()->getLastSql();
        return $num;
    }

    // 获取有效客资 量  城市花园 根据 登记时间计算有效客资
    public function getInvCustomerNum($data){
        // 有效客资定义：毛客资中，标记有效的，
        $where['c_from']        = 1;
        $where['is_valid']      = 1;
        $where['is_status']     = 1;
        // $where['customer_type'] = 1;
        if ($data['customer_cource']) {
            $where['customer_cource'] = $data['customer_cource'];
        }

        $num = db('c_customerinfo')
            ->where($where)
            ->where('add_shop_code', 'in', $data['shop_code'])
            ->where('dj_day', 'between time', [$data['start'], $data['end']])
            ->count();

        // echo db()->getLastSql();
        // exit;
        return $num;
    }

    // 进客模块 今日预进店
    public function readyIntoNum($data){
        $sql  = ' c.is_status=1 and i.status = 1 ';
        if ($data['customer_cource']) {
            $where['c.customer_cource'] = $data['customer_cource'];
        }
        $num = db('c_customer_intostore i')->join('c_customerinfo c','c.id=i.cid','LEFT')
            ->where($sql)
            ->where($where)
            ->where('i.yjd_day','between',[$data['start'],$data['end']])
            ->where('i.consulation_shop_code', 'in', $data['shop_code'])
            ->count();
        return $num;
    }
    // 进客模块 今日未进店
    public function notIntoNum($data){
        $sql  = ' c.is_status=1 and i.status = 1 ';
        if ($data['customer_cource']) {
            $where['c.customer_cource'] = $data['customer_cource'];
        }
        $num = db('c_customer_intostore i')->join('c_customerinfo c','c.id=i.cid','LEFT')
            ->where($sql)
            ->where($where)
            ->where('i.is_intostore', 'in', [1,4])
            ->where('i.yjd_day','between',[$data['start'],$data['end']])
            ->where('i.consulation_shop_code', 'in', $data['shop_code'])
            ->count();
        // echo db()->getLastSql();
        return $num;
    }
    // 进客模块 已成交
    public function intoOrderNum($data){
        $sql  = ' c.is_status=1 and i.status = 1 ';
        if ($data['customer_cource']) {
            $where['c.customer_cource'] = $data['customer_cource'];
        }
        $num = db('c_customer_intostore i')->join('c_customerinfo c','c.id=i.cid','LEFT')->join('c_customer_order o','o.into_id=i.id','LEFT')
            ->where($sql)
            ->where($where)
            ->where('i.is_success', 'in', '1,3')
            ->where('i.yjd_day','between',[$data['start'],$data['end']])
            ->where('i.consulation_shop_code', 'in', $data['shop_code'])
            ->count();
        return $num;
    }
    // 网付订单
    public function onlineOrderNum($data){
        $where['c.is_status'] = 1;
        $where['c.c_from'] = 1;
        if ($data['customer_cource']) {
            $where['c.customer_cource'] = $data['customer_cource'];
        }
        $num = db('c_customerinfo c')->join('c_customer_order o','c.id=o.customer_id','LEFT')
            ->where($sql)
            ->where($where)
            // ->where('o.order_valid', 1)
            ->where('o.target_time','between',[$data['start'],$data['end']])
            ->where('c.order_type',1)
            // ->where('o.consumption_type','not in', $this->noinConsultation)
            // ->where('c.consulation_shop_code', 'in', $data['shop_code'])
            ->count();
        // echo db()->getLastSql();
        return $num;
    }
    // 进客模块 进店流失非进客
    public function intoLossNum($data){
        $sql  = ' c.is_status=1 and i.status = 1 ';
        if ($data['customer_cource']) {
            $where['c.customer_cource'] = $data['customer_cource'];
        }
        $num = db('c_customer_intostore i')->join('c_customerinfo c','c.id=i.cid','LEFT')
            ->where($sql)
            ->where($where)
            ->where('i.is_intostore', 'in', '5,3')
            ->where('i.yjd_day','between',[$data['start'],$data['end']])
            ->where('i.consulation_shop_code', 'in', $data['shop_code'])
            ->count();
        return $num;
    }

    // 进店/邀约 量
    public function getIntoCustomerNum($data){
        $sql  = ' c.is_status=1 and i.status = 1 ';
        if ($data['customer_cource']) {
            $where['c.customer_cource'] = $data['customer_cource'];
        }

        $num = db('c_customer_intostore i')->join('c_customerinfo c','c.id=i.cid','LEFT')
            ->where($sql)
            ->where($where)
            ->where('i.is_intostore', '<>', 1)
            ->where('i.yjd_day','between',[$data['start'],$data['end']])
            ->where('i.consulation_shop_code', 'in', $data['shop_code'])
            ->count();
        return $num;
    }

    // 新单 量  订单开始时间 查询crm
    public function getOrderNumberNum_old($data){
        // 新单 定义：电商、网销录入的新客资  且已经有效的订单
        // $where['c_from']        = 1;
        $where['is_status']     = 1;
        // $where['customer_type'] = 1;

        $num = db('c_customerinfo')
            ->where($where)
            ->where('shop_code', 'in', $data['shop_code'])
            ->where('is_success', 'in', '1,3')
            ->where('order_start_time', 'between time', [$data['start'], $data['end']])
            ->count();

        // echo db()->getLastSql();
        // exit;
        return $num;
    }
    // 新单 量  订单开始时间 (查询erp数据)
    public function getOrderNumberNum($data){
        $start = date('Ymd',strtotime($data['start']));
        $end = date('Ymd',strtotime($data['end']));
        
        if ($data['customer_cource']) {
            $where['c.cssname'] = $data['customer_cource'];
        }

        $num = db('c_customerorder', 'sx_erp_hs')->alias('o')
            ->join('c_customerinfo c', 'o.customerid = c.customerid', 'left')
            ->where($where)
            ->where('o.consumption_type','not in', $this->noinConsultation)
            ->where('o.shop_code', 'in', $data['shop_code'])
            ->where('o.payment_money', '>', 0)
            ->where('o.targetdate', 'between', [$start, $end])
            ->count();
        return $num;
    }

    // 新单 量  订单开始时间 (查询erp数据)
    public function getOrderNumCource($data){
        $start = date('Ymd',strtotime($data['start']));
        $end = date('Ymd',strtotime($data['end']));
        
        $num = db('c_customerorder', 'sx_erp_hs')->alias('o')
            ->join('c_customerinfo c', 'o.customerid = c.customerid', 'left')
            ->where('o.consumption_type','not in', $this->noinConsultation)
            ->where('o.shop_code', 'in', $data['shop_code'])
            ->where('o.payment_money', '>', 0)
            ->where('o.targetdate', 'between', [$start, $end])
            ->group('c.cssname')
            ->column('count(o.id) as num','c.cssname');

        // echo db('c_customerorder', 'sx_erp_hs')->getLastSql();
        // exit;
        return $num;
    }

}