<?php
/**
 * 电商员工业绩报表 (按录入计算)  
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: lilong/wangzhenya 2018-05-24 $
 */
namespace app\crm\lib\report;
use app\crm\lib\Report;
use think\Controller;
use think\Session;

class Ds_staffwork extends Report {

	private $level= 3;
	private $type = 1;
	private $code = 'ds_staffwork';

	public function getLevel(){
		return $this->level;
	}
	public function getType(){
		return $this->type;
	}
	public function getCode(){
		return $this->code;
	}
	public function data(){
		$param = input();
		$shop_code = session('shop_code');

		// 选择了岗位 查询岗位下的人
		if ($param['position']) {
			$mcData['main_position_code'] = $param['position'];
			$positionStaff = cache('positionStaff_'.$param['position']);
			if (!$positionStaff) {
				$url='5a19201a33c20';
				$mcData['get_leave']  = 2;
				$res = sx_call($url, $mcData);
				if ($res['code'] == 200) {
					$positionStaff = $res['data'];
					cache('positionStaff_'.$param['position'], $positionStaff);
				} else {
					$positionStaff = [];
					return json(array('code' => 100, 'msg' => '岗位下没有员工', 'count' => 0, 'data' => ''));
				}
			}

			$ids = '';
			$baseStaff = [];
			foreach ($positionStaff as $key => $value) {
				$ids .= $value['id'].',';
				$baseStaff[$value['id']]['staffname'] = $value['staffname'];
				$baseStaff[$value['id']]['fTelNum']   = NULL;
				$baseStaff[$value['id']]['fWechatNum']= NULL;
				$baseStaff[$value['id']]['fQqNum']    = NULL;
				$baseStaff[$value['id']]['mkzNum']    = NULL;
				$baseStaff[$value['id']]['yxNum']     = NULL;
				$baseStaff[$value['id']]['wxNum']     = NULL;
				$baseStaff[$value['id']]['ddNum']     = NULL;
				$baseStaff[$value['id']]['bhNum']     = NULL;
			}
			$ids = trim($ids,',');
		}
		// 没有选择岗位，查店下的人
		else{
			$shopStaffs = cache('shopStaffs'.session('shop_code'));
			if (!$shopStaffs) {
				$url='5a19201a33c20';
				$mcData['shop_code'] = session('shop_code');
				$mcData['get_leave'] = 2;
				$res = sx_call($url, $mcData);
				if ($res['code'] == 200) {
					$shopStaffs = $res['data'];
					cache('shopStaffs'.session('shop_code'), $shopStaffs);
				} else {
					$shopStaffs = [];
					return json(array('code' => 200, 'msg' => '店下没有员工', 'count' => 0, 'data' => ''));
				}
			}
			$ids = '';
			$baseStaff = [];
			foreach ($shopStaffs as $key => $value) {
				$ids .= $value['id'].',';
				$baseStaff[$value['id']]['staffname'] = $value['staffname'];
				$baseStaff[$value['id']]['fTelNum']   = NULL;
				$baseStaff[$value['id']]['fWechatNum']= NULL;
				$baseStaff[$value['id']]['fQqNum']    = NULL;
				$baseStaff[$value['id']]['mkzNum']    = NULL;
				$baseStaff[$value['id']]['yxNum']     = NULL;
				$baseStaff[$value['id']]['wxNum']     = NULL;
				$baseStaff[$value['id']]['ddNum']     = NULL;
				$baseStaff[$value['id']]['bhNum']     = NULL;
			}
			$ids = trim($ids,',');
		}
		// 开始结束时间，如果没有，则为当天
		if (!$param['start']) {
			$start = date('Y-m-d 00:00:00', time());
		}else{
			$start = date('Y-m-d 00:00:00', strtotime($param['start']));
		}
		if (!$param['end']) {
			$end = date('Y-m-d 23:59:59', time());
		}else{
			$end = date('Y-m-d 23:59:59', strtotime($param['end']));
		}

		$getM['start'] = $start;
		$getM['end']   = $end;
		$months = getMonths($getM);

		// 基础查询条件
		$baseWhere['c_from']        = 1;
		$baseWhere['is_status']     = 1;
		$baseWhere['customer_type'] = 1;
		$baseWhere['add_shop_code'] = $shop_code;

		// 消费类型
		if ($param['consultationType']) {
			$where['consultation_type_id'] = (int)$param['consultationType'];
		}
		// 获取方式
		if ($param['accessModel']) {
			$where['access_model_id'] = (int)$param['accessModel'];
		}

		// 省市
		if ($param['province']) {
			$where['province_id'] = (int)$param['province'];
		}
		if ($param['city']) {
			$where['city_id'] = (int)$param['city'];
		}

		$allData = [];
		foreach ($months as $key => $value) {
			// $dbName = 'd_customerinfo_'.$key;
			$dbName = 'c_customerinfo';
			// 首次获取手机
			$fTel = db($dbName)
				->where($baseWhere)
				->where($where)
				->where('dj_staff_id', 'in', $ids)
				->where('is_valid', 1)
				->where('yx_day', 'between', [$value['start'], $value['end']])
				->where('is_first_tel', 1)
				->group('dj_staff_id')
				->column('dj_staff, count(*) as fTelNum', 'dj_staff_id');
			foreach ($fTel as $key => $val) {
				$baseStaff[$key]['fTelNum'] = $val['fTelNum'];
			}

			// 首次获取微信
			$fWechat = db($dbName)
				->where($baseWhere)
				->where($where)
				->where('dj_staff_id', 'in', $ids)
				->where('is_valid', 1)
				->where('yx_day', 'between', [$value['start'], $value['end']])
				->where('is_first_tel','null')
				->where('is_first_wechat',1)
				->group('dj_staff_id')
				->column('dj_staff, count(*) as fWechatNum', 'dj_staff_id');
			foreach ($fWechat as $key => $val) {
				$baseStaff[$key]['fWechatNum'] = $val['fWechatNum'];
			}

			// 首次获取qq
			$fQq = db($dbName)
				->where($baseWhere)
				->where($where)
				->where('dj_staff_id', 'in', $ids)
				->where('is_valid', 1)
				->where('yx_day', 'between', [$value['start'], $value['end']])
				->where('is_first_tel', 'null')
				->where('is_first_wechat', 'null')
				->where('is_first_qq', 1)
				->group('dj_staff_id')
				->column('dj_staff, count(*) as fQqNum', 'dj_staff_id');
			foreach ($fQq as $key => $val) {
				$baseStaff[$key]['fQqNum'] = $val['fQqNum'];
			}
			// 毛客资
			$mkz = db($dbName)
				->where($baseWhere)
				->where('dj_staff_id', 'in', $ids)
				->where('dj_day', 'between', [$value['start'], $value['end']])
				->group('dj_staff_id')
				->column('dj_staff,count(*) as mkzNum', 'dj_staff_id');
			foreach ($mkz as $key => $val) {
				$baseStaff[$key]['mkzNum'] = $val['mkzNum'];
			}
			// echo db ()->getLastSql();
			// 有效/无效/待定/驳回 客资总量
			$yx = db($dbName)
				->where($baseWhere)
				->where($where)
				->where('yx_day', 'between', [$value['start'], $value['end']])
				->where('dj_staff_id', 'in', $ids)
				->group('dj_staff_id, is_valid')
				->field('dj_staff,dj_staff_id,is_valid,count(*) as num')
				->select();

			foreach ($yx as $key => $val) {
				// 有效
				if ($val['is_valid'] == 1) {
					$baseStaff[$val['dj_staff_id']]['yxNum'] = $val['num'];
				}
				// 待定
				if ($val['is_valid'] == 2) {
					$baseStaff[$val['dj_staff_id']]['ddNum'] = $val['num'];
				}
				// 无效
				if ($val['is_valid'] == 3) {
					$baseStaff[$val['dj_staff_id']]['wxNum'] = $val['num'];
				}
				// 驳回给电商
				if ($val['is_valid'] == 4) {
					$baseStaff[$val['dj_staff_id']]['bhNum'] = $val['num'];
				}
				// 反驳回给网销
				// if ($val['is_valid'] == 5) {
				// 	$baseStaff[$val['dj_staff_id']]['yxNum'] = $val['num'];
				// }
			}
		}

		return json(array('code' => 0, 'msg' => '', 'count' => count($baseStaff), 'data' => $baseStaff));
	}
	public function show(){
		
		$html = strtolower(input('param.id'));
		$display = APP_PATH.'crm'.DS.'view'.DS.'report'.DS.$html.'.html';

		$code = $this->getCode();

		// 岗位列表
		$position=controller("crm/Setting","lib")->get_position_list(array('shop_code'=>session('shop_code')));
		$this->assign('position',$position);

		// 消费类型列表
		$param['shop_type'] = session('shop_type');
		$consultationType = consultationType($param);

		$this->assign('consultationType',$consultationType);

		// 获取方式列表
		$accessModel=controller("crm/Customer","lib")->accessModel();
		$this->assign('accessModel',$accessModel);

		// crm省    列表
		$data['type'] = 1;
		$province = controller("Customer", "lib")->address($data);
		$this->assign('province', $province);

		//来源渠道
		// $channel = controller("Customer", "lib")->getChannel();
		// $this->assign("channel", $channel);

		$title = db('s_report_form')->where('code', $code)->value('report_name');
		$this->assign('title', $title);

		$this->assign('shop_code', session('shop_code'));

		return $this->fetch($display);
	}

}