<?php
/**
 * 报表实现类 小组数据统计
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: lilong/wangzhenya 2018-05-29 $
 */
namespace app\crm\lib\report;
use app\crm\lib\Report;
use think\Controller;
use think\image\Exception;

class Jj_staff_data extends Report {

    private $level=1;
    private $type=3;
    private $code='code1533161172';

    public function getLevel(){
        return $this->level;

    }
    public function getType(){
        return $this->type;
    }
    public function getCode(){
        return $this->code;
    }
    public function data()
    {
        set_time_limit(0);
        // 权限
        $auth = check_right('menu1521352658');
        if (!$auth) {
            $return = ['code' => 0, 'msg' => '', 'count' => 0, 'data' => ''];
            return json($return);
        }
        $data = input();

        $det = db('s_report_form')->alias('f')->join('s_report_detail d','d.form_id=f.id')->where('d.id',$data['did'])->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();
        $shopCode = $det['shop_code'];
        if(empty($shopCode)){
            return array('code'=>100,'msg'=>'报表配置有误');
        }

        if($data['group_id']){
            $staffList = db('c_staff_group_relation')->where('group_id', $data['group_id'])->select();
            foreach($staffList as $k=>$v){
                $staffList[$k]['id'] = $v['staff_id'];
                $staffList[$k]['staff_name'] = $v['staff_name'];
            }
        }else{
            //获取店下的所以人
            $staffList = controller('crm/Customer','lib')->get_staff_lists(['shop_code'=>$shopCode]);
        }


        // 时间区域
        $start = date('Y-m-d', strtotime($data['start']));
        $end = date('Y-m-d 23:59:59', strtotime($data['end']));
        $where['c.is_status'] = 1;
        $where['c.c_from'] = 1;

        $where['c.shop_code'] = $shopCode;

        $sql = '';
        $sql .= "sum(dj_day between '$start' and '$end') as mkz,";
        $sql .= "sum(is_valid=1 and dj_day between '$start' and '$end') as valid,";//有效
        $sql .= "sum(is_valid=2 and dj_day between '$start' and '$end') as dd,";//待定
        $sql .= "sum(is_valid in('3','4','5') and dj_day between '$start' and '$end') as wx,";//无效
        $sql .= "sum(fact_money>0 and order_start_time between '$start' and '$end') as `order`";//成交
        $sql_zy = "sum(fact_money>0 and customer_channel<>'官方抖音' and customer_channel<>'官方快手' and order_start_time between '$start' and '$end') as zyOrder";//资源订单：收款大于0，排除抖音，快手
        if($data['channel']){
            $info= db('c_customerinfo c')->join('c_customer_from f','c.id=f.cid','left')
                ->where($where)
                ->where('customer_channel','in',$data['channel'])
                ->group('c.sales_staff_id')
                ->column($sql,'c.sales_staff_id');
            $channel = explode(',',$data['channel']);
            if(in_array('官方抖音',$channel) || in_array('官方抖音',$channel)){
                foreach($channel as $key=>$value){
                    if($value == '官方抖音' || $value == '官方快手'){
                        unset($channel[$key]);
                    }
                }
            }
            $info1= db('c_customerinfo c')->join('c_customer_from f','c.id=f.cid','left')
                ->where($where)
                ->where('customer_channel','in',$channel)
                ->group('c.sales_staff_id')
                ->column($sql_zy,'c.sales_staff_id');
            $info = array_merge($info,$info1);
        }else{
            $info= db('c_customerinfo c')->join('c_customer_from f','c.id=f.cid','left')
                ->where($where)
                ->group('c.sales_staff_id')
                ->column($sql,'c.sales_staff_id');
        }

        $total = [];//最后总计
        $returnData = [];
        $i = 1;
        foreach($staffList as $k=>$v){
                $arr = [];
                $arr['id'] = $i;
                $arr['staff_name'] = $v['staff_name'] ? $v['staff_name'] : $v['staffname'];
                $arr['mkz'] = $info[$v['id']]['mkz'];
                $arr['valid'] = $info[$v['id']]['valid'];
                $arr['validRate'] = $info[$v['id']]['valid']?sprintf('%.2f',$info[$v['id']]['valid']/$info[$v['id']]['mkz']*100).'%':'';
                $arr['dd'] = $info[$v['id']]['dd'];
                $arr['ddRate'] = $info[$v['id']]['dd']?sprintf('%.2f',$info[$v['id']]['dd']/$info[$v['id']]['mkz']*100).'%':'';
                $arr['wx'] = $info[$v['id']]['wx'];
                $arr['wxRate'] = $info[$v['id']]['wx']?sprintf('%.2f',$info[$v['id']]['wx']/$info[$v['id']]['mkz']*100).'%':'';
                $arr['order'] = $info[$v['id']]['order'];
                $arr['zyOrder'] = $info[$v['id']]['zyOrder'];
                $arr['zyOrderRate'] = $info[$v['id']]['zyOrder']?sprintf('%.2f',$info[$v['id']]['zyOrder']/($arr['valid']+$arr['dd'])*100).'%': '';
                $arr['validOrderRate'] = $info[$v['id']]['zyOrder']?sprintf('%.2f',$info[$v['id']]['zyOrder']/($arr['valid'])*100).'%': '';
                $arr['allZyOrderRate'] = $info[$v['id']]['zyOrder']?sprintf('%.2f',$info[$v['id']]['zyOrder']/($arr['mkz'])*100).'%': '';
                $arr['orderRate'] = $info[$v['id']]['order']?sprintf('%.2f',$info[$v['id']]['order']/($arr['valid']+$arr['dd'])*100).'%': '';
                $arr['allOrderRate'] = $info[$v['id']]['order']?sprintf('%.2f',$info[$v['id']]['order']/($arr['mkz'])*100).'%': '';

                $returnData[] = $arr;

                //最后总计
                $total['staff_name'] = '总计';
                $total['mkz'] += $info[$v['id']]['mkz'];
                $total['valid'] += $info[$v['id']]['valid'];
                $total['validRate'] = '';
                $total['dd'] += $info[$v['id']]['dd'];
                $total['ddRate'] = '';
                $total['wx'] += $info[$v['id']]['wx'];
                $total['wxRate'] = '';
                $total['order'] += $info[$v['id']]['order'];
                $total['zyOrder'] += $info[$v['id']]['zyOrder'];
                $i++;
        }
        $total['validRate'] = $total['valid']?sprintf('%.2f',$total['valid']/($total['mkz'])*100).'%': '';
        $total['ddRate'] = $total['zyOrder']?sprintf('%.2f',$total['dd']/($total['mkz'])*100).'%': '';
        $total['wxRate'] = $total['zyOrder']?sprintf('%.2f',$total['wx']/($total['mkz'])*100).'%': '';
        $total['zyOrderRate'] = $total['zyOrder']?sprintf('%.2f',$total['zyOrder']/($total['valid']+$total['dd'])*100).'%': '';
        $total['validOrderRate'] = $total['zyOrder']?sprintf('%.2f',$total['zyOrder']/($total['valid'])*100).'%': '';
        $total['allZyOrderRate'] = $total['zyOrder']?sprintf('%.2f',$total['zyOrder']/($total['mkz'])*100).'%': '';
        $total['orderRate'] = $total['order']?sprintf('%.2f',$total['order']/($total['valid']+$total['dd'])*100).'%': '';
        $total['allOrderRate'] = $total['order']?sprintf('%.2f',$total['order']/($total['mkz'])*100).'%': '';
        $returnData[] = $total;

        $return['code'] = 0;
        $return['msg'] = '';
        $return['count'] = count($returnData);
        $return['data'] = $returnData;
        return json($return);
    }

    public function show(){
        $code = $this->getCode();
        $did = strtolower(input('param.did'));
        $info = db('s_report_form')->alias('f')->join('s_report_detail d','d.form_id=f.id')->where('d.id',$did)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();
        $shop= controller('crm/Customer','lib')->get_shop(['shop_code'=>$info['shop_code']]);

        //来源渠道
        $channel = db('s_channel')->where('shop_code','in',$info['shop_code'])->order('order_sort')->select();
        $this->assign("channel", $channel);

        //获取店下的小组
        $group = db('c_staff_group')->where('shop_code', $info['shop_code'])->select();
        $this->assign('group', $group);
        $display = APP_PATH.'crm'.DS.'view'.DS.'report'.DS.strtolower($info['report_class_name']).'.html';
        $title = db('s_report_form')->where('code', $code)->value('report_name');
        $this->assign('title', $shop[0]['shop_name'].'-'.$title);
        $this->assign('did', $info['id']);
        return $this->fetch($display);
    }

}