<?php
/**
 * 报表实现类 电商渠道占比
 * *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: wangzhenya 2018-08-20 $
 */
namespace app\crm\lib\report;
use app\crm\lib\Report;
use think\Controller;
use think\image\Exception;
class Jw_ds_channel_ratio extends Report{
    private $level = 1;
    private $type = 1;
    private $code = 'code1535455531';

    public function getLevel()
    {
        return $this->level;

    }

    public function getType()
    {
        return $this->type;
    }

    public function getCode()
    {
        return $this->code;
    }

    public function data()
    {
        $data = input();
        $start = date('Y-m-d 00:00:00', strtotime($data['start']));
        $end = date('Y-m-d 23:59:59', strtotime($data['end']));
        $det = db('s_report_form')->alias('f')->join('s_report_detail d','d.form_id=f.id')->where('d.id',$data['did'])->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();

        $shop_code = $det['shop_code'];
        if(empty($shop_code)){
            return array('code'=>100,'msg'=>'报表配置有误');
        }
        $channel = controller('crm/Customer','lib')->getChannel($shop_code);
        //本地外地
        $city = db_config('sx_city_id_'.$det['brandclass_id']);
        if(empty($city)){
            return array('code'=>101,'msg'=>'未设置本地配置,请先去配置');
        }
        //花费
        $cost = db('s_channel_cost')
            ->where('cost_date', 'between time', [$start, $end])
            ->where('shop_code',$shop_code)
            ->where('city_id',$city)
            ->group('channel_id')
            ->column('sum(cost) as cost','channel_id');

        $totalCost = array_sum(array_values($cost));

        $other = db('s_channel_cost')
            ->where('cost_date', 'between time', [$start, $end])
            ->where('shop_code',$shop_code)
            ->where('city_id','<>',$city)
            ->group('channel_id')
            ->column('sum(cost) as cost','channel_id');

        $totalOtherCost = array_sum(array_values($other));

        $returnData = [];
        $returnData[0][0] = '区域';
        foreach($channel as $k=>$v){
            $returnData[0][$k+1] = $v['channel_name'];
        }
        $returnData[1][0] = '本地';
        foreach($channel as $k=>$v){

            $returnData[1][$k+1] = $cost[$v['id']] ? sprintf('%.2f',$cost[$v['id']]/$totalCost*100).'%' : '0%';
        }
        $returnData[2][0] = '外地';
        foreach($channel as $k=>$v){
            $returnData[2][$k+1] = $other[$v['id']] ? sprintf('%.2f',$other[$v['id']]/$totalOtherCost*100).'%' : '0%';
        }
        $returnData[3][0] = '总计';
        foreach($channel as $k=>$v){
            $returnData[3][$k+1] = $cost[$v['id']]+$other[$v['id']]>0 ? sprintf('%.2f',($cost[$v['id']]+$other[$v['id']])/($totalCost+$totalOtherCost)*100).'%' : '0%';
        }
        // 导出
        if ($data['need'] == 1) {
            $title = $returnData[0];
            unset($returnData[0]);
            $code = $this->getCode();
            $ff = db('s_report_form')->where('code', $code)->value('report_name');
            $shop = controller('crm/Customer','lib')->get_shop(['shop_code'=>$data['shop_code']]);
            $file = $shop[0]['shop_name'].'-'.$ff.'.xlsx';
            controller("crm/Customer", "lib")->export($title, $returnData, $file);
        } else {
            return json(array('code' => 200, 'data' => $returnData, 'count' => count($channel)+1));
        }
    }
    public function show()
    {
        $did = strtolower(input('param.did'));
        $info = db('s_report_form')->alias('f')->join('s_report_detail d','d.form_id=f.id')->where('d.id',$did)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();
        $code = $this->getCode();
        $display = APP_PATH.'crm'.DS.'view'.DS.'report'.DS.strtolower($info['report_class_name']).'.html';
        $title = db('s_report_form')->where('code', $code)->value('report_name');
        $shop= controller('crm/Customer','lib')->get_shop(['shop_code'=>$info['shop_code']]);

        $this->assign('title', $shop[0]['shop_name'].'-'.$title);
        $this->assign('did', $info['id']);
        return $this->fetch($display);
    }
}