<?php
/**
 * 报表实现类 进店客资成交汇总
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: wangzhenya 2018-06-12 $
 */
namespace app\crm\lib\report;
use app\crm\lib\Report;
use think\Controller;
use think\image\Exception;

class Tcdj_into_data extends Report {

    private $level=1;
    private $type=1;
    private $code='code1576808504';

    public function getLevel(){
        return $this->level;

    }
    public function getType(){
        return $this->type;
    }
    public function getCode(){
        return $this->code;
    }
    public function data()
    {
        set_time_limit(0);
        $data = input();
        $det = db('s_report_form')->alias('f')->join('s_report_detail d','d.form_id=f.id')->where('d.id',$data['did'])->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name,f.report_name')->find();
        $brandclass_id = $det['brandclass_id'];
        if(empty($brandclass_id)){
            return array('code'=>100,'msg'=>'报表配置有误');
        }
        $start = $data['start'] ? date('Y-m-d', strtotime($data['start'])) : date('Y-m-d 00:00:00');
        $end =  $data['end'] ? date('Y-m-d 23:59:59', strtotime($data['end'])) : date('Y-m-d 23:59:59');

        $where['is_status'] = 1;
        if($data['shop_name']){
            $shop = controller('crm/Customer','lib')->get_shop(['shop_name'=>$data['shop_name']]);
            $where['shop_name'] = array('in',array_column($shop,'shop_name'));
        }else{
            $shop = controller('crm/Customer','lib')->get_shop(['brandclass_id'=>$det['brandclass_id']]);
            $where['shop_name'] = array('in',array_column($shop,'shop_name'));
        }
        if($data['consultation_type_id']){
            $where['consultation_type_id'] = intval($data['consultation_type_id']);
        }
        if($data['channel_name']){
            $where['customer_channel'] = ['in',explode(',',trim($data['channel_name']))];
        }
        $ds_sql = '';
        //电商
        $where['customer_cource'] = ['in',['电商','电商1','网络']];
        $ds_sql .= "sum(dj_day between '$start' and '$end') as ds_mkz,";
        $ds_sql .= "sum(is_intostore in ('2','3','5') and syjd_day between '$start' and '$end') as ds_into,";
        $ds_sql .= "sum(fact_money>0 and order_start_time between '$start' and '$end') as `ds_order`";
        // 录入客资量
        $ds_info= db('c_customerinfo')
            ->where($where)
            ->group('shop_name')
            ->column($ds_sql,'shop_name');
        //转介绍
        $where['customer_cource'] = ['in',['转介绍','老客户转介绍','员工转介绍']];
        $zjs_sql = "sum(dj_day between '$start' and '$end') as zjs_mkz,";
        $zjs_sql .= "sum(fact_money>0 and order_start_time between '$start' and '$end') as zjs_order";
        $zjs_info= db('c_customerinfo')
            ->where($where)
            ->group('shop_name')
            ->column($zjs_sql,'shop_name');
        //自然进店
        $where['customer_cource'] = '自然进店';
        $zr_sql = "sum(dj_day between '$start' and '$end') as zr_mkz,";
        $zr_sql .= "sum(fact_money>0 and order_start_time between '$start' and '$end') as zr_order";
        $zr_info= db('c_customerinfo')
            ->where($where)
            ->group('shop_name')
            ->column($zr_sql,'shop_name');
        //其他
        $where['customer_cource'] = ['in',['展会','异业联盟']];
        $other_sql = "sum(dj_day between '$start' and '$end') as other_mkz,";
        $other_sql .= "sum(fact_money>0 and order_start_time between '$start' and '$end') as other_order";
        $other_info= db('c_customerinfo')
            ->where($where)
            ->group('shop_name')
            ->column($other_sql,'shop_name');
        $return = [];
        $total['shop_name'] = '总计';
        foreach($shop as $k=>$v){
            $return[$k]['shop_name'] = $v['shop_name'];

            $return[$k]['ds_mkz'] = $ds_info[$v['shop_name']]['ds_mkz'] ? $ds_info[$v['shop_name']]['ds_mkz'] : '';
            $return[$k]['ds_into'] = $ds_info[$v['shop_name']]['ds_into'] ? $ds_info[$v['shop_name']]['ds_into'] : '';
            $return[$k]['ds_into_rate'] = $ds_info[$v['shop_name']]['ds_into']/$ds_info[$v['shop_name']]['ds_mkz']>0 ? sprintf('%.2f',$ds_info[$v['shop_name']]['ds_into']/$ds_info[$v['shop_name']]['ds_mkz']*100).'%' : '';
            $return[$k]['ds_order'] = $ds_info[$v['shop_name']]['ds_order'] ? $ds_info[$v['shop_name']]['ds_order'] : '';
            $return[$k]['ds_order_rate'] = $ds_info[$v['shop_name']]['ds_order']/$ds_info[$v['shop_name']]['ds_into']>0 ? sprintf('%.2f',$ds_info[$v['shop_name']]['ds_order']/$ds_info[$v['shop_name']]['ds_into']*100).'%' : '';

            $return[$k]['zjs_mkz'] = $zjs_info[$v['shop_name']]['zjs_mkz'] ? $zjs_info[$v['shop_name']]['zjs_mkz'] : '';
            $return[$k]['zjs_order'] = $zjs_info[$v['shop_name']]['zjs_order'] ? $zjs_info[$v['shop_name']]['zjs_order'] : '';
            $return[$k]['zjs_order_rate'] = $zjs_info[$v['shop_name']]['zjs_order']/$zjs_info[$v['shop_name']]['zjs_mkz']>0 ? sprintf('%.2f',$zjs_info[$v['shop_name']]['zjs_order']/$zjs_info[$v['shop_name']]['zjs_mkz']*100).'%' : '';

            $return[$k]['zr_mkz'] = $zr_info[$v['shop_name']]['zr_mkz'] ? $zr_info[$v['shop_name']]['zr_mkz'] : '';
            $return[$k]['zr_order'] = $zr_info[$v['shop_name']]['zr_order'] ? $zr_info[$v['shop_name']]['zr_order'] : '';
            $return[$k]['zr_order_rate'] = $zr_info[$v['shop_name']]['zr_order']/$zr_info[$v['shop_name']]['zr_mkz']>0 ? sprintf('%.2f',$zr_info[$v['shop_name']]['zr_order']/$zr_info[$v['shop_name']]['zr_mkz']*100).'%' : '';

            $return[$k]['other_mkz'] = $other_info[$v['shop_name']]['other_mkz'] ? $other_info[$v['shop_name']]['other_mkz'] : '';
            $return[$k]['other_order'] = $other_info[$v['shop_name']]['other_order'] ? $other_info[$v['shop_name']]['other_order'] : '';
            $return[$k]['other_order_rate'] = $other_info[$v['shop_name']]['other_order']/$other_info[$v['shop_name']]['other_mkz']>0 ? sprintf('%.2f',$other_info[$v['shop_name']]['other_order']/$other_info[$v['shop_name']]['other_mkz']*100).'%' : '';

            $return[$k]['mkz'] = $ds_info[$v['shop_name']]['ds_mkz']+$zjs_info[$v['shop_name']]['zjs_mkz']+$zr_info[$v['shop_name']]['zr_mkz']+$other_info[$v['shop_name']]['other_mkz'];
            $return[$k]['order'] = $ds_info[$v['shop_name']]['ds_order']+$zjs_info[$v['shop_name']]['zjs_order']+$zr_info[$v['shop_name']]['zr_order']+$other_info[$v['shop_name']]['other_order'];
            $return[$k]['order_rate'] = $return[$k]['order']/$return[$k]['mkz']>0 ? sprintf('%.2f',$return[$k]['order']/$return[$k]['mkz']*100).'%' : '';

            $total['ds_mkz'] +=$ds_info[$v['shop_name']]['ds_mkz'];
            $total['ds_into'] +=$ds_info[$v['shop_name']]['ds_into'];
            $total['ds_into_rate'] = '';
            $total['ds_order'] +=$ds_info[$v['shop_name']]['ds_order'];
            $total['ds_order_rate'] = '';

            $total['zjs_mkz'] +=$zjs_info[$v['shop_name']]['zjs_mkz'];
            $total['zjs_order'] +=$zjs_info[$v['shop_name']]['zjs_order'];
            $total['zjs_order_rate'] = '';

            $total['zr_mkz'] +=$zr_info[$v['shop_name']]['zr_mkz'];
            $total['zr_order'] +=$zr_info[$v['shop_name']]['zr_order'];
            $total['zr_order_rate'] = '';

            $total['other_mkz'] +=$other_info[$v['shop_name']]['other_mkz'];
            $total['other_order'] +=$other_info[$v['shop_name']]['other_order'];
            $total['order_rate'] = '';

            $total['mkz'] += $return[$k]['mkz'];
            $total['order'] += $return[$k]['order'];
            $total['order_rate'] = '';
        }
        $total['ds_into_rate'] = $total['ds_into']/$total['ds_mkz']>0 ? sprintf('%.2f',$total['ds_into']/$total['ds_mkz']*100).'%' : '';
        $total['ds_order_rate'] = $total['ds_order']/$total['ds_into']>0 ? sprintf('%.2f',$total['ds_order']/$total['ds_into']*100).'%' : '';
        $total['zjs_order_rate'] = $total['zjs_into']/$total['zjs_order']>0 ? sprintf('%.2f',$total['zjs_into']/$total['zjs_order']*100).'%' : '';
        $total['zr_order_rate'] = $total['zr_into']/$total['zr_order']>0 ? sprintf('%.2f',$total['zr_into']/$total['zr_order']*100).'%' : '';
        $total['other_order_rate'] = $total['other_into']/$total['other_order']>0 ? sprintf('%.2f',$total['other_into']/$total['other_order']*100).'%' : '';
        $total['order_rate'] = $total['order']/$total['mkz']>0 ? sprintf('%.2f',$total['order']/$total['mkz']*100).'%' : '';
        if(count($shop) > 1){
            array_push($return,$total);
        }
        $returnData['code'] = 0;
        $returnData['msg'] = '';
        $returnData['count'] = count($return);
        $returnData['data'] = $return;
        return json($returnData);
    }

    public function show(){
        $code = $this->getCode();
        $did = strtolower(input('param.did'));
        $info = db('s_report_form')->alias('f')->join('s_report_detail d','d.form_id=f.id')->where('d.id',$did)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();

        $display = APP_PATH.'crm'.DS.'view'.DS.'report'.DS.strtolower($info['report_class_name']).'.html';
        $title = db('s_report_form')->where('code', $code)->value('report_name');
        $shop= controller('crm/Customer','lib')->get_shop(['brandclass_id'=>$info['brandclass_id']]);
        //消费类型
        $consumptionType = controller("Customer", "lib")->consumptionType(['brandclass_id'=>$info['brandclass_id']]);
        $this->assign("consumptionType", $consumptionType);

        $this->assign('shop', $shop);
        $channels = getChannelJson($info['shop_code']);
        $this->assign('channel', json_encode($channels));
        $this->assign('title', $shop[0]['brandclass'].'-'.$title);
        $this->assign('did', $info['id']);
        return $this->fetch($display);
    }

}