<?php

/**
 * 异步写日志监听服务
 * 
 *  * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 * 
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: songdemei<songdemei@suxuantech.cn> 2018-03-16 $
 */
namespace app\crm\command;
use think\console\Command;
use think\console\Input;
use think\console\Output;

class Runlogs extends Command{

    protected function configure()
    {
        $this->setName('runlogs')->setDescription('Suxuan system service: logs save');
    }
    
    protected function execute(Input $input, Output $output)
    {
        /**
         *要操作的类，此类必须在LIB下面
         * 
         */
        $controller = 'ListenRedis';
        /**
         * 类里的方法 处理方法
         */
        $method = 'syncLogs';
        
        if(!class_exists('app\\crm\\lib\\'.ucwords($controller))){
            echo '没有发现这个类：'.$controller."\r\n";
            exit();
        }
        $instance = new \ReflectionClass('app\\crm\\lib\\'.ucwords($controller));
        if (!$instance->hasMethod($method)) {
            echo '没有发现这个方法：'.$method."\r\n";
            exit();
        }
        $objMethod = $instance->getMethod($method);
        $handle = $instance->newInstance();
        while (1){
            $dbData = db()->master()->query("select sysdate() as time");
            echo "Start new loop run at ".date('Y-m-d H:i:s').",dbDate:".$dbData[0]['time']."\r\n";
            try{
                $objMethod->invokeArgs($handle, array($this->apiParams,  $this->appId));
            }  catch (\Exception $e){
                if(!file_exists(ROOT_PATH.DS.'runtime'.DS.'log'.DS.  'run')){
                    mkdir(ROOT_PATH.DS.'runtime'.DS.'log'.DS.  'run',0777,true);
                }
//                file_put_contents(ROOT_PATH.DS.'runtime'.DS.'logs'.DS. 'run' .DS.'runlogs.log', date('Y-m-d H:i:s')."\t".'run error '.$e->getMessage().  json_encode($e->getTraceAsString()),FILE_APPEND);
                var_dump($e->getMessage());
                sleep(1);
            }
        }
        
    }

}