<?php
/**
 * 大屏控制器
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: lilong<lilong@suxuantech.cn> $
 */
namespace app\crm\controller;
use think\Controller;
use think\Queue;
use think\Request;
// use app\index\controller\Base;

// class Lzl extends Base{
class Lzl extends Controller{
    /*
        兰州龙大屏，需要额外 在crm里增加两张表 和 setting控制器也要升级

        CREATE TABLE `s_goal` (
          `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
          `goal_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '目标名称,实收，订单，进客等',
          `key` varchar(20) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '维度key，如brandclass_id，shop_code，staff_id',
          `name` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '为谁设置的：某个店，事业部，人等',
          `shop_code` varchar(100) DEFAULT NULL,
          `method` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '目标维度，事业部、店，人等',
          `goal_value` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '目标值',
          `year` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '年份',
          `month` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '月份',
          `day` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '天',
          `status` tinyint(1) DEFAULT '1' COMMENT '是否启用：1：启用；2：关闭',
          `create_time` datetime DEFAULT NULL,
          PRIMARY KEY (`id`)
        ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='目标设定表';

        CREATE TABLE `s_goal_name` (
          `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
          `goal_name` varchar(50) DEFAULT NULL COMMENT '目标名称',
          `create_time` datetime DEFAULT NULL,
          PRIMARY KEY (`id`)
        ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='目标名称设定表';
    */
    
    // tab切换用  集团、礼服、兰州婚纱、兰州儿童、兰州写真、直营大店、直营小店
    // payclass  0门市收款 1礼服 2化妆 3VIP收款 4商品收款
    protected  $baseBrand = [ 
        '集团业绩' => [
            '0' =>[
                'shop_name' => '龙摄影',
                'shop_code' => 'LZL01,LZL02',
                'shop_type' => '1',// 婚纱
                'inclued_lf'=> '2',// 不包含礼服
                'payclass'  => '0,4',// 门市收款，商品收款
            ],
            '1' =>[
                'shop_name' => '世华洛',
                'shop_code' => 'LZL03',
                'shop_type' => '1',// 婚纱
                'inclued_lf'=> '2',// 不包含礼服
                'payclass'  => '0,4',// 门市收款，商品收款
            ],
            '2' =>[
                'shop_name' => '韩国印象',
                'shop_code' => 'LZL04',
                'shop_type' => '1',// 婚纱
                'inclued_lf'=> '2',// 不包含礼服
                'payclass'  => '0,4',// 门市收款，商品收款
            ],
            '3' =>[
                'shop_name' => '薇拉',
                'shop_code' => 'LZL05',
                'shop_type' => '1',// 婚纱
                'inclued_lf'=> '2',// 不包含礼服
                'payclass'  => '0,4',// 门市收款，商品收款
            ],
            /* '4' =>[
                'shop_name' => '格林童话',
                'shop_code' => 'LBB01',
                'shop_type' => '2',// 儿童
                'inclued_lf'=> '2',// 不包含礼服
            ],*/
            '4' =>[
                'shop_name' => '星光贝贝',
                'shop_code' => 'LBB02',
                'shop_type' => '2',// 儿童
                'inclued_lf'=> '2',// 不包含礼服
                'payclass'  => '0,4',// 门市收款，商品收款
            ],
            '5' =>[
                'shop_name' => '瑞丽风尚',
                'shop_code' => 'LZL06',
                'shop_type' => '1',// 婚纱
                'inclued_lf'=> '2',// 不包含礼服
                'payclass'  => '0,4',// 门市收款，商品收款
            ],
            // '6' =>[
            //     'shop_name' => '瑞丽纯色',
            //     'shop_code' => 'LZL07',
            //     'shop_type' => '1',// 婚纱
            //     'inclued_lf'=> '2',// 不包含礼服
            //     'payclass'  => '0,4',// 门市收款，商品收款
            // ],
            '7' =>[
                'shop_name' => '武威',
                'shop_code' => 'LBB08,LZL17,LZL18,LZL19,LZL13,LZL22',
                'shop_type' => '3',// 婚纱+儿童
                'inclued_lf'=> '1',// 包含礼服
                'payclass'  => '',// 门市收款，商品收款
            ],
            '8' =>[
                'shop_name' => '银川',
                'shop_code' => 'LZL15,LZL16,LBB07',
                'shop_type' => '3',// 婚纱+儿童
                'inclued_lf'=> '1',// 包含礼服
                'payclass'  => '',// 门市收款，商品收款
            ],
            '9' =>[
                'shop_name' => '天水',
                'shop_code' => 'LZL12,LZL14,LBB06',
                'shop_type' => '3',// 婚纱+儿童
                'inclued_lf'=> '1',// 包含礼服
                'payclass'  => '',// 门市收款，商品收款
            ],
            '10' =>[
                'shop_name' => '榆中',
                'shop_code' => 'LZL09,LZL10,LBB04',
                'shop_type' => '3',// 婚纱+儿童
                'inclued_lf'=> '1',// 包含礼服
                'payclass'  => '',// 门市收款，商品收款
            ],
            '11' =>[
                'shop_name' => '临洮',
                'shop_code' => 'LZL11,LBB05',
                'shop_type' => '3',// 婚纱+儿童
                'inclued_lf'=> '1',// 包含礼服
                'payclass'  => '',// 门市收款，商品收款
            ],
            '12' =>[
                'shop_name' => '永登',
                'shop_code' => 'LZL08,LBB03',
                'shop_type' => '3',// 婚纱+儿童
                'inclued_lf'=> '1',// 包含礼服
                'payclass'  => '',// 门市收款，商品收款
            ],
            '13' =>[
                'shop_name'=> '龙+韩',
                'shop_code'=> 'LZL01,LZL02,LZL04',
                'shop_type'=> '1',// 婚纱
                'select'   =>'eq',
                'payclass' => '1,2',// 礼服收款，化妆收款
                'fundname' => '化妆定金,化妆全款,化妆补款,礼服定金,礼服全款,礼服补款,完美新娘',
            ],
            '14' =>[
                'shop_name'=> '世+薇',
                'shop_code'=> 'LZL03,LZL05',
                'shop_type'=> '1',// 婚纱
                'select'   => 'eq',
                'payclass' => '1,2',// 礼服收款，化妆收款
                'fundname' => '化妆定金,化妆全款,化妆补款,礼服定金,礼服全款,礼服补款,完美新娘',
            ],
            '15' =>[
                'shop_name'=> '香榭丽舍',
                'shop_code'=> 'LZL01,LZL02,LZL03,LZL04,LZL05',
                'shop_type'=> '1',// 婚纱
                'select'   => 'eq',
                'payclass' => '1,2',// 礼服收款，化妆收款
                'fundname' => '基地三销款',
            ],
        ],
        '电商数据' => [
        ],
        '兰州婚纱' => [
            '0' =>[
                'shop_name' => '龙摄影',
                'shop_code' => 'LZL01,LZL02',
            ],
            '1' =>[
                'shop_name' => '世华洛',
                'shop_code' => 'LZL03',
            ],
            '2' =>[
                'shop_name' => '韩国印象',
                'shop_code' => 'LZL04',
            ],
            '3' =>[
                'shop_name' => '薇拉',
                'shop_code' => 'LZL05',
            ],
        ],
        '兰州写真/儿童' => [
            '0' =>[
                'shop_name' => '瑞丽风尚',
                'shop_code' => 'LZL06',
                'shop_type' => '1',// 婚纱
                'inclued_lf'=> '2',// 不包含礼服
                'payclass'  => '0,4',// 门市收款，商品收款
            ],
            // '1' =>[
            //     'shop_name' => '瑞丽纯色',
            //     'shop_code' => 'LZL07',
            //     'shop_type' => '1',// 婚纱
            //     'inclued_lf'=> '2',// 不包含礼服
            //     'payclass'  => '0,4',// 门市收款，商品收款
            // ],
            '1' =>[
                'shop_name' => '星光贝贝',
                'shop_code' => 'LBB01,LBB02',
                'shop_type' => '2',// 儿童
                'inclued_lf'=> '2',// 不包含礼服
                'payclass'  => '0,4',// 门市收款，商品收款
            ],
        ],
        /* 跟写真合并到一起 格林店不要了并到星光贝贝了
        '兰州儿童' => [
            '0' =>[
                'shop_name' => '格林童话',
                'shop_code' => 'LBB01',
            ],
            '1' =>[
                'shop_name' => '星光贝贝',
                'shop_code' => 'LBB02',
            ],
        ],
        */
        '直营大店' => [
            '0' =>[
                'shop_name' => '武威',
                'shop_code'=>'LZL17,LZL18,LZL19,LZL13,LZL22,LBB08',
                '婚纱'=>'LZL17,LZL18,LZL19,LZL13,LZL22',
                '写真'=>'LZL17,LZL18,LZL19,LZL13,LZL22',
                '儿童'=>'LBB08',
            ],
            '1' =>[
                'shop_name' => '银川',
                'shop_code'=>'LZL15,LZL16,LBB07',
                '婚纱'=>'LZL15,LZL16',
                '写真'=>'LZL15,LZL16',
                '儿童'=>'LBB07',
            ],
            '2' =>[
                'shop_name' => '天水',
                'shop_code'=>'LZL12,LZL14,LBB06',
                '婚纱'=>'LZL12,LZL14',
                '写真'=>'LZL12,LZL14',
                '儿童'=>'LBB06',
            ],
        ],
        '直营小店' => [
            '0' =>[
                'shop_name'=>'榆中',
                'shop_code'=>'LZL09,LZL10,LBB04',
                '婚纱'=>'LZL09,LZL10',
                '写真'=>'LZL09,LZL10',
                '儿童'=>'LBB04',
            ],
            '1' =>[
                'shop_name'=>'临洮',
                'shop_code'=>'LZL11,LBB05',
                '婚纱'=>'LZL11',
                '写真'=>'LZL11',
                '儿童'=>'LBB05',
            ],
            '2' =>[
                'shop_name'=>'永登',
                'shop_code'=>'LZL08,LBB03',
                '婚纱'=>'LZL08',
                '写真'=>'LZL08',
                '儿童'=>'LBB03',
            ],
        ],
        '直营礼服/化造'   => [
            /*'0' =>[
                'shop_name' => '龙+韩',
                'shop_code' => 'LZL01,LZL02,LZL04',
                'shop_type' => '1',// 婚纱
            ],
            '1' =>[
                'shop_name' => '世+薇',
                'shop_code' => 'LZL03,LZL05',
                'shop_type' => '1',// 婚纱
            ],*/
            '2' =>[
                'shop_name' => '武威',
                'shop_code' => 'LZL17,LZL18,LZL19,LZL13,LZL22',
                'shop_type' => '3',
            ],
            '3' =>[
                'shop_name' => '银川',
                'shop_code' => 'LZL15,LZL16',
                'shop_type' => '3',
            ],
            '4' =>[
                'shop_name' => '天水',
                'shop_code' => 'LZL12,LZL14',
                'shop_type' => '3',
            ],
            '5' =>[
                'shop_name' => '榆中',
                'shop_code' => 'LZL09,LZL10',
                'shop_type' => '3',
            ],
            '6' =>[
                'shop_name' => '临洮',
                'shop_code' => 'LZL11',
                'shop_type' => '3',
            ],
            '7' =>[
                'shop_name' => '永登',
                'shop_code' => 'LZL08',
                'shop_type' => '3',
            ],
        ],
        '直营拍摄量'=>[
            '0' =>[
                'shop_name' => '武威',
                '婚纱'=>'LZL17,LZL18,LZL19,LZL13,LZL22',
                '写真'=>'LZL17,LZL18,LZL19,LZL13,LZL22',
                '儿童'=>'LBB08',
            ],
            '1' =>[
                'shop_name' => '银川',
                '婚纱'=>'LZL15,LZL16',
                '写真'=>'LZL15,LZL16',
                '儿童'=>'LBB07',
            ],
            '2' =>[
                'shop_name' => '天水',
                '婚纱'=>'LZL12,LZL14',
                '写真'=>'LZL12,LZL14',
                '儿童'=>'LBB06',
            ],
            '3' =>[
                'shop_name'=>'榆中',
                '婚纱'=>'LZL09,LZL10',
                '写真'=>'LZL09,LZL10',
                '儿童'=>'LBB04',
            ],
            '4' =>[
                'shop_name'=>'临洮',
                '婚纱'=>'LZL11',
                '写真'=>'LZL11',
                '儿童'=>'LBB05',
            ],
            '5' =>[
                'shop_name'=>'永登',
                '婚纱'=>'LZL08',
                '写真'=>'LZL08',
                '儿童'=>'LBB03',
            ],
        ],
        /* '拍摄三销' => [
            '0'=>[
                'shop_name'=>'香榭丽舍',
                'shop_type' => '1',
                'shop_code'=>'LZL01,LZL02,LZL03,LZL04,LZL05',
            ],
            '1'=>[
                'shop_name'=>'武威',
                'shop_type' => 3,
                'shop_code'=>'LBB08,LZL17,LZL18,LZL19,LZL13,LZL22',
            ],
            '2'=>[
                'shop_name'=>'银川',
                'shop_type' => 3,
                'shop_code'=>'LZL15,LZL16,LBB07',
            ],
            '3'=>[
                'shop_name'=>'天水',
                'shop_type' => 3,
                'shop_code'=>'LZL12,LZL14,LBB06',
            ],
            '4'=>[
                'shop_name'=>'榆中',
                'shop_type' => 3,
                'shop_code'=>'LZL09,LZL10,LBB04',
            ],
            '5'=>[
                'shop_name'=>'临姚',
                'shop_type' => 3,
                'shop_code'=>'LZL11,LBB05',
            ],
            '6'=>[
                'shop_name'=>'永登',
                'shop_type' => 3,
                'shop_code'=>'LZL08,LBB03',
            ],
        ],*/
    ];
    protected  $funcname = [
        '龙+韩' =>[
            'shop_name' => '龙+韩',
            'shop_code' => 'LZL01,LZL02,LZL04',
            'lifu'=>['化妆定金','化妆全款','化妆补款','礼服定金','礼服全款','礼服补款'],
        ],
        '世+薇' =>[
            'shop_name' => '世+薇',
            'shop_code' => 'LZL03,LZL05',
            'lifu'=>['化妆定金','化妆全款','化妆补款','礼服定金','礼服全款','礼服补款'],
        ],
        '龙摄影' =>[
            'shop_name' => '龙摄影',
            'shop_code' => 'LZL01,LZL02',
            'shop_type' => '1',// 婚纱
            'yixiao'=>['定单定金','定单补款','定单全款','婚博会定金','婚博全款','婚博会补款','退定单款',],
            'erxiao'=>['选片全款','选片定金','选片补款','选片定金退款',],
            'shangpin'=>['商品收款'],
            'lifu'=>['化妆定金','化妆全款','化妆补款','礼服定金','礼服全款','礼服补款'],
        ],
        '世华洛' =>[
            'shop_name' => '世华洛',
            'shop_code' => 'LZL03',
            'shop_type' => '1',// 婚纱
            'yixiao'=>['定单定金','定单补款','定单全款','婚博会定金','婚博全款','婚博会补款','退定单款',],
            'erxiao'=>['选片全款','选片定金','选片补款','选片定金退款',],
            'shangpin'=>['商品收款'],
            'lifu'=>['化妆定金','化妆全款','化妆补款','礼服定金','礼服全款','礼服补款'],
        ],
        '韩国印象' =>[
            'shop_name' => '韩国印象',
            'shop_code' => 'LZL04',
            'shop_type' => '1',// 婚纱
            'yixiao'=>['定单定金','定单补款','定单全款','婚博会定金','婚博全款','婚博会补款','退定单款',],
            'erxiao'=>['选片全款','选片定金','选片补款','选片定金退款',],
            'shangpin'=>['商品收款'],
            'lifu'=>['化妆定金','化妆全款','化妆补款','礼服定金','礼服全款','礼服补款'],
        ],
        '薇拉' =>[
            'shop_name' => '薇拉',
            'shop_code' => 'LZL05',
            'shop_type' => '1',// 婚纱
            'yixiao'=>['定单定金','定单补款','定单全款','婚博会定金','婚博全款','婚博会补款','退定单款',],
            'erxiao'=>['选片全款','选片定金','选片补款','选片定金退款',],
            'shangpin'=>['商品收款'],
            'lifu'=>['化妆定金','化妆全款','化妆补款','礼服定金','礼服全款','礼服补款'],
        ],
        '香榭丽舍' =>[
            'shop_name' => '香榭丽舍',
            'shop_code' => 'LZL01,LZL02,LZL03,LZL04,LZL05',
            'shop_type' => '1',// 儿童
            'inclued_lf'=> '2',// 不包含礼服
            'sanxiao'=> ['基地三销款'],
        ],
        '星光贝贝' =>[
            'shop_name' => '星光贝贝',
            'shop_code' => 'LBB02',
            'shop_type' => '2',// 婚纱
            'yixiao'=>['定单定金','定单补款','定单全款','婚博会定金','婚博全款','婚博会补款','退定单款',],
            'erxiao'=>['选片全款','选片定金','选片补款','选片定金退款',],
            'shangpin'=>['商品收款'],
            'lifu'=>['化妆定金','化妆全款','化妆补款','礼服定金','礼服全款','礼服补款'],
        ],
        '瑞丽风尚' =>[
            'shop_name' => '瑞丽风尚',
            'shop_code' => 'LZL06',
            'shop_type' => '1',// 婚纱
            'yixiao'=>['定单定金','定单补款','定单全款','婚博会定金','婚博全款','婚博会补款','退定单款',],
            'erxiao'=>['选片全款','选片定金','选片补款','选片定金退款',],
            'shangpin'=>['商品收款','化妆收款'],
            'lifu'=>['化妆定金','化妆全款','化妆补款','礼服定金','礼服全款','礼服补款'],
        ],
        // '瑞丽纯色' =>[
        //     'shop_name' => '瑞丽纯色',
        //     'shop_code' => 'LZL07',
        //     'shop_type' => '1',// 婚纱
        //     'yixiao'=>['定单定金','定单补款','定单全款','婚博会定金','婚博全款','婚博会补款','退定单款',],
        //     'erxiao'=>['选片全款','选片定金','选片补款','选片定金退款',],
        //     'shangpin'=>['商品收款'],
        //     'lifu'=>['化妆定金','化妆全款','化妆补款','礼服定金','礼服全款','礼服补款'],
        // ],
        '武威' =>[
            'shop_name' => '武威',
            'shop_type' => '3',// 婚纱
            'shop_code' => 'LBB08,LZL17,LZL18,LZL19,LZL13,LZL22',
            'yixiao'  => ['定单定金','定单补款','定单全款','儿博会定金','儿博会全款','儿博会补款','退定单款','前期充值','（-VIP)',],
            'erxiao'  => ['选片全款','选片定金','选片补款','选片定金退款','后期充值','（-VIP)',],
            'sanxiao'=> ['基地三销款'],
            'shangpin'=>['商品收款'],
            'lifu'=>['化妆定金','化妆全款','化妆补款','礼服定金','礼服全款','礼服补款'],
        ],
        '银川' =>[
            'shop_name' => '银川',
            'shop_code' => 'LZL15,LZL16,LBB07',
            'shop_type' => '3',// 婚纱
            'yixiao'  => ['定单定金','定单补款','定单全款','儿博会定金','儿博会全款','儿博会补款','退定单款','前期充值','（-VIP)',],
            'erxiao'  => ['选片全款','选片定金','选片补款','选片定金退款','后期充值','（-VIP)',],
            'sanxiao'=> ['基地三销款'],
            'shangpin'=>['商品收款'],
            'lifu'=>['化妆定金','化妆全款','化妆补款','礼服定金','礼服全款','礼服补款'],
        ],
        '天水' =>[
            'shop_name' => '天水',
            'shop_code' => 'LZL12,LZL14,LBB06',
            'shop_type' => '3',// 婚纱
            'yixiao'  => ['定单定金','定单补款','定单全款','儿博会定金','儿博会全款','儿博会补款','退定单款','前期充值','（-VIP)',],
            'erxiao'  => ['选片全款','选片定金','选片补款','选片定金退款','后期充值','（-VIP)',],
            'sanxiao'=> ['基地三销款'],
            'shangpin'=>['商品收款'],
            'lifu'=>['化妆定金','化妆全款','化妆补款','礼服定金','礼服全款','礼服补款'],
        ],
        '榆中' =>[
            'shop_name' => '榆中',
            'shop_code' => 'LZL09,LZL10,LBB04',
            'shop_type' => '3',// 婚纱
            'yixiao'  => ['定单定金','定单补款','定单全款','儿博会定金','儿博会全款','儿博会补款','退定单款','前期充值','（-VIP)',],
            'erxiao'  => ['选片全款','选片定金','选片补款','选片定金退款','后期充值','（-VIP)',],
            'sanxiao'=> ['基地三销款'],
            'shangpin'=>['商品收款'],
            'lifu'=>['化妆定金','化妆全款','化妆补款','礼服定金','礼服全款','礼服补款'],
        ],
        '临洮' =>[
            'shop_name' => '临洮',
            'shop_code' => 'LZL11,LBB05',
            'shop_type' => '3',// 婚纱
            'yixiao'  => ['定单定金','定单补款','定单全款','儿博会定金','儿博会全款','儿博会补款','退定单款','前期充值','（-VIP)',],
            'erxiao'  => ['选片全款','选片定金','选片补款','选片定金退款','后期充值','（-VIP)',],
            'sanxiao'=> ['基地三销款'],
            'shangpin'=>['商品收款'],
            'lifu'=>['化妆定金','化妆全款','化妆补款','礼服定金','礼服全款','礼服补款'],
        ],
        '永登' =>[
            'shop_name' => '永登',
            'shop_code' => 'LZL08,LBB03',
            'shop_type' => '3',// 婚纱
            'yixiao'  => ['定单定金','定单补款','定单全款','儿博会定金','儿博会全款','儿博会补款','退定单款','前期充值','（-VIP)',],
            'erxiao'  => ['选片全款','选片定金','选片补款','选片定金退款','后期充值','（-VIP)',],
            'sanxiao'=> ['基地三销款'],
            'shangpin'=>['商品收款'],
            'lifu'=>['化妆定金','化妆全款','化妆补款','礼服定金','礼服全款','礼服补款'],
        ],
    ];
    // 今天
    protected  $today = [
        'start'=>'', 'end'  =>'',
    ];
    // 昨天
    protected  $yestoday = [
        'start'=>'', 'end'  =>'',
    ];
    // 本月一号和当天
    protected  $thisMonth = [
        'start'=>'', 'end'  =>'',
    ];
    // 本月每一天
    protected  $thisMonthAllDay = [];
    
    public function _initialize(){
        // 今天
        $this->today['start']=  date('Y-m-d 00:00:00');
        $this->today['end']  =  date('Y-m-d 23:59:59');
        // $this->today['start']=  date('Y-m-d 00:00:00',strtotime('-2 day'));
        // $this->today['end']  =  date('Y-m-d 23:59:59',strtotime('-2 day'));
        // 昨天
        $this->yestoday['start']= date('Y-m-d 00:00:00',strtotime('-1 day'));
        $this->yestoday['end']  = date('Y-m-d 23:59:59',strtotime('-1 day'));
        // 本月
        $this->thisMonth['start']= date('Y-m-01 00:00:00');
        $this->thisMonth['end']  = date('Y-m-d 23:59:59');
        // 本月每一天
        $date = getdateArea('this_month');
        $timezone = getDateFromRange($date[0], $date[1]);
        $this->thisMonthAllDay = $timezone;
    }
    // 大屏页面  2018-03-11
    public function index(){
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        $all = $this->baseBrand;
        $baseBrand = [];
        foreach ($all as $key => $value) {
            array_push($baseBrand, $key);
        }
        $this->assign('baseBrand', $baseBrand);

        // 集团名称
        $gInfo = controller('crm/Lzl', 'lib')->getGName();
        $this->assign('title',$gInfo['group_company_name']);
        return $this->fetch();
    }
    // 移动端大屏
    public function mobile(){
        $get = input('get.sid');
        $sid = think_decrypt($get);
        session('staff_id', $sid);
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        $all = $this->baseBrand;
        $baseBrand = [];
        foreach ($all as $key => $value) {
            array_push($baseBrand, $key);
        }
        $this->assign('baseBrand', $baseBrand);

        // 集团名称
        $gInfo = controller('crm/Lzl', 'lib')->getGName();
        $this->assign('title',$gInfo['group_company_name']);
        return $this->fetch();
    }
    // 获取兰州、直营店 缓存 key
    public function getKey($tab){
        if ($tab=='兰州婚纱') {
            $key = 'lhs';
        }
        /*elseif ($tab=='兰州儿童') {
            $key = 'let';
        }*/
        elseif ($tab=='兰州写真/儿童') {
            $key = 'lxz';
        }elseif ($tab=='直营大店') {
            $key = 'zdd';
        }elseif ($tab=='直营小店') {
            $key = 'zxd';
        }
        return $key;
    }
    // ----------------------------------- 集团业绩 -----------------------------------
    /**
     * 集团业绩  没算 vip 和 商品收款
     * 
     * @param  tabname       集团业绩
     * @return json
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getJtDataDay(){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        // 缓存
        $cacheData = cache('bg_jtDataDay');
        if ($cacheData) {
            return json($cacheData);
        }
        // 查当日业绩
        $params['start']= $this->today['start'];
        $params['end']  = $this->today['end'];

        // $allShops = $this->getJtYj($params);

        // // 返回数据
        // $names = [];
        // $datas = [];
        // foreach ($allShops as $key => $value) {
        //     array_push($names, $value['shop_name']);
        //     array_push($datas, $value['money']);
        // }
        // $return['names'] = $names;
        // $return['datas'] = $datas;

        $fact = $this->getCompanyFact($params);
        $return['names'] = array_column($fact,'shop_name');
        $return['datas'] = array_column($fact,'money');
        cache('bg_jtDataDay',$return,60);
        return json($return);
    }
    public function getJtDataMonth(){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        // 缓存
        $cacheData = cache('bg_jtDataMonth');
        if ($cacheData) {
            return json($cacheData);
        }
        // 查当月业绩
        $params['start']= $this->thisMonth['start'];
        $params['end']  = $this->thisMonth['end'];
        /*$allShops = $this->getJtYj($params);
        $allShopCodes = '';
        foreach ($allShops as $key => $value) {
            $allShopCodes .= $value['shop_code'].',';
        }
        $allShopCodes = trim($allShopCodes,',');
        // 查询当月目标
        $tParams['goal_name']= '订单营收';
        $tParams['month']    = $this->thisMonth['start'];
        $tParams['allShopCodes']= $allShopCodes;
        $target = controller('crm/Lzl', 'lib')->getTarget($tParams);
        foreach ($allShops as $key => $value) {
            foreach ($target as $k => $v) {
                if (strpos($value['shop_code'],$k)!==false) {
                    $allShops[$key]['target'] += $target[$k];
                }else{
                    $allShops[$key]['target'] += 0;
                }
            }
        }
        // 当月营收  (营收/目标)*100
        foreach ($allShops as $key => $value) {
            $allShops[$key]['rate'] = dataFormate(($value['money']/$value['target']*100));
        }

        // 最后需要返回的数据
        $names = [];
        $datas = [];
        foreach ($allShops as $key => $value) {
            array_push($names, $value['shop_name']);
            array_push($datas, $value['rate']);
        }
        $return['names'] = $names;
        $return['datas'] = $datas;*/
        $fact = $this->getCompanyFact($params);
        $return = [];
        foreach($fact as $k=>$v){
            // 查询当月目标
            $tParams['goal_name']= '总营收';
            $tParams['select']= $v['select'];
            $tParams['month']    = $this->thisMonth['start'];
            $tParams['allShopCodes']= $v['shop_code'];
            $target = controller('crm/Lzl', 'lib')->getTarget($tParams);
            $return[$k]['shop_name'] = $v['shop_name'];
            $return[$k]['rate'] = dataFormate($v['money']/$target*100,0);
        }
        $returnData['names'] = array_column($return,'shop_name');
        $returnData['datas'] = array_column($return,'rate');
        cache('bg_jtDataMonth',$returnData,60);
        return json($returnData);
    }
    public function getCompanyFact($params){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        $allShops = $this->baseBrand['集团业绩'];
        $fundname = $this->funcname;
        $return = [];
        foreach ($allShops as $key => $value) {
            $return[$key]['shop_name'] = $value['shop_name'];
            $return[$key]['shop_code'] = explode(',',$value['shop_code']);
            $return[$key]['select'] = $value['select'];

            $data['start']    = $params['start'];
            $data['end']      = $params['end'];
            $data['shop_type']= $value['shop_type'];
            $data['shop_code']= explode(',',$value['shop_code']);
            $data['shop_name']= $value['shop_name'];
            $data['payclass'] = $value['payclass'];
            $data['fundname'] = $value['fundname'];
            
            $return[$key]['money'] = controller('crm/Lzl','lib')->getFact($data);
        }
        return $return;
    }
    // 获取集团业绩统一方法
    public function getJtYj($params){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        // 当日营收  兰州不包含礼服业绩, 直营店包含礼服业绩
        $allShops = $this->baseBrand['集团业绩'];
        // 包含礼服店业绩
        $lfShops = '';
        // 不包含礼服业绩
        $nLfShops= '';
        foreach ($allShops as $key => $value) {
            // 包含礼服业绩的店
            if ($value['inclued_lf']==1) {
                $lfShops .= $value['shop_code'].',';
            }
            // 不包含礼服业绩的店
            if ($value['inclued_lf']==2) {
                $nLfShops .= $value['shop_code'].',';
            }
        }
        $lfShops = trim($lfShops, ',');
        $nLfShops= trim($nLfShops, ',');
        // 婚纱 不包含礼服（兰州）
        $hsNLfYs_params['search_type']= 1;
        $hsNLfYs_params['payclass']   = 0;
        $hsNLfYs_params['start']      = $params['start'];
        $hsNLfYs_params['end']        = $params['end'];
        $hsNLfYs_params['shop_code']  = $nLfShops;
        $hsNLfYs = controller('crm/Lzl','lib')->getYsYj($hsNLfYs_params);

        foreach ($allShops as $key => $value) {
            foreach ($hsNLfYs as $k => $v) {
                if (strpos($value['shop_code'],$k)!==false) {
                    $allShops[$key]['money'] += $hsNLfYs[$k];
                    continue;
                }else{
                    $allShops[$key]['money'] += 0;
                }
            }
        }
        // 婚纱 包含礼服（直营）
        $hsLfYs_params['search_type']= 1;
        $hsLfYs_params['payclass']   = '0,1,2';
        $hsLfYs_params['start']      = $this->today['start'];
        $hsLfYs_params['end']        = $this->today['end'];
        $hsLfYs_params['shop_code']  = $lfShops;
        $hsLfYs = controller('crm/Lzl','lib')->getYsYj($hsLfYs_params);
        foreach ($allShops as $key => $value) {
            foreach ($hsLfYs as $k => $v) {
                if (strpos($value['shop_code'],$k)!==false) {
                    $allShops[$key]['money'] += $hsLfYs[$k];
                    continue;
                }else{
                    $allShops[$key]['money'] += 0;
                }
            }
        }
        // 儿童 不包含礼服
        $etNLfYs_params['search_type']= 2;
        $etNLfYs_params['payclass']   = '0,1,2';
        $etNLfYs_params['start']      = $this->today['start'];
        $etNLfYs_params['end']        = $this->today['end'];
        $etNLfYs_params['shop_code']  = $nLfShops.','.$lfShops;
        $etNLfYs = controller('crm/Lzl','lib')->getYsYj($etNLfYs_params);
        foreach ($allShops as $key => $value) {
            foreach ($etNLfYs as $k => $v) {
                if (strpos($value['shop_code'],$k)!==false) {
                    $allShops[$key]['money'] += $etNLfYs[$k];
                    continue;
                }else{
                    $allShops[$key]['money'] += 0;
                }
            }
        }

        return $allShops;
    }
    // ----------------------------------- 集团业绩 -----------------------------------

    // ----------------------------------- 礼服馆 -----------------------------------
    /**
     * 礼服馆
     * 
     * @param  tabname       礼服馆
     * @return json
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getLfDataDay(){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        // 缓存
        $cacheData = cache('bg_lfDataDay');
        if ($cacheData) {
            return json($cacheData);
        }
        // 当日礼服营收 基地三销不算礼服馆业绩
        $params['start']= $this->today['start'];
        $params['end']  = $this->today['end'];
       /* $allShops = $this->getLfgYj($params);
        // var_dump($allShops);die;
        // 返回数据
        $names = [];
        $datas = [];
        foreach ($allShops as $key => $value) {
            array_push($names, $value['shop_name']);
            array_push($datas, $value['money']);
        }
        $return['names'] = $names;
        $return['datas'] = $datas;*/
        $shops = $this->baseBrand['直营礼服/化造'];
        $return = [];
        $fact = [];
        $fundname = $this->funcname;
        foreach($shops as $k=>$v){
            $fact[$k]['shop_name'] = $v['shop_name'];
            $params['shop_code'] = explode(',',$v['shop_code']);
            $params['shop_type'] = $v['shop_type'];
            $params['fundname'] = $fundname[$v['shop_name']]['lifu'];
            $fact[$k]['money'] = controller('crm/Lzl','lib')->getFact($params);

        }
        $return['names'] = array_column($fact,'shop_name');
        $return['datas'] = array_column($fact,'money');
        // print_r($fact);die;
        cache('bg_lfDataDay',$return,60);
        return json($return);
    }
    public function getLfDataMonth(){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        // 缓存
        $cacheData = cache('bg_lfDataMonth');
        if ($cacheData) {
            return json($cacheData);
        }
        // 查当月业绩
        $params['start']= $this->thisMonth['start'];
        $params['end']  = $this->thisMonth['end'];
        /*$allShops = $this->getLfgYj($params);
        $allShopCodes = '';
        foreach ($allShops as $key => $value) {
            $allShopCodes .= $value['shop_code'].',';
        }
        $allShopCodes = trim($allShopCodes,',');
        // 查询当月目标
        $tParams['goal_name']= '礼服营收';
        $tParams['month']    = $this->thisMonth['start'];
        $tParams['allShopCodes']= $allShopCodes;
        $target = controller('crm/Lzl', 'lib')->getTarget($tParams);
        foreach ($allShops as $key => $value) {
            foreach ($target as $k => $v) {
                if (strpos($value['shop_code'],$k)!==false) {
                    $allShops[$key]['target'] += $target[$k];
                }else{
                    $allShops[$key]['target'] += 0;
                }
            }
        }
        // 当月营收  (营收/目标)*100
        foreach ($allShops as $key => $value) {
            $allShops[$key]['rate'] = dataFormate(($value['money']/$value['target']*100));
        }
        // 最后需要返回的数据
        $names = [];
        $datas = [];
        foreach ($allShops as $key => $value) {
            array_push($names, $value['shop_name']);
            array_push($datas, $value['rate']);
        }
        $return['names'] = $names;
        $return['datas'] = $datas;*/
        $shops = $this->baseBrand['直营礼服/化造'];
        $return = [];
        $fact = [];
        $fundname = $this->funcname;
        foreach($shops as $k=>$v){
            $fact[$k]['shop_name'] = $v['shop_name'];
            $params['shop_code'] = explode(',',$v['shop_code']);
            $params['shop_type'] = $v['shop_type'];
            $params['fundname'] = $fundname[$v['shop_name']]['lifu'];
            $money = controller('crm/Lzl','lib')->getFact($params);
            // 查询当月目标
            $tParams['goal_name']= '礼服营收';
            $tParams['month']    = $this->thisMonth['start'];
            $tParams['allShopCodes']= $v['shop_code'];
            $target = controller('crm/Lzl', 'lib')->getTarget($tParams);
            $fact[$k]['rate'] = dataFormate(($money/$target*100),0);
        }

        $return['names'] = array_column($fact,'shop_name');
        $return['datas'] = array_column($fact,'rate');
        cache('bg_lfDataMonth',$return,60);
        return json($return);
    }
    // 获取礼服馆统一方法
    public function getLfgYj($params){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        // 当日营收  兰州不包含礼服业绩, 直营店包含礼服业绩
        $allShops = $this->baseBrand['直营礼服/化造'];
        $shops = '';
        foreach ($allShops as $key => $value) {
            $shops .= $value['shop_code'].',';
        }
        $shops = trim($shops, ',');
        // 婚纱 
        $lfYs_params['search_type']= 1;
        $lfYs_params['payclass']   = '1,2';
        $lfYs_params['start']      = $params['start'];
        $lfYs_params['end']        = $params['end'];
        $lfYs_params['shop_code']  = $shops;
        $getData = controller('crm/Lzl','lib')->getLfYj($lfYs_params);
        // var_dump($lfYs);die;
        foreach ($allShops as $key => $value) {
            if (empty($getData)) {
                $allShops[$key]['money'] = 0;
            }else{
                foreach ($getData as $k => $v) {
                    if (strpos($value['shop_code'],$k)!==false) {
                        $allShops[$key]['money'] += $getData[$k];
                        continue;
                    }else{
                        $allShops[$key]['money'] += 0;
                    }
                }
            }
        }
        // 儿童 
        // $etLfYs_params['search_type']= 2;
        // $etLfYs_params['payclass']   = '1,2';
        // $etLfYs_params['start']      = $this->today['start'];
        // $etLfYs_params['end']        = $this->today['end'];
        // $etLfYs_params['shop_code']  = $shops;
        // $etLfYs = controller('crm/Lzl','lib')->getLfYj($etLfYs_params);
        // foreach ($allShops as $key => $value) {
        //     foreach ($etLfYs as $k => $v) {
        //         if (strpos($value['shop_code'],$k)!==false) {
        //             $allShops[$key]['money'] += $etLfYs[$k];
        //             continue;
        //         }else{
        //             $allShops[$key]['money'] += 0;
        //         }
        //     }
        // }

        return $allShops;
    }
    // ----------------------------------- 礼服馆 -----------------------------------

    // ----------------------------------- 基地三销 -----------------------------------
    /**
     * 基地三销
     * 
     * @param  tabname       基地三销
     * @return json
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getSxDataDay(){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        // 缓存
        $cacheData = cache('bg_sxDataDay');
        if ($cacheData) {
            return json($cacheData);
        }
        // 当日  基地三销 业绩
        $params['start']= $this->today['start'];
        $params['end']  = $this->today['end'];
        /*$allShops = $this->getSxYj($params);
        // var_dump($allShops);die;
        // 返回数据
        $names = [];
        $datas = [];
        foreach ($allShops as $key => $value) {
            array_push($names, $value['shop_name']);
            array_push($datas, $value['money']);
        }
        $return['names'] = $names;
        $return['datas'] = $datas;*/
        $shops = $this->baseBrand['拍摄三销'];
        $return = [];
        $fact = [];
        $fundname = $this->funcname;
        foreach($shops as $k=>$v){
            $fact[$k]['shop_name'] = $v['shop_name'];
            $params['shop_code'] = explode(',',$v['shop_code']);
            $params['shop_type'] = $v['shop_type'];
            $params['fundname'] = $fundname[$v['shop_name']]['sanxiao'];
            $fact[$k]['money'] = controller('crm/Lzl','lib')->getFact($params);
        }
        $return['names'] = array_column($fact,'shop_name');
        $return['datas'] = array_column($fact,'money');
        cache('bg_sxDataDay',$return,60);
        return json($return);
    }
    public function getSxDataMonth(){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        // 缓存
        $cacheData = cache('bg_sxDataMonth');
        if ($cacheData) {
            return json($cacheData);
        }
        // 查当月业绩
        $params['start']= $this->thisMonth['start'];
        $params['end']  = $this->thisMonth['end'];
        /*$allShops = $this->getSxYj($params);
        $allShopCodes = '';
        foreach ($allShops as $key => $value) {
            $allShopCodes .= $value['shop_code'].',';
        }
        $allShopCodes = trim($allShopCodes,',');
        // 查询当月目标
        $tParams['goal_name']= '基地三销';
        $tParams['month']    = $this->thisMonth['start'];
        $tParams['allShopCodes']= $allShopCodes;
        $target = controller('crm/Lzl', 'lib')->getTarget($tParams);
        foreach ($allShops as $key => $value) {
            foreach ($target as $k => $v) {
                if (strpos($value['shop_code'],$k)!==false) {
                    $allShops[$key]['target'] += $target[$k];
                }else{
                    $allShops[$key]['target'] += 0;
                }
            }
        }
        // 当月营收  (营收/目标)*100
        foreach ($allShops as $key => $value) {
            $allShops[$key]['rate'] = dataFormate(($value['money']/$value['target']*100));
        }
        // 最后需要返回的数据
        $names = [];
        $datas = [];
        foreach ($allShops as $key => $value) {
            array_push($names, $value['shop_name']);
            array_push($datas, $value['rate']);
        }
        $return['names'] = $names;
        $return['datas'] = $datas;*/
        $shops = $this->baseBrand['拍摄三销'];
        $return = [];
        $fact = [];
        $fundname = $this->funcname;
        foreach($shops as $k=>$v){
            $fact[$k]['shop_name'] = $v['shop_name'];
            $params['shop_code'] = explode(',',$v['shop_code']);
            $params['shop_type'] = $v['shop_type'];
            $params['fundname'] = $fundname[$v['shop_name']]['sanxiao'];
            $money = controller('crm/Lzl','lib')->getFact($params);
            // 查询当月目标
            $tParams['goal_name']= '基地三销';
            $tParams['month']    = $this->thisMonth['start'];
            $tParams['allShopCodes']= $v['shop_code'];
            $target = controller('crm/Lzl', 'lib')->getTarget($tParams);
            $fact[$k]['rate'] = dataFormate(($money/$target*100),0);
        }
        $return['names'] = array_column($fact,'shop_name');
        $return['datas'] = array_column($fact,'rate');
        cache('bg_sxDataMonth',$return,60);
        return json($return);
    }
    // 获取基地三销统一方法
    public function getSxYj($params){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        // 当日营收  三销只统计 付款类型是  基地三销款 的
        $allShops = $this->baseBrand['拍摄三销'];
        $shops = '';
        foreach ($allShops as $key => $value) {
            $shops .= $value['shop_code'].',';
        }
        $shops = trim($shops, ',');
        // 婚纱 
        $sxYs_params['search_type']= 1;
        $sxYs_params['payclass']   = '1,2';
        $sxYs_params['start']      = $params['start'];
        $sxYs_params['end']        = $params['end'];
        $sxYs_params['shop_code']  = $shops;
        $getData = controller('crm/Lzl','lib')->getSxYj($sxYs_params);
        // var_dump($lfYs);die;
        foreach ($allShops as $key => $value) {
            if (empty($getData)) {
                $allShops[$key]['money'] = 0;
            }else{
                foreach ($getData as $k => $v) {
                    if (strpos($value['shop_code'],$k)!==false) {
                        $allShops[$key]['money'] += $getData[$k];
                        continue;
                    }else{
                        $allShops[$key]['money'] += 0;
                    }
                }
            }
        }
        // 儿童 
        // $etLfYs_params['search_type']= 2;
        // $etLfYs_params['payclass']   = '1,2';
        // $etLfYs_params['start']      = $this->today['start'];
        // $etLfYs_params['end']        = $this->today['end'];
        // $etLfYs_params['shop_code']  = $shops;
        // $etLfYs = controller('crm/Lzl','lib')->getLfYj($etLfYs_params);
        // foreach ($allShops as $key => $value) {
        //     foreach ($etLfYs as $k => $v) {
        //         if (strpos($value['shop_code'],$k)!==false) {
        //             $allShops[$key]['money'] += $etLfYs[$k];
        //             continue;
        //         }else{
        //             $allShops[$key]['money'] += 0;
        //         }
        //     }
        // }

        return $allShops;
    }
    // ----------------------------------- 基地三销 -----------------------------------

    // ----------------------------------- 兰州店 -----------------------------------    
    /**
     * 兰州营收  不算礼服 和 化妆
     * 
     * @param  tabname       兰州婚纱/兰州儿童/兰州写真
     * @return json
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getLzYsDataDay(){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        $post = input('post.');
        $tab = $post['tab'] ? trim($post['tab']) : '兰州婚纱';
        $key = $this->getKey($tab);
        // 缓存
        $cacheData = cache('bg_lzYsDataDay'.$key);
        if ($cacheData) {
            return json($cacheData);
        }
        // 当日营收  兰州 不算礼服 和 化妆
        $params['tab']  = $tab;
        $params['start']= $this->today['start'];
        $params['end']  = $this->today['end'];
        /* $allShops = $this->getLzYs($params);
        // 返回数据
        $names = [];
        $datas = [];
        foreach ($allShops as $key => $value) {
            array_push($names, $value['shop_name']);
            array_push($datas, $value['money']);
        }
        $return['names'] = $names;
        $return['datas'] = $datas;*/
        $shops = $this->baseBrand[$tab];
        $return = [];
        $fundname = $this->funcname;
        foreach($shops as $k=>$v){
            $temp['product']= $v['shop_name'];
            $params['shop_code'] = explode(',',$v['shop_code']);
            $params['shop_type'] = $v['shop_type'];
            //总营收
            // $params['fundname'] = array_merge($fundname[$v['shop_name']]['yixiao'],$fundname[$v['shop_name']]['erxiao'],$fundname[$v['shop_name']]['shangpin']);
            // $temp['总营收']   = controller('crm/Lzl','lib')->getFact($params);
            //订单营收
            // $params['fundname'] = $fundname[$v['shop_name']]['yixiao'];
            $params['suoshu'] = ['前期款','前期补款'];
            $temp['一销营收']   = controller('crm/Lzl','lib')->getFact($params);
            //二销
            // $params['fundname'] = $fundname[$v['shop_name']]['erxiao'];
            $params['suoshu'] = ['后期款','后期补款'];
            $temp['二销营收']   = controller('crm/Lzl','lib')->getFact($params);
            array_push($return, $temp);
        }
        cache('bg_lzYsDataDay'.$key,$return,60);
        return json($return);
    }
    public function getLzYsDataMonth(){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        $post = input('post.');
        $tab = $post['tab'] ? trim($post['tab']) : '兰州婚纱';
        $key = $this->getKey($tab);
        // 缓存
        $cacheData = cache('bg_lzYsDataMonth'.$key);
        if ($cacheData) {
            return json($cacheData);
        }
        // 当月营收  兰州 不算礼服 和 化妆
        $params['tab']  = $tab;
        $params['start']= $this->thisMonth['start'];
        $params['end']  = $this->thisMonth['end'];
        /*$allShops = $this->getLzYs($params);

        $allShopCodes = '';
        foreach ($allShops as $key => $value) {
            $allShopCodes .= $value['shop_code'].',';
        }
        $allShopCodes = trim($allShopCodes,',');
        // 查询当月目标
        $tParams['goal_name']= '总营收';
        $tParams['month']    = $this->thisMonth['start'];
        $tParams['allShopCodes']= $allShopCodes;
        $target = controller('crm/Lzl', 'lib')->getTarget($tParams);
        foreach ($allShops as $key => $value) {
            foreach ($target as $k => $v) {
                if (strpos($value['shop_code'],$k)!==false) {
                    $allShops[$key]['target'] += $target[$k];
                }else{
                    $allShops[$key]['target'] += 0;
                }
            }
        }
        // 当月营收  (营收/目标)*100
        foreach ($allShops as $key => $value) {
            $allShops[$key]['rate'] = dataFormate(($value['money']/$value['target']*100));
        }
        // 返回数据
        $names = [];
        $datas = [];
        foreach ($allShops as $key => $value) {
            array_push($names, $value['shop_name']);
            array_push($datas, $value['rate']);
        }
        $return['names'] = $names;
        $return['datas'] = $datas;*/
        $shops = $this->baseBrand[$tab];
        $return = [];
        $fundname = $this->funcname;
        foreach($shops as $k=>$v){
            $return[$k]['product']= $v['shop_name'];
            $params['shop_code'] = explode(',',$v['shop_code']);
            $params['shop_type'] = $v['shop_type'];
            $params['select'] = $v['select'];
            //总营收
            $params['fundname'] = array_merge($fundname[$v['shop_name']]['yixiao'],$fundname[$v['shop_name']]['erxiao'],$fundname[$v['shop_name']]['shangpin']);
            // 查询当月目标
            // $tParams['goal_name']= '总营收';
            $tParams['month']    = $this->thisMonth['start'];
            $tParams['allShopCodes']= $params['shop_code'];

            // $target = controller('crm/Lzl', 'lib')->getTarget($tParams);
            // $fact = controller('crm/Lzl','lib')->getFact($params);
            // $return[$k]['总营收'] = dataFormate($fact/$target*100);
            //订单营收
            // $params['fundname'] = $fundname[$v['shop_name']]['yixiao'];
            $params['suoshu'] = ['前期款','前期补款'];
            $tParams['goal_name']= '一销营收';
            $target = controller('crm/Lzl', 'lib')->getTarget($tParams);
            
            $order = controller('crm/Lzl','lib')->getFact($params);
            
            $return[$k]['一销营收'] = dataFormate($order/$target*100,0);
            //礼服营收
            // $params['fundname'] = $fundname[$v['shop_name']]['erxiao'];
            $params['suoshu'] = ['后期款','后期补款'];
            $tParams['goal_name']= '二销营收';
            $target = controller('crm/Lzl', 'lib')->getTarget($tParams);
            $lifu = controller('crm/Lzl','lib')->getFact($params);
            $return[$k]['二销营收'] = dataFormate($lifu/$target*100,0);
        }
        //var_dump($return);die;
        cache('bg_lzYsDataMonth'.$key,$return,60);
        return json($return);
    }
    // 获取兰州营收统一方法
    public function getLzYs($params){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        $tab = trim($params['tab']);
        if ($tab=='let') {
            $search_type = 2;
        }else{
            $search_type = 1;
        }
        // 当日营收  兰州 不算礼服 和 化妆
        $allShops = $this->baseBrand[$tab];
        $shops = '';
        foreach ($allShops as $key => $value) {
            $shops .= $value['shop_code'].',';
        }
        $shops = trim($shops, ',');
        // 婚纱 不包含礼服（兰州）
        $lz_params['search_type']= $search_type;
        $lz_params['payclass']   = 0;
        $lz_params['start']      = $params['start'];
        $lz_params['end']        = $params['end'];
        $lz_params['shop_code']  = $shops;
        $getData = controller('crm/Lzl','lib')->getYsYj($lz_params);
        foreach ($allShops as $key => $value) {
            if (empty($getData)) {
                $allShops[$key]['money'] = 0;
            }else{
                foreach ($getData as $k => $v) {
                    if (strpos($value['shop_code'],$k)!==false) {
                        $allShops[$key]['money'] += $getData[$k];
                        continue;
                    }else{
                        $allShops[$key]['money'] += 0;
                    }
                }
            }
        }
        return $allShops;
    }
    // 订单
    public function getLzDdDataDay(){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        $post = input('post.');
        $tab = $post['tab'] ? trim($post['tab']) : '兰州婚纱';
        $key = $this->getKey($tab);
        // 缓存
        $cacheData = cache('bg_lzDdDataDay'.$key);
        if ($cacheData) {
            return json($cacheData);
        }
        if ($key=='lhs') {
            $con_type = 1;
        }else if ($key=='lxz') {
            $con_type = 2;
        }else if ($key=='let') {
            $con_type = 3;
        }
        // 当日订单
        $params['tab']     = $tab;
        $params['start']   = $this->today['start'];
        $params['end']     = $this->today['end'];
        $params['con_type']= $con_type;
        $allShops = $this->getLzDd($params);
        // 返回数据
       /* $names = [];
        $datas = [];
        foreach ($allShops as $key => $value) {
            array_push($names, $value['shop_name']);
            array_push($datas, $value['money']);
        }*/
        $return['names'] = array_column($allShops,'shop_name');
        $return['datas'] = array_column($allShops,'money');
        //var_dump($return);die;
        cache('bg_lzDdDataDay'.$key,$return,60);
        return json($return);
    }
    public function getLzXZDdDataDay(){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        $post = input('post.');
        $tab = $post['tab'] ? trim($post['tab']) : '兰州写真/儿童';
        $key = $this->getKey($tab);
        // 缓存
        $cacheData = cache('bg_lzDdDataDay'.$key);
        if ($cacheData) {
            return json($cacheData);
        }
        if ($key=='lhs') {
            $con_type = 1;
        }else if ($key=='lxz') {
            $con_type = 2;
        }else if ($key=='let') {
            $con_type = 3;
        }
        // 当日订单
        $params['tab']     = $tab;
        $params['start']   = $this->today['start'];
        $params['end']     = $this->today['end'];
        $allShops = $this->getLzXZDd($params);
        // 返回数据
        /* $names = [];
        $datas = [];
        foreach ($allShops as $key => $value) {
            array_push($names, $value['shop_name']);
            array_push($datas, $value['money']);
        }*/
        // $return['names'] = array_column($allShops,'shop_name');
        // $return['datas'] = array_column($allShops,'money');
        //var_dump($return);die;
        cache('bg_lzDdDataDay'.$key,$allShops,60);
        return json($allShops);
    }
    public function getLzDdDataMonth(){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        $post = input('post.');
        $tab = $post['tab'] ? trim($post['tab']) : '兰州婚纱';
        $key = $this->getKey($tab);
        // 缓存
        $cacheData = cache('bg_lzDdDataMonth'.$key);
        if ($cacheData) {
            return json($cacheData);
        }
        if ($key=='lhs') {
            $con_type = 1;
        }else if ($key=='lxz') {
            $con_type = 2;
        }else if ($key=='let') {
            $con_type = 3;
        }
        // 当月订单量
        $params['tab']     = $tab;
        $params['start']   = $this->thisMonth['start'];
        $params['end']     = $this->thisMonth['end'];
        $params['con_type']= $con_type;
        $allShops = $this->getLzDd($params);


       /* // 查询当月目标
        $tParams['goal_name']= '订单量';
        $tParams['month']    = $this->thisMonth['start'];
        $tParams['allShopCodes']= $allShopCodes;
        $target = controller('crm/Lzl', 'lib')->getTargetGroup($tParams);
        foreach ($allShops as $key => $value) {
            foreach ($target as $k => $v) {
                if (strpos($value['shop_code'],$k)!==false) {
                    $allShops[$key]['target'] += $target[$k];
                }else{
                    $allShops[$key]['target'] += 0;
                }
            }
        }
        // 当月订单完成比  (订单量/目标)*100
        foreach ($allShops as $key => $value) {
            $allShops[$key]['rate'] = dataFormate(($value['money']/$value['target']*100),0);
        }
        // 返回数据
        $names = [];
        $datas = [];
        foreach ($allShops as $key => $value) {
            array_push($names, $value['shop_name']);
            array_push($datas, $value['rate']);
        }*/
        $return['names'] = array_column($allShops,'shop_name');
        $return['datas'] = array_column($allShops,'money');
        //var_dump($return);die;
        cache('bg_lzDdDataMonth'.$key,$return,60);
        return json($return);
    }
    public function getLzXZDdDataMonth(){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        $post = input('post.');
        $tab = $post['tab'] ? trim($post['tab']) : '兰州写真/儿童';
        $key = $this->getKey($tab);
        // 缓存
        $cacheData = cache('bg_lzDdDataMonth'.$key);
        if ($cacheData) {
            return json($cacheData);
        }

        // 当月订单量
        $params['tab']     = $tab;
        $params['start']   = $this->thisMonth['start'];
        $params['end']     = $this->thisMonth['end'];
        $allShops = $this->getLzXZDd($params);

        cache('bg_lzDdDataMonth'.$key,$allShops,60);
        return json($allShops);
    }
    // 获取兰州订单数统一方法
    public function getLzDd_new($params){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        $tab = trim($params['tab']);
        if ($tab=='let') {
            $search_type = 2;
        }else{
            $search_type = 1;
        }
        // 当日营收  兰州 不算礼服 和 化妆
        $allShops = $this->baseBrand[$tab];
        $return = [];
        foreach($allShops as $k=>$v){
            // 婚纱 不包含礼服（兰州）
            $lz_params['search_type']= $search_type;
            $lz_params['start']      = $params['start'];
            $lz_params['end']        = $params['end'];
            $lz_params['shop_code']  = explode(',',$v['shop_code']);
            $lz_params['con_type']   = (int)$params['con_type'];
            $order =  controller('crm/Lzl','lib')->getDdNum($lz_params);
            $return[$v['shop_name']] = $order ? array_sum(array_values($order)) : 0;
        }
       /* $shops = '';
        foreach ($allShops as $key => $value) {
            $shops .= $value['shop_code'].',';
        }
        $shops = trim($shops, ',');
        // 婚纱 不包含礼服（兰州）
        $lz_params['search_type']= $search_type;
        $lz_params['start']      = $params['start'];
        $lz_params['end']        = $params['end'];
        $lz_params['shop_code']  = $shops;
        $lz_params['con_type']   = (int)$params['con_type'];
        $getData = controller('crm/Lzl','lib')->getDdNum($lz_params);
        
        foreach ($allShops as $key => $value) {
            if (empty($getData)) {
                $allShops[$key]['money'] = 0;
            }else{
                foreach ($getData as $k => $v) {
                    if (strpos($value['shop_code'],$k)!==false) {
                        $allShops[$key]['money'] += $getData[$k];
                        continue;
                    }else{
                        $allShops[$key]['money'] += 0;
                    }
                }
            }
        }*/
        return $return;
    }
    public function getLzDd($params){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        $tab = trim($params['tab']);
        if ($tab=='let') {
            $search_type = 2;
        }else{
            $search_type = 1;
        }
        // 当日营收  兰州 不算礼服 和 化妆
        $allShops = $this->baseBrand[$tab];

        $shops = '';
        foreach ($allShops as $key => $value) {
            $shops .= $value['shop_code'].',';
        }
        $shops = trim($shops, ',');
        // 婚纱 不包含礼服（兰州）
        $lz_params['search_type']= $search_type;
        $lz_params['start']      = $params['start'];
        $lz_params['end']        = $params['end'];
        $lz_params['shop_code']  = $shops;
        $lz_params['con_type']   = (int)$params['con_type'];
        $getData = controller('crm/Lzl','lib')->getDdNum($lz_params);

        foreach ($allShops as $key => $value) {
            if (empty($getData)) {
                $allShops[$key]['money'] = 0;
            }else{
                foreach ($getData as $k => $v) {
                    if (strpos($value['shop_code'],$k)!==false) {
                        $allShops[$key]['money'] += $getData[$k];
                        continue;
                    }else{
                        $allShops[$key]['money'] += 0;
                    }
                }
            }
        }
        return $allShops;
    }
    public function getLzXZDd($params){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        $tab = trim($params['tab']);
        // 当日营收  兰州 不算礼服 和 化妆
        $allShops = $this->baseBrand[$tab];

        $return = [];
        foreach ($allShops as $key => $value) {
            $return[$key]['product'] = $value['shop_name'];
            $lz_params['search_type']= $value['shop_type'];
            $lz_params['start']      = $params['start'];
            $lz_params['end']        = $params['end'];
            $lz_params['shop_code']  = explode(',',$value['shop_code']);
            $lz_params['con_type']   = 1;//1：婚纱；2：其他
            if($value['shop_type'] == 2){
                $return[$key]['婚纱'] = 0;
            }else{
                $return[$key]['婚纱'] = controller('crm/Lzl','lib')->getXZDdNum($lz_params);
            }
            $lz_params['con_type']   = 2;//1：婚纱；2：其他
            $return[$key]['写真'] = controller('crm/Lzl','lib')->getXZDdNum($lz_params);
        }
        return $return;
    }
    // 看样(选片)
    public function getLzKyDataDay(){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        $post = input('post.');
        $tab = $post['tab'] ? trim($post['tab']) : '兰州婚纱';
        $key = $this->getKey($tab);
        // 缓存
        $cacheData = cache('bg_lzKyDataDay'.$key);
        if ($cacheData) {
            return json($cacheData);
        }
        // 当日订单
        $params['tab']     = $tab;
        $params['start']   = $this->today['start'];
        $params['end']     = $this->today['end'];
        $allShops = $this->getLzKy($params);
        // 返回数据
        $names = [];
        $datas = [];
        foreach ($allShops as $key => $value) {
            array_push($names, $value['shop_name']);
            array_push($datas, $value['money']);
        }
        $return['names'] = $names;
        $return['datas'] = $datas;
        //var_dump($return);die;
        cache('bg_lzKyDataDay'.$key,$return,60);
        return json($return);
    }
    public function getLzXZKyDataDay(){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        $post = input('post.');
        $tab = $post['tab'] ? trim($post['tab']) : '兰州写真/儿童';
        $key = $this->getKey($tab);
        // 缓存
        $cacheData = cache('bg_lzKyDataDay'.$key);
        if ($cacheData) {
            return json($cacheData);
        }
        // 当日订单
        $params['tab']     = $tab;
        $params['start']   = $this->today['start'];
        $params['end']     = $this->today['end'];
        $allShops = $this->getXZLzKy($params);

        cache('bg_lzKyDataDay'.$key,$allShops,60);
        return json($allShops);
    }
    public function getLzKyDataMonth(){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        $post = input('post.');
        $tab = $post['tab'] ? trim($post['tab']) : '兰州婚纱';
        $key = $this->getKey($tab);
        // 缓存
        $cacheData = cache('bg_lzKyDataMonth'.$key);
        if ($cacheData) {
            return json($cacheData);
        }
        // 当月看样(选片)
        $params['tab']     = $tab;
        $params['start']   = $this->thisMonth['start'];
        $params['end']     = $this->thisMonth['end'];
        $allShops = $this->getLzKy($params);
        /*
        $allShopCodes = '';
        foreach ($allShops as $key => $value) {
            $allShopCodes .= $value['shop_code'].',';
        }
        $allShopCodes = trim($allShopCodes,',');
        // 查询当月目标
        $tParams['goal_name']= '看样量';
        $tParams['month']    = $this->thisMonth['start'];
        $tParams['allShopCodes']= $allShopCodes;
        $target = controller('crm/Lzl', 'lib')->getTarget($tParams);
        foreach ($allShops as $key => $value) {
            foreach ($target as $k => $v) {
                if (strpos($value['shop_code'],$k)!==false) {
                    $allShops[$key]['target'] += $target[$k];
                }else{
                    $allShops[$key]['target'] += 0;
                }
            }
        }
        // 当月订单完成比  (看样(选片)量/目标)*100
        foreach ($allShops as $key => $value) {
            $allShops[$key]['rate'] = dataFormate(($value['money']/$value['target']*100));
        }
        */
        // 返回数据
        $names = [];
        $datas = [];
        foreach ($allShops as $key => $value) {
            array_push($names, $value['shop_name']);
            array_push($datas, $value['money']);
            // array_push($datas, $value['rate']);
        }
        $return['names'] = $names;
        $return['datas'] = $datas;
        //var_dump($return);die;
        cache('bg_lzKyDataMonth'.$key,$return,60);
        return json($return);
    }
    public function getLzXZKyDataMonth(){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        $post = input('post.');
        $tab = $post['tab'] ? trim($post['tab']) : '兰州写真/儿童';
        $key = $this->getKey($tab);
        // 缓存
        $cacheData = cache('bg_lzKyDataMonth'.$key);
        if ($cacheData) {
            return json($cacheData);
        }
        // 当月看样(选片)
        $params['tab']     = $tab;
        $params['start']   = $this->thisMonth['start'];
        $params['end']     = $this->thisMonth['end'];
        $allShops = $this->getXZLzKy($params);

        cache('bg_lzKyDataMonth'.$key,$allShops,60);
        return json($allShops);
    }
    // 兰州看样(选片)量统一方法
    public function getLzKy($params){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        $tab = trim($params['tab']);
        if ($tab=='let') {
            $search_type = 2;
        }else{
            $search_type = 1;
        }
        // 当日营收  兰州 不算礼服 和 化妆
        $allShops = $this->baseBrand[$tab];
        $shops = '';
        foreach ($allShops as $key => $value) {
            $shops .= $value['shop_code'].',';
        }
        $shops = trim($shops, ',');
        // 婚纱 不包含礼服（兰州）
        $lz_params['search_type']= $search_type;
        $lz_params['start']      = $params['start'];
        $lz_params['end']        = $params['end'];
        $lz_params['shop_code']  = $shops;
        // $lz_params['con_type']   = (int)$params['con_type'];
        $getData = controller('crm/Lzl','lib')->getKyNum($lz_params);

        foreach ($allShops as $key => $value) {
            if (empty($getData)) {
                $allShops[$key]['money'] = 0;
            }else{
                foreach ($getData as $k => $v) {
                    if (strpos($value['shop_code'],$k)!==false) {
                        $allShops[$key]['money'] += $getData[$k];
                        continue;
                    }else{
                        $allShops[$key]['money'] += 0;
                    }
                }
            }
        }
        return $allShops;
    }
    public function getXZLzKy($params){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        $tab = trim($params['tab']);
        // 当日营收  兰州 不算礼服 和 化妆
        $allShops = $this->baseBrand[$tab];
        $return = [];
        foreach ($allShops as $key => $value) {
            $return[$key]['product'] = $value['shop_name'];
            $lz_params['search_type']= $value['shop_type'];
            $lz_params['start']      = $params['start'];
            $lz_params['end']        = $params['end'];
            $lz_params['shop_code']  = explode(',',$value['shop_code']);
            $lz_params['con_type']   = 1;//1：婚纱；2：其他
            if($value['shop_type'] == 2){
                $return[$key]['婚纱'] = 0;
            }else{
                $return[$key]['婚纱'] = controller('crm/Lzl','lib')->getXZKyNum($lz_params);
            }
            $lz_params['con_type']   = 2;//1：婚纱；2：其他
            $return[$key]['写真'] = controller('crm/Lzl','lib')->getXZKyNum($lz_params);
        }
        return $return;
    }
    // 一销平销 月 (套系总额bargain_money/一销金额大于0的订单量 )
    public function getLzYxData(){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        $post = input('post.');
        $tab = $post['tab'] ? trim($post['tab']) : '兰州婚纱';
        $key = $this->getKey($tab);
        // 缓存
        $cacheData = cache('bg_lzYxData'.$key);
        if ($cacheData) {
            return json($cacheData);
        }
        if ($key=='lhs') {
            $con_type = 1;
            $search_type = 1;
        }else if ($key=='lxz') {
            $con_type = 2;
            $search_type = 1;
        }else if ($key=='let') {
            $con_type = 3;
            $search_type = 2;
        }
        // 当月订单量 
        $params['tab']     = $tab;
        $params['start']   = $this->thisMonth['start'];
        $params['end']     = $this->thisMonth['end'];
        $params['con_type']= $con_type;
        $allShops = $this->getLzDd($params);
        $allShopCodes = '';
        foreach ($allShops as $key => $value) {
            $allShopCodes .= $value['shop_code'].',';
        }
        $allShopCodes = trim($allShopCodes,',');
        // 当月一销总额
        $money_params['search_type']= $search_type;
        $money_params['shop_code']  = $allShopCodes;
        $money_params['start']      = $this->thisMonth['start'];
        $money_params['end']        = $this->thisMonth['end'];
        $all_money = controller('crm/Lzl', 'lib')->getYxMoney($money_params);
        foreach ($allShops as $key => $value) {
            if (empty($all_money)) {
                $allShops[$key]['all_money'] = 0;
            }else{
                foreach ($all_money as $k => $v) {
                    if (strpos($value['shop_code'],$k)!==false) {
                        $allShops[$key]['all_money'] += $all_money[$k];
                        continue;
                    }else{
                        $allShops[$key]['all_money'] += 0;
                    }
                }
            }
        }
        // 返回数据 平销  (套系总额bargain_money/订单量)
        $names = [];
        $datas = [];
        foreach ($allShops as $key => $value) {
            array_push($names, $value['shop_name']);
            array_push($datas, dataFormate($value['all_money']/$value['money'],0));
        }
        $return['names'] = $names;
        $return['datas'] = $datas;
        //var_dump($return);die;
        cache('bg_lzYxData'.$key,$return,60);
        return json($return);
    }
    // 二销平销 月 (二销已付 erxiaopaid_money / 选片订单量) 
    public function getLzExData(){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        $post = input('post.');
        $tab = $post['tab'] ? trim($post['tab']) : '兰州婚纱';
        $key = $this->getKey($tab);
        // 缓存
        $cacheData = cache('bg_lzYxData'.$key);
        if ($cacheData) {
            return json($cacheData);
        }
        if ($key=='lhs') {
            $con_type = 1;
            $search_type = 1;
        }else if ($key=='lxz') {
            $con_type = 2;
            $search_type = 1;
        }else if ($key=='let') {
            $con_type = 3;
            $search_type = 2;
        }
        // 当月订单量 
        $params['tab']     = $tab;
        $params['start']   = $this->thisMonth['start'];
        $params['end']     = $this->thisMonth['end'];
        $params['con_type']= $con_type;
        $allShops = $this->getLzKy($params);
        $allShopCodes = '';
        foreach ($allShops as $key => $value) {
            $allShopCodes .= $value['shop_code'].',';
        }
        $allShopCodes = trim($allShopCodes,',');
        // 当月一销总额
        $money_params['search_type']= $search_type;
        $money_params['shop_code']  = $allShopCodes;
        $money_params['start']      = $this->thisMonth['start'];
        $money_params['end']        = $this->thisMonth['end'];
        $all_money = controller('crm/Lzl', 'lib')->getExMoney($money_params);

        foreach ($allShops as $key => $value) {
            if (empty($all_money)) {
                $allShops[$key]['all_money'] = 0;
            }else{
                foreach ($all_money as $k => $v) {
                    if (strpos($value['shop_code'],$k)!==false) {
                        $allShops[$key]['all_money'] += $all_money[$k];
                        continue;
                    }else{
                        $allShops[$key]['all_money'] += 0;
                    }
                }
            }
        }
        // 返回数据 平销  (套系总额bargain_money/订单量)
        $names = [];
        $datas = [];
        foreach ($allShops as $key => $value) {
            array_push($names, $value['shop_name']);
            array_push($datas, dataFormate($value['all_money']/$value['money'],0));
        }
        $return['names'] = $names;
        $return['datas'] = $datas;
        //var_dump($return);die;
        cache('bg_lzYxData'.$key,$return,60);
        return json($return);
    }
    // 兰州写真/儿童  一销平销 月 (套系总额bargain_money/订单量)
    public function getLzXZYxData(){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        $post = input('post.');
        $tab = $post['tab'] ? trim($post['tab']) : '兰州写真/儿童';
        $key = $this->getKey($tab);
        // 缓存
        $cacheData = cache('bg_lzXZYxData'.$key);
        if ($cacheData) {
            return json($cacheData);
        }
        /*if ($key=='lhs') {
            $con_type = 1;
            $search_type = 1;
        }else if ($key=='lxz') {
            $con_type = 2;
            $search_type = 1;
        }else if ($key=='let') {
            $con_type = 3;
            $search_type = 2;
        }
        // 当月订单量
        $params['tab']     = $tab;
        $params['start']   = $this->thisMonth['start'];
        $params['end']     = $this->thisMonth['end'];
        $params['con_type']= $con_type;
        $allShops = $this->getLzDd($params);
        $allShopCodes = '';
        foreach ($allShops as $key => $value) {
            $allShopCodes .= $value['shop_code'].',';
        }
        $allShopCodes = trim($allShopCodes,',');
        // 当月一销总额
        $money_params['search_type']= $search_type;
        $money_params['shop_code']  = $allShopCodes;
        $money_params['start']      = $this->thisMonth['start'];
        $money_params['end']        = $this->thisMonth['end'];
        $all_money = controller('crm/Lzl', 'lib')->getYxMoney($money_params);
        foreach ($allShops as $key => $value) {
            if (empty($all_money)) {
                $allShops[$key]['all_money'] = 0;
            }else{
                foreach ($all_money as $k => $v) {
                    if (strpos($value['shop_code'],$k)!==false) {
                        $allShops[$key]['all_money'] += $all_money[$k];
                        continue;
                    }else{
                        $allShops[$key]['all_money'] += 0;
                    }
                }
            }
        }
        // 返回数据 平销  (套系总额bargain_money/订单量)
        $names = [];
        $datas = [];
        foreach ($allShops as $key => $value) {
            array_push($names, $value['shop_name']);
            array_push($datas, dataFormate($value['all_money']/$value['money'],0));
        }
        $return['names'] = $names;
        $return['datas'] = $datas;*/
        $start  = date('Ymd',strtotime($this->thisMonth['start']));
        $end    = date('Ymd',strtotime($this->thisMonth['end']));
        $shops     = $this->baseBrand[$tab];
        $return = [];
        foreach($shops as $k=>$v){
            // 订单量
            $hs_order = db('c_customerorder', 'sx_erp_hs')
                ->where('targetdate', 'between', [$start, $end])
                ->where('consumption_type','婚纱照')
                ->where('bargain_money','>', '0')
                ->where('blankoutannal', '0')
                ->where('shop_code', 'in', explode(',',$v['shop_code']))
                ->count('orderId');
            $xz_order = db('c_customerorder', 'sx_erp_hs')
                ->where('targetdate', 'between', [$start, $end])
                ->where('consumption_type','<>','婚纱照')
                ->where('bargain_money','>', '0')
                ->where('blankoutannal', '0')
                ->where('shop_code', 'in', explode(',',$v['shop_code']))
                ->count('orderId');
            $et_order = db('c_customerorder', 'sx_erp_et')
                ->where('targetdate', 'between', [$start, $end])
                // ->where('consumption_type','<>','婚纱照')
                ->where('bargain_money','>', '0')
                ->where('blankoutannal', '0')
                ->where('shop_code', 'in', explode(',',$v['shop_code']))
                ->count('orderId');
            // 营收
            $hs_fact =  db('c_customerorder', 'sx_erp_hs')->alias('o')
                ->where('o.consumption_type', '婚纱照')
                ->where('o.targetdate', 'between', [$start, $end])
                ->where('o.blankoutannal', '0')
                ->where('o.shop_code', 'in', explode(',',$v['shop_code']))
                ->sum('o.bargain_money');
            $xz_fact =  db('c_customerorder', 'sx_erp_hs')->alias('o')
                ->where('o.consumption_type', '<>', '婚纱照')
                ->where('o.targetdate', 'between', [$start, $end])
                ->where('o.blankoutannal', '0')
                ->where('o.shop_code', 'in', explode(',',$v['shop_code']))
                ->sum('o.bargain_money');
            $et_fact =  db('c_customerorder', 'sx_erp_et')->alias('o')
                ->where('o.consumption_type', '<>', '婚纱照')
                ->where('o.targetdate', 'between', [$start, $end])
                ->where('o.blankoutannal', '0')
                ->where('o.shop_code', 'in', explode(',',$v['shop_code']))
                ->sum('o.bargain_money');
            $return[$k]['product'] = $v['shop_name'];

            $return[$k]['hs_fact'] = $hs_fact;
            $return[$k]['xz_fact'] = $xz_fact;
            $return[$k]['et_fact'] = $et_fact;

            $return[$k]['hs_order'] = $hs_order;
            $return[$k]['xz_order'] = $xz_order;
            $return[$k]['et_order'] = $et_order;

            $return[$k]['婚纱'] = dataFormate($hs_fact/$hs_order,0);
            $return[$k]['写真'] = dataFormate(($xz_fact+$et_fact)/($xz_order+$et_order),0);
        }
        cache('bg_lzXZYxData'.$key,$return,60);
        return json($return);
    }
    //兰州写真/儿童 二销平销 月 (套系总额supplementary_money/订单量)
    public function getLzXZExData(){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        $post = input('post.');
        $tab = $post['tab'] ? trim($post['tab']) : '兰州写真/儿童';
        $key = $this->getKey($tab);
        // 缓存
        $cacheData = cache('bg_lzXZExData'.$key);
        if ($cacheData) {
            return json($cacheData);
        }
        /*if ($key=='lhs') {
            $con_type = 1;
            $search_type = 1;
        }else if ($key=='lxz') {
            $con_type = 2;
            $search_type = 1;
        }else if ($key=='let') {
            $con_type = 3;
            $search_type = 2;
        }
        // 当月订单量
        $params['tab']     = $tab;
        $params['start']   = $this->thisMonth['start'];
        $params['end']     = $this->thisMonth['end'];
        $params['con_type']= $con_type;
        $allShops = $this->getLzDd($params);
        $allShopCodes = '';
        foreach ($allShops as $key => $value) {
            $allShopCodes .= $value['shop_code'].',';
        }
        $allShopCodes = trim($allShopCodes,',');
        // 当月一销总额
        $money_params['search_type']= $search_type;
        $money_params['shop_code']  = $allShopCodes;
        $money_params['start']      = $this->thisMonth['start'];
        $money_params['end']        = $this->thisMonth['end'];
        $all_money = controller('crm/Lzl', 'lib')->getExMoney($money_params);

        foreach ($allShops as $key => $value) {
            if (empty($all_money)) {
                $allShops[$key]['all_money'] = 0;
            }else{
                foreach ($all_money as $k => $v) {
                    if (strpos($value['shop_code'],$k)!==false) {
                        $allShops[$key]['all_money'] += $all_money[$k];
                        continue;
                    }else{
                        $allShops[$key]['all_money'] += 0;
                    }
                }
            }
        }
        // 返回数据 平销  (套系总额bargain_money/订单量)
        $names = [];
        $datas = [];
        foreach ($allShops as $key => $value) {
            array_push($names, $value['shop_name']);
            array_push($datas, dataFormate($value['all_money']/$value['money'],0));
        }
        $return['names'] = $names;
        $return['datas'] = $datas;*/
        $start  = date('Ymd',strtotime($this->thisMonth['start']));
        $end    = date('Ymd',strtotime($this->thisMonth['end']));
        $shops     = $this->baseBrand[$tab];
        $return = [];
        foreach($shops as $k=>$v){
            // 选片订单
            $hs_order = db('c_customersp', 'sx_erp_hs')->alias('s')
                ->join('c_customerorder o', 's.orderId=o.orderId', 'left')
                ->where('o.consumption_type','婚纱照')
                ->where('s.selectday', 'between', [$start, $end])
                ->where('s.shop_code', 'in',explode(',',$v['shop_code']))
                ->where('s.sptstate', 1)// '选片状态  0未选完，1已选，2未选',
                ->count('DISTINCT s.orderId');
            $xz_order = db('c_customersp', 'sx_erp_hs')->alias('s')
                ->join('c_customerorder o', 's.orderId=o.orderId', 'left')
                ->where('s.selectday', 'between', [$start, $end])
                ->where('o.consumption_type','<>','婚纱照')
                ->where('s.shop_code', 'in',explode(',',$v['shop_code']))
                ->where('s.sptstate', 1)// '选片状态  0未选完，1已选，2未选',
                ->count('DISTINCT s.orderId');
            $et_order = db('c_customersp', 'sx_erp_et')->alias('s')
                ->join('c_customerorder o', 's.orderId=o.orderId', 'left')
                // ->where('o.consumption_type','婚纱照')
                ->where('s.selectday', 'between', [$start, $end])
                ->where('s.shop_code', 'in',explode(',',$v['shop_code']))
                ->where('s.sptstate', 1)// '选片状态  0未选完，1已选，2未选',
                ->count('DISTINCT s.orderId');
            // 二销金额
            $hs_fact =  db('c_customerorder', 'sx_erp_hs')->alias('o')
                ->join('c_customersp s', 's.orderId=o.orderId', 'left')
                ->where('o.consumption_type', '婚纱照')
                ->where('s.selectday', 'between', [$start, $end])
                ->where('o.blankoutannal', '0')
                ->where('s.shop_code', 'in', explode(',',$v['shop_code']))
                ->sum('o.supplementary_money');
            $xz_fact =  db('c_customerorder', 'sx_erp_hs')->alias('o')
                ->join('c_customersp s', 's.orderId=o.orderId', 'left')
                ->where('o.consumption_type', '<>', '婚纱照')
                ->where('s.selectday', 'between', [$start, $end])
                ->where('o.blankoutannal', '0')
                ->where('s.shop_code', 'in', explode(',',$v['shop_code']))
                ->sum('o.supplementary_money');
            $et_fact =  db('c_customerorder', 'sx_erp_et')->alias('o')
                ->join('c_customersp s', 's.orderId=o.orderId', 'left')
                // ->where('o.consumption_type', '婚纱照')
                ->where('s.selectday', 'between', [$start, $end])
                ->where('o.blankoutannal', '0')
                ->where('s.shop_code', 'in', explode(',',$v['shop_code']))
                ->sum('o.supplementary_money');

            $return[$k]['product'] = $v['shop_name'];

            $return[$k]['hs_fact'] = $hs_fact;
            $return[$k]['xz_fact'] = $xz_fact;
            $return[$k]['et_fact'] = $et_fact;

            $return[$k]['hs_order'] = $hs_order;
            $return[$k]['xz_order'] = $xz_order;
            $return[$k]['et_order'] = $et_order;

            $return[$k]['婚纱'] = dataFormate($hs_fact/$hs_order,0);
            $return[$k]['写真'] = dataFormate(($xz_fact+$et_fact)/($xz_order+$et_order),0);
        }
        //var_dump($return);die;
        cache('bg_lzXZExData'.$key,$return,60);
        return json($return);
    }
    // 摄影
    public function getLzSyDataDay(){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        $post = input('post.');
        $tab = $post['tab'] ? trim($post['tab']) : '兰州婚纱';
        $key = $this->getKey($tab);
        // 缓存
        $cacheData = cache('bg_lzSyDataDay'.$key);
        if ($cacheData) {
            return json($cacheData);
        }
        // 当日订单
        $params['tab']     = $tab;
        $params['start']   = $this->today['start'];
        $params['end']     = $this->today['end'];
        $allShops = $this->getLzSy($params);
        // 返回数据
        $names = [];
        $datas = [];
        foreach ($allShops as $key => $value) {
            array_push($names, $value['shop_name']);
            array_push($datas, $value['money']);
        }
        $return['names'] = $names;
        $return['datas'] = $datas;
        //var_dump($return);die;
        cache('bg_lzSyDataDay'.$key,$return,60);
        return json($return);
    }
    public function getLzXZSyDataDay(){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        $post = input('post.');
        $tab = $post['tab'] ? trim($post['tab']) : '兰州写真/儿童';
        $key = $this->getKey($tab);
        // 缓存
        $cacheData = cache('bg_lzSyDataDay'.$key);
        if ($cacheData) {
            return json($cacheData);
        }
        // 当日订单
        $params['tab']     = $tab;
        $params['start']   = $this->today['start'];
        $params['end']     = $this->today['end'];
        $allShops = $this->getLzXZSy($params);
        cache('bg_lzSyDataDay'.$key,$allShops,60);
        return json($allShops);
    }
    public function getLzSyDataMonth(){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        $post = input('post.');
        $tab = $post['tab'] ? trim($post['tab']) : '兰州婚纱';
        $key = $this->getKey($tab);
        // 缓存
        // $cacheData = cache('bg_lzSyDataMonth'.$key);
        if ($cacheData) {
            return json($cacheData);
        }
        // 当月看样(选片)
        $params['tab']     = $tab;
        $params['start']   = $this->thisMonth['start'];
        $params['end']     = $this->thisMonth['end'];
        $allShops = $this->getLzSy($params);
        /*
        $allShopCodes = '';
        foreach ($allShops as $key => $value) {
            $allShopCodes .= $value['shop_code'].',';
        }
        $allShopCodes = trim($allShopCodes,',');
        // 查询当月目标
        $tParams['goal_name']= '摄影量';
        $tParams['month']    = $this->thisMonth['start'];
        $tParams['allShopCodes']= $allShopCodes;
        $target = controller('crm/Lzl', 'lib')->getTarget($tParams);
        foreach ($allShops as $key => $value) {
            foreach ($target as $k => $v) {
                if (strpos($value['shop_code'],$k)!==false) {
                    $allShops[$key]['target'] += $target[$k];
                }else{
                    $allShops[$key]['target'] += 0;
                }
            }
        }
        // 当月订单完成比  (看样(选片)量/目标)*100
        foreach ($allShops as $key => $value) {
            $allShops[$key]['rate'] = dataFormate(($value['money']/$value['target']*100));
        }
        */
        // 返回数据
        $names = [];
        $datas = [];
        foreach ($allShops as $key => $value) {
            array_push($names, $value['shop_name']);
            array_push($datas, $value['money']);
            // array_push($datas, $value['rate']);
        }
        $return['names'] = $names;
        $return['datas'] = $datas;
        //var_dump($return);die;
        cache('bg_lzSyDataMonth'.$key,$return,60);
        return json($return);
    }
    public function getLzXZSyDataMonth(){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        $post = input('post.');
        $tab = $post['tab'] ? trim($post['tab']) : '兰州写真/儿童';
        $key = $this->getKey($tab);
        // 缓存
         $cacheData = cache('bg_lzSyDataMonth'.$key);
        if ($cacheData) {
            return json($cacheData);
        }
        // 当月看样(选片)
        $params['tab']     = $tab;
        $params['start']   = $this->thisMonth['start'];
        $params['end']     = $this->thisMonth['end'];
        $allShops = $this->getLzXZSy($params);
        cache('bg_lzSyDataDay'.$key,$allShops,60);
        return json($allShops);
    }
    // 兰州摄影量统一方法
    public function getLzSy($params){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        $tab = trim($params['tab']);
        if ($tab=='let') {
            $search_type = 2;
        }else{
            $search_type = 1;
        }

        $allShops = $this->baseBrand[$tab];
        $shops = '';
        foreach ($allShops as $key => $value) {
            $shops .= $value['shop_code'].',';
        }
        $shops = trim($shops, ',');
        // 婚纱 不包含礼服（兰州）
        $lz_params['con_type']= 1;
        $lz_params['search_type']= $search_type;
        $lz_params['start']      = $params['start'];
        $lz_params['end']        = $params['end'];
        $lz_params['shop_code']  = $shops;
        $getData = controller('crm/Lzl','lib')->getSyNum($lz_params);

        foreach ($allShops as $key => $value) {
            if (empty($getData)) {
                $allShops[$key]['money'] = 0;
            }else{
                foreach ($getData as $k => $v) {
                    if (strpos($value['shop_code'],$k)!==false) {
                        $allShops[$key]['money'] += $getData[$k] ? $getData[$k] : 0;
                        continue;
                    }else{
                        $allShops[$key]['money'] += 0;
                    }
                }
            }
        }
        return $allShops;
    }
    public function getLzXZSy($params){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        $tab = trim($params['tab']);
        if ($tab=='let') {
            $search_type = 2;
        }else{
            $search_type = 1;
        }

        $allShops = $this->baseBrand[$tab];
        $return = [];
        foreach ($allShops as $key => $value) {
            $return[$key]['product'] = $value['shop_name'];
            $lz_params['search_type']= $value['shop_type'];
            $lz_params['start']      = $params['start'];
            $lz_params['end']        = $params['end'];
            $lz_params['shop_code']  = explode(',',$value['shop_code']);
            $lz_params['con_type']   = 1;//1：婚纱；2：其他
            if($value['shop_type'] == 2){
                $return[$key]['婚纱'] = 0;
            }else{
                $return[$key]['婚纱'] = controller('crm/Lzl','lib')->getXZSyNum($lz_params);
            }
            $lz_params['con_type']   = 2;//1：婚纱；2：其他
            $return[$key]['写真'] = controller('crm/Lzl','lib')->getXZSyNum($lz_params);
        }
        return $return;
    }
    // ----------------------------------- 兰州店 -----------------------------------

    // ----------------------------------- 直营店 -----------------------------------  
    /**
     * 直营
     * 
     * @param  tabname       直营大店/直营小店
     * @return json
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getZyYsDataDay(){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        $post = input('post.');
        $tab = $post['tab'] ? trim($post['tab']) : '直营大店';
        $key = $this->getKey($tab);
        // 缓存
        $cacheData = cache('bg_zyYsDataDay'.$key);
        if ($cacheData) {
            return json($cacheData);
        }
        // 当日营收  兰州 不算礼服 和 化妆
        $params['tab']  = $tab;
        $params['start']= $this->today['start'];
        $params['end']  = $this->today['end'];
        /*$allShops = $this->getZyYs($params);

        // 返回数据
        $names = [];
        $datas = [];
        // var_dump($allShops);die;
        foreach ($allShops as $key => $value) {
            array_push($names, $value['shop_name']);
            array_push($datas, $value['money']);
        }
        $return['names'] = $names;
        $return['datas'] = $datas;*/
        $shops = $this->baseBrand[$tab];
        $return = [];
        $fundname = $this->funcname;
        foreach($shops as $k=>$v){
            $return[$k]['product']= $v['shop_name'];
            $params['shop_code'] = explode(',',$v['shop_code']);
            $params['shop_type'] = 1;
            $params['select'] = $v['select'];
            //总营收
            $params['fundname'] = array_merge($fundname[$v['shop_name']]['yixiao'],$fundname[$v['shop_name']]['erxiao'],$fundname[$v['shop_name']]['shangpin']);
            // 查询当月目标
            // $tParams['goal_name']= '总营收';
            $tParams['month']    = $this->thisMonth['start'];
            $tParams['allShopCodes']= $params['shop_code'];

            // $target = controller('crm/Lzl', 'lib')->getTarget($tParams);
            // $fact = controller('crm/Lzl','lib')->getFact($params);
            // $return[$k]['总营收'] = dataFormate($fact/$target*100);
            //订单营收
            // $params['fundname'] = $fundname[$v['shop_name']]['yixiao'];
            $params['suoshu'] = ['前期款','前期补款'];
            $order = controller('crm/Lzl','lib')->getFact($params);
            $return[$k]['一销营收'] = dataFormate($order,0);
            //礼服营收
            // $params['fundname'] = $fundname[$v['shop_name']]['erxiao'];
            $params['suoshu'] = ['后期款','后期补款'];
            $lifu = controller('crm/Lzl','lib')->getFact($params);
            $return[$k]['二销营收'] = dataFormate($lifu,0);
        }
        //var_dump($return);die;
        cache('bg_lzYsDataDay'.$key,$return,60);
        return json($return);
    }
    public function getZyYsDataMonth(){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        $post = input('post.');
        $tab = $post['tab'] ? trim($post['tab']) : '直营大店';
        $key = $this->getKey($tab);
        // 缓存
         $cacheData = cache('bg_zyYsDataMonth'.$key);
        if ($cacheData) {
            return json($cacheData);
        }
        // 当月营收  兰州 不算礼服 和 化妆
        $params['tab']  = $tab;
        $params['start']= $this->thisMonth['start'];
        $params['end']  = $this->thisMonth['end'];
        /*$allShops = $this->getZyYs($params);

        $allShopCodes = '';
        foreach ($allShops as $key => $value) {
            $allShopCodes .= $value['shop_code'].',';
        }
        $allShopCodes = trim($allShopCodes,',');
        // 查询当月目标
        $tParams['goal_name']= '订单营收';
        $tParams['month']    = $this->thisMonth['start'];
        $tParams['allShopCodes']= $allShopCodes;
        $target = controller('crm/Lzl', 'lib')->getTarget($tParams);
        foreach ($allShops as $key => $value) {
            foreach ($target as $k => $v) {
                if (strpos($value['shop_code'],$k)!==false) {
                    $allShops[$key]['target'] += $target[$k];
                }else{
                    $allShops[$key]['target'] += 0;
                }
            }
        }
        // 当月营收  (营收/目标)*100
        foreach ($allShops as $key => $value) {
            $allShops[$key]['rate'] = dataFormate(($value['money']/$value['target']*100));
        }
        // 返回数据
        $names = [];
        $datas = [];
        foreach ($allShops as $key => $value) {
            array_push($names, $value['shop_name']);
            array_push($datas, $value['rate']);
        }
        $return['names'] = $names;
        $return['datas'] = $datas;*/
        $shops = $this->baseBrand[$tab];
        $return = [];
        $fundname = $this->funcname;
        foreach($shops as $k=>$v){
            $return[$k]['product']= $v['shop_name'];
            $params['shop_code'] = explode(',',$v['shop_code']);
            $params['shop_type'] = 1;
            $params['select'] = $v['select'];
            //总营收
            // $params['fundname'] = array_merge($fundname[$v['shop_name']]['yixiao'],$fundname[$v['shop_name']]['erxiao'],$fundname[$v['shop_name']]['shangpin']);
            // 查询当月目标
            // $tParams['goal_name']= '总营收';
            $tParams['month']    = $this->thisMonth['start'];
            $tParams['allShopCodes']= $params['shop_code'];

            // $target = controller('crm/Lzl', 'lib')->getTarget($tParams);
            // $fact = controller('crm/Lzl','lib')->getFact($params);
            // $return[$k]['总营收'] = dataFormate($fact/$target*100);
            //订单营收
            // $params['fundname'] = $fundname[$v['shop_name']]['yixiao'];
            $params['suoshu'] = ['前期款','前期补款'];
            $params['payclass'] = 0;
            $tParams['goal_name']= '一销营收';
            $target = controller('crm/Lzl', 'lib')->getTarget($tParams);
            $order = controller('crm/Lzl','lib')->getFact($params);
            $return[$k]['一销营收'] = dataFormate($order/$target*100,0);
            //礼服营收
            // $params['fundname'] = $fundname[$v['shop_name']]['erxiao'];
            $tParams['goal_name']= '二销营收';
            $params['suoshu'] = ['后期款','后期补款'];
            $target = controller('crm/Lzl', 'lib')->getTarget($tParams);
            $lifu = controller('crm/Lzl','lib')->getFact($params);
            $return[$k]['二销营收'] = dataFormate($lifu/$target*100,0);
        }
        //var_dump($return);die;
        cache('bg_lzYsDataMonth'.$key,$return,60);
        return json($return);
    }
    // 获取 直营店 营收统一方法
    public function getZyYs($params){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        $tab = trim($params['tab']);
        // 当日营收   算礼服 和 化妆
        $allShops = $this->baseBrand[$tab];
        $hsShops = '';
        $etShops = '';
        foreach ($allShops as $key => $value) {
            foreach ($value as $k => $v) {
                if ($k=='儿童') {
                    $etShops .= $v.',';
                }else{
                    $hsShops .= $v.',';
                }
                $allShops[$key]['shop_code'] .= $v.',';
            }
        }
        $hsShops = trim($hsShops, ',');
        $etShops = trim($etShops, ',');
        // 婚纱 包含礼服
        $zy_hs_params['search_type']= 1;
        $zy_hs_params['payclass']   = '0,1,2';
        $zy_hs_params['start']      = $params['start'];
        $zy_hs_params['end']        = $params['end'];
        $zy_hs_params['shop_code']  = $hsShops;
        $getData_hs = controller('crm/Lzl','lib')->getYsYj($zy_hs_params);
        foreach ($allShops as $key => $value) {
            if (empty($getData_hs)) {
                $allShops[$key]['money'] = 0;
            }else{
                foreach ($getData_hs as $k => $v) {
                    if (strpos($value['shop_code'],$k)!==false) {
                        $allShops[$key]['money'] += $getData_hs[$k];
                        continue;
                    }else{
                        $allShops[$key]['money'] += 0;
                    }
                }
            }
        }
        // var_dump($allShops);
        // die;
        // 儿童 
        $zy_et_params['search_type']= 2;
        $zy_et_params['payclass']   = '0,1,2';
        $zy_et_params['start']      = $params['start'];
        $zy_et_params['end']        = $params['end'];
        $zy_et_params['shop_code']  = $etShops;
        $getData_et = controller('crm/Lzl','lib')->getYsYj($zy_et_params);
        
        foreach ($allShops as $key => $value) {
            if (empty($getData_et)) {
                $allShops[$key]['money'] += 0;
            }else{
                foreach ($getData_et as $k => $v) {
                    if (strpos($value['shop_code'],$k)!==false) {
                        $allShops[$key]['money'] += $getData_et[$k];
                        continue;
                    }else{
                        $allShops[$key]['money'] += 0;
                    }
                }
            }
        }        
        return $allShops;
    }
    // 订单
    public function getZyDdDataDay(){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        $post = input('post.');
        $tab = $post['tab'] ? trim($post['tab']) : '直营大店';
        $key = $this->getKey($tab);
        // 缓存
        $cacheData = cache('bg_zyDdDataDay'.$key);
        if ($cacheData) {
            return json($cacheData);
        }
        // 当日订单
        $params['tab']  = $tab;
        $params['start']= $this->today['start'];
        $params['end']  = $this->today['end'];
        $allShops = $this->getZyDd($params);
        // 返回数据
        $return = [];
        foreach ($allShops as $key => $value) {
            $temp['product']= $value['shop_name'];
            $temp['婚纱']   = $value['hs_money'];
            $temp['写真']   = $value['xz_money'];
            $temp['儿童']   = $value['et_money'];
            array_push($return, $temp);
        }
        // var_dump($return);die;
        cache('bg_zyDdDataDay'.$key,$return,60);
        return json($return);
    }
     public function getZyDdDataMonth(){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        $post = input('post.');
        $tab = $post['tab'] ? trim($post['tab']) : '直营大店';
        $key = $this->getKey($tab);
        // 缓存
        $cacheData = cache('bg_zyDdDataMonth'.$key);
        if ($cacheData) {
            return json($cacheData);
        }
        // 当月订单
        $params['tab']  = $tab;
        $params['start']= $this->thisMonth['start'];
        $params['end']  = $this->thisMonth['end'];
        $allShops = $this->getZyDd($params);
        // 目标
       /* foreach ($allShops as $key => $value) {
            // 婚纱目标
            $tParams['goal_name']= '直营婚纱订单量';
            $tParams['month']    = $this->thisMonth['start'];
            $tParams['allShopCodes']= $value['婚纱'];
            $target_hs = controller('crm/Lzl', 'lib')->getTarget($tParams);
            $hs_target = 0;
            foreach ($target_hs as $k => $v) {
                $hs_target += $v;
            }
            $allShops[$key]['hs_target'] = $target_hs;
            unset($k,$v);
            // 写真目标
            $tParams['goal_name']= '直营写真订单量';
            $tParams['month']    = $this->thisMonth['start'];
            $tParams['allShopCodes']= $value['写真'];
            $target_xz = controller('crm/Lzl', 'lib')->getTarget($tParams);
            $xz_target = 0;
            foreach ($target_xz as $k => $v) {
                $xz_target += $v;
            }
            $allShops[$key]['xz_target'] = $target_xz;
            unset($k,$v);
            // 儿童目标
            $tParams['goal_name']= '直营儿童订单量';
            $tParams['month']    = $this->thisMonth['start'];
            $tParams['allShopCodes']= $value['儿童'];
            $target_et = controller('crm/Lzl', 'lib')->getTarget($tParams);
            $et_target = 0;
            foreach ($target_et as $k => $v) {
                $et_target += $v;
            }
            $allShops[$key]['et_target'] = $target_et;
            unset($k,$v);
        }*/
        // 返回数据
        $return = [];
        foreach ($allShops as $key => $value) {
            $temp['product']= $value['shop_name'];
            // $temp['婚纱']   = dataFormate($value['hs_money']/$value['hs_target']*100,0);
            // $temp['写真']   = dataFormate($value['xz_money']/$value['xz_target']*100,0);
            // $temp['儿童']   = dataFormate($value['et_money']/$value['et_target']*100,0);
            $temp['婚纱']   = $value['hs_money'];
            $temp['写真']   = $value['xz_money'];
            $temp['儿童']   = $value['et_money'];
            array_push($return, $temp);
        }
        // var_dump($return);die;
        cache('bg_zyDdDataMonth'.$key,$return,60);
        return json($return);
    }
    // 直营店 订单数统一方法
    public function getZyDd($params){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        $tab = trim($params['tab']);
        // 订单量 
        $allShops = $this->baseBrand[$tab];
        $hsShops = '';
        $xzShops = '';
        $etShops = '';
        foreach ($allShops as $key => $value) {
            foreach ($value as $k => $v) {
                if ($k=='婚纱') {
                    $hsShops .= $v.',';
                }elseif ($k=='写真') {
                    $xzShops .= $v.',';
                }else if($k=='儿童'){
                    $etShops .= $v.',';
                }
            }
        }
        $hsShops = trim($hsShops, ',');
        $xzShops = trim($xzShops, ',');
        $etShops = trim($etShops, ',');
        // 婚纱
        $zy_hs_params['search_type']= 1;
        $zy_hs_params['start']      = $params['start'];
        $zy_hs_params['end']        = $params['end'];
        $zy_hs_params['shop_code']  = $hsShops;
        $zy_hs_params['con_type']   = '1';
        $getData_hs = controller('crm/Lzl','lib')->getDdNum($zy_hs_params);
        // var_dump($getData_hs);die;
        foreach ($allShops as $key => $value) {
            if (empty($getData_hs)) {
                $allShops[$key]['hs_money'] = 0;
            }else{
                foreach ($getData_hs as $k => $v) {
                    if (strpos($value['婚纱'],$k)!==false) {
                        $allShops[$key]['hs_money'] += $getData_hs[$k];
                        continue;
                    }else{
                        $allShops[$key]['hs_money'] += 0;
                    }
                }
            }
        }
        // 写真
        $zy_xz_params['search_type']= 1;
        $zy_xz_params['start']      = $params['start'];
        $zy_xz_params['end']        = $params['end'];
        $zy_xz_params['shop_code']  = $xzShops;
        $zy_xz_params['con_type']   = '2';
        $getData_xz = controller('crm/Lzl','lib')->getDdNum($zy_xz_params);
        foreach ($allShops as $key => $value) {
            if (empty($getData_xz)) {
                $allShops[$key]['xz_money'] = 0;
            }else{
                foreach ($getData_xz as $k => $v) {
                    if (strpos($value['写真'],$k)!==false) {
                        $allShops[$key]['xz_money'] += $getData_xz[$k];
                        continue;
                    }else{
                        $allShops[$key]['xz_money'] += 0;
                    }
                }
            }
        }
        // 儿童
        $zy_et_params['search_type']= 2;
        $zy_et_params['start']      = $params['start'];
        $zy_et_params['end']        = $params['end'];
        $zy_et_params['shop_code']  = $etShops;
        $zy_et_params['con_type']   = '3';
        $getData_et = controller('crm/Lzl','lib')->getDdNum($zy_et_params);
        foreach ($allShops as $key => $value) {
            if (empty($getData_et)) {
                $allShops[$key]['et_money'] = 0;
            }else{
                foreach ($getData_et as $k => $v) {
                    if (strpos($value['儿童'],$k)!==false) {
                        $allShops[$key]['et_money'] += $getData_et[$k];
                        continue;
                    }else{
                        $allShops[$key]['et_money'] += 0;
                    }
                }
            }
        }
        return $allShops;
    }
    // 看样 (选片)
    public function getZyKyDataDay(){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        $post = input('post.');
        $tab = $post['tab'] ? trim($post['tab']) : '直营大店';
        $key = $this->getKey($tab);
        // 缓存
        $cacheData = cache('bg_zyKyDataDay'.$key);
        if ($cacheData) {
            return json($cacheData);
        }
        // 当日订单
        $params['tab']  = $tab;
        $params['start']= $this->today['start'];
        $params['end']  = $this->today['end'];
        $allShops = $this->getZyKy($params);
        // 返回数据
        $return = [];
        foreach ($allShops as $key => $value) {
            $temp['product']= $value['shop_name'];
            $temp['婚纱']   = $value['hs_money'];
            $temp['写真']   = $value['xz_money'];
            $temp['儿童']   = $value['et_money'];
            array_push($return, $temp);
        }
        // var_dump($return);die;
        cache('bg_zyKyDataDay'.$key,$return,60);
        return json($return);
    }
    public function getZyKyDataMonth(){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        $post = input('post.');
        $tab = $post['tab'] ? trim($post['tab']) : '直营大店';
        $key = $this->getKey($tab);
        // 缓存
        $cacheData = cache('bg_zyKyDataMonth'.$key);
        if ($cacheData) {
            return json($cacheData);
        }
        // 当月看样
        $params['tab']  = $tab;
        $params['start']= $this->thisMonth['start'];
        $params['end']  = $this->thisMonth['end'];
        $allShops = $this->getZyKy($params);
        /*
        // 目标
        foreach ($allShops as $key => $value) {
            // 婚纱目标
            $tParams['goal_name']= '直营婚纱看样量';
            $tParams['month']    = $this->thisMonth['start'];
            $tParams['allShopCodes']= $value['婚纱'];
            $target_hs = controller('crm/Lzl', 'lib')->getTarget($tParams);
            $hs_target = 0;
            foreach ($target_hs as $k => $v) {
                $hs_target += $v;
            }
            $allShops[$key]['hs_target'] = $hs_target;
            unset($k,$v);
            // 写真目标
            $tParams['goal_name']= '直营写真看样量';
            $tParams['month']    = $this->thisMonth['start'];
            $tParams['allShopCodes']= $value['写真'];
            $target_xz = controller('crm/Lzl', 'lib')->getTarget($tParams);
            $xz_target = 0;
            foreach ($target_xz as $k => $v) {
                $xz_target += $v;
            }
            $allShops[$key]['xz_target'] = $xz_target;
            unset($k,$v);
            // 儿童目标
            $tParams['goal_name']= '直营儿童看样量';
            $tParams['month']    = $this->thisMonth['start'];
            $tParams['allShopCodes']= $value['儿童'];
            $target_et = controller('crm/Lzl', 'lib')->getTarget($tParams);
            $et_target = 0;
            foreach ($target_et as $k => $v) {
                $et_target += $v;
            }
            $allShops[$key]['et_target'] = $et_target;
            unset($k,$v);
        }
        */
        // 返回数据
        $return = [];
        foreach ($allShops as $key => $value) {
            $temp['product']= $value['shop_name'];
            $temp['婚纱']   = $value['hs_money'];
            $temp['写真']   = $value['xz_money'];
            $temp['儿童']   = $value['et_money'];
            /*
            array_push($temp, '婚纱:'.dataFormate($value['hs_money']/$value['hs_target']*100));
            array_push($temp, '写真:'.dataFormate($value['xz_money']/$value['xz_target']*100));
            array_push($temp, '儿童:'.dataFormate($value['et_money']/$value['et_target']*100));
            */
            array_push($return, $temp);
        }
        // var_dump($return);die;
        cache('bg_zyKyDataMonth'.$key,$return,60);
        return json($return);
    }
    // 直营看样(选片)量统一方法
    public function getZyKy($params){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        $tab = trim($params['tab']);
        // 看样量 
        $allShops = $this->baseBrand[$tab];
        $hsShops = '';
        $xzShops = '';
        $etShops = '';
        foreach ($allShops as $key => $value) {
            foreach ($value as $k => $v) {
                if ($k=='婚纱') {
                    $hsShops .= $v.',';
                }elseif ($k=='写真') {
                    $xzShops .= $v.',';
                }else if($k=='儿童'){
                    $etShops .= $v.',';
                }
            }
        }
        $hsShops = trim($hsShops, ',');
        $xzShops = trim($xzShops, ',');
        $etShops = trim($etShops, ',');
        // 婚纱
        $zy_hs_params['search_type']= 1;
        $zy_hs_params['start']      = $params['start'];
        $zy_hs_params['end']        = $params['end'];
        $zy_hs_params['shop_code']  = $hsShops;
        $zy_hs_params['con_type']   = 1;
        $getData_hs = controller('crm/Lzl','lib')->getKyNum($zy_hs_params);

        foreach ($allShops as $key => $value) {
            if (empty($getData_hs)) {
                $allShops[$key]['hs_money'] = 0;
            }else{
                foreach ($getData_hs as $k => $v) {
                    if (strpos($value['婚纱'],$k)!==false) {
                        $allShops[$key]['hs_money'] += $getData_hs[$k];
                        continue;
                    }else{
                        $allShops[$key]['hs_money'] += 0;
                    }
                }
            }
        }
        // 写真
        $zy_xz_params['search_type']= 1;
        $zy_xz_params['start']      = $params['start'];
        $zy_xz_params['end']        = $params['end'];
        $zy_xz_params['shop_code']  = $xzShops;
        $zy_xz_params['con_type']   = 2;
        $getData_xz = controller('crm/Lzl','lib')->getKyNum($zy_xz_params);
        foreach ($allShops as $key => $value) {
            if (empty($getData_xz)) {
                $allShops[$key]['xz_money'] = 0;
            }else{
                foreach ($getData_xz as $k => $v) {
                    if (strpos($value['写真'],$k)!==false) {
                        $allShops[$key]['xz_money'] += $getData_xz[$k];
                        continue;
                    }else{
                        $allShops[$key]['xz_money'] += 0;
                    }
                }
            }
        }
        // 儿童
        $zy_et_params['search_type']= 2;
        $zy_et_params['start']      = $params['start'];
        $zy_et_params['end']        = $params['end'];
        $zy_et_params['shop_code']  = $etShops;
        $zy_et_params['con_type']   = 3;
        $getData_et = controller('crm/Lzl','lib')->getKyNum($zy_et_params);
        foreach ($allShops as $key => $value) {
            if (empty($getData_et)) {
                $allShops[$key]['et_money'] = 0;
            }else{
                foreach ($getData_et as $k => $v) {
                    if (strpos($value['儿童'],$k)!==false) {
                        $allShops[$key]['et_money'] += $getData_et[$k];
                        continue;
                    }else{
                        $allShops[$key]['et_money'] += 0;
                    }
                }
            }
        }
        return $allShops;
    }
    // 平销 (套系总额 / 订单金额大于0的订单量)
    public function getZyYxData(){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        $post = input('post.');
        $tab = $post['tab'] ? trim($post['tab']) : '直营大店';
        $key = $this->getKey($tab);
        // 缓存
        $cacheData = cache('bg_zyYxData'.$key);
        if ($cacheData) {
            return json($cacheData);
        }
        // 当月订单量 
        $params['tab']  = $tab;
        $params['start']= $this->month['start'];
        $params['end']  = $this->month['end'];
        $allShops = $this->getZyDd($params);
        // 当月二销总额
        foreach ($allShops as $key => $value) {
            // 婚纱当月一销总额
            $hs_money_params['search_type']= 1;
            $hs_money_params['shop_code']  = $value['婚纱'];
            $hs_money_params['start']      = $this->month['start'];
            $hs_money_params['end']        = $this->month['end'];
            $hs_money_params['con_type']   = 1;
            $hs_money = controller('crm/Lzl', 'lib')->getYxMoney($hs_money_params);
            $hs_all_money = 0;
            foreach ($hs_money as $k => $v) {
                $hs_all_money += $v;
            }
            $allShops[$key]['hs_all_money'] = $hs_all_money;
            unset($k,$v);
            // 写真目标
            $xz_money_params['search_type']= 1;
            $xz_money_params['shop_code']  = $value['写真'];
            $xz_money_params['start']      = $this->month['start'];
            $xz_money_params['end']        = $this->month['end'];
            $xz_money_params['con_type']   = 2;
            $xz_money = controller('crm/Lzl', 'lib')->getYxMoney($xz_money_params);
            $xz_all_money = 0;
            foreach ($xz_money as $k => $v) {
                $xz_all_money += $v;
            }
            $allShops[$key]['xz_all_money'] = $xz_all_money;
            unset($k,$v);
            // 儿童目标
            $et_money_params['search_type']= 2;
            $et_money_params['shop_code']  = $value['儿童'];
            $et_money_params['start']      = $this->month['start'];
            $et_money_params['end']        = $this->month['end'];
            $et_money_params['con_type']   = 3;
            $et_money = controller('crm/Lzl', 'lib')->getYxMoney($et_money_params);
            $et_all_money = 0;
            foreach ($et_money as $k => $v) {
                $et_all_money += $v;
            }
            $allShops[$key]['et_all_money'] = $et_all_money;
            unset($k,$v);
        }

        $return = [];
        foreach ($allShops as $key => $value) {
            $temp['product']= $value['shop_name'];
            $temp['婚纱']   = dataFormate($value['hs_all_money']/$value['hs_money'],0);
            $temp['写真']   = dataFormate($value['xz_all_money']/$value['xz_money'],0);
            $temp['儿童']   = dataFormate($value['et_all_money']/$value['et_money'],0);
            array_push($return, $temp);
        }

        cache('bg_zyYxData'.$key,$return,60);
        return json($return);
    }
    public function getZyExData(){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        $post = input('post.');
        $tab = $post['tab'] ? trim($post['tab']) : '直营大店';
        $key = $this->getKey($tab);
        // 缓存
         $cacheData = cache('bg_zyExData'.$key);
        if ($cacheData) {
            return json($cacheData);
        }
        // 当月订单量 
        $params['tab']  = $tab;
        $params['start']= $this->today['start'];
        $params['end']  = $this->today['end'];
        $allShops = $this->getZyKy($params);
        // 当月一销总额
        foreach ($allShops as $key => $value) {
            // 婚纱当月一销总额
            $hs_money_params['search_type']= 1;
            $hs_money_params['shop_code']  = $value['婚纱'];
            $hs_money_params['start']      = $this->today['start'];
            $hs_money_params['end']        = $this->today['end'];
            $hs_money_params['con_type']   = 1;
            $hs_money = controller('crm/Lzl', 'lib')->getExMoney($hs_money_params);
            $hs_all_money = 0;
            foreach ($hs_money as $k => $v) {
                $hs_all_money += $v;
            }
            $allShops[$key]['hs_all_money'] = $hs_all_money;
            unset($k,$v);
            // 写真目标
            $xz_money_params['search_type']= 1;
            $xz_money_params['shop_code']  = $value['写真'];
            $xz_money_params['start']      = $this->today['start'];
            $xz_money_params['end']        = $this->today['end'];
            $xz_money_params['con_type']   = 2;
            $xz_money = controller('crm/Lzl', 'lib')->getExMoney($xz_money_params);
            $xz_all_money = 0;
            foreach ($xz_money as $k => $v) {
                $xz_all_money += $v;
            }
            $allShops[$key]['xz_all_money'] = $xz_all_money;
            unset($k,$v);
            // 儿童目标
            $et_money_params['search_type']= 2;
            $et_money_params['shop_code']  = $value['儿童'];
            $et_money_params['start']      = $this->today['start'];
            $et_money_params['end']        = $this->today['end'];
            $et_money_params['con_type']   = 3;
            $et_money = controller('crm/Lzl', 'lib')->getExMoney($et_money_params);
            $et_all_money = 0;
            foreach ($et_money as $k => $v) {
                $et_all_money += $v;
            }
            $allShops[$key]['et_all_money'] = $et_all_money;
            unset($k,$v);
        }
        $return = [];
        foreach ($allShops as $key => $value) {
            $temp['product']= $value['shop_name'];
            $temp['婚纱']   = dataFormate($value['hs_all_money']/$value['hs_money'],0);
            $temp['写真']   = dataFormate($value['xz_all_money']/$value['xz_money'],0);
            $temp['儿童']   = dataFormate($value['et_all_money']/$value['et_money'],0);
            array_push($return, $temp);
        }
        // var_dump($allShops);die;
        cache('bg_zyExData'.$key,$return,60);
        return json($return);
    }
    // 摄影
    public function getZySyDataDay(){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        $post = input('post.');
        $tab = $post['tab'] ? trim($post['tab']) : '直营大店';
        $key = $this->getKey($tab);
        // 缓存
        $cacheData = cache('bg_zySyDataDay'.$key);
        if ($cacheData) {
            return json($cacheData);
        }
        // 当日订单
        $params['tab']  = $tab;
        $params['start']= $this->today['start'];
        $params['end']  = $this->today['end'];
        $allShops = $this->getZySy($params);
        // 返回数据
        $return = [];
        foreach ($allShops as $key => $value) {
            $temp['product']= $value['shop_name'];
            $temp['婚纱']   = $value['hs_money'];
            $temp['写真']   = $value['xz_money'];
            $temp['儿童']   = $value['et_money'];
            // array_push($temp, 'product:'.$value['shop_name']);
            // array_push($temp, '婚纱:'.$value['hs_money']);
            // array_push($temp, '写真:'.$value['xz_money']);
            // array_push($temp, '儿童:'.$value['et_money']);
            array_push($return, $temp);
        }
        // var_dump($return);die;
        cache('bg_zySyDataDay'.$key,$return,60);
        return json($return);
    }
    public function getZySyDataMonth(){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        $post = input('post.');
        $tab = $post['tab'] ? trim($post['tab']) : '直营大店';
        $key = $this->getKey($tab);
        // 缓存
        $cacheData = cache('bg_zySyDataMonth'.$key);
        if ($cacheData) {
            return json($cacheData);
        }
        // 当月摄影
        $params['tab']  = $tab;
        $params['start']= $this->thisMonth['start'];
        $params['end']  = $this->thisMonth['end'];
        $allShops = $this->getZySy($params);
        /*
        // 目标
        foreach ($allShops as $key => $value) {
            // 婚纱目标
            $tParams['goal_name']= '直营婚纱摄影量';
            $tParams['month']    = $this->thisMonth['start'];
            $tParams['allShopCodes']= $value['婚纱'];
            $target_hs = controller('crm/Lzl', 'lib')->getTarget($tParams);
            $hs_target = 0;
            foreach ($target_hs as $k => $v) {
                $hs_target += $v;
            }
            $allShops[$key]['hs_target'] = $hs_target;
            unset($k,$v);
            // 写真目标
            $tParams['goal_name']= '直营写真摄影量';
            $tParams['month']    = $this->thisMonth['start'];
            $tParams['allShopCodes']= $value['写真'];
            $target_xz = controller('crm/Lzl', 'lib')->getTarget($tParams);
            $xz_target = 0;
            foreach ($target_xz as $k => $v) {
                $xz_target += $v;
            }
            $allShops[$key]['xz_target'] = $xz_target;
            unset($k,$v);
            // 儿童目标
            $tParams['goal_name']= '直营儿童摄影量';
            $tParams['month']    = $this->thisMonth['start'];
            $tParams['allShopCodes']= $value['儿童'];
            $target_et = controller('crm/Lzl', 'lib')->getTarget($tParams);
            $et_target = 0;
            foreach ($target_et as $k => $v) {
                $et_target += $v;
            }
            $allShops[$key]['et_target'] = $et_target;
            unset($k,$v);
        }
        */
        // 返回数据
        $return = [];
        foreach ($allShops as $key => $value) {
            $temp['product']= $value['shop_name'];
            $temp['婚纱']   = $value['hs_money'];
            $temp['写真']   = $value['xz_money'];
            $temp['儿童']   = $value['et_money'];
            /*
            array_push($temp, '婚纱:'.dataFormate($value['hs_money']/$value['hs_target']*100));
            array_push($temp, '写真:'.dataFormate($value['xz_money']/$value['xz_target']*100));
            array_push($temp, '儿童:'.dataFormate($value['et_money']/$value['et_target']*100));
            */
            array_push($return, $temp);
        }
        // var_dump($return);die;
        cache('bg_zySyDataMonth'.$key,$return,60);
        return json($return);
    }
    // 直营 摄影量 统一方法
    public function getZySy($params){
        // 权限
        $auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        $tab = trim($params['tab']);
        // 摄影量 
        $allShops = $this->baseBrand[$tab];
        $hsShops = '';
        $xzShops = '';
        $etShops = '';
        foreach ($allShops as $key => $value) {
            foreach ($value as $k => $v) {
                if ($k=='婚纱') {
                    $hsShops .= $v.',';
                }elseif ($k=='写真') {
                    $xzShops .= $v.',';
                }else if($k=='儿童'){
                    $etShops .= $v.',';
                }
            }
        }
        $hsShops = trim($hsShops, ',');
        $xzShops = trim($xzShops, ',');
        $etShops = trim($etShops, ',');
        // 婚纱
        $zy_hs_params['search_type']= 1;
        $zy_hs_params['start']      = $params['start'];
        $zy_hs_params['end']        = $params['end'];
        $zy_hs_params['shop_code']  = $hsShops;
        $zy_hs_params['con_type']   = 1;
        $getData_hs = controller('crm/Lzl','lib')->getSyNum($zy_hs_params);
        // var_dump($getData_hs);die;
        foreach ($allShops as $key => $value) {
            if (empty($getData_hs)) {
                $allShops[$key]['hs_money'] = 0;
            }else{
                foreach ($getData_hs as $k => $v) {
                    if (strpos($value['婚纱'],$k)!==false) {
                        $allShops[$key]['hs_money'] += $getData_hs[$k];
                        continue;
                    }else{
                        $allShops[$key]['hs_money'] += 0;
                    }
                }
            }
        }
        // 写真
        $zy_xz_params['search_type']= 1;
        $zy_xz_params['start']      = $params['start'];
        $zy_xz_params['end']        = $params['end'];
        $zy_xz_params['shop_code']  = $xzShops;
        $zy_xz_params['con_type']   = 2;
        $getData_xz = controller('crm/Lzl','lib')->getSyNum($zy_xz_params);
        foreach ($allShops as $key => $value) {
            if (empty($getData_xz)) {
                $allShops[$key]['xz_money'] = 0;
            }else{
                foreach ($getData_xz as $k => $v) {
                    if (strpos($value['写真'],$k)!==false) {
                        $allShops[$key]['xz_money'] += $getData_xz[$k];
                        continue;
                    }else{
                        $allShops[$key]['xz_money'] += 0;
                    }
                }
            }
        }
        // 儿童
        $zy_et_params['search_type']= 2;
        $zy_et_params['start']      = $params['start'];
        $zy_et_params['end']        = $params['end'];
        $zy_et_params['shop_code']  = $etShops;
        $zy_et_params['con_type']   = 3;
        $getData_et = controller('crm/Lzl','lib')->getSyNum($zy_et_params);
        // var_dump($getData_et);die;
        foreach ($allShops as $key => $value) {
            if (empty($getData_et)) {
                $allShops[$key]['et_money'] = 0;
            }else{
                foreach ($getData_et as $k => $v) {
                    if (strpos($value['儿童'],$k)!==false) {
                        $allShops[$key]['et_money'] += $getData_et[$k];
                        continue;
                    }else{
                        $allShops[$key]['et_money'] += 0;
                    }
                }
            }
        }
        return $allShops;
    }
    // ----------------------------------- 直营店 -----------------------------------  
}