<?php
/**
 * 绝对人气 大屏专用lib
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: lilong<lilong@suxuantech.cn> $
 */
namespace app\crm\lib;
use think\Controller;

class Xafszjs extends Controller{
    // 大屏专用  判断  该员工是否有权限查看大屏数据
    public function checkBigScreenAuth(){
        // 获取配置文件中的信息，根据,分割成数组，如果staff_id不存在，则跳转到登录或首页
        $staff_id = session('staff_id');
        $str_id = config('bigScreen_id');
        $bigScreen_id = explode(',', $str_id);
        $is_in = in_array($staff_id, $bigScreen_id);
        if ($is_in === false) {
            // 查看有无查看大屏权限
            if(check_right('menu1556162726')){
                return true;
            }
            return false;
        }else{
            return true;
        }
    }
    /**
     * 获取所有的组
     * 
     * @param  id              部门id
     * @param  department_name 部门名
     * 
     * @return string
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getAllGroups($param){
        $cacheKey = md5(json_encode($param));
        $allGroups = cache('allGroups_'.$cacheKey);
        if (!$allGroups) {
            $where['department_id'] = (int)$param['id'];
            $where['department_name'] = trim($param['department_name']);
        
            $allGroups = db('c_staff_group')->where($where)->select();
            if ($allGroups) {
                cache('allGroups_'.$cacheKey, $allGroups);
            }
        }
        return $allGroups;
    }
    /**
     * 店内在线员工查询
     * 
     * @param  shop_code[]      shop_code数组
     * 
     * @return string
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getOnlineStaffs($param){
        $shop_code = $param['shop_code'];
        $shops = '';
        foreach ($shop_code as $key => $value) {
            $shops .= $value.',';
        }
        $shops = trim($shops,',');
        $staffs = cache('staffs_hw_'.$shops);
        if (!$staffs) {
            $mc = new \app\common\lib\mcInterface();
            $staffs = $mc->getStaffsByWorkType( array('shop_code'=>$shops, 'work_type'=>RECEIVE_WORK_TYPE) );
            if ($staffs) {
                cache('staffs_hw_'.$param['shop_code'], $staffs);
            }
        }
        
        $onlineStaffs = 0;
        foreach ($staffs as $key => $value) {
            $status = controller('crm/Customer','lib')->getStaffOnlineStatus($value['id']);
            if ($status) {
                $onlineStaffs++;
            }
        }
        
        return $onlineStaffs;
    }
    /**
     *  毛客资量
     * 
     * @param  shop_code[]   shop_code数组
     * @param  start         开始时间
     * @param  end           结束时间
     * 
     * @return string
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getCustomerNum($param){
        $where['is_status'] = 1;
        $where['c_from'] = 1;
        if ($param['shop_code']) {
            $shop_code = '';
            foreach ($param['shop_code'] as $key => $value) {
                $shop_code .= $value.',';
            }
            $shop_code = trim($shop_code,',');
            $where['shop_code'] = ['in', $shop_code];
        }
        $num = db('c_customerinfo')
            ->where($where)
            ->where('dj_day', 'between time', [$param['start'], $param['end']])
            ->count();
        // echo db()->getLastSql();
        return $num;
    }
    /**
     *  待追踪客资量
     * 
     * @param  shop_code[]   shop_code数组
     * @param  start         开始时间
     * @param  end           结束时间
     * 
     * @return string
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getDzzNum($param){
        $where['is_status'] = 1;
        $where['c_from'] = 1;
        if ($param['shop_code']) {
            $shop_code = '';
            foreach ($param['shop_code'] as $key => $value) {
                $shop_code .= $value.',';
            }
            $shop_code = trim($shop_code,',');
            $where['shop_code'] = ['in', $shop_code];
        }
        $num = db('c_customerinfo')
            ->where($where)
            ->where('dj_day', 'between time', [$param['start'], $param['end']])
            ->where('c_star_day','null')
            ->count();
        // echo db()->getLastSql();
        return $num;
    }
    //-------------------------- 员工 --------------------------//
    /**
     *  网销员工客资数量
     * 
     * @param  shop_code[]   shop_code数组
     * @param  start         开始时间
     * @param  end           结束时间
     * 
     * @return string
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getAllStaffCus($param){
        $cacheKey = md5(json_encode($param));
        $staffCus = cache('allStaffCus_'.$cacheKey);
        if (!$staffCus) {
            $where['c.is_status'] = 1;
            $where['c.c_from'] = 1;
            if ($param['shop_code']) {
                $shop_code = '';
                foreach ($param['shop_code'] as $key => $value) {
                    $shop_code .= $value.',';
                }
                $shop_code = trim($shop_code,',');
                $where['c.shop_code'] = ['in', $shop_code];
            }
            $staffCus = db('c_customerinfo')->alias('c')
                ->where($where)
                ->where('c.dj_day', 'between time', [$param['start'], $param['end']])
                ->where('c.sales_staff_id','>',0)
                ->group('c.sales_staff')
                ->order('cusNum desc')
                ->column('count(c.id) as cusNum,c.sales_staff,c.sales_staff_id', 'c.sales_staff');
            // echo db()->getLastSql();die;
            if ($staffCus_) {
                cache('allStaffCus_'.$cacheKey, $staffCus, 60);
            }
        }
        return $staffCus;
    }
    /**
     *  网销员工订单数量
     * 
     * @param  shop_code[]   shop_code数组
     * @param  start         开始时间
     * @param  end           结束时间
     * 
     * @return string
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getAllStaffOrders($param){
        $cacheKey = md5(json_encode($param));
        $staffOrders = cache('allStaffOrders_'.$cacheKey);
        if (!$staffOrders) {
            $where['c.is_status'] = 1;
            $where['c.c_from'] = 1;
            if ($param['shop_code']) {
                $shop_code = '';
                foreach ($param['shop_code'] as $key => $value) {
                    $shop_code .= $value.',';
                }
                $shop_code = trim($shop_code,',');
                $where['c.shop_code'] = ['in', $shop_code];
            }
            $staffOrders = db('c_customerinfo')->alias('c')
                ->where($where)
                ->where('c.order_day', 'between time', [$param['start'], $param['end']])
                ->where('c.sales_staff_id','>',0)
                ->group('c.sales_staff')
                ->order('orderNum desc')
                ->column('count(c.id) as orderNum,c.sales_staff,c.sales_staff_id', 'c.sales_staff');
            // echo db()->getLastSql();die;
            if ($staffOrders) {
                cache('allStaffOrders_'.$cacheKey, $staffOrders, 60);
            }
        }
        return $staffOrders;
    }
    /**
     *  网销员工订单实收
     * 
     * @param  shop_code[]   shop_code数组
     * @param  start         开始时间
     * @param  end           结束时间
     * 
     * @return string
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getAllStaffFactMoney($param){
        $cacheKey = md5(json_encode($param));
        $staffFactMoney = cache('allStaffFactMoney_'.$cacheKey);
        if (!$staffFactMoney) {
            $where['c.is_status'] = 1;
            $where['c.c_from'] = 1;
            if ($param['shop_code']) {
                $shop_code = '';
                foreach ($param['shop_code'] as $key => $value) {
                    $shop_code .= $value.',';
                }
                $shop_code = trim($shop_code,',');
                $where['c.shop_code'] = ['in', $shop_code];
            }
            $staffFactMoney = db('c_customerinfo')->alias('c')
                ->where($where)
                ->where('c.order_day', 'between time', [$param['start'], $param['end']])
                ->where('c.sales_staff_id','>',0)
                ->group('c.sales_staff')
                ->order('factMoney desc')
                ->column('sum(c.fact_money) as factMoney,c.sales_staff,c.sales_staff_id', 'c.sales_staff');
            // echo db()->getLastSql();die;
            if ($staffFactMoney) {
                cache('allStaffFactMoney_'.$cacheKey, $staffFactMoney, 60);
            }
        }
        return $staffFactMoney;
    }
    //-------------------------- 小组 --------------------------//
    /**
     *  网销小组客资数量
     * 
     * @param  shop_code[]   shop_code数组
     * @param  department    部门信息
     * @param  start         开始时间
     * @param  end           结束时间
     * 
     * @return string
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getAllGroupCus($param){
        $cacheKey = md5(json_encode($param));
        $groupCus = cache('allGroupCus_'.$cacheKey);
        if (!$groupCus) {
            $where['c.is_status'] = 1;
            $where['c.c_from'] = 1;
            if ($param['shop_code']) {
                $shop_code = '';
                foreach ($param['shop_code'] as $key => $value) {
                    $shop_code .= $value.',';
                }
                $shop_code = trim($shop_code,',');
                $where['c.shop_code'] = ['in', $shop_code];
            }
            if ($param['gids']) {
                $where['f.sales_group_id'] = ['in',$param['gids']];
            }else{
                $where['f.sales_group_id'] = ['>',0];
            }
            $groupCus = db('c_customerinfo')->alias('c')
                ->join('c_customer_from f', 'f.cid=c.id','left')
                ->where($where)
                ->where('c.dj_day', 'between time', [$param['start'], $param['end']])
                ->group('f.sales_group_name')
                ->order('cusNum desc')
                ->column('count(c.id) as cusNum,f.sales_group_name', 'f.sales_group_id');
            // echo db()->getLastSql();die;
            if ($groupCus) {
                cache('allGroupCus_'.$cacheKey, $groupCus, 60);
            }
        }
        return $groupCus;
    }
    /**
     *  网销小组订单数量
     * 
     * @param  shop_code[]   shop_code数组
     * @param  department    部门信息
     * @param  start         开始时间
     * @param  end           结束时间
     * 
     * @return string
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getAllGroupOrders($param){
        $cacheKey = md5(json_encode($param));
        $groupOrders = cache('allGroupOrders_'.$cacheKey);
        if (!$groupOrders) {
            $where['c.is_status'] = 1;
            $where['c.c_from'] = 1;
            if ($param['shop_code']) {
                $shop_code = '';
                foreach ($param['shop_code'] as $key => $value) {
                    $shop_code .= $value.',';
                }
                $shop_code = trim($shop_code,',');
                $where['c.shop_code'] = ['in', $shop_code];
            }
            if ($param['gids']) {
                $where['f.sales_group_id'] = ['in',$param['gids']];
            }else{
                $where['f.sales_group_id'] = ['>',0];
            }
            $groupOrders = db('c_customerinfo')->alias('c')
                ->join('c_customer_from f', 'f.cid=c.id','left')
                ->where($where)
                ->where('c.order_day', 'between time', [$param['start'], $param['end']])
                ->group('f.sales_group_name')
                ->order('orderNum desc')
                ->column('count(c.id) as orderNum,f.sales_group_name', 'f.sales_group_id');
            // echo db()->getLastSql();die;
            if ($groupOrders) {
                cache('allGroupOrders_'.$cacheKey, $groupOrders, 60);
            }
        }
        return $groupOrders;
    }
    /**
     *  网销小组订单实收
     * 
     * @param  shop_code[]   shop_code数组
     * @param  department    部门信息
     * @param  start         开始时间
     * @param  end           结束时间
     * 
     * @return string
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getAllGroupFactMoney($param){
        $cacheKey = md5(json_encode($param));
        $groupFactMoney = cache('allGroupFactMoney_'.$cacheKey);
        if (!$groupFactMoney) {
            $where['c.is_status'] = 1;
            $where['c.c_from'] = 1;
            if ($param['shop_code']) {
                $shop_code = '';
                foreach ($param['shop_code'] as $key => $value) {
                    $shop_code .= $value.',';
                }
                $shop_code = trim($shop_code,',');
                $where['c.shop_code'] = ['in', $shop_code];
            }
            if ($param['gids']) {
                $where['f.sales_group_id'] = ['in',$param['gids']];
            }else{
                $where['f.sales_group_id'] = ['>',0];
            }
            $groupFactMoney = db('c_customerinfo')->alias('c')
                ->join('c_customer_from f', 'f.cid=c.id','left')
                ->where($where)
                ->where('c.order_day', 'between time', [$param['start'], $param['end']])
                ->group('f.sales_group_name')
                ->order('factMoney desc')
                ->column('sum(c.fact_money) as factMoney,f.sales_group_name', 'f.sales_group_id');
            // echo db()->getLastSql();die;
            if ($groupFactMoney) {
                cache('allGroupFactMoney_'.$cacheKey, $groupFactMoney, 60);
            }
        }
        return $groupFactMoney;
    }
}