<?php
/**
 * 报表实现类 电商渠道数据统计
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: wangzhenya 2018-06-12 $
 */
namespace app\crm\lib\report;
use app\crm\lib\Report;
use think\Controller;
use think\image\Exception;

class Ds_channel extends Report {

    private $level=1;
    private $type=1;
    private $code='code1541159433';

    public function getLevel(){
        return $this->level;

    }
    public function getType(){
        return $this->type;
    }
    public function getCode(){
        return $this->code;
    }
    public function data()
    {
        set_time_limit(0);
        $data = input();
        $det = db('s_report_form')->alias('f')->join('s_report_detail d','d.form_id=f.id')->where('d.id',$data['did'])->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name,f.report_name')->find();
        $shop_code = $det['shop_code'] ? $det['shop_code'] :session('shop_code');
        if(empty($shop_code)){
            return array('code'=>100,'msg'=>'报表配置有误');
        }
        $start = $data['start'] ? date('Y-m-d', strtotime($data['start'])) : date('Y-m-d 00:00:00');
        $end =  $data['end'] ? date('Y-m-d 23:59:59', strtotime($data['end'])) : date('Y-m-d 23:59:59');
        $method = $data['method'];
        // 来源渠道
        $channels = db('s_channel')->where('shop_code', $shop_code)->order('order_sort')->select();
        $channelIds = array_column($channels,'id');
        $channelName = array_column($channels,'channel_name');
        $where['is_status'] = 1;
        $where['c_from'] = 1;
        $where['add_shop_code'] = $shop_code;
        // 地域id，拼接where条件
        if ($data['province_id']) {
            $where['province_id'] = (int)$data['province_id'];
        }
        if ($data['city_id']) {
            $where['city_id'] = (int)$data['city_id'];
        }
        $date = 'dj_day';
        if($method == 'valid'){
            $where['is_valid'] = 1;
        }elseif($method == 'unvalid'){
            $where['is_valid'] = 3;
        }elseif($method == 'dd'){
           $where['is_valid'] = 2;
        }elseif($method == 'bh'){
           $where['is_valid'] = 4;
        }elseif($method == 'bh'){
           $where['is_valid'] = 4;
        }elseif($method == 'yy'){//邀约
            $date = 'yjd_day';
        }elseif($method == 'jd'){//进店
            $date = 'syjd_day';
        }elseif($method == 'order'){//订单
            $where['is_success'] = 1;
            $date = 'order_day';
        }
        if($method == 'cost'){
            $whereCost['shop_code'] = $shop_code;
            $info = db('s_channel_cost')
                ->where($whereCost)
                ->where('channel_id', 'in',$channelIds)
                ->where('cost_date', 'between time', [$start, $end])
                ->group('channel_id')
                ->column('sum(cost) num','channel_id');
        }elseif($method == 'jd'){
            $info = db('c_customerinfo')
                ->where($where)
                ->where('is_intostore','in',[2,3])
                ->where('customer_channel_id', 'in',$channelIds)
                ->where($date, 'between time', [$start, $end])
                ->group('customer_channel_id')
                ->column('count(*) num','customer_channel_id');
        }else{
            $info = db('c_customerinfo')
                ->where($where)
                ->where('customer_channel_id', 'in',$channelIds)
                ->where($date, 'between time', [$start, $end])
                ->group('customer_channel_id')
                ->column('count(*) num','customer_channel_id');
        }
        $return = [];
        $return['channel'] = $channelName;
        foreach($channels as $k=>$v){
            $arr = [];
            $arr['value'] = $info[$v['id']] ? intval($info[$v['id']]) : 0;
            $arr['name'] = $v['channel_name'];
            $return['value'][] = $arr;
        }

        return json(array('code' =>200,'title'=>$det['report_name'] ,'shop'=>$channels[0]['shop_name'],'channel' => $return['channel'], 'value' => $return['value']));

    }

    public function show(){
        $code = $this->getCode();
        $did = strtolower(input('param.did'));
        $info = db('s_report_form')->alias('f')->join('s_report_detail d','d.form_id=f.id')->where('d.id',$did)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();

        $display = APP_PATH.'crm'.DS.'view'.DS.'report'.DS.strtolower($info['report_class_name']).'.html';
        $title = db('s_report_form')->where('code', $code)->value('report_name');
        $shop= controller('crm/Customer','lib')->get_shop(['shop_code'=>$info['shop_code']]);

        $this->assign('shop', $shop);
        // crm省    列表
        $data['type'] = 1;
        $data['shop_code'] = $info['shop_code'];
        $province = controller("Customer", "lib")->address($data);
        $this->assign('province', $province);
        $this->assign('title', $shop[0]['shop_name'].'-'.$title);
        $this->assign('did', $info['id']);
        return $this->fetch($display);
    }

}