<?php
/**
 * 报表实现类 小组数据统计
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: lilong/wangzhenya 2018-05-29 $
 */
namespace app\crm\lib\report;
use app\crm\lib\Report;
use think\Controller;
use think\image\Exception;

class Jj_group extends Report {

    private $level=1;
    private $type=3;
    private $code='code1533561172';

    public function getLevel(){
        return $this->level;

    }
    public function getType(){
        return $this->type;
    }
    public function getCode(){
        return $this->code;
    }
    public function data()
    {
        set_time_limit(0);
        // 权限
        $auth = check_right('menu1521352658');
        if (!$auth) {
            $return = ['code' => 0, 'msg' => '', 'count' => 0, 'data' => ''];
            return json($return);
        }
        $data = input();

        $det = db('s_report_form')->alias('f')->join('s_report_detail d','d.form_id=f.id')->where('d.id',$data['did'])->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();
        $shopCode = $det['shop_code'];
        if(empty($shopCode)){
            return array('code'=>100,'msg'=>'报表配置有误');
        }

        if($data['group_id']){
            $groupList = db('c_staff_group')->where('id', $data['group_id'])->select();
        }else{
            //获取店下的小组
            $groupList = db('c_staff_group')->where('shop_code', $shopCode)->select();
        }


        // 时间区域
        $start = date('Y-m-d', strtotime($data['start']));
        $end = date('Y-m-d 23:59:59', strtotime($data['end']));
        $where['c.is_status'] = 1;
        $where['c.c_from'] = 1;

        $where['c.shop_code'] = $shopCode;

        $total = [];//最后总计
        $returnData = [];
        $i = 1;
        $time = getDates($start,$end);
        foreach($groupList as $k=>$v){
            $sql = 'DATE_FORMAT(dj_day,"%Y-%m-%d") days,';
            $sql .= "sum(dj_day between '$start' and '$end') as mkz,";
            $sql .= "sum(is_valid=1 and dj_day between '$start' and '$end') as valid,";//有效
            $sql .= "sum(is_valid=2 and dj_day between '$start' and '$end') as dd,";//待定
            $sql .= "sum(is_valid in('3','4','5') and dj_day between '$start' and '$end') as wx,";//无效
            $sql .= "sum(fact_money>0 and order_start_time between '$start' and '$end') as `order`,";//成交
            $sql .= "sum(fact_money>0 and customer_channel<>'官方抖音' and customer_channel<>'官方快手' and order_start_time between '$start' and '$end') as zyOrder";//资源订单：收款大于0，排程抖音，快手
            $info= db('c_customerinfo c')->join('c_customer_from f','c.id=f.cid','left')
                ->where($where)
                ->where('sales_group_id',$v['id'])
                ->group('days')
                ->column($sql);
            $groupTotal = [];//小组总计
            foreach($time as $kk=>$vv){
                $arr = [];
                $arr['id'] = $i;
                $arr['group_name'] = $v['group_name'];
                $arr['date'] = $vv;
                $arr['mkz'] = $info[$vv]['mkz'];
                $arr['valid'] = $info[$vv]['valid'];
                $arr['dd'] = $info[$vv]['dd'];
                $arr['wx'] = $info[$vv]['wx'];
                $arr['order'] = $info[$vv]['order'];
                $arr['zyOrder'] = $info[$vv]['zyOrder'];
                $arr['zyOrderRate'] = $info[$vv]['zyOrder']?sprintf('%.2f',$info[$vv]['zyOrder']/($arr['valid']+$arr['dd'])*100).'%': '';
                $arr['validOrderRate'] = $info[$vv]['zyOrder']?sprintf('%.2f',$info[$vv]['zyOrder']/($arr['valid'])*100).'%': '';
                $arr['allZyOrderRate'] = $info[$vv]['zyOrder']?sprintf('%.2f',$info[$vv]['zyOrder']/($arr['mkz'])*100).'%': '';
                $arr['orderRate'] = $info[$vv]['order']?sprintf('%.2f',$info[$vv]['order']/($arr['valid']+$arr['dd'])*100).'%': '';
                $arr['allOrderRate'] = $info[$vv]['order']?sprintf('%.2f',$info[$vv]['order']/($arr['mkz'])*100).'%': '';

                $returnData[] = $arr;
                //小组总计
                $groupTotal['group_name'] = '小组总计';
                $groupTotal['date'] = '';
                $groupTotal['mkz'] += $info[$vv]['mkz'];
                $groupTotal['valid'] += $info[$vv]['valid'];
                $groupTotal['dd'] += $info[$vv]['dd'];
                $groupTotal['wx'] += $info[$vv]['wx'];
                $groupTotal['order'] += $info[$vv]['order'];
                $groupTotal['zyOrder'] += $info[$vv]['zyOrder'];
                //最后总计
                $total['group_name'] = '总计';
                $total['date'] = '';
                $total['mkz'] += $info[$vv]['mkz'];
                $total['valid'] += $info[$vv]['valid'];
                $total['dd'] += $info[$vv]['dd'];
                $total['wx'] += $info[$vv]['wx'];
                $total['order'] += $info[$vv]['order'];
                $total['zyOrder'] += $info[$vv]['zyOrder'];
                $i++;
            }
            $groupTotal['zyOrderRate'] = $groupTotal['zyOrder']?sprintf('%.2f',$groupTotal['zyOrder']/($groupTotal['valid']+$groupTotal['dd'])*100).'%': '';
            $groupTotal['validOrderRate'] = $groupTotal['zyOrder']?sprintf('%.2f',$groupTotal['zyOrder']/($groupTotal['valid'])*100).'%': '';
            $groupTotal['allZyOrderRate'] = $groupTotal['zyOrder']?sprintf('%.2f',$groupTotal['zyOrder']/($groupTotal['mkz'])*100).'%': '';
            $groupTotal['orderRate'] = $groupTotal['order']?sprintf('%.2f',$groupTotal['order']/($groupTotal['valid']+$groupTotal['dd'])*100).'%': '';
            $groupTotal['allOrderRate'] = $groupTotal['order']?sprintf('%.2f',$groupTotal['order']/($groupTotal['mkz'])*100).'%': '';
            $returnData[] = $groupTotal;
        }
        $total['zyOrderRate'] = $total['zyOrder']?sprintf('%.2f',$total['zyOrder']/($total['valid']+$total['dd'])*100).'%': '';
        $total['validOrderRate'] = $total['zyOrder']?sprintf('%.2f',$total['zyOrder']/($total['valid'])*100).'%': '';
        $total['allZyOrderRate'] = $total['zyOrder']?sprintf('%.2f',$total['zyOrder']/($total['mkz'])*100).'%': '';
        $total['orderRate'] = $total['order']?sprintf('%.2f',$total['order']/($total['valid']+$total['dd'])*100).'%': '';
        $total['allOrderRate'] = $total['order']?sprintf('%.2f',$total['order']/($total['mkz'])*100).'%': '';
        $returnData[] = $total;

        $return['code'] = 0;
        $return['msg'] = '';
        $return['count'] = count($returnData);
        $return['data'] = $returnData;
        return json($return);
    }

    public function show(){
        $code = $this->getCode();
        $did = strtolower(input('param.did'));
        $info = db('s_report_form')->alias('f')->join('s_report_detail d','d.form_id=f.id')->where('d.id',$did)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();
        $shop= controller('crm/Customer','lib')->get_shop(['shop_code'=>$info['shop_code']]);
        //获取店下的小组
        $group = db('c_staff_group')->where('shop_code', $info['shop_code'])->select();
        $this->assign('group', $group);
        $display = APP_PATH.'crm'.DS.'view'.DS.'report'.DS.strtolower($info['report_class_name']).'.html';
        $title = db('s_report_form')->where('code', $code)->value('report_name');
        $this->assign('title', $shop[0]['shop_name'].'-'.$title);
        $this->assign('did', $info['id']);
        return $this->fetch($display);
    }

}