<?php
/**
 * 报表实现类 网销个人业绩报表
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: lilong/wangzhenya 2018-05-29 $
 */
namespace app\crm\lib\report;
use app\crm\lib\Report;
use think\Controller;
use think\image\Exception;

class Jj_personal_data extends Report {

    private $level=1;
    private $type=1;
    private $code='code1545299286';

    public function getLevel(){
        return $this->level;

    }
    public function getType(){
        return $this->type;
    }
    public function getCode(){
        return $this->code;
    }
    public function data()
    {
        set_time_limit(0);

        $data = input();


        $det = db('s_report_form')->alias('f')->join('s_report_detail d','d.form_id=f.id')->where('d.id',$data['did'])->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();
        $shop_code = $det['shop_code'];
        if(empty($shop_code)){
            return array('code'=>100,'msg'=>'报表配置有误');
        }
        if(!check_right('menu1512637269')){
            if(!$data['sales_staff_id']){
                return array('code'=>105,'msg'=>'没有查看所有客资权限，不能查看全部');
            }
            if(session('staff_id') != $data['sales_staff_id']){
                return array('code'=>105,'msg'=>'没有查看所有客资权限，不能查看别人客资');
            }
        }else{
            if(!$data['sales_staff_id']){
                $staff = controller('crm/Customer','lib')->get_staff_lists(['shop_code'=>$shop_code]);
            }else{
                $staff = controller('crm/Customer','lib')->get_staff_list(['id'=>$data['sales_staff_id']]);
            }
        }
        $where['is_status'] = 1;
        $where['c_from'] = 1;
        $where['shop_code'] = $shop_code;

        if($data['sales_staff_id']){
            $where['sales_staff_id'] = trim($data['sales_staff_id']);
        }
        $start = $data['start'] ? date('Y-m-d', strtotime($data['start'])) : date('Y-m-d 00:00:00');
        $end =  $data['end'] ? date('Y-m-d 23:59:59', strtotime($data['end'])) : date('Y-m-d 23:59:59');

        $sql = 'sum(jr_day between "'.$start.'" and "'.$end.'") as jr,';
        $sql .= 'sum(is_valid=1 and yx_day between "'.$start.'" and "'.$end.'") as valid,';
        $sql .= 'sum(is_valid=3 and yx_day between "'.$start.'" and "'.$end.'") as wx,';
        $sql .= 'sum(is_valid=2 and yx_day between "'.$start.'" and "'.$end.'") as dd';
        $info = db('c_customerinfo')
            ->where($where)
            ->group('sales_staff_id')
            ->column($sql, 'sales_staff_id');

        $tel = db('c_salestrackinginfo')
            ->where('sales_day','between',[$start,$end])
            ->group('sales_staff_id')
            ->column('count(id)as num','sales_staff_id');


        $returnData = [];
        $arr = [];
        $px = [];
        $px['sales_staff'] = '总计';
        foreach($staff as $k=>$v){
            $arr['sales_staff_id'] = $v['id'];
            $arr['sales_staff'] = $v['staffname'];
            $arr['jr'] = $info[$v['id']]['jr'] ? $info[$v['id']]['jr'] : '';
            $arr['valid'] = $info[$v['id']]['valid'] ? $info[$v['id']]['valid'] : '';
            $arr['wx'] = $info[$v['id']]['wx'] ? $info[$v['id']]['wx'] : '';
            $arr['dd'] = $info[$v['id']]['dd'] ? $info[$v['id']]['dd'] : '';
            $arr['tel'] = $tel[$v['id']] ? $tel[$v['id']] : '';

            array_push($returnData,$arr);
            $px['jr'] += $arr['jr'];
            $px['valid'] += $arr['valid'];
            $px['wx'] += $arr['wx'];
            $px['dd'] += $arr['dd'];
            $px['tel'] += $arr['tel'];
        }

        array_push($returnData,$px);

        // 导出
        if ($data['need'] == 1) {
            $title = ['追踪人','接入客资','有效', '无效','待定','电话量'];
            $code = $this->getCode();
            $ff = db('s_report_form')->where('code', $code)->value('report_name');
            $shop = controller('crm/Customer','lib')->get_shop(['shop_code'=>$shop_code]);
            $file = $shop[0]['shop_name'].'-'.$ff.'.xlsx';
            foreach ($returnData as $k=>$v) {
                unset($returnData[$k]['sales_staff_id']);
            }
            controller("crm/Customer", "lib")->export($title, $returnData, $file);
        }else {
            $return['code'] = 0;
            $return['msg'] = '';
            $return['data'] = $returnData;
            $return['count'] = count($returnData);
            return json($return);
        }
    }

    public function show(){
        $code = $this->getCode();
        $did = strtolower(input('param.did'));
        $info = db('s_report_form')->alias('f')->join('s_report_detail d','d.form_id=f.id')->where('d.id',$did)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();
        $staff = controller('crm/Customer','lib')->get_staff_lists(['shop_code'=>$info['shop_code']]);
        if(!check_right('menu1512637269')){//如果没有查看所有客资权限，则只能查看自己的业绩
            foreach($staff as $k=>$v){
                if(session('staff_id') != $v['id']){
                    unset($staff[$k]);
                }
            }
        }
        $this->assign('staff',$staff);

        $display = APP_PATH.'crm'.DS.'view'.DS.'report'.DS.strtolower($info['report_class_name']).'.html';
        $title = db('s_report_form')->where('code', $code)->value('report_name');
        $this->assign('shop_code', $info['shop_code']);
        $this->assign('title', $title);
        $this->assign('did', $info['id']);
        return $this->fetch($display);
    }

}