<?php
/**
 * 报表实现类 网销客资分析
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: wangzhenya 2018-06-12 $
 */
namespace app\crm\lib\report;
use app\crm\lib\Report;
use think\Controller;
use think\image\Exception;

class Qqbaby_wx_data extends Report {

    private $level=1;
    private $type=3;
    private $code='code1544506169';

    public function getLevel(){
        return $this->level;

    }
    public function getType(){
        return $this->type;
    }
    public function getCode(){
        return $this->code;
    }
    public function data()
    {
        set_time_limit(0);
        $data = input();
        $det = db('s_report_form')->alias('f')->join('s_report_detail d','d.form_id=f.id')->where('d.id',$data['did'])->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name,f.report_name')->find();
        $shop_code = $det['shop_code'];
        if(empty($shop_code)){
            return array('code'=>100,'msg'=>'报表配置有误');
        }
        $start = $data['start'] ? date('Y-m-d', strtotime($data['start'])) : date('Y-m-d 00:00:00');
        $end =  $data['end'] ? date('Y-m-d 23:59:59', strtotime($data['end'])) : date('Y-m-d 23:59:59');
        $flag = $data['flag'];

        $where['c_from'] = 1;
        $where['is_status'] = 1;
        $where['shop_code'] = $shop_code;
        $shopinfo = controller('crm/Customer','lib')->get_shop(['shop_code'=>$shop_code]);
        // 地域id，拼接where条件
        if ($data['province_id']) {
            $where['province_id'] = (int)$data['province_id'];
        }
        if ($data['city_id']) {
            $where['city_id'] = (int)$data['city_id'];
        }
        $return = [];
        $info = [];
        $list = [];
        if($flag == 'channel'){//客资渠道分析
            $info = db('c_customerinfo')
                ->where($where)
                ->where('dj_day', 'between time', [$start, $end])
                ->group('customer_channel')
                ->column('count(*) num','customer_channel');
        }elseif($flag == 'succChannel'){//渠道成交分析
            $info = db('c_customerinfo')
                ->where($where)
                ->where('is_success',1)
                ->where('order_day', 'between time', [$start, $end])
                ->group('customer_channel')
                ->column('count(*) num','customer_channel');
        }elseif($flag == 'type'){//消费类型分析
            $info = db('c_customerinfo')
                ->where($where)
                ->where('dj_day', 'between time', [$start, $end])
                ->group('consultation_type')
                ->column('count(*) num','consultation_type');
        }elseif($flag == 'succType'){//成交类型
            $info = db('c_customerinfo')
                ->where($where)
                ->where('is_success',1)
                ->where('order_day', 'between time', [$start, $end])
                ->group('consultation_type')
                ->column('count(*) num','consultation_type');
        }elseif($flag == 'intoSucc'){//进店成交分析
            $info = db('c_customerinfo')
                ->where($where)
                ->where('is_intostore','in',[2,3])
                ->where('order_day', 'between time', [$start, $end])
                ->group('consulation_shop')
                ->column('count(*) num','consulation_shop');
        }elseif($flag == 'is_loss'){//不再追踪分析
            $info = db('c_customerinfo')
                ->where($where)
                ->where('is_loss',1)
                ->where('loss_day', 'between time', [$start, $end])
                ->group('loss_cause')
                ->column('count(*) num','loss_cause');
        }elseif($flag == 'erp_loss'){//流失分析
            $info = db('c_customerinfo')
                ->where($where)
                ->where('erp_loss',2)
                ->where('erp_loss_time', 'between time', [$start, $end])
                ->group('erp_loss_reason')
                ->column('count(*) num','erp_loss_reason');
        }
        foreach($info as $k=>$v){
            $arr = [];
            $arr['value'] = $v ? $v : 0;
            $arr['name'] = $k ? $k : '未填写';
            $return['value'][] = $arr;
            if(empty($k)){
                $list[] = '未填写';
            }else{
                $list[] = $k;
            }
        }
        if(empty($info)){
            return json(array('code'=>100,'msg'=>'暂无数据'));
        }
        return json(array('code' =>200,'shop'=>$shopinfo[0]['shop_name'],'list' => $list, 'value' => $return['value']));

    }

    public function show(){
        $code = $this->getCode();
        $did = strtolower(input('param.did'));
        $info = db('s_report_form')->alias('f')->join('s_report_detail d','d.form_id=f.id')->where('d.id',$did)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();

        $display = APP_PATH.'crm'.DS.'view'.DS.'report'.DS.strtolower($info['report_class_name']).'.html';
        $title = db('s_report_form')->where('code', $code)->value('report_name');
        $shop= controller('crm/Customer','lib')->get_shop(['shop_code'=>$info['shop_code']]);

        $this->assign('shop', $shop);
        // crm省    列表
        $data['type'] = 1;
        $data['shop_code'] = $info['shop_code'];
        $province = controller("Customer", "lib")->address($data);
        $this->assign('province', $province);

        $this->assign('title', $shop[0]['shop_name'].'-'.$title);
        $this->assign('did', $info['id']);
        return $this->fetch($display);
    }

}